---
stage: AI-powered
group: Custom Models
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Configure your GitLab instance to use GitLab Duo Self-Hosted.
title: Configure GitLab to access GitLab Duo Self-Hosted
---

{{< details >}}

- Tier: Premium, Ultimate
- Add-on: GitLab Duo Enterprise
- Offering: GitLab Self-Managed

{{< /details >}}

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/12972) in GitLab 17.1 [with a flag](../feature_flags/_index.md) named `ai_custom_model`. Disabled by default.
- [Enabled on GitLab Self-Managed](https://gitlab.com/groups/gitlab-org/-/epics/15176) in GitLab 17.6.
- Changed to require GitLab Duo add-on in GitLab 17.6 and later.
- Feature flag `ai_custom_model` removed in GitLab 17.8
- Ability to set AI Gateway URL using UI [added](https://gitlab.com/gitlab-org/gitlab/-/issues/473143) in GitLab 17.9.
- Generally available in GitLab 17.9.
- Changed to include Premium in GitLab 18.0.

{{< /history >}}

Prerequisites:

- [Upgrade GitLab to version 17.9 or later](../../update/_index.md).
- You must be an administrator.

To configure your GitLab instance to access the available self-hosted models in your infrastructure:

1. [Confirm that a fully self-hosted configuration is appropriate for your use case](_index.md#ai-gateway-configurations).
1. Configure your GitLab instance to access the AI Gateway.
1. In GitLab 18.4 and later, configure your GitLab instance to access the GitLab Duo Agent Platform service.
1. Configure the self-hosted model.
1. Configure the GitLab Duo features to use your self-hosted model.

## Configure access to the local AI Gateway

To configure access between your GitLab instance and your local AI Gateway:

1. In the upper-right corner, select **Admin**.
1. In the left sidebar, select **GitLab Duo**.
1. Select **Change configuration**.
1. Under **Local AI Gateway URL**, enter your AI Gateway URL.
1. Select **Save changes**.

> [!note]
> If your AI Gateway URL points to a local network or private IP address (for example, `172.31.x.x` or internal hostnames like `ip-172-xx-xx-xx.region.compute.internal`), GitLab might block the request for security reasons. To allow requests to this address, [add the address to the IP allowlist](../../security/webhooks.md#allow-outbound-requests-to-certain-ip-addresses-and-domains).

## Configure timeout for the AI Gateway

{{< history >}}

- [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/567878) in GitLab 18.7.

{{< /history >}}

To conserve resources and prevent long-running queries, configure the timeout for GitLab requests to the AI Gateway when waiting for model responses.
Use longer timeouts for self-hosted models with large context windows or complex queries.

You can configure a timeout between 60 and 600 seconds (10 minutes). If you don't set the timeout, GitLab uses the default timeout of 60 seconds.

To configure the AI Gateway timeout:

1. In the upper-right corner, select **Admin**.
1. In the left sidebar, select **GitLab Duo**.
1. Select **Change configuration**.
1. Under **AI Gateway request timeout**, enter the timeout value in seconds (between 60 and 600).
1. Select **Save changes**.

### Determine the timeout value

The timeout value depends on your specific deployment and use case.

To determine the timeout value:

- Start with the default timeout of 60 seconds and monitor for timeout errors.
- Monitor your logs for `A1000` timeout errors in your logs. If these errors occur frequently, consider increasing the timeout.
- Consider your use case. Larger prompts, complex code generation tasks, or processing large design documents might require longer timeouts.
- Consider your infrastructure. Model performance depends on available GPU resources, network latency between the AI Gateway and model endpoint, and the model's processing capabilities.
- Increase incrementally. If you experience timeouts, increase the value gradually (for example, by 30-60 seconds) and monitor the results.

For more information on troubleshooting timeout errors, see [Error A1000](troubleshooting.md#error-a1000).

## Configure access to the GitLab Duo Agent Platform

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/19213) in GitLab 18.4, as an [experiment](../../policy/development_stages_support.md#experiment) with a [feature flag](../feature_flags/_index.md) named `self_hosted_agent_platform`. Disabled by default.
- [Changed](https://gitlab.com/gitlab-org/gitlab/-/issues/558083) from experiment to beta in GitLab 18.5.
- [Enabled](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208951) in GitLab 18.7.
- [Generally available](https://gitlab.com/groups/gitlab-org/-/work_items/19125) in GitLab 18.8.
- Feature flag `self_hosted_agent_platform` [removed](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/218589) in GitLab 18.9.

{{< /history >}}

Prerequisites:

- Self-hosted beta models and features are [turned on](#turn-on-self-hosted-beta-models-and-features).
- If your instance has an offline license, you must have the [GitLab Duo Agent Platform Self-Hosted](../../subscriptions/subscription-add-ons.md) add-on.

To access the Agent Platform service from your GitLab instance:

1. In the upper-right corner, select **Admin**.
1. In the left sidebar, select **GitLab Duo**.
1. Select **Change configuration**.
1. Under **Local URL for the GitLab Duo Agent Platform service**, enter the URL for the local Agent Platform service.
   - The URL is typically the same as the **Local AI Gateway URL** but on gRPC port :50052.
   - Do not include a URL prefix such as `http://` or `https://`.

   - If the URL is not set up with TLS, you must set the `DUO_AGENT_PLATFORM_SERVICE_SECURE` environment variable in your GitLab instance:

     - For Linux package installations, in `gitlab_rails['env']`, set `'DUO_AGENT_PLATFORM_SERVICE_SECURE' => false`
     - For self-compiled installations, in `/etc/default/gitlab` set `export DUO_AGENT_PLATFORM_SERVICE_SECURE=false`
1. Select **Save changes**.

## Add a self-hosted model

You must add a self-hosted model to your GitLab instance to use it with GitLab Duo features.

To add a self-hosted model:

1. In the upper-right corner, select **Admin**.
1. In the left sidebar, select **GitLab Duo**.
1. Select **Configure GitLab Duo Self-Hosted**.
   - If **Configure GitLab Duo Self-Hosted** is not available, synchronize your
     subscription after purchase:
     1. In the left sidebar, select **Subscription**.
     1. In **Subscription details**, to the right of **Last sync**, select
        synchronize subscription ({{< icon name="retry" >}}).
1. Select **Add self-hosted model**.
1. Complete the fields:
   - **Deployment name**: Enter a name to uniquely identify the model deployment, for example, `Mixtral-8x7B-it-v0.1 on GCP`.
   - **Model family**: Select the model family the deployment belongs to. You can select either a supported or compatible model.
   - **Endpoint**: Enter the URL where the model is hosted.
   - **API key**: Optional. Add an API key if you need one to access the model.
   - **Model identifier**: Enter the model identifier based on your deployment method. The model identifier should match the following format:

     | Deployment method | Format | Example |
     |-------------|---------|---------|
     | [vLLM](supported_llm_serving_platforms.md#find-the-model-name)        | `custom_openai/<name of the model served through vLLM>` | `custom_openai/Mixtral-8x7B-Instruct-v0.1` |
     | [Amazon Bedrock](#set-the-model-identifier-for-amazon-bedrock-models) | `bedrock/<model ID of the model>`                       | `bedrock/mistral.mixtral-8x7b-instruct-v0:1` |
     | Azure OpenAI                                                          | `azure/<model ID of the model>`                         | `azure/gpt-35-turbo` |

1. Select **Add self-hosted model**.

### Set the model identifier for Amazon Bedrock models

To set a model identifier for an Amazon Bedrock model:

1. Set your `AWS_REGION`. Ensure you have access to models in that region in your AI Gateway Docker configuration.
1. Add the region prefix to the model's inference profile ID for cross-region inferencing.
1. Use the `bedrock/` prefix region as the prefix for the model identifier.

   For example, for the Anthropic Claude 4.0 model in the Tokyo region:

   - The `AWS_REGION` is `ap-northeast-1`.
   - The cross-region inferencing prefix is `apac.`.
   - The model identifier is `bedrock/apac.anthropic.claude-sonnet-4-20250514-v1:0`.

Some regions are not supported by cross-region inferencing. For these regions, do not specify a region prefix in the model identifier. For example:

- The `AWS_REGION` is `eu-west-2`.
- The model identifier is `anthropic.claude-sonnet-4-5-20250929-v1:0`.

## Turn on self-hosted beta models and features

> [!note]
> Turning on beta self-hosted models and features also accepts the [GitLab Testing Agreement](https://handbook.gitlab.com/handbook/legal/testing-agreement/).

To enable self-hosted beta models and features:

1. In the upper-right corner, select **Admin**.
1. In the left sidebar, select **GitLab Duo**.
1. Select **Change configuration**.
1. Under **Self-hosted beta models and features**, select the **Use beta models and features in GitLab Duo Self-Hosted** checkbox.
1. Select **Save changes**.

## Configure GitLab Duo features to use self-hosted models

### View configured features

1. In the upper-right corner, select **Admin**.
1. In the left sidebar, select **GitLab Duo**.
1. Select **Configure GitLab Duo Self-Hosted**.
   - If **Configure GitLab Duo Self-Hosted** is not available, synchronize your
     subscription after purchase:
     1. In the left sidebar, select **Subscription**.
     1. In **Subscription details**, to the right of **Last sync**, select
        synchronize subscription ({{< icon name="retry" >}}).
1. Select the **AI-native features** tab.

### Configure a feature to use a self-hosted model

Configure a GitLab Duo feature and sub-feature to send queries to the self-hosted model:

1. In the upper-right corner, select **Admin**.
1. In the left sidebar, select **GitLab Duo**.
1. Select **Configure GitLab Duo Self-Hosted**.
1. Select the **AI-native features** tab.
1. For the feature and sub-feature you want to configure, from the dropdown list, choose the self-hosted model you want to use.

   For example, for the code generation, you can select **Claude-3 on Bedrock deployment (Claude 3)**.

   ![GitLab Duo Self-Hosted Feature Configuration](img/gitlab_duo_self_hosted_feature_configuration_v17_11.png)

> [!note]
> If you don't specify a model for a GitLab Duo Chat sub-feature, it automatically uses the model configured for **General Chat**.
> This ensures all Chat functionality works without requiring individual model configuration for each sub-feature.

### Configure a feature to use a GitLab AI vendor model

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/17192) in GitLab 18.3, as a [beta](../../policy/development_stages_support.md#beta) with a [feature flag](../feature_flags/_index.md) named `ai_self_hosted_vendored_features`. Disabled by default.
- [Enabled by default](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/214030) in GitLab 18.7
- Generally available in GitLab 18.9. Feature flag `ai_self_hosted_vendored_features` [removed](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/218595).

{{< /history >}}

You can configure a GitLab Duo feature to use the GitLab AI vendor model, even if you use a self-hosted AI Gateway and models.

1. In the upper-right corner, select **Admin**.
1. In the left sidebar, select **GitLab Duo**.
1. Select **Configure GitLab Duo Self-Hosted**.
1. Select the **AI-native features** tab.
1. For the feature and sub-feature you want to configure, from the dropdown list, select **GitLab AI vendor model**.

![GitLab Duo Self-Hosted feature configuration using GitLab AI vendor model](img/gitlab_duo_self_hosted_feature_configuration_with_vendored_model_v18_3.png)

### Enable extended logging for debugging

{{< history >}}

- [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/587976) in GitLab 18.9.

{{< /history >}}

You can enable extended logging to collect detailed AI interaction data from the GitLab Duo Agent Platform.

- On GitLab Self-Managed, the detailed logs are shared with GitLab.
- When you host your own models and AI Gateway, this data remains on your infrastructure and is not shared with GitLab.

To view which information is logged,
see [Collecting usage data](../../user/gitlab_duo/data_usage.md#collecting-usage-data).

To enable extended logging:

1. In the upper-right corner, select **Admin**.
1. On the left sidebar, select **GitLab Duo**.
1. Select **Change configuration**.
1. Select the **Collect usage data** checkbox.
1. Select **Save changes**.

### Disable GitLab Duo features

GitLab Duo features remain turned on even if you have not chosen a model for a sub-feature.

To disable a GitLab Duo feature or sub-feature:

1. In the upper-right corner, select **Admin**.
1. In the left sidebar, select **GitLab Duo**.
1. Select **Configure GitLab Duo Self-Hosted**.
1. Select the **AI-native features** tab.
1. For the feature or sub-feature you want to disable, from the dropdown list, select **Disabled**.

![Disabling GitLab Duo Feature](img/gitlab_duo_self_hosted_disable_feature_v17_11.png)

### Self-host the GitLab documentation

If your GitLab Duo Self-Hosted setup prevents you from accessing the GitLab documentation at
`docs.gitlab.com`, you can self-host the documentation.
For more information, see [Host the GitLab product documentation](../docs_self_host.md).

## Related topics

- [Supported models](supported_models_and_hardware_requirements.md#supported-models)
- [Compatible models](supported_models_and_hardware_requirements.md#compatible-models)
- [AI Gateway configuration types](_index.md#ai-gateway-configurations)
