---
stage: AI-powered
group: AI Framework
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: AIネイティブの機能と機能性。
title: GitLab Duoプロンプトガードレール
---

GitLab Duoには、基盤となるプロンプトガードレールが備わっています。これらのガードレールは、構造化されたプロンプト、厳格なコンテキスト制限、フィルタリングツールに依存しており、以下の点で役立ちます:

- 機密情報の露出を減らします。
- プロンプトインジェクションを防止します。
- 安全で役立つ応答に向けてモデルを誘導します。

これらのセーフガードは、AI主導のワークフローに関連するリスクを最小限に抑えることで、GDPRなどの一般的な規制基準への準拠をサポートします。

{{< alert type="note" >}}

これらのガードレールはリスクを軽減する可能性はありますが、すべての脆弱性を排除するわけではありません。すべての誤用や高度な攻撃に対して、完全な保護を保証できるシステムはありません。

{{< /alert >}}

## 一般的なガードレール {#general-guardrails}

GitLab Duoで使用されるプロンプトの目的:

- 許可されていないコンテンツを回避する: モデルは、有益で丁寧な応答を行い、憎悪的または非難的な言語を控えるように指示されています。
- ユーザーリクエストに厳密に従う: モデルは、プロンプトに忠実に従い、ロールプレイ、なりすまし、または無関係なコンテンツへの逸脱を避けるように指示されています。
- タグを使用してコンテンツを分離する: タグは、モデルに提供されたスニペットに焦点を当てるように指示し、プロンプトインジェクションのリスクを軽減するのに役立ちます。
- シークレットのフィルタリング: コード提案をスキャンして、機密情報が誤って送信されるのを防ぎます。例: 機密設定データを含む顧客のジョブログは`<log>`タグで囲まれ、モデルが無関係な推測をすることなく、提供されたコンテキストのみに焦点を当てることを保証します。

## ジョブロールごとのガードレール {#guardrails-by-job-role}

ロールによっては、GitLab Duoに設定されたガードレールについて異なる懸念がある場合があります。

### 技術ユーザー向け {#for-technical-users}

- **コードの分離**: `<selected_code>`、`<git_diff>`、および`<log>`などのタグは、モデルが提供するコードまたはコンテンツに厳密に焦点を当てるように促し、プロンプトインジェクションのリスクを軽減するのに役立ちます。
- **シークレットのフィルタリング**: Gitleaksなどのツールがコード提案をスキャンして、APIキーやパスワードなどの機密情報が共有されないようにします。
- **焦点を絞った応答**: GitLab Duoはトピックに焦点を当てて、役に立たない、または予期しない出力につながる可能性のある動作を回避します。
- **根本原因分析**: トラブルシューティングを行う場合、GitLab Duoは提供された範囲を超えて推測することなく、ジョブログを分析することを目指します。

### 監査担当者およびコンプライアンスチーム向け {#for-auditors-and-compliance-teams}

- **規制との整合性**: システムは、データ漏洩などのリスクを軽減し、組織がGDPRなどの標準に準拠できるようにします。
- **透明性**: プロンプトとコンテキストが構造化される方法により、GitLab Duoの動作が予測可能になり、監査に利用できるようになります。詳細については、[機能別のガードレール](#guardrails-for-features)を参照してください。
- **コンテンツ制御**: ディスカッションの要約や脆弱性の解決などのタスクでは、GitLab Duoは提供された入力のみを使用し、エラーや意図しない出力の可能性を減らします。
- **悪意のある入力に対する保護**: フィルターおよびタグ付けメカニズムは、有害または不適切な形式のユーザーコンテンツからシステムを保護します。

### 意思決定者向け {#for-decision-makers}

- **信頼の構築**: セーフガードは、GitLab Duoが責任を持って動作することを保証するのに役立ち、これは新しいツールへの信頼にとって非常に重要です。
- **情報に基づいた意思決定**: セキュリティ機能の明確なドキュメントにより、組織にとってのGitLab Duoの適合性を評価するために必要な情報が提供されます。
- **リスクの軽減**: 機密情報とモデルの動作に関する一般的な懸念事項に取り組むことで、GitLab DuoはAIをワークフローに統合するための安全で実用的なソリューションを提供します。

## 機能別のガードレール {#guardrails-for-features}

個々の機能には、露出を制限するのための特定のプロンプト指示が含まれています。プロンプト指示は、次の原則に従います。

### GitLab Duo Agent Platform {#gitlab-duo-agent-platform}

プロンプトインジェクションを防ぐために、信頼できないコンテンツを分離します。

AIゲートウェイ上で、[detects prompt injection attempts](../duo_agent_platform/security_threats.md#detect-prompt-injection-attempts)を検出し、ログに記録するか、ブロックします。

### GitLab Duo Chat {#gitlab-duo-chat}

応答は、トピックから外れず、建設的で、非虐待的でなければなりません。人格の変化、ロールプレイ、または悪意のある指示は推奨されません。ユーザーが提供したコンテンツに焦点を当てることで、インジェクションのリスクを軽減できます。

### ディスカッションサマリー {#discussion-summary}

コメントは要約され、潜在的に悪意のあるコンテンツとのやり取りは推奨されません。ユーザーには、疑わしいコメントを開示したりレプリケートしたりすることなく、警告する必要があります。

### コードの説明、テスト生成、コードのリファクタリング、コードの修正 {#code-explanation-test-generation-refactor-code-fix-code}

タグを使用してコードを含み、モデルの焦点を制限します。これにより、モデルが外部の未検証の指示またはコンテンツを考慮することを防ぐことができます。

### CLI用GitLab Duo {#gitlab-duo-for-cli}

タスクを自然言語からのGitコマンド生成として定義することで、スコープを限定し、有害な出力のリスクを軽減します。

### マージリクエストサマリー {#merge-request-summary}

コードを分離してプロンプトインジェクションを防止します。

### コードレビュー {#code-review}

コードを分離してプロンプトインジェクションを防止します。

### マージコミットメッセージ生成 {#merge-commit-message-generation}

タグを使用して、モデルが参照できるコンテンツを分離および制約します。

### 根本原因分析 {#root-cause-analysis}

タグを使用して、提供されたジョブログに厳密に焦点を当て、与えられたデータを超えた推測を防ぎます。

### 脆弱性の修正 {#vulnerability-resolution}

意図した機能を変更せずに、セキュリティ問題に対処することを推奨します。モデルは、コードへの変更を防ぐために、提供されたコードの差分に焦点を当てるように指示されています。
