/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.state.analysis;

import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ShiftedAddressDataType;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.state.VarnodeOperation;
import ghidra.util.state.analysis.Switch;
import ghidra.util.state.analysis.TableEntryAddress;

public class TableEntry
extends Switch {
    private final Program program;
    private final TableEntryAddress tableEntryAddress;
    private final int size;
    private boolean signExtend;

    private TableEntry(Program program, TableEntryAddress tableEntryAddress, int entrySize, boolean signExtend) {
        this.program = program;
        this.tableEntryAddress = tableEntryAddress;
        this.size = entrySize;
        this.signExtend = signExtend;
    }

    int getTableEntrySize() {
        return this.size;
    }

    @Override
    Varnode getIndexValue() {
        return this.tableEntryAddress.getIndexValue();
    }

    long getTableEntryValue(int caseIndexValue, int scaleFactor, boolean createTableData) throws MemoryAccessException {
        Address entryAddr = this.tableEntryAddress.getCaseAddress(caseIndexValue);
        if (createTableData) {
            this.createData(this.program.getListing(), entryAddr);
        }
        return TableEntry.getLongValue(this.program, entryAddr, scaleFactor, this.size, this.signExtend);
    }

    Address getTableEntryAsAddress(int caseIndexValue, int scaleFactor, boolean createTableData) throws MemoryAccessException, AddressOutOfBoundsException {
        Address entryAddr = this.tableEntryAddress.getCaseAddress(caseIndexValue);
        if (createTableData) {
            this.createPointer(entryAddr, scaleFactor);
        }
        long offset = TableEntry.getLongValue(this.program, entryAddr, scaleFactor, this.size, false);
        return this.program.getAddressFactory().getDefaultAddressSpace().getAddress(offset);
    }

    @Override
    Address getCaseAddress(int caseIndexValue) throws MemoryAccessException, AddressOutOfBoundsException {
        return this.getTableEntryAsAddress(caseIndexValue, 1, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createPointer(Address entryAddr, int scaleFactor) {
        Pointer ptrDt;
        if (scaleFactor != 1) {
            DataOrganization dataOrg = this.program.getDataTypeManager().getDataOrganization();
            int shiftFactor = 1 << dataOrg.getPointerShift();
            if (this.size != dataOrg.getPointerSize() || scaleFactor != shiftFactor) return;
            ptrDt = ShiftedAddressDataType.dataType;
        } else {
            ptrDt = PointerDataType.getPointer((DataType)DataType.DEFAULT, (int)this.size);
        }
        CreateDataCmd cmd = new CreateDataCmd(entryAddr, (DataType)ptrDt);
        cmd.applyTo(this.program);
    }

    private void createData(Listing listing, Address entryAddr) {
        ByteDataType primitiveDt;
        switch (this.size) {
            case 1: {
                primitiveDt = new ByteDataType();
                break;
            }
            case 2: {
                primitiveDt = new ByteDataType();
                break;
            }
            case 4: {
                primitiveDt = new ByteDataType();
                break;
            }
            case 8: {
                primitiveDt = new ByteDataType();
                break;
            }
            default: {
                return;
            }
        }
        CreateDataCmd cmd = new CreateDataCmd(entryAddr, (DataType)primitiveDt);
        cmd.applyTo(this.program);
    }

    static long getLongValue(Program program, Address entryAddr, int scaleFactor, int size, boolean signExtend) throws MemoryAccessException {
        byte[] bytes = new byte[size];
        Memory mem = program.getMemory();
        if (mem.getBytes(entryAddr, bytes) != size) {
            throw new MemoryAccessException("Failed to read table entry at: " + String.valueOf(entryAddr));
        }
        long val = 0L;
        if (program.getLanguage().isBigEndian()) {
            if (signExtend && bytes[0] < 0) {
                val = -1L;
            }
            for (int i = 0; i < size; ++i) {
                val = (val << 8) + ((long)bytes[i] & 0xFFL);
            }
        } else {
            if (signExtend && bytes[size - 1] < 0) {
                val = -1L;
            }
            for (int i = size - 1; i >= 0; --i) {
                val = (val << 8) + ((long)bytes[i] & 0xFFL);
            }
        }
        return val * (long)scaleFactor;
    }

    static TableEntry getTableEntry(Program program, Varnode v) {
        if (!(v instanceof VarnodeOperation)) {
            return null;
        }
        VarnodeOperation op = (VarnodeOperation)v;
        int opcode = op.getPCodeOp().getOpcode();
        boolean signExtend = false;
        if (opcode == 18 || opcode == 17) {
            v = op.getInputValues()[0];
            boolean bl = signExtend = opcode == 18;
            if (!(v instanceof VarnodeOperation)) {
                return null;
            }
            op = (VarnodeOperation)v;
            opcode = op.getPCodeOp().getOpcode();
        }
        if (opcode != 2) {
            return null;
        }
        Varnode[] inputValues = op.getInputValues();
        if (!inputValues[0].isConstant()) {
            return null;
        }
        AddressFactory addrFactory = program.getAddressFactory();
        if ((long)addrFactory.getDefaultAddressSpace().getSpaceID() != inputValues[0].getOffset()) {
            return null;
        }
        TableEntryAddress tableEntryAddress = TableEntryAddress.getTableEntryAddress(addrFactory, inputValues[1]);
        if (tableEntryAddress == null) {
            return null;
        }
        return new TableEntry(program, tableEntryAddress, op.getSize(), signExtend);
    }
}

