/*
 * Decompiled with CFR 0.152.
 */
package ghidra.sleigh.grammar;

import ghidra.sleigh.grammar.ANTLRUtil;
import ghidra.sleigh.grammar.BailoutException;
import ghidra.sleigh.grammar.HashMapPreprocessorDefinitionsAdapter;
import ghidra.sleigh.grammar.LineArrayListWriter;
import ghidra.sleigh.grammar.ParsingEnvironment;
import ghidra.sleigh.grammar.SleighLexer;
import ghidra.sleigh.grammar.SleighParser;
import ghidra.sleigh.grammar.SleighPreprocessor;
import java.io.File;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.UnbufferedTokenStream;
import org.antlr.runtime.tree.Tree;

public class SleighParserRun {
    public static void main(String[] args) {
        ParsingEnvironment env = null;
        try {
            LineArrayListWriter writer = new LineArrayListWriter();
            env = new ParsingEnvironment(writer);
            SleighPreprocessor sp = new SleighPreprocessor(new HashMapPreprocessorDefinitionsAdapter(), new File(args[0]));
            sp.process(writer);
            ANTLRStringStream input = new ANTLRStringStream(writer.toString());
            SleighLexer lex = new SleighLexer((CharStream)input);
            lex.setEnv(env);
            UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lex);
            SleighParser parser = new SleighParser((TokenStream)tokens);
            parser.setEnv(env);
            parser.setLexer(lex);
            SleighParser.spec_return spec = parser.spec();
            ANTLRUtil.debugTree((Tree)spec.tree, System.out);
        }
        catch (BailoutException be) {
            System.err.println(env.format(be));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

