/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.oatdexfile;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.dex.DexHeaderFactory;
import ghidra.file.formats.android.dex.format.ClassDefItem;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.OatUtilities;
import ghidra.file.formats.android.oat.oatclass.OatClass;
import ghidra.file.formats.android.oat.oatclass.OatClassFactory;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFileUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class OatDexFile_KitKat
extends OatDexFile {
    protected int dex_file_location_size_;
    protected String dex_file_location_;
    protected int dex_file_location_checksum_;
    protected int dex_file_pointer_;
    protected int[] oat_class_offsets_pointer_;
    private DexHeader dexHeader;

    OatDexFile_KitKat(BinaryReader reader) throws IOException {
        this.dex_file_location_size_ = reader.readNextInt();
        this.dex_file_location_ = reader.readNextAsciiString(this.dex_file_location_size_);
        this.dex_file_location_checksum_ = reader.readNextInt();
        this.dex_file_pointer_ = reader.readNextInt();
        ByteProvider provider = reader.getByteProvider();
        ByteProviderWrapper tmpProvider = new ByteProviderWrapper(provider, (long)this.dex_file_pointer_, provider.length() - (long)this.dex_file_pointer_);
        BinaryReader tmpReader = new BinaryReader((ByteProvider)tmpProvider, reader.isLittleEndian());
        this.dexHeader = DexHeaderFactory.getDexHeader(tmpReader);
        int size = this.dexHeader.getClassDefs().size();
        this.oat_class_offsets_pointer_ = size == 0 ? new int[0] : reader.readNextIntArray(size);
    }

    @Override
    public String getDexFileLocation() {
        return this.dex_file_location_;
    }

    @Override
    public int getDexFileChecksum() {
        return this.dex_file_location_checksum_;
    }

    @Override
    public int getDexFileOffset() {
        return this.dex_file_pointer_;
    }

    @Override
    public DexHeader getDexHeader() {
        return this.dexHeader;
    }

    @Override
    public boolean isDexHeaderExternal() {
        return false;
    }

    @Override
    public void markup(OatHeader oatHeader, Program program, TaskMonitor monitor, MessageLog log) throws Exception {
        Symbol oatDataSymbol = OatUtilities.getOatDataSymbol(program);
        Address address = oatDataSymbol.getAddress();
        Listing listing = program.getListing();
        ReferenceManager referenceManager = program.getReferenceManager();
        SymbolTable symbolTable = program.getSymbolTable();
        Memory memory = program.getMemory();
        Data oatHeaderData = listing.getDefinedDataAt(address);
        if (oatHeaderData == null || !oatHeaderData.getDataType().getName().startsWith("OatHeader")) {
            return;
        }
        List<Data> oatDexFileHeaderDataList = this.getOatDexFileHeaderData(oatHeaderData, monitor);
        monitor.setProgress(0L);
        monitor.setMaximum((long)oatDexFileHeaderDataList.size());
        for (Data data : oatDexFileHeaderDataList) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            for (int i = 0; i < data.getNumComponents(); ++i) {
                monitor.checkCancelled();
                monitor.setMaximum((long)data.getNumComponents());
                monitor.setProgress((long)i);
                Data componentI = data.getComponent(i);
                if (componentI.getFieldName().startsWith("dex_file_pointer_")) {
                    Scalar scalar = componentI.getScalar(0);
                    Address toAddr = oatDataSymbol.getAddress().add(scalar.getUnsignedValue());
                    referenceManager.addMemoryReference(componentI.getMinAddress(), toAddr, RefType.DATA, SourceType.ANALYSIS, 0);
                }
                if (!componentI.getFieldName().startsWith("dexClassOffsets")) continue;
                Data dexClassOffsetsData = this.getDexClassOffsetsData(data, monitor);
                this.markupDexClassOffset(oatHeader, program, oatDataSymbol, dexClassOffsetsData, monitor, log);
            }
        }
        for (int i = 0; i < this.oat_class_offsets_pointer_.length; ++i) {
            monitor.checkCancelled();
            monitor.setMaximum((long)this.oat_class_offsets_pointer_.length);
            monitor.setProgress((long)i);
            ClassDefItem classDefItem = this.dexHeader.getClassDefs().get(i);
            String className = DexUtil.convertTypeIndexToString(this.dexHeader, classDefItem.getClassIndex());
            Namespace classNameSpace = DexUtil.createNameSpaceFromMangledClassName(program, className);
            Address offsetAddress = oatDataSymbol.getAddress().add((long)this.oat_class_offsets_pointer_[i]);
            symbolTable.createLabel(offsetAddress, className, SourceType.ANALYSIS);
            MemoryByteProvider oatClassHeaderProvider = new MemoryByteProvider(memory, offsetAddress);
            BinaryReader oatClassHeaderReader = new BinaryReader((ByteProvider)oatClassHeaderProvider, !program.getLanguage().isBigEndian());
            OatClass oatClassHeader = OatClassFactory.getOatClass(oatClassHeaderReader, classDefItem.getClassDataItem(), oatHeader.getVersion());
            OatDexFileUtilities.markupMethod(oatHeader, oatClassHeader, this.dexHeader, classDefItem, program, oatDataSymbol, classNameSpace, log, monitor);
            OatDexFileUtilities.markupClassHeaderData(program, oatDataSymbol, offsetAddress, oatHeader, oatClassHeader, log, monitor);
        }
    }

    private void markupDexClassOffset(OatHeader oatHeader, Program program, Symbol oatDataSymbol, Data dexClassOffsetsData, TaskMonitor monitor, MessageLog log) throws Exception, CancelledException {
        ReferenceManager referenceManager = program.getReferenceManager();
        SymbolTable symbolTable = program.getSymbolTable();
        for (int j = 0; j < dexClassOffsetsData.getNumComponents(); ++j) {
            monitor.checkCancelled();
            Data component = dexClassOffsetsData.getComponent(j);
            if (!component.getFieldName().startsWith("oat_class_offsets_pointer")) continue;
            Scalar scalar = component.getScalar(0);
            Address toAddr = oatDataSymbol.getAddress().add(scalar.getUnsignedValue());
            toAddr = OatUtilities.adjustForThumbAsNeeded(oatHeader, program, toAddr, log);
            referenceManager.addMemoryReference(component.getMinAddress(), toAddr, RefType.DATA, SourceType.ANALYSIS, 0);
            symbolTable.addExternalEntryPoint(toAddr);
        }
    }

    private List<Data> getOatDexFileHeaderData(Data oatHeaderData, TaskMonitor monitor) throws Exception {
        ArrayList<Data> list = new ArrayList<Data>();
        for (int i = 0; i < oatHeaderData.getNumComponents(); ++i) {
            monitor.checkCancelled();
            monitor.setMaximum((long)oatHeaderData.getNumComponents());
            monitor.setProgress((long)i);
            Data componentI = oatHeaderData.getComponent(i);
            if (!componentI.getFieldName().startsWith(OatDexFile.PREFIX)) continue;
            list.add(componentI);
        }
        return list;
    }

    private Data getDexClassOffsetsData(Data oatDexFileHeaderData, TaskMonitor monitor) throws Exception {
        for (int i = 0; i < oatDexFileHeaderData.getNumComponents(); ++i) {
            monitor.checkCancelled();
            monitor.setMaximum((long)oatDexFileHeaderData.getNumComponents());
            monitor.setProgress((long)i);
            Data componentI = oatDexFileHeaderData.getComponent(i);
            if (!componentI.getFieldName().startsWith("dexClassOffsets")) continue;
            return componentI;
        }
        throw new RuntimeException("Can't find dexClassOffsets");
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(OatDexFile_KitKat.class.getSimpleName() + "_" + this.oat_class_offsets_pointer_.length, 0);
        structure.add(DWORD, "dex_file_location_size_", null);
        structure.add(STRING, this.dex_file_location_size_, "dex_file_location_", null);
        structure.add(DWORD, "dex_file_location_checksum_", null);
        structure.add(DWORD, "dex_file_pointer_", null);
        StructureDataType dexClassOffsetsStructure = new StructureDataType("dexClassOffsets_" + this.oat_class_offsets_pointer_.length, 0);
        for (int i = 0; i < this.oat_class_offsets_pointer_.length; ++i) {
            dexClassOffsetsStructure.add(DWORD, "oat_class_offsets_pointer_" + i, null);
        }
        dexClassOffsetsStructure.setCategoryPath(new CategoryPath("/oat"));
        structure.add((DataType)dexClassOffsetsStructure, "dexClassOffsets", null);
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

