/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractDefinedSingleAddressRangeMsSymbol;

public class SubfieldDARMsSymbol
extends AbstractDefinedSingleAddressRangeMsSymbol {
    public static final int PDB_ID = 4416;
    private long program;
    private long offsetInParent;

    public SubfieldDARMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.program = reader.parseVarSizedOffset(32);
        this.offsetInParent = reader.parseVarSizedOffset(32);
        this.parseRangeAndGaps(reader);
    }

    @Override
    public int getPdbId() {
        return 4416;
    }

    @Override
    protected String getSymbolTypeName() {
        return "DEFRANGE_SUBFIELD";
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: offset at %04X, DIA Program NI: %04X, ", this.getSymbolTypeName(), this.offsetInParent, this.program));
        this.emitRangeAndGaps(builder);
    }
}

