/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

import ghidra.util.BigEndianDataConverter;

public class BufferFileBlock {
    private int blockIndex;
    private byte[] buffer;

    public BufferFileBlock(int blockIndex, byte[] buffer) {
        this.blockIndex = blockIndex;
        this.buffer = buffer;
    }

    public BufferFileBlock(byte[] bytes) {
        this.blockIndex = BigEndianDataConverter.INSTANCE.getInt(bytes, 0);
        this.buffer = new byte[bytes.length - 4];
        System.arraycopy(bytes, 4, this.buffer, 0, this.buffer.length);
    }

    public int size() {
        return this.buffer.length;
    }

    public int getIndex() {
        return this.blockIndex;
    }

    public byte[] getData() {
        return this.buffer;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[this.buffer.length + 4];
        System.arraycopy(this.buffer, 0, bytes, 4, this.buffer.length);
        BigEndianDataConverter.INSTANCE.putInt(bytes, 0, this.blockIndex);
        return bytes;
    }
}

