/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.DialogActionContext;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.datatable.ProjectTreeContext;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.ProjectData;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreePath;

public class DialogProjectTreeContext
extends DialogActionContext
implements ProjectTreeContext {
    private TreePath[] selectionPaths;
    private DataTree tree;
    private List<DomainFolder> selectedFolders;
    private List<DomainFile> selectedFiles;

    public DialogProjectTreeContext(ProjectData projectData, TreePath[] selectionPaths, List<DomainFolder> folderList, List<DomainFile> fileList, DataTree tree) {
        super(DialogProjectTreeContext.getContextObject(selectionPaths), (Component)((Object)tree));
        this.selectionPaths = selectionPaths;
        this.selectedFolders = folderList;
        this.selectedFiles = fileList;
        this.tree = tree;
    }

    private static Object getContextObject(TreePath[] selectionPaths) {
        if (selectionPaths.length == 0) {
            return null;
        }
        return selectionPaths[0].getLastPathComponent();
    }

    @Override
    public TreePath[] getSelectionPaths() {
        return this.selectionPaths;
    }

    @Override
    public DataTree getTree() {
        return this.tree;
    }

    @Override
    public List<DomainFile> getSelectedFiles() {
        if (this.selectedFiles == null) {
            return Collections.emptyList();
        }
        return this.selectedFiles;
    }

    @Override
    public List<DomainFolder> getSelectedFolders() {
        if (this.selectedFolders == null) {
            return Collections.emptyList();
        }
        return this.selectedFolders;
    }

    @Override
    public int getFolderCount() {
        if (this.selectedFolders == null) {
            return 0;
        }
        return this.selectedFolders.size();
    }

    @Override
    public int getFileCount() {
        if (this.selectedFiles == null) {
            return 0;
        }
        return this.selectedFiles.size();
    }

    @Override
    public boolean hasExactlyOneFileOrFolder() {
        return this.getFolderCount() + this.getFileCount() == 1;
    }

    @Override
    public boolean hasOneOrMoreFilesAndFolders() {
        return this.getFolderCount() + this.getFileCount() > 0;
    }

    @Override
    public GTreeNode getContextNode() {
        return (GTreeNode)super.getContextObject();
    }
}

