/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.parser.AbstractTokenHandler;
import io.sf.carte.doc.style.css.parser.CSSContentHandler;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.CSSTokenHandler;
import io.sf.carte.doc.style.css.parser.ControlTokenHandler;
import io.sf.carte.doc.style.css.parser.HandlerManager;
import io.sf.carte.doc.style.css.parser.ParseHelper;

abstract class BufferTokenHandler
extends CSSTokenHandler
implements CSSContentHandler {
    StringBuilder buffer;
    private int escapedTokenIndex = -1;

    BufferTokenHandler() {
        this.initializeBuffer();
    }

    protected void initializeBuffer() {
    }

    protected void setEscapedTokenStart(int index) {
        if (this.escapedTokenIndex == -1) {
            this.escapedTokenIndex = index - 1;
        }
    }

    protected void resetEscapedTokenIndex() {
        this.escapedTokenIndex = -1;
    }

    boolean isEscapedIdent() {
        return this.getEscapedTokenIndex() != -1;
    }

    protected int getEscapedTokenIndex() {
        return this.escapedTokenIndex;
    }

    public void word(int index, CharSequence word) {
        this.buffer.append(word);
        this.prevcp = 65;
    }

    public void escaped(int index, int codePoint) {
        if (this.isEscapedCodepoint(codePoint)) {
            this.setEscapedTokenStart(index);
            this.buffer.append('\\');
        }
        this.prevcp = 65;
        this.bufferAppend(codePoint);
    }

    boolean isEscapedCodepoint(int codepoint) {
        return ParseHelper.isHexCodePoint(codepoint) || codepoint == 92 || codepoint == 43 || codepoint == 45 || codepoint == 32;
    }

    public void separator(int index, int codepoint) {
        if (this.getEscapedTokenIndex() != -1 && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
            this.buffer.append(' ');
        } else {
            if (this.buffer.length() != 0) {
                this.processBuffer(index, codepoint);
            }
            this.setWhitespacePrevCp();
        }
    }

    @Override
    public void endOfStream(int len) {
        if (this.buffer.length() != 0) {
            this.processBuffer(len, 0);
        }
    }

    abstract void processBuffer(int var1, int var2);

    @Override
    public void leftCurlyBracket(int index) {
        this.unexpectedLeftCurlyBracketError(index);
    }

    @Override
    public void rightCurlyBracket(int index) {
        this.getManager().rightCurlyBracket(index);
        this.prevcp = 125;
    }

    void bufferAppend(char c) {
        this.buffer.append(c);
    }

    void bufferAppend(int codepoint) {
        this.buffer.appendCodePoint(codepoint);
    }

    void trimBufferTail() {
        int lenm1 = this.buffer.length() - 1;
        if (this.buffer.charAt(lenm1) == ' ') {
            this.buffer.setLength(lenm1);
        }
    }

    String rawBuffer() {
        this.resetEscapedTokenIndex();
        String s = this.buffer.toString();
        this.buffer.setLength(0);
        return s;
    }

    String unescapeBuffer(int index) {
        String s = this.unescapeStringValue(index);
        this.buffer.setLength(0);
        this.resetEscapedTokenIndex();
        return s;
    }

    String unescapeStringValue(int index) {
        String s;
        if (this.isEscapedIdent()) {
            int escsz = index - this.escapedTokenIndex;
            int rawlen = this.buffer.length() - escsz;
            if (rawlen <= 0) {
                s = CSSParser.safeUnescapeIdentifier(this.buffer.toString());
            } else {
                CharSequence rawseq = this.buffer.subSequence(0, rawlen);
                s = rawseq + CSSParser.safeUnescapeIdentifier(this.buffer.substring(rawlen));
            }
        } else {
            s = this.buffer.toString();
        }
        return s;
    }

    @Override
    public void resetHandler() {
        super.resetHandler();
        this.resetEscapedTokenIndex();
    }

    @Override
    public void reportError(CSSParseException ex) throws CSSParseException {
        if (this.getErrorHandler() == null) {
            throw ex;
        }
        this.getErrorHandler().error(ex);
        this.setParseError();
    }

    @Override
    public void handleWarning(int index, byte errCode, String message, Throwable cause) {
        if (!this.isInError() && this.getErrorHandler() != null) {
            CSSParseException ex = this.createException(index, errCode, message);
            if (cause != null) {
                ex.initCause(cause);
            }
            this.getErrorHandler().warning(ex);
        }
    }

    @Override
    void unexpectedLeftCurlyBracketError(int index) {
        CSSTokenHandler curh;
        if (!this.isInError()) {
            super.unexpectedLeftCurlyBracketError(index);
        }
        if ((curh = this.getControlHandler().getCurrentHandler()) != this) {
            curh.leftCurlyBracket(index);
        }
    }

    void sendLeftCurlyBracketEvent(int index, AbstractTokenHandler fromTH) {
        CSSTokenHandler curTH = this.getControlHandler().getCurrentHandler();
        if (curTH == fromTH) {
            throw new IllegalStateException("Handler sends event to itself.");
        }
        curTH.leftCurlyBracket(index);
    }

    @Override
    public void unexpectedLeftSquareBracketError(int index) {
        CSSTokenHandler curh;
        if (!this.isInError()) {
            super.unexpectedLeftSquareBracketError(index);
        }
        if ((curh = this.getControlHandler().getCurrentHandler()) != this) {
            curh.leftSquareBracket(index);
        }
    }

    @Override
    public void unexpectedRightCurlyBracketError(int index) {
        CSSTokenHandler curh;
        if (!this.isInError()) {
            super.unexpectedRightCurlyBracketError(index);
        }
        if ((curh = this.getControlHandler().getCurrentHandler()) != this) {
            curh.rightCurlyBracket(index);
        }
    }

    @Override
    public void unexpectedRightSquareBracketError(int index) {
        CSSTokenHandler curh;
        if (!this.isInError()) {
            super.unexpectedRightSquareBracketError(index);
        }
        if ((curh = this.getControlHandler().getCurrentHandler()) != this) {
            curh.rightSquareBracket(index);
        }
    }

    @Override
    protected void yieldHandling(CSSContentHandler yieldHandler) {
        ControlTokenHandler ctl = this.getControlHandler();
        assert (this.checkYieldHandling(ctl));
        ctl.yieldHandling(yieldHandler);
    }

    private boolean checkYieldHandling(ControlTokenHandler ctl) {
        if (ctl.getCurrentHandler() instanceof IgnoredDeclarationTokenHandler) {
            throw new IllegalStateException("Attempting to replace an error handler.");
        }
        return true;
    }

    class IgnoredDeclarationTokenHandler
    extends CSSTokenHandler {
        private int curlyBracketDepth = 0;
        private int sqBracketDepth = 0;

        IgnoredDeclarationTokenHandler() {
            this.parendepth = BufferTokenHandler.this.getCurrentParenDepth();
            if (this.parendepth < 0) {
                this.parendepth = 0;
            }
        }

        public void word(int index, CharSequence word) {
        }

        public void separator(int index, int codePoint) {
        }

        @Override
        public void commented(int index, int commentType, String comment) {
        }

        @Override
        public void quoted(int index, CharSequence quoted, int quoteCp) {
        }

        @Override
        public void quotedWithControl(int index, CharSequence quoted, int quote) {
        }

        @Override
        public void leftParenthesis(int index) {
            this.parendepth = (short)(this.parendepth + 1);
        }

        @Override
        public void leftSquareBracket(int index) {
            ++this.sqBracketDepth;
        }

        @Override
        public void rightParenthesis(int index) {
            this.parendepth = (short)(this.parendepth - 1);
        }

        @Override
        public void rightSquareBracket(int index) {
            --this.sqBracketDepth;
        }

        @Override
        public void leftCurlyBracket(int index) {
            ++this.curlyBracketDepth;
        }

        @Override
        public void rightCurlyBracket(int index) {
            --this.curlyBracketDepth;
            if (this.parendepth <= 0 && this.sqBracketDepth <= 0) {
                if (this.curlyBracketDepth < 0) {
                    this.endDeclarationBlock(index);
                    this.resetHandler();
                } else if (this.curlyBracketDepth == 0) {
                    this.resumeDeclarationRuleList();
                }
            }
        }

        public void character(int index, int codePoint) {
            if (codePoint == 59 && this.curlyBracketDepth == 0 && this.parendepth == 0 && this.sqBracketDepth == 0) {
                this.resetHandler();
                this.resumeDeclarationList();
            }
        }

        protected void resumeDeclarationRuleList() {
            this.resetHandler();
            this.resumeDeclarationList();
        }

        @Override
        public void resetHandler() {
            BufferTokenHandler.this.resetHandler();
            BufferTokenHandler.this.resetParseError();
        }

        protected void resumeDeclarationList() {
            this.getManager().restoreInitialHandler();
        }

        @Override
        public void endOfStream(int len) {
            this.getManager().endOfStream(len);
        }

        protected void endDeclarationBlock(int index) {
            this.getManager().endManagement(index);
        }

        public void escaped(int index, int codePoint) {
        }

        @Override
        public void handleErrorRecovery() {
        }

        @Override
        public boolean isInError() {
            return true;
        }

        @Override
        public void reportError(CSSParseException ex) throws CSSParseException {
        }

        @Override
        public void handleWarning(int index, byte errCode, String message, Throwable cause) {
        }

        @Override
        ControlTokenHandler getControlHandler() {
            return BufferTokenHandler.this.getControlHandler();
        }

        @Override
        public HandlerManager getManager() {
            return BufferTokenHandler.this.getManager();
        }
    }
}

