/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectState;

public class DB2ColumnMask
extends DB2Object<DB2Table>
implements DBPStatefulObject {
    private DB2TableColumn tableColumn;
    private Date creationTime;
    private Date alteringTime;
    private boolean enable;
    private boolean valid;
    private String ruleText;
    private String description;

    DB2ColumnMask(@NotNull DB2Table db2Table, @NotNull DB2TableColumn column, @NotNull String name, @NotNull JDBCResultSet resultSet) {
        super(db2Table, name, true);
        this.tableColumn = column;
        this.creationTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CREATE_TIME");
        this.alteringTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"ALTER_TIME");
        this.enable = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"ENABLE", (String)DB2YesNo.Y.name());
        this.valid = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"VALID", (String)DB2YesNo.Y.name());
        this.ruleText = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"RULETEXT");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMARKS");
    }

    @Property(viewable=true, order=2)
    public DB2TableColumn getTableColumn() {
        return this.tableColumn;
    }

    @Property(viewable=true, order=3)
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Property(viewable=true, order=4)
    public Date getAlteringTime() {
        return this.alteringTime;
    }

    @Property(viewable=true, order=5)
    public boolean isEnable() {
        return this.enable;
    }

    @Property(viewable=true, order=6)
    public boolean isValid() {
        return this.valid;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=7)
    public String getRuleText() {
        return this.ruleText;
    }

    @Override
    @Property(viewable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.valid ? DBSObjectState.NORMAL : DBSObjectState.INVALID;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) {
    }
}

