/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import java.io.File;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.controls.ScriptSelectorPanel;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.INonPersistentEditorInput;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectDataSourceDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SQLEditorHandlerOpenEditor
extends AbstractDataSourceHandler {
    public static void openResource(IResource resource) {
        SQLEditorHandlerOpenEditor.openResource(resource, new SQLNavigatorContext());
    }

    public static void openResource(IResource resource, @Nullable SQLNavigatorContext navigatorContext) {
        try {
            DBPResourceHandler handler = DBPPlatformDesktop.getInstance().getWorkspace().getResourceHandler(resource);
            if (handler != null) {
                if (navigatorContext != null && resource instanceof IFile && navigatorContext.getDataSourceContainer() != null) {
                    EditorUtils.setFileDataSource((IFile)((IFile)resource), (DatabaseEditorContext)navigatorContext);
                }
                handler.openResource(resource);
            }
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.actions_navigator_error_dialog_open_resource_title, "Can't open resource '" + resource.getName() + "'", (Throwable)e);
        }
    }

    public static void openResourceEditor(IWorkbenchWindow workbenchWindow, SQLEditorUtils.ResourceInfo resourceInfo, SQLNavigatorContext context) {
        if (resourceInfo.getResource() != null) {
            SQLEditorHandlerOpenEditor.openResource(resourceInfo.getResource(), context);
        } else if (resourceInfo.getLocalFile() != null) {
            if (context != null) {
                EditorUtils.setFileDataSource((File)resourceInfo.getLocalFile(), (DatabaseEditorContext)context);
            }
            EditorUtils.openExternalFileEditor((File)resourceInfo.getLocalFile(), (IWorkbenchWindow)workbenchWindow);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String actionId = event.getCommand().getId();
        if ("org.jkiss.dbeaver.core.sql.editor.defaultCommand".equals(actionId)) {
            String defCommand = DBWorkbench.getPlatform().getPreferenceStore().getString("SQLEditor.defaultOpenCommand");
            if (CommonUtils.isEmpty((String)defCommand)) {
                return null;
            }
            if (defCommand.equals("org.jkiss.dbeaver.core.sql.editor.console")) {
                ActionUtils.runCommand((String)"org.jkiss.dbeaver.core.sql.editor.console", (IServiceLocator)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event));
                return null;
            }
            actionId = defCommand;
        }
        try {
            DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
            switch (actionId) {
                case "org.jkiss.dbeaver.core.sql.editor.open": {
                    if (activeProject != null && !activeProject.hasRealmPermission("project-resource-view")) break;
                    SQLEditorHandlerOpenEditor.openEditor(event);
                    break;
                }
                case "org.jkiss.dbeaver.core.sql.editor.create": {
                    if (activeProject != null && !activeProject.hasRealmPermission("project-resource-edit")) break;
                    SQLEditorHandlerOpenEditor.openNewEditor(event);
                    break;
                }
                case "org.jkiss.dbeaver.core.sql.editor.recent": {
                    if (activeProject != null && !activeProject.hasRealmPermission("project-resource-view")) break;
                    SQLEditorHandlerOpenEditor.openRecentEditor(event);
                }
            }
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError("Open editor", null, e);
        }
        return null;
    }

    private static void openEditor(ExecutionEvent event) throws CoreException, InterruptedException {
        SQLNavigatorContext editorContext = SQLEditorHandlerOpenEditor.getCurrentContext(event);
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        SQLEditorHandlerOpenEditor.openEditor(workbenchWindow, editorContext);
    }

    private static void openEditor(IWorkbenchWindow workbenchWindow, SQLNavigatorContext editorContext) throws CoreException {
        RCPProject project = editorContext.getProject();
        SQLEditorHandlerOpenEditor.checkProjectIsOpen((DBPProject)project);
        IFolder rootFolder = SQLEditorUtils.getScriptsFolder((DBPProject)project, true);
        List<SQLEditorUtils.ResourceInfo> scriptTree = SQLEditorUtils.findScriptTree(project, rootFolder, editorContext.getDataSourceContainer());
        if (scriptTree.isEmpty()) {
            IFile newScript = SQLEditorUtils.createNewScript((DBPProject)project, rootFolder, editorContext);
            SQLEditorHandlerOpenEditor.openResource((IResource)newScript, editorContext);
        } else {
            ScriptSelectorPanel.showTree(workbenchWindow, editorContext, rootFolder, scriptTree);
        }
    }

    public static IFile openNewEditor(@NotNull SQLNavigatorContext editorContext, ISelection selection) throws CoreException {
        RCPProject project = editorContext.getProject();
        SQLEditorHandlerOpenEditor.checkProjectIsOpen((DBPProject)project);
        IFolder folder = SQLEditorHandlerOpenEditor.getCurrentScriptFolder(selection);
        IFile scriptFile = SQLEditorUtils.createNewScript((DBPProject)project, folder, editorContext);
        SQLEditorHandlerOpenEditor.openResource((IResource)scriptFile, editorContext);
        return scriptFile;
    }

    public static IFolder getCurrentScriptFolder(ISelection selection) {
        IFolder folder = null;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IFolder) {
                folder = (IFolder)element;
            } else if (element instanceof DBNResource && ((DBNResource)element).getResource() instanceof IFolder) {
                folder = (IFolder)((DBNResource)element).getResource();
            }
        }
        return folder;
    }

    private static void openNewEditor(ExecutionEvent event) throws CoreException, InterruptedException {
        SQLNavigatorContext context = SQLEditorHandlerOpenEditor.getCurrentContext(event);
        SQLEditorHandlerOpenEditor.openNewEditor(context, HandlerUtil.getCurrentSelection((ExecutionEvent)event));
    }

    private static void openRecentEditor(ExecutionEvent event) throws CoreException, InterruptedException {
        SQLNavigatorContext context = SQLEditorHandlerOpenEditor.getCurrentContext(event);
        SQLEditorHandlerOpenEditor.openRecentScript(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), context, null);
    }

    @NotNull
    static SQLNavigatorContext getCurrentContext(ExecutionEvent event) throws InterruptedException {
        DBPProject project;
        SQLNavigatorContext context = new SQLNavigatorContext(event);
        if (context.getDataSourceContainer() == null && (project = NavigatorUtils.getSelectedProject()) != null) {
            DBPDataSourceRegistry dataSourceRegistry = project.getDataSourceRegistry();
            if (dataSourceRegistry.getDataSources().size() == 1) {
                context.setDataSourceContainer((DBPDataSourceContainer)dataSourceRegistry.getDataSources().get(0));
            } else if (!dataSourceRegistry.getDataSources().isEmpty()) {
                SelectDataSourceDialog dialog = new SelectDataSourceDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), project, null);
                dialog.setModeless(true);
                if (dialog.open() == 1) {
                    throw new InterruptedException();
                }
                context.setDataSourceContainer(dialog.getDataSource());
            }
        }
        return context;
    }

    private static DBPDataSourceContainer getDataSourceContainers(IWorkbenchPart activePart) {
        if (activePart instanceof DBPDataSourceContainerProvider) {
            return ((DBPDataSourceContainerProvider)activePart).getDataSourceContainer();
        }
        if (activePart instanceof DBPContextProvider) {
            DBCExecutionContext context = ((DBPContextProvider)activePart).getExecutionContext();
            return context == null ? null : context.getDataSource().getContainer();
        }
        return null;
    }

    public static void openRecentScript(@NotNull IWorkbenchWindow workbenchWindow, @NotNull SQLNavigatorContext editorContext, @Nullable IFolder scriptFolder) throws CoreException {
        RCPProject project = editorContext.getProject();
        SQLEditorHandlerOpenEditor.checkProjectIsOpen((DBPProject)project);
        SQLEditorUtils.ResourceInfo res = SQLEditorUtils.findRecentScript(project, editorContext);
        if (res != null) {
            IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
            if (res.getResource() != null && activeEditor != null && CommonUtils.equalObjects((Object)res.getResource(), (Object)EditorUtils.getFileFromInput((IEditorInput)activeEditor.getEditorInput()))) {
                SQLEditorHandlerOpenEditor.openEditor(workbenchWindow, editorContext);
            } else {
                SQLEditorHandlerOpenEditor.openResourceEditor(workbenchWindow, res, editorContext);
            }
        } else if (project.hasRealmPermission("project-resource-edit")) {
            IFile scriptFile = SQLEditorUtils.createNewScript((DBPProject)project, scriptFolder, editorContext);
            SQLEditorHandlerOpenEditor.openResource((IResource)scriptFile, editorContext);
        } else {
            SQLEditorHandlerOpenEditor.openSQLConsole(workbenchWindow, editorContext, editorContext.getDataSourceContainer().getName(), "");
        }
    }

    static void checkProjectIsOpen(DBPProject project) throws CoreException {
        if (project == null) {
            throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)new IllegalStateException("No active project.")));
        }
        project.ensureOpen();
    }

    public static SQLEditor openSQLConsole(IWorkbenchWindow workbenchWindow, SQLNavigatorContext context, String name, String sqlText) {
        StringEditorInput sqlInput = new StringEditorInput(name, (CharSequence)sqlText, false, GeneralUtils.DEFAULT_ENCODING);
        return SQLEditorHandlerOpenEditor.openSQLConsole(workbenchWindow, context, (IEditorInput)sqlInput);
    }

    public static SQLEditor openSQLConsole(@NotNull IWorkbenchWindow workbenchWindow, @NotNull SQLNavigatorContext context, @NotNull IEditorInput sqlInput) {
        EditorUtils.setInputDataSource((IEditorInput)sqlInput, (DatabaseEditorContext)context);
        return SQLEditorHandlerOpenEditor.openSQLEditor(workbenchWindow, sqlInput);
    }

    @Nullable
    public static SQLEditor openNewSQLConsole(@NotNull IWorkbenchWindow workbenchWindow, @NotNull SQLNavigatorContext context, @NotNull IEditorInput sqlInput) {
        EditorUtils.setInputDataSource((IEditorInput)sqlInput, (DatabaseEditorContext)context);
        return SQLEditorHandlerOpenEditor.openSQLEditor(workbenchWindow, sqlInput, 0);
    }

    private static SQLEditor openSQLEditor(@NotNull IWorkbenchWindow workbenchWindow, @NotNull IEditorInput sqlInput) {
        boolean isConsole = sqlInput instanceof INonPersistentEditorInput;
        return SQLEditorHandlerOpenEditor.openSQLEditor(workbenchWindow, sqlInput, isConsole ? 0 : 1);
    }

    private static SQLEditor openSQLEditor(@NotNull IWorkbenchWindow workbenchWindow, @NotNull IEditorInput sqlInput, int matchFlags) {
        try {
            return (SQLEditor)workbenchWindow.getActivePage().openEditor(sqlInput, SQLEditor.class.getName(), true, matchFlags);
        }
        catch (PartInitException e) {
            DBWorkbench.getPlatformUI().showError("Can't open editor", null, (Throwable)e);
            return null;
        }
    }
}

