/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class UnicodeReader
extends Reader {
    private static final int BOM_SIZE = 4;
    private final InputStreamReader reader;

    public UnicodeReader(InputStream in, Charset defaultCharset) throws IOException {
        int unread;
        Charset encoding;
        byte[] bom = new byte[4];
        PushbackInputStream pushbackStream = new PushbackInputStream(in, 4);
        int n = pushbackStream.read(bom, 0, bom.length);
        if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            encoding = StandardCharsets.UTF_8;
            unread = n - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            encoding = StandardCharsets.UTF_16BE;
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            encoding = StandardCharsets.UTF_16LE;
            unread = n - 2;
        } else if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            encoding = Charset.forName("UTF-32BE");
            unread = n - 4;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            encoding = Charset.forName("UTF-32LE");
            unread = n - 4;
        } else {
            encoding = defaultCharset;
            unread = n;
        }
        if (unread > 0) {
            pushbackStream.unread(bom, n - unread, unread);
        } else if (unread < -1) {
            pushbackStream.unread(bom, 0, 0);
        }
        this.reader = encoding == null ? new InputStreamReader(pushbackStream) : new InputStreamReader((InputStream)pushbackStream, encoding);
    }

    public String getEncoding() {
        return this.reader.getEncoding();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.reader.read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

