﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/servicediscovery/ServiceDiscovery_EXPORTS.h>
#include <aws/servicediscovery/model/SOA.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ServiceDiscovery {
namespace Model {

/**
 * <p>A complex type that contains the ID for the Route 53 hosted zone that Cloud
 * Map creates when you create a namespace.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DnsProperties">AWS
 * API Reference</a></p>
 */
class DnsProperties {
 public:
  AWS_SERVICEDISCOVERY_API DnsProperties() = default;
  AWS_SERVICEDISCOVERY_API DnsProperties(Aws::Utils::Json::JsonView jsonValue);
  AWS_SERVICEDISCOVERY_API DnsProperties& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SERVICEDISCOVERY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID for the Route 53 hosted zone that Cloud Map creates when you create a
   * namespace.</p>
   */
  inline const Aws::String& GetHostedZoneId() const { return m_hostedZoneId; }
  inline bool HostedZoneIdHasBeenSet() const { return m_hostedZoneIdHasBeenSet; }
  template <typename HostedZoneIdT = Aws::String>
  void SetHostedZoneId(HostedZoneIdT&& value) {
    m_hostedZoneIdHasBeenSet = true;
    m_hostedZoneId = std::forward<HostedZoneIdT>(value);
  }
  template <typename HostedZoneIdT = Aws::String>
  DnsProperties& WithHostedZoneId(HostedZoneIdT&& value) {
    SetHostedZoneId(std::forward<HostedZoneIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Start of Authority (SOA) record for the hosted zone.</p>
   */
  inline const SOA& GetSOA() const { return m_sOA; }
  inline bool SOAHasBeenSet() const { return m_sOAHasBeenSet; }
  template <typename SOAT = SOA>
  void SetSOA(SOAT&& value) {
    m_sOAHasBeenSet = true;
    m_sOA = std::forward<SOAT>(value);
  }
  template <typename SOAT = SOA>
  DnsProperties& WithSOA(SOAT&& value) {
    SetSOA(std::forward<SOAT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_hostedZoneId;

  SOA m_sOA;
  bool m_hostedZoneIdHasBeenSet = false;
  bool m_sOAHasBeenSet = false;
};

}  // namespace Model
}  // namespace ServiceDiscovery
}  // namespace Aws
