﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/route53/Route53_EXPORTS.h>

namespace Aws {
namespace Route53 {
namespace Model {
enum class ChangeStatus { NOT_SET, PENDING, INSYNC };

namespace ChangeStatusMapper {
AWS_ROUTE53_API ChangeStatus GetChangeStatusForName(const Aws::String& name);

AWS_ROUTE53_API Aws::String GetNameForChangeStatus(ChangeStatus value);
}  // namespace ChangeStatusMapper
}  // namespace Model
}  // namespace Route53
}  // namespace Aws
