﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codeartifact/CodeArtifact_EXPORTS.h>
#include <aws/codeartifact/model/AssetSummary.h>
#include <aws/codeartifact/model/PackageFormat.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeArtifact {
namespace Model {
class ListPackageVersionAssetsResult {
 public:
  AWS_CODEARTIFACT_API ListPackageVersionAssetsResult() = default;
  AWS_CODEARTIFACT_API ListPackageVersionAssetsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODEARTIFACT_API ListPackageVersionAssetsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The format of the package that contains the requested package version
   * assets. </p>
   */
  inline PackageFormat GetFormat() const { return m_format; }
  inline void SetFormat(PackageFormat value) {
    m_formatHasBeenSet = true;
    m_format = value;
  }
  inline ListPackageVersionAssetsResult& WithFormat(PackageFormat value) {
    SetFormat(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The namespace of the package version that contains the requested package
   * version assets. The package component that specifies its namespace depends on
   * its type. For example:</p> <ul> <li> <p> The namespace of a Maven package
   * version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm
   * or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The
   * namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p>
   * Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding
   * component, package versions of those formats do not have a namespace. </p> </li>
   * </ul>
   */
  inline const Aws::String& GetNamespace() const { return m_namespace; }
  template <typename NamespaceT = Aws::String>
  void SetNamespace(NamespaceT&& value) {
    m_namespaceHasBeenSet = true;
    m_namespace = std::forward<NamespaceT>(value);
  }
  template <typename NamespaceT = Aws::String>
  ListPackageVersionAssetsResult& WithNamespace(NamespaceT&& value) {
    SetNamespace(std::forward<NamespaceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The name of the package that contains the requested package version assets.
   * </p>
   */
  inline const Aws::String& GetPackage() const { return m_package; }
  template <typename PackageT = Aws::String>
  void SetPackage(PackageT&& value) {
    m_packageHasBeenSet = true;
    m_package = std::forward<PackageT>(value);
  }
  template <typename PackageT = Aws::String>
  ListPackageVersionAssetsResult& WithPackage(PackageT&& value) {
    SetPackage(std::forward<PackageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The version of the package associated with the requested assets. </p>
   */
  inline const Aws::String& GetVersion() const { return m_version; }
  template <typename VersionT = Aws::String>
  void SetVersion(VersionT&& value) {
    m_versionHasBeenSet = true;
    m_version = std::forward<VersionT>(value);
  }
  template <typename VersionT = Aws::String>
  ListPackageVersionAssetsResult& WithVersion(VersionT&& value) {
    SetVersion(std::forward<VersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The current revision associated with the package version. </p>
   */
  inline const Aws::String& GetVersionRevision() const { return m_versionRevision; }
  template <typename VersionRevisionT = Aws::String>
  void SetVersionRevision(VersionRevisionT&& value) {
    m_versionRevisionHasBeenSet = true;
    m_versionRevision = std::forward<VersionRevisionT>(value);
  }
  template <typename VersionRevisionT = Aws::String>
  ListPackageVersionAssetsResult& WithVersionRevision(VersionRevisionT&& value) {
    SetVersionRevision(std::forward<VersionRevisionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> If there are additional results, this is the token for the next set of
   * results. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListPackageVersionAssetsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The returned list of <a
   * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a>
   * objects. </p>
   */
  inline const Aws::Vector<AssetSummary>& GetAssets() const { return m_assets; }
  template <typename AssetsT = Aws::Vector<AssetSummary>>
  void SetAssets(AssetsT&& value) {
    m_assetsHasBeenSet = true;
    m_assets = std::forward<AssetsT>(value);
  }
  template <typename AssetsT = Aws::Vector<AssetSummary>>
  ListPackageVersionAssetsResult& WithAssets(AssetsT&& value) {
    SetAssets(std::forward<AssetsT>(value));
    return *this;
  }
  template <typename AssetsT = AssetSummary>
  ListPackageVersionAssetsResult& AddAssets(AssetsT&& value) {
    m_assetsHasBeenSet = true;
    m_assets.emplace_back(std::forward<AssetsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListPackageVersionAssetsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  PackageFormat m_format{PackageFormat::NOT_SET};

  Aws::String m_namespace;

  Aws::String m_package;

  Aws::String m_version;

  Aws::String m_versionRevision;

  Aws::String m_nextToken;

  Aws::Vector<AssetSummary> m_assets;

  Aws::String m_requestId;
  bool m_formatHasBeenSet = false;
  bool m_namespaceHasBeenSet = false;
  bool m_packageHasBeenSet = false;
  bool m_versionHasBeenSet = false;
  bool m_versionRevisionHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_assetsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeArtifact
}  // namespace Aws
