/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * This file was generated by the dom/make_names.pl script.
 *
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2013 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#if ENABLE(MATHML)

#include "MathMLElementFactory.h"

#include "MathMLNames.h"

#include "MathMLAnnotationElement.h"
#include "MathMLSelectElement.h"
#include "MathMLPresentationElement.h"
#include "MathMLMathElement.h"
#include "MathMLMencloseElement.h"
#include "MathMLRowElement.h"
#include "MathMLFractionElement.h"
#include "MathMLTokenElement.h"
#include "MathMLScriptsElement.h"
#include "MathMLOperatorElement.h"
#include "MathMLUnderOverElement.h"
#include "MathMLPaddedElement.h"
#include "MathMLRootElement.h"
#include "MathMLSpaceElement.h"
#include "MathMLUnknownElement.h"

#include "DeprecatedGlobalSettings.h"
#include "Document.h"
#include "NodeName.h"
#include "Settings.h"
#include "TagName.h"

namespace WebCore {

static Ref<MathMLElement> annotationConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLAnnotationElement::create(tagName, document);
}

static Ref<MathMLElement> selectConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLSelectElement::create(tagName, document);
}

static Ref<MathMLElement> presentationConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLPresentationElement::create(tagName, document);
}

static Ref<MathMLElement> mathConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLMathElement::create(tagName, document);
}

static Ref<MathMLElement> mencloseConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLMencloseElement::create(tagName, document);
}

static Ref<MathMLElement> rowConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLRowElement::create(tagName, document);
}

static Ref<MathMLElement> fractionConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLFractionElement::create(tagName, document);
}

static Ref<MathMLElement> tokenConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLTokenElement::create(tagName, document);
}

static Ref<MathMLElement> scriptsConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLScriptsElement::create(tagName, document);
}

static Ref<MathMLElement> operatorConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLOperatorElement::create(tagName, document);
}

static Ref<MathMLElement> underoverConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLUnderOverElement::create(tagName, document);
}

static Ref<MathMLElement> paddedConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLPaddedElement::create(tagName, document);
}

static Ref<MathMLElement> rootConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLRootElement::create(tagName, document);
}

static Ref<MathMLElement> spaceConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLSpaceElement::create(tagName, document);
}


RefPtr<MathMLElement> MathMLElementFactory::createKnownElement(TagName tagName, Document& document, bool createdByParser)
{
    switch (tagName) {
    case TagName::annotation:
        return annotationConstructor(MathMLNames::annotationTag, document, createdByParser);
    case TagName::annotation_xml:
        return annotationConstructor(MathMLNames::annotation_xmlTag, document, createdByParser);
    case TagName::maction:
        return selectConstructor(MathMLNames::mactionTag, document, createdByParser);
    case TagName::maligngroup:
        return presentationConstructor(MathMLNames::maligngroupTag, document, createdByParser);
    case TagName::malignmark:
        return presentationConstructor(MathMLNames::malignmarkTag, document, createdByParser);
    case TagName::math:
        return mathConstructor(MathMLNames::mathTag, document, createdByParser);
    case TagName::menclose:
        return mencloseConstructor(MathMLNames::mencloseTag, document, createdByParser);
    case TagName::merror:
        return rowConstructor(MathMLNames::merrorTag, document, createdByParser);
    case TagName::mfenced:
        return rowConstructor(MathMLNames::mfencedTag, document, createdByParser);
    case TagName::mfrac:
        return fractionConstructor(MathMLNames::mfracTag, document, createdByParser);
    case TagName::mglyph:
        return presentationConstructor(MathMLNames::mglyphTag, document, createdByParser);
    case TagName::mi:
        return tokenConstructor(MathMLNames::miTag, document, createdByParser);
    case TagName::mlabeledtr:
        return presentationConstructor(MathMLNames::mlabeledtrTag, document, createdByParser);
    case TagName::mlongdiv:
        return presentationConstructor(MathMLNames::mlongdivTag, document, createdByParser);
    case TagName::mmultiscripts:
        return scriptsConstructor(MathMLNames::mmultiscriptsTag, document, createdByParser);
    case TagName::mn:
        return tokenConstructor(MathMLNames::mnTag, document, createdByParser);
    case TagName::mo:
        return operatorConstructor(MathMLNames::moTag, document, createdByParser);
    case TagName::mover:
        return underoverConstructor(MathMLNames::moverTag, document, createdByParser);
    case TagName::mpadded:
        return paddedConstructor(MathMLNames::mpaddedTag, document, createdByParser);
    case TagName::mphantom:
        return rowConstructor(MathMLNames::mphantomTag, document, createdByParser);
    case TagName::mprescripts:
        return presentationConstructor(MathMLNames::mprescriptsTag, document, createdByParser);
    case TagName::mroot:
        return rootConstructor(MathMLNames::mrootTag, document, createdByParser);
    case TagName::mrow:
        return rowConstructor(MathMLNames::mrowTag, document, createdByParser);
    case TagName::ms:
        return tokenConstructor(MathMLNames::msTag, document, createdByParser);
    case TagName::mscarries:
        return presentationConstructor(MathMLNames::mscarriesTag, document, createdByParser);
    case TagName::mscarry:
        return presentationConstructor(MathMLNames::mscarryTag, document, createdByParser);
    case TagName::msgroup:
        return presentationConstructor(MathMLNames::msgroupTag, document, createdByParser);
    case TagName::msline:
        return presentationConstructor(MathMLNames::mslineTag, document, createdByParser);
    case TagName::mspace:
        return spaceConstructor(MathMLNames::mspaceTag, document, createdByParser);
    case TagName::msqrt:
        return rootConstructor(MathMLNames::msqrtTag, document, createdByParser);
    case TagName::msrow:
        return presentationConstructor(MathMLNames::msrowTag, document, createdByParser);
    case TagName::mstack:
        return presentationConstructor(MathMLNames::mstackTag, document, createdByParser);
    case TagName::mstyle:
        return rowConstructor(MathMLNames::mstyleTag, document, createdByParser);
    case TagName::msub:
        return scriptsConstructor(MathMLNames::msubTag, document, createdByParser);
    case TagName::msubsup:
        return scriptsConstructor(MathMLNames::msubsupTag, document, createdByParser);
    case TagName::msup:
        return scriptsConstructor(MathMLNames::msupTag, document, createdByParser);
    case TagName::mtable:
        return presentationConstructor(MathMLNames::mtableTag, document, createdByParser);
    case TagName::mtd:
        return presentationConstructor(MathMLNames::mtdTag, document, createdByParser);
    case TagName::mtext:
        return tokenConstructor(MathMLNames::mtextTag, document, createdByParser);
    case TagName::mtr:
        return presentationConstructor(MathMLNames::mtrTag, document, createdByParser);
    case TagName::munder:
        return underoverConstructor(MathMLNames::munderTag, document, createdByParser);
    case TagName::munderover:
        return underoverConstructor(MathMLNames::munderoverTag, document, createdByParser);
    case TagName::none:
        return presentationConstructor(MathMLNames::noneTag, document, createdByParser);
    case TagName::semantics:
        return selectConstructor(MathMLNames::semanticsTag, document, createdByParser);
    default:
        return nullptr;
    }
}

RefPtr<MathMLElement> MathMLElementFactory::createKnownElementWithName(TagName tagName, const QualifiedName& name, Document& document, bool createdByParser)
{
    switch (tagName) {
    case TagName::annotation:
        return annotationConstructor(name, document, createdByParser);
    case TagName::annotation_xml:
        return annotationConstructor(name, document, createdByParser);
    case TagName::maction:
        return selectConstructor(name, document, createdByParser);
    case TagName::maligngroup:
        return presentationConstructor(name, document, createdByParser);
    case TagName::malignmark:
        return presentationConstructor(name, document, createdByParser);
    case TagName::math:
        return mathConstructor(name, document, createdByParser);
    case TagName::menclose:
        return mencloseConstructor(name, document, createdByParser);
    case TagName::merror:
        return rowConstructor(name, document, createdByParser);
    case TagName::mfenced:
        return rowConstructor(name, document, createdByParser);
    case TagName::mfrac:
        return fractionConstructor(name, document, createdByParser);
    case TagName::mglyph:
        return presentationConstructor(name, document, createdByParser);
    case TagName::mi:
        return tokenConstructor(name, document, createdByParser);
    case TagName::mlabeledtr:
        return presentationConstructor(name, document, createdByParser);
    case TagName::mlongdiv:
        return presentationConstructor(name, document, createdByParser);
    case TagName::mmultiscripts:
        return scriptsConstructor(name, document, createdByParser);
    case TagName::mn:
        return tokenConstructor(name, document, createdByParser);
    case TagName::mo:
        return operatorConstructor(name, document, createdByParser);
    case TagName::mover:
        return underoverConstructor(name, document, createdByParser);
    case TagName::mpadded:
        return paddedConstructor(name, document, createdByParser);
    case TagName::mphantom:
        return rowConstructor(name, document, createdByParser);
    case TagName::mprescripts:
        return presentationConstructor(name, document, createdByParser);
    case TagName::mroot:
        return rootConstructor(name, document, createdByParser);
    case TagName::mrow:
        return rowConstructor(name, document, createdByParser);
    case TagName::ms:
        return tokenConstructor(name, document, createdByParser);
    case TagName::mscarries:
        return presentationConstructor(name, document, createdByParser);
    case TagName::mscarry:
        return presentationConstructor(name, document, createdByParser);
    case TagName::msgroup:
        return presentationConstructor(name, document, createdByParser);
    case TagName::msline:
        return presentationConstructor(name, document, createdByParser);
    case TagName::mspace:
        return spaceConstructor(name, document, createdByParser);
    case TagName::msqrt:
        return rootConstructor(name, document, createdByParser);
    case TagName::msrow:
        return presentationConstructor(name, document, createdByParser);
    case TagName::mstack:
        return presentationConstructor(name, document, createdByParser);
    case TagName::mstyle:
        return rowConstructor(name, document, createdByParser);
    case TagName::msub:
        return scriptsConstructor(name, document, createdByParser);
    case TagName::msubsup:
        return scriptsConstructor(name, document, createdByParser);
    case TagName::msup:
        return scriptsConstructor(name, document, createdByParser);
    case TagName::mtable:
        return presentationConstructor(name, document, createdByParser);
    case TagName::mtd:
        return presentationConstructor(name, document, createdByParser);
    case TagName::mtext:
        return tokenConstructor(name, document, createdByParser);
    case TagName::mtr:
        return presentationConstructor(name, document, createdByParser);
    case TagName::munder:
        return underoverConstructor(name, document, createdByParser);
    case TagName::munderover:
        return underoverConstructor(name, document, createdByParser);
    case TagName::none:
        return presentationConstructor(name, document, createdByParser);
    case TagName::semantics:
        return selectConstructor(name, document, createdByParser);
    default:
        return nullptr;
    }
}

RefPtr<MathMLElement> MathMLElementFactory::createKnownElement(const AtomString& localName, Document& document, bool createdByParser)
{
    return createKnownElement(tagNameForElementName(findMathMLElementName(localName)), document, createdByParser);
}

RefPtr<MathMLElement> MathMLElementFactory::createKnownElement(const QualifiedName& name, Document& document, bool createdByParser)
{
    return createKnownElementWithName(tagNameForElementName(name.nodeName()), name, document, createdByParser);
}

Ref<MathMLElement> MathMLElementFactory::createElement(const AtomString& localName, Document& document, bool createdByParser)
{
    auto elementName = findMathMLElementName(localName);
    if (elementName != ElementName::Unknown)
        return createKnownElement(tagNameForElementName(elementName), document, createdByParser).releaseNonNull();
    return MathMLUnknownElement::create(QualifiedName(nullAtom(), localName, MathMLNames::mathmlNamespaceURI), document);
}

Ref<MathMLElement> MathMLElementFactory::createElement(const QualifiedName& name, Document& document, bool createdByParser)
{
    auto elementName = name.nodeName();
    if (elementName != ElementName::Unknown) {
        if (auto result = createKnownElementWithName(tagNameForElementName(elementName), name, document, createdByParser))
            return result.releaseNonNull();
    }
    return MathMLUnknownElement::create(name, document);
}

} // namespace WebCore

#endif
