/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSScrollAxis.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ScrollAxis enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 4> values {
        MAKE_STATIC_STRING_IMPL("block"),
        MAKE_STATIC_STRING_IMPL("inline"),
        MAKE_STATIC_STRING_IMPL("x"),
        MAKE_STATIC_STRING_IMPL("y"),
    };
    static_assert(static_cast<size_t>(ScrollAxis::Block) == 0, "ScrollAxis::Block is not 0 as expected");
    static_assert(static_cast<size_t>(ScrollAxis::Inline) == 1, "ScrollAxis::Inline is not 1 as expected");
    static_assert(static_cast<size_t>(ScrollAxis::X) == 2, "ScrollAxis::X is not 2 as expected");
    static_assert(static_cast<size_t>(ScrollAxis::Y) == 3, "ScrollAxis::Y is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ScrollAxis enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ScrollAxis> parseEnumerationFromString<ScrollAxis>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, ScrollAxis>, 4> mappings {
        std::pair<ComparableASCIILiteral, ScrollAxis> { "block"_s, ScrollAxis::Block },
        std::pair<ComparableASCIILiteral, ScrollAxis> { "inline"_s, ScrollAxis::Inline },
        std::pair<ComparableASCIILiteral, ScrollAxis> { "x"_s, ScrollAxis::X },
        std::pair<ComparableASCIILiteral, ScrollAxis> { "y"_s, ScrollAxis::Y },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ScrollAxis> parseEnumeration<ScrollAxis>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ScrollAxis>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<ScrollAxis>()
{
    return "\"block\", \"inline\", \"x\", \"y\""_s;
}

} // namespace WebCore

