/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSImageDataSettings.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertOptional.h"
#include "JSImageDataStorageFormat.h"
#include "JSPredefinedColorSpace.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<ImageDataSettings>> convertDictionary<ImageDataSettings>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ImageDataSettings result;
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().canvasColorSpaceEnabled) {
        JSValue colorSpaceValue;
        if (isNullOrUndefined)
            colorSpaceValue = jsUndefined();
        else {
            colorSpaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorSpace"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        if (!colorSpaceValue.isUndefined()) {
            auto colorSpaceConversionResult = convert<IDLEnumeration<PredefinedColorSpace>>(lexicalGlobalObject, colorSpaceValue);
            if (colorSpaceConversionResult.hasException(throwScope)) [[unlikely]]
                return ConversionResultException { };
            result.colorSpace = colorSpaceConversionResult.releaseReturnValue();
        }
    }
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().canvasPixelFormatEnabled) {
        JSValue storageFormatValue;
        if (isNullOrUndefined)
            storageFormatValue = jsUndefined();
        else {
            storageFormatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "storageFormat"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        auto storageFormatConversionResult = convertOptionalWithDefault<IDLEnumeration<ImageDataStorageFormat>>(lexicalGlobalObject, storageFormatValue, [&]() -> ConversionResult<IDLEnumeration<ImageDataStorageFormat>> { return Converter<IDLEnumeration<ImageDataStorageFormat>>::ReturnType { ImageDataStorageFormat::Uint8 }; });
        if (storageFormatConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.storageFormat = storageFormatConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore

