/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFetchReferrerPolicy.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FetchReferrerPolicy enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 9> values {
        emptyString(),
        MAKE_STATIC_STRING_IMPL("no-referrer"),
        MAKE_STATIC_STRING_IMPL("no-referrer-when-downgrade"),
        MAKE_STATIC_STRING_IMPL("same-origin"),
        MAKE_STATIC_STRING_IMPL("origin"),
        MAKE_STATIC_STRING_IMPL("strict-origin"),
        MAKE_STATIC_STRING_IMPL("origin-when-cross-origin"),
        MAKE_STATIC_STRING_IMPL("strict-origin-when-cross-origin"),
        MAKE_STATIC_STRING_IMPL("unsafe-url"),
    };
    static_assert(static_cast<size_t>(FetchReferrerPolicy::EmptyString) == 0, "FetchReferrerPolicy::EmptyString is not 0 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::NoReferrer) == 1, "FetchReferrerPolicy::NoReferrer is not 1 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::NoReferrerWhenDowngrade) == 2, "FetchReferrerPolicy::NoReferrerWhenDowngrade is not 2 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::SameOrigin) == 3, "FetchReferrerPolicy::SameOrigin is not 3 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::Origin) == 4, "FetchReferrerPolicy::Origin is not 4 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::StrictOrigin) == 5, "FetchReferrerPolicy::StrictOrigin is not 5 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::OriginWhenCrossOrigin) == 6, "FetchReferrerPolicy::OriginWhenCrossOrigin is not 6 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::StrictOriginWhenCrossOrigin) == 7, "FetchReferrerPolicy::StrictOriginWhenCrossOrigin is not 7 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::UnsafeUrl) == 8, "FetchReferrerPolicy::UnsafeUrl is not 8 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, FetchReferrerPolicy enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<FetchReferrerPolicy> parseEnumerationFromString<FetchReferrerPolicy>(const String& stringValue)
{
    if (stringValue.isEmpty())
        return FetchReferrerPolicy::EmptyString;
    static constexpr std::array<std::pair<ComparableASCIILiteral, FetchReferrerPolicy>, 8> mappings {
        std::pair<ComparableASCIILiteral, FetchReferrerPolicy> { "no-referrer"_s, FetchReferrerPolicy::NoReferrer },
        std::pair<ComparableASCIILiteral, FetchReferrerPolicy> { "no-referrer-when-downgrade"_s, FetchReferrerPolicy::NoReferrerWhenDowngrade },
        std::pair<ComparableASCIILiteral, FetchReferrerPolicy> { "origin"_s, FetchReferrerPolicy::Origin },
        std::pair<ComparableASCIILiteral, FetchReferrerPolicy> { "origin-when-cross-origin"_s, FetchReferrerPolicy::OriginWhenCrossOrigin },
        std::pair<ComparableASCIILiteral, FetchReferrerPolicy> { "same-origin"_s, FetchReferrerPolicy::SameOrigin },
        std::pair<ComparableASCIILiteral, FetchReferrerPolicy> { "strict-origin"_s, FetchReferrerPolicy::StrictOrigin },
        std::pair<ComparableASCIILiteral, FetchReferrerPolicy> { "strict-origin-when-cross-origin"_s, FetchReferrerPolicy::StrictOriginWhenCrossOrigin },
        std::pair<ComparableASCIILiteral, FetchReferrerPolicy> { "unsafe-url"_s, FetchReferrerPolicy::UnsafeUrl },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<FetchReferrerPolicy> parseEnumeration<FetchReferrerPolicy>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<FetchReferrerPolicy>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<FetchReferrerPolicy>()
{
    return "\"\", \"no-referrer\", \"no-referrer-when-downgrade\", \"same-origin\", \"origin\", \"strict-origin\", \"origin-when-cross-origin\", \"strict-origin-when-cross-origin\", \"unsafe-url\""_s;
}

} // namespace WebCore

