/*
 * Copyright (C) 2022-2023 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "SerializedTypeInfo.h"

#include "APIArray.h"
#include "APIDictionary.h"
#include "APIError.h"
#include "APIFrameHandle.h"
#include "APIGeometry.h"
#include "APINumber.h"
#include "APIObject.h"
#include "APIPageHandle.h"
#include "APIString.h"
#include "APIURL.h"
#include "APIURLRequest.h"
#include "APIURLResponse.h"
#include "APIUserContentURLPattern.h"
#include "AccessibilityPreferences.h"
#include "ArgumentCoders.h"
#include "ArgumentCoders.h"
#if USE(SOUP)
#include "ArgumentCodersGLib.h"
#endif
#if PLATFORM(GTK)
#include "ArgumentCodersGtk.h"
#endif
#if USE(UNIX_DOMAIN_SOCKETS)
#include "ArgumentCodersUnix.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "AudioTrackPrivateRemoteConfiguration.h"
#endif
#include "AuthenticationChallengeDisposition.h"
#include "AuxiliaryProcessCreationParameters.h"
#if ENABLE(MODEL_PROCESS)
#include "AuxiliaryProcessCreationParameters.h"
#endif
#include "BackgroundFetchChange.h"
#include "BackgroundFetchState.h"
#if ENABLE(GPU_PROCESS)
#include "BufferIdentifierSet.h"
#endif
#include "CacheModel.h"
#include "CallbackID.h"
#include "ConnectionHandle.h"
#include "ContentWorldData.h"
#if ENABLE(CONTEXT_MENUS)
#include "ContextMenuContextData.h"
#endif
#include "CoordinateSystem.h"
#if USE(SKIA)
#include "CoreIPCSkColorSpace.h"
#endif
#if USE(SKIA)
#include "CoreIPCSkData.h"
#endif
#if USE(SKIA)
#include "CoreIPCSkFontStyleSlant.h"
#endif
#if USE(SKIA)
#include "CoreIPCSkString.h"
#endif
#include "DebuggableInfoData.h"
#if PLATFORM(IOS_FAMILY)
#include "DocumentEditingContext.h"
#endif
#include "DragControllerAction.h"
#include "EditingRange.h"
#include "EditorState.h"
#include "FileSystemStorageError.h"
#include "FileSystemSyncAccessHandleInfo.h"
#include "FocusedElementInformation.h"
#include "FormDataReference.h"
#include "FrameInfoData.h"
#include "FrameTreeCreationParameters.h"
#include "FrameTreeNodeData.h"
#include "FullScreenMediaDetails.h"
#if ENABLE(GPU_PROCESS)
#include "GPUProcessConnectionInfo.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "GPUProcessConnectionParameters.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "GPUProcessCreationParameters.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "GPUProcessPreferences.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "GPUProcessSessionParameters.h"
#endif
#if ENABLE(GAMEPAD)
#include "GamepadData.h"
#endif
#include "GeneratedWebKitSecureCoding.h"
#include "GoToBackForwardItemParameters.h"
#include "IPCEvent.h"
#include "IPCSemaphore.h"
#include "ITPThirdPartyData.h"
#include "ITPThirdPartyDataForSpecificFirstParty.h"
#include "ImageBufferBackendHandle.h"
#include "ImageOptions.h"
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
#include "InitializationSegmentInfo.h"
#endif
#include "InjectUserScriptImmediately.h"
#include "InputMethodState.h"
#include "InspectorExtensionTypes.h"
#include "JavaScriptEvaluationResult.h"
#include "LayerTreeContext.h"
#include "LoadParameters.h"
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
#include "MediaDescriptionInfo.h"
#endif
#if ENABLE(MEDIA_STREAM)
#include "MediaDeviceSandboxExtensions.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "MediaOverridesForTesting.h"
#endif
#include "MediaPlaybackState.h"
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "MediaPlayerPrivateRemote.h"
#endif
#include "MessageFlags.h"
#if ENABLE(ARKIT_INLINE_PREVIEW)
#include "ModelIdentifier.h"
#endif
#if ENABLE(MODEL_PROCESS)
#include "ModelProcessConnectionInfo.h"
#endif
#if ENABLE(MODEL_PROCESS)
#include "ModelProcessConnectionParameters.h"
#endif
#if ENABLE(MODEL_PROCESS)
#include "ModelProcessCreationParameters.h"
#endif
#include "MonotonicObjectIdentifier.h"
#include "NavigationActionData.h"
#include "NetworkProcessConnectionInfo.h"
#include "NetworkProcessConnectionParameters.h"
#include "NetworkProcessCreationParameters.h"
#include "NetworkResourceLoadParameters.h"
#include "NetworkSessionCreationParameters.h"
#include "NodeInfo.h"
#include "PlatformFontInfo.h"
#include "PlatformPopupMenuData.h"
#include "PolicyDecision.h"
#if ENABLE(GPU_PROCESS) && PLATFORM(COCOA)
#include "PrepareBackingStoreBuffersData.h"
#endif
#include "PrintInfo.h"
#include "PrivateClickMeasurementManagerInterface.h"
#include "ProvisionalFrameCreationParameters.h"
#if USE(LIBWEBRTC)
#include "RTCNetwork.h"
#endif
#if USE(LIBWEBRTC)
#include "RTCPacketOptions.h"
#endif
#if (USE(LIBWEBRTC)) && (USE(LIBWEBRTC) && PLATFORM(COCOA))
#include "RTCWebKitEncodedFrameInfo.h"
#endif
#if ENABLE(GPU_PROCESS) && USE(AUDIO_SESSION)
#include "RemoteAudioSessionConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
#include "RemoteCDMConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
#include "RemoteCDMInstanceConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "RemoteGPURequestAdapterResponse.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#include "RemoteGraphicsContextGLInitializationState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "RemoteImageBufferSetConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS) && PLATFORM(COCOA)
#include "RemoteImageBufferSetIdentifier.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "RemoteMediaPlayerConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "RemoteMediaPlayerProxyConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "RemoteMediaPlayerState.h"
#endif
#if ENABLE(GPU_PROCESS) && PLATFORM(IOS_FAMILY)
#include "RemoteMediaSessionHelper.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "RemoteSerializedImageBufferIdentifier.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "RemoteTrackInfo.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "RemoteVideoFrameIdentifier.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "RemoteVideoFrameProxyProperties.h"
#endif
#if ENABLE(TOUCH_EVENTS)
#include "RemoteWebTouchEvent.h"
#endif
#include "RemoteWorkerInitializationData.h"
#include "RemoteWorkerType.h"
#include "RendererBufferFormat.h"
#include "ResourceLoadInfo.h"
#include "ResourceLoadStatisticsParameters.h"
#include "RunJavaScriptParameters.h"
#include "SameDocumentNavigationType.h"
#include "ScriptTrackingPrivacyFilter.h"
#if ENABLE(MOMENTUM_EVENT_DISPATCHER)
#include "ScrollingAccelerationCurve.h"
#endif
#include "SessionState.h"
#include "SharedBufferReference.h"
#include "SharedFileHandle.h"
#include "SharedPreferencesForWebProcess.h"
#if ENABLE(GPU_PROCESS) && PLATFORM(COCOA) && ENABLE(VIDEO)
#include "SharedVideoFrame.h"
#endif
#include "StorageAccessStatus.h"
#include "StreamConnectionEncoder.h"
#include "StreamConnectionEncoder.h"
#include "StreamServerConnection.h"
#include "SyntheticEditingCommandType.h"
#include "TextRecognitionUpdateResult.h"
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "TextTrackPrivateRemoteConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "TrackPrivateRemoteConfiguration.h"
#endif
#include "URLSchemeTaskParameters.h"
#include "UndoOrRedo.h"
#include "UnifiedOriginStorageLevel.h"
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
#include "UpdateInfo.h"
#endif
#include "UserContentControllerParameters.h"
#include "UserData.h"
#include "UserMessage.h"
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "VideoTrackPrivateRemoteConfiguration.h"
#endif
#if ENABLE(UI_SIDE_COMPOSITING)
#include "VisibleContentRectUpdateInfo.h"
#endif
#include "WebBackForwardListCounts.h"
#if ENABLE(CONTENT_EXTENSIONS)
#include "WebCompiledContentRuleListData.h"
#endif
#if ENABLE(CONTEXT_MENUS)
#include "WebContextMenuItemData.h"
#endif
#include "WebEvent.h"
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtension.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS_SIDEBAR)
#include "WebExtensionActionClickBehavior.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionAlarmParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS_BOOKMARKS)
#include "WebExtensionBookmarksParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionCommandParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionContentWorldType.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionContext.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionContextParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionControllerParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionCookieParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionDataType.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionEventListenerType.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionFrameParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionMatchedRuleParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionMenuItemContextParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionMenuItemParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionMessageSenderParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionMessageTargetParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionRegisteredScriptParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionScriptInjectionParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionScriptInjectionResultParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS_SIDEBAR)
#include "WebExtensionSidebarParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionStorageAccessLevel.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionTab.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionTabParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionTabQueryParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionWindow.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionWindowParameters.h"
#endif
#include "WebFindOptions.h"
#include "WebFoundTextRange.h"
#include "WebFrameMetrics.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUBindGroupDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBindGroupEntry.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBindGroupLayoutDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBindGroupLayoutEntry.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBlendComponent.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBlendState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBufferBinding.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBufferBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBufferDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUCanvasConfiguration.h"
#endif
#include "WebGPUColor.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUColorTargetState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUCommandBufferDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUCommandEncoderDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUCompilationMessage.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUComputePassDescriptor.h"
#endif
#include "WebGPUComputePassTimestampWrites.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUComputePipelineDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUDepthStencilState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUDeviceDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUError.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUExtent3D.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUExternalTextureBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUExternalTextureDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUFragmentState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageCopyBuffer.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageCopyExternalImage.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageCopyTexture.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageCopyTextureTagged.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageDataLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUInternalError.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUMultisampleState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUObjectDescriptorBase.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUOrigin2D.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUOrigin3D.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUOutOfMemoryError.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUPipelineDescriptorBase.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUPipelineLayoutDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUPresentationContextDescriptor.h"
#endif
#include "WebGPUPrimitiveState.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUPrimitiveState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUProgrammableStage.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUQuerySetDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderBundleDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderBundleEncoderDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPassColorAttachment.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPassDepthStencilAttachment.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPassDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPassLayout.h"
#endif
#include "WebGPURenderPassTimestampWrites.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPipelineDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURequestAdapterOptions.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUSamplerBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUSamplerDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUShaderModuleCompilationHint.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUShaderModuleDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUStencilFaceState.h"
#endif
#include "WebGPUStorageTextureBindingLayout.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUStorageTextureBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUSupportedFeatures.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUSupportedLimits.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUTextureBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUTextureDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUTextureViewDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUValidationError.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUVertexAttribute.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUVertexBufferLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUVertexState.h"
#endif
#if ENABLE(MAC_GESTURE_EVENTS)
#include "WebGestureEvent.h"
#endif
#include "WebHitTestResultData.h"
#include "WebIDBResult.h"
#include "WebImage.h"
#include "WebKeyboardEvent.h"
#include "WebMouseEvent.h"
#include "WebNavigationDataStore.h"
#include "WebPageCreationParameters.h"
#include "WebPageGroupData.h"
#include "WebPageNetworkParameters.h"
#include "WebPopupItem.h"
#include "WebPreferencesStore.h"
#include "WebProcessCreationParameters.h"
#include "WebProcessDataStoreParameters.h"
#include "WebPushDaemonConnectionConfiguration.h"
#include "WebPushMessage.h"
#if ENABLE(SPEECH_SYNTHESIS)
#include "WebSpeechSynthesisVoice.h"
#endif
#if ENABLE(TOUCH_EVENTS)
#include "WebTouchEvent.h"
#endif
#include "WebUserContentControllerDataTypes.h"
#include "WebWheelEvent.h"
#include "WebsiteAutoplayPolicy.h"
#include "WebsiteAutoplayQuirk.h"
#include "WebsiteData.h"
#include "WebsiteDataFetchOption.h"
#include "WebsiteDataStoreParameters.h"
#include "WebsiteDataType.h"
#include "WebsitePoliciesData.h"
#include "WebsitePopUpPolicy.h"
#include "WebsitePushAndNotificationsEnabledPolicy.h"
#if ENABLE(WEBXR)
#include "XRDeviceInfo.h"
#endif
#if (ENABLE(WEBXR)) && (USE(OPENXR))
#include "XRDeviceLayer.h"
#endif
#include <JavaScriptCore/ArrayBuffer.h>
#include <JavaScriptCore/ConsoleTypes.h>
#include <JavaScriptCore/InspectorFrontendChannel.h>
#include <JavaScriptCore/InspectorTarget.h>
#include <JavaScriptCore/SourceTaintedOrigin.h>
#include <JavaScriptCore/WasmModule.h>
#if USE(SYSTEM_PREVIEW)
#include <WebCore/ARKitBadgeSystemImage.h>
#endif
#include <WebCore/AXObjectCache.h>
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/AcceleratedEffect.h>
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/AcceleratedEffectValues.h>
#endif
#include <WebCore/AffineTransform.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/AllAcceptedCredentialsOptions.h>
#endif
#include <WebCore/Allowlist.h>
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/AnimationEffectTiming.h>
#endif
#if ENABLE(APP_HIGHLIGHTS)
#include <WebCore/AppHighlight.h>
#endif
#if USE(APPKIT)
#include <WebCore/AppKitControlSystemImage.h>
#endif
#if ENABLE(APPLE_PAY_AMS_UI) && ENABLE(PAYMENT_REQUEST)
#include <WebCore/ApplePayAMSUIRequest.h>
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
#include <WebCore/ApplePayAutomaticReloadPaymentRequest.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayButtonPart.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayContactField.h>
#endif
#if ENABLE(APPLE_PAY_COUPON_CODE)
#include <WebCore/ApplePayCouponCodeUpdate.h>
#endif
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
#include <WebCore/ApplePayDateComponents.h>
#endif
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
#include <WebCore/ApplePayDateComponentsRange.h>
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
#include <WebCore/ApplePayDeferredPaymentRequest.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayDetailsUpdateBase.h>
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
#include <WebCore/ApplePayDisbursementRequest.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayError.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayFeature.h>
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
#include <WebCore/ApplePayInstallmentConfigurationWebCore.h>
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
#include <WebCore/ApplePayInstallmentItem.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayLineItem.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayLogoSystemImage.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayPaymentAuthorizationResult.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayPaymentMethodUpdate.h>
#endif
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
#include <WebCore/ApplePayPaymentOrderDetails.h>
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
#include <WebCore/ApplePayPaymentTokenContext.h>
#endif
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
#include <WebCore/ApplePayRecurringPaymentRequest.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePaySetupConfiguration.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayShippingContactUpdate.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayShippingMethod.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayShippingMethodUpdate.h>
#endif
#if HAVE(CORE_MATERIAL)
#include <WebCore/AppleVisualEffect.h>
#endif
#if ENABLE(APPLICATION_MANIFEST)
#include <WebCore/ApplicationManifest.h>
#endif
#if PLATFORM(COCOA)
#include <WebCore/ArchiveResource.h>
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
#include <WebCore/AttachmentAssociatedElement.h>
#endif
#include <WebCore/AttributionSecondsUntilSendData.h>
#include <WebCore/AudioConfiguration.h>
#include <WebCore/AudioIOCallback.h>
#if USE(AUDIO_SESSION)
#include <WebCore/AudioSession.h>
#endif
#if ENABLE(VIDEO)
#include <WebCore/AudioTrackPrivate.h>
#endif
#include <WebCore/AuthenticationChallenge.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/AuthenticationExtensionsClientInputs.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/AuthenticationExtensionsClientOutputs.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/AuthenticatorResponseData.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/AuthenticatorSelectionCriteria.h>
#endif
#include <WebCore/AutocapitalizeTypes.h>
#include <WebCore/Autofill.h>
#include <WebCore/AutoplayEvent.h>
#include <WebCore/BackgroundFetchFailureReason.h>
#include <WebCore/BackgroundFetchInformation.h>
#include <WebCore/BackgroundFetchOptions.h>
#include <WebCore/BackgroundFetchRecordInformation.h>
#include <WebCore/BackgroundFetchRequest.h>
#include <WebCore/BackgroundFetchResult.h>
#if ENABLE(GPU_PROCESS)
#include <WebCore/BarcodeDetectorOptionsInterface.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/BarcodeFormatInterface.h>
#endif
#include <WebCore/BlobPart.h>
#include <WebCore/BufferSource.h>
#include <WebCore/ButtonPart.h>
#include <WebCore/ByteArrayPixelBuffer.h>
#if PLATFORM(COCOA)
#include <WebCore/CAAudioStreamDescription.h>
#endif
#if ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMInstance.h>
#endif
#if ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMInstanceSession.h>
#endif
#if ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMKeySystemConfiguration.h>
#endif
#if ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMMediaCapability.h>
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMPrivate.h>
#endif
#if ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMRestrictions.h>
#endif
#include <WebCore/COEPInheritenceViolationReportBody.h>
#include <WebCore/CORPViolationReportBody.h>
#include <WebCore/CSPViolationReportBody.h>
#include <WebCore/CSSFilter.h>
#include <WebCore/CSSValueKey.h>
#include <WebCore/CacheQueryOptions.h>
#include <WebCore/CanvasActivityRecord.h>
#if ENABLE(VIDEO)
#include <WebCore/CaptionUserPreferences.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/CaptureDevice.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/CaptureDeviceWithCapabilities.h>
#endif
#if PLATFORM(MAC)
#include <WebCore/CaretAnimator.h>
#endif
#include <WebCore/CertificateInfo.h>
#include <WebCore/CharacterRange.h>
#include <WebCore/ClientOrigin.h>
#include <WebCore/Color.h>
#include <WebCore/Color.h>
#include <WebCore/ColorInterpolationMethod.h>
#include <WebCore/ColorTypes.h>
#include <WebCore/ColorTypes.h>
#include <WebCore/ColorWellPart.h>
#include <WebCore/CompositionHighlight.h>
#include <WebCore/CompositionUnderline.h>
#include <WebCore/ContactInfo.h>
#include <WebCore/ContactsRequestData.h>
#if ENABLE(CONTENT_EXTENSIONS)
#include <WebCore/ContentRuleListResults.h>
#endif
#include <WebCore/ContentSecurityPolicy.h>
#include <WebCore/ContentSecurityPolicyResponseHeaders.h>
#include <WebCore/ContentType.h>
#if ENABLE(CONTEXT_MENUS)
#include <WebCore/ContextMenuContext.h>
#endif
#include <WebCore/ContextMenuItem.h>
#include <WebCore/ControlPart.h>
#include <WebCore/ControlStyle.h>
#include <WebCore/Cookie.h>
#include <WebCore/CookieChangeSubscription.h>
#include <WebCore/CookieConsentDecisionResult.h>
#include <WebCore/CookieRequestHeaderFieldProxy.h>
#include <WebCore/CookieStoreGetOptions.h>
#include <WebCore/Credential.h>
#if PLATFORM(COCOA)
#include <WebCore/Credential.h>
#endif
#if USE(CURL)
#include <WebCore/Credential.h>
#endif
#if USE(SOUP)
#include <WebCore/Credential.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/CredentialPropertiesOutput.h>
#endif
#include <WebCore/CrossOriginAccessControl.h>
#include <WebCore/CrossOriginEmbedderPolicy.h>
#include <WebCore/CrossOriginOpenerPolicy.h>
#include <WebCore/CrossSiteNavigationDataTransfer.h>
#include <WebCore/CryptoKeyData.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/CurrentUserDetailsOptions.h>
#endif
#include <WebCore/Cursor.h>
#include <WebCore/CustomHeaderFields.h>
#if USE(GBM)
#include <WebCore/DMABufBuffer.h>
#endif
#if ENABLE(DOM_AUDIO_SESSION)
#include <WebCore/DOMAudioSession.h>
#endif
#include <WebCore/DOMCacheEngine.h>
#include <WebCore/DOMPasteAccess.h>
#if USE(GBM)
#include <WebCore/DRMDevice.h>
#endif
#if ENABLE(DATA_DETECTION)
#include <WebCore/DataDetectorElementInfo.h>
#endif
#if ENABLE(DATA_DETECTION)
#include <WebCore/DataDetectorType.h>
#endif
#include <WebCore/DataListSuggestionInformation.h>
#include <WebCore/DatabaseDetails.h>
#include <WebCore/DateTimeChooserParameters.h>
#include <WebCore/DeprecationReportBody.h>
#include <WebCore/DestinationColorSpace.h>
#if ENABLE(WEB_RTC)
#include <WebCore/DetachedRTCDataChannel.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/DetectedBarcodeInterface.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/DetectedFaceInterface.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/DetectedTextInterface.h>
#endif
#include <WebCore/DeviceOrientationOrMotionPermissionState.h>
#include <WebCore/DiagnosticLoggingClient.h>
#include <WebCore/DiagnosticLoggingDomain.h>
#include <WebCore/DictationAlternative.h>
#include <WebCore/DictionaryPopupInfo.h>
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#include <WebCore/DigitalCredentialsRequestData.h>
#endif
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#include <WebCore/DigitalCredentialsResponseData.h>
#endif
#if HAVE(SCREEN_CAPTURE_KIT)
#include <WebCore/DisplayCapturePromptType.h>
#endif
#include <WebCore/DisplayListItems.h>
#include <WebCore/DisplayUpdate.h>
#include <WebCore/DistantLightSource.h>
#include <WebCore/DocumentClasses.h>
#include <WebCore/DocumentLoader.h>
#include <WebCore/DocumentStorageAccess.h>
#include <WebCore/DocumentSyncData.h>
#include <WebCore/DragData.h>
#if ENABLE(DRAG_SUPPORT)
#include <WebCore/DragData.h>
#endif
#include <WebCore/DragImage.h>
#include <WebCore/DragItem.h>
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
#include <WebCore/DynamicContentScalingDisplayList.h>
#endif
#include <WebCore/ElementAnimationContext.h>
#include <WebCore/ElementContext.h>
#include <WebCore/ElementTargetingTypes.h>
#include <WebCore/EventInit.h>
#include <WebCore/EventRegion.h>
#include <WebCore/EventTrackingRegions.h>
#include <WebCore/Exception.h>
#include <WebCore/ExceptionData.h>
#include <WebCore/ExceptionDetails.h>
#include <WebCore/FEBlend.h>
#include <WebCore/FEColorMatrix.h>
#include <WebCore/FEComponentTransfer.h>
#include <WebCore/FEComposite.h>
#include <WebCore/FEConvolveMatrix.h>
#include <WebCore/FEDiffuseLighting.h>
#include <WebCore/FEDisplacementMap.h>
#include <WebCore/FEDropShadow.h>
#include <WebCore/FEFlood.h>
#include <WebCore/FEGaussianBlur.h>
#include <WebCore/FEImage.h>
#include <WebCore/FEMerge.h>
#include <WebCore/FEMorphology.h>
#include <WebCore/FEOffset.h>
#include <WebCore/FESpecularLighting.h>
#include <WebCore/FETile.h>
#include <WebCore/FETurbulence.h>
#if ENABLE(GPU_PROCESS)
#include <WebCore/FaceDetectorOptionsInterface.h>
#endif
#include <WebCore/FetchOptions.h>
#include <WebCore/FileChooser.h>
#include <WebCore/FileSystemWriteCommandType.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/FillLightMode.h>
#endif
#include <WebCore/Filter.h>
#include <WebCore/FilterEffect.h>
#include <WebCore/FilterEffectGeometry.h>
#include <WebCore/FilterFunction.h>
#include <WebCore/FilterOperation.h>
#if !USE(COORDINATED_GRAPHICS)
#include <WebCore/FilterOperation.h>
#endif
#if !USE(COORDINATED_GRAPHICS)
#include <WebCore/FilterOperations.h>
#endif
#include <WebCore/FilterRenderingMode.h>
#include <WebCore/FixedContainerEdges.h>
#include <WebCore/FloatLine.h>
#include <WebCore/FloatPoint.h>
#include <WebCore/FloatPoint3D.h>
#include <WebCore/FloatQuad.h>
#include <WebCore/FloatRect.h>
#include <WebCore/FloatRoundedRect.h>
#include <WebCore/FloatSegment.h>
#include <WebCore/FloatSize.h>
#include <WebCore/FocusController.h>
#include <WebCore/FocusDirection.h>
#include <WebCore/FocusEventData.h>
#include <WebCore/Font.h>
#include <WebCore/FontAttributeChanges.h>
#include <WebCore/FontAttributes.h>
#include <WebCore/FontCache.h>
#include <WebCore/FontCustomPlatformData.h>
#include <WebCore/FontPlatformData.h>
#if USE(SKIA)
#include <WebCore/FontPlatformData.h>
#endif
#include <WebCore/FontSelectionAlgorithm.h>
#include <WebCore/FontShadow.h>
#include <WebCore/FontTaggedSettings.h>
#include <WebCore/FormData.h>
#include <WebCore/FourCC.h>
#include <WebCore/FrameTreeSyncData.h>
#if ENABLE(GAMEPAD)
#include <WebCore/GamepadEffectParameters.h>
#endif
#if ENABLE(GAMEPAD)
#include <WebCore/GamepadHapticEffectType.h>
#endif
#include <WebCore/GeolocationPositionData.h>
#include <WebCore/GlobalFrameIdentifier.h>
#include <WebCore/GlobalWindowIdentifier.h>
#include <WebCore/Gradient.h>
#include <WebCore/GradientColorStop.h>
#include <WebCore/GradientColorStops.h>
#if (!PLATFORM(COCOA) && ENABLE(WEBGL)) && ((PLATFORM(GTK) || PLATFORM(WPE)))
#include <WebCore/GraphicsContextGL.h>
#endif
#if ENABLE(WEBGL)
#include <WebCore/GraphicsContextGL.h>
#endif
#if PLATFORM(COCOA) && ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#include <WebCore/GraphicsContextGL.h>
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#include <WebCore/GraphicsContextGLActiveInfo.h>
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#include <WebCore/GraphicsContextGLAttributes.h>
#endif
#include <WebCore/GraphicsStyle.h>
#include <WebCore/GraphicsTypes.h>
#include <WebCore/GraphicsTypesGL.h>
#include <WebCore/HTMLModelElementCamera.h>
#include <WebCore/HTTPCookieAcceptPolicy.h>
#include <WebCore/HTTPHeaderField.h>
#include <WebCore/HTTPHeaderMap.h>
#include <WebCore/HostingContext.h>
#include <WebCore/IDBCursorInfo.h>
#include <WebCore/IDBCursorRecord.h>
#include <WebCore/IDBDatabaseIdentifier.h>
#include <WebCore/IDBDatabaseInfo.h>
#include <WebCore/IDBDatabaseNameAndVersion.h>
#include <WebCore/IDBError.h>
#include <WebCore/IDBGetAllRecordsData.h>
#include <WebCore/IDBGetAllResult.h>
#include <WebCore/IDBGetRecordData.h>
#include <WebCore/IDBGetResult.h>
#include <WebCore/IDBIndexInfo.h>
#include <WebCore/IDBIterateCursorData.h>
#include <WebCore/IDBKeyData.h>
#include <WebCore/IDBKeyRangeData.h>
#include <WebCore/IDBObjectStoreInfo.h>
#include <WebCore/IDBOpenRequestData.h>
#include <WebCore/IDBRequestData.h>
#include <WebCore/IDBResourceIdentifier.h>
#include <WebCore/IDBResultData.h>
#include <WebCore/IDBTransactionInfo.h>
#include <WebCore/IDBValue.h>
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#include <WebCore/ISO18013.h>
#endif
#include <WebCore/ISOVTTCue.h>
#include <WebCore/IdentityTransformOperation.h>
#include <WebCore/Image.h>
#include <WebCore/ImageBitmap.h>
#include <WebCore/ImageBuffer.h>
#include <WebCore/ImageBufferFormat.h>
#include <WebCore/ImageBufferResourceLimits.h>
#if ENABLE(SERVICE_CONTROLS)
#include <WebCore/ImageControlsButtonPart.h>
#endif
#include <WebCore/ImageDecoder.h>
#include <WebCore/ImageOrientation.h>
#include <WebCore/ImagePaintingOptions.h>
#include <WebCore/ImageResource.h>
#include <WebCore/ImageTypes.h>
#if PLATFORM(COCOA)
#include <WebCore/ImageUtilities.h>
#endif
#if ENABLE(VIDEO)
#include <WebCore/InbandGenericCue.h>
#endif
#include <WebCore/IndexKey.h>
#include <WebCore/InnerSpinButtonPart.h>
#include <WebCore/InspectorBackendClient.h>
#include <WebCore/InspectorFrontendClient.h>
#if ENABLE(INSPECTOR_EXTENSIONS)
#include <WebCore/InspectorFrontendClient.h>
#endif
#if PLATFORM(IOS_FAMILY)
#include <WebCore/InspectorOverlay.h>
#endif
#if PLATFORM(IOS_FAMILY)
#include <WebCore/InspectorOverlayLabel.h>
#endif
#include <WebCore/IntPoint.h>
#include <WebCore/IntRect.h>
#include <WebCore/IntSize.h>
#include <WebCore/InteractionRegion.h>
#include <WebCore/IsLoggedIn.h>
#include <WebCore/JsonWebKey.h>
#include <WebCore/KeyboardScroll.h>
#if PLATFORM(COCOA)
#include <WebCore/KeypressCommand.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/LandmarkInterface.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/LandmarkTypeInterface.h>
#endif
#include <WebCore/LayerTreeAsTextOptions.h>
#include <WebCore/LayoutPoint.h>
#include <WebCore/LayoutRect.h>
#include <WebCore/LayoutSize.h>
#include <WebCore/LayoutUnit.h>
#if PLATFORM(COCOA)
#include <WebCore/LegacyWebArchive.h>
#endif
#include <WebCore/Length.h>
#include <WebCore/LengthPoint.h>
#include <WebCore/LengthSize.h>
#include <WebCore/LightSource.h>
#include <WebCore/LinkDecorationFilteringData.h>
#include <WebCore/LinkIcon.h>
#include <WebCore/LoadSchedulingMode.h>
#include <WebCore/LocalFrameLoaderClient.h>
#include <WebCore/LoginStatus.h>
#include <WebCore/MDNSRegisterError.h>
#include <WebCore/MarkupExclusionRule.h>
#include <WebCore/Matrix3DTransformOperation.h>
#include <WebCore/MatrixTransformOperation.h>
#include <WebCore/MediaCapabilitiesDecodingInfo.h>
#include <WebCore/MediaCapabilitiesEncodingInfo.h>
#include <WebCore/MediaCapabilitiesInfo.h>
#include <WebCore/MediaConfiguration.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/MediaConstraints.h>
#endif
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS) && USE(UICONTEXTMENU)
#include <WebCore/MediaControlsContextMenuItem.h>
#endif
#include <WebCore/MediaDecodingConfiguration.h>
#include <WebCore/MediaDeviceHashSalts.h>
#include <WebCore/MediaEncodingConfiguration.h>
#if ENABLE(VIDEO)
#include <WebCore/MediaPlayer.h>
#endif
#if ENABLE(MEDIA_SESSION)
#include <WebCore/MediaPositionState.h>
#endif
#include <WebCore/MediaProducer.h>
#include <WebCore/MediaSample.h>
#include <WebCore/MediaSelectionOption.h>
#if ENABLE(MEDIA_SESSION)
#include <WebCore/MediaSessionAction.h>
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
#include <WebCore/MediaSessionCoordinatorState.h>
#endif
#if ENABLE(MEDIA_SESSION)
#include <WebCore/MediaSessionPlaybackState.h>
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
#include <WebCore/MediaSessionReadyState.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/MediaSettingsRange.h>
#endif
#if ENABLE(MEDIA_SOURCE)
#include <WebCore/MediaSourceConfiguration.h>
#endif
#if ENABLE(MEDIA_SOURCE)
#include <WebCore/MediaSourcePrivate.h>
#endif
#include <WebCore/MediaStreamRequest.h>
#if ! ENABLE(MEDIA_STREAM)
#include <WebCore/MediaStreamRequest.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/MediaStreamRequest.h>
#endif
#include <WebCore/MediaUsageInfo.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/MediationRequirement.h>
#endif
#include <WebCore/MenuListButtonPart.h>
#include <WebCore/MenuListPart.h>
#include <WebCore/MessageForTesting.h>
#include <WebCore/MessagePort.h>
#include <WebCore/MessagePortIdentifier.h>
#include <WebCore/MessageWithMessagePorts.h>
#include <WebCore/MeterPart.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/MeteringMode.h>
#endif
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#include <WebCore/MobileDocumentRequest.h>
#endif
#if ENABLE(CONTENT_FILTERING)
#include <WebCore/MockContentFilterSettings.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/MockMediaDevice.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/MockWebAuthenticationConfiguration.h>
#endif
#include <WebCore/ModalContainerTypes.h>
#include <WebCore/Model.h>
#if ENABLE(MODEL_PROCESS)
#include <WebCore/ModelContext.h>
#endif
#include <WebCore/ModelPlayerAnimationState.h>
#include <WebCore/MotionPath.h>
#include <WebCore/NavigationPreloadState.h>
#include <WebCore/NavigationRequester.h>
#include <WebCore/NavigationScheduler.h>
#include <WebCore/NetworkLoadInformation.h>
#include <WebCore/NetworkLoadMetrics.h>
#include <WebCore/NotificationData.h>
#include <WebCore/NotificationOptionsPayload.h>
#include <WebCore/NotificationPayload.h>
#include <WebCore/NotificationResources.h>
#include <WebCore/NowPlayingInfo.h>
#include <WebCore/OffscreenCanvas.h>
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#include <WebCore/OpenID4VPRequest.h>
#endif
#include <WebCore/OrganizationStorageAccessPromptQuirk.h>
#include <WebCore/OwnerPermissionsPolicyData.h>
#include <WebCore/Pagination.h>
#include <WebCore/Pasteboard.h>
#include <WebCore/PasteboardCustomData.h>
#include <WebCore/PasteboardItemInfo.h>
#include <WebCore/Path.h>
#include <WebCore/PathOperation.h>
#include <WebCore/PathSegment.h>
#include <WebCore/PathSegmentData.h>
#include <WebCore/Pattern.h>
#if ENABLE(APPLE_PAY_INSTALLMENTS)
#include <WebCore/PaymentInstallmentConfigurationWebCore.h>
#endif
#include <WebCore/PermissionDescriptor.h>
#include <WebCore/PermissionQuerySource.h>
#include <WebCore/PermissionState.h>
#include <WebCore/PermissionsPolicy.h>
#include <WebCore/PerspectiveTransformOperation.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/PhotoCapabilities.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/PhotoSettings.h>
#endif
#include <WebCore/PixelBuffer.h>
#include <WebCore/PixelBufferFormat.h>
#if ENABLE(VIDEO)
#include <WebCore/PlatformAudioTrackConfiguration.h>
#endif
#if (!(USE(CG))) && (!(USE(SKIA)))
#include <WebCore/PlatformColorSpace.h>
#endif
#include <WebCore/PlatformDynamicRangeLimit.h>
#include <WebCore/PlatformMediaSession.h>
#if ENABLE(VIDEO)
#include <WebCore/PlatformTextTrack.h>
#endif
#include <WebCore/PlatformTimeRanges.h>
#if ENABLE(VIDEO)
#include <WebCore/PlatformTrackConfiguration.h>
#endif
#include <WebCore/PlatformVideoColorSpace.h>
#if ENABLE(VIDEO)
#include <WebCore/PlatformVideoTrackConfiguration.h>
#endif
#include <WebCore/PlatformWheelEvent.h>
#if (ENABLE(WEBXR)) && (USE(OPENXR))
#include <WebCore/PlatformXR.h>
#endif
#if ENABLE(WEBXR)
#include <WebCore/PlatformXR.h>
#endif
#include <WebCore/PluginData.h>
#include <WebCore/PointLightSource.h>
#include <WebCore/PolicyContainer.h>
#include <WebCore/PredefinedColorSpace.h>
#include <WebCore/PrewarmInformation.h>
#include <WebCore/PrivateClickMeasurement.h>
#include <WebCore/ProcessIdentity.h>
#include <WebCore/ProcessQualified.h>
#include <WebCore/ProcessSwapDisposition.h>
#include <WebCore/ProcessSyncData.h>
#include <WebCore/ProgressBarPart.h>
#include <WebCore/PromisedAttachmentInfo.h>
#include <WebCore/ProtectionSpace.h>
#include <WebCore/ProtectionSpaceBase.h>
#include <WebCore/ProtectionSpaceBase.h>
#include <WebCore/PublicKeyCredentialCreationOptions.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/PublicKeyCredentialDescriptor.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/PublicKeyCredentialEntity.h>
#endif
#include <WebCore/PublicKeyCredentialRequestOptions.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/PublicKeyCredentialRpEntity.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/PublicKeyCredentialUserEntity.h>
#endif
#include <WebCore/PublicSuffix.h>
#include <WebCore/PushPermissionState.h>
#include <WebCore/PushSubscriptionData.h>
#if ENABLE(WEB_RTC)
#include <WebCore/RTCDataChannelHandler.h>
#endif
#include <WebCore/RTCErrorDetailType.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RealtimeMediaSource.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RealtimeMediaSourceCapabilities.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RealtimeMediaSourceCenter.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RealtimeMediaSourceSettings.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RealtimeMediaSourceSupportedConstraints.h>
#endif
#include <WebCore/RectEdges.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RedEyeReduction.h>
#endif
#include <WebCore/Region.h>
#include <WebCore/RegistrableDomain.h>
#include <WebCore/RemoteUserInputEventData.h>
#include <WebCore/RenderObject.h>
#include <WebCore/RenderStyleConstants.h>
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/RenderStyleConstants.h>
#endif
#include <WebCore/RenderTreeAsText.h>
#include <WebCore/Report.h>
#include <WebCore/ReportBody.h>
#include <WebCore/ResourceError.h>
#include <WebCore/ResourceLoadStatistics.h>
#include <WebCore/ResourceLoaderOptions.h>
#include <WebCore/ResourceRequest.h>
#if !USE(CURL) && !PLATFORM(COCOA)
#include <WebCore/ResourceRequest.h>
#endif
#if PLATFORM(COCOA)
#include <WebCore/ResourceRequest.h>
#endif
#if USE(CURL)
#include <WebCore/ResourceRequest.h>
#endif
#if USE(SOUP)
#include <WebCore/ResourceRequest.h>
#endif
#include <WebCore/ResourceResponse.h>
#include <WebCore/ResourceResponseBase.h>
#include <WebCore/RetrieveRecordsOptions.h>
#include <WebCore/RotateTransformOperation.h>
#include <WebCore/RouterSourceDict.h>
#include <WebCore/RsaOtherPrimesInfo.h>
#include <WebCore/SVGFilter.h>
#include <WebCore/SVGFilterExpression.h>
#include <WebCore/SVGPathByteStream.h>
#include <WebCore/SVGPreserveAspectRatioValue.h>
#include <WebCore/SameSiteInfo.h>
#include <WebCore/ScaleTransformOperation.h>
#include <WebCore/ScreenOrientationLockType.h>
#include <WebCore/ScreenOrientationType.h>
#include <WebCore/ScreenProperties.h>
#if !ENABLE(SHAREABLE_RESOURCE) || !PLATFORM(COCOA)
#include <WebCore/ScriptBuffer.h>
#endif
#if ENABLE(SHAREABLE_RESOURCE) && PLATFORM(COCOA)
#include <WebCore/ScriptBuffer.h>
#endif
#include <WebCore/ScriptTrackingPrivacyCategory.h>
#include <WebCore/ScrollTypes.h>
#if USE(APPKIT)
#include <WebCore/ScrollbarTrackCornerSystemImageMac.h>
#endif
#include <WebCore/ScrollingConstraints.h>
#include <WebCore/ScrollingCoordinatorTypes.h>
#if ENABLE(ASYNC_SCROLLING)
#include <WebCore/ScrollingStateNode.h>
#endif
#include <WebCore/SearchFieldCancelButtonPart.h>
#include <WebCore/SearchFieldPart.h>
#include <WebCore/SearchFieldResultsPart.h>
#include <WebCore/SearchPopupMenu.h>
#include <WebCore/SecurityOrigin.h>
#include <WebCore/SecurityOriginData.h>
#include <WebCore/SecurityPolicyViolationEvent.h>
#include <WebCore/SecurityPolicyViolationEventDisposition.h>
#include <WebCore/SelectionData.h>
#if PLATFORM(IOS_FAMILY)
#include <WebCore/SelectionGeometry.h>
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
#include <WebCore/SerializedAttachmentData.h>
#endif
#include <WebCore/SerializedNode.h>
#if ENABLE(VIDEO)
#include <WebCore/SerializedPlatformDataCueValue.h>
#endif
#include <WebCore/SerializedScriptValue.h>
#include <WebCore/ServiceWorkerClientData.h>
#include <WebCore/ServiceWorkerClientPendingMessage.h>
#include <WebCore/ServiceWorkerClientQueryOptions.h>
#include <WebCore/ServiceWorkerContextData.h>
#include <WebCore/ServiceWorkerData.h>
#include <WebCore/ServiceWorkerImportedScript.h>
#include <WebCore/ServiceWorkerJobData.h>
#include <WebCore/ServiceWorkerJobDataIdentifier.h>
#include <WebCore/ServiceWorkerRegistrationData.h>
#include <WebCore/ServiceWorkerRegistrationKey.h>
#include <WebCore/ServiceWorkerRegistrationOptions.h>
#include <WebCore/ServiceWorkerRoute.h>
#include <WebCore/ShareData.h>
#include <WebCore/ShareableBitmap.h>
#if ENABLE(SHAREABLE_RESOURCE)
#include <WebCore/ShareableResource.h>
#endif
#include <WebCore/SharedBuffer.h>
#include <WebCore/SharedStringHash.h>
#include <WebCore/SharedWorkerKey.h>
#include <WebCore/ShouldTreatAsContinuingLoad.h>
#include <WebCore/Site.h>
#include <WebCore/SkewTransformOperation.h>
#include <WebCore/SliderThumbPart.h>
#include <WebCore/SliderTrackPart.h>
#include <WebCore/SocketStreamError.h>
#include <WebCore/SoupNetworkProxySettings.h>
#include <WebCore/SourceAlpha.h>
#if ENABLE(MEDIA_SOURCE)
#include <WebCore/SourceBufferPrivate.h>
#endif
#if ENABLE(MEDIA_SOURCE)
#include <WebCore/SourceBufferPrivateClient.h>
#endif
#include <WebCore/SourceGraphic.h>
#include <WebCore/SourceImage.h>
#if ENABLE(WEB_PAGE_SPATIAL_BACKDROP)
#include <WebCore/SpatialBackdropSource.h>
#endif
#if ENABLE(VIDEO)
#include <WebCore/SpatialVideoMetadata.h>
#endif
#include <WebCore/SpeechRecognitionError.h>
#include <WebCore/SpeechRecognitionRequestInfo.h>
#include <WebCore/SpeechRecognitionResultData.h>
#include <WebCore/SpeechRecognitionUpdate.h>
#include <WebCore/SpotLightSource.h>
#if ENABLE(MODEL_PROCESS)
#include <WebCore/StageModeOperations.h>
#endif
#include <WebCore/StorageBlockingPolicy.h>
#include <WebCore/StorageEstimate.h>
#include <WebCore/StorageType.h>
#include <WebCore/StyleBorderRadius.h>
#include <WebCore/StyleCircleFunction.h>
#include <WebCore/StyleEllipseFunction.h>
#include <WebCore/StyleFillRule.h>
#include <WebCore/StyleGradient.h>
#include <WebCore/StyleInsetFunction.h>
#include <WebCore/StyleLengthWrapperData.h>
#include <WebCore/StyleListStyleType.h>
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/StyleOffsetRotate.h>
#endif
#include <WebCore/StylePathFunction.h>
#include <WebCore/StylePolygonFunction.h>
#include <WebCore/StylePosition.h>
#include <WebCore/StylePrimitiveNumericTypes.h>
#include <WebCore/StyleRayFunction.h>
#include <WebCore/StyleShapeFunction.h>
#include <WebCore/SubstituteData.h>
#include <WebCore/SwitchThumbPart.h>
#include <WebCore/SwitchTrackPart.h>
#include <WebCore/SystemImage.h>
#include <WebCore/SystemPreviewInfo.h>
#include <WebCore/SystemSettings.h>
#include <WebCore/TestReportBody.h>
#include <WebCore/TextAreaPart.h>
#if PLATFORM(COCOA)
#include <WebCore/TextAttachmentForSerialization.h>
#endif
#include <WebCore/TextChecking.h>
#include <WebCore/TextExtractionTypes.h>
#include <WebCore/TextFieldPart.h>
#include <WebCore/TextFlags.h>
#include <WebCore/TextGranularity.h>
#include <WebCore/TextIndicator.h>
#include <WebCore/TextManipulationController.h>
#include <WebCore/TextManipulationControllerManipulationFailure.h>
#include <WebCore/TextManipulationItem.h>
#include <WebCore/TextManipulationToken.h>
#if ENABLE(IMAGE_ANALYSIS)
#include <WebCore/TextRecognitionResult.h>
#endif
#if ENABLE(IMAGE_ANALYSIS) && ENABLE(DATA_DETECTION)
#include <WebCore/TextRecognitionResult.h>
#endif
#include <WebCore/ThreadSafeDataBuffer.h>
#include <WebCore/TimingFunction.h>
#include <WebCore/ToggleButtonPart.h>
#include <WebCore/TransformOperation.h>
#include <WebCore/TransformOperationData.h>
#include <WebCore/TransformOperations.h>
#include <WebCore/TransformationMatrix.h>
#include <WebCore/TranslateTransformOperation.h>
#if HAVE(TRANSLATION_UI_SERVICES) && ENABLE(CONTEXT_MENUS)
#include <WebCore/TranslationContextMenuInfo.h>
#endif
#include <WebCore/TrustedFonts.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/UnknownCredentialOptions.h>
#endif
#include <WebCore/UserScript.h>
#include <WebCore/UserStyleSheet.h>
#include <WebCore/VP9Utilities.h>
#if ENABLE(VIDEO)
#include <WebCore/VTTCue.h>
#endif
#include <WebCore/VelocityData.h>
#include <WebCore/VideoCodecType.h>
#include <WebCore/VideoConfiguration.h>
#include <WebCore/VideoEncoderScalabilityMode.h>
#if ENABLE(VIDEO)
#include <WebCore/VideoFrame.h>
#endif
#if ENABLE(VIDEO) && USE(AVFOUNDATION)
#include <WebCore/VideoFrameCV.h>
#endif
#if ENABLE(VIDEO)
#include <WebCore/VideoFrameMetadata.h>
#endif
#include <WebCore/VideoFrameTimeMetadata.h>
#if ENABLE(VIDEO)
#include <WebCore/VideoPlaybackQualityMetrics.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/VideoPreset.h>
#endif
#if ENABLE(VIDEO)
#include <WebCore/VideoProjectionMetadata.h>
#endif
#if ENABLE(VIDEO)
#include <WebCore/VideoTrackPrivate.h>
#endif
#if ENABLE(META_VIEWPORT)
#include <WebCore/ViewportArguments.h>
#endif
#include <WebCore/VisibleSelection.h>
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/WebAnimationTime.h>
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/WebAnimationTypes.h>
#endif
#include <WebCore/WebCodecsEncodedAudioChunk.h>
#if ENABLE(WEB_CODECS)
#include <WebCore/WebCodecsEncodedAudioChunk.h>
#endif
#if ENABLE(WEB_CODECS)
#include <WebCore/WebCodecsEncodedAudioChunkData.h>
#endif
#include <WebCore/WebCodecsEncodedVideoChunk.h>
#if ENABLE(WEB_CODECS)
#include <WebCore/WebCodecsEncodedVideoChunk.h>
#endif
#if ENABLE(WEB_CODECS)
#include <WebCore/WebCodecsEncodedVideoChunkData.h>
#endif
#include <WebCore/WebGPUAddressMode.h>
#include <WebCore/WebGPUBlendFactor.h>
#include <WebCore/WebGPUBlendOperation.h>
#include <WebCore/WebGPUBufferBindingType.h>
#include <WebCore/WebGPUBufferUsage.h>
#include <WebCore/WebGPUCanvasAlphaMode.h>
#include <WebCore/WebGPUCanvasToneMappingMode.h>
#include <WebCore/WebGPUColorWrite.h>
#include <WebCore/WebGPUCompareFunction.h>
#include <WebCore/WebGPUCompilationMessageType.h>
#include <WebCore/WebGPUCullMode.h>
#include <WebCore/WebGPUDeviceLostReason.h>
#include <WebCore/WebGPUErrorFilter.h>
#include <WebCore/WebGPUFilterMode.h>
#include <WebCore/WebGPUFrontFace.h>
#include <WebCore/WebGPUIndexFormat.h>
#include <WebCore/WebGPULoadOp.h>
#include <WebCore/WebGPUMapMode.h>
#include <WebCore/WebGPUPredefinedColorSpace.h>
#include <WebCore/WebGPUPrimitiveTopology.h>
#include <WebCore/WebGPUQueryType.h>
#include <WebCore/WebGPUSamplerBindingType.h>
#include <WebCore/WebGPUShaderStage.h>
#include <WebCore/WebGPUStencilOperation.h>
#include <WebCore/WebGPUStorageTextureAccess.h>
#include <WebCore/WebGPUStoreOp.h>
#include <WebCore/WebGPUTextureAspect.h>
#include <WebCore/WebGPUTextureDimension.h>
#include <WebCore/WebGPUTextureFormat.h>
#include <WebCore/WebGPUTextureSampleType.h>
#include <WebCore/WebGPUTextureUsage.h>
#include <WebCore/WebGPUTextureViewDimension.h>
#include <WebCore/WebGPUVertexFormat.h>
#include <WebCore/WebGPUVertexStepMode.h>
#include <WebCore/WebGPUXREye.h>
#include <WebCore/WebLockManagerSnapshot.h>
#include <WebCore/WheelEventTestMonitor.h>
#include <WebCore/WindowFeatures.h>
#include <WebCore/WorkerFetchResult.h>
#include <WebCore/WorkerInitializationData.h>
#include <WebCore/WorkerOptions.h>
#include <WebCore/WrappedCryptoKey.h>
#include <WebCore/WritingDirection.h>
#if ENABLE(WRITING_TOOLS)
#include <WebCore/WritingToolsTypes.h>
#endif
#if USE(SKIA)
#include <hb.h>
#endif
#include <pal/SessionID.h>
#include <skia/core/SkFontStyle.h>
#include <wtf/JSONValues.h>
#if OS(DARWIN)
#include <wtf/MachSendRight.h>
#endif
#if PLATFORM(COCOA)
#include <wtf/MachSendRightAnnotated.h>
#endif
#include <wtf/MediaTime.h>
#include <wtf/MemoryPressureHandler.h>
#include <wtf/MonotonicTime.h>
#include <wtf/ObjectIdentifier.h>
#if ENABLE(MODEL_PROCESS)
#include <wtf/ProcessID.h>
#endif
#include <wtf/RobinHoodHashTable.h>
#include <wtf/Seconds.h>
#include <wtf/URL.h>
#include <wtf/UUID.h>
#include <wtf/Variant.h>
#include <wtf/WallTime.h>
#include <wtf/text/AtomString.h>
#include <wtf/text/CString.h>
#if USE(UNIX_DOMAIN_SOCKETS)
#include <wtf/unix/UnixFileDescriptor.h>
#endif

static_assert(std::is_same_v<WebCore::PathSegment::Data,
    Variant<WebCore::PathMoveTo, WebCore::PathLineTo, WebCore::PathQuadCurveTo, WebCore::PathBezierCurveTo, WebCore::PathArcTo, WebCore::PathArc, WebCore::PathClosedArc, WebCore::PathEllipse, WebCore::PathEllipseInRect, WebCore::PathRect, WebCore::PathRoundedRect, WebCore::PathContinuousRoundedRect, WebCore::PathDataLine, WebCore::PathDataQuadCurve, WebCore::PathDataBezierCurve, WebCore::PathDataArc, WebCore::PathCloseSubpath>
>);
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
static_assert(std::is_same_v<WebCore::TextDrawingModeFlags,
    OptionSet<WebCore::TextDrawingMode>
>);
#endif
static_assert(std::is_same_v<WebCore::FetchingWorkerIdentifier,
    Variant<std::monostate, WebCore::SharedWorkerIdentifier, WebCore::ServiceWorkerIdentifier>
>);
static_assert(std::is_same_v<WebKit::ActivityStateChangeID,
    uint64_t
>);
static_assert(std::is_same_v<WebCore::ScrollOffset,
    WebCore::IntPoint
>);
#if (USE(LIBWEBRTC)) && (USE(LIBWEBRTC) && PLATFORM(COCOA))
static_assert(std::is_same_v<webrtc::WebKitEncodedFrameTiming,
    webrtc::EncodedImage::Timing
>);
#endif
#if OS(WINDOWS)
static_assert(std::is_same_v<WTF::ProcessID,
    int
>);
#endif
#if !(OS(WINDOWS))
static_assert(std::is_same_v<WTF::ProcessID,
    pid_t
>);
#endif
static_assert(std::is_same_v<FileSystem::Salt,
    std::array<uint8_t, 8>
>);
static_assert(std::is_same_v<WebCore::IndexIDToIndexKeyMap,
    HashMap<WebCore::IDBIndexIdentifier, WebCore::IndexKey>
>);
static_assert(std::is_same_v<WebCore::TargetedElementIdentifiers,
    std::pair<WebCore::NodeIdentifier, WebCore::ScriptExecutionContextIdentifier>
>);
static_assert(std::is_same_v<WebCore::TargetedElementSelectors,
    Vector<HashSet<String>>
>);
#if ENABLE(WEB_AUTHN)
static_assert(std::is_same_v<WebCore::AuthenticatorResponseDataSerializableForm,
    Variant<std::nullptr_t, WebCore::AuthenticatorResponseBaseData, WebCore::AuthenticatorAttestationResponseData, WebCore::AuthenticatorAssertionResponseData>
>);
#endif
#if ENABLE(WEB_AUTHN)
static_assert(std::is_same_v<WebCore::PointerID,
    uint32_t
>);
#endif
#if USE(CG)
static_assert(std::is_same_v<WebCore::PlatformColorSpace,
    RetainPtr<CGColorSpaceRef>
>);
#endif
#if (!(USE(CG))) && (USE(SKIA))
static_assert(std::is_same_v<WebCore::PlatformColorSpace,
    sk_sp<SkColorSpace>
>);
#endif
static_assert(std::is_same_v<WebCore::PlatformDisplayID,
    uint32_t
>);
static_assert(std::is_same_v<WebCore::Style::LengthAll,
    WebCore::Style::Length<WebCore::CSS::All>
>);
static_assert(std::is_same_v<WebCore::Style::LengthPercentageNonnegative,
    WebCore::Style::LengthPercentage<WebCore::CSS::Nonnegative>
>);
static_assert(std::is_same_v<WebCore::Style::LengthPercentageAll,
    WebCore::Style::LengthPercentage<WebCore::CSS::All>
>);
static_assert(std::is_same_v<WebCore::Style::LengthPercentageSpaceSeparatedPointAll,
    WebCore::SpaceSeparatedPoint<WebCore::Style::LengthPercentageAll>
>);
static_assert(std::is_same_v<WebCore::Style::LengthPercentageSpaceSeparatedPointNonnegative,
    WebCore::SpaceSeparatedPoint<WebCore::Style::LengthPercentageNonnegative>
>);
static_assert(std::is_same_v<WebCore::Style::ShapeCommand,
    Variant<WebCore::Style::MoveCommand, WebCore::Style::LineCommand, WebCore::Style::HLineCommand, WebCore::Style::VLineCommand, WebCore::Style::CurveCommand, WebCore::Style::SmoothCommand, WebCore::Style::ArcCommand, WebCore::Style::CloseCommand>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::ClosestCorner,
    WebCore::Constant<WebCore::CSSValueClosestCorner>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::ClosestSide,
    WebCore::Constant<WebCore::CSSValueClosestSide>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::FarthestCorner,
    WebCore::Constant<WebCore::CSSValueFarthestCorner>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::FarthestSide,
    WebCore::Constant<WebCore::CSSValueFarthestSide>
>);
static_assert(std::is_same_v<WebCore::Style::Circle::Extent,
    Variant<WebCore::CSS::Keyword::ClosestCorner, WebCore::CSS::Keyword::ClosestSide, WebCore::CSS::Keyword::FarthestCorner, WebCore::CSS::Keyword::FarthestSide>
>);
static_assert(std::is_same_v<WebCore::Style::Circle::RadialSize,
    Variant<WebCore::Style::LengthPercentage<WebCore::CSS::Nonnegative>, WebCore::Style::Circle::Extent>
>);
static_assert(std::is_same_v<WebCore::Style::Ellipse::Extent,
    Variant<WebCore::CSS::Keyword::ClosestCorner, WebCore::CSS::Keyword::ClosestSide, WebCore::CSS::Keyword::FarthestCorner, WebCore::CSS::Keyword::FarthestSide>
>);
static_assert(std::is_same_v<WebCore::Style::Ellipse::RadialSize,
    Variant<WebCore::Style::LengthPercentage<WebCore::CSS::Nonnegative>, WebCore::Style::Ellipse::Extent>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::Nonzero,
    WebCore::Constant<WebCore::CSSValueNonzero>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::Evenodd,
    WebCore::Constant<WebCore::CSSValueEvenodd>
>);
static_assert(std::is_same_v<WebCore::Style::FillRule,
    Variant<WebCore::CSS::Keyword::Nonzero, WebCore::CSS::Keyword::Evenodd>
>);
static_assert(std::is_same_v<WebCore::Style::CoordinatePair,
    WebCore::SpaceSeparatedPoint<WebCore::Style::LengthPercentageAll>
>);
static_assert(std::is_same_v<WebCore::Style::CommandAffinity,
    Variant<WebCore::CSS::Keyword::By, WebCore::CSS::Keyword::To>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::By,
    WebCore::Constant<WebCore::CSSValueBy>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::To,
    WebCore::Constant<WebCore::CSSValueTo>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::Ccw,
    WebCore::Constant<WebCore::CSSValueCcw>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::Cw,
    WebCore::Constant<WebCore::CSSValueCw>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::Large,
    WebCore::Constant<WebCore::CSSValueLarge>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::Small,
    WebCore::Constant<WebCore::CSSValueSmall>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::Start,
    WebCore::Constant<WebCore::CSSValueStart>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::End,
    WebCore::Constant<WebCore::CSSValueEnd>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::Origin,
    WebCore::Constant<WebCore::CSSValueOrigin>
>);
static_assert(std::is_same_v<WebCore::Style::ControlPointAnchor,
    Variant<WebCore::CSS::Keyword::Start, WebCore::CSS::Keyword::End, WebCore::CSS::Keyword::Origin>
>);
static_assert(std::is_same_v<WebCore::Style::CloseCommand,
    WebCore::Constant<WebCore::CSSValueClose>
>);
static_assert(std::is_same_v<WebCore::Style::LengthPercentageMinimallySerializingSpaceSeparatedSizeAll,
    WebCore::MinimallySerializingSpaceSeparatedSize<WebCore::Style::LengthPercentageAll>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::Sides,
    WebCore::Constant<WebCore::CSSValueSides>
>);
static_assert(std::is_same_v<WebCore::CSS::Keyword::Contain,
    WebCore::Constant<WebCore::CSSValueContain>
>);
static_assert(std::is_same_v<WebCore::Style::RaySize,
    Variant<WebCore::CSS::Keyword::ClosestCorner, WebCore::CSS::Keyword::ClosestSide, WebCore::CSS::Keyword::FarthestCorner, WebCore::CSS::Keyword::FarthestSide, WebCore::CSS::Keyword::Sides>
>);
static_assert(std::is_same_v<WebCore::Style::BasicShape,
    Variant<WebCore::Style::CircleFunction, WebCore::Style::EllipseFunction, WebCore::Style::InsetFunction, WebCore::Style::PathFunction, WebCore::Style::PolygonFunction, WebCore::Style::ShapeFunction>
>);
static_assert(std::is_same_v<WebCore::ResourceResponseBase::Type,
    WebCore::ResourceResponseBaseType
>);
static_assert(std::is_same_v<WebCore::ResourceResponseBase::Tainting,
    WebCore::ResourceResponseBaseTainting
>);
static_assert(std::is_same_v<WebCore::ResourceResponseBase::Source,
    WebCore::ResourceResponseSource
>);
static_assert(std::is_same_v<WebCore::SharedStringHash,
    uint32_t
>);
static_assert(std::is_same_v<PlatformGLObject,
    GCGLuint
>);
static_assert(std::is_same_v<GCGLuint,
    unsigned
>);
static_assert(std::is_same_v<WebCore::IDBConnectionIdentifier,
    WebCore::ProcessIdentifier
>);
static_assert(std::is_same_v<WebCore::TransferredMessagePort,
    std::pair<WebCore::MessagePortIdentifier, WebCore::MessagePortIdentifier>
>);
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
static_assert(std::is_same_v<WebCore::CSS::Keyword::Auto,
    WebCore::Constant<WebCore::CSSValueAuto>
>);
#endif
#if ENABLE(WRITING_TOOLS)
static_assert(std::is_same_v<WebCore::WritingTools::SessionID,
    WTF::UUID
>);
#endif
#if ENABLE(WRITING_TOOLS)
static_assert(std::is_same_v<WebCore::WritingTools::ContextID,
    WTF::UUID
>);
#endif
#if ENABLE(WRITING_TOOLS)
static_assert(std::is_same_v<WebCore::WritingTools::TextSuggestionID,
    WTF::UUID
>);
#endif
static_assert(std::is_same_v<WebCore::ViewportConstraints::AnchorEdges,
    unsigned
>);
static_assert(std::is_same_v<WebCore::FontSelectionValue::BackingType,
    int16_t
>);
static_assert(std::is_same_v<WebCore::FontTag,
    std::array<char, 4>
>);
#if ENABLE(MEDIA_SOURCE)
static_assert(std::is_same_v<WebCore::SourceBufferPrivate::SamplesPromise::Result,
    Expected<Vector<String>, WebCore::PlatformMediaError>
>);
#endif
static_assert(std::is_same_v<WebCore::MediaProducerMutedStateFlags,
    OptionSet<WebCore::MediaProducerMutedState>
>);
static_assert(std::is_same_v<WebCore::FramesPerSecond,
    unsigned
>);
static_assert(std::is_same_v<WebCore::PlatformGPUID,
    uint64_t
>);
static_assert(std::is_same_v<WebCore::GraphicsStyle,
    Variant<WebCore::GraphicsDropShadow, WebCore::GraphicsGaussianBlur, WebCore::GraphicsColorMatrix>
>);
#if USE(CG)
static_assert(std::is_same_v<WebCore::GlyphBufferGlyph,
    CGGlyph
>);
#endif
#if !(USE(CG))
static_assert(std::is_same_v<WebCore::GlyphBufferGlyph,
    WebCore::Glyph
>);
#endif
static_assert(std::is_same_v<WebCore::Glyph,
    unsigned short
>);
static_assert(std::is_same_v<WebCore::ContentExtensionEnablement,
    std::pair<WebCore::ContentExtensionDefaultEnablement, HashSet<String>>
>);
#if PLATFORM(COCOA) && ENABLE(WEBGL)
static_assert(std::is_same_v<WebCore::GraphicsContextGL::ExternalImageSource,
    Variant<WebCore::GraphicsContextGLExternalImageSourceIOSurfaceHandle, WebCore::GraphicsContextGLExternalImageSourceMTLSharedTextureHandle>
>);
#endif
#if PLATFORM(COCOA) && ENABLE(WEBGL)
static_assert(std::is_same_v<WebCore::GraphicsContextGL::ExternalSyncSource,
    std::tuple<MachSendRight, uint64_t>
>);
#endif
#if (!PLATFORM(COCOA) && ENABLE(WEBGL)) && ((PLATFORM(GTK) || PLATFORM(WPE)))
static_assert(std::is_same_v<WebCore::GraphicsContextGL::ExternalImageSource,
    WebCore::GraphicsContextGLExternalImageSource
>);
#endif
#if (!PLATFORM(COCOA) && ENABLE(WEBGL)) && (!((PLATFORM(GTK) || PLATFORM(WPE))))
static_assert(std::is_same_v<WebCore::GraphicsContextGL::ExternalImageSource,
    int
>);
#endif
#if !PLATFORM(COCOA) && ENABLE(WEBGL)
static_assert(std::is_same_v<WebCore::GraphicsContextGL::ExternalSyncSource,
    int
>);
#endif
static_assert(std::is_same_v<WebCore::DOMCacheEngine::CacheInfosOrError,
    Expected<WebCore::DOMCacheEngine::CacheInfos, WebCore::DOMCacheEngine::Error>
>);
static_assert(std::is_same_v<WebCore::DOMCacheEngine::CacheIdentifierOrError,
    Expected<WebCore::DOMCacheEngine::CacheIdentifierOperationResult, WebCore::DOMCacheEngine::Error>
>);
static_assert(std::is_same_v<WebCore::DOMCacheEngine::RecordIdentifiersOrError,
    Expected<Vector<uint64_t>, WebCore::DOMCacheEngine::Error>
>);
static_assert(std::is_same_v<WebCore::DOMCacheEngine::CrossThreadRecordsOrError,
    Expected<Vector<WebCore::DOMCacheEngine::CrossThreadRecord>, WebCore::DOMCacheEngine::Error>
>);
static_assert(std::is_same_v<WebCore::DOMCacheEngine::RemoveCacheIdentifierOrError,
    Expected<bool, WebCore::DOMCacheEngine::Error>
>);
static_assert(std::is_same_v<WebCore::SVGFilterExpression,
    Vector<WebCore::SVGFilterExpressionTerm>
>);
static_assert(std::is_same_v<WebCore::SandboxFlags,
    OptionSet<WebCore::SandboxFlag>
>);
#if ENABLE(VIDEO)
static_assert(std::is_same_v<WebCore::MediaPlayer::VideoFullscreenMode,
    uint32_t
>);
#endif
#if ENABLE(VIDEO)
static_assert(std::is_same_v<WebCore::TrackID,
    uint64_t
>);
#endif
static_assert(std::is_same_v<WebCore::EpochTimeStamp,
    uint64_t
>);
static_assert(std::is_same_v<WebCore::SharedMemory::Handle,
    WebCore::SharedMemoryHandle
>);
static_assert(std::is_same_v<WebCore::ServiceWorkerOrClientIdentifier,
    Variant<WebCore::ScriptExecutionContextIdentifier, WebCore::ServiceWorkerIdentifier>
>);
#if OS(WINDOWS)
static_assert(std::is_same_v<ProcessID,
    int
>);
#endif
#if !(OS(WINDOWS))
static_assert(std::is_same_v<ProcessID,
    pid_t
>);
#endif
static_assert(std::is_same_v<WebCore::IntDegrees,
    int32_t
>);
static_assert(std::is_same_v<WebCore::PageOverlay::PageOverlayID,
    uint64_t
>);
#if ENABLE(INSPECTOR_EXTENSIONS)
static_assert(std::is_same_v<Inspector::ExtensionTabID,
    String
>);
#endif
static_assert(std::is_same_v<WebCore::IDBKeyPath,
    Variant<String, Vector<String>>
>);
static_assert(std::is_same_v<WebCore::ServiceWorkerOrClientData,
    Variant<WebCore::ServiceWorkerData, WebCore::ServiceWorkerClientData>
>);
#if PLATFORM(IOS_FAMILY)
static_assert(std::is_same_v<WebCore::RenderThemeIOS::CSSValueToSystemColorMap,
    HashMap<WebCore::CSSValueKey, WebCore::Color>
>);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(LEGACY_ENCRYPTED_MEDIA)
static_assert(std::is_same_v<WebCore::LegacyCDMSessionClient::MediaKeyErrorCode,
    unsigned short
>);
#endif
static_assert(std::is_same_v<WebCore::PermissionsPolicy::InheritedPolicy,
    HashSet<WebCore::PermissionsPolicy::Feature, IntHash<WebCore::PermissionsPolicy::Feature>, WTF::StrongEnumHashTraits<WebCore::PermissionsPolicy::Feature>>
>);
static_assert(std::is_same_v<WebCore::OwnerPermissionsPolicyData::PolicyDirective,
    HashMap<WebCore::PermissionsPolicy::Feature, WebCore::Allowlist, IntHash<WebCore::PermissionsPolicy::Feature>, WTF::StrongEnumHashTraits<WebCore::PermissionsPolicy::Feature>>
>);
static_assert(std::is_same_v<WebCore::FixedContainerEdge,
    Variant<WebCore::PredominantColorType, WebCore::Color>
>);
static_assert(std::is_same_v<WebCore::FontPlatformData::IPCData,
    Variant<WebCore::FontPlatformSerializedData, WebCore::FontPlatformSerializedCreationData>
>);
static_assert(std::is_same_v<WebKit::WebPreferencesStore::ValueMap,
    MemoryCompactRobinHoodHashMap<String, WebKit::WebPreferencesStore::Value>
>);
static_assert(std::is_same_v<WebKit::WebPreferencesStore::Value,
    Variant<String, bool, uint32_t, double>
>);
#if ENABLE(WK_WEB_EXTENSIONS)
static_assert(std::is_same_v<WebKit::WebExtensionError,
    String
>);
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
static_assert(std::is_same_v<WebKit::WebExtensionContext::PageIdentifierTuple,
    std::tuple<WebCore::PageIdentifier, std::optional<WebKit::WebExtensionTabIdentifier>, std::optional<WebKit::WebExtensionWindowIdentifier>>
>);
#endif
#if ENABLE(GPU_PROCESS)
static_assert(std::is_same_v<WebKit::WebGPU::Color,
    Variant<Vector<double>, WebKit::WebGPU::ColorDict>
>);
#endif
#if ENABLE(GPU_PROCESS)
static_assert(std::is_same_v<WebKit::WebGPU::Extent3D,
    Variant<Vector<WebCore::WebGPU::IntegerCoordinate>, WebKit::WebGPU::Extent3DDict>
>);
#endif
#if ENABLE(GPU_PROCESS)
static_assert(std::is_same_v<WebKit::WebGPU::Origin2D,
    Variant<Vector<WebCore::WebGPU::IntegerCoordinate>, WebKit::WebGPU::Origin2DDict>
>);
#endif
#if ENABLE(GPU_PROCESS)
static_assert(std::is_same_v<WebKit::WebGPU::Origin3D,
    Variant<Vector<WebCore::WebGPU::IntegerCoordinate>, WebKit::WebGPU::Origin3DDict>
>);
#endif
#if ENABLE(GPU_PROCESS)
static_assert(std::is_same_v<WebKit::WebGPU::Error,
    Variant<WebKit::WebGPU::OutOfMemoryError, WebKit::WebGPU::ValidationError, WebKit::WebGPU::InternalError>
>);
#endif
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING) && PLATFORM(COCOA)
static_assert(std::is_same_v<WebKit::ImageBufferBackendHandle,
    Variant<WebCore::ShareableBitmapHandle, MachSendRight, WebCore::DynamicContentScalingDisplayList>
>);
#endif
#if !ENABLE(RE_DYNAMIC_CONTENT_SCALING) && PLATFORM(COCOA)
static_assert(std::is_same_v<WebKit::ImageBufferBackendHandle,
    Variant<WebCore::ShareableBitmapHandle, MachSendRight>
>);
#endif
#if !PLATFORM(COCOA)
static_assert(std::is_same_v<WebKit::ImageBufferBackendHandle,
    Variant<WebCore::ShareableBitmapHandle>
>);
#endif
#if ENABLE(GPU_PROCESS) && PLATFORM(COCOA) && ENABLE(VIDEO)
static_assert(std::is_same_v<WebKit::SharedVideoFrame::Buffer,
    Variant<std::nullptr_t, WebKit::RemoteVideoFrameReadReference, MachSendRight, WebCore::IntSize>
>);
#endif
#if USE(SKIA)
static_assert(std::is_same_v<hb_tag_t,
    uint32_t
>);
#endif
#if !ENABLE(DOM_AUDIO_SESSION)
static_assert(std::is_same_v<WebCore::DOMAudioSessionType,
    bool
>);
#endif
static_assert(std::is_same_v<WebCore::ProcessSyncDataVariant,
    Variant<WebCore::DOMAudioSessionType, bool, bool, bool, URL, RefPtr<WebCore::SecurityOrigin>, OptionSet<WebCore::DocumentClass>, bool, bool, RefPtr<WebCore::SecurityOrigin>>
>);
static_assert(std::is_same_v<WebCore::ProtectionSpace::ServerType,
    WebCore::ProtectionSpaceBaseServerType
>);
static_assert(std::is_same_v<WebCore::ProtectionSpace::AuthenticationScheme,
    WebCore::ProtectionSpaceBaseAuthenticationScheme
>);
static_assert(std::is_same_v<WebCore::WebGPU::MapModeFlags,
    OptionSet<WebCore::WebGPU::MapMode>
>);
static_assert(std::is_same_v<WebCore::WebGPU::Size64,
    uint64_t
>);
static_assert(std::is_same_v<WebCore::WebGPU::Size32,
    uint32_t
>);
static_assert(std::is_same_v<WebCore::WebGPU::BufferDynamicOffset,
    uint32_t
>);
static_assert(std::is_same_v<WebCore::WebGPU::IntegerCoordinate,
    uint32_t
>);
static_assert(std::is_same_v<WebCore::WebGPU::Index32,
    uint32_t
>);
static_assert(std::is_same_v<WebCore::WebGPU::StencilValue,
    uint32_t
>);
static_assert(std::is_same_v<WebCore::WebGPU::SampleMask,
    uint32_t
>);
static_assert(std::is_same_v<WebCore::WebGPU::DepthBias,
    int32_t
>);
static_assert(std::is_same_v<WebCore::WebGPU::SignedOffset32,
    int32_t
>);
static_assert(std::is_same_v<WebCore::WebGPU::FlagsConstant,
    uint32_t
>);
static_assert(std::is_same_v<WebCore::WebGPU::ShaderStageFlags,
    OptionSet<WebCore::WebGPU::ShaderStage>
>);
static_assert(std::is_same_v<WebCore::WebGPU::ColorWriteFlags,
    uint32_t
>);
static_assert(std::is_same_v<WebCore::WebGPU::TextureUsageFlags,
    OptionSet<WebCore::WebGPU::TextureUsage>
>);
static_assert(std::is_same_v<WebCore::WebGPU::BufferUsageFlags,
    uint16_t
>);

#if ENABLE(IPC_TESTING_API)

namespace WebKit {

template<typename E> uint64_t enumValueForIPCTestAPI(E e)
{
    return static_cast<std::make_unsigned_t<std::underlying_type_t<E>>>(e);
}

Vector<SerializedTypeInfo> allSerializedTypes()
{
    return {
#if ENABLE(GPU_PROCESS)
        { "WebKit::GPUProcessCreationParameters"_s, {
            {
                "WebKit::AuxiliaryProcessCreationParameters"_s,
                "auxiliaryProcessParameters"_s
            },
#if ENABLE(MEDIA_STREAM)
            {
                "bool"_s,
                "useMockCaptureDevices"_s
            },
#endif
#if (ENABLE(MEDIA_STREAM)) && (PLATFORM(MAC))
            {
                "WebKit::SandboxExtensionHandle"_s,
                "microphoneSandboxExtensionHandle"_s
            },
#endif
#if (ENABLE(MEDIA_STREAM)) && (PLATFORM(MAC))
            {
                "WebKit::SandboxExtensionHandle"_s,
                "launchServicesExtensionHandle"_s
            },
#endif
#if USE(MODERN_AVCONTENTKEYSESSION)
            {
                "bool"_s,
                "shouldUseModernAVContentKeySession"_s
            },
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
            {
                "WebKit::SandboxExtensionHandle"_s,
                "containerCachesDirectoryExtensionHandle"_s
            },
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
            {
                "WebKit::SandboxExtensionHandle"_s,
                "containerTemporaryDirectoryExtensionHandle"_s
            },
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
            {
                "String"_s,
                "containerCachesDirectory"_s
            },
#endif
            {
                "std::optional<WebKit::SandboxExtensionHandle>"_s,
                "mobileGestaltExtensionHandle"_s
            },
#if PLATFORM(COCOA) && ENABLE(REMOTE_INSPECTOR)
            {
                "Vector<WebKit::SandboxExtensionHandle>"_s,
                "gpuToolsExtensionHandles"_s
            },
#endif
            {
                "String"_s,
                "applicationVisibleName"_s
            },
#if USE(GBM)
            {
                "WebCore::DRMDevice"_s,
                "drmDevice"_s
            },
#endif
            {
                "Vector<String>"_s,
                "overrideLanguages"_s
            },
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "enableMetalDebugDeviceForTesting"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "enableMetalShaderValidationForTesting"_s
            },
#endif
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::GPUProcessPreferences"_s, {
#if USE(MODERN_AVCONTENTKEYSESSION)
            {
                "std::optional<bool>"_s,
                "shouldUseModernAVContentKeySession"_s
            },
#endif
#if ENABLE(VP9)
            {
                "std::optional<bool>"_s,
                "vp9DecoderEnabled"_s
            },
#endif
#if ENABLE(VP9)
            {
                "bool"_s,
                "swVPDecodersAlwaysEnabled"_s
            },
#endif
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::GPUProcessSessionParameters"_s, {
            {
                "String"_s,
                "mediaCacheDirectory"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "mediaCacheDirectorySandboxExtensionHandle"_s
            },
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA)
            {
                "String"_s,
                "mediaKeysStorageDirectory"_s
            },
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA)
            {
                "WebKit::SandboxExtensionHandle"_s,
                "mediaKeysStorageDirectorySandboxExtensionHandle"_s
            },
#endif
        } },
#endif // ENABLE(GPU_PROCESS)
        { "WebCore::PathMoveTo"_s, {
            {
                "WebCore::FloatPoint"_s,
                "point"_s
            },
        } },
        { "WebCore::PathLineTo"_s, {
            {
                "WebCore::FloatPoint"_s,
                "point"_s
            },
        } },
        { "WebCore::PathQuadCurveTo"_s, {
            {
                "WebCore::FloatPoint"_s,
                "controlPoint"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "endPoint"_s
            },
        } },
        { "WebCore::PathBezierCurveTo"_s, {
            {
                "WebCore::FloatPoint"_s,
                "controlPoint1"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "controlPoint2"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "endPoint"_s
            },
        } },
        { "WebCore::PathArcTo"_s, {
            {
                "WebCore::FloatPoint"_s,
                "controlPoint1"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "controlPoint2"_s
            },
            {
                "float"_s,
                "radius"_s
            },
        } },
        { "WebCore::PathArc"_s, {
            {
                "WebCore::FloatPoint"_s,
                "center"_s
            },
            {
                "float"_s,
                "radius"_s
            },
            {
                "float"_s,
                "startAngle"_s
            },
            {
                "float"_s,
                "endAngle"_s
            },
            {
                "WebCore::RotationDirection"_s,
                "direction"_s
            },
        } },
        { "WebCore::PathClosedArc"_s, {
            {
                "WebCore::PathArc"_s,
                "arc"_s
            },
        } },
        { "WebCore::PathEllipse"_s, {
            {
                "WebCore::FloatPoint"_s,
                "center"_s
            },
            {
                "float"_s,
                "radiusX"_s
            },
            {
                "float"_s,
                "radiusY"_s
            },
            {
                "float"_s,
                "rotation"_s
            },
            {
                "float"_s,
                "startAngle"_s
            },
            {
                "float"_s,
                "endAngle"_s
            },
            {
                "WebCore::RotationDirection"_s,
                "direction"_s
            },
        } },
        { "WebCore::PathEllipseInRect"_s, {
            {
                "WebCore::FloatRect"_s,
                "rect"_s
            },
        } },
        { "WebCore::PathRect"_s, {
            {
                "WebCore::FloatRect"_s,
                "rect"_s
            },
        } },
        { "WebCore::PathRoundedRect"_s, {
            {
                "WebCore::FloatRoundedRect"_s,
                "roundedRect"_s
            },
            {
                "WebCore::PathRoundedRect::Strategy"_s,
                "strategy"_s
            },
        } },
        { "WebCore::PathContinuousRoundedRect"_s, {
            {
                "WebCore::FloatRect"_s,
                "rect"_s
            },
            {
                "float"_s,
                "cornerWidth"_s
            },
            {
                "float"_s,
                "cornerHeight"_s
            },
        } },
        { "WebCore::PathDataLine"_s, {
            {
                "std::span<const float, 4>"_s,
                "span()"_s
            },
        } },
        { "WebCore::PathDataQuadCurve"_s, {
            {
                "WebCore::FloatPoint"_s,
                "start"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "controlPoint"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "endPoint"_s
            },
        } },
        { "WebCore::PathDataBezierCurve"_s, {
            {
                "WebCore::FloatPoint"_s,
                "start"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "controlPoint1"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "controlPoint2"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "endPoint"_s
            },
        } },
        { "WebCore::PathDataArc"_s, {
            {
                "WebCore::FloatPoint"_s,
                "start"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "controlPoint1"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "controlPoint2"_s
            },
            {
                "float"_s,
                "radius"_s
            },
        } },
        { "WebCore::PathCloseSubpath"_s, {
        } },
        { "WebCore::PathSegment"_s, {
            {
                "WebCore::PathSegment::Data"_s,
                "data()"_s
            },
        } },
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "WebKit::RemoteGraphicsContextGLInitializationState"_s, {
            {
                "String"_s,
                "availableExtensions"_s
            },
            {
                "String"_s,
                "requestableExtensions"_s
            },
            {
                "GCGLenum"_s,
                "externalImageTarget"_s
            },
            {
                "GCGLenum"_s,
                "externalImageBindingQuery"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#if ENABLE(GPU_PROCESS)
        { "WebKit::RemoteGPURequestAdapterResponse"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "WebKit::WebGPU::SupportedFeatures"_s,
                "features"_s
            },
            {
                "WebKit::WebGPU::SupportedLimits"_s,
                "limits"_s
            },
            {
                "bool"_s,
                "isFallbackAdapter"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
        { "WebKit::AudioTrackPrivateRemoteConfiguration"_s, {
            {
                "WebCore::TrackID"_s,
                "trackId"_s
            },
            {
                "String"_s,
                "label"_s
            },
            {
                "String"_s,
                "language"_s
            },
            {
                "MediaTime"_s,
                "startTimeVariance"_s
            },
            {
                "int"_s,
                "trackIndex"_s
            },
            {
                "bool"_s,
                "enabled"_s
            },
            {
                "WebCore::AudioTrackPrivate::Kind"_s,
                "kind"_s
            },
            {
                "WebCore::PlatformAudioTrackConfiguration"_s,
                "trackConfiguration"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
        { "WebKit::InitializationSegmentInfo"_s, {
            {
                "MediaTime"_s,
                "duration"_s
            },
            {
                "Vector<WebKit::InitializationSegmentInfo::TrackInformation>"_s,
                "audioTracks"_s
            },
            {
                "Vector<WebKit::InitializationSegmentInfo::TrackInformation>"_s,
                "videoTracks"_s
            },
            {
                "Vector<WebKit::InitializationSegmentInfo::TrackInformation>"_s,
                "textTracks"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
        { "WebKit::InitializationSegmentInfo::TrackInformation"_s, {
            {
                "WebKit::MediaDescriptionInfo"_s,
                "description"_s
            },
            {
                "WebCore::TrackID"_s,
                "id"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
        { "WebKit::MediaDescriptionInfo"_s, {
            {
                "String"_s,
                "m_codec"_s
            },
            {
                "bool"_s,
                "m_isVideo"_s
            },
            {
                "bool"_s,
                "m_isAudio"_s
            },
            {
                "bool"_s,
                "m_isText"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
#if ENABLE(GPU_PROCESS)
        { "WebKit::RemoteMediaPlayerProxyConfiguration"_s, {
            {
                "String"_s,
                "referrer"_s
            },
            {
                "String"_s,
                "userAgent"_s
            },
            {
                "String"_s,
                "sourceApplicationIdentifier"_s
            },
            {
                "String"_s,
                "networkInterfaceName"_s
            },
            {
                "String"_s,
                "audioOutputDeviceId"_s
            },
            {
                "Vector<WebCore::ContentType>"_s,
                "mediaContentTypesRequiringHardwareSupport"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "allowedMediaContainerTypes"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "allowedMediaCodecTypes"_s
            },
            {
                "std::optional<Vector<WebCore::FourCC>>"_s,
                "allowedMediaVideoCodecIDs"_s
            },
            {
                "std::optional<Vector<WebCore::FourCC>>"_s,
                "allowedMediaAudioCodecIDs"_s
            },
            {
                "std::optional<Vector<WebCore::FourCC>>"_s,
                "allowedMediaCaptionFormatTypes"_s
            },
            {
                "WebCore::LayoutRect"_s,
                "playerContentBoxRect"_s
            },
            {
                "Vector<String>"_s,
                "preferredAudioCharacteristics"_s
            },
#if PLATFORM(COCOA)
            {
                "Vector<WebCore::PlatformTextTrackData>"_s,
                "outOfBandTrackData"_s
            },
#endif
            {
                "WebCore::SecurityOriginData"_s,
                "documentSecurityOrigin"_s
            },
            {
                "WebCore::IntSize"_s,
                "presentationSize"_s
            },
            {
                "WebCore::FloatSize"_s,
                "videoLayerSize"_s
            },
            {
                "uint64_t"_s,
                "logIdentifier"_s
            },
            {
                "bool"_s,
                "shouldUsePersistentCache"_s
            },
            {
                "bool"_s,
                "isVideo"_s
            },
            {
                "bool"_s,
                "renderingCanBeAccelerated"_s
            },
            {
                "bool"_s,
                "shouldDisableHDR"_s
            },
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "canShowWhileLocked"_s
            },
#endif
#if HAVE(SPATIAL_AUDIO_EXPERIENCE)
            {
                "bool"_s,
                "prefersSpatialAudioExperience"_s
            },
#endif
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
        { "WebKit::RemoteAudioInfo"_s, {
            {
                "WebCore::FourCC"_s,
                "codecName"_s
            },
            {
                "String"_s,
                "codecString"_s
            },
            {
                "WebCore::TrackID"_s,
                "trackID"_s
            },
            {
                "uint32_t"_s,
                "rate"_s
            },
            {
                "uint32_t"_s,
                "channels"_s
            },
            {
                "uint32_t"_s,
                "framesPerPacket"_s
            },
            {
                "uint8_t"_s,
                "bitDepth"_s
            },
            {
                "RefPtr<WebCore::SharedBuffer>"_s,
                "cookieData"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
        { "WebKit::RemoteVideoInfo"_s, {
            {
                "WebCore::FourCC"_s,
                "codecName"_s
            },
            {
                "String"_s,
                "codecString"_s
            },
            {
                "WebCore::TrackID"_s,
                "trackID"_s
            },
            {
                "WebCore::FloatSize"_s,
                "size"_s
            },
            {
                "WebCore::FloatSize"_s,
                "displaySize"_s
            },
            {
                "uint8_t"_s,
                "bitDepth"_s
            },
            {
                "WebCore::PlatformVideoColorSpace"_s,
                "colorSpace"_s
            },
            {
                "RefPtr<WebCore::SharedBuffer>"_s,
                "atomData"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
        { "WebKit::TextTrackPrivateRemoteConfiguration"_s, {
            {
                "WebCore::TrackID"_s,
                "trackId"_s
            },
            {
                "String"_s,
                "label"_s
            },
            {
                "String"_s,
                "language"_s
            },
            {
                "String"_s,
                "inBandMetadataTrackDispatchType"_s
            },
            {
                "MediaTime"_s,
                "startTimeVariance"_s
            },
            {
                "int"_s,
                "trackIndex"_s
            },
            {
                "WebCore::InbandTextTrackPrivate::CueFormat"_s,
                "cueFormat"_s
            },
            {
                "WebCore::InbandTextTrackPrivate::Kind"_s,
                "kind"_s
            },
            {
                "bool"_s,
                "isClosedCaptions"_s
            },
            {
                "bool"_s,
                "isSDH"_s
            },
            {
                "bool"_s,
                "containsOnlyForcedSubtitles"_s
            },
            {
                "bool"_s,
                "isMainProgramContent"_s
            },
            {
                "bool"_s,
                "isEasyToRead"_s
            },
            {
                "bool"_s,
                "isDefault"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
        { "WebKit::TrackPrivateRemoteConfiguration"_s, {
            {
                "WebCore::TrackID"_s,
                "trackId"_s
            },
            {
                "String"_s,
                "label"_s
            },
            {
                "String"_s,
                "language"_s
            },
            {
                "MediaTime"_s,
                "startTimeVariance"_s
            },
            {
                "int"_s,
                "trackIndex"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
        { "WebKit::VideoTrackPrivateRemoteConfiguration"_s, {
            {
                "WebCore::TrackID"_s,
                "trackId"_s
            },
            {
                "String"_s,
                "label"_s
            },
            {
                "String"_s,
                "language"_s
            },
            {
                "MediaTime"_s,
                "startTimeVariance"_s
            },
            {
                "int"_s,
                "trackIndex"_s
            },
            {
                "bool"_s,
                "selected"_s
            },
            {
                "WebCore::VideoTrackPrivate::Kind"_s,
                "kind"_s
            },
            {
                "WebCore::PlatformVideoTrackConfiguration"_s,
                "trackConfiguration"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#if ENABLE(MODEL_PROCESS)
        { "WebKit::ModelProcessCreationParameters"_s, {
            {
                "WebKit::AuxiliaryProcessCreationParameters"_s,
                "auxiliaryProcessParameters"_s
            },
            {
                "ProcessID"_s,
                "parentPID"_s
            },
            {
                "String"_s,
                "applicationVisibleName"_s
            },
            {
                "bool"_s,
                "restrictiveRenderingMode"_s
            },
            {
                "std::optional<int>"_s,
                "debugEntityMemoryLimit"_s
            },
        } },
#endif // ENABLE(MODEL_PROCESS)
        { "WebKit::NetworkProcessCreationParameters"_s, {
            {
                "WebKit::AuxiliaryProcessCreationParameters"_s,
                "auxiliaryProcessParameters"_s
            },
            {
                "WebKit::CacheModel"_s,
                "cacheModel"_s
            },
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
            {
                "Vector<uint8_t>"_s,
                "uiProcessCookieStorageIdentifier"_s
            },
#endif
            {
                "bool"_s,
                "shouldSuppressMemoryPressureHandler"_s
            },
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredForCustomProtocols"_s
            },
#if PLATFORM(COCOA)
            {
                "String"_s,
                "uiProcessBundleIdentifier"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "RetainPtr<CFDataRef>"_s,
                "networkATSContext"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "isParentProcessFullWebBrowserOrRunningTest"_s
            },
#endif
#if USE(SOUP)
            {
                "WebCore::HTTPCookieAcceptPolicy"_s,
                "cookieAcceptPolicy"_s
            },
#endif
#if USE(SOUP)
            {
                "Vector<String>"_s,
                "languages"_s
            },
#endif
#if USE(SOUP)
            {
                "std::optional<MemoryPressureHandler::Configuration>"_s,
                "memoryPressureHandlerConfiguration"_s
            },
#endif
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsSecure"_s
            },
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsBypassingContentSecurityPolicy"_s
            },
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsLocal"_s
            },
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsNoAccess"_s
            },
            {
                "bool"_s,
                "enablePrivateClickMeasurement"_s
            },
            {
                "bool"_s,
                "ftpEnabled"_s
            },
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "enableModernDownloadProgress"_s
            },
#endif
            {
                "Vector<WebKit::WebsiteDataStoreParameters>"_s,
                "websiteDataStoreParameters"_s
            },
            {
                "Vector<std::pair<WebCore::ProcessIdentifier, WebCore::RegistrableDomain>>"_s,
                "allowedFirstPartiesForCookies"_s
            },
            {
                "HashSet<String>"_s,
                "localhostAliasesForTesting"_s
            },
            {
                "Vector<WebCore::OrganizationStorageAccessPromptQuirk>"_s,
                "storageAccessPromptQuirksData"_s
            },
            {
                "Markable<double>"_s,
                "defaultRequestTimeoutInterval"_s
            },
        } },
        { "WebKit::NetworkResourceLoadParameters"_s, {
            {
                "WebKit::WebPageProxyIdentifier"_s,
                "webPageProxyID"_s
            },
            {
                "WebCore::PageIdentifier"_s,
                "webPageID"_s
            },
            {
                "WebCore::FrameIdentifier"_s,
                "webFrameID"_s
            },
            {
                "WebCore::ResourceRequest"_s,
                "request"_s
            },
            {
                "IPC::FormDataReference"_s,
                "requestBody"_s
            },
            {
                "RefPtr<WebCore::SecurityOrigin>"_s,
                "topOrigin"_s
            },
            {
                "RefPtr<WebCore::SecurityOrigin>"_s,
                "sourceOrigin"_s
            },
            {
                "WTF::ProcessID"_s,
                "parentPID"_s
            },
            {
                "WebCore::ContentSniffingPolicy"_s,
                "contentSniffingPolicy"_s
            },
            {
                "WebCore::ContentEncodingSniffingPolicy"_s,
                "contentEncodingSniffingPolicy"_s
            },
            {
                "WebCore::StoredCredentialsPolicy"_s,
                "storedCredentialsPolicy"_s
            },
            {
                "WebCore::ClientCredentialPolicy"_s,
                "clientCredentialPolicy"_s
            },
            {
                "bool"_s,
                "shouldClearReferrerOnHTTPSToHTTPRedirect"_s
            },
            {
                "bool"_s,
                "needsCertificateInfo"_s
            },
            {
                "bool"_s,
                "isMainFrameNavigation"_s
            },
            {
                "std::optional<WebKit::NavigationActionData>"_s,
                "mainResourceNavigationDataForAnyFrame"_s
            },
            {
                "WebKit::PreconnectOnly"_s,
                "shouldPreconnectOnly"_s
            },
            {
                "std::optional<WebKit::NavigatingToAppBoundDomain>"_s,
                "isNavigatingToAppBoundDomain"_s
            },
            {
                "bool"_s,
                "hadMainFrameMainResourcePrivateRelayed"_s
            },
            {
                "bool"_s,
                "allowPrivacyProxy"_s
            },
            {
                "OptionSet<WebCore::AdvancedPrivacyProtections>"_s,
                "advancedPrivacyProtections"_s
            },
            {
                "uint64_t"_s,
                "requiredCookiesVersion"_s
            },
            {
                "Markable<WebCore::ResourceLoaderIdentifier>"_s,
                "identifier"_s
            },
            {
                "Vector<WebKit::SandboxExtensionHandle>"_s,
                "requestBodySandboxExtensions"_s
            },
            {
                "std::optional<WebKit::SandboxExtensionHandle>"_s,
                "resourceSandboxExtension"_s
            },
            {
                "Seconds"_s,
                "maximumBufferingTime"_s
            },
            {
                "WebCore::FetchOptions"_s,
                "options"_s
            },
            {
                "std::optional<WebCore::ContentSecurityPolicyResponseHeaders>"_s,
                "cspResponseHeaders"_s
            },
            {
                "URL"_s,
                "parentFrameURL"_s
            },
            {
                "URL"_s,
                "frameURL"_s
            },
            {
                "WebCore::CrossOriginEmbedderPolicy"_s,
                "parentCrossOriginEmbedderPolicy"_s
            },
            {
                "WebCore::CrossOriginEmbedderPolicy"_s,
                "crossOriginEmbedderPolicy"_s
            },
            {
                "WebCore::HTTPHeaderMap"_s,
                "originalRequestHeaders"_s
            },
            {
                "bool"_s,
                "shouldRestrictHTTPResponseAccess"_s
            },
            {
                "WebCore::PreflightPolicy"_s,
                "preflightPolicy"_s
            },
            {
                "bool"_s,
                "shouldEnableCrossOriginResourcePolicy"_s
            },
            {
                "Vector<Ref<WebCore::SecurityOrigin>>"_s,
                "frameAncestorOrigins"_s
            },
            {
                "bool"_s,
                "pageHasResourceLoadClient"_s
            },
            {
                "std::optional<WebCore::FrameIdentifier>"_s,
                "parentFrameID"_s
            },
            {
                "bool"_s,
                "crossOriginAccessControlCheckEnabled"_s
            },
            {
                "URL"_s,
                "documentURL"_s
            },
            {
                "bool"_s,
                "isCrossOriginOpenerPolicyEnabled"_s
            },
            {
                "bool"_s,
                "isClearSiteDataHeaderEnabled"_s
            },
            {
                "bool"_s,
                "isClearSiteDataExecutionContextEnabled"_s
            },
            {
                "bool"_s,
                "isDisplayingInitialEmptyDocument"_s
            },
            {
                "WebCore::SandboxFlags"_s,
                "effectiveSandboxFlags"_s
            },
            {
                "URL"_s,
                "openerURL"_s
            },
            {
                "WebCore::CrossOriginOpenerPolicy"_s,
                "sourceCrossOriginOpenerPolicy"_s
            },
            {
                "std::optional<WebCore::NavigationIdentifier>"_s,
                "navigationID"_s
            },
            {
                "std::optional<WebCore::NavigationRequester>"_s,
                "navigationRequester"_s
            },
            {
                "WebCore::ServiceWorkersMode"_s,
                "serviceWorkersMode"_s
            },
            {
                "std::optional<WebCore::ServiceWorkerRegistrationIdentifier>"_s,
                "serviceWorkerRegistrationIdentifier"_s
            },
            {
                "OptionSet<WebCore::HTTPHeadersToKeepFromCleaning>"_s,
                "httpHeadersToKeep"_s
            },
            {
                "std::optional<WebCore::FetchIdentifier>"_s,
                "navigationPreloadIdentifier"_s
            },
            {
                "WebCore::FetchingWorkerIdentifier"_s,
                "workerIdentifier"_s
            },
#if ENABLE(CONTENT_EXTENSIONS)
            {
                "URL"_s,
                "mainDocumentURL"_s
            },
#endif
#if ENABLE(CONTENT_EXTENSIONS)
            {
                "std::optional<WebKit::UserContentControllerIdentifier>"_s,
                "userContentControllerIdentifier"_s
            },
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
            {
                "bool"_s,
                "pageHasLoadedWebExtensions"_s
            },
#endif
            {
                "bool"_s,
                "linkPreconnectEarlyHintsEnabled"_s
            },
            {
                "bool"_s,
                "shouldRecordFrameLoadForStorageAccess"_s
            },
        } },
        { "WebKit::NetworkSessionCreationParameters"_s, {
            {
                "PAL::SessionID"_s,
                "sessionID"_s
            },
            {
                "Markable<WTF::UUID>"_s,
                "dataStoreIdentifier"_s
            },
            {
                "String"_s,
                "boundInterfaceIdentifier"_s
            },
            {
                "WebKit::AllowsCellularAccess"_s,
                "allowsCellularAccess"_s
            },
#if PLATFORM(COCOA)
            {
                "RetainPtr<CFDictionaryRef>"_s,
                "proxyConfiguration"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "String"_s,
                "sourceApplicationBundleIdentifier"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "String"_s,
                "sourceApplicationSecondaryIdentifier"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "shouldLogCookieInformation"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "URL"_s,
                "httpProxy"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "URL"_s,
                "httpsProxy"_s
            },
#endif
#if HAVE(ALTERNATIVE_SERVICE)
            {
                "String"_s,
                "alternativeServiceDirectory"_s
            },
#endif
#if HAVE(ALTERNATIVE_SERVICE)
            {
                "WebKit::SandboxExtensionHandle"_s,
                "alternativeServiceDirectoryExtensionHandle"_s
            },
#endif
            {
                "String"_s,
                "hstsStorageDirectory"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "hstsStorageDirectoryExtensionHandle"_s
            },
#if USE(SOUP)
            {
                "String"_s,
                "cookiePersistentStoragePath"_s
            },
#endif
#if USE(SOUP)
            {
                "WebKit::SoupCookiePersistentStorageType"_s,
                "cookiePersistentStorageType"_s
            },
#endif
#if USE(SOUP)
            {
                "bool"_s,
                "persistentCredentialStorageEnabled"_s
            },
#endif
#if USE(SOUP)
            {
                "bool"_s,
                "ignoreTLSErrors"_s
            },
#endif
#if USE(SOUP)
            {
                "WebCore::SoupNetworkProxySettings"_s,
                "proxySettings"_s
            },
#endif
#if USE(SOUP)
            {
                "WebCore::HTTPCookieAcceptPolicy"_s,
                "cookieAcceptPolicy"_s
            },
#endif
#if USE(CURL)
            {
                "String"_s,
                "cookiePersistentStorageFile"_s
            },
#endif
#if USE(CURL)
            {
                "WebCore::CurlProxySettings"_s,
                "proxySettings"_s
            },
#endif
            {
                "bool"_s,
                "deviceManagementRestrictionsEnabled"_s
            },
            {
                "bool"_s,
                "allLoadsBlockedByDeviceManagementRestrictionsForTesting"_s
            },
            {
                "WebKit::WebPushD::WebPushDaemonConnectionConfiguration"_s,
                "webPushDaemonConnectionConfiguration"_s
            },
            {
                "String"_s,
                "networkCacheDirectory"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "networkCacheDirectoryExtensionHandle"_s
            },
            {
                "String"_s,
                "dataConnectionServiceType"_s
            },
            {
                "bool"_s,
                "fastServerTrustEvaluationEnabled"_s
            },
            {
                "bool"_s,
                "networkCacheSpeculativeValidationEnabled"_s
            },
            {
                "bool"_s,
                "shouldUseTestingNetworkSession"_s
            },
            {
                "bool"_s,
                "staleWhileRevalidateEnabled"_s
            },
            {
                "unsigned"_s,
                "testSpeedMultiplier"_s
            },
            {
                "bool"_s,
                "suppressesConnectionTerminationOnSystemChange"_s
            },
            {
                "bool"_s,
                "allowsServerPreconnect"_s
            },
            {
                "bool"_s,
                "requiresSecureHTTPSProxyConnection"_s
            },
            {
                "bool"_s,
                "shouldRunServiceWorkersOnMainThreadForTesting"_s
            },
            {
                "std::optional<unsigned>"_s,
                "overrideServiceWorkerRegistrationCountTestingValue"_s
            },
            {
                "bool"_s,
                "preventsSystemHTTPProxyAuthentication"_s
            },
            {
                "std::optional<bool>"_s,
                "useNetworkLoader"_s
            },
            {
                "bool"_s,
                "allowsHSTSWithUntrustedRootCertificate"_s
            },
            {
                "String"_s,
                "pcmMachServiceName"_s
            },
            {
                "String"_s,
                "webPushMachServiceName"_s
            },
            {
                "String"_s,
                "webPushPartitionString"_s
            },
            {
                "bool"_s,
                "enablePrivateClickMeasurementDebugMode"_s
            },
            {
                "bool"_s,
                "isOptInCookiePartitioningEnabled"_s
            },
            {
                "bool"_s,
                "shouldSendPrivateTokenIPCForTesting"_s
            },
            {
                "uint64_t"_s,
                "cookiesVersion"_s
            },
            {
                "WebKit::UnifiedOriginStorageLevel"_s,
                "unifiedOriginStorageLevel"_s
            },
            {
                "uint64_t"_s,
                "perOriginStorageQuota"_s
            },
            {
                "std::optional<double>"_s,
                "originQuotaRatio"_s
            },
            {
                "std::optional<double>"_s,
                "totalQuotaRatio"_s
            },
            {
                "std::optional<uint64_t>"_s,
                "standardVolumeCapacity"_s
            },
            {
                "std::optional<uint64_t>"_s,
                "volumeCapacityOverride"_s
            },
            {
                "String"_s,
                "localStorageDirectory"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "localStorageDirectoryExtensionHandle"_s
            },
            {
                "String"_s,
                "indexedDBDirectory"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "indexedDBDirectoryExtensionHandle"_s
            },
            {
                "String"_s,
                "cacheStorageDirectory"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "cacheStorageDirectoryExtensionHandle"_s
            },
            {
                "String"_s,
                "generalStorageDirectory"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "generalStorageDirectoryHandle"_s
            },
            {
                "String"_s,
                "serviceWorkerRegistrationDirectory"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "serviceWorkerRegistrationDirectoryExtensionHandle"_s
            },
            {
                "bool"_s,
                "serviceWorkerProcessTerminationDelayEnabled"_s
            },
            {
                "bool"_s,
                "inspectionForServiceWorkersAllowed"_s
            },
            {
                "bool"_s,
                "storageSiteValidationEnabled"_s
            },
#if ENABLE(DECLARATIVE_WEB_PUSH)
            {
                "bool"_s,
                "isDeclarativeWebPushEnabled"_s
            },
#endif
#if HAVE(NW_PROXY_CONFIG)
            {
                "std::optional<Vector<std::pair<Vector<uint8_t>, std::optional<WTF::UUID>>>>"_s,
                "proxyConfigData"_s
            },
#endif
            {
                "WebKit::ResourceLoadStatisticsParameters"_s,
                "resourceLoadStatisticsParameters"_s
            },
#if ENABLE(CONTENT_EXTENSIONS)
            {
                "String"_s,
                "resourceMonitorThrottlerDirectory"_s
            },
#endif
#if ENABLE(CONTENT_EXTENSIONS)
            {
                "WebKit::SandboxExtensionHandle"_s,
                "resourceMonitorThrottlerDirectoryExtensionHandle"_s
            },
#endif
            {
                "bool"_s,
                "isLegacyTLSAllowed"_s
            },
#if HAVE(WEBCONTENTRESTRICTIONS_PATH_SPI)
            {
                "String"_s,
                "webContentRestrictionsConfigurationFile"_s
            },
#endif
#if HAVE(WEBCONTENTRESTRICTIONS_PATH_SPI)
            {
                "WebKit::SandboxExtension::Handle"_s,
                "webContentRestrictionsConfigurationExtensionHandle"_s
            },
#endif
        } },
        { "WebKit::ITPThirdPartyData"_s, {
            {
                "WebCore::RegistrableDomain"_s,
                "thirdPartyDomain"_s
            },
            {
                "Vector<WebKit::ITPThirdPartyDataForSpecificFirstParty>"_s,
                "underFirstParties"_s
            },
        } },
        { "WebKit::ITPThirdPartyDataForSpecificFirstParty"_s, {
            {
                "WebCore::RegistrableDomain"_s,
                "firstPartyDomain"_s
            },
            {
                "bool"_s,
                "storageAccessGranted"_s
            },
            {
                "Seconds"_s,
                "timeLastUpdated"_s
            },
        } },
        { "IPC::ConnectionHandle"_s, {
#if USE(UNIX_DOMAIN_SOCKETS)
            {
                "UnixFileDescriptor"_s,
                "m_handle"_s
            },
#endif
#if OS(WINDOWS)
            {
                "Win32Handle"_s,
                "m_handle"_s
            },
#endif
#if OS(DARWIN)
            {
                "MachSendRight"_s,
                "m_handle"_s
            },
#endif
        } },
        { "IPC::FormDataReference"_s, {
            {
                "RefPtr<WebCore::FormData>"_s,
                "data()"_s
            },
            {
                "Vector<WebKit::SandboxExtensionHandle>"_s,
                "sandboxExtensionHandles()"_s
            },
        } },
        { "IPC::Signal"_s, {
#if PLATFORM(COCOA)
            {
                "MachSendRight"_s,
                "takeSendRight()"_s
            },
#endif
#if !PLATFORM(COCOA)
            {
                "IPC::Semaphore"_s,
                "semaphore()"_s
            },
#endif
        } },
        { "IPC::Semaphore"_s, {
#if PLATFORM(COCOA)
            {
                "MachSendRight"_s,
                "createSendRight()"_s
            },
#endif
#if OS(WINDOWS)
            {
                "Win32Handle"_s,
                "win32Handle()"_s
            },
#endif
#if USE(UNIX_DOMAIN_SOCKETS)
            {
                "UnixFileDescriptor"_s,
                "duplicateDescriptor()"_s
            },
#endif
        } },
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
        { "WebKit::RemoteVideoFrameReference"_s, {
            {
                "WebKit::RemoteVideoFrameIdentifier"_s,
                "identifier()"_s
            },
            {
                "uint64_t"_s,
                "version()"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
        { "WebKit::RemoteVideoFrameWriteReference"_s, {
            {
                "WebKit::RemoteVideoFrameReference"_s,
                "reference()"_s
            },
            {
                "uint64_t"_s,
                "pendingReads()"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
        { "WebKit::RemoteVideoFrameReadReference"_s, {
            {
                "WebKit::RemoteVideoFrameReference"_s,
                "reference()"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#if ENABLE(GPU_PROCESS)
        { "WebKit::RemoteSerializedImageBufferReference"_s, {
            {
                "WebKit::RemoteSerializedImageBufferIdentifier"_s,
                "identifier()"_s
            },
            {
                "uint64_t"_s,
                "version()"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::RemoteSerializedImageBufferWriteReference"_s, {
            {
                "WebKit::RemoteSerializedImageBufferReference"_s,
                "reference()"_s
            },
            {
                "uint64_t"_s,
                "pendingReads()"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::RemoteSerializedImageBufferReadReference"_s, {
            {
                "WebKit::RemoteSerializedImageBufferReference"_s,
                "reference()"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if !USE(UNIX_DOMAIN_SOCKETS)
        { "IPC::SharedBufferReference::SerializableBuffer"_s, {
            {
                "uint64_t"_s,
                "size"_s
            },
            {
                "std::optional<WebCore::SharedMemory::Handle>"_s,
                "handle"_s
            },
        } },
#endif // !USE(UNIX_DOMAIN_SOCKETS)
        { "IPC::SharedBufferReference"_s, {
#if USE(UNIX_DOMAIN_SOCKETS)
            {
                "RefPtr<WebCore::FragmentedSharedBuffer>"_s,
                "buffer()"_s
            },
#endif
#if !(USE(UNIX_DOMAIN_SOCKETS))
            {
                "std::optional<IPC::SharedBufferReference::SerializableBuffer>"_s,
                "serializableBuffer()"_s
            },
#endif
        } },
        { "IPC::SharedFileHandle"_s, {
#if PLATFORM(COCOA)
            {
                "MachSendRight"_s,
                "toMachSendRight()"_s
            },
#endif
        } },
        { "IPC::StreamServerConnectionHandle"_s, {
            {
                "IPC::ConnectionHandle"_s,
                "outOfStreamConnection"_s
            },
            {
                "WebCore::SharedMemoryHandle"_s,
                "buffer"_s
            },
        } },
        { "WebKit::AccessibilityPreferences"_s, {
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
            {
                "WebKit::WebKitAXValueState"_s,
                "reduceMotionEnabled"_s
            },
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
            {
                "WebKit::WebKitAXValueState"_s,
                "increaseButtonLegibility"_s
            },
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
            {
                "WebKit::WebKitAXValueState"_s,
                "enhanceTextLegibility"_s
            },
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
            {
                "WebKit::WebKitAXValueState"_s,
                "darkenSystemColors"_s
            },
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
            {
                "WebKit::WebKitAXValueState"_s,
                "invertColorsEnabled"_s
            },
#endif
            {
                "bool"_s,
                "imageAnimationEnabled"_s
            },
            {
                "bool"_s,
                "enhanceTextLegibilityOverall"_s
            },
#if ENABLE(ACCESSIBILITY_NON_BLINKING_CURSOR)
            {
                "bool"_s,
                "prefersNonBlinkingCursor"_s
            },
#endif
        } },
        { "WebKit::AuxiliaryProcessCreationParameters"_s, {
            {
                "String"_s,
                "wtfLoggingChannels"_s
            },
            {
                "String"_s,
                "webCoreLoggingChannels"_s
            },
            {
                "String"_s,
                "webKitLoggingChannels"_s
            },
            {
                "std::unique_ptr<HashSet<String>>"_s,
                "classNamesExemptFromSecureCodingCrash"_s
            },
        } },
        { "WebKit::BackgroundFetchState"_s, {
            {
                "WebCore::SecurityOriginData"_s,
                "topOrigin"_s
            },
            {
                "URL"_s,
                "scope"_s
            },
            {
                "String"_s,
                "identifier"_s
            },
            {
                "WebCore::BackgroundFetchOptions"_s,
                "options"_s
            },
            {
                "uint64_t"_s,
                "downloadTotal"_s
            },
            {
                "uint64_t"_s,
                "downloaded"_s
            },
            {
                "uint64_t"_s,
                "uploadTotal"_s
            },
            {
                "uint64_t"_s,
                "uploaded"_s
            },
            {
                "WebCore::BackgroundFetchResult"_s,
                "result"_s
            },
            {
                "WebCore::BackgroundFetchFailureReason"_s,
                "failureReason"_s
            },
            {
                "bool"_s,
                "isPaused"_s
            },
        } },
        { "WebKit::CallbackID"_s, {
            {
                "uint64_t"_s,
                "m_id"_s
            },
        } },
        { "WebKit::ContentWorldData"_s, {
            {
                "WebKit::ContentWorldIdentifier"_s,
                "identifier"_s
            },
            {
                "String"_s,
                "name"_s
            },
            {
                "OptionSet<WebKit::ContentWorldOption>"_s,
                "options"_s
            },
        } },
#if ENABLE(CONTEXT_MENUS)
        { "WebKit::ContextMenuContextData"_s, {
            {
                "WebCore::ContextMenuContextType"_s,
                "type()"_s
            },
            {
                "WebCore::IntPoint"_s,
                "menuLocation()"_s
            },
            {
                "Vector<WebKit::WebContextMenuItemData>"_s,
                "menuItems()"_s
            },
            {
                "std::optional<WebKit::WebHitTestResultData>"_s,
                "webHitTestResultData()"_s
            },
            {
                "String"_s,
                "selectedText()"_s
            },
#if ENABLE(SERVICE_CONTROLS)
            {
                "std::optional<WebCore::ShareableBitmapHandle>"_s,
                "createControlledImageReadOnlyHandle()"_s
            },
#endif
#if ENABLE(SERVICE_CONTROLS)
            {
                "WebCore::AttributedString"_s,
                "controlledSelection()"_s
            },
#endif
#if ENABLE(SERVICE_CONTROLS)
            {
                "Vector<String>"_s,
                "selectedTelephoneNumbers()"_s
            },
#endif
#if ENABLE(SERVICE_CONTROLS)
            {
                "bool"_s,
                "selectionIsEditable()"_s
            },
#endif
#if ENABLE(SERVICE_CONTROLS)
            {
                "WebCore::IntRect"_s,
                "controlledImageBounds()"_s
            },
#endif
#if ENABLE(SERVICE_CONTROLS)
            {
                "String"_s,
                "controlledImageAttachmentID()"_s
            },
#endif
#if ENABLE(SERVICE_CONTROLS)
            {
                "std::optional<WebCore::ElementContext>"_s,
                "controlledImageElementContext()"_s
            },
#endif
#if ENABLE(SERVICE_CONTROLS)
            {
                "String"_s,
                "controlledImageMIMEType()"_s
            },
#endif
#if ENABLE(CONTEXT_MENU_QR_CODE_DETECTION)
            {
                "std::optional<WebCore::ShareableBitmapHandle>"_s,
                "createPotentialQRCodeNodeSnapshotImageReadOnlyHandle()"_s
            },
#endif
#if ENABLE(CONTEXT_MENU_QR_CODE_DETECTION)
            {
                "std::optional<WebCore::ShareableBitmapHandle>"_s,
                "createPotentialQRCodeViewportSnapshotImageReadOnlyHandle()"_s
            },
#endif
            {
                "bool"_s,
                "hasEntireImage()"_s
            },
            {
                "bool"_s,
                "allowsFollowingLink()"_s
            },
            {
                "bool"_s,
                "allowsFollowingImageURL()"_s
            },
        } },
#endif // ENABLE(CONTEXT_MENUS)
        { "WebKit::DebuggableInfoData"_s, {
            {
                "Inspector::DebuggableType"_s,
                "debuggableType"_s
            },
            {
                "String"_s,
                "targetPlatformName"_s
            },
            {
                "String"_s,
                "targetBuildVersion"_s
            },
            {
                "String"_s,
                "targetProductVersion"_s
            },
            {
                "bool"_s,
                "targetIsSimulator"_s
            },
        } },
#if PLATFORM(IOS_FAMILY)
        { "WebKit::DocumentEditingContext::Range"_s, {
            {
                "uint64_t"_s,
                "location"_s
            },
            {
                "uint64_t"_s,
                "length"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
#if PLATFORM(IOS_FAMILY)
        { "WebKit::DocumentEditingContext::TextRectAndRange"_s, {
            {
                "WebCore::FloatRect"_s,
                "rect"_s
            },
            {
                "WebKit::DocumentEditingContext::Range"_s,
                "range"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
#if PLATFORM(IOS_FAMILY)
        { "WebKit::DocumentEditingContextRequest"_s, {
            {
                "OptionSet<WebKit::DocumentEditingContextRequest::Options>"_s,
                "options"_s
            },
            {
                "WebCore::TextGranularity"_s,
                "surroundingGranularity"_s
            },
            {
                "int64_t"_s,
                "granularityCount"_s
            },
            {
                "WebCore::FloatRect"_s,
                "rect"_s
            },
            {
                "std::optional<WebCore::ElementContext>"_s,
                "textInputContext"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
#if PLATFORM(IOS_FAMILY)
        { "WebKit::DocumentEditingContext"_s, {
            {
                "WebCore::AttributedString"_s,
                "contextBefore"_s
            },
            {
                "WebCore::AttributedString"_s,
                "selectedText"_s
            },
            {
                "WebCore::AttributedString"_s,
                "contextAfter"_s
            },
            {
                "WebCore::AttributedString"_s,
                "markedText"_s
            },
            {
                "WebCore::AttributedString"_s,
                "annotatedText"_s
            },
            {
                "WebKit::DocumentEditingContext::Range"_s,
                "selectedRangeInMarkedText"_s
            },
            {
                "Vector<WebKit::DocumentEditingContext::TextRectAndRange>"_s,
                "textRects"_s
            },
            {
                "Vector<WebKit::DocumentEditingContext::Range>"_s,
                "autocorrectedRanges"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
        { "WebKit::EditingRange"_s, {
            {
                "uint64_t"_s,
                "location"_s
            },
            {
                "uint64_t"_s,
                "length"_s
            },
        } },
        { "WebKit::EditorState"_s, {
            {
                "WebKit::EditorStateIdentifier"_s,
                "identifier"_s
            },
            {
                "bool"_s,
                "shouldIgnoreSelectionChanges"_s
            },
            {
                "bool"_s,
                "selectionIsNone"_s
            },
            {
                "bool"_s,
                "selectionIsRange"_s
            },
            {
                "bool"_s,
                "selectionIsRangeInsideImageOverlay"_s
            },
            {
                "bool"_s,
                "selectionIsRangeInAutoFilledAndViewableField"_s
            },
            {
                "bool"_s,
                "isContentEditable"_s
            },
            {
                "bool"_s,
                "isContentRichlyEditable"_s
            },
            {
                "bool"_s,
                "isInPasswordField"_s
            },
            {
                "bool"_s,
                "hasComposition"_s
            },
            {
                "bool"_s,
                "triggeredByAccessibilitySelectionChange"_s
            },
            {
                "bool"_s,
                "isInPlugin"_s
            },
#if PLATFORM(MAC)
            {
                "bool"_s,
                "canEnableAutomaticSpellingCorrection"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "bool"_s,
                "inputMethodUsesCorrectKeyEventOrder"_s
            },
#endif
            {
                "std::optional<WebKit::EditorState::PostLayoutData>"_s,
                "postLayoutData"_s
            },
            {
                "std::optional<WebKit::EditorState::VisualData>"_s,
                "visualData"_s
            },
        } },
        { "WebKit::EditorState::PostLayoutData"_s, {
            {
                "OptionSet<WebKit::TypingAttribute>"_s,
                "typingAttributes"_s
            },
#if PLATFORM(COCOA)
            {
                "uint64_t"_s,
                "selectedTextLength"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "WebKit::TextAlignment"_s,
                "textAlignment"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "WebCore::Color"_s,
                "textColor"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "WebKit::ListType"_s,
                "enclosingListType"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "WebCore::WritingDirection"_s,
                "baseWritingDirection"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "selectionIsTransparentOrFullyClipped"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "canEnableWritingSuggestions"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "String"_s,
                "markedText"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "String"_s,
                "wordAtSelection"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "char32_t"_s,
                "characterAfterSelection"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "char32_t"_s,
                "characterBeforeSelection"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "char32_t"_s,
                "twoCharacterBeforeSelection"_s
            },
#endif
#if PLATFORM(IOS_FAMILY) && USE(DICTATION_ALTERNATIVES)
            {
                "Vector<WebCore::DictationContext>"_s,
                "dictationContextsForSelection"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "isReplaceAllowed"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "hasContent"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "isStableStateUpdate"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "insideFixedPosition"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "hasPlainText"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::Color"_s,
                "caretColor"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "hasCaretColorAuto"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "atStartOfSentence"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "selectionStartIsAtParagraphBoundary"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "selectionEndIsAtParagraphBoundary"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "hasGrammarDocumentMarkers"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "std::optional<WebCore::ElementContext>"_s,
                "selectedEditableImage"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "WebCore::IntRect"_s,
                "selectionBoundingRect"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "uint64_t"_s,
                "candidateRequestStartPosition"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "String"_s,
                "paragraphContextForCandidateRequest"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "String"_s,
                "stringForCandidateRequest"_s
            },
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            {
                "String"_s,
                "surroundingContext"_s
            },
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            {
                "uint64_t"_s,
                "surroundingContextCursorPosition"_s
            },
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            {
                "uint64_t"_s,
                "surroundingContextSelectionPosition"_s
            },
#endif
            {
                "std::optional<WebCore::FontAttributes>"_s,
                "fontAttributes"_s
            },
            {
                "bool"_s,
                "canCut"_s
            },
            {
                "bool"_s,
                "canCopy"_s
            },
            {
                "bool"_s,
                "canPaste"_s
            },
        } },
        { "WebKit::EditorState::VisualData"_s, {
#if PLATFORM(IOS_FAMILY) || PLATFORM(GTK) || PLATFORM(WPE)
            {
                "WebCore::IntRect"_s,
                "caretRectAtStart"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::IntRect"_s,
                "selectionClipRect"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::IntRect"_s,
                "editableRootBounds"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::IntRect"_s,
                "caretRectAtEnd"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "Vector<WebCore::SelectionGeometry>"_s,
                "selectionGeometries"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "Vector<WebCore::SelectionGeometry>"_s,
                "markedTextRects"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::IntRect"_s,
                "markedTextCaretRectAtStart"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::IntRect"_s,
                "markedTextCaretRectAtEnd"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "std::optional<WebCore::PlatformLayerIdentifier>"_s,
                "enclosingLayerID"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "Vector<WebCore::PlatformLayerIdentifier>"_s,
                "intersectingLayerIDs"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "std::optional<WebCore::ScrollingNodeID>"_s,
                "enclosingScrollingNodeID"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "std::optional<WebCore::ScrollingNodeID>"_s,
                "scrollingNodeIDAtStart"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "std::optional<WebCore::ScrollingNodeID>"_s,
                "scrollingNodeIDAtEnd"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::ScrollOffset"_s,
                "enclosingScrollOffset"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "enclosingLayerUsesContentsLayer"_s
            },
#endif
        } },
        { "WebKit::FileSystemSyncAccessHandleInfo"_s, {
            {
                "Markable<WebCore::FileSystemSyncAccessHandleIdentifier>"_s,
                "identifier"_s
            },
            {
                "IPC::SharedFileHandle"_s,
                "handle"_s
            },
            {
                "uint64_t"_s,
                "capacity"_s
            },
        } },
#if PLATFORM(IOS_FAMILY)
        { "WebKit::OptionItem"_s, {
            {
                "String"_s,
                "text"_s
            },
            {
                "bool"_s,
                "isGroup"_s
            },
            {
                "bool"_s,
                "isSelected"_s
            },
            {
                "bool"_s,
                "disabled"_s
            },
            {
                "int"_s,
                "parentGroupID"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
#if PLATFORM(IOS_FAMILY)
        { "WebKit::FocusedElementInformation"_s, {
            {
                "WebCore::IntRect"_s,
                "interactionRect"_s
            },
            {
                "WebCore::ElementContext"_s,
                "elementContext"_s
            },
            {
                "WebCore::IntPoint"_s,
                "lastInteractionLocation"_s
            },
            {
                "double"_s,
                "minimumScaleFactor"_s
            },
            {
                "double"_s,
                "maximumScaleFactor"_s
            },
            {
                "double"_s,
                "maximumScaleFactorIgnoringAlwaysScalable"_s
            },
            {
                "double"_s,
                "nodeFontSize"_s
            },
            {
                "bool"_s,
                "hasNextNode"_s
            },
            {
                "WebCore::IntRect"_s,
                "nextNodeRect"_s
            },
            {
                "bool"_s,
                "hasPreviousNode"_s
            },
            {
                "WebCore::IntRect"_s,
                "previousNodeRect"_s
            },
            {
                "bool"_s,
                "isAutocorrect"_s
            },
            {
                "bool"_s,
                "isRTL"_s
            },
            {
                "bool"_s,
                "isMultiSelect"_s
            },
            {
                "bool"_s,
                "isReadOnly"_s
            },
            {
                "bool"_s,
                "allowsUserScaling"_s
            },
            {
                "bool"_s,
                "allowsUserScalingIgnoringAlwaysScalable"_s
            },
            {
                "bool"_s,
                "insideFixedPosition"_s
            },
            {
                "bool"_s,
                "hasPlainText"_s
            },
            {
                "WebCore::AutocapitalizeType"_s,
                "autocapitalizeType"_s
            },
            {
                "WebKit::InputType"_s,
                "elementType"_s
            },
            {
                "WebCore::InputMode"_s,
                "inputMode"_s
            },
            {
                "WebCore::EnterKeyHint"_s,
                "enterKeyHint"_s
            },
            {
                "String"_s,
                "formAction"_s
            },
            {
                "Vector<WebKit::OptionItem>"_s,
                "selectOptions"_s
            },
            {
                "int"_s,
                "selectedIndex"_s
            },
            {
                "String"_s,
                "value"_s
            },
            {
                "double"_s,
                "valueAsNumber"_s
            },
            {
                "String"_s,
                "title"_s
            },
            {
                "bool"_s,
                "acceptsAutofilledLoginCredentials"_s
            },
            {
                "bool"_s,
                "isAutofillableUsernameField"_s
            },
            {
                "URL"_s,
                "representingPageURL"_s
            },
            {
                "WebCore::AutofillFieldName"_s,
                "autofillFieldName"_s
            },
            {
                "WebCore::NonAutofillCredentialType"_s,
                "nonAutofillCredentialType"_s
            },
            {
                "String"_s,
                "placeholder"_s
            },
            {
                "String"_s,
                "label"_s
            },
            {
                "String"_s,
                "ariaLabel"_s
            },
            {
                "bool"_s,
                "hasSuggestions"_s
            },
            {
                "bool"_s,
                "isFocusingWithDataListDropdown"_s
            },
            {
                "WebCore::Color"_s,
                "colorValue"_s
            },
            {
                "WebKit::ColorControlSupportsAlpha"_s,
                "supportsAlpha"_s
            },
            {
                "Vector<WebCore::Color>"_s,
                "suggestedColors"_s
            },
            {
                "bool"_s,
                "hasEverBeenPasswordField"_s
            },
            {
                "bool"_s,
                "shouldSynthesizeKeyEventsForEditing"_s
            },
            {
                "bool"_s,
                "isSpellCheckingEnabled"_s
            },
            {
                "bool"_s,
                "isWritingSuggestionsEnabled"_s
            },
            {
                "bool"_s,
                "shouldAvoidResizingWhenInputViewBoundsChange"_s
            },
            {
                "bool"_s,
                "shouldAvoidScrollingWhenFocusedContentIsVisible"_s
            },
            {
                "bool"_s,
                "shouldUseLegacySelectPopoverDismissalBehaviorInDataActivation"_s
            },
            {
                "bool"_s,
                "shouldHideSoftTopScrollEdgeEffect"_s
            },
            {
                "bool"_s,
                "isFocusingWithValidationMessage"_s
            },
            {
                "bool"_s,
                "preventScroll"_s
            },
            {
                "WebKit::FocusedElementInformationIdentifier"_s,
                "identifier"_s
            },
            {
                "Markable<WebCore::ScrollingNodeID>"_s,
                "containerScrollingNodeID"_s
            },
            {
                "std::optional<WebKit::FrameInfoData>"_s,
                "frame"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
        { "WebKit::FrameInfoData"_s, {
            {
                "bool"_s,
                "isMainFrame"_s
            },
            {
                "WebKit::FrameType"_s,
                "frameType"_s
            },
            {
                "WebCore::ResourceRequest"_s,
                "request"_s
            },
            {
                "WebCore::SecurityOriginData"_s,
                "securityOrigin"_s
            },
            {
                "String"_s,
                "frameName"_s
            },
            {
                "WebCore::FrameIdentifier"_s,
                "frameID"_s
            },
            {
                "Markable<WebCore::FrameIdentifier>"_s,
                "parentFrameID"_s
            },
            {
                "Markable<WebCore::ScriptExecutionContextIdentifier>"_s,
                "documentID"_s
            },
            {
                "WebCore::CertificateInfo"_s,
                "certificateInfo"_s
            },
            {
                "WTF::ProcessID"_s,
                "processID"_s
            },
            {
                "bool"_s,
                "isFocused"_s
            },
            {
                "bool"_s,
                "errorOccurred"_s
            },
            {
                "WebKit::WebFrameMetrics"_s,
                "frameMetrics"_s
            },
        } },
        { "WebKit::FrameTreeCreationParameters"_s, {
            {
                "WebCore::FrameIdentifier"_s,
                "frameID"_s
            },
            {
                "std::optional<WebCore::FrameIdentifier>"_s,
                "openerFrameID"_s
            },
            {
                "String"_s,
                "frameName"_s
            },
            {
                "Ref<WebCore::FrameTreeSyncData>"_s,
                "frameTreeSyncData"_s
            },
            {
                "Vector<WebKit::FrameTreeCreationParameters>"_s,
                "children"_s
            },
        } },
        { "WebKit::FrameTreeNodeData"_s, {
            {
                "WebKit::FrameInfoData"_s,
                "info"_s
            },
            {
                "Vector<WebKit::FrameTreeNodeData>"_s,
                "children"_s
            },
        } },
        { "WebKit::FullScreenMediaDetails"_s, {
            {
                "WebKit::FullScreenMediaDetails::Type"_s,
                "type"_s
            },
            {
                "WebCore::FloatSize"_s,
                "mediaDimensions"_s
            },
            {
                "String"_s,
                "mimeType"_s
            },
            {
                "std::optional<WebCore::SharedMemory::Handle>"_s,
                "imageHandle"_s
            },
        } },
#if ENABLE(GPU_PROCESS)
        { "WebKit::GPUProcessConnectionParameters"_s, {
            {
                "WebCore::ProcessIdentity"_s,
                "webProcessIdentity"_s
            },
            {
                "WebKit::SharedPreferencesForWebProcess"_s,
                "sharedPreferencesForWebProcess"_s
            },
            {
                "bool"_s,
                "isLockdownModeEnabled"_s
            },
#if ENABLE(IPC_TESTING_API)
            {
                "bool"_s,
                "ignoreInvalidMessageForTesting"_s
            },
#endif
#if HAVE(AUDIT_TOKEN)
            {
                "HashMap<WebCore::PageIdentifier, WebKit::CoreIPCAuditToken>"_s,
                "presentingApplicationAuditTokens"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "String"_s,
                "applicationBundleIdentifier"_s
            },
#endif
#if ENABLE(VP9)
            {
                "std::optional<bool>"_s,
                "hasVP9HardwareDecoder"_s
            },
#endif
#if ENABLE(AV1)
            {
                "std::optional<bool>"_s,
                "hasAV1HardwareDecoder"_s
            },
#endif
        } },
#endif // ENABLE(GPU_PROCESS)
        { "WebKit::GoToBackForwardItemParameters"_s, {
            {
                "WebCore::NavigationIdentifier"_s,
                "navigationID"_s
            },
            {
                "Ref<WebKit::FrameState>"_s,
                "frameState"_s
            },
            {
                "WebCore::FrameLoadType"_s,
                "backForwardType"_s
            },
            {
                "WebCore::ShouldTreatAsContinuingLoad"_s,
                "shouldTreatAsContinuingLoad"_s
            },
            {
                "std::optional<WebKit::WebsitePoliciesData>"_s,
                "websitePolicies"_s
            },
            {
                "bool"_s,
                "lastNavigationWasAppInitiated"_s
            },
            {
                "std::optional<WebKit::NetworkResourceLoadIdentifier>"_s,
                "existingNetworkResourceLoadIdentifierToResume"_s
            },
            {
                "WebCore::PublicSuffix"_s,
                "publicSuffix"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "sandboxExtensionHandle"_s
            },
            {
                "WebCore::ProcessSwapDisposition"_s,
                "processSwapDisposition"_s
            },
        } },
        { "WebKit::NodeInfo"_s, {
            {
                "WebCore::NodeIdentifier"_s,
                "nodeIdentifier"_s
            },
            {
                "Markable<WebCore::FrameIdentifier>"_s,
                "contentFrameIdentifier"_s
            },
        } },
        { "WebKit::JavaScriptEvaluationResult"_s, {
            {
                "WebKit::JSObjectID"_s,
                "root()"_s
            },
            {
                "HashMap<WebKit::JSObjectID, Variant<WebKit::JavaScriptEvaluationResult::EmptyType, bool, double, String, Seconds, Vector<WebKit::JSObjectID>, HashMap<WebKit::JSObjectID, WebKit::JSObjectID>, WebKit::NodeInfo, UniqueRef<WebCore::SerializedNode>>>"_s,
                "map()"_s
            },
        } },
        { "WebKit::LayerTreeContext"_s, {
            {
                "uint64_t"_s,
                "contextID"_s
            },
        } },
        { "WebKit::LoadParameters"_s, {
            {
                "WebCore::PublicSuffix"_s,
                "publicSuffix"_s
            },
            {
                "std::optional<WebCore::NavigationIdentifier>"_s,
                "navigationID"_s
            },
            {
                "std::optional<WebCore::FrameIdentifier>"_s,
                "frameIdentifier"_s
            },
            {
                "WebCore::ResourceRequest"_s,
                "request"_s
            },
            {
                "IPC::FormDataReference"_s,
                "requestBody"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "sandboxExtensionHandle"_s
            },
            {
                "RefPtr<WebCore::SharedBuffer>"_s,
                "data"_s
            },
            {
                "String"_s,
                "MIMEType"_s
            },
            {
                "String"_s,
                "encodingName"_s
            },
            {
                "String"_s,
                "baseURLString"_s
            },
            {
                "String"_s,
                "unreachableURLString"_s
            },
            {
                "String"_s,
                "provisionalLoadErrorURLString"_s
            },
            {
                "std::optional<WebKit::WebsitePoliciesData>"_s,
                "websitePolicies"_s
            },
            {
                "std::optional<WebKit::FrameInfoData>"_s,
                "originatingFrame"_s
            },
            {
                "WebCore::ShouldOpenExternalURLsPolicy"_s,
                "shouldOpenExternalURLsPolicy"_s
            },
            {
                "WebCore::ShouldTreatAsContinuingLoad"_s,
                "shouldTreatAsContinuingLoad"_s
            },
            {
                "WebKit::UserData"_s,
                "userData"_s
            },
            {
                "WebCore::LockHistory"_s,
                "lockHistory"_s
            },
            {
                "WebCore::LockBackForwardList"_s,
                "lockBackForwardList"_s
            },
            {
                "WebCore::SubstituteData::SessionHistoryVisibility"_s,
                "sessionHistoryVisibility"_s
            },
            {
                "String"_s,
                "clientRedirectSourceForHistory"_s
            },
            {
                "WebCore::SandboxFlags"_s,
                "effectiveSandboxFlags"_s
            },
            {
                "std::optional<WebCore::OwnerPermissionsPolicyData>"_s,
                "ownerPermissionsPolicy"_s
            },
            {
                "std::optional<WebKit::NavigatingToAppBoundDomain>"_s,
                "isNavigatingToAppBoundDomain"_s
            },
            {
                "std::optional<WebKit::NetworkResourceLoadIdentifier>"_s,
                "existingNetworkResourceLoadIdentifierToResume"_s
            },
            {
                "bool"_s,
                "isServiceWorkerLoad"_s
            },
#if PLATFORM(COCOA)
            {
                "std::optional<double>"_s,
                "dataDetectionReferenceDate"_s
            },
#endif
            {
                "bool"_s,
                "isRequestFromClientOrUserInput"_s
            },
            {
                "bool"_s,
                "isPerformingHTTPFallback"_s
            },
            {
                "bool"_s,
                "isHandledByAboutSchemeHandler"_s
            },
            {
                "std::optional<OptionSet<WebCore::AdvancedPrivacyProtections>>"_s,
                "advancedPrivacyProtections"_s
            },
            {
                "uint64_t"_s,
                "requiredCookiesVersion"_s
            },
        } },
#if ENABLE(ARKIT_INLINE_PREVIEW)
        { "WebKit::ModelIdentifier"_s, {
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
            {
                "String"_s,
                "uuid"_s
            },
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
            {
                "WebCore::PlatformLayerIdentifier"_s,
                "layerIdentifier"_s
            },
#endif
        } },
#endif // ENABLE(ARKIT_INLINE_PREVIEW)
#if ENABLE(MODEL_PROCESS)
        { "WebKit::ModelProcessConnectionParameters"_s, {
            {
                "WebCore::ProcessIdentity"_s,
                "webProcessIdentity"_s
            },
            {
                "WebKit::SharedPreferencesForWebProcess"_s,
                "sharedPreferencesForWebProcess"_s
            },
#if ENABLE(IPC_TESTING_API)
            {
                "bool"_s,
                "ignoreInvalidMessageForTesting"_s
            },
#endif
#if HAVE(AUDIT_TOKEN)
            {
                "std::optional<WebKit::CoreIPCAuditToken>"_s,
                "presentingApplicationAuditToken"_s
            },
#endif
        } },
#endif // ENABLE(MODEL_PROCESS)
        { "WebKit::EditorStateIdentifier"_s, {
            {
                "uint64_t"_s,
                "toUInt64()"_s
            },
        } },
        { "WebKit::RenderingUpdateID"_s, {
            {
                "uint64_t"_s,
                "toUInt64()"_s
            },
        } },
        { "WebKit::TransactionIdentifier"_s, {
            {
                "uint64_t"_s,
                "toUInt64()"_s
            },
        } },
        { "WebKit::FocusedElementInformationIdentifier"_s, {
            {
                "uint64_t"_s,
                "toUInt64()"_s
            },
        } },
        { "WebKit::NavigationActionData"_s, {
            {
                "WebCore::NavigationType"_s,
                "navigationType"_s
            },
            {
                "OptionSet<WebKit::WebEventModifier>"_s,
                "modifiers"_s
            },
            {
                "WebKit::WebMouseEventButton"_s,
                "mouseButton"_s
            },
            {
                "WebKit::WebMouseEventSyntheticClickType"_s,
                "syntheticClickType"_s
            },
            {
                "std::optional<WebCore::UserGestureTokenIdentifier>"_s,
                "userGestureTokenIdentifier"_s
            },
            {
                "std::optional<WTF::UUID>"_s,
                "userGestureAuthorizationToken"_s
            },
            {
                "bool"_s,
                "canHandleRequest"_s
            },
            {
                "WebCore::ShouldOpenExternalURLsPolicy"_s,
                "shouldOpenExternalURLsPolicy"_s
            },
            {
                "String"_s,
                "downloadAttribute"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "clickLocationInRootViewCoordinates"_s
            },
            {
                "WebCore::ResourceResponse"_s,
                "redirectResponse"_s
            },
            {
                "bool"_s,
                "isRequestFromClientOrUserInput"_s
            },
            {
                "bool"_s,
                "treatAsSameOriginNavigation"_s
            },
            {
                "bool"_s,
                "hasOpenedFrames"_s
            },
            {
                "bool"_s,
                "openedByDOMWithOpener"_s
            },
            {
                "bool"_s,
                "hasOpener"_s
            },
            {
                "bool"_s,
                "isPerformingHTTPFallback"_s
            },
            {
                "bool"_s,
                "isInitialFrameSrcLoad"_s
            },
            {
                "bool"_s,
                "isContentRuleListRedirect"_s
            },
            {
                "String"_s,
                "openedMainFrameName"_s
            },
            {
                "WebCore::SecurityOriginData"_s,
                "requesterOrigin"_s
            },
            {
                "WebCore::SecurityOriginData"_s,
                "requesterTopOrigin"_s
            },
            {
                "std::optional<WebCore::BackForwardItemIdentifier>"_s,
                "targetBackForwardItemIdentifier"_s
            },
            {
                "std::optional<WebCore::BackForwardItemIdentifier>"_s,
                "sourceBackForwardItemIdentifier"_s
            },
            {
                "WebCore::LockHistory"_s,
                "lockHistory"_s
            },
            {
                "WebCore::LockBackForwardList"_s,
                "lockBackForwardList"_s
            },
            {
                "String"_s,
                "clientRedirectSourceForHistory"_s
            },
            {
                "WebCore::SandboxFlags"_s,
                "effectiveSandboxFlags"_s
            },
            {
                "std::optional<WebCore::OwnerPermissionsPolicyData>"_s,
                "ownerPermissionsPolicy"_s
            },
            {
                "std::optional<WebCore::PrivateClickMeasurement>"_s,
                "privateClickMeasurement"_s
            },
            {
                "OptionSet<WebCore::AdvancedPrivacyProtections>"_s,
                "advancedPrivacyProtections"_s
            },
            {
                "std::optional<OptionSet<WebCore::AdvancedPrivacyProtections>>"_s,
                "originatorAdvancedPrivacyProtections"_s
            },
#if PLATFORM(MAC) || HAVE(UIKIT_WITH_MOUSE_SUPPORT)
            {
                "std::optional<WebKit::WebHitTestResultData>"_s,
                "webHitTestResultData"_s
            },
#endif
            {
                "WebKit::FrameInfoData"_s,
                "originatingFrameInfoData"_s
            },
            {
                "std::optional<WebKit::WebPageProxyIdentifier>"_s,
                "originatingPageID"_s
            },
            {
                "WebKit::FrameInfoData"_s,
                "frameInfo"_s
            },
            {
                "std::optional<WebCore::NavigationIdentifier>"_s,
                "navigationID"_s
            },
            {
                "WebCore::ResourceRequest"_s,
                "originalRequest"_s
            },
            {
                "WebCore::ResourceRequest"_s,
                "request"_s
            },
            {
                "IPC::FormDataReference"_s,
                "requestBody"_s
            },
            {
                "String"_s,
                "invalidURLString"_s
            },
        } },
        { "WebKit::NetworkProcessConnectionParameters"_s, {
            {
                "WebKit::SharedPreferencesForWebProcess"_s,
                "sharedPreferencesForWebProcess"_s
            },
#if ENABLE(IPC_TESTING_API)
            {
                "bool"_s,
                "ignoreInvalidMessageForTesting"_s
            },
#endif
            {
                "Vector<WebKit::WebPageProxyIdentifier>"_s,
                "pagesWithRelaxedThirdPartyCookieBlocking"_s
            },
        } },
        { "WebCore::PasteboardImage"_s, {
            {
                "RefPtr<WebCore::Image>"_s,
                "image"_s
            },
#if PLATFORM(MAC)
            {
                "RefPtr<WebCore::SharedBuffer>"_s,
                "dataInWebArchiveFormat"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "String"_s,
                "dataInHTMLFormat"_s
            },
#endif
#if !PLATFORM(WIN)
            {
                "WebCore::PasteboardURL"_s,
                "url"_s
            },
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
            {
                "RefPtr<WebCore::SharedBuffer>"_s,
                "resourceData"_s
            },
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
            {
                "String"_s,
                "resourceMIMEType"_s
            },
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
            {
                "Vector<std::pair<String, RefPtr<WebCore::SharedBuffer>>>"_s,
                "clientTypesAndData"_s
            },
#endif
            {
                "String"_s,
                "suggestedName"_s
            },
            {
                "WebCore::FloatSize"_s,
                "imageSize"_s
            },
        } },
        { "WebCore::PasteboardWebContent"_s, {
#if PLATFORM(COCOA)
            {
                "String"_s,
                "contentOrigin"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "canSmartCopyOrDelete"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "RefPtr<WebCore::SharedBuffer>"_s,
                "dataInWebArchiveFormat"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "RefPtr<WebCore::SharedBuffer>"_s,
                "dataInRTFDFormat"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "RefPtr<WebCore::SharedBuffer>"_s,
                "dataInRTFFormat"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "RefPtr<WebCore::SharedBuffer>"_s,
                "dataInAttributedStringFormat"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "String"_s,
                "dataInHTMLFormat"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "String"_s,
                "dataInStringFormat"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "Vector<std::pair<String, RefPtr<WebCore::SharedBuffer>>>"_s,
                "clientTypesAndData"_s
            },
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            {
                "String"_s,
                "contentOrigin"_s
            },
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            {
                "bool"_s,
                "canSmartCopyOrDelete"_s
            },
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            {
                "String"_s,
                "text"_s
            },
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            {
                "String"_s,
                "markup"_s
            },
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
            {
                "String"_s,
                "text"_s
            },
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
            {
                "String"_s,
                "markup"_s
            },
#endif
        } },
        { "WebCore::PasteboardURL"_s, {
            {
                "URL"_s,
                "url"_s
            },
            {
                "String"_s,
                "title"_s
            },
#if PLATFORM(MAC)
            {
                "String"_s,
                "userVisibleForm"_s
            },
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            {
                "String"_s,
                "markup"_s
            },
#endif
        } },
        { "WebCore::PasteboardBuffer"_s, {
#if PLATFORM(COCOA)
            {
                "String"_s,
                "contentOrigin"_s
            },
#endif
            {
                "String"_s,
                "type"_s
            },
            {
                "RefPtr<WebCore::SharedBuffer>"_s,
                "data"_s
            },
        } },
        { "WebKit::PlatformFontInfo"_s, {
#if PLATFORM(COCOA)
            {
                "RetainPtr<CFDictionaryRef>"_s,
                "fontAttributeDictionary"_s
            },
#endif
        } },
        { "WebKit::PlatformPopupMenuData"_s, {
#if PLATFORM(COCOA)
            {
                "WebKit::PlatformFontInfo"_s,
                "fontInfo"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "shouldPopOver"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "hideArrows"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "WebCore::PopupMenuStyle::Size"_s,
                "menuSize"_s
            },
#endif
#if PLATFORM(WIN)
            {
                "int"_s,
                "m_clientPaddingLeft"_s
            },
#endif
#if PLATFORM(WIN)
            {
                "int"_s,
                "m_clientPaddingRight"_s
            },
#endif
#if PLATFORM(WIN)
            {
                "int"_s,
                "m_clientInsetLeft"_s
            },
#endif
#if PLATFORM(WIN)
            {
                "int"_s,
                "m_clientInsetRight"_s
            },
#endif
#if PLATFORM(WIN)
            {
                "int"_s,
                "m_popupWidth"_s
            },
#endif
#if PLATFORM(WIN)
            {
                "float"_s,
                "m_itemHeight"_s
            },
#endif
#if PLATFORM(WIN)
            {
                "bool"_s,
                "m_isRTL"_s
            },
#endif
#if PLATFORM(WIN)
            {
                "RefPtr<WebCore::ShareableBitmap>"_s,
                "m_notSelectedBackingStore"_s
            },
#endif
#if PLATFORM(WIN)
            {
                "RefPtr<WebCore::ShareableBitmap>"_s,
                "m_selectedBackingStore"_s
            },
#endif
        } },
        { "WebKit::PolicyDecision"_s, {
            {
                "std::optional<WebKit::NavigatingToAppBoundDomain>"_s,
                "isNavigatingToAppBoundDomain"_s
            },
            {
                "WebCore::PolicyAction"_s,
                "policyAction"_s
            },
            {
                "std::optional<WebCore::NavigationIdentifier>"_s,
                "navigationID"_s
            },
            {
                "std::optional<WebKit::DownloadID>"_s,
                "downloadID"_s
            },
            {
                "std::optional<WebKit::WebsitePoliciesData>"_s,
                "websitePoliciesData"_s
            },
            {
                "std::optional<WebKit::SandboxExtensionHandle>"_s,
                "sandboxExtensionHandle"_s
            },
            {
                "std::optional<WebKit::PolicyDecisionConsoleMessage>"_s,
                "consoleMessage"_s
            },
            {
                "WebKit::SafeBrowsingCheckOngoing"_s,
                "isSafeBrowsingCheckOngoing"_s
            },
        } },
        { "WebKit::PolicyDecisionConsoleMessage"_s, {
            {
                "JSC::MessageLevel"_s,
                "messageLevel"_s
            },
            {
                "JSC::MessageSource"_s,
                "messageSource"_s
            },
            {
                "String"_s,
                "message"_s
            },
        } },
        { "WebKit::PrintInfo"_s, {
            {
                "float"_s,
                "pageSetupScaleFactor"_s
            },
            {
                "float"_s,
                "availablePaperWidth"_s
            },
            {
                "float"_s,
                "availablePaperHeight"_s
            },
            {
                "WebCore::FloatBoxExtent"_s,
                "margin"_s
            },
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "snapshotFirstPage"_s
            },
#endif
#if PLATFORM(GTK)
            {
                "GRefPtr<GtkPrintSettings>"_s,
                "printSettings"_s
            },
#endif
#if PLATFORM(GTK)
            {
                "GRefPtr<GtkPageSetup>"_s,
                "pageSetup"_s
            },
#endif
#if PLATFORM(GTK)
            {
                "WebKit::PrintInfo::PrintMode"_s,
                "printMode"_s
            },
#endif
        } },
        { "WebCore::BackForwardFrameItemIdentifier"_s, {
            {
                "WebCore::BackForwardFrameItemIdentifierID"_s,
                "object()"_s
            },
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier()"_s
            },
        } },
        { "WebCore::BackForwardItemIdentifier"_s, {
            {
                "WebCore::BackForwardItemIdentifierID"_s,
                "object()"_s
            },
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier()"_s
            },
        } },
        { "WebCore::DOMCacheIdentifier"_s, {
            {
                "WebCore::DOMCacheIdentifierID"_s,
                "object()"_s
            },
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier()"_s
            },
        } },
        { "WebCore::OpaqueOriginIdentifierProcessQualified"_s, {
            {
                "WebCore::OpaqueOriginIdentifier"_s,
                "object()"_s
            },
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier()"_s
            },
        } },
        { "WebCore::PlatformLayerIdentifier"_s, {
            {
                "WebCore::PlatformLayerIdentifierID"_s,
                "object()"_s
            },
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier()"_s
            },
        } },
        { "WebCore::PlaybackTargetClientContextIdentifier"_s, {
            {
                "WebCore::PlaybackTargetClientContextID"_s,
                "object()"_s
            },
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier()"_s
            },
        } },
        { "WebCore::RTCDataChannelIdentifier"_s, {
            {
                "WebCore::RTCDataChannelLocalIdentifier"_s,
                "object()"_s
            },
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier()"_s
            },
        } },
        { "WebCore::SharedWorkerObjectIdentifier"_s, {
            {
                "WebCore::SharedWorkerObjectIdentifierID"_s,
                "object()"_s
            },
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier()"_s
            },
        } },
        { "WebCore::UserGestureTokenIdentifier"_s, {
            {
                "WebCore::UserGestureTokenIdentifierID"_s,
                "object()"_s
            },
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier()"_s
            },
        } },
        { "WebCore::WebLockIdentifier"_s, {
            {
                "WebCore::WebLockIdentifierID"_s,
                "object()"_s
            },
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier()"_s
            },
        } },
        { "WebCore::ScrollingNodeID"_s, {
            {
                "WebCore::ScrollingNodeIdentifier"_s,
                "object()"_s
            },
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier()"_s
            },
        } },
        { "WebCore::ScriptExecutionContextIdentifier"_s, {
            {
                "WTF::UUID"_s,
                "object()"_s
            },
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier()"_s
            },
        } },
        { "WebKit::TransactionID"_s, {
            {
                "WebKit::TransactionIdentifier"_s,
                "object()"_s
            },
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier()"_s
            },
        } },
        { "WebKit::PlaybackSessionContextIdentifier"_s, {
            {
                "WebCore::MediaPlayerClientIdentifier"_s,
                "object()"_s
            },
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier()"_s
            },
        } },
        { "WebKit::ProvisionalFrameCreationParameters"_s, {
            {
                "WebCore::FrameIdentifier"_s,
                "frameID"_s
            },
            {
                "std::optional<WebCore::FrameIdentifier>"_s,
                "frameIDBeforeProvisionalNavigation"_s
            },
            {
                "std::optional<WebCore::LayerHostingContextIdentifier>"_s,
                "layerHostingContextIdentifier"_s
            },
            {
                "WebCore::SandboxFlags"_s,
                "effectiveSandboxFlags"_s
            },
            {
                "WebCore::ScrollbarMode"_s,
                "scrollingMode"_s
            },
            {
                "std::optional<WebCore::IntSize>"_s,
                "initialSize"_s
            },
        } },
#if USE(LIBWEBRTC)
        { "WebKit::WebRTCNetwork::IPAddress"_s, {
            {
                "Variant<WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily, uint32_t, std::array<uint32_t, 4>>"_s,
                "value"_s
            },
        } },
#endif // USE(LIBWEBRTC)
#if USE(LIBWEBRTC)
        { "WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily"_s, {
        } },
#endif // USE(LIBWEBRTC)
#if USE(LIBWEBRTC)
        { "WebKit::WebRTCNetwork::InterfaceAddress"_s, {
            {
                "WebKit::WebRTCNetwork::IPAddress"_s,
                "address"_s
            },
            {
                "int"_s,
                "ipv6Flags"_s
            },
        } },
#endif // USE(LIBWEBRTC)
#if USE(LIBWEBRTC)
        { "WebKit::WebRTCNetwork::SocketAddress"_s, {
            {
                "uint16_t"_s,
                "port"_s
            },
            {
                "int"_s,
                "scopeID"_s
            },
            {
                "Vector<char>"_s,
                "hostname"_s
            },
            {
                "std::optional<WebKit::WebRTCNetwork::IPAddress>"_s,
                "ipAddress"_s
            },
        } },
#endif // USE(LIBWEBRTC)
#if USE(LIBWEBRTC)
        { "WebKit::RTCNetwork"_s, {
            {
                "Vector<char>"_s,
                "name"_s
            },
            {
                "Vector<char>"_s,
                "description"_s
            },
            {
                "WebKit::WebRTCNetwork::IPAddress"_s,
                "prefix"_s
            },
            {
                "int"_s,
                "prefixLength"_s
            },
            {
                "int"_s,
                "type"_s
            },
            {
                "uint16_t"_s,
                "id"_s
            },
            {
                "int"_s,
                "preference"_s
            },
            {
                "bool"_s,
                "active"_s
            },
            {
                "bool"_s,
                "ignored"_s
            },
            {
                "int"_s,
                "scopeID"_s
            },
            {
                "Vector<WebKit::WebRTCNetwork::InterfaceAddress>"_s,
                "ips"_s
            },
        } },
#endif // USE(LIBWEBRTC)
#if (USE(LIBWEBRTC)) && (USE(LIBWEBRTC) && PLATFORM(COCOA))
        { "webrtc::WebKitEncodedFrameInfo"_s, {
            {
                "uint32_t"_s,
                "width"_s
            },
            {
                "uint32_t"_s,
                "height"_s
            },
            {
                "int64_t"_s,
                "timeStamp"_s
            },
            {
                "std::optional<uint64_t>"_s,
                "duration"_s
            },
            {
                "int64_t"_s,
                "ntpTimeMS"_s
            },
            {
                "int64_t"_s,
                "captureTimeMS"_s
            },
            {
                "webrtc::VideoFrameType"_s,
                "frameType"_s
            },
            {
                "webrtc::WebKitEncodedVideoRotation"_s,
                "rotation"_s
            },
            {
                "webrtc::VideoContentType"_s,
                "contentType"_s
            },
            {
                "bool"_s,
                "completeFrame"_s
            },
            {
                "int"_s,
                "qp"_s
            },
            {
                "int"_s,
                "temporalIndex"_s
            },
            {
                "webrtc::WebKitEncodedFrameTiming"_s,
                "timing"_s
            },
        } },
#endif // (USE(LIBWEBRTC)) && (USE(LIBWEBRTC) && PLATFORM(COCOA))
#if (USE(LIBWEBRTC)) && (USE(LIBWEBRTC) && PLATFORM(COCOA))
        { "webrtc::EncodedImage::Timing"_s, {
            {
                "uint8_t"_s,
                "flags"_s
            },
            {
                "int64_t"_s,
                "encode_start_ms"_s
            },
            {
                "int64_t"_s,
                "encode_finish_ms"_s
            },
            {
                "int64_t"_s,
                "packetization_finish_ms"_s
            },
            {
                "int64_t"_s,
                "pacer_exit_ms"_s
            },
            {
                "int64_t"_s,
                "network_timestamp_ms"_s
            },
            {
                "int64_t"_s,
                "network2_timestamp_ms"_s
            },
            {
                "int64_t"_s,
                "receive_start_ms"_s
            },
            {
                "int64_t"_s,
                "receive_finish_ms"_s
            },
        } },
#endif // (USE(LIBWEBRTC)) && (USE(LIBWEBRTC) && PLATFORM(COCOA))
#if USE(LIBWEBRTC)
        { "WebKit::RTCPacketOptions::SerializableData"_s, {
            {
                "WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint"_s,
                "dscp"_s
            },
            {
                "int32_t"_s,
                "packetId"_s
            },
            {
                "int"_s,
                "rtpSendtimeExtensionId"_s
            },
            {
                "int64_t"_s,
                "srtpAuthTagLength"_s
            },
            {
                "std::span<const char>"_s,
                "srtpAuthKey"_s
            },
            {
                "int64_t"_s,
                "srtpPacketIndex"_s
            },
        } },
#endif // USE(LIBWEBRTC)
#if USE(LIBWEBRTC)
        { "WebKit::RTCPacketOptions"_s, {
            {
                "WebKit::RTCPacketOptions::SerializableData"_s,
                "serializableData()"_s
            },
        } },
#endif // USE(LIBWEBRTC)
#if ENABLE(TOUCH_EVENTS)
        { "WebKit::RemoteWebTouchEvent"_s, {
            {
                "WebCore::FrameIdentifier"_s,
                "targetFrameID"_s
            },
            {
                "WebKit::WebTouchEvent"_s,
                "transformedEvent"_s
            },
        } },
#endif // ENABLE(TOUCH_EVENTS)
        { "WebKit::RemoteWorkerInitializationData"_s, {
            {
                "WebKit::UserContentControllerIdentifier"_s,
                "userContentControllerIdentifier"_s
            },
#if ENABLE(CONTENT_EXTENSIONS)
            {
                "Vector<std::pair<WebKit::WebCompiledContentRuleListData, URL>>"_s,
                "contentRuleLists"_s
            },
#endif
        } },
        { "WebKit::ResourceLoadInfo"_s, {
            {
                "WebKit::NetworkResourceLoadIdentifier"_s,
                "resourceLoadID"_s
            },
            {
                "std::optional<WebCore::FrameIdentifier>"_s,
                "frameID"_s
            },
            {
                "std::optional<WebCore::FrameIdentifier>"_s,
                "parentFrameID"_s
            },
            {
                "Markable<WTF::UUID>"_s,
                "documentID"_s
            },
            {
                "URL"_s,
                "originalURL"_s
            },
            {
                "String"_s,
                "originalHTTPMethod"_s
            },
            {
                "WallTime"_s,
                "eventTimestamp"_s
            },
            {
                "bool"_s,
                "loadedFromCache"_s
            },
            {
                "WebKit::ResourceLoadInfo::Type"_s,
                "type"_s
            },
        } },
        { "WebKit::ResourceLoadStatisticsParameters"_s, {
            {
                "String"_s,
                "directory"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "directoryExtensionHandle"_s
            },
            {
                "bool"_s,
                "enabled"_s
            },
            {
                "bool"_s,
                "enableLogTestingEvent"_s
            },
            {
                "bool"_s,
                "shouldIncludeLocalhost"_s
            },
            {
                "bool"_s,
                "enableDebugMode"_s
            },
            {
                "WebCore::ThirdPartyCookieBlockingMode"_s,
                "thirdPartyCookieBlockingMode"_s
            },
            {
                "WebCore::SameSiteStrictEnforcementEnabled"_s,
                "sameSiteStrictEnforcementEnabled"_s
            },
            {
                "WebCore::FirstPartyWebsiteDataRemovalMode"_s,
                "firstPartyWebsiteDataRemovalMode"_s
            },
            {
                "WebCore::RegistrableDomain"_s,
                "standaloneApplicationDomain"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "appBoundDomains"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "managedDomains"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "persistedDomains"_s
            },
            {
                "WebCore::RegistrableDomain"_s,
                "manualPrevalentResource"_s
            },
        } },
        { "WebKit::SandboxExtensionHandle"_s, {
#if ENABLE(SANDBOX_EXTENSIONS)
            {
                "std::unique_ptr<WebKit::SandboxExtensionImpl>"_s,
                "takeImpl()"_s
            },
#endif
        } },
#if ENABLE(SANDBOX_EXTENSIONS)
        { "WebKit::SandboxExtensionImpl"_s, {
            {
                "std::span<const uint8_t>"_s,
                "getSerializedFormat()"_s
            },
        } },
#endif // ENABLE(SANDBOX_EXTENSIONS)
        { "WebKit::ScriptTrackingPrivacyHost"_s, {
            {
                "String"_s,
                "hostName"_s
            },
            {
                "OptionSet<WebCore::ScriptTrackingPrivacyFlag>"_s,
                "allowedCategories"_s
            },
        } },
        { "WebKit::ScriptTrackingPrivacyRules"_s, {
            {
                "Vector<WebKit::ScriptTrackingPrivacyHost>"_s,
                "thirdPartyHosts"_s
            },
            {
                "Vector<WebKit::ScriptTrackingPrivacyHost>"_s,
                "thirdPartyTopDomains"_s
            },
            {
                "Vector<WebKit::ScriptTrackingPrivacyHost>"_s,
                "firstPartyHosts"_s
            },
            {
                "Vector<WebKit::ScriptTrackingPrivacyHost>"_s,
                "firstPartyTopDomains"_s
            },
        } },
#if ENABLE(MOMENTUM_EVENT_DISPATCHER)
        { "WebKit::ScrollingAccelerationCurve"_s, {
            {
                "float"_s,
                "gainLinear()"_s
            },
            {
                "float"_s,
                "gainParabolic()"_s
            },
            {
                "float"_s,
                "gainCubic()"_s
            },
            {
                "float"_s,
                "gainQuartic()"_s
            },
            {
                "float"_s,
                "tangentSpeedLinear()"_s
            },
            {
                "float"_s,
                "tangentSpeedParabolicRoot()"_s
            },
            {
                "float"_s,
                "resolution()"_s
            },
            {
                "float"_s,
                "frameRate()"_s
            },
        } },
#endif // ENABLE(MOMENTUM_EVENT_DISPATCHER)
        { "WebCore::SerializedNode::QualifiedName"_s, {
            {
                "String"_s,
                "prefix"_s
            },
            {
                "String"_s,
                "localName"_s
            },
            {
                "String"_s,
                "namespaceURI"_s
            },
        } },
        { "WebCore::SerializedNode::ContainerNode"_s, {
            {
                "Vector<WebCore::SerializedNode>"_s,
                "children"_s
            },
        } },
        { "WebCore::SerializedNode::Attr"_s, {
            {
                "WebCore::SerializedNode::QualifiedName"_s,
                "name"_s
            },
            {
                "String"_s,
                "value"_s
            },
        } },
        { "WebCore::SerializedNode::CharacterData"_s, {
            {
                "String"_s,
                "data"_s
            },
        } },
        { "WebCore::SerializedNode::Document"_s, {
            {
                "Vector<WebCore::SerializedNode>"_s,
                "children"_s
            },
            {
                "WebCore::ClonedDocumentType"_s,
                "type"_s
            },
            {
                "URL"_s,
                "url"_s
            },
            {
                "URL"_s,
                "baseURL"_s
            },
            {
                "URL"_s,
                "baseURLOverride"_s
            },
            {
                "Variant<String, URL>"_s,
                "documentURI"_s
            },
            {
                "String"_s,
                "contentType"_s
            },
        } },
        { "WebCore::SerializedNode::DocumentFragment"_s, {
            {
                "Vector<WebCore::SerializedNode>"_s,
                "children"_s
            },
        } },
        { "WebCore::SerializedNode::DocumentType"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "String"_s,
                "publicId"_s
            },
            {
                "String"_s,
                "systemId"_s
            },
        } },
        { "WebCore::SerializedNode::Element::Attribute"_s, {
            {
                "WebCore::SerializedNode::QualifiedName"_s,
                "name"_s
            },
            {
                "String"_s,
                "value"_s
            },
        } },
        { "WebCore::SerializedNode::Element"_s, {
            {
                "Vector<WebCore::SerializedNode>"_s,
                "children"_s
            },
            {
                "WebCore::SerializedNode::QualifiedName"_s,
                "name"_s
            },
            {
                "Vector<WebCore::SerializedNode::Element::Attribute>"_s,
                "attributes"_s
            },
        } },
        { "WebCore::SerializedNode::Comment"_s, {
            {
                "String"_s,
                "data"_s
            },
        } },
        { "WebCore::SerializedNode::Text"_s, {
            {
                "String"_s,
                "data"_s
            },
        } },
        { "WebCore::SerializedNode::CDATASection"_s, {
            {
                "String"_s,
                "data"_s
            },
        } },
        { "WebCore::SerializedNode::ProcessingInstruction"_s, {
            {
                "String"_s,
                "data"_s
            },
            {
                "String"_s,
                "target"_s
            },
        } },
        { "WebCore::SerializedNode::ShadowRoot"_s, {
            {
                "Vector<WebCore::SerializedNode>"_s,
                "children"_s
            },
        } },
        { "WebCore::SerializedNode::HTMLTemplateElement"_s, {
            {
                "Vector<WebCore::SerializedNode>"_s,
                "children"_s
            },
            {
                "WebCore::SerializedNode::QualifiedName"_s,
                "name"_s
            },
            {
                "Vector<WebCore::SerializedNode::Element::Attribute>"_s,
                "attributes"_s
            },
        } },
        { "WebCore::SerializedNode"_s, {
            {
                "Variant<WebCore::SerializedNode::Attr, WebCore::SerializedNode::CDATASection, WebCore::SerializedNode::Comment, WebCore::SerializedNode::Document, WebCore::SerializedNode::DocumentFragment, WebCore::SerializedNode::DocumentType, WebCore::SerializedNode::Element, WebCore::SerializedNode::ProcessingInstruction, WebCore::SerializedNode::ShadowRoot, WebCore::SerializedNode::Text, WebCore::SerializedNode::HTMLTemplateElement>"_s,
                "data"_s
            },
        } },
        { "WebKit::HTTPBody"_s, {
            {
                "String"_s,
                "contentType"_s
            },
            {
                "Vector<WebKit::HTTPBody::Element>"_s,
                "elements"_s
            },
        } },
        { "WebKit::HTTPBody::Element"_s, {
            {
                "Variant<Vector<uint8_t>, WebKit::HTTPBody::Element::FileData, String>"_s,
                "data"_s
            },
        } },
        { "WebKit::HTTPBody::Element::FileData"_s, {
            {
                "String"_s,
                "filePath"_s
            },
            {
                "int64_t"_s,
                "fileStart"_s
            },
            {
                "std::optional<int64_t>"_s,
                "fileLength"_s
            },
            {
                "std::optional<WallTime>"_s,
                "expectedFileModificationTime"_s
            },
        } },
        { "WebKit::FrameState"_s, {
            {
                "String"_s,
                "urlString"_s
            },
            {
                "String"_s,
                "originalURLString"_s
            },
            {
                "String"_s,
                "referrer"_s
            },
            {
                "AtomString"_s,
                "target"_s
            },
            {
                "std::optional<WebCore::FrameIdentifier>"_s,
                "frameID"_s
            },
            {
                "std::optional<Vector<uint8_t>>"_s,
                "stateObjectData"_s
            },
            {
                "int64_t"_s,
                "documentSequenceNumber"_s
            },
            {
                "int64_t"_s,
                "itemSequenceNumber"_s
            },
            {
                "WebCore::IntPoint"_s,
                "scrollPosition"_s
            },
            {
                "bool"_s,
                "shouldRestoreScrollPosition"_s
            },
            {
                "float"_s,
                "pageScaleFactor"_s
            },
            {
                "std::optional<WebKit::HTTPBody>"_s,
                "httpBody"_s
            },
            {
                "Markable<WebCore::BackForwardItemIdentifier>"_s,
                "itemID"_s
            },
            {
                "Markable<WebCore::BackForwardFrameItemIdentifier>"_s,
                "frameItemID"_s
            },
            {
                "bool"_s,
                "hasCachedPage"_s
            },
            {
                "String"_s,
                "title"_s
            },
            {
                "WebCore::ShouldOpenExternalURLsPolicy"_s,
                "shouldOpenExternalURLsPolicy"_s
            },
            {
                "RefPtr<WebCore::SerializedScriptValue>"_s,
                "sessionStateObject"_s
            },
            {
                "bool"_s,
                "wasCreatedByJSWithoutUserInteraction"_s
            },
            {
                "bool"_s,
                "wasRestoredFromSession"_s
            },
            {
                "std::optional<WebCore::PolicyContainer>"_s,
                "policyContainer"_s
            },
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::FloatRect"_s,
                "exposedContentRect"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::IntRect"_s,
                "unobscuredContentRect"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::FloatSize"_s,
                "minimumLayoutSizeInScrollViewCoordinates"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::IntSize"_s,
                "contentSize"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "scaleIsInitial"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::FloatBoxExtent"_s,
                "obscuredInsets"_s
            },
#endif
            {
                "Vector<Ref<WebKit::FrameState>>"_s,
                "children"_s
            },
            {
                "Vector<AtomString>"_s,
                "documentState()"_s
            },
        } },
        { "WebKit::BackForwardListState"_s, {
            {
                "Vector<Ref<WebKit::FrameState>>"_s,
                "items"_s
            },
            {
                "std::optional<uint32_t>"_s,
                "currentIndex"_s
            },
        } },
#if ENABLE(IMAGE_ANALYSIS)
        { "WebCore::TextRecognitionWordData"_s, {
            {
                "String"_s,
                "text"_s
            },
            {
                "WebCore::FloatQuad"_s,
                "normalizedQuad"_s
            },
            {
                "bool"_s,
                "hasLeadingWhitespace"_s
            },
        } },
#endif // ENABLE(IMAGE_ANALYSIS)
#if ENABLE(IMAGE_ANALYSIS)
        { "WebCore::TextRecognitionLineData"_s, {
            {
                "WebCore::FloatQuad"_s,
                "normalizedQuad"_s
            },
            {
                "Vector<WebCore::TextRecognitionWordData>"_s,
                "children"_s
            },
            {
                "bool"_s,
                "hasTrailingNewline"_s
            },
            {
                "bool"_s,
                "isVertical"_s
            },
        } },
#endif // ENABLE(IMAGE_ANALYSIS)
#if ENABLE(IMAGE_ANALYSIS)
        { "WebCore::TextRecognitionBlockData"_s, {
            {
                "String"_s,
                "text"_s
            },
            {
                "WebCore::FloatQuad"_s,
                "normalizedQuad"_s
            },
        } },
#endif // ENABLE(IMAGE_ANALYSIS)
#if ENABLE(IMAGE_ANALYSIS)
        { "WebCore::TextRecognitionResult"_s, {
            {
                "Vector<WebCore::TextRecognitionLineData>"_s,
                "lines"_s
            },
#if ENABLE(DATA_DETECTION)
            {
                "Vector<WebCore::TextRecognitionDataDetector>"_s,
                "dataDetectors"_s
            },
#endif
            {
                "Vector<WebCore::TextRecognitionBlockData>"_s,
                "blocks"_s
            },
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
            {
                "RetainPtr<NSData>"_s,
                "imageAnalysisData"_s
            },
#endif
        } },
#endif // ENABLE(IMAGE_ANALYSIS)
        { "WebKit::URLSchemeTaskParameters"_s, {
            {
                "WebKit::WebURLSchemeHandlerIdentifier"_s,
                "handlerIdentifier"_s
            },
            {
                "WebCore::ResourceLoaderIdentifier"_s,
                "taskIdentifier"_s
            },
            {
                "WebCore::ResourceRequest"_s,
                "request"_s
            },
            {
                "IPC::FormDataReference"_s,
                "requestBody"_s
            },
            {
                "WebKit::FrameInfoData"_s,
                "frameInfo"_s
            },
        } },
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
        { "WebKit::UpdateInfo"_s, {
            {
                "WebCore::IntSize"_s,
                "viewSize"_s
            },
            {
                "float"_s,
                "deviceScaleFactor"_s
            },
            {
                "WebCore::IntRect"_s,
                "scrollRect"_s
            },
            {
                "WebCore::IntSize"_s,
                "scrollOffset"_s
            },
            {
                "WebCore::IntRect"_s,
                "updateRectBounds"_s
            },
            {
                "Vector<WebCore::IntRect>"_s,
                "updateRects"_s
            },
            {
                "float"_s,
                "updateScaleFactor"_s
            },
            {
                "std::optional<WebCore::ShareableBitmapHandle>"_s,
                "bitmapHandle"_s
            },
            {
                "WebCore::IntPoint"_s,
                "bitmapOffset"_s
            },
        } },
#endif // USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
        { "WebKit::UserContentControllerParameters"_s, {
            {
                "WebKit::UserContentControllerIdentifier"_s,
                "identifier"_s
            },
            {
                "Vector<WebKit::ContentWorldData>"_s,
                "userContentWorlds"_s
            },
            {
                "Vector<WebKit::WebUserScriptData>"_s,
                "userScripts"_s
            },
            {
                "Vector<WebKit::WebUserStyleSheetData>"_s,
                "userStyleSheets"_s
            },
            {
                "Vector<WebKit::WebScriptMessageHandlerData>"_s,
                "messageHandlers"_s
            },
#if ENABLE(CONTENT_EXTENSIONS)
            {
                "Vector<std::pair<WebKit::WebCompiledContentRuleListData, URL>>"_s,
                "contentRuleLists"_s
            },
#endif
        } },
        { "WebKit::UserData"_s, {
            {
                "RefPtr<API::Object>"_s,
                "protectedObject()"_s
            },
        } },
#if ENABLE(UI_SIDE_COMPOSITING)
        { "WebKit::VisibleContentRectUpdateInfo"_s, {
            {
                "WebCore::FloatRect"_s,
                "exposedContentRect()"_s
            },
            {
                "WebCore::FloatRect"_s,
                "unobscuredContentRect()"_s
            },
            {
                "WebCore::FloatBoxExtent"_s,
                "contentInsets()"_s
            },
            {
                "WebCore::FloatRect"_s,
                "unobscuredRectInScrollViewCoordinates()"_s
            },
            {
                "WebCore::FloatRect"_s,
                "unobscuredContentRectRespectingInputViewBounds()"_s
            },
            {
                "WebCore::FloatRect"_s,
                "layoutViewportRect()"_s
            },
            {
                "WebCore::FloatBoxExtent"_s,
                "obscuredInsets()"_s
            },
            {
                "WebCore::FloatBoxExtent"_s,
                "unobscuredSafeAreaInsets()"_s
            },
            {
                "double"_s,
                "scale()"_s
            },
            {
                "OptionSet<WebKit::ViewStabilityFlag>"_s,
                "viewStability()"_s
            },
            {
                "bool"_s,
                "isFirstUpdateForNewViewSize()"_s
            },
            {
                "bool"_s,
                "allowShrinkToFit()"_s
            },
            {
                "bool"_s,
                "enclosedInScrollableAncestorView()"_s
            },
            {
                "WebCore::VelocityData"_s,
                "scrollVelocity()"_s
            },
            {
                "WebKit::TransactionID"_s,
                "lastLayerTreeTransactionID()"_s
            },
        } },
#endif // ENABLE(UI_SIDE_COMPOSITING)
        { "URL"_s, {
            {
                "String"_s,
                "string()"_s
            },
        } },
        { "CString"_s, {
            {
                "std::span<const char>"_s,
                "span()"_s
            },
        } },
        { "MediaTime"_s, {
            {
                "int64_t"_s,
                "timeValue()"_s
            },
            {
                "uint32_t"_s,
                "timeScale()"_s
            },
            {
                "uint8_t"_s,
                "timeFlags()"_s
            },
        } },
        { "Seconds"_s, {
            {
                "double"_s,
                "value()"_s
            },
        } },
        { "MonotonicTime"_s, {
            {
                "double"_s,
                "secondsSinceEpoch().seconds()"_s
            },
        } },
        { "WallTime"_s, {
            {
                "double"_s,
                "secondsSinceEpoch().seconds()"_s
            },
        } },
        { "AtomString"_s, {
            {
                "String"_s,
                "string()"_s
            },
        } },
        { "WTF::UUID"_s, {
            {
                "uint64_t"_s,
                "high()"_s
            },
            {
                "uint64_t"_s,
                "low()"_s
            },
        } },
        { "WTF::JSONImpl::Value"_s, {
            {
                "String"_s,
                "toJSONString()"_s
            },
        } },
        { "ObjectIdentifier"_s, {
            {
                "uint64_t"_s,
                "toUInt64()"_s
            },
        } },
        { "AtomicObjectIdentifier"_s, {
            {
                "uint64_t"_s,
                "toUInt64()"_s
            },
        } },
        { "MemoryPressureHandlerConfiguration"_s, {
            {
                "uint64_t"_s,
                "baseThreshold"_s
            },
            {
                "double"_s,
                "conservativeThresholdFraction"_s
            },
            {
                "double"_s,
                "strictThresholdFraction"_s
            },
            {
                "std::optional<double>"_s,
                "killThresholdFraction"_s
            },
            {
                "Seconds"_s,
                "pollInterval"_s
            },
        } },
        { "std::monostate"_s, {
        } },
#if PLATFORM(COCOA)
        { "MachSendRightAnnotated"_s, {
            {
                "MachSendRight"_s,
                "sendRight"_s
            },
            {
                "FixedVector<uint8_t>"_s,
                "data"_s
            },
        } },
#endif // PLATFORM(COCOA)
        { "WebKit::WebBackForwardListCounts"_s, {
            {
                "uint32_t"_s,
                "backCount"_s
            },
            {
                "uint32_t"_s,
                "forwardCount"_s
            },
        } },
#if ENABLE(CONTEXT_MENUS)
        { "WebKit::WebContextMenuItemData"_s, {
            {
                "WebCore::ContextMenuItemType"_s,
                "type()"_s
            },
            {
                "WebCore::ContextMenuAction"_s,
                "action()"_s
            },
            {
                "String"_s,
                "title()"_s
            },
            {
                "bool"_s,
                "enabled()"_s
            },
            {
                "bool"_s,
                "checked()"_s
            },
            {
                "unsigned"_s,
                "indentationLevel()"_s
            },
            {
                "Vector<WebKit::WebContextMenuItemData>"_s,
                "submenu()"_s
            },
        } },
#endif // ENABLE(CONTEXT_MENUS)
        { "WebCore::DOMCacheEngine::CacheInfo"_s, {
            {
                "WebCore::DOMCacheIdentifier"_s,
                "identifier"_s
            },
            {
                "String"_s,
                "name"_s
            },
        } },
        { "WebCore::DOMCacheEngine::CacheInfos"_s, {
            {
                "Vector<WebCore::DOMCacheEngine::CacheInfo>"_s,
                "infos"_s
            },
            {
                "uint64_t"_s,
                "updateCounter"_s
            },
        } },
        { "WebCore::DOMCacheEngine::CacheIdentifierOperationResult"_s, {
            {
                "WebCore::DOMCacheIdentifier"_s,
                "identifier"_s
            },
            {
                "bool"_s,
                "hadStorageError"_s
            },
        } },
#if HAVE(TRANSLATION_UI_SERVICES) && ENABLE(CONTEXT_MENUS)
        { "WebCore::TranslationContextMenuInfo"_s, {
            {
                "String"_s,
                "text"_s
            },
            {
                "WebCore::IntRect"_s,
                "selectionBoundsInRootView"_s
            },
            {
                "WebCore::IntPoint"_s,
                "locationInRootView"_s
            },
            {
                "WebCore::TranslationContextMenuMode"_s,
                "mode"_s
            },
            {
                "WebCore::TranslationContextMenuSource"_s,
                "source"_s
            },
        } },
#endif // HAVE(TRANSLATION_UI_SERVICES) && ENABLE(CONTEXT_MENUS)
#if USE(APPKIT)
        { "WebCore::AppKitControlSystemImage"_s, {
            {
                "WebCore::Color"_s,
                "m_tintColor"_s
            },
            {
                "bool"_s,
                "m_useDarkAppearance"_s
            },
        } },
#endif // USE(APPKIT)
        { "WebCore::Style::ListStyleType"_s, {
            {
                "Variant<WebCore::Style::ListStyleType::NoneData, WebCore::Style::ListStyleType::StringData, WebCore::Style::ListStyleType::CounterStyleData>"_s,
                "ipcData()"_s
            },
        } },
        { "WebCore::Style::ListStyleType::NoneData"_s, {
        } },
        { "WebCore::Style::ListStyleType::StringData"_s, {
            {
                "AtomString"_s,
                "identifier"_s
            },
        } },
        { "WebCore::Style::ListStyleType::CounterStyleData"_s, {
            {
                "AtomString"_s,
                "identifier"_s
            },
        } },
        { "WebCore::DOMCacheEngine::CrossThreadRecord"_s, {
            {
                "uint64_t"_s,
                "identifier"_s
            },
            {
                "uint64_t"_s,
                "updateResponseCounter"_s
            },
            {
                "WebCore::FetchHeadersGuard"_s,
                "requestHeadersGuard"_s
            },
            {
                "WebCore::ResourceRequest"_s,
                "request"_s
            },
            {
                "WebCore::FetchOptions"_s,
                "options"_s
            },
            {
                "String"_s,
                "referrer"_s
            },
            {
                "WebCore::FetchHeadersGuard"_s,
                "responseHeadersGuard"_s
            },
            {
                "WebCore::ResourceResponseData"_s,
                "response"_s
            },
            {
                "Variant<std::nullptr_t, Ref<WebCore::FormData>, Ref<WebCore::SharedBuffer>>"_s,
                "responseBody"_s
            },
            {
                "uint64_t"_s,
                "responseBodySize"_s
            },
        } },
        { "WebCore::TransformationMatrix"_s, {
            {
                "double"_s,
                "m11()"_s
            },
            {
                "double"_s,
                "m12()"_s
            },
            {
                "double"_s,
                "m13()"_s
            },
            {
                "double"_s,
                "m14()"_s
            },
            {
                "double"_s,
                "m21()"_s
            },
            {
                "double"_s,
                "m22()"_s
            },
            {
                "double"_s,
                "m23()"_s
            },
            {
                "double"_s,
                "m24()"_s
            },
            {
                "double"_s,
                "m31()"_s
            },
            {
                "double"_s,
                "m32()"_s
            },
            {
                "double"_s,
                "m33()"_s
            },
            {
                "double"_s,
                "m34()"_s
            },
            {
                "double"_s,
                "m41()"_s
            },
            {
                "double"_s,
                "m42()"_s
            },
            {
                "double"_s,
                "m43()"_s
            },
            {
                "double"_s,
                "m44()"_s
            },
        } },
        { "WebCore::CacheQueryOptions"_s, {
            {
                "bool"_s,
                "ignoreSearch"_s
            },
            {
                "bool"_s,
                "ignoreMethod"_s
            },
            {
                "bool"_s,
                "ignoreVary"_s
            },
        } },
        { "WebCore::CharacterRange"_s, {
            {
                "uint64_t"_s,
                "location"_s
            },
            {
                "uint64_t"_s,
                "length"_s
            },
        } },
        { "WebCore::AffineTransform"_s, {
            {
                "std::span<const double, 6>"_s,
                "span()"_s
            },
        } },
        { "WebCore::FloatPoint"_s, {
            {
                "float"_s,
                "x()"_s
            },
            {
                "float"_s,
                "y()"_s
            },
        } },
        { "WebCore::FloatPoint3D"_s, {
            {
                "float"_s,
                "x()"_s
            },
            {
                "float"_s,
                "y()"_s
            },
            {
                "float"_s,
                "z()"_s
            },
        } },
        { "WebCore::FloatQuad"_s, {
            {
                "WebCore::FloatPoint"_s,
                "p1()"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "p2()"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "p3()"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "p4()"_s
            },
        } },
        { "WebCore::IDBCursorRecord"_s, {
            {
                "WebCore::IDBKeyData"_s,
                "key"_s
            },
            {
                "WebCore::IDBKeyData"_s,
                "primaryKey"_s
            },
            {
                "WebCore::IDBValue"_s,
                "value"_s
            },
        } },
        { "WebCore::IDBCursorInfo"_s, {
            {
                "WebCore::IDBResourceIdentifier"_s,
                "identifier()"_s
            },
            {
                "WebCore::IDBResourceIdentifier"_s,
                "transactionIdentifier()"_s
            },
            {
                "WebCore::IDBObjectStoreIdentifier"_s,
                "objectStoreIdentifier()"_s
            },
            {
                "Variant<WebCore::IDBObjectStoreIdentifier, WebCore::IDBIndexIdentifier>"_s,
                "sourceIdentifier()"_s
            },
            {
                "WebCore::IDBKeyRangeData"_s,
                "range()"_s
            },
            {
                "WebCore::IndexedDB::CursorSource"_s,
                "cursorSource()"_s
            },
            {
                "WebCore::IndexedDB::CursorDirection"_s,
                "cursorDirection()"_s
            },
            {
                "WebCore::IndexedDB::CursorType"_s,
                "cursorType()"_s
            },
        } },
        { "WebCore::IDBError"_s, {
            {
                "std::optional<WebCore::ExceptionCode>"_s,
                "code()"_s
            },
            {
                "String"_s,
                "messageForSerialization()"_s
            },
        } },
        { "WebCore::IDBGetAllRecordsData"_s, {
            {
                "WebCore::IDBKeyRangeData"_s,
                "keyRangeData"_s
            },
            {
                "WebCore::IndexedDB::GetAllType"_s,
                "getAllType"_s
            },
            {
                "std::optional<uint32_t>"_s,
                "count"_s
            },
            {
                "WebCore::IDBObjectStoreIdentifier"_s,
                "objectStoreIdentifier"_s
            },
            {
                "std::optional<WebCore::IDBIndexIdentifier>"_s,
                "indexIdentifier"_s
            },
        } },
        { "WebCore::IDBGetResult"_s, {
            {
                "WebCore::IDBKeyData"_s,
                "keyData()"_s
            },
            {
                "WebCore::IDBKeyData"_s,
                "primaryKeyData()"_s
            },
            {
                "WebCore::IDBValue"_s,
                "value()"_s
            },
            {
                "std::optional<WebCore::IDBKeyPath>"_s,
                "keyPath()"_s
            },
            {
                "Vector<WebCore::IDBCursorRecord>"_s,
                "prefetchedRecords()"_s
            },
            {
                "bool"_s,
                "isDefined()"_s
            },
        } },
        { "WebCore::IDBGetAllResult"_s, {
            {
                "WebCore::IndexedDB::GetAllType"_s,
                "type()"_s
            },
            {
                "Vector<WebCore::IDBKeyData>"_s,
                "keys()"_s
            },
            {
                "Vector<WebCore::IDBValue>"_s,
                "values()"_s
            },
            {
                "std::optional<WebCore::IDBKeyPath>"_s,
                "keyPath()"_s
            },
        } },
        { "WebCore::IDBDatabaseInfo"_s, {
            {
                "String"_s,
                "m_name"_s
            },
            {
                "uint64_t"_s,
                "m_version"_s
            },
            {
                "uint64_t"_s,
                "m_maxIndexID"_s
            },
            {
                "HashMap<WebCore::IDBObjectStoreIdentifier, WebCore::IDBObjectStoreInfo>"_s,
                "m_objectStoreMap"_s
            },
        } },
        { "WebCore::IDBKeyRangeData"_s, {
            {
                "WebCore::IDBKeyData"_s,
                "lowerKey"_s
            },
            {
                "WebCore::IDBKeyData"_s,
                "upperKey"_s
            },
            {
                "bool"_s,
                "lowerOpen"_s
            },
            {
                "bool"_s,
                "upperOpen"_s
            },
        } },
        { "WebCore::IDBTransactionInfo"_s, {
            {
                "WebCore::IDBResourceIdentifier"_s,
                "identifier()"_s
            },
            {
                "WebCore::IDBTransactionMode"_s,
                "mode()"_s
            },
            {
                "WebCore::IDBTransactionDurability"_s,
                "durability()"_s
            },
            {
                "uint64_t"_s,
                "newVersion()"_s
            },
            {
                "Vector<String>"_s,
                "objectStores()"_s
            },
            {
                "std::unique_ptr<WebCore::IDBDatabaseInfo>"_s,
                "originalDatabaseInfo()"_s
            },
        } },
        { "WebCore::IDBGetRecordData"_s, {
            {
                "WebCore::IDBKeyRangeData"_s,
                "keyRangeData"_s
            },
            {
                "WebCore::IDBGetRecordDataType"_s,
                "type"_s
            },
        } },
        { "WebCore::IDBIndexInfo"_s, {
            {
                "WebCore::IDBIndexIdentifier"_s,
                "identifier()"_s
            },
            {
                "WebCore::IDBObjectStoreIdentifier"_s,
                "objectStoreIdentifier()"_s
            },
            {
                "String"_s,
                "name()"_s
            },
            {
                "WebCore::IDBKeyPath"_s,
                "keyPath()"_s
            },
            {
                "bool"_s,
                "unique()"_s
            },
            {
                "bool"_s,
                "multiEntry()"_s
            },
        } },
        { "WebCore::IDBObjectStoreInfo"_s, {
            {
                "WebCore::IDBObjectStoreIdentifier"_s,
                "identifier()"_s
            },
            {
                "String"_s,
                "name()"_s
            },
            {
                "std::optional<WebCore::IDBKeyPath>"_s,
                "keyPath()"_s
            },
            {
                "bool"_s,
                "autoIncrement()"_s
            },
            {
                "HashMap<WebCore::IDBIndexIdentifier, WebCore::IDBIndexInfo>"_s,
                "indexMap()"_s
            },
        } },
        { "WebCore::IDBIterateCursorData"_s, {
            {
                "WebCore::IDBKeyData"_s,
                "keyData"_s
            },
            {
                "WebCore::IDBKeyData"_s,
                "primaryKeyData"_s
            },
            {
                "unsigned"_s,
                "count"_s
            },
            {
                "WebCore::IndexedDB::CursorIterateOption"_s,
                "option"_s
            },
        } },
        { "WebCore::IDBResourceIdentifier"_s, {
            {
                "Markable<WebCore::IDBConnectionIdentifier>"_s,
                "m_idbConnectionIdentifier"_s
            },
            {
                "Markable<WebCore::IDBResourceObjectIdentifier>"_s,
                "m_resourceNumber"_s
            },
        } },
        { "WebCore::IDBValue"_s, {
            {
                "WebCore::ThreadSafeDataBuffer"_s,
                "data()"_s
            },
            {
                "Vector<String>"_s,
                "blobURLs()"_s
            },
            {
                "Vector<String>"_s,
                "blobFilePaths()"_s
            },
        } },
        { "WebCore::IDBOpenRequestData"_s, {
            {
                "WebCore::IDBConnectionIdentifier"_s,
                "m_serverConnectionIdentifier"_s
            },
            {
                "WebCore::IDBResourceIdentifier"_s,
                "m_requestIdentifier"_s
            },
            {
                "WebCore::IDBDatabaseIdentifier"_s,
                "m_databaseIdentifier"_s
            },
            {
                "uint64_t"_s,
                "m_requestedVersion"_s
            },
            {
                "WebCore::IndexedDB::RequestType"_s,
                "m_requestType"_s
            },
        } },
        { "WebCore::IDBRequestData"_s, {
            {
                "WebCore::IDBConnectionIdentifier"_s,
                "m_serverConnectionIdentifier"_s
            },
            {
                "WebCore::IDBResourceIdentifier"_s,
                "m_requestIdentifier"_s
            },
            {
                "WebCore::IDBResourceIdentifier"_s,
                "m_transactionIdentifier"_s
            },
            {
                "std::optional<WebCore::IDBResourceIdentifier>"_s,
                "m_cursorIdentifier"_s
            },
            {
                "Markable<WebCore::IDBObjectStoreIdentifier>"_s,
                "m_objectStoreIdentifier"_s
            },
            {
                "Markable<WebCore::IDBIndexIdentifier>"_s,
                "m_indexIdentifier"_s
            },
            {
                "WebCore::IndexedDB::IndexRecordType"_s,
                "m_indexRecordType"_s
            },
            {
                "uint64_t"_s,
                "m_requestedVersion"_s
            },
            {
                "WebCore::IndexedDB::RequestType"_s,
                "m_requestType"_s
            },
        } },
        { "WebCore::IDBDatabaseIdentifier"_s, {
            {
                "String"_s,
                "m_databaseName"_s
            },
            {
                "WebCore::ClientOrigin"_s,
                "m_origin"_s
            },
            {
                "bool"_s,
                "m_isTransient"_s
            },
        } },
        { "WebCore::IDBDatabaseNameAndVersion"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "uint64_t"_s,
                "version"_s
            },
        } },
        { "WebCore::IDBResultData"_s, {
            {
                "WebCore::IDBResultType"_s,
                "m_type"_s
            },
            {
                "WebCore::IDBResourceIdentifier"_s,
                "m_requestIdentifier"_s
            },
            {
                "WebCore::IDBError"_s,
                "m_error"_s
            },
            {
                "std::optional<WebCore::IDBDatabaseConnectionIdentifier>"_s,
                "m_databaseConnectionIdentifier"_s
            },
            {
                "std::unique_ptr<WebCore::IDBDatabaseInfo>"_s,
                "m_databaseInfo"_s
            },
            {
                "std::unique_ptr<WebCore::IDBTransactionInfo>"_s,
                "m_transactionInfo"_s
            },
            {
                "std::unique_ptr<WebCore::IDBKeyData>"_s,
                "m_resultKey"_s
            },
            {
                "std::unique_ptr<WebCore::IDBGetResult>"_s,
                "m_getResult"_s
            },
            {
                "std::unique_ptr<WebCore::IDBGetAllResult>"_s,
                "m_getAllResult"_s
            },
            {
                "uint64_t"_s,
                "m_resultInteger"_s
            },
        } },
        { "WebCore::IDBKeyData"_s, {
            {
                "bool"_s,
                "isPlaceholder()"_s
            },
            {
                "Variant<std::nullptr_t, WebCore::IDBKeyData::Invalid, Vector<WebCore::IDBKeyData>, String, double, WebCore::IDBKeyData::Date, WebCore::ThreadSafeDataBuffer, WebCore::IDBKeyData::Min, WebCore::IDBKeyData::Max>"_s,
                "value()"_s
            },
        } },
        { "WebCore::IDBKeyData::Invalid"_s, {
        } },
        { "WebCore::IDBKeyData::Min"_s, {
        } },
        { "WebCore::IDBKeyData::Max"_s, {
        } },
        { "WebCore::IDBKeyData::Date"_s, {
            {
                "double"_s,
                "value"_s
            },
        } },
        { "WebCore::IndexKey"_s, {
            {
                "Variant<std::nullptr_t, WebCore::IDBKeyData, Vector<WebCore::IDBKeyData>>"_s,
                "data()"_s
            },
        } },
        { "WebCore::FloatRect"_s, {
            {
                "WebCore::FloatPoint"_s,
                "location()"_s
            },
            {
                "WebCore::FloatSize"_s,
                "size()"_s
            },
        } },
        { "WebCore::LinearTimingFunction::Point"_s, {
            {
                "double"_s,
                "value"_s
            },
            {
                "double"_s,
                "progress"_s
            },
        } },
        { "WebCore::LinearTimingFunction"_s, {
            {
                "Vector<WebCore::LinearTimingFunction::Point>"_s,
                "points()"_s
            },
        } },
        { "WebCore::CubicBezierTimingFunction"_s, {
            {
                "WebCore::CubicBezierTimingFunction::TimingFunctionPreset"_s,
                "timingFunctionPreset()"_s
            },
            {
                "double"_s,
                "x1()"_s
            },
            {
                "double"_s,
                "y1()"_s
            },
            {
                "double"_s,
                "x2()"_s
            },
            {
                "double"_s,
                "y2()"_s
            },
        } },
        { "WebCore::StepsTimingFunction"_s, {
            {
                "int"_s,
                "numberOfSteps()"_s
            },
            {
                "std::optional<WebCore::StepsTimingFunction::StepPosition>"_s,
                "stepPosition()"_s
            },
        } },
        { "WebCore::SpringTimingFunction"_s, {
            {
                "double"_s,
                "mass()"_s
            },
            {
                "double"_s,
                "stiffness()"_s
            },
            {
                "double"_s,
                "damping()"_s
            },
            {
                "double"_s,
                "initialVelocity()"_s
            },
        } },
        { "WebCore::ResourceLoadStatistics"_s, {
            {
                "WebCore::RegistrableDomain"_s,
                "registrableDomain"_s
            },
            {
                "WallTime"_s,
                "lastSeen"_s
            },
            {
                "bool"_s,
                "hadUserInteraction"_s
            },
            {
                "WallTime"_s,
                "mostRecentUserInteractionTime"_s
            },
            {
                "bool"_s,
                "grandfathered"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "storageAccessUnderTopFrameDomains"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "topFrameUniqueRedirectsTo"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "topFrameUniqueRedirectsFrom"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "topFrameLinkDecorationsFrom"_s
            },
            {
                "bool"_s,
                "gotLinkDecorationFromPrevalentResource"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "topFrameLoadedThirdPartyScripts"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "subframeUnderTopFrameDomains"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "subresourceUnderTopFrameDomains"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "subresourceUniqueRedirectsTo"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "subresourceUniqueRedirectsFrom"_s
            },
            {
                "bool"_s,
                "isPrevalentResource"_s
            },
            {
                "bool"_s,
                "isVeryPrevalentResource"_s
            },
            {
                "unsigned"_s,
                "dataRecordsRemoved"_s
            },
            {
                "unsigned"_s,
                "timesAccessedAsFirstPartyDueToUserInteraction"_s
            },
            {
                "unsigned"_s,
                "timesAccessedAsFirstPartyDueToStorageAccessAPI"_s
            },
#if ENABLE(WEB_API_STATISTICS)
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "topFrameRegistrableDomainsWhichAccessedWebAPIs"_s
            },
#endif
#if ENABLE(WEB_API_STATISTICS)
            {
                "HashSet<String>"_s,
                "fontsFailedToLoad"_s
            },
#endif
#if ENABLE(WEB_API_STATISTICS)
            {
                "HashSet<String>"_s,
                "fontsSuccessfullyLoaded"_s
            },
#endif
#if ENABLE(WEB_API_STATISTICS)
            {
                "WebCore::CanvasActivityRecord"_s,
                "canvasActivityRecord"_s
            },
#endif
#if ENABLE(WEB_API_STATISTICS)
            {
                "OptionSet<WebCore::NavigatorAPIsAccessed>"_s,
                "navigatorFunctionsAccessed"_s
            },
#endif
#if ENABLE(WEB_API_STATISTICS)
            {
                "OptionSet<WebCore::ScreenAPIsAccessed>"_s,
                "screenFunctionsAccessed"_s
            },
#endif
        } },
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "WebCore::GraphicsContextGLActiveInfo"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "GCGLenum"_s,
                "type"_s
            },
            {
                "GCGLint"_s,
                "size"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "WebCore::ShareDataWithParsedURL"_s, {
            {
                "WebCore::ShareData"_s,
                "shareData"_s
            },
            {
                "std::optional<URL>"_s,
                "url"_s
            },
            {
                "Vector<WebCore::RawFile>"_s,
                "files"_s
            },
            {
                "WebCore::ShareDataOriginator"_s,
                "originator"_s
            },
        } },
        { "WebCore::ShareData"_s, {
            {
                "String"_s,
                "title"_s
            },
            {
                "String"_s,
                "text"_s
            },
            {
                "String"_s,
                "url"_s
            },
        } },
#if ENABLE(WEB_PAGE_SPATIAL_BACKDROP)
        { "WebCore::SpatialBackdropSource"_s, {
            {
                "URL"_s,
                "m_sourceURL"_s
            },
            {
                "URL"_s,
                "m_modelURL"_s
            },
            {
                "std::optional<URL>"_s,
                "m_environmentMapURL"_s
            },
        } },
#endif // ENABLE(WEB_PAGE_SPATIAL_BACKDROP)
        { "WebCore::TargetedElementAdjustment"_s, {
            {
                "WebCore::TargetedElementIdentifiers"_s,
                "identifiers"_s
            },
            {
                "WebCore::TargetedElementSelectors"_s,
                "selectors"_s
            },
        } },
        { "WebCore::TargetedElementRequest"_s, {
            {
                "Variant<WebCore::FloatPoint, String, WebCore::TargetedElementSelectors>"_s,
                "data"_s
            },
            {
                "bool"_s,
                "canIncludeNearbyElements"_s
            },
            {
                "bool"_s,
                "shouldIgnorePointerEventsNone"_s
            },
        } },
        { "WebCore::TargetedElementInfo"_s, {
            {
                "WebCore::NodeIdentifier"_s,
                "nodeIdentifier"_s
            },
            {
                "WebCore::ScriptExecutionContextIdentifier"_s,
                "documentIdentifier"_s
            },
            {
                "WebCore::RectEdges<bool>"_s,
                "offsetEdges"_s
            },
            {
                "String"_s,
                "renderedText"_s
            },
            {
                "String"_s,
                "searchableText"_s
            },
            {
                "String"_s,
                "screenReaderText"_s
            },
            {
                "Vector<Vector<String>>"_s,
                "selectors"_s
            },
            {
                "WebCore::FloatRect"_s,
                "boundsInRootView"_s
            },
            {
                "WebCore::FloatRect"_s,
                "boundsInClientCoordinates"_s
            },
            {
                "WebCore::PositionType"_s,
                "positionType"_s
            },
            {
                "Vector<WebCore::FrameIdentifier>"_s,
                "childFrameIdentifiers"_s
            },
            {
                "HashSet<URL>"_s,
                "mediaAndLinkURLs"_s
            },
            {
                "bool"_s,
                "isNearbyTarget"_s
            },
            {
                "bool"_s,
                "isPseudoElement"_s
            },
            {
                "bool"_s,
                "isInShadowTree"_s
            },
            {
                "bool"_s,
                "isInVisibilityAdjustmentSubtree"_s
            },
            {
                "bool"_s,
                "hasLargeReplacedDescendant"_s
            },
            {
                "bool"_s,
                "hasAudibleMedia"_s
            },
        } },
        { "WebCore::RawFile"_s, {
            {
                "String"_s,
                "fileName"_s
            },
            {
                "RefPtr<WebCore::SharedBuffer>"_s,
                "fileData"_s
            },
        } },
        { "WebCore::FloatRoundedRect"_s, {
            {
                "WebCore::FloatRect"_s,
                "rect()"_s
            },
            {
                "WebCore::FloatSize"_s,
                "radii().topLeft()"_s
            },
            {
                "WebCore::FloatSize"_s,
                "radii().topRight()"_s
            },
            {
                "WebCore::FloatSize"_s,
                "radii().bottomLeft()"_s
            },
            {
                "WebCore::FloatSize"_s,
                "radii().bottomRight()"_s
            },
        } },
        { "WebCore::IntRect"_s, {
            {
                "WebCore::IntPoint"_s,
                "location()"_s
            },
            {
                "WebCore::IntSize"_s,
                "size()"_s
            },
        } },
        { "WebCore::IntPoint"_s, {
            {
                "int"_s,
                "x()"_s
            },
            {
                "int"_s,
                "y()"_s
            },
        } },
        { "WebCore::IntSize"_s, {
            {
                "int"_s,
                "width()"_s
            },
            {
                "int"_s,
                "height()"_s
            },
        } },
        { "WebCore::FloatSize"_s, {
            {
                "float"_s,
                "width()"_s
            },
            {
                "float"_s,
                "height()"_s
            },
        } },
        { "WebCore::LayoutUnit"_s, {
            {
                "int"_s,
                "rawValue()"_s
            },
        } },
        { "WebCore::LayoutPoint"_s, {
            {
                "WebCore::LayoutUnit"_s,
                "x()"_s
            },
            {
                "WebCore::LayoutUnit"_s,
                "y()"_s
            },
        } },
        { "WebCore::LayoutSize"_s, {
            {
                "WebCore::LayoutUnit"_s,
                "width()"_s
            },
            {
                "WebCore::LayoutUnit"_s,
                "height()"_s
            },
        } },
        { "WebCore::DictionaryPopupInfo"_s, {
            {
                "WebCore::FloatPoint"_s,
                "origin"_s
            },
            {
                "RefPtr<WebCore::TextIndicator>"_s,
                "textIndicator"_s
            },
#if ENABLE(LEGACY_PDFKIT_PLUGIN)
            {
                "WebCore::DictionaryPopupInfoCocoa"_s,
                "platformData"_s
            },
#endif
#if !(ENABLE(LEGACY_PDFKIT_PLUGIN))
            {
                "String"_s,
                "text"_s
            },
#endif
        } },
        { "WebCore::PrivateClickMeasurement"_s, {
            {
                "uint8_t"_s,
                "sourceID()"_s
            },
            {
                "WebCore::PCM::SourceSite"_s,
                "sourceSite()"_s
            },
            {
                "WebCore::PCM::AttributionDestinationSite"_s,
                "destinationSite()"_s
            },
            {
                "WallTime"_s,
                "timeOfAdClick()"_s
            },
            {
                "WebCore::PCM::AttributionEphemeral"_s,
                "isEphemeral()"_s
            },
            {
                "std::optional<uint64_t>"_s,
                "adamID()"_s
            },
            {
                "std::optional<WebCore::PCM::AttributionTriggerData>"_s,
                "attributionTriggerData()"_s
            },
            {
                "WebCore::PCM::AttributionTimeToSendData"_s,
                "timesToSend()"_s
            },
            {
                "std::optional<WebCore::PCM::EphemeralNonce>"_s,
                "ephemeralSourceNonce()"_s
            },
            {
                "String"_s,
                "sourceApplicationBundleID()"_s
            },
        } },
        { "WebCore::PCM::SourceSite"_s, {
            {
                "WebCore::RegistrableDomain"_s,
                "registrableDomain"_s
            },
        } },
        { "WebCore::PCM::AttributionDestinationSite"_s, {
            {
                "WebCore::RegistrableDomain"_s,
                "registrableDomain"_s
            },
        } },
        { "WebCore::PCM::EphemeralNonce"_s, {
            {
                "String"_s,
                "nonce"_s
            },
        } },
        { "WebCore::PCM::AttributionTriggerData"_s, {
            {
                "uint8_t"_s,
                "data"_s
            },
            {
                "uint8_t"_s,
                "priority"_s
            },
            {
                "WebCore::PCM::WasSent"_s,
                "wasSent"_s
            },
            {
                "std::optional<WebCore::RegistrableDomain>"_s,
                "sourceRegistrableDomain"_s
            },
            {
                "std::optional<WebCore::PCM::EphemeralNonce>"_s,
                "ephemeralDestinationNonce"_s
            },
            {
                "std::optional<WebCore::RegistrableDomain>"_s,
                "destinationSite"_s
            },
        } },
        { "WebCore::PCM::AttributionTimeToSendData"_s, {
            {
                "std::optional<WallTime>"_s,
                "sourceEarliestTimeToSend"_s
            },
            {
                "std::optional<WallTime>"_s,
                "destinationEarliestTimeToSend"_s
            },
        } },
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
        { "WebCore::ApplePayRecurringPaymentRequest"_s, {
            {
                "String"_s,
                "paymentDescription"_s
            },
            {
                "WebCore::ApplePayLineItem"_s,
                "regularBilling"_s
            },
            {
                "std::optional<WebCore::ApplePayLineItem>"_s,
                "trialBilling"_s
            },
            {
                "String"_s,
                "billingAgreement"_s
            },
            {
                "String"_s,
                "managementURL"_s
            },
            {
                "String"_s,
                "tokenNotificationURL"_s
            },
        } },
#endif // ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
        { "WebCore::ApplePayPaymentTokenContext"_s, {
            {
                "String"_s,
                "merchantIdentifier"_s
            },
            {
                "String"_s,
                "externalIdentifier"_s
            },
            {
                "String"_s,
                "merchantName"_s
            },
            {
                "String"_s,
                "merchantDomain"_s
            },
            {
                "String"_s,
                "amount"_s
            },
        } },
#endif // ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
        { "WebCore::ApplePayDeferredPaymentRequest"_s, {
            {
                "String"_s,
                "billingAgreement"_s
            },
            {
                "WebCore::ApplePayLineItem"_s,
                "deferredBilling"_s
            },
            {
                "WallTime"_s,
                "freeCancellationDate"_s
            },
            {
                "String"_s,
                "freeCancellationDateTimeZone"_s
            },
            {
                "String"_s,
                "managementURL"_s
            },
            {
                "String"_s,
                "paymentDescription"_s
            },
            {
                "String"_s,
                "tokenNotificationURL"_s
            },
        } },
#endif // ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
        { "WebCore::ApplePayPaymentOrderDetails"_s, {
            {
                "String"_s,
                "orderTypeIdentifier"_s
            },
            {
                "String"_s,
                "orderIdentifier"_s
            },
            {
                "String"_s,
                "webServiceURL"_s
            },
            {
                "String"_s,
                "authenticationToken"_s
            },
        } },
#endif // ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
#if ENABLE(APPLE_PAY_AMS_UI) && ENABLE(PAYMENT_REQUEST)
        { "WebCore::ApplePayAMSUIRequest"_s, {
            {
                "String"_s,
                "engagementRequest"_s
            },
        } },
#endif // ENABLE(APPLE_PAY_AMS_UI) && ENABLE(PAYMENT_REQUEST)
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
        { "WebCore::ApplePayAutomaticReloadPaymentRequest"_s, {
            {
                "String"_s,
                "paymentDescription"_s
            },
            {
                "WebCore::ApplePayLineItem"_s,
                "automaticReloadBilling"_s
            },
            {
                "String"_s,
                "billingAgreement"_s
            },
            {
                "String"_s,
                "managementURL"_s
            },
            {
                "String"_s,
                "tokenNotificationURL"_s
            },
        } },
#endif // ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
        { "WebCore::ApplePayDateComponents"_s, {
            {
                "std::optional<unsigned>"_s,
                "years"_s
            },
            {
                "std::optional<unsigned>"_s,
                "months"_s
            },
            {
                "std::optional<unsigned>"_s,
                "days"_s
            },
            {
                "std::optional<unsigned>"_s,
                "hours"_s
            },
        } },
#endif // ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
        { "WebCore::ApplePayDateComponentsRange"_s, {
            {
                "WebCore::ApplePayDateComponents"_s,
                "startDateComponents"_s
            },
            {
                "WebCore::ApplePayDateComponents"_s,
                "endDateComponents"_s
            },
        } },
#endif // ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePaySetupConfiguration"_s, {
            {
                "String"_s,
                "merchantIdentifier"_s
            },
            {
                "String"_s,
                "referrerIdentifier"_s
            },
            {
                "String"_s,
                "signature"_s
            },
            {
                "Vector<String>"_s,
                "signedFields"_s
            },
        } },
#endif // ENABLE(APPLE_PAY)
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayLineItem"_s, {
            {
                "WebCore::ApplePayLineItem::Type"_s,
                "type"_s
            },
            {
                "String"_s,
                "label"_s
            },
            {
                "String"_s,
                "amount"_s
            },
            {
                "WebCore::ApplePayPaymentTiming"_s,
                "paymentTiming"_s
            },
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
            {
                "WallTime"_s,
                "recurringPaymentStartDate"_s
            },
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
            {
                "WebCore::ApplePayRecurringPaymentDateUnit"_s,
                "recurringPaymentIntervalUnit"_s
            },
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
            {
                "unsigned"_s,
                "recurringPaymentIntervalCount"_s
            },
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
            {
                "WallTime"_s,
                "recurringPaymentEndDate"_s
            },
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
            {
                "WallTime"_s,
                "deferredPaymentDate"_s
            },
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
            {
                "String"_s,
                "automaticReloadPaymentThresholdAmount"_s
            },
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
            {
                "std::optional<WebCore::ApplePayLineItem::DisbursementLineItemType>"_s,
                "disbursementLineItemType"_s
            },
#endif
        } },
#endif // ENABLE(APPLE_PAY)
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayShippingMethod"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "String"_s,
                "detail"_s
            },
            {
                "String"_s,
                "amount"_s
            },
            {
                "String"_s,
                "identifier"_s
            },
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
            {
                "std::optional<WebCore::ApplePayDateComponentsRange>"_s,
                "dateComponentsRange"_s
            },
#endif
#if ENABLE(APPLE_PAY_SELECTED_SHIPPING_METHOD)
            {
                "bool"_s,
                "selected"_s
            },
#endif
        } },
#endif // ENABLE(APPLE_PAY)
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayError"_s, {
            {
                "WebCore::ApplePayErrorCode"_s,
                "code()"_s
            },
            {
                "std::optional<WebCore::ApplePayErrorContactField>"_s,
                "contactField()"_s
            },
            {
                "String"_s,
                "message()"_s
            },
            {
                "std::optional<WebCore::ApplePayError::Domain>"_s,
                "domain()"_s
            },
        } },
#endif // ENABLE(APPLE_PAY)
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayLogoSystemImage"_s, {
            {
                "WebCore::ApplePayLogoStyle"_s,
                "applePayLogoStyle()"_s
            },
        } },
#endif // ENABLE(APPLE_PAY)
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayDetailsUpdateBase"_s, {
            {
                "WebCore::ApplePayLineItem"_s,
                "newTotal"_s
            },
            {
                "Vector<WebCore::ApplePayLineItem>"_s,
                "newLineItems"_s
            },
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayRecurringPaymentRequest>"_s,
                "newRecurringPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>"_s,
                "newAutomaticReloadPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
            {
                "std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>"_s,
                "newMultiTokenContexts"_s
            },
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayDeferredPaymentRequest>"_s,
                "newDeferredPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
            {
                "std::optional<WebCore::ApplePayDisbursementRequest>"_s,
                "newDisbursementRequest"_s
            },
#endif
        } },
#endif // ENABLE(APPLE_PAY)
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayPaymentMethodUpdate"_s, {
            {
                "WebCore::ApplePayLineItem"_s,
                "newTotal"_s
            },
            {
                "Vector<WebCore::ApplePayLineItem>"_s,
                "newLineItems"_s
            },
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayRecurringPaymentRequest>"_s,
                "newRecurringPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>"_s,
                "newAutomaticReloadPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
            {
                "std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>"_s,
                "newMultiTokenContexts"_s
            },
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayDeferredPaymentRequest>"_s,
                "newDeferredPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
            {
                "std::optional<WebCore::ApplePayDisbursementRequest>"_s,
                "newDisbursementRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
            {
                "Vector<Ref<WebCore::ApplePayError>>"_s,
                "errors"_s
            },
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
            {
                "Vector<WebCore::ApplePayShippingMethod>"_s,
                "newShippingMethods"_s
            },
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
            {
                "String"_s,
                "installmentGroupIdentifier"_s
            },
#endif
        } },
#endif // ENABLE(APPLE_PAY)
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayShippingContactUpdate"_s, {
            {
                "WebCore::ApplePayLineItem"_s,
                "newTotal"_s
            },
            {
                "Vector<WebCore::ApplePayLineItem>"_s,
                "newLineItems"_s
            },
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayRecurringPaymentRequest>"_s,
                "newRecurringPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>"_s,
                "newAutomaticReloadPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
            {
                "std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>"_s,
                "newMultiTokenContexts"_s
            },
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayDeferredPaymentRequest>"_s,
                "newDeferredPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
            {
                "std::optional<WebCore::ApplePayDisbursementRequest>"_s,
                "newDisbursementRequest"_s
            },
#endif
            {
                "Vector<Ref<WebCore::ApplePayError>>"_s,
                "errors"_s
            },
            {
                "Vector<WebCore::ApplePayShippingMethod>"_s,
                "newShippingMethods"_s
            },
        } },
#endif // ENABLE(APPLE_PAY)
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayShippingMethodUpdate"_s, {
            {
                "WebCore::ApplePayLineItem"_s,
                "newTotal"_s
            },
            {
                "Vector<WebCore::ApplePayLineItem>"_s,
                "newLineItems"_s
            },
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayRecurringPaymentRequest>"_s,
                "newRecurringPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>"_s,
                "newAutomaticReloadPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
            {
                "std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>"_s,
                "newMultiTokenContexts"_s
            },
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayDeferredPaymentRequest>"_s,
                "newDeferredPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
            {
                "std::optional<WebCore::ApplePayDisbursementRequest>"_s,
                "newDisbursementRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
            {
                "Vector<WebCore::ApplePayShippingMethod>"_s,
                "newShippingMethods"_s
            },
#endif
        } },
#endif // ENABLE(APPLE_PAY)
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayPaymentAuthorizationResult"_s, {
            {
                "unsigned short"_s,
                "status"_s
            },
            {
                "Vector<Ref<WebCore::ApplePayError>>"_s,
                "errors"_s
            },
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
            {
                "std::optional<WebCore::ApplePayPaymentOrderDetails>"_s,
                "orderDetails"_s
            },
#endif
        } },
#endif // ENABLE(APPLE_PAY)
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
        { "WebCore::ApplePayDisbursementRequest"_s, {
            {
                "std::optional<Vector<WebCore::ApplePayContactField>>"_s,
                "requiredRecipientContactFields"_s
            },
        } },
#endif // ENABLE(APPLE_PAY_DISBURSEMENTS)
#if ENABLE(APPLE_PAY_INSTALLMENTS)
        { "WebCore::ApplePayInstallmentConfiguration"_s, {
            {
                "WebCore::ApplePaySetupFeatureType"_s,
                "featureType"_s
            },
            {
                "String"_s,
                "merchandisingImageData"_s
            },
            {
                "String"_s,
                "openToBuyThresholdAmount"_s
            },
            {
                "String"_s,
                "bindingTotalAmount"_s
            },
            {
                "String"_s,
                "currencyCode"_s
            },
            {
                "bool"_s,
                "isInStorePurchase"_s
            },
            {
                "String"_s,
                "merchantIdentifier"_s
            },
            {
                "String"_s,
                "referrerIdentifier"_s
            },
            {
                "Vector<WebCore::ApplePayInstallmentItem>"_s,
                "items"_s
            },
            {
                "String"_s,
                "applicationMetadata"_s
            },
            {
                "WebCore::ApplePayInstallmentRetailChannel"_s,
                "retailChannel"_s
            },
        } },
#endif // ENABLE(APPLE_PAY_INSTALLMENTS)
#if ENABLE(APPLE_PAY_INSTALLMENTS)
        { "WebCore::PaymentInstallmentConfiguration"_s, {
            {
                "std::optional<WebCore::ApplePayInstallmentConfiguration>"_s,
                "applePayInstallmentConfiguration()"_s
            },
        } },
#endif // ENABLE(APPLE_PAY_INSTALLMENTS)
#if ENABLE(APPLE_PAY_INSTALLMENTS)
        { "WebCore::ApplePayInstallmentItem"_s, {
            {
                "WebCore::ApplePayInstallmentItemType"_s,
                "type"_s
            },
            {
                "String"_s,
                "amount"_s
            },
            {
                "String"_s,
                "currencyCode"_s
            },
            {
                "String"_s,
                "programIdentifier"_s
            },
            {
                "String"_s,
                "apr"_s
            },
            {
                "String"_s,
                "programTerms"_s
            },
        } },
#endif // ENABLE(APPLE_PAY_INSTALLMENTS)
#if ENABLE(APPLE_PAY_COUPON_CODE)
        { "WebCore::ApplePayCouponCodeUpdate"_s, {
            {
                "WebCore::ApplePayLineItem"_s,
                "newTotal"_s
            },
            {
                "Vector<WebCore::ApplePayLineItem>"_s,
                "newLineItems"_s
            },
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayRecurringPaymentRequest>"_s,
                "newRecurringPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>"_s,
                "newAutomaticReloadPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
            {
                "std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>"_s,
                "newMultiTokenContexts"_s
            },
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
            {
                "std::optional<WebCore::ApplePayDeferredPaymentRequest>"_s,
                "newDeferredPaymentRequest"_s
            },
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
            {
                "std::optional<WebCore::ApplePayDisbursementRequest>"_s,
                "newDisbursementRequest"_s
            },
#endif
            {
                "Vector<Ref<WebCore::ApplePayError>>"_s,
                "errors"_s
            },
            {
                "Vector<WebCore::ApplePayShippingMethod>"_s,
                "newShippingMethods"_s
            },
        } },
#endif // ENABLE(APPLE_PAY_COUPON_CODE)
#if ENABLE(APPLICATION_MANIFEST)
        { "WebCore::ApplicationManifest::Icon"_s, {
            {
                "URL"_s,
                "src"_s
            },
            {
                "Vector<String>"_s,
                "sizes"_s
            },
            {
                "String"_s,
                "type"_s
            },
            {
                "OptionSet<WebCore::ApplicationManifest::Icon::Purpose>"_s,
                "purposes"_s
            },
        } },
#endif // ENABLE(APPLICATION_MANIFEST)
#if ENABLE(APPLICATION_MANIFEST)
        { "WebCore::ApplicationManifest::Shortcut"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "URL"_s,
                "url"_s
            },
            {
                "Vector<WebCore::ApplicationManifest::Icon>"_s,
                "icons"_s
            },
        } },
#endif // ENABLE(APPLICATION_MANIFEST)
#if ENABLE(APPLICATION_MANIFEST)
        { "WebCore::ApplicationManifest"_s, {
            {
                "String"_s,
                "rawJSON"_s
            },
            {
                "WebCore::ApplicationManifest::Direction"_s,
                "dir"_s
            },
            {
                "String"_s,
                "name"_s
            },
            {
                "String"_s,
                "shortName"_s
            },
            {
                "String"_s,
                "description"_s
            },
            {
                "URL"_s,
                "scope"_s
            },
            {
                "bool"_s,
                "isDefaultScope"_s
            },
            {
                "WebCore::ApplicationManifest::Display"_s,
                "display"_s
            },
            {
                "std::optional<WebCore::ScreenOrientationLockType>"_s,
                "orientation"_s
            },
            {
                "URL"_s,
                "manifestURL"_s
            },
            {
                "URL"_s,
                "startURL"_s
            },
            {
                "URL"_s,
                "id"_s
            },
            {
                "WebCore::Color"_s,
                "backgroundColor"_s
            },
            {
                "WebCore::Color"_s,
                "themeColor"_s
            },
            {
                "Vector<String>"_s,
                "categories"_s
            },
            {
                "Vector<WebCore::ApplicationManifest::Icon>"_s,
                "icons"_s
            },
            {
                "Vector<WebCore::ApplicationManifest::Shortcut>"_s,
                "shortcuts"_s
            },
        } },
#endif // ENABLE(APPLICATION_MANIFEST)
        { "WebCore::RetrieveRecordsOptions"_s, {
            {
                "WebCore::ResourceRequest"_s,
                "request"_s
            },
            {
                "WebCore::CrossOriginEmbedderPolicy"_s,
                "crossOriginEmbedderPolicy"_s
            },
            {
                "Ref<WebCore::SecurityOrigin>"_s,
                "sourceOrigin"_s
            },
            {
                "bool"_s,
                "ignoreSearch"_s
            },
            {
                "bool"_s,
                "ignoreMethod"_s
            },
            {
                "bool"_s,
                "ignoreVary"_s
            },
            {
                "bool"_s,
                "shouldProvideResponse"_s
            },
        } },
        { "WebCore::ContactInfo"_s, {
            {
                "Vector<String>"_s,
                "name"_s
            },
            {
                "Vector<String>"_s,
                "email"_s
            },
            {
                "Vector<String>"_s,
                "tel"_s
            },
        } },
        { "WebCore::ContactsRequestData"_s, {
            {
                "Vector<WebCore::ContactProperty>"_s,
                "properties"_s
            },
            {
                "bool"_s,
                "multiple"_s
            },
            {
                "String"_s,
                "url"_s
            },
        } },
#if ENABLE(MEDIA_SESSION)
        { "WebCore::MediaPositionState"_s, {
            {
                "double"_s,
                "duration"_s
            },
            {
                "double"_s,
                "playbackRate"_s
            },
            {
                "double"_s,
                "position"_s
            },
        } },
#endif // ENABLE(MEDIA_SESSION)
#if ENABLE(WEB_RTC)
        { "WebCore::DetachedRTCDataChannel"_s, {
            {
                "WebCore::RTCDataChannelIdentifier"_s,
                "identifier"_s
            },
            {
                "String"_s,
                "label"_s
            },
            {
                "WebCore::RTCDataChannelInit"_s,
                "options"_s
            },
            {
                "WebCore::RTCDataChannelState"_s,
                "state"_s
            },
        } },
#endif // ENABLE(WEB_RTC)
#if ENABLE(WEB_CODECS)
        { "WebCore::WebCodecsEncodedVideoChunkData"_s, {
            {
                "WebCore::WebCodecsEncodedVideoChunkType"_s,
                "type"_s
            },
            {
                "int64_t"_s,
                "timestamp"_s
            },
            {
                "std::optional<uint64_t>"_s,
                "duration"_s
            },
            {
                "Vector<uint8_t>"_s,
                "buffer"_s
            },
        } },
#endif // ENABLE(WEB_CODECS)
#if ENABLE(WEB_CODECS)
        { "WebCore::WebCodecsEncodedAudioChunkData"_s, {
            {
                "WebCore::WebCodecsEncodedAudioChunkType"_s,
                "type"_s
            },
            {
                "int64_t"_s,
                "timestamp"_s
            },
            {
                "std::optional<uint64_t>"_s,
                "duration"_s
            },
            {
                "Vector<uint8_t>"_s,
                "buffer"_s
            },
        } },
#endif // ENABLE(WEB_CODECS)
        { "WebCore::HTMLModelElementCamera"_s, {
            {
                "double"_s,
                "pitch"_s
            },
            {
                "double"_s,
                "yaw"_s
            },
            {
                "double"_s,
                "scale"_s
            },
        } },
        { "WebCore::NotificationData"_s, {
            {
                "URL"_s,
                "navigateURL"_s
            },
            {
                "String"_s,
                "title"_s
            },
            {
                "String"_s,
                "body"_s
            },
            {
                "String"_s,
                "iconURL"_s
            },
            {
                "String"_s,
                "tag"_s
            },
            {
                "String"_s,
                "language"_s
            },
            {
                "WebCore::NotificationDirection"_s,
                "direction"_s
            },
            {
                "String"_s,
                "originString"_s
            },
            {
                "URL"_s,
                "serviceWorkerRegistrationURL"_s
            },
            {
                "WTF::UUID"_s,
                "notificationID"_s
            },
            {
                "std::optional<WebCore::ScriptExecutionContextIdentifier>"_s,
                "contextIdentifier"_s
            },
            {
                "PAL::SessionID"_s,
                "sourceSession"_s
            },
            {
                "MonotonicTime"_s,
                "creationTime"_s
            },
            {
                "Vector<uint8_t>"_s,
                "data"_s
            },
            {
                "std::optional<bool>"_s,
                "silent"_s
            },
        } },
        { "WebCore::PermissionDescriptor"_s, {
            {
                "WebCore::PermissionName"_s,
                "name"_s
            },
        } },
        { "WebCore::PushSubscriptionData"_s, {
            {
                "Markable<WebCore::PushSubscriptionIdentifier>"_s,
                "identifier"_s
            },
            {
                "String"_s,
                "endpoint"_s
            },
            {
                "std::optional<WebCore::EpochTimeStamp>"_s,
                "expirationTime"_s
            },
            {
                "Vector<uint8_t>"_s,
                "serverVAPIDPublicKey"_s
            },
            {
                "Vector<uint8_t>"_s,
                "clientECDHPublicKey"_s
            },
            {
                "Vector<uint8_t>"_s,
                "sharedAuthenticationSecret"_s
            },
        } },
        { "WebCore::DeprecationReportBody"_s, {
            {
                "String"_s,
                "id()"_s
            },
            {
                "WallTime"_s,
                "anticipatedRemoval()"_s
            },
            {
                "String"_s,
                "message()"_s
            },
            {
                "String"_s,
                "sourceFile()"_s
            },
            {
                "std::optional<unsigned>"_s,
                "lineNumber()"_s
            },
            {
                "std::optional<unsigned>"_s,
                "columnNumber()"_s
            },
        } },
        { "WebCore::Report"_s, {
            {
                "String"_s,
                "type()"_s
            },
            {
                "String"_s,
                "url()"_s
            },
            {
                "RefPtr<WebCore::ReportBody>"_s,
                "body()"_s
            },
        } },
        { "WebCore::TestReportBody"_s, {
            {
                "String"_s,
                "message()"_s
            },
        } },
        { "WebCore::SpeechRecognitionError"_s, {
            {
                "WebCore::SpeechRecognitionErrorType"_s,
                "type"_s
            },
            {
                "String"_s,
                "message"_s
            },
        } },
        { "WebCore::SpeechRecognitionRequestInfo"_s, {
            {
                "WebCore::SpeechRecognitionConnectionClientIdentifier"_s,
                "clientIdentifier"_s
            },
            {
                "String"_s,
                "lang"_s
            },
            {
                "bool"_s,
                "continuous"_s
            },
            {
                "bool"_s,
                "interimResults"_s
            },
            {
                "uint64_t"_s,
                "maxAlternatives"_s
            },
            {
                "WebCore::ClientOrigin"_s,
                "clientOrigin"_s
            },
            {
                "WebCore::FrameIdentifier"_s,
                "mainFrameIdentifier"_s
            },
        } },
        { "WebCore::SpeechRecognitionAlternativeData"_s, {
            {
                "String"_s,
                "transcript"_s
            },
            {
                "double"_s,
                "confidence"_s
            },
        } },
        { "WebCore::SpeechRecognitionResultData"_s, {
            {
                "Vector<WebCore::SpeechRecognitionAlternativeData>"_s,
                "alternatives"_s
            },
            {
                "bool"_s,
                "isFinal"_s
            },
        } },
        { "WebCore::WebLockManagerSnapshot"_s, {
            {
                "Vector<WebCore::WebLockManagerSnapshot::Info>"_s,
                "held"_s
            },
            {
                "Vector<WebCore::WebLockManagerSnapshot::Info>"_s,
                "pending"_s
            },
        } },
        { "WebCore::WebLockManagerSnapshot::Info"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "WebCore::WebLockMode"_s,
                "mode"_s
            },
            {
                "String"_s,
                "clientId"_s
            },
        } },
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticatorResponseBaseData"_s, {
            {
                "RefPtr<JSC::ArrayBuffer>"_s,
                "rawId"_s
            },
            {
                "std::optional<WebCore::AuthenticationExtensionsClientOutputs>"_s,
                "extensionOutputs"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticatorAttestationResponseData"_s, {
            {
                "RefPtr<JSC::ArrayBuffer>"_s,
                "rawId"_s
            },
            {
                "std::optional<WebCore::AuthenticationExtensionsClientOutputs>"_s,
                "extensionOutputs"_s
            },
            {
                "RefPtr<JSC::ArrayBuffer>"_s,
                "clientDataJSON"_s
            },
            {
                "RefPtr<JSC::ArrayBuffer>"_s,
                "attestationObject"_s
            },
            {
                "Vector<WebCore::AuthenticatorTransport>"_s,
                "transports"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticatorAssertionResponseData"_s, {
            {
                "RefPtr<JSC::ArrayBuffer>"_s,
                "rawId"_s
            },
            {
                "std::optional<WebCore::AuthenticationExtensionsClientOutputs>"_s,
                "extensionOutputs"_s
            },
            {
                "RefPtr<JSC::ArrayBuffer>"_s,
                "clientDataJSON"_s
            },
            {
                "RefPtr<JSC::ArrayBuffer>"_s,
                "authenticatorData"_s
            },
            {
                "RefPtr<JSC::ArrayBuffer>"_s,
                "signature"_s
            },
            {
                "RefPtr<JSC::ArrayBuffer>"_s,
                "userHandle"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticatorResponseData"_s, {
            {
                "WebCore::AuthenticatorResponseDataSerializableForm"_s,
                "getSerializableForm()"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs"_s, {
            {
                "String"_s,
                "support"_s
            },
            {
                "std::optional<bool>"_s,
                "read"_s
            },
            {
                "std::optional<WebCore::BufferSource>"_s,
                "write"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticationExtensionsClientInputs::PRFValues"_s, {
            {
                "WebCore::BufferSource"_s,
                "first"_s
            },
            {
                "std::optional<WebCore::BufferSource>"_s,
                "second"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticationExtensionsClientInputs::PRFInputs"_s, {
            {
                "std::optional<WebCore::AuthenticationExtensionsClientInputs::PRFValues>"_s,
                "eval"_s
            },
            {
                "std::optional<Vector<KeyValuePair<String, WebCore::AuthenticationExtensionsClientInputs::PRFValues>>>"_s,
                "evalByCredential"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticationExtensionsClientInputs"_s, {
            {
                "String"_s,
                "appid"_s
            },
            {
                "std::optional<bool>"_s,
                "credProps"_s
            },
            {
                "std::optional<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs>"_s,
                "largeBlob"_s
            },
            {
                "std::optional<WebCore::AuthenticationExtensionsClientInputs::PRFInputs>"_s,
                "prf"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::CredentialPropertiesOutput"_s, {
            {
                "bool"_s,
                "rk"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs"_s, {
            {
                "std::optional<bool>"_s,
                "supported"_s
            },
            {
                "RefPtr<JSC::ArrayBuffer>"_s,
                "blob"_s
            },
            {
                "std::optional<bool>"_s,
                "written"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticationExtensionsClientOutputs::PRFValues"_s, {
            {
                "RefPtr<JSC::ArrayBuffer>"_s,
                "first"_s
            },
            {
                "RefPtr<JSC::ArrayBuffer>"_s,
                "second"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs"_s, {
            {
                "std::optional<bool>"_s,
                "enabled"_s
            },
            {
                "std::optional<WebCore::AuthenticationExtensionsClientOutputs::PRFValues>"_s,
                "results"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticationExtensionsClientOutputs"_s, {
            {
                "std::optional<bool>"_s,
                "appid"_s
            },
            {
                "std::optional<WebCore::CredentialPropertiesOutput>"_s,
                "credProps"_s
            },
            {
                "std::optional<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs>"_s,
                "largeBlob"_s
            },
            {
                "std::optional<WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs>"_s,
                "prf"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::PublicKeyCredentialParameters"_s, {
            {
                "WebCore::PublicKeyCredentialType"_s,
                "type"_s
            },
            {
                "int64_t"_s,
                "alg"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::UnknownCredentialOptions"_s, {
            {
                "String"_s,
                "rpId"_s
            },
            {
                "String"_s,
                "credentialId"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::AllAcceptedCredentialsOptions"_s, {
            {
                "String"_s,
                "rpId"_s
            },
            {
                "String"_s,
                "userId"_s
            },
            {
                "Vector<String>"_s,
                "allAcceptedCredentialIds"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::CurrentUserDetailsOptions"_s, {
            {
                "String"_s,
                "rpId"_s
            },
            {
                "String"_s,
                "userId"_s
            },
            {
                "String"_s,
                "name"_s
            },
            {
                "String"_s,
                "displayName"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticatorSelectionCriteria"_s, {
            {
                "std::optional<WebCore::AuthenticatorAttachment>"_s,
                "authenticatorAttachment"_s
            },
            {
                "std::optional<WebCore::ResidentKeyRequirement>"_s,
                "residentKey"_s
            },
            {
                "bool"_s,
                "requireResidentKey"_s
            },
            {
                "WebCore::UserVerificationRequirement"_s,
                "userVerification"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::PublicKeyCredentialEntity"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "String"_s,
                "icon"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::PublicKeyCredentialRpEntity"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "String"_s,
                "icon"_s
            },
            {
                "String"_s,
                "id"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::PublicKeyCredentialUserEntity"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "String"_s,
                "icon"_s
            },
            {
                "WebCore::BufferSource"_s,
                "id"_s
            },
            {
                "String"_s,
                "displayName"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::PublicKeyCredentialDescriptor"_s, {
            {
                "WebCore::PublicKeyCredentialType"_s,
                "type"_s
            },
            {
                "WebCore::BufferSource"_s,
                "id"_s
            },
            {
                "Vector<WebCore::AuthenticatorTransport>"_s,
                "transports"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
        { "WebCore::PublicKeyCredentialCreationOptions"_s, {
#if ENABLE(WEB_AUTHN)
            {
                "WebCore::PublicKeyCredentialRpEntity"_s,
                "rp"_s
            },
#endif
#if ENABLE(WEB_AUTHN)
            {
                "WebCore::PublicKeyCredentialUserEntity"_s,
                "user"_s
            },
#endif
#if ENABLE(WEB_AUTHN)
            {
                "WebCore::BufferSource"_s,
                "challenge"_s
            },
#endif
#if ENABLE(WEB_AUTHN)
            {
                "Vector<WebCore::PublicKeyCredentialParameters>"_s,
                "pubKeyCredParams"_s
            },
#endif
#if ENABLE(WEB_AUTHN)
            {
                "std::optional<unsigned>"_s,
                "timeout"_s
            },
#endif
#if ENABLE(WEB_AUTHN)
            {
                "Vector<WebCore::PublicKeyCredentialDescriptor>"_s,
                "excludeCredentials"_s
            },
#endif
#if ENABLE(WEB_AUTHN)
            {
                "std::optional<WebCore::AuthenticatorSelectionCriteria>"_s,
                "authenticatorSelection"_s
            },
#endif
#if ENABLE(WEB_AUTHN)
            {
                "WebCore::AttestationConveyancePreference"_s,
                "attestation"_s
            },
#endif
#if ENABLE(WEB_AUTHN)
            {
                "std::optional<WebCore::AuthenticationExtensionsClientInputs>"_s,
                "extensions"_s
            },
#endif
        } },
        { "WebCore::PublicKeyCredentialRequestOptions"_s, {
#if ENABLE(WEB_AUTHN)
            {
                "WebCore::BufferSource"_s,
                "challenge"_s
            },
#endif
#if ENABLE(WEB_AUTHN)
            {
                "std::optional<unsigned>"_s,
                "timeout"_s
            },
#endif
#if ENABLE(WEB_AUTHN)
            {
                "String"_s,
                "rpId"_s
            },
#endif
#if ENABLE(WEB_AUTHN)
            {
                "Vector<WebCore::PublicKeyCredentialDescriptor>"_s,
                "allowCredentials"_s
            },
#endif
#if ENABLE(WEB_AUTHN)
            {
                "WebCore::UserVerificationRequirement"_s,
                "userVerification"_s
            },
#endif
#if ENABLE(WEB_AUTHN)
            {
                "std::optional<WebCore::AuthenticationExtensionsClientInputs>"_s,
                "extensions"_s
            },
#endif
        } },
        { "WebCore::RegistrableDomain"_s, {
            {
                "String"_s,
                "string()"_s
            },
        } },
        { "WebCore::Site"_s, {
            {
                "String"_s,
                "protocol()"_s
            },
            {
                "WebCore::RegistrableDomain"_s,
                "domain()"_s
            },
        } },
        { "WebCore::AudioConfiguration"_s, {
            {
                "String"_s,
                "contentType"_s
            },
            {
                "String"_s,
                "channels"_s
            },
            {
                "std::optional<uint64_t>"_s,
                "bitrate"_s
            },
            {
                "std::optional<uint32_t>"_s,
                "samplerate"_s
            },
            {
                "std::optional<bool>"_s,
                "spatialRendering"_s
            },
        } },
        { "WebCore::Cookie"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "String"_s,
                "value"_s
            },
            {
                "String"_s,
                "domain"_s
            },
            {
                "String"_s,
                "path"_s
            },
            {
                "String"_s,
                "partitionKey"_s
            },
            {
                "double"_s,
                "created"_s
            },
            {
                "std::optional<double>"_s,
                "expires"_s
            },
            {
                "bool"_s,
                "httpOnly"_s
            },
            {
                "bool"_s,
                "secure"_s
            },
            {
                "bool"_s,
                "session"_s
            },
            {
                "String"_s,
                "comment"_s
            },
            {
                "URL"_s,
                "commentURL"_s
            },
            {
                "Vector<uint16_t>"_s,
                "ports"_s
            },
            {
                "WebCore::Cookie::SameSitePolicy"_s,
                "sameSite"_s
            },
        } },
#if ENABLE(VIDEO)
        { "WebCore::VideoFrameMetadata"_s, {
            {
                "double"_s,
                "presentationTime"_s
            },
            {
                "double"_s,
                "expectedDisplayTime"_s
            },
            {
                "unsigned"_s,
                "width"_s
            },
            {
                "unsigned"_s,
                "height"_s
            },
            {
                "double"_s,
                "mediaTime"_s
            },
            {
                "unsigned"_s,
                "presentedFrames"_s
            },
            {
                "std::optional<double>"_s,
                "processingDuration"_s
            },
            {
                "std::optional<double>"_s,
                "captureTime"_s
            },
            {
                "std::optional<double>"_s,
                "receiveTime"_s
            },
            {
                "std::optional<unsigned>"_s,
                "rtpTimestamp"_s
            },
        } },
#endif // ENABLE(VIDEO)
        { "WebCore::NavigationPreloadState"_s, {
            {
                "bool"_s,
                "enabled"_s
            },
            {
                "String"_s,
                "headerValue"_s
            },
        } },
        { "WebCore::PlatformDynamicRangeLimit"_s, {
            {
                "float"_s,
                "m_value"_s
            },
        } },
#if ENABLE(CONTENT_FILTERING)
        { "WebCore::MockContentFilterSettings"_s, {
            {
                "bool"_s,
                "m_enabled"_s
            },
            {
                "WebCore::MockContentFilterSettings::DecisionPoint"_s,
                "m_decisionPoint"_s
            },
            {
                "WebCore::MockContentFilterSettings::Decision"_s,
                "m_decision"_s
            },
            {
                "WebCore::MockContentFilterSettings::Decision"_s,
                "m_unblockRequestDecision"_s
            },
            {
                "String"_s,
                "m_blockedString"_s
            },
            {
                "String"_s,
                "m_modifiedRequestURL"_s
            },
        } },
#endif // ENABLE(CONTENT_FILTERING)
        { "WebCore::LoginStatus"_s, {
            {
                "WebCore::RegistrableDomain"_s,
                "domain()"_s
            },
            {
                "String"_s,
                "username()"_s
            },
            {
                "WebCore::LoginStatus::CredentialTokenType"_s,
                "tokenType()"_s
            },
            {
                "WebCore::LoginStatus::AuthenticationType"_s,
                "authType()"_s
            },
            {
                "WallTime"_s,
                "loggedInTime()"_s
            },
            {
                "Seconds"_s,
                "timeToLive()"_s
            },
        } },
        { "WebCore::ExceptionDetails"_s, {
            {
                "String"_s,
                "message"_s
            },
            {
                "int"_s,
                "lineNumber"_s
            },
            {
                "int"_s,
                "columnNumber"_s
            },
            {
                "WebCore::ExceptionDetails::Type"_s,
                "type"_s
            },
            {
                "String"_s,
                "sourceURL"_s
            },
        } },
        { "WebCore::FloatBoxExtent"_s, {
            {
                "float"_s,
                "top()"_s
            },
            {
                "float"_s,
                "right()"_s
            },
            {
                "float"_s,
                "bottom()"_s
            },
            {
                "float"_s,
                "left()"_s
            },
        } },
        { "WebCore::RectEdges<bool>"_s, {
            {
                "bool"_s,
                "top()"_s
            },
            {
                "bool"_s,
                "right()"_s
            },
            {
                "bool"_s,
                "bottom()"_s
            },
            {
                "bool"_s,
                "left()"_s
            },
        } },
        { "WebCore::RectEdges<WebCore::Color>"_s, {
            {
                "WebCore::Color"_s,
                "top()"_s
            },
            {
                "WebCore::Color"_s,
                "right()"_s
            },
            {
                "WebCore::Color"_s,
                "bottom()"_s
            },
            {
                "WebCore::Color"_s,
                "left()"_s
            },
        } },
        { "WebCore::RectEdges<WebCore::RubberBandingBehavior>"_s, {
            {
                "WebCore::RubberBandingBehavior"_s,
                "top()"_s
            },
            {
                "WebCore::RubberBandingBehavior"_s,
                "right()"_s
            },
            {
                "WebCore::RubberBandingBehavior"_s,
                "bottom()"_s
            },
            {
                "WebCore::RubberBandingBehavior"_s,
                "left()"_s
            },
        } },
        { "WebCore::Path"_s, {
            {
                "Vector<WebCore::PathSegment>"_s,
                "segments()"_s
            },
        } },
#if ENABLE(META_VIEWPORT)
        { "WebCore::ViewportArguments"_s, {
            {
                "WebCore::ViewportArguments::Type"_s,
                "type"_s
            },
            {
                "float"_s,
                "width"_s
            },
            {
                "float"_s,
                "height"_s
            },
            {
                "float"_s,
                "zoom"_s
            },
            {
                "float"_s,
                "minZoom"_s
            },
            {
                "float"_s,
                "maxZoom"_s
            },
            {
                "float"_s,
                "userZoom"_s
            },
            {
                "float"_s,
                "orientation"_s
            },
            {
                "float"_s,
                "shrinkToFit"_s
            },
            {
                "WebCore::ViewportFit"_s,
                "viewportFit"_s
            },
            {
                "bool"_s,
                "widthWasExplicit"_s
            },
            {
                "WebCore::InteractiveWidget"_s,
                "interactiveWidget"_s
            },
        } },
#endif // ENABLE(META_VIEWPORT)
        { "WebCore::HTTPHeaderMap::CommonHeader"_s, {
            {
                "WebCore::HTTPHeaderName"_s,
                "key"_s
            },
            {
                "String"_s,
                "value"_s
            },
        } },
        { "WebCore::HTTPHeaderMap::UncommonHeader"_s, {
            {
                "String"_s,
                "key"_s
            },
            {
                "String"_s,
                "value"_s
            },
        } },
        { "WebCore::HTTPHeaderMap"_s, {
            {
                "Vector<WebCore::HTTPHeaderMap::CommonHeader, 0, CrashOnOverflow, 6>"_s,
                "commonHeaders()"_s
            },
            {
                "Vector<WebCore::HTTPHeaderMap::UncommonHeader, 0, CrashOnOverflow, 0>"_s,
                "uncommonHeaders()"_s
            },
        } },
        { "WebCore::ElementContext"_s, {
            {
                "WebCore::FloatRect"_s,
                "boundingRect"_s
            },
            {
                "Markable<WebCore::PageIdentifier>"_s,
                "webPageIdentifier"_s
            },
            {
                "Markable<WebCore::ScriptExecutionContextIdentifier>"_s,
                "documentIdentifier"_s
            },
            {
                "Markable<WebCore::NodeIdentifier>"_s,
                "nodeIdentifier"_s
            },
        } },
        { "WebCore::ElementAnimationContext"_s, {
            {
                "WebCore::ElementContext"_s,
                "element"_s
            },
            {
                "bool"_s,
                "isAnimating"_s
            },
        } },
        { "WebCore::SystemPreviewInfo"_s, {
            {
                "WebCore::ElementContext"_s,
                "element"_s
            },
            {
                "WebCore::IntRect"_s,
                "previewRect"_s
            },
            {
                "bool"_s,
                "isPreview"_s
            },
        } },
        { "WebCore::ResourceRequest::RequestData"_s, {
            {
                "URL"_s,
                "m_url"_s
            },
            {
                "URL"_s,
                "m_firstPartyForCookies"_s
            },
            {
                "double"_s,
                "m_timeoutInterval"_s
            },
            {
                "String"_s,
                "m_httpMethod"_s
            },
            {
                "WebCore::HTTPHeaderMap"_s,
                "m_httpHeaderFields"_s
            },
            {
                "Vector<String>"_s,
                "m_responseContentDispositionEncodingFallbackArray"_s
            },
            {
                "WebCore::ResourceRequestCachePolicy"_s,
                "m_cachePolicy"_s
            },
            {
                "WebCore::ResourceRequestBase::SameSiteDisposition"_s,
                "m_sameSiteDisposition"_s
            },
            {
                "WebCore::ResourceLoadPriority"_s,
                "m_priority"_s
            },
            {
                "WebCore::ResourceRequestRequester"_s,
                "m_requester"_s
            },
            {
                "bool"_s,
                "m_allowCookies"_s
            },
            {
                "bool"_s,
                "m_isTopSite"_s
            },
            {
                "bool"_s,
                "m_isAppInitiated"_s
            },
            {
                "bool"_s,
                "m_privacyProxyFailClosedForUnreachableNonMainHosts"_s
            },
            {
                "bool"_s,
                "m_useAdvancedPrivacyProtections"_s
            },
            {
                "bool"_s,
                "m_didFilterLinkDecoration"_s
            },
            {
                "bool"_s,
                "m_isPrivateTokenUsageByThirdPartyAllowed"_s
            },
            {
                "bool"_s,
                "m_wasSchemeOptimisticallyUpgraded"_s
            },
        } },
#if USE(SOUP)
        { "WebCore::ResourceRequestPlatformData"_s, {
            {
                "WebCore::ResourceRequest::RequestData"_s,
                "requestData"_s
            },
            {
                "bool"_s,
                "acceptEncoding"_s
            },
            {
                "uint16_t"_s,
                "redirectCount"_s
            },
        } },
#endif // USE(SOUP)
#if PLATFORM(COCOA)
        { "WebCore::ResourceRequest"_s, {
            {
                "Variant<WebCore::ResourceRequest::RequestData, WebCore::ResourceRequestPlatformData>"_s,
                "getRequestDataToSerialize()"_s
            },
            {
                "String"_s,
                "cachePartition()"_s
            },
            {
                "bool"_s,
                "hiddenFromInspector()"_s
            },
        } },
#endif // PLATFORM(COCOA)
#if USE(CURL)
        { "WebCore::ResourceRequest"_s, {
            {
                "WebCore::ResourceRequest::RequestData"_s,
                "getRequestDataToSerialize()"_s
            },
        } },
#endif // USE(CURL)
#if !USE(CURL) && !PLATFORM(COCOA)
        { "WebCore::ResourceRequest"_s, {
            {
                "Variant<WebCore::ResourceRequest::RequestData, WebCore::ResourceRequestPlatformData>"_s,
                "getRequestDataToSerialize()"_s
            },
        } },
#endif // !USE(CURL) && !PLATFORM(COCOA)
        { "WebCore::ResourceError::IPCData"_s, {
            {
                "WebCore::ResourceErrorBaseType"_s,
                "type"_s
            },
#if PLATFORM(COCOA)
            {
                "RetainPtr<NSError>"_s,
                "nsError"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "isSanitized"_s
            },
#endif
#if !PLATFORM(COCOA)
            {
                "String"_s,
                "domain"_s
            },
#endif
#if !PLATFORM(COCOA)
            {
                "int"_s,
                "errorCode"_s
            },
#endif
#if !PLATFORM(COCOA)
            {
                "URL"_s,
                "failingURL"_s
            },
#endif
#if !PLATFORM(COCOA)
            {
                "String"_s,
                "localizedDescription"_s
            },
#endif
#if !PLATFORM(COCOA)
            {
                "WebCore::ResourceError::IsSanitized"_s,
                "isSanitized"_s
            },
#endif
#if USE(SOUP)
            {
                "WebCore::CertificateInfo"_s,
                "certificateInfo"_s
            },
#endif
        } },
        { "WebCore::ResourceError"_s, {
            {
                "std::optional<WebCore::ResourceError::IPCData>"_s,
                "ipcData()"_s
            },
        } },
#if (!(USE(CG))) && (!(USE(SKIA)))
        { "WebCore::PlatformColorSpace"_s, {
            {
                "WebCore::PlatformColorSpace::Name"_s,
                "get()"_s
            },
        } },
#endif // (!(USE(CG))) && (!(USE(SKIA)))
        { "WebCore::DestinationColorSpace"_s, {
            {
                "WebCore::PlatformColorSpace"_s,
                "serializableColorSpace()"_s
            },
        } },
        { "WebCore::WindowFeatures"_s, {
            {
                "bool"_s,
                "hasAdditionalFeatures"_s
            },
            {
                "std::optional<float>"_s,
                "x"_s
            },
            {
                "std::optional<float>"_s,
                "y"_s
            },
            {
                "std::optional<float>"_s,
                "width"_s
            },
            {
                "std::optional<float>"_s,
                "height"_s
            },
            {
                "std::optional<bool>"_s,
                "popup"_s
            },
            {
                "std::optional<bool>"_s,
                "menuBarVisible"_s
            },
            {
                "std::optional<bool>"_s,
                "statusBarVisible"_s
            },
            {
                "std::optional<bool>"_s,
                "toolBarVisible"_s
            },
            {
                "std::optional<bool>"_s,
                "locationBarVisible"_s
            },
            {
                "std::optional<bool>"_s,
                "scrollbarsVisible"_s
            },
            {
                "std::optional<bool>"_s,
                "resizable"_s
            },
#if PLATFORM(GTK)
            {
                "WebCore::FloatRect"_s,
                "oldWindowRect"_s
            },
#endif
            {
                "std::optional<bool>"_s,
                "fullscreen"_s
            },
            {
                "std::optional<bool>"_s,
                "dialog"_s
            },
            {
                "std::optional<bool>"_s,
                "noopener"_s
            },
        } },
        { "WebCore::CompositionUnderline"_s, {
            {
                "unsigned"_s,
                "startOffset"_s
            },
            {
                "unsigned"_s,
                "endOffset"_s
            },
            {
                "WebCore::CompositionUnderlineColor"_s,
                "compositionUnderlineColor"_s
            },
            {
                "WebCore::Color"_s,
                "color"_s
            },
            {
                "bool"_s,
                "thick"_s
            },
        } },
#if PLATFORM(COCOA) && ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "WebCore::GraphicsContextGLExternalImageSourceIOSurfaceHandle"_s, {
            {
                "MachSendRight"_s,
                "handle"_s
            },
        } },
#endif // PLATFORM(COCOA) && ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#if PLATFORM(COCOA) && ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "WebCore::GraphicsContextGLExternalImageSourceMTLSharedTextureHandle"_s, {
            {
                "MachSendRight"_s,
                "handle"_s
            },
        } },
#endif // PLATFORM(COCOA) && ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#if ENABLE(ATTACHMENT_ELEMENT)
        { "WebCore::SerializedAttachmentData"_s, {
            {
                "String"_s,
                "identifier"_s
            },
            {
                "String"_s,
                "mimeType"_s
            },
            {
                "Ref<WebCore::SharedBuffer>"_s,
                "data"_s
            },
        } },
#endif // ENABLE(ATTACHMENT_ELEMENT)
        { "WebCore::FileChooserSettings"_s, {
            {
                "bool"_s,
                "allowsDirectories"_s
            },
            {
                "bool"_s,
                "allowsMultipleFiles"_s
            },
            {
                "Vector<String>"_s,
                "acceptMIMETypes"_s
            },
            {
                "Vector<String>"_s,
                "acceptFileExtensions"_s
            },
            {
                "Vector<String>"_s,
                "selectedFiles"_s
            },
#if ENABLE(MEDIA_CAPTURE)
            {
                "WebCore::MediaCaptureType"_s,
                "mediaCaptureType"_s
            },
#endif
        } },
        { "WebCore::GrammarDetail"_s, {
            {
                "WebCore::CharacterRange"_s,
                "range"_s
            },
            {
                "Vector<String>"_s,
                "guesses"_s
            },
            {
                "String"_s,
                "userDescription"_s
            },
        } },
        { "WebCore::TextCheckingResult"_s, {
            {
                "OptionSet<WebCore::TextCheckingType>"_s,
                "type"_s
            },
            {
                "WebCore::CharacterRange"_s,
                "range"_s
            },
            {
                "Vector<WebCore::GrammarDetail>"_s,
                "details"_s
            },
            {
                "String"_s,
                "replacement"_s
            },
        } },
        { "WebCore::TextCheckingRequestData"_s, {
            {
                "std::optional<WebCore::TextCheckingRequestIdentifier>"_s,
                "identifier()"_s
            },
            {
                "String"_s,
                "text()"_s
            },
            {
                "OptionSet<WebCore::TextCheckingType>"_s,
                "checkingTypes()"_s
            },
            {
                "WebCore::TextCheckingProcessType"_s,
                "processType()"_s
            },
        } },
        { "WebCore::LayoutRect"_s, {
            {
                "WebCore::LayoutPoint"_s,
                "m_location"_s
            },
            {
                "WebCore::LayoutSize"_s,
                "m_size"_s
            },
        } },
        { "WebCore::ScreenDataOverrides"_s, {
            {
                "double"_s,
                "width"_s
            },
            {
                "double"_s,
                "height"_s
            },
            {
                "double"_s,
                "scale"_s
            },
        } },
        { "WebCore::BlobPart"_s, {
            {
                "Variant<Vector<uint8_t>, Ref<WebCore::SharedBuffer>, URL>"_s,
                "m_dataOrURL"_s
            },
        } },
        { "WebCore::PackedColor::RGBA"_s, {
            {
                "uint32_t"_s,
                "value"_s
            },
        } },
        { "WebCore::OutOfLineColorDataForIPC"_s, {
            {
                "WebCore::ColorSpace"_s,
                "colorSpace"_s
            },
            {
                "float"_s,
                "c1"_s
            },
            {
                "float"_s,
                "c2"_s
            },
            {
                "float"_s,
                "c3"_s
            },
            {
                "float"_s,
                "alpha"_s
            },
        } },
        { "WebCore::ColorDataForIPC"_s, {
            {
                "bool"_s,
                "isSemantic"_s
            },
            {
                "bool"_s,
                "usesFunctionSerialization"_s
            },
            {
                "Variant<WebCore::PackedColor::RGBA, WebCore::OutOfLineColorDataForIPC>"_s,
                "data"_s
            },
        } },
        { "WebCore::Color"_s, {
            {
                "std::optional<WebCore::ColorDataForIPC>"_s,
                "data()"_s
            },
        } },
        { "WebCore::MediaCapabilitiesInfo"_s, {
            {
                "bool"_s,
                "supported"_s
            },
            {
                "bool"_s,
                "smooth"_s
            },
            {
                "bool"_s,
                "powerEfficient"_s
            },
        } },
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MediaStreamRequest"_s, {
            {
                "WebCore::MediaStreamRequest::Type"_s,
                "type"_s
            },
            {
                "WebCore::MediaConstraints"_s,
                "audioConstraints"_s
            },
            {
                "WebCore::MediaConstraints"_s,
                "videoConstraints"_s
            },
            {
                "bool"_s,
                "isUserGesturePriviledged"_s
            },
            {
                "Markable<WebCore::PageIdentifier>"_s,
                "pageIdentifier"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MediaTrackConstraintSetMap"_s, {
            {
                "std::optional<WebCore::IntConstraint>"_s,
                "m_width"_s
            },
            {
                "std::optional<WebCore::IntConstraint>"_s,
                "m_height"_s
            },
            {
                "std::optional<WebCore::IntConstraint>"_s,
                "m_sampleRate"_s
            },
            {
                "std::optional<WebCore::IntConstraint>"_s,
                "m_sampleSize"_s
            },
            {
                "std::optional<WebCore::DoubleConstraint>"_s,
                "m_aspectRatio"_s
            },
            {
                "std::optional<WebCore::DoubleConstraint>"_s,
                "m_frameRate"_s
            },
            {
                "std::optional<WebCore::DoubleConstraint>"_s,
                "m_volume"_s
            },
            {
                "std::optional<WebCore::BooleanConstraint>"_s,
                "m_echoCancellation"_s
            },
            {
                "std::optional<WebCore::BooleanConstraint>"_s,
                "m_displaySurface"_s
            },
            {
                "std::optional<WebCore::BooleanConstraint>"_s,
                "m_logicalSurface"_s
            },
            {
                "std::optional<WebCore::StringConstraint>"_s,
                "m_facingMode"_s
            },
            {
                "std::optional<WebCore::StringConstraint>"_s,
                "m_deviceId"_s
            },
            {
                "std::optional<WebCore::StringConstraint>"_s,
                "m_groupId"_s
            },
            {
                "std::optional<WebCore::StringConstraint>"_s,
                "m_whiteBalanceMode"_s
            },
            {
                "std::optional<WebCore::DoubleConstraint>"_s,
                "m_zoom"_s
            },
            {
                "std::optional<WebCore::BooleanConstraint>"_s,
                "m_torch"_s
            },
            {
                "std::optional<WebCore::BooleanConstraint>"_s,
                "m_backgroundBlur"_s
            },
            {
                "std::optional<WebCore::BooleanConstraint>"_s,
                "m_powerEfficient"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ! ENABLE(MEDIA_STREAM)
        { "WebCore::MediaStreamRequest"_s, {
            {
                "WebCore::MediaStreamRequest::Type"_s,
                "type"_s
            },
        } },
#endif // ! ENABLE(MEDIA_STREAM)
        { "WebCore::MediaCapabilitiesDecodingInfo"_s, {
            {
                "bool"_s,
                "supported"_s
            },
            {
                "bool"_s,
                "smooth"_s
            },
            {
                "bool"_s,
                "powerEfficient"_s
            },
            {
                "WebCore::MediaDecodingConfiguration"_s,
                "configuration"_s
            },
        } },
        { "WebCore::MediaCapabilitiesEncodingInfo"_s, {
            {
                "bool"_s,
                "supported"_s
            },
            {
                "bool"_s,
                "smooth"_s
            },
            {
                "bool"_s,
                "powerEfficient"_s
            },
            {
                "WebCore::MediaEncodingConfiguration"_s,
                "configuration"_s
            },
        } },
        { "WebCore::FormDataElement"_s, {
            {
                "Variant<Vector<uint8_t>, WebCore::FormDataElement::EncodedFileData, WebCore::FormDataElement::EncodedBlobData>"_s,
                "data"_s
            },
        } },
        { "WebCore::FormDataElement::EncodedFileData"_s, {
            {
                "String"_s,
                "filename"_s
            },
            {
                "int64_t"_s,
                "fileStart"_s
            },
            {
                "int64_t"_s,
                "fileLength"_s
            },
            {
                "std::optional<WallTime>"_s,
                "expectedFileModificationTime"_s
            },
        } },
        { "WebCore::FormDataElement::EncodedBlobData"_s, {
            {
                "URL"_s,
                "url"_s
            },
        } },
        { "WebCore::NetworkTransactionInformation"_s, {
            {
                "WebCore::NetworkTransactionInformation::Type"_s,
                "type"_s
            },
            {
                "WebCore::ResourceRequest"_s,
                "request"_s
            },
            {
                "WebCore::ResourceResponse"_s,
                "response"_s
            },
            {
                "WebCore::NetworkLoadMetrics"_s,
                "metrics"_s
            },
        } },
        { "WebCore::ContentType"_s, {
            {
                "String"_s,
                "raw()"_s
            },
            {
                "bool"_s,
                "typeWasInferredFromExtension()"_s
            },
        } },
        { "WebCore::DateTimeChooserParameters"_s, {
            {
                "AtomString"_s,
                "type"_s
            },
            {
                "WebCore::IntRect"_s,
                "anchorRectInRootView"_s
            },
            {
                "AtomString"_s,
                "locale"_s
            },
            {
                "String"_s,
                "currentValue"_s
            },
            {
                "Vector<String>"_s,
                "suggestionValues"_s
            },
            {
                "Vector<String>"_s,
                "localizedSuggestionValues"_s
            },
            {
                "Vector<String>"_s,
                "suggestionLabels"_s
            },
            {
                "double"_s,
                "minimum"_s
            },
            {
                "double"_s,
                "maximum"_s
            },
            {
                "double"_s,
                "step"_s
            },
            {
                "double"_s,
                "stepBase"_s
            },
            {
                "bool"_s,
                "required"_s
            },
            {
                "bool"_s,
                "isAnchorElementRTL"_s
            },
            {
                "bool"_s,
                "useDarkAppearance"_s
            },
            {
                "bool"_s,
                "hasSecondField"_s
            },
            {
                "bool"_s,
                "hasMillisecondField"_s
            },
        } },
        { "WebCore::ScreenData"_s, {
            {
                "WebCore::FloatRect"_s,
                "screenAvailableRect"_s
            },
            {
                "WebCore::FloatRect"_s,
                "screenRect"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "colorSpace"_s
            },
            {
                "int"_s,
                "screenDepth"_s
            },
            {
                "int"_s,
                "screenDepthPerComponent"_s
            },
            {
                "bool"_s,
                "screenSupportsExtendedColor"_s
            },
            {
                "bool"_s,
                "screenHasInvertedColors"_s
            },
            {
                "bool"_s,
                "screenSupportsHighDynamicRange"_s
            },
#if HAVE(SUPPORT_HDR_DISPLAY)
            {
                "bool"_s,
                "suppressEDR"_s
            },
#endif
#if HAVE(SUPPORT_HDR_DISPLAY)
            {
                "float"_s,
                "currentEDRHeadroom"_s
            },
#endif
#if HAVE(SUPPORT_HDR_DISPLAY)
            {
                "float"_s,
                "maxEDRHeadroom"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "WebCore::FloatSize"_s,
                "screenSize"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "bool"_s,
                "screenIsMonochrome"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "uint32_t"_s,
                "displayMask"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "WebCore::PlatformGPUID"_s,
                "gpuID"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "WebCore::DynamicRangeMode"_s,
                "preferredDynamicRangeMode"_s
            },
#endif
#if PLATFORM(GTK) || (PLATFORM(WPE) && ENABLE(WPE_PLATFORM))
            {
                "WebCore::IntSize"_s,
                "screenSize"_s
            },
#endif
#if PLATFORM(GTK) || (PLATFORM(WPE) && ENABLE(WPE_PLATFORM))
            {
                "double"_s,
                "dpi"_s
            },
#endif
#if PLATFORM(MAC) || PLATFORM(IOS_FAMILY)
            {
                "float"_s,
                "scaleFactor"_s
            },
#endif
        } },
        { "WebCore::ScreenProperties"_s, {
            {
                "WebCore::PlatformDisplayID"_s,
                "primaryDisplayID"_s
            },
            {
                "HashMap<WebCore::PlatformDisplayID, WebCore::ScreenData>"_s,
                "screenDataMap"_s
            },
#if HAVE(SUPPORT_HDR_DISPLAY)
            {
                "OptionSet<WebCore::ContentsFormat>"_s,
                "screenContentsFormatsForTesting"_s
            },
#endif
#if ENABLE(TOUCH_EVENTS) && PLATFORM(GTK)
            {
                "bool"_s,
                "screenHasTouchDevice"_s
            },
#endif
        } },
        { "WebCore::PlatformTimeRanges"_s, {
            {
                "Vector<WebCore::PlatformTimeRanges::Range>"_s,
                "m_ranges"_s
            },
        } },
        { "WebCore::PlatformTimeRanges::Range"_s, {
            {
                "MediaTime"_s,
                "start"_s
            },
            {
                "MediaTime"_s,
                "end"_s
            },
        } },
#if ENABLE(VIDEO)
        { "WebCore::VideoPlaybackQualityMetrics"_s, {
            {
                "uint32_t"_s,
                "totalVideoFrames"_s
            },
            {
                "uint32_t"_s,
                "droppedVideoFrames"_s
            },
            {
                "uint32_t"_s,
                "corruptedVideoFrames"_s
            },
            {
                "double"_s,
                "totalFrameDelay"_s
            },
            {
                "uint32_t"_s,
                "displayCompositedVideoFrames"_s
            },
        } },
#endif // ENABLE(VIDEO)
#if PLATFORM(IOS_FAMILY)
        { "WebCore::SelectionGeometry"_s, {
            {
                "WebCore::FloatQuad"_s,
                "quad()"_s
            },
            {
                "WebCore::SelectionRenderingBehavior"_s,
                "behavior()"_s
            },
            {
                "WebCore::TextDirection"_s,
                "direction()"_s
            },
            {
                "int"_s,
                "minX()"_s
            },
            {
                "int"_s,
                "maxX()"_s
            },
            {
                "int"_s,
                "maxY()"_s
            },
            {
                "int"_s,
                "lineNumber()"_s
            },
            {
                "bool"_s,
                "isLineBreak()"_s
            },
            {
                "bool"_s,
                "isFirstOnLine()"_s
            },
            {
                "bool"_s,
                "isLastOnLine()"_s
            },
            {
                "bool"_s,
                "containsStart()"_s
            },
            {
                "bool"_s,
                "containsEnd()"_s
            },
            {
                "bool"_s,
                "isHorizontal()"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
        { "WebCore::DataListSuggestion"_s, {
            {
                "String"_s,
                "value"_s
            },
            {
                "String"_s,
                "label"_s
            },
        } },
        { "WebCore::DataListSuggestionInformation"_s, {
            {
                "WebCore::DataListSuggestionActivationType"_s,
                "activationType"_s
            },
            {
                "Vector<WebCore::DataListSuggestion>"_s,
                "suggestions"_s
            },
            {
                "WebCore::IntRect"_s,
                "elementRect"_s
            },
        } },
        { "WebCore::ClientOrigin"_s, {
            {
                "WebCore::SecurityOriginData"_s,
                "topOrigin"_s
            },
            {
                "WebCore::SecurityOriginData"_s,
                "clientOrigin"_s
            },
        } },
        { "WebCore::ImageBufferFormat"_s, {
            {
                "WebCore::ImageBufferPixelFormat"_s,
                "pixelFormat"_s
            },
            {
                "WebCore::UseLosslessCompression"_s,
                "useLosslessCompression"_s
            },
        } },
        { "WebCore::PixelBufferFormat"_s, {
            {
                "WebCore::AlphaPremultiplication"_s,
                "alphaFormat"_s
            },
            {
                "WebCore::PixelFormat"_s,
                "pixelFormat"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "colorSpace"_s
            },
        } },
        { "WebCore::TextIndicator"_s, {
            {
                "WebCore::TextIndicatorData"_s,
                "data()"_s
            },
        } },
        { "WebCore::CertificateInfo"_s, {
#if PLATFORM(COCOA)
            {
                "RetainPtr<SecTrustRef>"_s,
                "trust()"_s
            },
#endif
#if USE(CURL)
            {
                "int"_s,
                "verificationError()"_s
            },
#endif
#if USE(CURL)
            {
                "Vector<Vector<uint8_t>>"_s,
                "certificateChain()"_s
            },
#endif
#if USE(SOUP)
            {
                "GRefPtr<GTlsCertificate>"_s,
                "certificate()"_s
            },
#endif
#if USE(SOUP)
            {
                "GTlsCertificateFlags"_s,
                "tlsErrors()"_s
            },
#endif
        } },
        { "WebCore::PasteboardCustomData::Entry"_s, {
            {
                "String"_s,
                "type"_s
            },
            {
                "String"_s,
                "customData"_s
            },
            {
                "Variant<String, Ref<WebCore::SharedBuffer>>"_s,
                "platformData"_s
            },
        } },
        { "WebCore::PasteboardCustomData"_s, {
            {
                "String"_s,
                "origin()"_s
            },
            {
                "Vector<WebCore::PasteboardCustomData::Entry>"_s,
                "data()"_s
            },
        } },
        { "WebCore::SharedMemoryHandle"_s, {
#if USE(UNIX_DOMAIN_SOCKETS)
            {
                "UnixFileDescriptor"_s,
                "m_handle"_s
            },
#endif
#if OS(DARWIN)
            {
                "MachSendRight"_s,
                "m_handle"_s
            },
#endif
#if OS(WINDOWS)
            {
                "Win32Handle"_s,
                "m_handle"_s
            },
#endif
            {
                "uint64_t"_s,
                "m_size"_s
            },
        } },
        { "WebCore::DatabaseDetails"_s, {
            {
                "String"_s,
                "name()"_s
            },
            {
                "String"_s,
                "displayName()"_s
            },
            {
                "uint64_t"_s,
                "expectedUsage()"_s
            },
            {
                "uint64_t"_s,
                "currentUsage()"_s
            },
            {
                "std::optional<WallTime>"_s,
                "creationTime()"_s
            },
            {
                "std::optional<WallTime>"_s,
                "modificationTime()"_s
            },
        } },
        { "WebCore::TextIndicatorData"_s, {
            {
                "WebCore::FloatRect"_s,
                "selectionRectInRootViewCoordinates"_s
            },
            {
                "WebCore::FloatRect"_s,
                "textBoundingRectInRootViewCoordinates"_s
            },
            {
                "WebCore::FloatRect"_s,
                "contentImageWithoutSelectionRectInRootViewCoordinates"_s
            },
            {
                "Vector<WebCore::FloatRect>"_s,
                "textRectsInBoundingRectCoordinates"_s
            },
            {
                "float"_s,
                "contentImageScaleFactor"_s
            },
            {
                "RefPtr<WebCore::Image>"_s,
                "contentImageWithHighlight"_s
            },
            {
                "RefPtr<WebCore::Image>"_s,
                "contentImageWithoutSelection"_s
            },
            {
                "RefPtr<WebCore::Image>"_s,
                "contentImage"_s
            },
            {
                "WebCore::Color"_s,
                "estimatedBackgroundColor"_s
            },
            {
                "WebCore::TextIndicatorPresentationTransition"_s,
                "presentationTransition"_s
            },
            {
                "OptionSet<WebCore::TextIndicatorOption>"_s,
                "options"_s
            },
            {
                "std::optional<WebCore::PlatformLayerIdentifier>"_s,
                "enclosingGraphicsLayerID"_s
            },
        } },
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MediaConstraints"_s, {
            {
                "WebCore::MediaTrackConstraintSetMap"_s,
                "mandatoryConstraints"_s
            },
            {
                "Vector<WebCore::MediaTrackConstraintSetMap>"_s,
                "advancedConstraints"_s
            },
            {
                "bool"_s,
                "isValid"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
        { "WebCore::PromisedAttachmentInfo"_s, {
#if ENABLE(ATTACHMENT_ELEMENT)
            {
                "String"_s,
                "attachmentIdentifier"_s
            },
#endif
            {
                "Vector<std::pair<String, RefPtr<WebCore::SharedBuffer>>>"_s,
                "additionalTypesAndData"_s
            },
        } },
        { "WebCore::RecentSearch"_s, {
            {
                "String"_s,
                "string"_s
            },
            {
                "WallTime"_s,
                "time"_s
            },
        } },
        { "WebCore::EventTrackingRegions"_s, {
            {
                "WebCore::Region"_s,
                "asynchronousDispatchRegion"_s
            },
            {
                "HashMap<WebCore::EventTrackingRegions::EventType, WebCore::Region, WTF::IntHash<WebCore::EventTrackingRegions::EventType>, WTF::StrongEnumHashTraits<WebCore::EventTrackingRegions::EventType>>"_s,
                "eventSpecificSynchronousDispatchRegions"_s
            },
        } },
        { "WebCore::TextManipulationItem"_s, {
            {
                "Markable<WebCore::FrameIdentifier>"_s,
                "frameID"_s
            },
            {
                "bool"_s,
                "isSubframe"_s
            },
            {
                "bool"_s,
                "isCrossSiteSubframe"_s
            },
            {
                "Markable<WebCore::TextManipulationItemIdentifier>"_s,
                "identifier"_s
            },
            {
                "Vector<WebCore::TextManipulationToken>"_s,
                "tokens"_s
            },
        } },
        { "WebCore::TextManipulationToken"_s, {
            {
                "WebCore::TextManipulationTokenIdentifier"_s,
                "identifier"_s
            },
            {
                "String"_s,
                "content"_s
            },
            {
                "std::optional<WebCore::TextManipulationTokenInfo>"_s,
                "info"_s
            },
            {
                "bool"_s,
                "isExcluded"_s
            },
        } },
        { "WebCore::TextManipulationTokenInfo"_s, {
            {
                "String"_s,
                "tagName"_s
            },
            {
                "String"_s,
                "roleAttribute"_s
            },
            {
                "URL"_s,
                "documentURL"_s
            },
            {
                "bool"_s,
                "isVisible"_s
            },
        } },
        { "WebCore::VelocityData"_s, {
            {
                "float"_s,
                "horizontalVelocity"_s
            },
            {
                "float"_s,
                "verticalVelocity"_s
            },
            {
                "float"_s,
                "scaleChangeRate"_s
            },
            {
                "MonotonicTime"_s,
                "lastUpdateTime"_s
            },
        } },
        { "WebCore::MimeClassInfo"_s, {
            {
                "AtomString"_s,
                "type"_s
            },
            {
                "String"_s,
                "desc"_s
            },
            {
                "Vector<String>"_s,
                "extensions"_s
            },
        } },
        { "WebCore::AuthenticationChallenge"_s, {
            {
                "WebCore::ProtectionSpace"_s,
                "protectionSpace()"_s
            },
            {
                "WebCore::Credential"_s,
                "proposedCredential()"_s
            },
            {
                "unsigned"_s,
                "previousFailureCount()"_s
            },
            {
                "WebCore::ResourceResponse"_s,
                "failureResponse()"_s
            },
            {
                "WebCore::ResourceError"_s,
                "error()"_s
            },
#if USE(SOUP)
            {
                "uint32_t"_s,
                "tlsPasswordFlags()"_s
            },
#endif
        } },
#if ENABLE(DRAG_SUPPORT)
        { "WebCore::DragData"_s, {
#if PLATFORM(COCOA)
            {
                "String"_s,
                "pasteboardName()"_s
            },
#endif
            {
                "WebCore::IntPoint"_s,
                "clientPosition()"_s
            },
            {
                "WebCore::IntPoint"_s,
                "globalPosition()"_s
            },
#if PLATFORM(COCOA)
            {
                "Vector<String>"_s,
                "fileNames()"_s
            },
#endif
            {
                "OptionSet<WebCore::DragOperation>"_s,
                "draggingSourceOperationMask()"_s
            },
            {
                "OptionSet<WebCore::DragApplicationFlags>"_s,
                "flags()"_s
            },
            {
                "OptionSet<WebCore::DragDestinationAction>"_s,
                "dragDestinationActionMask()"_s
            },
            {
                "std::optional<WebCore::PageIdentifier>"_s,
                "pageID()"_s
            },
        } },
#endif // ENABLE(DRAG_SUPPORT)
        { "WebCore::DictationAlternative"_s, {
            {
                "WebCore::CharacterRange"_s,
                "range"_s
            },
            {
                "WebCore::DictationContext"_s,
                "context"_s
            },
        } },
        { "WebCore::UserStyleSheet"_s, {
            {
                "String"_s,
                "source()"_s
            },
            {
                "URL"_s,
                "url()"_s
            },
            {
                "Vector<String>"_s,
                "allowlist()"_s
            },
            {
                "Vector<String>"_s,
                "blocklist()"_s
            },
            {
                "WebCore::UserContentInjectedFrames"_s,
                "injectedFrames()"_s
            },
            {
                "WebCore::UserContentMatchParentFrame"_s,
                "matchParentFrame()"_s
            },
            {
                "WebCore::UserStyleLevel"_s,
                "level()"_s
            },
            {
                "std::optional<WebCore::PageIdentifier>"_s,
                "pageID()"_s
            },
        } },
        { "WebCore::ScrollableAreaParameters"_s, {
            {
                "WebCore::ScrollElasticity"_s,
                "horizontalScrollElasticity"_s
            },
            {
                "WebCore::ScrollElasticity"_s,
                "verticalScrollElasticity"_s
            },
            {
                "WebCore::ScrollbarMode"_s,
                "horizontalScrollbarMode"_s
            },
            {
                "WebCore::ScrollbarMode"_s,
                "verticalScrollbarMode"_s
            },
            {
                "WebCore::OverscrollBehavior"_s,
                "horizontalOverscrollBehavior"_s
            },
            {
                "WebCore::OverscrollBehavior"_s,
                "verticalOverscrollBehavior"_s
            },
            {
                "bool"_s,
                "allowsHorizontalScrolling"_s
            },
            {
                "bool"_s,
                "allowsVerticalScrolling"_s
            },
            {
                "WebCore::NativeScrollbarVisibility"_s,
                "horizontalNativeScrollbarVisibility"_s
            },
            {
                "WebCore::NativeScrollbarVisibility"_s,
                "verticalNativeScrollbarVisibility"_s
            },
            {
                "WebCore::ScrollbarWidth"_s,
                "scrollbarWidthStyle"_s
            },
        } },
        { "WebCore::RequestedKeyboardScrollData"_s, {
            {
                "WebCore::KeyboardScrollAction"_s,
                "action"_s
            },
            {
                "std::optional<WebCore::KeyboardScroll>"_s,
                "keyboardScroll"_s
            },
        } },
        { "WebCore::ScrollUpdate"_s, {
            {
                "WebCore::ScrollingNodeID"_s,
                "nodeID"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "scrollPosition"_s
            },
            {
                "std::optional<WebCore::FloatPoint>"_s,
                "layoutViewportOrigin"_s
            },
            {
                "WebCore::ScrollUpdateType"_s,
                "updateType"_s
            },
            {
                "WebCore::ScrollingLayerPositionAction"_s,
                "updateLayerPositionAction"_s
            },
        } },
        { "WebCore::AbsolutePositionConstraints"_s, {
            {
                "WebCore::FloatSize"_s,
                "alignmentOffset()"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "layerPositionAtLastLayout()"_s
            },
        } },
        { "WebCore::KeyboardScroll"_s, {
            {
                "WebCore::FloatSize"_s,
                "offset"_s
            },
            {
                "WebCore::FloatSize"_s,
                "maximumVelocity"_s
            },
            {
                "WebCore::FloatSize"_s,
                "force"_s
            },
            {
                "WebCore::ScrollGranularity"_s,
                "granularity"_s
            },
            {
                "WebCore::ScrollDirection"_s,
                "direction"_s
            },
        } },
        { "WebCore::NotificationResources"_s, {
            {
                "RefPtr<WebCore::Image>"_s,
                "icon()"_s
            },
        } },
        { "WebCore::IdentityTransformOperation"_s, {
        } },
        { "WebCore::TranslateTransformOperation"_s, {
            {
                "WebCore::Length"_s,
                "x()"_s
            },
            {
                "WebCore::Length"_s,
                "y()"_s
            },
            {
                "WebCore::Length"_s,
                "z()"_s
            },
            {
                "WebCore::TransformOperationType"_s,
                "type()"_s
            },
        } },
        { "WebCore::RotateTransformOperation"_s, {
            {
                "double"_s,
                "x()"_s
            },
            {
                "double"_s,
                "y()"_s
            },
            {
                "double"_s,
                "z()"_s
            },
            {
                "double"_s,
                "angle()"_s
            },
            {
                "WebCore::TransformOperationType"_s,
                "type()"_s
            },
        } },
        { "WebCore::ScaleTransformOperation"_s, {
            {
                "double"_s,
                "x()"_s
            },
            {
                "double"_s,
                "y()"_s
            },
            {
                "double"_s,
                "z()"_s
            },
            {
                "WebCore::TransformOperationType"_s,
                "type()"_s
            },
        } },
        { "WebCore::SkewTransformOperation"_s, {
            {
                "double"_s,
                "angleX()"_s
            },
            {
                "double"_s,
                "angleY()"_s
            },
            {
                "WebCore::TransformOperationType"_s,
                "type()"_s
            },
        } },
        { "WebCore::PerspectiveTransformOperation"_s, {
            {
                "std::optional<WebCore::Length>"_s,
                "perspective()"_s
            },
        } },
        { "WebCore::MatrixTransformOperation"_s, {
            {
                "WebCore::TransformationMatrix"_s,
                "matrix()"_s
            },
        } },
        { "WebCore::Matrix3DTransformOperation"_s, {
            {
                "WebCore::TransformationMatrix"_s,
                "matrix()"_s
            },
        } },
#if PLATFORM(COCOA)
        { "AudioStreamBasicDescription"_s, {
            {
                "double"_s,
                "mSampleRate"_s
            },
            {
                "UInt32"_s,
                "mFormatID"_s
            },
            {
                "UInt32"_s,
                "mFormatFlags"_s
            },
            {
                "UInt32"_s,
                "mBytesPerPacket"_s
            },
            {
                "UInt32"_s,
                "mFramesPerPacket"_s
            },
            {
                "UInt32"_s,
                "mBytesPerFrame"_s
            },
            {
                "UInt32"_s,
                "mChannelsPerFrame"_s
            },
            {
                "UInt32"_s,
                "mBitsPerChannel"_s
            },
            {
                "UInt32"_s,
                "mReserved"_s
            },
        } },
#endif // PLATFORM(COCOA)
#if PLATFORM(COCOA)
        { "WebCore::CAAudioStreamDescription"_s, {
            {
                "AudioStreamBasicDescription"_s,
                "streamDescription()"_s
            },
        } },
#endif // PLATFORM(COCOA)
        { "WebCore::TransformOperations"_s, {
            {
                "Vector<Ref<WebCore::TransformOperation>>"_s,
                "m_operations"_s
            },
        } },
        { "WebCore::Gradient::LinearData"_s, {
            {
                "WebCore::FloatPoint"_s,
                "point0"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "point1"_s
            },
        } },
        { "WebCore::Gradient::RadialData"_s, {
            {
                "WebCore::FloatPoint"_s,
                "point0"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "point1"_s
            },
            {
                "float"_s,
                "startRadius"_s
            },
            {
                "float"_s,
                "endRadius"_s
            },
            {
                "float"_s,
                "aspectRatio"_s
            },
        } },
        { "WebCore::Gradient::ConicData"_s, {
            {
                "WebCore::FloatPoint"_s,
                "point0"_s
            },
            {
                "float"_s,
                "angleRadians"_s
            },
        } },
        { "WebCore::Gradient"_s, {
            {
                "Variant<WebCore::Gradient::LinearData, WebCore::Gradient::RadialData, WebCore::Gradient::ConicData>"_s,
                "data()"_s
            },
            {
                "WebCore::ColorInterpolationMethod"_s,
                "colorInterpolationMethod()"_s
            },
            {
                "WebCore::GradientSpreadMethod"_s,
                "spreadMethod()"_s
            },
            {
                "WebCore::GradientColorStops"_s,
                "stops()"_s
            },
        } },
        { "WebCore::PatternParameters"_s, {
            {
                "bool"_s,
                "repeatX"_s
            },
            {
                "bool"_s,
                "repeatY"_s
            },
            {
                "WebCore::AffineTransform"_s,
                "patternSpaceTransform"_s
            },
        } },
        { "WebCore::ThreadSafeDataBufferImpl"_s, {
            {
                "Vector<uint8_t>"_s,
                "m_data"_s
            },
        } },
        { "WebCore::ThreadSafeDataBuffer"_s, {
            {
                "RefPtr<WebCore::ThreadSafeDataBufferImpl>"_s,
                "m_impl"_s
            },
        } },
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "WebCore::GraphicsContextGLAttributes"_s, {
            {
                "bool"_s,
                "alpha"_s
            },
            {
                "bool"_s,
                "depth"_s
            },
            {
                "bool"_s,
                "stencil"_s
            },
            {
                "bool"_s,
                "antialias"_s
            },
            {
                "bool"_s,
                "premultipliedAlpha"_s
            },
            {
                "bool"_s,
                "preserveDrawingBuffer"_s
            },
            {
                "WebCore::GraphicsContextGLPowerPreference"_s,
                "powerPreference"_s
            },
            {
                "bool"_s,
                "isWebGL2"_s
            },
#if PLATFORM(MAC)
            {
                "uint64_t"_s,
                "windowGPUID"_s
            },
#endif
#if ENABLE(WEBXR)
            {
                "bool"_s,
                "xrCompatible"_s
            },
#endif
            {
                "WebCore::GraphicsContextGLSimulatedCreationFailure"_s,
                "failContextCreationForTesting"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "WebCore::TimingFunction"_s, {
            { "Variant<"
                "WebCore::LinearTimingFunction"
                ", WebCore::CubicBezierTimingFunction"
                ", WebCore::StepsTimingFunction"
                ", WebCore::SpringTimingFunction"
            ">"_s, "subclasses"_s }
        } },
        { "WebCore::TransformOperation"_s, {
            { "Variant<"
                "WebCore::TranslateTransformOperation"
                ", WebCore::ScaleTransformOperation"
                ", WebCore::RotateTransformOperation"
                ", WebCore::SkewTransformOperation"
                ", WebCore::MatrixTransformOperation"
                ", WebCore::Matrix3DTransformOperation"
                ", WebCore::PerspectiveTransformOperation"
                ", WebCore::IdentityTransformOperation"
            ">"_s, "subclasses"_s }
        } },
        { "WebCore::LengthPoint"_s, {
            {
                "WebCore::Length"_s,
                "x"_s
            },
            {
                "WebCore::Length"_s,
                "y"_s
            },
        } },
        { "WebCore::LengthSize"_s, {
            {
                "WebCore::Length"_s,
                "width"_s
            },
            {
                "WebCore::Length"_s,
                "height"_s
            },
        } },
        { "WebCore::SVGPathByteStream"_s, {
            {
                "Vector<unsigned char>"_s,
                "bytes()"_s
            },
        } },
        { "WebCore::Style::Angle<WebCore::CSS::Nonnegative>"_s, {
            {
                "double"_s,
                "value"_s
            },
        } },
        { "WebCore::Style::Angle<WebCore::CSS::All>"_s, {
            {
                "double"_s,
                "value"_s
            },
        } },
        { "WebCore::Style::AngleAllFloat"_s, {
            {
                "float"_s,
                "value"_s
            },
        } },
        { "WebCore::Style::PercentageNonnegativeFloat"_s, {
            {
                "float"_s,
                "value"_s
            },
        } },
        { "WebCore::Style::PercentageAllFloat"_s, {
            {
                "float"_s,
                "value"_s
            },
        } },
        { "WebCore::Style::LengthNonnegative"_s, {
            {
                "float"_s,
                "value"_s
            },
        } },
        { "WebCore::Style::Length<WebCore::CSS::All>"_s, {
            {
                "float"_s,
                "value"_s
            },
        } },
        { "WebCore::Style::Percentage<WebCore::CSS::Nonnegative>"_s, {
            {
                "double"_s,
                "value"_s
            },
        } },
        { "WebCore::Style::Percentage<WebCore::CSS::All>"_s, {
            {
                "double"_s,
                "value"_s
            },
        } },
        { "WebCore::Style::LengthPercentage<WebCore::CSS::All>"_s, {
            {
                "Variant<WebCore::Style::LengthAll, WebCore::Style::PercentageAllFloat>"_s,
                "ipcData()"_s
            },
        } },
        { "WebCore::Style::LengthPercentage<WebCore::CSS::Nonnegative>"_s, {
            {
                "Variant<WebCore::Style::LengthNonnegative, WebCore::Style::PercentageNonnegativeFloat>"_s,
                "ipcData()"_s
            },
        } },
        { "WebCore::SpaceSeparatedPair<WebCore::Style::LengthPercentageNonnegative>"_s, {
            {
                "std::array<WebCore::Style::LengthPercentageNonnegative, 2>"_s,
                "value"_s
            },
        } },
        { "WebCore::SpaceSeparatedPair<WebCore::Style::LengthPercentageAll>"_s, {
            {
                "std::array<WebCore::Style::LengthPercentageAll, 2>"_s,
                "value"_s
            },
        } },
        { "WebCore::SpaceSeparatedPair<WebCore::Style::CoordinatePair>"_s, {
            {
                "std::array<WebCore::Style::CoordinatePair, 2>"_s,
                "value"_s
            },
        } },
        { "WebCore::SpaceSeparatedSize<WebCore::Style::LengthPercentageNonnegative>"_s, {
            {
                "WebCore::SpaceSeparatedPair<WebCore::Style::LengthPercentageNonnegative>"_s,
                "value"_s
            },
        } },
        { "WebCore::SpaceSeparatedSize<WebCore::Style::LengthPercentageAll>"_s, {
            {
                "WebCore::SpaceSeparatedPair<WebCore::Style::LengthPercentageAll>"_s,
                "value"_s
            },
        } },
        { "WebCore::SpaceSeparatedPoint<WebCore::Style::LengthPercentageNonnegative>"_s, {
            {
                "WebCore::SpaceSeparatedPair<WebCore::Style::LengthPercentageNonnegative>"_s,
                "value"_s
            },
        } },
        { "WebCore::SpaceSeparatedPoint<WebCore::Style::LengthPercentageAll>"_s, {
            {
                "WebCore::SpaceSeparatedPair<WebCore::Style::LengthPercentageAll>"_s,
                "value"_s
            },
        } },
        { "WebCore::MinimallySerializingSpaceSeparatedSize<WebCore::Style::LengthPercentageNonnegative>"_s, {
            {
                "WebCore::SpaceSeparatedPair<WebCore::Style::LengthPercentageNonnegative>"_s,
                "value"_s
            },
        } },
        { "WebCore::MinimallySerializingSpaceSeparatedSize<WebCore::Style::LengthPercentageAll>"_s, {
            {
                "WebCore::SpaceSeparatedPair<WebCore::Style::LengthPercentageAll>"_s,
                "value"_s
            },
        } },
        { "WebCore::CommaSeparatedVector<WebCore::Style::LengthPercentageSpaceSeparatedPointAll>"_s, {
            {
                "Vector<WebCore::Style::LengthPercentageSpaceSeparatedPointAll>"_s,
                "value"_s
            },
        } },
        { "WebCore::CommaSeparatedVector<WebCore::Style::LengthPercentageSpaceSeparatedPointNonnegative>"_s, {
            {
                "Vector<WebCore::Style::LengthPercentageSpaceSeparatedPointNonnegative>"_s,
                "value"_s
            },
        } },
        { "WebCore::MinimallySerializingSpaceSeparatedRectEdges<WebCore::Style::LengthPercentageAll>"_s, {
            {
                "WebCore::Style::LengthPercentageAll"_s,
                "top()"_s
            },
            {
                "WebCore::Style::LengthPercentageAll"_s,
                "right()"_s
            },
            {
                "WebCore::Style::LengthPercentageAll"_s,
                "bottom()"_s
            },
            {
                "WebCore::Style::LengthPercentageAll"_s,
                "left()"_s
            },
        } },
        { "WebCore::CommaSeparatedVector<WebCore::Style::ShapeCommand>"_s, {
            {
                "Vector<WebCore::Style::ShapeCommand>"_s,
                "value"_s
            },
        } },
        { "WebCore::Style::LengthWrapperData"_s, {
            {
                "Variant<WebCore::Style::LengthWrapperData::AutoData, WebCore::Style::LengthWrapperData::NormalData, WebCore::Style::LengthWrapperData::RelativeData, WebCore::Style::LengthWrapperData::PercentData, WebCore::Style::LengthWrapperData::FixedData, WebCore::Style::LengthWrapperData::IntrinsicData, WebCore::Style::LengthWrapperData::MinIntrinsicData, WebCore::Style::LengthWrapperData::MinContentData, WebCore::Style::LengthWrapperData::MaxContentData, WebCore::Style::LengthWrapperData::FillAvailableData, WebCore::Style::LengthWrapperData::FitContentData, WebCore::Style::LengthWrapperData::ContentData, WebCore::Style::LengthWrapperData::UndefinedData>"_s,
                "ipcData()"_s
            },
        } },
        { "WebCore::Style::LengthWrapperData::AutoData"_s, {
        } },
        { "WebCore::Style::LengthWrapperData::NormalData"_s, {
        } },
        { "WebCore::Style::LengthWrapperData::FixedData"_s, {
            {
                "Variant<float, int>"_s,
                "value"_s
            },
            {
                "bool"_s,
                "hasQuirk"_s
            },
        } },
        { "WebCore::Style::LengthWrapperData::RelativeData"_s, {
            {
                "Variant<float, int>"_s,
                "value"_s
            },
        } },
        { "WebCore::Style::LengthWrapperData::PercentData"_s, {
            {
                "Variant<float, int>"_s,
                "value"_s
            },
        } },
        { "WebCore::Style::LengthWrapperData::IntrinsicData"_s, {
        } },
        { "WebCore::Style::LengthWrapperData::MinIntrinsicData"_s, {
        } },
        { "WebCore::Style::LengthWrapperData::MinContentData"_s, {
        } },
        { "WebCore::Style::LengthWrapperData::MaxContentData"_s, {
        } },
        { "WebCore::Style::LengthWrapperData::FillAvailableData"_s, {
        } },
        { "WebCore::Style::LengthWrapperData::FitContentData"_s, {
        } },
        { "WebCore::Style::LengthWrapperData::ContentData"_s, {
        } },
        { "WebCore::Style::LengthWrapperData::UndefinedData"_s, {
        } },
        { "WebCore::Style::PositionX"_s, {
            {
                "Variant<WebCore::Style::LengthWrapperData::AutoData, WebCore::Style::LengthWrapperData::NormalData, WebCore::Style::LengthWrapperData::RelativeData, WebCore::Style::LengthWrapperData::PercentData, WebCore::Style::LengthWrapperData::FixedData, WebCore::Style::LengthWrapperData::IntrinsicData, WebCore::Style::LengthWrapperData::MinIntrinsicData, WebCore::Style::LengthWrapperData::MinContentData, WebCore::Style::LengthWrapperData::MaxContentData, WebCore::Style::LengthWrapperData::FillAvailableData, WebCore::Style::LengthWrapperData::FitContentData, WebCore::Style::LengthWrapperData::ContentData, WebCore::Style::LengthWrapperData::UndefinedData>"_s,
                "ipcData()"_s
            },
        } },
        { "WebCore::Style::PositionY"_s, {
            {
                "Variant<WebCore::Style::LengthWrapperData::AutoData, WebCore::Style::LengthWrapperData::NormalData, WebCore::Style::LengthWrapperData::RelativeData, WebCore::Style::LengthWrapperData::PercentData, WebCore::Style::LengthWrapperData::FixedData, WebCore::Style::LengthWrapperData::IntrinsicData, WebCore::Style::LengthWrapperData::MinIntrinsicData, WebCore::Style::LengthWrapperData::MinContentData, WebCore::Style::LengthWrapperData::MaxContentData, WebCore::Style::LengthWrapperData::FillAvailableData, WebCore::Style::LengthWrapperData::FitContentData, WebCore::Style::LengthWrapperData::ContentData, WebCore::Style::LengthWrapperData::UndefinedData>"_s,
                "ipcData()"_s
            },
        } },
        { "WebCore::Style::Position"_s, {
            {
                "WebCore::Style::PositionX"_s,
                "x"_s
            },
            {
                "WebCore::Style::PositionY"_s,
                "y"_s
            },
        } },
        { "WebCore::Style::TwoComponentPositionHorizontal"_s, {
            {
                "WebCore::Style::PositionX"_s,
                "offset"_s
            },
        } },
        { "WebCore::Style::TwoComponentPositionVertical"_s, {
            {
                "WebCore::Style::PositionY"_s,
                "offset"_s
            },
        } },
        { "WebCore::Constant<WebCore::CSSValueClosestCorner>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueClosestSide>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueFarthestCorner>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueFarthestSide>"_s, {
        } },
        { "WebCore::Style::CircleFunction"_s, {
            {
                "WebCore::Style::Circle"_s,
                "parameters"_s
            },
        } },
        { "WebCore::Style::Circle"_s, {
            {
                "WebCore::Style::Circle::RadialSize"_s,
                "radius"_s
            },
            {
                "std::optional<WebCore::Style::Position>"_s,
                "position"_s
            },
        } },
        { "WebCore::SpaceSeparatedPair<WebCore::Style::Ellipse::RadialSize>"_s, {
            {
                "std::array<WebCore::Style::Ellipse::RadialSize, 2>"_s,
                "value"_s
            },
        } },
        { "WebCore::Style::EllipseFunction"_s, {
            {
                "WebCore::Style::Ellipse"_s,
                "parameters"_s
            },
        } },
        { "WebCore::Style::Ellipse"_s, {
            {
                "WebCore::SpaceSeparatedPair<WebCore::Style::Ellipse::RadialSize>"_s,
                "radii"_s
            },
            {
                "std::optional<WebCore::Style::Position>"_s,
                "position"_s
            },
        } },
        { "WebCore::Style::InsetFunction"_s, {
            {
                "WebCore::Style::Inset"_s,
                "parameters"_s
            },
        } },
        { "WebCore::Style::Inset"_s, {
            {
                "WebCore::MinimallySerializingSpaceSeparatedRectEdges<WebCore::Style::LengthPercentageAll>"_s,
                "insets"_s
            },
            {
                "WebCore::Style::BorderRadius"_s,
                "radii"_s
            },
        } },
        { "WebCore::Style::PathFunction"_s, {
            {
                "WebCore::Style::Path"_s,
                "parameters"_s
            },
        } },
        { "WebCore::Style::Path::Data"_s, {
            {
                "WebCore::SVGPathByteStream"_s,
                "byteStream"_s
            },
        } },
        { "WebCore::Style::Path"_s, {
            {
                "std::optional<WebCore::Style::FillRule>"_s,
                "fillRule"_s
            },
            {
                "WebCore::Style::Path::Data"_s,
                "data"_s
            },
            {
                "float"_s,
                "zoom"_s
            },
        } },
        { "WebCore::Style::PolygonFunction"_s, {
            {
                "WebCore::Style::Polygon"_s,
                "parameters"_s
            },
        } },
        { "WebCore::Style::Polygon"_s, {
            {
                "std::optional<WebCore::Style::FillRule>"_s,
                "fillRule"_s
            },
            {
                "WebCore::CommaSeparatedVector<WebCore::Style::LengthPercentageSpaceSeparatedPointAll>"_s,
                "vertices"_s
            },
        } },
        { "WebCore::Constant<WebCore::CSSValueNonzero>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueEvenodd>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueBy>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueTo>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueCcw>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueCw>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueLarge>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueSmall>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueStart>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueEnd>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueOrigin>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueClose>"_s, {
        } },
        { "WebCore::Style::ToPosition"_s, {
            {
                "WebCore::Style::Position"_s,
                "offset"_s
            },
        } },
        { "WebCore::Style::ByCoordinatePair"_s, {
            {
                "WebCore::Style::CoordinatePair"_s,
                "offset"_s
            },
        } },
        { "WebCore::Style::RelativeControlPoint"_s, {
            {
                "WebCore::Style::CoordinatePair"_s,
                "offset"_s
            },
            {
                "std::optional<WebCore::Style::ControlPointAnchor>"_s,
                "anchor"_s
            },
        } },
        { "WebCore::Style::AbsoluteControlPoint"_s, {
            {
                "WebCore::Style::Position"_s,
                "offset"_s
            },
            {
                "std::optional<WebCore::Style::ControlPointAnchor>"_s,
                "anchor"_s
            },
        } },
        { "WebCore::Style::ShapeFunction"_s, {
            {
                "WebCore::Style::Shape"_s,
                "parameters"_s
            },
        } },
        { "WebCore::Style::Shape"_s, {
            {
                "std::optional<WebCore::Style::FillRule>"_s,
                "fillRule"_s
            },
            {
                "WebCore::Style::Position"_s,
                "startingPoint"_s
            },
            {
                "WebCore::CommaSeparatedVector<WebCore::Style::ShapeCommand>"_s,
                "commands"_s
            },
        } },
        { "WebCore::Style::MoveCommand"_s, {
            {
                "Variant<WebCore::Style::ToPosition, WebCore::Style::ByCoordinatePair>"_s,
                "toBy"_s
            },
        } },
        { "WebCore::Style::LineCommand"_s, {
            {
                "Variant<WebCore::Style::ToPosition, WebCore::Style::ByCoordinatePair>"_s,
                "toBy"_s
            },
        } },
        { "WebCore::Style::HLineCommand::To"_s, {
            {
                "WebCore::Style::TwoComponentPositionHorizontal"_s,
                "offset"_s
            },
        } },
        { "WebCore::Style::HLineCommand::By"_s, {
            {
                "WebCore::Style::LengthPercentageAll"_s,
                "offset"_s
            },
        } },
        { "WebCore::Style::HLineCommand"_s, {
            {
                "Variant<WebCore::Style::HLineCommand::To, WebCore::Style::HLineCommand::By>"_s,
                "toBy"_s
            },
        } },
        { "WebCore::Style::VLineCommand::To"_s, {
            {
                "WebCore::Style::TwoComponentPositionVertical"_s,
                "offset"_s
            },
        } },
        { "WebCore::Style::VLineCommand::By"_s, {
            {
                "WebCore::Style::LengthPercentageAll"_s,
                "offset"_s
            },
        } },
        { "WebCore::Style::VLineCommand"_s, {
            {
                "Variant<WebCore::Style::VLineCommand::To, WebCore::Style::VLineCommand::By>"_s,
                "toBy"_s
            },
        } },
        { "WebCore::Style::CurveCommand::To"_s, {
            {
                "WebCore::Style::Position"_s,
                "offset"_s
            },
            {
                "WebCore::Style::AbsoluteControlPoint"_s,
                "controlPoint1"_s
            },
            {
                "std::optional<WebCore::Style::AbsoluteControlPoint>"_s,
                "controlPoint2"_s
            },
        } },
        { "WebCore::Style::CurveCommand::By"_s, {
            {
                "WebCore::Style::CoordinatePair"_s,
                "offset"_s
            },
            {
                "WebCore::Style::RelativeControlPoint"_s,
                "controlPoint1"_s
            },
            {
                "std::optional<WebCore::Style::RelativeControlPoint>"_s,
                "controlPoint2"_s
            },
        } },
        { "WebCore::Style::CurveCommand"_s, {
            {
                "Variant<WebCore::Style::CurveCommand::To, WebCore::Style::CurveCommand::By>"_s,
                "toBy"_s
            },
        } },
        { "WebCore::Style::SmoothCommand::To"_s, {
            {
                "WebCore::Style::Position"_s,
                "offset"_s
            },
            {
                "std::optional<WebCore::Style::AbsoluteControlPoint>"_s,
                "controlPoint"_s
            },
        } },
        { "WebCore::Style::SmoothCommand::By"_s, {
            {
                "WebCore::Style::CoordinatePair"_s,
                "offset"_s
            },
            {
                "std::optional<WebCore::Style::RelativeControlPoint>"_s,
                "controlPoint"_s
            },
        } },
        { "WebCore::Style::SmoothCommand"_s, {
            {
                "Variant<WebCore::Style::SmoothCommand::To, WebCore::Style::SmoothCommand::By>"_s,
                "toBy"_s
            },
        } },
        { "WebCore::Style::ArcCommand"_s, {
            {
                "Variant<WebCore::Style::ToPosition, WebCore::Style::ByCoordinatePair>"_s,
                "toBy"_s
            },
            {
                "WebCore::Style::LengthPercentageMinimallySerializingSpaceSeparatedSizeAll"_s,
                "size"_s
            },
            {
                "Variant<WebCore::CSS::Keyword::Cw, WebCore::CSS::Keyword::Ccw>"_s,
                "arcSweep"_s
            },
            {
                "Variant<WebCore::CSS::Keyword::Large, WebCore::CSS::Keyword::Small>"_s,
                "arcSize"_s
            },
            {
                "WebCore::Style::Angle<WebCore::CSS::All>"_s,
                "rotation"_s
            },
        } },
        { "WebCore::Style::BorderRadius"_s, {
            {
                "WebCore::MinimallySerializingSpaceSeparatedSize<WebCore::Style::LengthPercentageNonnegative>"_s,
                "topLeft()"_s
            },
            {
                "WebCore::MinimallySerializingSpaceSeparatedSize<WebCore::Style::LengthPercentageNonnegative>"_s,
                "topRight()"_s
            },
            {
                "WebCore::MinimallySerializingSpaceSeparatedSize<WebCore::Style::LengthPercentageNonnegative>"_s,
                "bottomRight()"_s
            },
            {
                "WebCore::MinimallySerializingSpaceSeparatedSize<WebCore::Style::LengthPercentageNonnegative>"_s,
                "bottomLeft()"_s
            },
        } },
        { "WebCore::Constant<WebCore::CSSValueSides>"_s, {
        } },
        { "WebCore::Constant<WebCore::CSSValueContain>"_s, {
        } },
        { "WebCore::Style::RayFunction"_s, {
            {
                "WebCore::Style::Ray"_s,
                "parameters"_s
            },
        } },
        { "WebCore::Style::Ray"_s, {
            {
                "WebCore::Style::Angle<WebCore::CSS::All>"_s,
                "angle"_s
            },
            {
                "WebCore::Style::RaySize"_s,
                "size"_s
            },
            {
                "std::optional<WebCore::CSS::Keyword::Contain>"_s,
                "contain"_s
            },
            {
                "std::optional<WebCore::Style::Position>"_s,
                "position"_s
            },
        } },
        { "WebCore::PixelBuffer"_s, {
            { "Variant<"
                "WebCore::ByteArrayPixelBuffer"
            ">"_s, "subclasses"_s }
        } },
        { "WebCore::MotionPathData"_s, {
            {
                "WebCore::FloatRoundedRect"_s,
                "containingBlockBoundingRect"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "offsetFromContainingBlock"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "usedStartingPosition"_s
            },
        } },
        { "WebCore::TransformOperationData"_s, {
            {
                "WebCore::FloatRect"_s,
                "boundingBox"_s
            },
            {
                "std::optional<WebCore::MotionPathData>"_s,
                "motionPathData"_s
            },
            {
                "bool"_s,
                "isSVGRenderer"_s
            },
        } },
        { "WebCore::ReferencePathOperation"_s, {
            {
                "std::optional<WebCore::Path>"_s,
                "path()"_s
            },
        } },
        { "WebCore::ShapePathOperation"_s, {
            {
                "WebCore::Style::BasicShape"_s,
                "shape()"_s
            },
            {
                "WebCore::CSSBoxType"_s,
                "referenceBox()"_s
            },
        } },
        { "WebCore::BoxPathOperation"_s, {
            {
                "WebCore::CSSBoxType"_s,
                "referenceBox()"_s
            },
        } },
        { "WebCore::RayPathOperation"_s, {
            {
                "WebCore::Style::RayFunction"_s,
                "ray()"_s
            },
        } },
        { "WebCore::PathOperation"_s, {
            { "Variant<"
                "WebCore::ReferencePathOperation"
                ", WebCore::ShapePathOperation"
                ", WebCore::BoxPathOperation"
                ", WebCore::RayPathOperation"
            ">"_s, "subclasses"_s }
        } },
#if ENABLE(ENCRYPTED_MEDIA)
        { "WebCore::CDMKeySystemConfiguration"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "Vector<AtomString>"_s,
                "initDataTypes"_s
            },
            {
                "Vector<WebCore::CDMMediaCapability>"_s,
                "audioCapabilities"_s
            },
            {
                "Vector<WebCore::CDMMediaCapability>"_s,
                "videoCapabilities"_s
            },
            {
                "WebCore::CDMRequirement"_s,
                "distinctiveIdentifier"_s
            },
            {
                "WebCore::CDMRequirement"_s,
                "persistentState"_s
            },
            {
                "Vector<WebCore::CDMSessionType>"_s,
                "sessionTypes"_s
            },
        } },
#endif // ENABLE(ENCRYPTED_MEDIA)
        { "WebCore::MediaConfiguration"_s, {
            {
                "std::optional<WebCore::VideoConfiguration>"_s,
                "video"_s
            },
            {
                "std::optional<WebCore::AudioConfiguration>"_s,
                "audio"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "allowedMediaContainerTypes"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "allowedMediaCodecTypes"_s
            },
        } },
        { "WebCore::MediaEncodingConfiguration"_s, {
            {
                "std::optional<WebCore::VideoConfiguration>"_s,
                "video"_s
            },
            {
                "std::optional<WebCore::AudioConfiguration>"_s,
                "audio"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "allowedMediaContainerTypes"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "allowedMediaCodecTypes"_s
            },
            {
                "WebCore::MediaEncodingType"_s,
                "type"_s
            },
        } },
        { "WebCore::MediaDecodingConfiguration"_s, {
            {
                "std::optional<WebCore::VideoConfiguration>"_s,
                "video"_s
            },
            {
                "std::optional<WebCore::AudioConfiguration>"_s,
                "audio"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "allowedMediaContainerTypes"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "allowedMediaCodecTypes"_s
            },
            {
                "WebCore::MediaDecodingType"_s,
                "type"_s
            },
            {
                "std::optional<WebCore::PageIdentifier>"_s,
                "pageIdentifier"_s
            },
            {
                "bool"_s,
                "canExposeVP9"_s
            },
        } },
        { "WebCore::ResourceResponseBase"_s, {
            {
                "std::optional<WebCore::ResourceResponseData>"_s,
                "getResponseData()"_s
            },
        } },
        { "WebCore::ResourceResponse"_s, {
            {
                "std::optional<WebCore::ResourceResponseData>"_s,
                "getResponseData()"_s
            },
        } },
        { "WebCore::ResourceResponseData"_s, {
            {
                "URL"_s,
                "url"_s
            },
            {
                "String"_s,
                "mimeType"_s
            },
            {
                "long long"_s,
                "expectedContentLength"_s
            },
            {
                "String"_s,
                "textEncodingName"_s
            },
            {
                "short"_s,
                "httpStatusCode"_s
            },
            {
                "String"_s,
                "httpStatusText"_s
            },
            {
                "String"_s,
                "httpVersion"_s
            },
            {
                "WebCore::HTTPHeaderMap"_s,
                "httpHeaderFields"_s
            },
            {
                "std::optional<WebCore::NetworkLoadMetrics>"_s,
                "networkLoadMetrics"_s
            },
            {
                "WebCore::ResourceResponseBase::Source"_s,
                "source"_s
            },
            {
                "WebCore::ResourceResponseBase::Type"_s,
                "type"_s
            },
            {
                "WebCore::ResourceResponseBase::Tainting"_s,
                "tainting"_s
            },
            {
                "bool"_s,
                "isRedirected"_s
            },
            {
                "WebCore::UsedLegacyTLS"_s,
                "usedLegacyTLS"_s
            },
            {
                "WebCore::WasPrivateRelayed"_s,
                "wasPrivateRelayed"_s
            },
            {
                "String"_s,
                "proxyName"_s
            },
            {
                "bool"_s,
                "isRangeRequested"_s
            },
            {
                "std::optional<WebCore::CertificateInfo>"_s,
                "certificateInfo"_s
            },
        } },
#if PLATFORM(COCOA)
        { "WebCore::ArchiveResource"_s, {
            {
                "Ref<WebCore::FragmentedSharedBuffer>"_s,
                "protectedData()"_s
            },
            {
                "URL"_s,
                "url()"_s
            },
            {
                "String"_s,
                "mimeType()"_s
            },
            {
                "String"_s,
                "textEncoding()"_s
            },
            {
                "String"_s,
                "frameName()"_s
            },
            {
                "WebCore::ResourceResponse"_s,
                "response()"_s
            },
            {
                "String"_s,
                "relativeFilePath()"_s
            },
        } },
#endif // PLATFORM(COCOA)
#if PLATFORM(COCOA)
        { "WebCore::LegacyWebArchive"_s, {
            {
                "Ref<WebCore::ArchiveResource>"_s,
                "protectedMainResource()"_s
            },
            {
                "Vector<Ref<WebCore::ArchiveResource>>"_s,
                "subresources()"_s
            },
            {
                "Vector<WebCore::FrameIdentifier>"_s,
                "subframeIdentifiers()"_s
            },
        } },
#endif // PLATFORM(COCOA)
        { "WebCore::FetchOptions"_s, {
            {
                "WebCore::FetchOptionsDestination"_s,
                "destination"_s
            },
            {
                "WebCore::FetchOptionsMode"_s,
                "mode"_s
            },
            {
                "WebCore::FetchOptionsCredentials"_s,
                "credentials"_s
            },
            {
                "WebCore::FetchOptionsCache"_s,
                "cache"_s
            },
            {
                "WebCore::FetchOptionsRedirect"_s,
                "redirect"_s
            },
            {
                "WebCore::ReferrerPolicy"_s,
                "referrerPolicy"_s
            },
            {
                "bool"_s,
                "keepAlive"_s
            },
            {
                "String"_s,
                "integrity"_s
            },
            {
                "Markable<WTF::UUID>"_s,
                "clientIdentifier"_s
            },
            {
                "Markable<WTF::UUID>"_s,
                "resultingClientIdentifier"_s
            },
        } },
        { "WebCore::ControlStyle"_s, {
            {
                "OptionSet<WebCore::ControlStyle::State>"_s,
                "states"_s
            },
            {
                "float"_s,
                "fontSize"_s
            },
            {
                "float"_s,
                "zoomFactor"_s
            },
            {
                "WebCore::Color"_s,
                "accentColor"_s
            },
            {
                "WebCore::Color"_s,
                "textColor"_s
            },
            {
                "WebCore::FloatBoxExtent"_s,
                "borderWidth"_s
            },
        } },
        { "WebCore::ControlPart"_s, {
            { "Variant<"
                "WebCore::ButtonPart"
                ", WebCore::ColorWellPart"
                ", WebCore::InnerSpinButtonPart"
                ", WebCore::MenuListButtonPart"
                ", WebCore::MenuListPart"
                ", WebCore::MeterPart"
                ", WebCore::ProgressBarPart"
                ", WebCore::SearchFieldPart"
                ", WebCore::SearchFieldResultsPart"
                ", WebCore::SearchFieldCancelButtonPart"
                ", WebCore::SliderThumbPart"
                ", WebCore::SliderTrackPart"
                ", WebCore::SwitchThumbPart"
                ", WebCore::SwitchTrackPart"
                ", WebCore::TextAreaPart"
                ", WebCore::TextFieldPart"
                ", WebCore::ToggleButtonPart"
#if ENABLE(APPLE_PAY)
                ", WebCore::ApplePayButtonPart"
#endif
#if ENABLE(SERVICE_CONTROLS)
                ", WebCore::ImageControlsButtonPart"
#endif
            ">"_s, "subclasses"_s }
        } },
        { "WebCore::ButtonPart"_s, {
            {
                "WebCore::StyleAppearance"_s,
                "type()"_s
            },
        } },
        { "WebCore::InnerSpinButtonPart"_s, {
        } },
        { "WebCore::MenuListButtonPart"_s, {
        } },
        { "WebCore::MenuListPart"_s, {
        } },
        { "WebCore::SearchFieldPart"_s, {
        } },
        { "WebCore::SliderThumbPart"_s, {
            {
                "WebCore::StyleAppearance"_s,
                "type()"_s
            },
        } },
        { "WebCore::SearchFieldResultsPart"_s, {
            {
                "WebCore::StyleAppearance"_s,
                "type()"_s
            },
        } },
        { "WebCore::SearchFieldCancelButtonPart"_s, {
        } },
        { "WebCore::TextAreaPart"_s, {
            {
                "WebCore::StyleAppearance"_s,
                "type()"_s
            },
        } },
        { "WebCore::TextFieldPart"_s, {
        } },
        { "WebCore::ToggleButtonPart"_s, {
            {
                "WebCore::StyleAppearance"_s,
                "type()"_s
            },
        } },
#if ENABLE(SERVICE_CONTROLS)
        { "WebCore::ImageControlsButtonPart"_s, {
        } },
#endif // ENABLE(SERVICE_CONTROLS)
        { "WebCore::ColorWellPart"_s, {
        } },
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayButtonPart"_s, {
            {
                "WebCore::ApplePayButtonType"_s,
                "buttonType()"_s
            },
            {
                "WebCore::ApplePayButtonStyle"_s,
                "buttonStyle()"_s
            },
            {
                "String"_s,
                "locale()"_s
            },
        } },
#endif // ENABLE(APPLE_PAY)
        { "WebCore::MeterPart"_s, {
            {
                "WebCore::MeterPart::GaugeRegion"_s,
                "gaugeRegion()"_s
            },
            {
                "double"_s,
                "value()"_s
            },
            {
                "double"_s,
                "minimum()"_s
            },
            {
                "double"_s,
                "maximum()"_s
            },
        } },
        { "WebCore::ProgressBarPart"_s, {
            {
                "double"_s,
                "position()"_s
            },
            {
                "Seconds"_s,
                "animationStartTime()"_s
            },
        } },
        { "WebCore::SliderTrackPart"_s, {
            {
                "WebCore::StyleAppearance"_s,
                "type()"_s
            },
            {
                "WebCore::IntSize"_s,
                "thumbSize()"_s
            },
            {
                "WebCore::IntRect"_s,
                "trackBounds()"_s
            },
            {
                "Vector<double>"_s,
                "tickRatios()"_s
            },
            {
                "double"_s,
                "thumbPosition()"_s
            },
        } },
        { "WebCore::SwitchThumbPart"_s, {
            {
                "bool"_s,
                "isOn()"_s
            },
            {
                "float"_s,
                "progress()"_s
            },
        } },
        { "WebCore::SwitchTrackPart"_s, {
            {
                "bool"_s,
                "isOn()"_s
            },
            {
                "float"_s,
                "progress()"_s
            },
        } },
        { "WebCore::DistantLightSource"_s, {
            {
                "float"_s,
                "azimuth()"_s
            },
            {
                "float"_s,
                "elevation()"_s
            },
        } },
        { "WebCore::PointLightSource"_s, {
            {
                "WebCore::FloatPoint3D"_s,
                "position()"_s
            },
        } },
        { "WebCore::SpotLightSource"_s, {
            {
                "WebCore::FloatPoint3D"_s,
                "position()"_s
            },
            {
                "WebCore::FloatPoint3D"_s,
                "direction()"_s
            },
            {
                "float"_s,
                "specularExponent()"_s
            },
            {
                "float"_s,
                "limitingConeAngle()"_s
            },
        } },
        { "WebCore::FEBlend"_s, {
            {
                "WebCore::BlendMode"_s,
                "blendMode()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FEColorMatrix"_s, {
            {
                "WebCore::ColorMatrixType"_s,
                "type()"_s
            },
            {
                "Vector<float>"_s,
                "values()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::ComponentTransferFunction"_s, {
            {
                "WebCore::ComponentTransferType"_s,
                "type"_s
            },
            {
                "float"_s,
                "slope"_s
            },
            {
                "float"_s,
                "intercept"_s
            },
            {
                "float"_s,
                "amplitude"_s
            },
            {
                "float"_s,
                "exponent"_s
            },
            {
                "float"_s,
                "offset"_s
            },
            {
                "Vector<float>"_s,
                "tableValues"_s
            },
        } },
        { "WebCore::FEComponentTransfer"_s, {
            {
                "WebCore::ComponentTransferFunction"_s,
                "redFunction()"_s
            },
            {
                "WebCore::ComponentTransferFunction"_s,
                "greenFunction()"_s
            },
            {
                "WebCore::ComponentTransferFunction"_s,
                "blueFunction()"_s
            },
            {
                "WebCore::ComponentTransferFunction"_s,
                "alphaFunction()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FEComposite"_s, {
            {
                "WebCore::CompositeOperationType"_s,
                "operation()"_s
            },
            {
                "float"_s,
                "k1()"_s
            },
            {
                "float"_s,
                "k2()"_s
            },
            {
                "float"_s,
                "k3()"_s
            },
            {
                "float"_s,
                "k4()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FEConvolveMatrix"_s, {
            {
                "WebCore::IntSize"_s,
                "kernelSize()"_s
            },
            {
                "float"_s,
                "divisor()"_s
            },
            {
                "float"_s,
                "bias()"_s
            },
            {
                "WebCore::IntPoint"_s,
                "targetOffset()"_s
            },
            {
                "WebCore::EdgeModeType"_s,
                "edgeMode()"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "kernelUnitLength()"_s
            },
            {
                "bool"_s,
                "preserveAlpha()"_s
            },
            {
                "Vector<float>"_s,
                "kernel()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FEDiffuseLighting"_s, {
            {
                "WebCore::Color"_s,
                "lightingColor()"_s
            },
            {
                "float"_s,
                "surfaceScale()"_s
            },
            {
                "float"_s,
                "diffuseConstant()"_s
            },
            {
                "float"_s,
                "kernelUnitLengthX()"_s
            },
            {
                "float"_s,
                "kernelUnitLengthY()"_s
            },
            {
                "WebCore::LightSource"_s,
                "lightSource()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FEDisplacementMap"_s, {
            {
                "WebCore::ChannelSelectorType"_s,
                "xChannelSelector()"_s
            },
            {
                "WebCore::ChannelSelectorType"_s,
                "yChannelSelector()"_s
            },
            {
                "float"_s,
                "scale()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FEDropShadow"_s, {
            {
                "float"_s,
                "stdDeviationX()"_s
            },
            {
                "float"_s,
                "stdDeviationY()"_s
            },
            {
                "float"_s,
                "dx()"_s
            },
            {
                "float"_s,
                "dy()"_s
            },
            {
                "WebCore::Color"_s,
                "shadowColor()"_s
            },
            {
                "float"_s,
                "shadowOpacity()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FEFlood"_s, {
            {
                "WebCore::Color"_s,
                "floodColor()"_s
            },
            {
                "float"_s,
                "floodOpacity()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FEGaussianBlur"_s, {
            {
                "float"_s,
                "stdDeviationX()"_s
            },
            {
                "float"_s,
                "stdDeviationY()"_s
            },
            {
                "WebCore::EdgeModeType"_s,
                "edgeMode()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FEImage"_s, {
            {
                "WebCore::SourceImage"_s,
                "sourceImage()"_s
            },
            {
                "WebCore::FloatRect"_s,
                "sourceImageRect()"_s
            },
            {
                "WebCore::SVGPreserveAspectRatioValue"_s,
                "preserveAspectRatio()"_s
            },
        } },
        { "WebCore::FEMerge"_s, {
            {
                "unsigned"_s,
                "numberOfEffectInputs()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FEMorphology"_s, {
            {
                "WebCore::MorphologyOperatorType"_s,
                "morphologyOperator()"_s
            },
            {
                "float"_s,
                "radiusX()"_s
            },
            {
                "float"_s,
                "radiusY()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FEOffset"_s, {
            {
                "float"_s,
                "dx()"_s
            },
            {
                "float"_s,
                "dy()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FETile"_s, {
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FESpecularLighting"_s, {
            {
                "WebCore::Color"_s,
                "lightingColor()"_s
            },
            {
                "float"_s,
                "surfaceScale()"_s
            },
            {
                "float"_s,
                "specularConstant()"_s
            },
            {
                "float"_s,
                "specularExponent()"_s
            },
            {
                "float"_s,
                "kernelUnitLengthX()"_s
            },
            {
                "float"_s,
                "kernelUnitLengthY()"_s
            },
            {
                "WebCore::LightSource"_s,
                "lightSource()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FETurbulence"_s, {
            {
                "WebCore::TurbulenceType"_s,
                "type()"_s
            },
            {
                "float"_s,
                "baseFrequencyX()"_s
            },
            {
                "float"_s,
                "baseFrequencyY()"_s
            },
            {
                "int"_s,
                "numOctaves()"_s
            },
            {
                "float"_s,
                "seed()"_s
            },
            {
                "bool"_s,
                "stitchTiles()"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::SourceAlpha"_s, {
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::SourceGraphic"_s, {
            {
                "WebCore::DestinationColorSpace"_s,
                "operatingColorSpace()"_s
            },
        } },
        { "WebCore::FilterEffectGeometry"_s, {
            {
                "WebCore::FloatRect"_s,
                "m_boundaries"_s
            },
            {
                "OptionSet<WebCore::FilterEffectGeometry::Flags>"_s,
                "m_flags"_s
            },
        } },
        { "WebCore::SVGFilterExpressionTerm"_s, {
            {
                "unsigned"_s,
                "index"_s
            },
            {
                "unsigned"_s,
                "level"_s
            },
            {
                "std::optional<WebCore::FilterEffectGeometry>"_s,
                "geometry"_s
            },
        } },
        { "WebCore::SVGPreserveAspectRatioValue"_s, {
            {
                "WebCore::SVGPreserveAspectRatioValue::SVGPreserveAspectRatioType"_s,
                "m_align"_s
            },
            {
                "WebCore::SVGPreserveAspectRatioValue::SVGMeetOrSliceType"_s,
                "m_meetOrSlice"_s
            },
        } },
#if ENABLE(GAMEPAD)
        { "WebCore::GamepadEffectParameters"_s, {
            {
                "double"_s,
                "duration"_s
            },
            {
                "double"_s,
                "startDelay"_s
            },
            {
                "double"_s,
                "strongMagnitude"_s
            },
            {
                "double"_s,
                "weakMagnitude"_s
            },
            {
                "double"_s,
                "leftTrigger"_s
            },
            {
                "double"_s,
                "rightTrigger"_s
            },
        } },
#endif // ENABLE(GAMEPAD)
        { "WebCore::StorageEstimate"_s, {
            {
                "uint64_t"_s,
                "usage"_s
            },
            {
                "uint64_t"_s,
                "quota"_s
            },
        } },
        { "PAL::SessionID"_s, {
            {
                "uint64_t"_s,
                "toUInt64()"_s
            },
        } },
        { "WebKit::RunJavaScriptParameters"_s, {
            {
                "String"_s,
                "source"_s
            },
            {
                "JSC::SourceTaintedOrigin"_s,
                "taintedness"_s
            },
            {
                "URL"_s,
                "sourceURL"_s
            },
            {
                "WebCore::RunAsAsyncFunction"_s,
                "runAsAsyncFunction"_s
            },
            {
                "std::optional<Vector<std::pair<String, WebKit::JavaScriptEvaluationResult>>>"_s,
                "arguments"_s
            },
            {
                "WebCore::ForceUserGesture"_s,
                "forceUserGesture"_s
            },
            {
                "WebCore::RemoveTransientActivation"_s,
                "removeTransientActivation"_s
            },
        } },
        { "WebCore::TextList"_s, {
            {
                "WebCore::Style::ListStyleType"_s,
                "styleType"_s
            },
            {
                "int"_s,
                "startingItemNumber"_s
            },
            {
                "bool"_s,
                "ordered"_s
            },
        } },
        { "WebCore::FontAttributes"_s, {
            {
                "RefPtr<WebCore::Font>"_s,
                "font"_s
            },
            {
                "WebCore::Color"_s,
                "backgroundColor"_s
            },
            {
                "WebCore::Color"_s,
                "foregroundColor"_s
            },
            {
                "WebCore::FontShadow"_s,
                "fontShadow"_s
            },
            {
                "WebCore::FontAttributes::SubscriptOrSuperscript"_s,
                "subscriptOrSuperscript"_s
            },
            {
                "WebCore::FontAttributes::HorizontalAlignment"_s,
                "horizontalAlignment"_s
            },
            {
                "Vector<WebCore::TextList>"_s,
                "textLists"_s
            },
            {
                "bool"_s,
                "hasUnderline"_s
            },
            {
                "bool"_s,
                "hasStrikeThrough"_s
            },
            {
                "bool"_s,
                "hasMultipleFonts"_s
            },
        } },
        { "WebCore::CrossOriginEmbedderPolicy"_s, {
            {
                "WebCore::CrossOriginEmbedderPolicyValue"_s,
                "value"_s
            },
            {
                "WebCore::CrossOriginEmbedderPolicyValue"_s,
                "reportOnlyValue"_s
            },
            {
                "String"_s,
                "reportingEndpoint"_s
            },
            {
                "String"_s,
                "reportOnlyReportingEndpoint"_s
            },
        } },
        { "WebCore::SameSiteInfo"_s, {
            {
                "bool"_s,
                "isSameSite"_s
            },
            {
                "bool"_s,
                "isTopSite"_s
            },
            {
                "bool"_s,
                "isSafeHTTPMethod"_s
            },
        } },
        { "WebCore::SecurityOrigin"_s, {
            {
                "WebCore::SecurityOriginData"_s,
                "m_data"_s
            },
            {
                "String"_s,
                "m_domain"_s
            },
            {
                "String"_s,
                "m_filePath"_s
            },
            {
                "bool"_s,
                "m_universalAccess"_s
            },
            {
                "bool"_s,
                "m_domainWasSetInDOM"_s
            },
            {
                "bool"_s,
                "m_canLoadLocalResources"_s
            },
            {
                "bool"_s,
                "m_enforcesFilePathSeparation"_s
            },
            {
                "bool"_s,
                "m_needsStorageAccessFromFileURLsQuirk"_s
            },
            {
                "std::optional<bool>"_s,
                "m_isPotentiallyTrustworthy"_s
            },
            {
                "bool"_s,
                "m_isLocal"_s
            },
        } },
        { "WebCore::CookieRequestHeaderFieldProxy"_s, {
            {
                "URL"_s,
                "firstParty"_s
            },
            {
                "WebCore::SameSiteInfo"_s,
                "sameSiteInfo"_s
            },
            {
                "URL"_s,
                "url"_s
            },
            {
                "std::optional<WebCore::FrameIdentifier>"_s,
                "frameID"_s
            },
            {
                "std::optional<WebCore::PageIdentifier>"_s,
                "pageID"_s
            },
            {
                "WebCore::IncludeSecureCookies"_s,
                "includeSecureCookies"_s
            },
        } },
        { "WebCore::FormData"_s, {
            {
                "Vector<WebCore::FormDataElement>"_s,
                "m_elements"_s
            },
            {
                "int64_t"_s,
                "m_identifier"_s
            },
            {
                "bool"_s,
                "m_alwaysStream"_s
            },
            {
                "Vector<uint8_t>"_s,
                "m_boundary"_s
            },
        } },
        { "WebCore::RequestedScrollData"_s, {
            {
                "WebCore::ScrollRequestType"_s,
                "requestType"_s
            },
            {
                "Variant<WebCore::FloatPoint, WebCore::FloatSize>"_s,
                "scrollPositionOrDelta"_s
            },
            {
                "WebCore::ScrollType"_s,
                "scrollType"_s
            },
            {
                "WebCore::ScrollClamping"_s,
                "clamping"_s
            },
            {
                "WebCore::ScrollIsAnimated"_s,
                "animated"_s
            },
            {
                "std::optional<std::tuple<WebCore::ScrollRequestType, Variant<WebCore::FloatPoint, WebCore::FloatSize>, WebCore::ScrollType, WebCore::ScrollClamping>>"_s,
                "requestedDataBeforeAnimatedScroll"_s
            },
        } },
        { "WebCore::FloatScrollSnapOffsetsInfo"_s, {
            {
                "WebCore::ScrollSnapStrictness"_s,
                "strictness"_s
            },
            {
                "Vector<WebCore::FloatSnapOffset>"_s,
                "horizontalSnapOffsets"_s
            },
            {
                "Vector<WebCore::FloatSnapOffset>"_s,
                "verticalSnapOffsets"_s
            },
            {
                "Vector<WebCore::FloatRect>"_s,
                "snapAreas"_s
            },
            {
                "Vector<WebCore::NodeIdentifier>"_s,
                "snapAreasIDs"_s
            },
        } },
        { "WebCore::FloatSnapOffset"_s, {
            {
                "float"_s,
                "offset"_s
            },
            {
                "WebCore::ScrollSnapStop"_s,
                "stop"_s
            },
            {
                "bool"_s,
                "hasSnapAreaLargerThanViewport"_s
            },
            {
                "Markable<WebCore::NodeIdentifier>"_s,
                "snapTargetID"_s
            },
            {
                "bool"_s,
                "isFocused"_s
            },
            {
                "Vector<uint64_t>"_s,
                "snapAreaIndices"_s
            },
        } },
#if ENABLE(ENCRYPTED_MEDIA)
        { "WebCore::CDMMediaCapability"_s, {
            {
                "String"_s,
                "contentType"_s
            },
            {
                "String"_s,
                "robustness"_s
            },
            {
                "std::optional<WebCore::CDMEncryptionScheme>"_s,
                "encryptionScheme"_s
            },
        } },
#endif // ENABLE(ENCRYPTED_MEDIA)
#if ENABLE(ENCRYPTED_MEDIA)
        { "WebCore::CDMRestrictions"_s, {
            {
                "bool"_s,
                "distinctiveIdentifierDenied"_s
            },
            {
                "bool"_s,
                "persistentStateDenied"_s
            },
            {
                "HashSet<WebCore::CDMSessionType, IntHash<WebCore::CDMSessionType>, WTF::StrongEnumHashTraits<WebCore::CDMSessionType>>"_s,
                "deniedSessionTypes"_s
            },
        } },
#endif // ENABLE(ENCRYPTED_MEDIA)
        { "WebCore::MediaSelectionOption"_s, {
            {
                "WebCore::MediaSelectionOption::MediaType"_s,
                "mediaType"_s
            },
            {
                "String"_s,
                "displayName"_s
            },
            {
                "WebCore::MediaSelectionOption::LegibleType"_s,
                "legibleType"_s
            },
        } },
        { "WebCore::BufferSource"_s, {
            {
                "std::span<const uint8_t>"_s,
                "span()"_s
            },
        } },
        { "WebCore::FontShadow"_s, {
            {
                "WebCore::Color"_s,
                "color"_s
            },
            {
                "WebCore::FloatSize"_s,
                "offset"_s
            },
            {
                "double"_s,
                "blurRadius"_s
            },
        } },
        { "WebCore::CompositionHighlight"_s, {
            {
                "unsigned"_s,
                "startOffset"_s
            },
            {
                "unsigned"_s,
                "endOffset"_s
            },
            {
                "std::optional<WebCore::Color>"_s,
                "backgroundColor"_s
            },
            {
                "std::optional<WebCore::Color>"_s,
                "foregroundColor"_s
            },
        } },
        { "WebCore::FontChanges"_s, {
            {
                "String"_s,
                "m_fontName"_s
            },
            {
                "String"_s,
                "m_fontFamily"_s
            },
            {
                "std::optional<double>"_s,
                "m_fontSize"_s
            },
            {
                "std::optional<double>"_s,
                "m_fontSizeDelta"_s
            },
            {
                "std::optional<bool>"_s,
                "m_bold"_s
            },
            {
                "std::optional<bool>"_s,
                "m_italic"_s
            },
        } },
        { "WebCore::FontAttributeChanges"_s, {
            {
                "std::optional<WebCore::VerticalAlignChange>"_s,
                "m_verticalAlign"_s
            },
            {
                "std::optional<WebCore::Color>"_s,
                "m_backgroundColor"_s
            },
            {
                "std::optional<WebCore::Color>"_s,
                "m_foregroundColor"_s
            },
            {
                "std::optional<WebCore::FontShadow>"_s,
                "m_shadow"_s
            },
            {
                "std::optional<bool>"_s,
                "m_strikeThrough"_s
            },
            {
                "std::optional<bool>"_s,
                "m_underline"_s
            },
            {
                "WebCore::FontChanges"_s,
                "m_fontChanges"_s
            },
        } },
        { "WebCore::TextManipulationControllerExclusionRule::ElementRule"_s, {
            {
                "AtomString"_s,
                "localName"_s
            },
        } },
        { "WebCore::TextManipulationControllerExclusionRule::AttributeRule"_s, {
            {
                "AtomString"_s,
                "name"_s
            },
            {
                "String"_s,
                "value"_s
            },
        } },
        { "WebCore::TextManipulationControllerExclusionRule::ClassRule"_s, {
            {
                "AtomString"_s,
                "className"_s
            },
        } },
        { "WebCore::TextManipulationControllerExclusionRule"_s, {
            {
                "WebCore::TextManipulationControllerExclusionRule::Type"_s,
                "type"_s
            },
            {
                "Variant<WebCore::TextManipulationControllerExclusionRule::ElementRule, WebCore::TextManipulationControllerExclusionRule::AttributeRule, WebCore::TextManipulationControllerExclusionRule::ClassRule>"_s,
                "rule"_s
            },
        } },
        { "WebCore::TextManipulationControllerManipulationFailure"_s, {
            {
                "WebCore::FrameIdentifier"_s,
                "frameID"_s
            },
            {
                "Markable<WebCore::TextManipulationItemIdentifier>"_s,
                "identifier"_s
            },
            {
                "uint64_t"_s,
                "index"_s
            },
            {
                "WebCore::TextManipulationControllerManipulationFailure::Type"_s,
                "type"_s
            },
        } },
        { "WebCore::TextManipulationControllerManipulationResult"_s, {
            {
                "Vector<WebCore::TextManipulationControllerManipulationFailure>"_s,
                "failures"_s
            },
            {
                "Vector<uint64_t>"_s,
                "succeededIndexes"_s
            },
        } },
        { "WebCore::BackgroundFetchInformation"_s, {
            {
                "WebCore::ServiceWorkerRegistrationIdentifier"_s,
                "registrationIdentifier"_s
            },
            {
                "String"_s,
                "identifier"_s
            },
            {
                "uint64_t"_s,
                "uploadTotal"_s
            },
            {
                "uint64_t"_s,
                "uploaded"_s
            },
            {
                "uint64_t"_s,
                "downloadTotal"_s
            },
            {
                "uint64_t"_s,
                "downloaded"_s
            },
            {
                "WebCore::BackgroundFetchResult"_s,
                "result"_s
            },
            {
                "WebCore::BackgroundFetchFailureReason"_s,
                "failureReason"_s
            },
            {
                "bool"_s,
                "recordsAvailable"_s
            },
        } },
        { "WebCore::BackgroundFetchRequest"_s, {
            {
                "WebCore::ResourceRequest"_s,
                "internalRequest"_s
            },
            {
                "WebCore::FetchOptions"_s,
                "options"_s
            },
            {
                "WebCore::FetchHeadersGuard"_s,
                "guard"_s
            },
            {
                "WebCore::HTTPHeaderMap"_s,
                "httpHeaders"_s
            },
            {
                "String"_s,
                "referrer"_s
            },
            {
                "Markable<WebCore::ContentSecurityPolicyResponseHeaders>"_s,
                "cspResponseHeaders"_s
            },
        } },
        { "WebCore::BackgroundFetchRecordInformation"_s, {
            {
                "WebCore::BackgroundFetchRecordIdentifier"_s,
                "identifier"_s
            },
            {
                "WebCore::ResourceRequest"_s,
                "internalRequest"_s
            },
            {
                "WebCore::FetchOptions"_s,
                "options"_s
            },
            {
                "WebCore::FetchHeadersGuard"_s,
                "guard"_s
            },
            {
                "WebCore::HTTPHeaderMap"_s,
                "httpHeaders"_s
            },
            {
                "String"_s,
                "referrer"_s
            },
        } },
        { "WebCore::BackgroundFetchOptions"_s, {
            {
                "Vector<WebCore::ImageResource>"_s,
                "icons"_s
            },
            {
                "String"_s,
                "title"_s
            },
            {
                "uint64_t"_s,
                "downloadTotal"_s
            },
        } },
        { "WebCore::ImageResource"_s, {
            {
                "String"_s,
                "src"_s
            },
            {
                "String"_s,
                "sizes"_s
            },
            {
                "String"_s,
                "type"_s
            },
            {
                "String"_s,
                "label"_s
            },
        } },
        { "WebCore::FourCC"_s, {
            {
                "uint32_t"_s,
                "value"_s
            },
        } },
#if ENABLE(VIDEO)
        { "WebCore::MediaEngineSupportParameters"_s, {
            {
                "WebCore::ContentType"_s,
                "type"_s
            },
            {
                "URL"_s,
                "url"_s
            },
            {
                "bool"_s,
                "isMediaSource"_s
            },
            {
                "bool"_s,
                "isMediaStream"_s
            },
            {
                "bool"_s,
                "requiresRemotePlayback"_s
            },
            {
                "bool"_s,
                "supportsLimitedMatroska"_s
            },
            {
                "Vector<WebCore::ContentType>"_s,
                "contentTypesRequiringHardwareSupport"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "allowedMediaContainerTypes"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "allowedMediaCodecTypes"_s
            },
            {
                "std::optional<Vector<WebCore::FourCC>>"_s,
                "allowedMediaVideoCodecIDs"_s
            },
            {
                "std::optional<Vector<WebCore::FourCC>>"_s,
                "allowedMediaAudioCodecIDs"_s
            },
            {
                "std::optional<Vector<WebCore::FourCC>>"_s,
                "allowedMediaCaptionFormatTypes"_s
            },
        } },
#endif // ENABLE(VIDEO)
#if ENABLE(VIDEO)
        { "WebCore::SeekTarget"_s, {
            {
                "MediaTime"_s,
                "time"_s
            },
            {
                "MediaTime"_s,
                "negativeThreshold"_s
            },
            {
                "MediaTime"_s,
                "positiveThreshold"_s
            },
        } },
#endif // ENABLE(VIDEO)
#if ENABLE(VIDEO)
        { "WebCore::MediaPlayerLoadOptions"_s, {
            {
                "WebCore::ContentType"_s,
                "contentType"_s
            },
            {
                "bool"_s,
                "requiresRemotePlayback"_s
            },
            {
                "bool"_s,
                "supportsLimitedMatroska"_s
            },
            {
                "OptionSet<WebCore::VideoMediaSampleRendererPreference>"_s,
                "videoMediaSampleRendererPreferences"_s
            },
        } },
#endif // ENABLE(VIDEO)
        { "WebCore::GeolocationPositionData"_s, {
            {
                "double"_s,
                "timestamp"_s
            },
            {
                "double"_s,
                "latitude"_s
            },
            {
                "double"_s,
                "longitude"_s
            },
            {
                "double"_s,
                "accuracy"_s
            },
            {
                "std::optional<double>"_s,
                "altitude"_s
            },
            {
                "std::optional<double>"_s,
                "altitudeAccuracy"_s
            },
            {
                "std::optional<double>"_s,
                "heading"_s
            },
            {
                "std::optional<double>"_s,
                "speed"_s
            },
            {
                "std::optional<double>"_s,
                "floorLevel"_s
            },
        } },
#if ENABLE(APP_HIGHLIGHTS)
        { "WebCore::AppHighlight"_s, {
            {
                "Ref<WebCore::SharedBuffer>"_s,
                "highlight"_s
            },
            {
                "std::optional<String>"_s,
                "text"_s
            },
            {
                "WebCore::CreateNewGroupForHighlight"_s,
                "isNewGroup"_s
            },
            {
                "WebCore::HighlightRequestOriginatedInApp"_s,
                "requestOriginatedInApp"_s
            },
        } },
#endif // ENABLE(APP_HIGHLIGHTS)
        { "WebCore::MediaDeviceHashSalts"_s, {
            {
                "String"_s,
                "persistentDeviceSalt"_s
            },
            {
                "String"_s,
                "ephemeralDeviceSalt"_s
            },
        } },
        { "WebCore::SpeechRecognitionUpdate"_s, {
            {
                "WebCore::SpeechRecognitionConnectionClientIdentifier"_s,
                "m_clientIdentifier"_s
            },
            {
                "WebCore::SpeechRecognitionUpdateType"_s,
                "m_type"_s
            },
            {
                "Variant<std::monostate, WebCore::SpeechRecognitionError, Vector<WebCore::SpeechRecognitionResultData>>"_s,
                "m_content"_s
            },
        } },
#if USE(SYSTEM_PREVIEW)
        { "WebCore::ARKitBadgeSystemImage"_s, {
            {
                "WebCore::RenderingResourceIdentifier"_s,
                "imageIdentifier()"_s
            },
            {
                "WebCore::FloatSize"_s,
                "m_imageSize"_s
            },
        } },
#endif // USE(SYSTEM_PREVIEW)
        { "WebCore::AudioIOPosition"_s, {
            {
                "Seconds"_s,
                "position"_s
            },
            {
                "MonotonicTime"_s,
                "timestamp"_s
            },
        } },
#if ENABLE(VIDEO) && USE(AVFOUNDATION)
        { "WebCore::VideoFrameCV"_s, {
            {
                "MediaTime"_s,
                "presentationTime()"_s
            },
            {
                "bool"_s,
                "isMirrored()"_s
            },
            {
                "WebCore::VideoFrameRotation"_s,
                "rotation()"_s
            },
            {
                "RetainPtr<CVPixelBufferRef>"_s,
                "m_pixelBuffer"_s
            },
            {
                "WebCore::PlatformVideoColorSpace"_s,
                "colorSpace()"_s
            },
        } },
#endif // ENABLE(VIDEO) && USE(AVFOUNDATION)
        { "WebCore::GradientColorStop"_s, {
            {
                "float"_s,
                "offset"_s
            },
            {
                "WebCore::Color"_s,
                "color"_s
            },
        } },
        { "WebCore::GradientColorStops"_s, {
            {
                "Vector<WebCore::GradientColorStop, 2>"_s,
                "stops()"_s
            },
        } },
        { "WebCore::ImageBufferParameters"_s, {
            {
                "WebCore::FloatSize"_s,
                "logicalSize"_s
            },
            {
                "float"_s,
                "resolutionScale"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "colorSpace"_s
            },
            {
                "WebCore::ImageBufferFormat"_s,
                "bufferFormat"_s
            },
            {
                "WebCore::RenderingPurpose"_s,
                "purpose"_s
            },
        } },
        { "WebCore::ProcessIdentity"_s, {
#if HAVE(TASK_IDENTITY_TOKEN)
            {
                "MachSendRight"_s,
                "m_taskIdToken"_s
            },
#endif
        } },
        { "WebCore::ColorInterpolationMethod::HSL"_s, {
            {
                "WebCore::HueInterpolationMethod"_s,
                "hueInterpolationMethod"_s
            },
        } },
        { "WebCore::ColorInterpolationMethod::HWB"_s, {
            {
                "WebCore::HueInterpolationMethod"_s,
                "hueInterpolationMethod"_s
            },
        } },
        { "WebCore::ColorInterpolationMethod::LCH"_s, {
            {
                "WebCore::HueInterpolationMethod"_s,
                "hueInterpolationMethod"_s
            },
        } },
        { "WebCore::ColorInterpolationMethod::Lab"_s, {
        } },
        { "WebCore::ColorInterpolationMethod::OKLCH"_s, {
            {
                "WebCore::HueInterpolationMethod"_s,
                "hueInterpolationMethod"_s
            },
        } },
        { "WebCore::ColorInterpolationMethod::OKLab"_s, {
        } },
        { "WebCore::ColorInterpolationMethod::SRGB"_s, {
        } },
        { "WebCore::ColorInterpolationMethod::SRGBLinear"_s, {
        } },
        { "WebCore::ColorInterpolationMethod::DisplayP3"_s, {
        } },
        { "WebCore::ColorInterpolationMethod::A98RGB"_s, {
        } },
        { "WebCore::ColorInterpolationMethod::ProPhotoRGB"_s, {
        } },
        { "WebCore::ColorInterpolationMethod::Rec2020"_s, {
        } },
        { "WebCore::ColorInterpolationMethod::XYZD50"_s, {
        } },
        { "WebCore::ColorInterpolationMethod::XYZD65"_s, {
        } },
        { "WebCore::ColorInterpolationMethod"_s, {
            {
                "Variant<WebCore::ColorInterpolationMethod::HSL, WebCore::ColorInterpolationMethod::HWB, WebCore::ColorInterpolationMethod::LCH, WebCore::ColorInterpolationMethod::Lab, WebCore::ColorInterpolationMethod::OKLCH, WebCore::ColorInterpolationMethod::OKLab, WebCore::ColorInterpolationMethod::SRGB, WebCore::ColorInterpolationMethod::SRGBLinear, WebCore::ColorInterpolationMethod::DisplayP3, WebCore::ColorInterpolationMethod::A98RGB, WebCore::ColorInterpolationMethod::ProPhotoRGB, WebCore::ColorInterpolationMethod::Rec2020, WebCore::ColorInterpolationMethod::XYZD50, WebCore::ColorInterpolationMethod::XYZD65>"_s,
                "colorSpace"_s
            },
            {
                "WebCore::AlphaPremultiplication"_s,
                "alphaPremultiplication"_s
            },
        } },
        { "WebCore::CompositeMode"_s, {
            {
                "WebCore::CompositeOperator"_s,
                "operation"_s
            },
            {
                "WebCore::BlendMode"_s,
                "blendMode"_s
            },
        } },
        { "WebCore::DocumentMarkerLineStyle"_s, {
            {
                "WebCore::DocumentMarkerLineStyleMode"_s,
                "mode"_s
            },
            {
                "WebCore::Color"_s,
                "color"_s
            },
        } },
        { "WebCore::GraphicsDropShadow"_s, {
            {
                "WebCore::FloatSize"_s,
                "offset"_s
            },
            {
                "float"_s,
                "radius"_s
            },
            {
                "WebCore::Color"_s,
                "color"_s
            },
            {
                "WebCore::ShadowRadiusMode"_s,
                "radiusMode"_s
            },
            {
                "float"_s,
                "opacity"_s
            },
        } },
        { "WebCore::GraphicsGaussianBlur"_s, {
            {
                "WebCore::FloatSize"_s,
                "radius"_s
            },
        } },
        { "WebCore::GraphicsColorMatrix"_s, {
            {
                "std::array<float, 20>"_s,
                "values"_s
            },
        } },
        { "WebCore::PlatformMediaSessionRemoteCommandArgument"_s, {
            {
                "std::optional<double>"_s,
                "time"_s
            },
            {
                "std::optional<bool>"_s,
                "fastSeek"_s
            },
        } },
        { "WebCore::SocketStreamError"_s, {
            {
                "int"_s,
                "m_errorCode"_s
            },
            {
                "String"_s,
                "m_failingURL"_s
            },
            {
                "String"_s,
                "m_localizedDescription"_s
            },
            {
                "bool"_s,
                "m_isNull"_s
            },
        } },
#if ENABLE(VIDEO)
        { "WebCore::GenericCueData"_s, {
            {
                "Markable<WebCore::InbandGenericCueIdentifier>"_s,
                "m_uniqueId"_s
            },
            {
                "MediaTime"_s,
                "m_startTime"_s
            },
            {
                "MediaTime"_s,
                "m_endTime"_s
            },
            {
                "AtomString"_s,
                "m_id"_s
            },
            {
                "String"_s,
                "m_content"_s
            },
            {
                "String"_s,
                "m_fontName"_s
            },
            {
                "double"_s,
                "m_line"_s
            },
            {
                "double"_s,
                "m_position"_s
            },
            {
                "double"_s,
                "m_size"_s
            },
            {
                "double"_s,
                "m_baseFontSize"_s
            },
            {
                "double"_s,
                "m_relativeFontSize"_s
            },
            {
                "WebCore::Color"_s,
                "m_foregroundColor"_s
            },
            {
                "WebCore::Color"_s,
                "m_backgroundColor"_s
            },
            {
                "WebCore::Color"_s,
                "m_highlightColor"_s
            },
            {
                "WebCore::GenericCueData::Alignment"_s,
                "m_positionAlign"_s
            },
            {
                "WebCore::GenericCueData::Alignment"_s,
                "m_align"_s
            },
            {
                "WebCore::GenericCueData::Status"_s,
                "m_status"_s
            },
        } },
#endif // ENABLE(VIDEO)
        { "WebCore::ImageDecoderFrameInfo"_s, {
            {
                "bool"_s,
                "hasAlpha"_s
            },
            {
                "Seconds"_s,
                "duration"_s
            },
        } },
        { "WebCore::DisplayList::DrawDotsForDocumentMarker"_s, {
            {
                "WebCore::FloatRect"_s,
                "rect()"_s
            },
            {
                "WebCore::DocumentMarkerLineStyle"_s,
                "style()"_s
            },
        } },
        { "WebCore::ImageOrientation"_s, {
            {
                "WebCore::ImageOrientation::Orientation"_s,
                "orientation()"_s
            },
        } },
        { "WebCore::Headroom"_s, {
            {
                "float"_s,
                "headroom"_s
            },
        } },
        { "WebCore::ImagePaintingOptions"_s, {
            {
                "WebCore::CompositeOperator"_s,
                "compositeOperator()"_s
            },
            {
                "WebCore::BlendMode"_s,
                "blendMode()"_s
            },
            {
                "WebCore::DecodingMode"_s,
                "decodingMode()"_s
            },
            {
                "WebCore::ImageOrientation::Orientation"_s,
                "orientation().orientation()"_s
            },
            {
                "WebCore::InterpolationQuality"_s,
                "interpolationQuality()"_s
            },
            {
                "WebCore::DrawsHDRContent"_s,
                "drawsHDRContent()"_s
            },
            {
                "WebCore::Headroom"_s,
                "headroom()"_s
            },
            {
                "WebCore::PlatformDynamicRangeLimit"_s,
                "dynamicRangeLimit()"_s
            },
        } },
        { "WebCore::FloatSegment"_s, {
            {
                "float"_s,
                "begin"_s
            },
            {
                "float"_s,
                "end"_s
            },
        } },
        { "WebCore::CanvasActivityRecord"_s, {
            {
                "HashSet<String>"_s,
                "textWritten"_s
            },
            {
                "bool"_s,
                "wasDataRead"_s
            },
        } },
        { "WebCore::PCM::AttributionSecondsUntilSendData"_s, {
            {
                "std::optional<Seconds>"_s,
                "sourceSeconds"_s
            },
            {
                "std::optional<Seconds>"_s,
                "destinationSeconds"_s
            },
        } },
        { "WebCore::CrossOriginOpenerPolicy"_s, {
            {
                "WebCore::CrossOriginOpenerPolicyValue"_s,
                "value"_s
            },
            {
                "WebCore::CrossOriginOpenerPolicyValue"_s,
                "reportOnlyValue"_s
            },
            {
                "String"_s,
                "reportingEndpoint"_s
            },
            {
                "String"_s,
                "reportOnlyReportingEndpoint"_s
            },
        } },
        { "WebCore::CustomHeaderFields"_s, {
            {
                "Vector<WebCore::HTTPHeaderField>"_s,
                "fields"_s
            },
            {
                "Vector<String>"_s,
                "thirdPartyDomains"_s
            },
        } },
        { "WebCore::HTTPHeaderField"_s, {
            {
                "String"_s,
                "name()"_s
            },
            {
                "String"_s,
                "value()"_s
            },
        } },
        { "WebCore::NavigationRequester"_s, {
            {
                "URL"_s,
                "url"_s
            },
            {
                "Ref<WebCore::SecurityOrigin>"_s,
                "securityOrigin"_s
            },
            {
                "Ref<WebCore::SecurityOrigin>"_s,
                "topOrigin"_s
            },
            {
                "WebCore::PolicyContainer"_s,
                "policyContainer"_s
            },
            {
                "std::optional<WebCore::FrameIdentifier>"_s,
                "frameID"_s
            },
            {
                "std::optional<WebCore::PageIdentifier>"_s,
                "pageID"_s
            },
            {
                "WebCore::ScriptExecutionContextIdentifier"_s,
                "documentIdentifier"_s
            },
            {
                "WebCore::SandboxFlags"_s,
                "sandboxFlags"_s
            },
        } },
        { "WebCore::PolicyContainer"_s, {
            {
                "WebCore::ContentSecurityPolicyResponseHeaders"_s,
                "contentSecurityPolicyResponseHeaders"_s
            },
            {
                "WebCore::CrossOriginEmbedderPolicy"_s,
                "crossOriginEmbedderPolicy"_s
            },
            {
                "WebCore::CrossOriginOpenerPolicy"_s,
                "crossOriginOpenerPolicy"_s
            },
            {
                "WebCore::ReferrerPolicy"_s,
                "referrerPolicy"_s
            },
        } },
        { "WebCore::SubstituteData"_s, {
            {
                "RefPtr<WebCore::FragmentedSharedBuffer>"_s,
                "protectedContent()"_s
            },
            {
                "URL"_s,
                "failingURL()"_s
            },
            {
                "WebCore::ResourceResponse"_s,
                "response()"_s
            },
            {
                "WebCore::SubstituteData::SessionHistoryVisibility"_s,
                "shouldRevealToSessionHistory()"_s
            },
        } },
        { "WebCore::ServiceWorkerClientData"_s, {
            {
                "WebCore::ScriptExecutionContextIdentifier"_s,
                "identifier"_s
            },
            {
                "WebCore::ServiceWorkerClientType"_s,
                "type"_s
            },
            {
                "WebCore::ServiceWorkerClientFrameType"_s,
                "frameType"_s
            },
            {
                "URL"_s,
                "url"_s
            },
            {
                "URL"_s,
                "ownerURL"_s
            },
            {
                "std::optional<WebCore::PageIdentifier>"_s,
                "pageIdentifier"_s
            },
            {
                "std::optional<WebCore::FrameIdentifier>"_s,
                "frameIdentifier"_s
            },
            {
                "WebCore::LastNavigationWasAppInitiated"_s,
                "lastNavigationWasAppInitiated"_s
            },
            {
                "OptionSet<WebCore::AdvancedPrivacyProtections>"_s,
                "advancedPrivacyProtections"_s
            },
            {
                "bool"_s,
                "isVisible"_s
            },
            {
                "bool"_s,
                "isFocused"_s
            },
            {
                "uint64_t"_s,
                "focusOrder"_s
            },
            {
                "Vector<String>"_s,
                "ancestorOrigins"_s
            },
        } },
        { "WebCore::ServiceWorkerClientPendingMessage"_s, {
            {
                "WebCore::MessageWithMessagePorts"_s,
                "message"_s
            },
            {
                "WebCore::ServiceWorkerData"_s,
                "sourceData"_s
            },
            {
                "String"_s,
                "sourceOrigin"_s
            },
        } },
        { "WebCore::ServiceWorkerClientQueryOptions"_s, {
            {
                "bool"_s,
                "includeUncontrolled"_s
            },
            {
                "WebCore::ServiceWorkerClientType"_s,
                "type"_s
            },
        } },
        { "WebCore::ServiceWorkerData"_s, {
            {
                "WebCore::ServiceWorkerIdentifier"_s,
                "identifier"_s
            },
            {
                "WebCore::ServiceWorkerRegistrationIdentifier"_s,
                "registrationIdentifier"_s
            },
            {
                "URL"_s,
                "scriptURL"_s
            },
            {
                "WebCore::ServiceWorkerState"_s,
                "state"_s
            },
            {
                "WebCore::WorkerType"_s,
                "type"_s
            },
        } },
        { "WebCore::ServiceWorkerJobData"_s, {
            {
                "WebCore::ServiceWorkerJobDataIdentifier"_s,
                "identifier()"_s
            },
            {
                "URL"_s,
                "scriptURL"_s
            },
            {
                "URL"_s,
                "clientCreationURL"_s
            },
            {
                "WebCore::SecurityOriginData"_s,
                "topOrigin"_s
            },
            {
                "URL"_s,
                "scopeURL"_s
            },
            {
                "WebCore::ServiceWorkerOrClientIdentifier"_s,
                "sourceContext"_s
            },
            {
                "WebCore::WorkerType"_s,
                "workerType"_s
            },
            {
                "WebCore::ServiceWorkerJobType"_s,
                "type"_s
            },
            {
                "String"_s,
                "domainForCachePartition"_s
            },
            {
                "bool"_s,
                "isFromServiceWorkerPage"_s
            },
            {
                "std::optional<WebCore::ServiceWorkerRegistrationOptions>"_s,
                "registrationOptions"_s
            },
        } },
        { "WebCore::RouterSourceDict"_s, {
            {
                "String"_s,
                "cacheName"_s
            },
        } },
        { "WebCore::ServiceWorkerRoutePattern"_s, {
            {
                "String"_s,
                "protocol"_s
            },
            {
                "String"_s,
                "username"_s
            },
            {
                "String"_s,
                "password"_s
            },
            {
                "String"_s,
                "hostname"_s
            },
            {
                "String"_s,
                "port"_s
            },
            {
                "String"_s,
                "pathname"_s
            },
            {
                "String"_s,
                "search"_s
            },
            {
                "String"_s,
                "hash"_s
            },
        } },
        { "WebCore::ServiceWorkerRouteCondition"_s, {
            {
                "std::optional<WebCore::ServiceWorkerRoutePattern>"_s,
                "urlPattern"_s
            },
            {
                "String"_s,
                "requestMethod"_s
            },
            {
                "std::optional<WebCore::FetchOptionsMode>"_s,
                "requestMode"_s
            },
            {
                "std::optional<WebCore::FetchOptionsDestination>"_s,
                "requestDestination"_s
            },
            {
                "std::optional<WebCore::RunningStatus>"_s,
                "runningStatus"_s
            },
            {
                "Vector<WebCore::ServiceWorkerRouteCondition>"_s,
                "orConditions"_s
            },
            {
                "std::unique_ptr<WebCore::ServiceWorkerRouteCondition>"_s,
                "notCondition"_s
            },
        } },
        { "WebCore::ServiceWorkerRoute"_s, {
            {
                "WebCore::ServiceWorkerRouteCondition"_s,
                "condition"_s
            },
            {
                "Variant<WebCore::RouterSourceDict, WebCore::RouterSourceEnum>"_s,
                "source"_s
            },
        } },
        { "WebCore::EventInit"_s, {
            {
                "bool"_s,
                "bubbles"_s
            },
            {
                "bool"_s,
                "cancelable"_s
            },
            {
                "bool"_s,
                "composed"_s
            },
        } },
        { "WebCore::MessageWithMessagePorts"_s, {
            {
                "RefPtr<WebCore::SerializedScriptValue>"_s,
                "message"_s
            },
            {
                "Vector<WebCore::TransferredMessagePort>"_s,
                "transferredPorts"_s
            },
        } },
        { "WebCore::RequestStorageAccessResult"_s, {
            {
                "WebCore::StorageAccessWasGranted"_s,
                "wasGranted"_s
            },
            {
                "WebCore::StorageAccessPromptWasShown"_s,
                "promptWasShown"_s
            },
            {
                "WebCore::StorageAccessScope"_s,
                "scope"_s
            },
            {
                "WebCore::RegistrableDomain"_s,
                "topFrameDomain"_s
            },
            {
                "WebCore::RegistrableDomain"_s,
                "subFrameDomain"_s
            },
        } },
        { "WebCore::Exception"_s, {
            {
                "WebCore::ExceptionCode"_s,
                "code()"_s
            },
            {
                "String"_s,
                "message()"_s
            },
        } },
        { "WebCore::ExceptionData"_s, {
            {
                "WebCore::ExceptionCode"_s,
                "code"_s
            },
            {
                "String"_s,
                "message"_s
            },
        } },
        { "WebCore::MessagePortIdentifier"_s, {
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier"_s
            },
            {
                "WebCore::PortIdentifier"_s,
                "portIdentifier"_s
            },
        } },
        { "WebCore::SecurityPolicyViolationEventInit"_s, {
            {
                "bool"_s,
                "bubbles"_s
            },
            {
                "bool"_s,
                "cancelable"_s
            },
            {
                "bool"_s,
                "composed"_s
            },
            {
                "String"_s,
                "documentURI"_s
            },
            {
                "String"_s,
                "referrer"_s
            },
            {
                "String"_s,
                "blockedURI"_s
            },
            {
                "String"_s,
                "violatedDirective"_s
            },
            {
                "String"_s,
                "effectiveDirective"_s
            },
            {
                "String"_s,
                "originalPolicy"_s
            },
            {
                "String"_s,
                "sourceFile"_s
            },
            {
                "String"_s,
                "sample"_s
            },
            {
                "WebCore::SecurityPolicyViolationEventDisposition"_s,
                "disposition"_s
            },
            {
                "unsigned short"_s,
                "statusCode"_s
            },
            {
                "unsigned"_s,
                "lineNumber"_s
            },
            {
                "unsigned"_s,
                "columnNumber"_s
            },
        } },
        { "WebCore::CSPViolationReportBody"_s, {
            {
                "String"_s,
                "documentURL()"_s
            },
            {
                "String"_s,
                "referrer()"_s
            },
            {
                "String"_s,
                "blockedURL()"_s
            },
            {
                "String"_s,
                "effectiveDirective()"_s
            },
            {
                "String"_s,
                "originalPolicy()"_s
            },
            {
                "String"_s,
                "sourceFile()"_s
            },
            {
                "String"_s,
                "sample()"_s
            },
            {
                "WebCore::SecurityPolicyViolationEventDisposition"_s,
                "disposition()"_s
            },
            {
                "unsigned short"_s,
                "statusCode()"_s
            },
            {
                "uint64_t"_s,
                "lineNumber()"_s
            },
            {
                "uint64_t"_s,
                "columnNumber()"_s
            },
        } },
        { "WebCore::SecurityOriginData"_s, {
            {
                "Variant<WebCore::SecurityOriginData::Tuple, WebCore::OpaqueOriginIdentifierProcessQualified>"_s,
                "data()"_s
            },
        } },
        { "WebCore::SecurityOriginData::Tuple"_s, {
            {
                "String"_s,
                "protocol"_s
            },
            {
                "String"_s,
                "host"_s
            },
            {
                "std::optional<uint16_t>"_s,
                "port"_s
            },
        } },
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MediaConstraint"_s, {
            {
                "WebCore::MediaConstraint::DataType"_s,
                "dataType()"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::IntConstraint"_s, {
            {
                "WebCore::MediaConstraint::DataType"_s,
                "dataType()"_s
            },
            {
                "std::optional<int>"_s,
                "m_min"_s
            },
            {
                "std::optional<int>"_s,
                "m_max"_s
            },
            {
                "std::optional<int>"_s,
                "m_exact"_s
            },
            {
                "std::optional<int>"_s,
                "m_ideal"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::DoubleConstraint"_s, {
            {
                "WebCore::MediaConstraint::DataType"_s,
                "dataType()"_s
            },
            {
                "std::optional<double>"_s,
                "m_min"_s
            },
            {
                "std::optional<double>"_s,
                "m_max"_s
            },
            {
                "std::optional<double>"_s,
                "m_exact"_s
            },
            {
                "std::optional<double>"_s,
                "m_ideal"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::BooleanConstraint"_s, {
            {
                "WebCore::MediaConstraint::DataType"_s,
                "dataType()"_s
            },
            {
                "std::optional<bool>"_s,
                "m_exact"_s
            },
            {
                "std::optional<bool>"_s,
                "m_ideal"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::StringConstraint"_s, {
            {
                "WebCore::MediaConstraint::DataType"_s,
                "dataType()"_s
            },
            {
                "Vector<String>"_s,
                "m_exact"_s
            },
            {
                "Vector<String>"_s,
                "m_ideal"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::FrameRateRange"_s, {
            {
                "double"_s,
                "minimum"_s
            },
            {
                "double"_s,
                "maximum"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::VideoPresetData"_s, {
            {
                "WebCore::IntSize"_s,
                "size"_s
            },
            {
                "Vector<WebCore::FrameRateRange>"_s,
                "frameRateRanges"_s
            },
            {
                "double"_s,
                "minZoom"_s
            },
            {
                "double"_s,
                "maxZoom"_s
            },
            {
                "bool"_s,
                "isEfficient"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::RealtimeMediaSourceSupportedConstraints"_s, {
            {
                "bool"_s,
                "supportsWidth()"_s
            },
            {
                "bool"_s,
                "supportsHeight()"_s
            },
            {
                "bool"_s,
                "supportsAspectRatio()"_s
            },
            {
                "bool"_s,
                "supportsFrameRate()"_s
            },
            {
                "bool"_s,
                "supportsFacingMode()"_s
            },
            {
                "bool"_s,
                "supportsVolume()"_s
            },
            {
                "bool"_s,
                "supportsSampleRate()"_s
            },
            {
                "bool"_s,
                "supportsSampleSize()"_s
            },
            {
                "bool"_s,
                "supportsEchoCancellation()"_s
            },
            {
                "bool"_s,
                "supportsDeviceId()"_s
            },
            {
                "bool"_s,
                "supportsGroupId()"_s
            },
            {
                "bool"_s,
                "supportsDisplaySurface()"_s
            },
            {
                "bool"_s,
                "supportsLogicalSurface()"_s
            },
            {
                "bool"_s,
                "supportsFocusDistance()"_s
            },
            {
                "bool"_s,
                "supportsWhiteBalanceMode()"_s
            },
            {
                "bool"_s,
                "supportsZoom()"_s
            },
            {
                "bool"_s,
                "supportsTorch()"_s
            },
            {
                "bool"_s,
                "supportsBackgroundBlur()"_s
            },
            {
                "bool"_s,
                "supportsPowerEfficient()"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::RealtimeMediaSourceSettings"_s, {
            {
                "uint32_t"_s,
                "width()"_s
            },
            {
                "uint32_t"_s,
                "height()"_s
            },
            {
                "float"_s,
                "frameRate()"_s
            },
            {
                "WebCore::VideoFacingMode"_s,
                "facingMode()"_s
            },
            {
                "double"_s,
                "volume()"_s
            },
            {
                "uint32_t"_s,
                "sampleRate()"_s
            },
            {
                "uint32_t"_s,
                "sampleSize()"_s
            },
            {
                "bool"_s,
                "echoCancellation()"_s
            },
            {
                "String"_s,
                "deviceId()"_s
            },
            {
                "String"_s,
                "groupId()"_s
            },
            {
                "String"_s,
                "label()"_s
            },
            {
                "WebCore::DisplaySurfaceType"_s,
                "displaySurface()"_s
            },
            {
                "bool"_s,
                "logicalSurface()"_s
            },
            {
                "WebCore::MeteringMode"_s,
                "whiteBalanceMode()"_s
            },
            {
                "double"_s,
                "zoom()"_s
            },
            {
                "bool"_s,
                "torch()"_s
            },
            {
                "bool"_s,
                "backgroundBlur()"_s
            },
            {
                "bool"_s,
                "powerEfficient()"_s
            },
            {
                "WebCore::RealtimeMediaSourceSupportedConstraints"_s,
                "supportedConstraints()"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::CaptureDevice"_s, {
            {
                "String"_s,
                "persistentId()"_s
            },
            {
                "WebCore::CaptureDevice::DeviceType"_s,
                "type()"_s
            },
            {
                "String"_s,
                "label()"_s
            },
            {
                "String"_s,
                "groupId()"_s
            },
            {
                "bool"_s,
                "enabled()"_s
            },
            {
                "bool"_s,
                "isDefault()"_s
            },
            {
                "bool"_s,
                "isMockDevice()"_s
            },
            {
                "bool"_s,
                "isEphemeral()"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::CaptureDeviceWithCapabilities"_s, {
            {
                "WebCore::CaptureDevice"_s,
                "device"_s
            },
            {
                "WebCore::RealtimeMediaSourceCapabilities"_s,
                "capabilities"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::DoubleCapabilityRange"_s, {
            {
                "double"_s,
                "min()"_s
            },
            {
                "double"_s,
                "max()"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::LongCapabilityRange"_s, {
            {
                "int"_s,
                "min()"_s
            },
            {
                "int"_s,
                "max()"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::RealtimeMediaSourceCapabilities"_s, {
            {
                "WebCore::LongCapabilityRange"_s,
                "width()"_s
            },
            {
                "WebCore::LongCapabilityRange"_s,
                "height()"_s
            },
            {
                "WebCore::DoubleCapabilityRange"_s,
                "aspectRatio()"_s
            },
            {
                "WebCore::DoubleCapabilityRange"_s,
                "frameRate()"_s
            },
            {
                "Vector<WebCore::VideoFacingMode>"_s,
                "facingMode()"_s
            },
            {
                "WebCore::DoubleCapabilityRange"_s,
                "volume()"_s
            },
            {
                "WebCore::LongCapabilityRange"_s,
                "sampleRate()"_s
            },
            {
                "WebCore::LongCapabilityRange"_s,
                "sampleSize()"_s
            },
            {
                "WebCore::RealtimeMediaSourceCapabilities::EchoCancellation"_s,
                "echoCancellation()"_s
            },
            {
                "String"_s,
                "deviceId()"_s
            },
            {
                "String"_s,
                "groupId()"_s
            },
            {
                "WebCore::DoubleCapabilityRange"_s,
                "focusDistance()"_s
            },
            {
                "Vector<WebCore::MeteringMode>"_s,
                "whiteBalanceModes()"_s
            },
            {
                "WebCore::DoubleCapabilityRange"_s,
                "zoom()"_s
            },
            {
                "bool"_s,
                "torch()"_s
            },
            {
                "WebCore::RealtimeMediaSourceCapabilities::BackgroundBlur"_s,
                "backgroundBlur()"_s
            },
            {
                "bool"_s,
                "powerEfficient()"_s
            },
            {
                "WebCore::RealtimeMediaSourceSupportedConstraints"_s,
                "supportedConstraints()"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::RealtimeMediaSourceCenter::ValidDevices"_s, {
            {
                "Vector<WebCore::CaptureDevice>"_s,
                "audioDevices"_s
            },
            {
                "Vector<WebCore::CaptureDevice>"_s,
                "videoDevices"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
        { "WebCore::PlatformVideoColorSpace"_s, {
            {
                "std::optional<WebCore::PlatformVideoColorPrimaries>"_s,
                "primaries"_s
            },
            {
                "std::optional<WebCore::PlatformVideoTransferCharacteristics>"_s,
                "transfer"_s
            },
            {
                "std::optional<WebCore::PlatformVideoMatrixCoefficients>"_s,
                "matrix"_s
            },
            {
                "std::optional<bool>"_s,
                "fullRange"_s
            },
        } },
#if ENABLE(VIDEO)
        { "WebCore::SpatialVideoMetadata"_s, {
            {
                "WebCore::IntSize"_s,
                "size"_s
            },
            {
                "float"_s,
                "horizontalFOVDegrees"_s
            },
            {
                "float"_s,
                "baseline"_s
            },
            {
                "float"_s,
                "disparityAdjustment"_s
            },
        } },
#endif // ENABLE(VIDEO)
#if ENABLE(VIDEO)
        { "WebCore::VideoProjectionMetadata"_s, {
            {
                "WebCore::VideoProjectionMetadataKind"_s,
                "kind"_s
            },
            {
                "RefPtr<WTF::JSONImpl::Value>"_s,
                "parameters"_s
            },
        } },
#endif // ENABLE(VIDEO)
#if ENABLE(VIDEO)
        { "WebCore::PlatformTrackConfiguration"_s, {
            {
                "String"_s,
                "codec"_s
            },
        } },
#endif // ENABLE(VIDEO)
#if ENABLE(VIDEO)
        { "WebCore::PlatformAudioTrackConfiguration"_s, {
            {
                "String"_s,
                "codec"_s
            },
            {
                "uint32_t"_s,
                "sampleRate"_s
            },
            {
                "uint32_t"_s,
                "numberOfChannels"_s
            },
            {
                "uint64_t"_s,
                "bitrate"_s
            },
        } },
#endif // ENABLE(VIDEO)
#if ENABLE(VIDEO)
        { "WebCore::PlatformVideoTrackConfiguration"_s, {
            {
                "String"_s,
                "codec"_s
            },
            {
                "uint32_t"_s,
                "width"_s
            },
            {
                "uint32_t"_s,
                "height"_s
            },
            {
                "WebCore::PlatformVideoColorSpace"_s,
                "colorSpace"_s
            },
            {
                "double"_s,
                "framerate"_s
            },
            {
                "uint64_t"_s,
                "bitrate"_s
            },
            {
                "std::optional<WebCore::SpatialVideoMetadata>"_s,
                "spatialVideoMetadata"_s
            },
            {
                "std::optional<WebCore::VideoProjectionMetadata>"_s,
                "videoProjectionMetadata"_s
            },
        } },
#endif // ENABLE(VIDEO)
#if ENABLE(WEB_RTC)
        { "WebCore::RTCDataChannelInit"_s, {
            {
                "std::optional<bool>"_s,
                "ordered"_s
            },
            {
                "std::optional<unsigned short>"_s,
                "maxPacketLifeTime"_s
            },
            {
                "std::optional<unsigned short>"_s,
                "maxRetransmits"_s
            },
            {
                "String"_s,
                "protocol"_s
            },
            {
                "std::optional<bool>"_s,
                "negotiated"_s
            },
            {
                "std::optional<unsigned short>"_s,
                "id"_s
            },
            {
                "WebCore::RTCPriorityType"_s,
                "priority"_s
            },
        } },
#endif // ENABLE(WEB_RTC)
#if ENABLE(CONTENT_EXTENSIONS)
        { "WebCore::ContentRuleListResults::Result"_s, {
            {
                "bool"_s,
                "blockedLoad"_s
            },
            {
                "bool"_s,
                "madeHTTPS"_s
            },
            {
                "bool"_s,
                "blockedCookies"_s
            },
            {
                "bool"_s,
                "modifiedHeaders"_s
            },
            {
                "bool"_s,
                "redirected"_s
            },
            {
                "Vector<String>"_s,
                "notifications"_s
            },
        } },
#endif // ENABLE(CONTENT_EXTENSIONS)
#if ENABLE(CONTENT_EXTENSIONS)
        { "WebCore::ContentRuleListResults::Summary"_s, {
            {
                "bool"_s,
                "blockedLoad"_s
            },
            {
                "bool"_s,
                "madeHTTPS"_s
            },
            {
                "bool"_s,
                "blockedCookies"_s
            },
            {
                "bool"_s,
                "hasNotifications"_s
            },
            {
                "bool"_s,
                "redirectedPriorToBlock"_s
            },
        } },
#endif // ENABLE(CONTENT_EXTENSIONS)
#if ENABLE(CONTENT_EXTENSIONS)
        { "WebCore::ContentRuleListResults"_s, {
            {
                "WebCore::ContentRuleListResults::Summary"_s,
                "summary"_s
            },
            {
                "Vector<std::pair<String, WebCore::ContentRuleListResults::Result>>"_s,
                "results"_s
            },
        } },
#endif // ENABLE(CONTENT_EXTENSIONS)
        { "WebCore::COEPInheritenceViolationReportBody"_s, {
            {
                "WebCore::COEPDisposition"_s,
                "m_disposition"_s
            },
            {
                "URL"_s,
                "m_blockedURL"_s
            },
            {
                "String"_s,
                "m_type"_s
            },
        } },
        { "WebCore::CORPViolationReportBody"_s, {
            {
                "WebCore::COEPDisposition"_s,
                "m_disposition"_s
            },
            {
                "URL"_s,
                "m_blockedURL"_s
            },
            {
                "WebCore::FetchOptionsDestination"_s,
                "m_destination"_s
            },
        } },
        { "WebCore::ReportBody"_s, {
            { "Variant<"
                "WebCore::CSPViolationReportBody"
                ", WebCore::COEPInheritenceViolationReportBody"
                ", WebCore::CORPViolationReportBody"
                ", WebCore::DeprecationReportBody"
                ", WebCore::TestReportBody"
            ">"_s, "subclasses"_s }
        } },
        { "WebCore::SourceImage"_s, {
            {
                "WebCore::RenderingResourceIdentifier"_s,
                "imageIdentifier()"_s
            },
        } },
        { "WebCore::LinkIcon"_s, {
            {
                "URL"_s,
                "url"_s
            },
            {
                "WebCore::LinkIconType"_s,
                "type"_s
            },
            {
                "String"_s,
                "mimeType"_s
            },
            {
                "std::optional<unsigned>"_s,
                "size"_s
            },
            {
                "Vector<std::pair<String, String>>"_s,
                "attributes"_s
            },
        } },
        { "WebCore::SupportedPluginIdentifier"_s, {
            {
                "String"_s,
                "matchingDomain"_s
            },
            {
                "String"_s,
                "pluginIdentifier"_s
            },
        } },
        { "WebCore::CSSValueKey"_s, {
            {
                "unsigned"_s,
                "cssValueID"_s
            },
            {
                "bool"_s,
                "useDarkAppearance"_s
            },
            {
                "bool"_s,
                "useElevatedUserInterfaceLevel"_s
            },
        } },
        { "WebCore::VideoFrameTimeMetadata"_s, {
            {
                "std::optional<double>"_s,
                "processingDuration"_s
            },
            {
                "std::optional<Seconds>"_s,
                "captureTime"_s
            },
            {
                "std::optional<Seconds>"_s,
                "receiveTime"_s
            },
            {
                "std::optional<unsigned>"_s,
                "rtpTimestamp"_s
            },
        } },
        { "WebCore::EventRegion"_s, {
            {
                "WebCore::Region"_s,
                "m_region"_s
            },
#if ENABLE(TOUCH_ACTION_REGIONS)
            {
                "Vector<WebCore::Region>"_s,
                "m_touchActionRegions"_s
            },
#endif
#if ENABLE(WHEEL_EVENT_REGIONS)
            {
                "WebCore::Region"_s,
                "m_wheelEventListenerRegion"_s
            },
#endif
#if ENABLE(WHEEL_EVENT_REGIONS)
            {
                "WebCore::Region"_s,
                "m_nonPassiveWheelEventListenerRegion"_s
            },
#endif
#if ENABLE(TOUCH_EVENT_REGIONS)
            {
                "WebCore::EventTrackingRegions"_s,
                "m_touchEventListenerRegion"_s
            },
#endif
#if ENABLE(EDITABLE_REGION)
            {
                "std::optional<WebCore::Region>"_s,
                "m_editableRegion"_s
            },
#endif
#if ENABLE(INTERACTION_REGIONS_IN_EVENT_REGION)
            {
                "Vector<WebCore::InteractionRegion>"_s,
                "m_interactionRegions"_s
            },
#endif
        } },
        { "WebCore::PresentationSize"_s, {
            {
                "std::optional<double>"_s,
                "width"_s
            },
            {
                "std::optional<double>"_s,
                "height"_s
            },
        } },
        { "WebCore::PasteboardItemInfo"_s, {
            {
                "Vector<String>"_s,
                "pathsForFileUpload"_s
            },
            {
                "Vector<String>"_s,
                "platformTypesForFileUpload"_s
            },
            {
                "Vector<String>"_s,
                "platformTypesByFidelity"_s
            },
            {
                "String"_s,
                "suggestedFileName"_s
            },
            {
                "WebCore::PresentationSize"_s,
                "preferredPresentationSize"_s
            },
            {
                "bool"_s,
                "isNonTextType"_s
            },
            {
                "bool"_s,
                "containsFileURLAndFileUploadContent"_s
            },
            {
                "Vector<String>"_s,
                "webSafeTypesByFidelity"_s
            },
            {
                "WebCore::PasteboardItemPresentationStyle"_s,
                "preferredPresentationStyle"_s
            },
        } },
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS) && USE(UICONTEXTMENU)
        { "WebCore::MediaControlsContextMenuItem"_s, {
            {
                "uint64_t"_s,
                "id"_s
            },
            {
                "String"_s,
                "title"_s
            },
            {
                "String"_s,
                "icon"_s
            },
            {
                "bool"_s,
                "checked"_s
            },
            {
                "Vector<WebCore::MediaControlsContextMenuItem>"_s,
                "children"_s
            },
        } },
#endif // ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS) && USE(UICONTEXTMENU)
        { "WebCore::WorkerOptions"_s, {
            {
                "WebCore::WorkerType"_s,
                "type"_s
            },
            {
                "WebCore::FetchOptionsCredentials"_s,
                "credentials"_s
            },
            {
                "String"_s,
                "name"_s
            },
        } },
        { "WebCore::WorkerInitializationData"_s, {
            {
                "std::optional<WebCore::ServiceWorkerData>"_s,
                "serviceWorkerData"_s
            },
            {
                "std::optional<WebCore::ScriptExecutionContextIdentifier>"_s,
                "clientIdentifier"_s
            },
            {
                "OptionSet<WebCore::AdvancedPrivacyProtections>"_s,
                "advancedPrivacyProtections"_s
            },
            {
                "String"_s,
                "userAgent"_s
            },
        } },
        { "WebCore::WorkerFetchResult"_s, {
            {
                "WebCore::ScriptBuffer"_s,
                "script"_s
            },
            {
                "URL"_s,
                "responseURL"_s
            },
            {
                "WebCore::CertificateInfo"_s,
                "certificateInfo"_s
            },
            {
                "WebCore::ContentSecurityPolicyResponseHeaders"_s,
                "contentSecurityPolicy"_s
            },
            {
                "WebCore::CrossOriginEmbedderPolicy"_s,
                "crossOriginEmbedderPolicy"_s
            },
            {
                "String"_s,
                "referrerPolicy"_s
            },
            {
                "WebCore::ResourceError"_s,
                "error"_s
            },
        } },
        { "WebCore::SharedWorkerKey"_s, {
            {
                "WebCore::ClientOrigin"_s,
                "origin"_s
            },
            {
                "URL"_s,
                "url"_s
            },
            {
                "String"_s,
                "name"_s
            },
        } },
        { "WebCore::ServiceWorkerRegistrationOptions"_s, {
            {
                "String"_s,
                "scope"_s
            },
            {
                "WebCore::WorkerType"_s,
                "type"_s
            },
            {
                "WebCore::ServiceWorkerUpdateViaCache"_s,
                "updateViaCache"_s
            },
        } },
        { "WebCore::ServiceWorkerRegistrationKey"_s, {
            {
                "WebCore::SecurityOriginData"_s,
                "topOrigin()"_s
            },
            {
                "URL"_s,
                "scope()"_s
            },
        } },
        { "WebCore::ServiceWorkerRegistrationData"_s, {
            {
                "WebCore::ServiceWorkerRegistrationKey"_s,
                "key"_s
            },
            {
                "WebCore::ServiceWorkerRegistrationIdentifier"_s,
                "identifier"_s
            },
            {
                "URL"_s,
                "scopeURL"_s
            },
            {
                "WebCore::ServiceWorkerUpdateViaCache"_s,
                "updateViaCache"_s
            },
            {
                "WallTime"_s,
                "lastUpdateTime"_s
            },
            {
                "std::optional<WebCore::ServiceWorkerData>"_s,
                "installingWorker"_s
            },
            {
                "std::optional<WebCore::ServiceWorkerData>"_s,
                "waitingWorker"_s
            },
            {
                "std::optional<WebCore::ServiceWorkerData>"_s,
                "activeWorker"_s
            },
        } },
        { "WebCore::ServiceWorkerJobDataIdentifier"_s, {
            {
                "WebCore::SWServerConnectionIdentifier"_s,
                "connectionIdentifier"_s
            },
            {
                "WebCore::ServiceWorkerJobIdentifier"_s,
                "jobIdentifier"_s
            },
        } },
        { "WebCore::ServiceWorkerImportedScript"_s, {
            {
                "WebCore::ScriptBuffer"_s,
                "script"_s
            },
            {
                "URL"_s,
                "responseURL"_s
            },
            {
                "String"_s,
                "mimeType"_s
            },
        } },
#if ENABLE(SHAREABLE_RESOURCE) && PLATFORM(COCOA)
        { "WebCore::ScriptBuffer"_s, {
            {
                "Variant<WebCore::ShareableResourceHandle, RefPtr<WebCore::FragmentedSharedBuffer>>"_s,
                "ipcData()"_s
            },
        } },
#endif // ENABLE(SHAREABLE_RESOURCE) && PLATFORM(COCOA)
#if !ENABLE(SHAREABLE_RESOURCE) || !PLATFORM(COCOA)
        { "WebCore::ScriptBuffer"_s, {
            {
                "RefPtr<WebCore::FragmentedSharedBuffer>"_s,
                "ipcData()"_s
            },
        } },
#endif // !ENABLE(SHAREABLE_RESOURCE) || !PLATFORM(COCOA)
        { "WebCore::ServiceWorkerContextData"_s, {
            {
                "std::optional<WebCore::ServiceWorkerJobDataIdentifier>"_s,
                "jobDataIdentifier"_s
            },
            {
                "WebCore::ServiceWorkerRegistrationData"_s,
                "registration"_s
            },
            {
                "WebCore::ServiceWorkerIdentifier"_s,
                "serviceWorkerIdentifier"_s
            },
            {
                "WebCore::ScriptBuffer"_s,
                "script"_s
            },
            {
                "WebCore::CertificateInfo"_s,
                "certificateInfo"_s
            },
            {
                "WebCore::ContentSecurityPolicyResponseHeaders"_s,
                "contentSecurityPolicy"_s
            },
            {
                "WebCore::CrossOriginEmbedderPolicy"_s,
                "crossOriginEmbedderPolicy"_s
            },
            {
                "String"_s,
                "referrerPolicy"_s
            },
            {
                "URL"_s,
                "scriptURL"_s
            },
            {
                "WebCore::WorkerType"_s,
                "workerType"_s
            },
            {
                "bool"_s,
                "loadedFromDisk"_s
            },
            {
                "std::optional<WebCore::LastNavigationWasAppInitiated>"_s,
                "lastNavigationWasAppInitiated"_s
            },
            {
                "MemoryCompactRobinHoodHashMap<URL, WebCore::ServiceWorkerImportedScript>"_s,
                "scriptResourceMap"_s
            },
            {
                "std::optional<WebCore::ScriptExecutionContextIdentifier>"_s,
                "serviceWorkerPageIdentifier"_s
            },
            {
                "WebCore::NavigationPreloadState"_s,
                "navigationPreloadState"_s
            },
        } },
        { "JSC::ArrayBuffer"_s, {
            {
                "Vector<uint8_t>"_s,
                "toVector()"_s
            },
        } },
        { "JSC::ArrayBufferContents"_s, {
            {
                "std::span<const uint8_t>"_s,
                "span()"_s
            },
        } },
        { "WebCore::GlobalFrameIdentifier"_s, {
            {
                "WebCore::PageIdentifier"_s,
                "pageID"_s
            },
            {
                "WebCore::FrameIdentifier"_s,
                "frameID"_s
            },
        } },
        { "WebCore::GlobalWindowIdentifier"_s, {
            {
                "WebCore::ProcessIdentifier"_s,
                "processIdentifier"_s
            },
            {
                "WebCore::WindowIdentifier"_s,
                "windowIdentifier"_s
            },
        } },
        { "WebCore::InteractionRegion"_s, {
            {
                "WebCore::InteractionRegion::Type"_s,
                "type"_s
            },
            {
                "WebCore::NodeIdentifier"_s,
                "nodeIdentifier"_s
            },
            {
                "WebCore::FloatRect"_s,
                "rectInLayerCoordinates"_s
            },
            {
                "float"_s,
                "cornerRadius"_s
            },
            {
                "OptionSet<WebCore::InteractionRegion::CornerMask>"_s,
                "maskedCorners"_s
            },
            {
                "WebCore::InteractionRegion::ContentHint"_s,
                "contentHint"_s
            },
            {
                "std::optional<WebCore::Path>"_s,
                "clipPath"_s
            },
            {
                "bool"_s,
                "useContinuousCorners"_s
            },
#if ENABLE(INTERACTION_REGION_TEXT_CONTENT)
            {
                "String"_s,
                "text"_s
            },
#endif
        } },
        { "WebCore::Region::Span"_s, {
            {
                "int"_s,
                "y"_s
            },
            {
                "uint64_t"_s,
                "segmentIndex"_s
            },
        } },
        { "WebCore::Region::Shape"_s, {
            {
                "Vector<int, 32>"_s,
                "m_segments"_s
            },
            {
                "Vector<WebCore::Region::Span, 16>"_s,
                "m_spans"_s
            },
        } },
        { "WebCore::Region"_s, {
            {
                "WebCore::Region::Shape"_s,
                "data()"_s
            },
        } },
        { "WebCore::ISOWebVTTCue"_s, {
            {
                "MediaTime"_s,
                "presentationTime()"_s
            },
            {
                "MediaTime"_s,
                "duration()"_s
            },
            {
                "AtomString"_s,
                "id()"_s
            },
            {
                "String"_s,
                "cueText()"_s
            },
            {
                "String"_s,
                "settings()"_s
            },
            {
                "String"_s,
                "sourceID()"_s
            },
            {
                "String"_s,
                "originalStartTime()"_s
            },
        } },
#if ENABLE(WEB_AUTHN)
        { "WebCore::MockWebAuthenticationConfiguration::LocalConfiguration"_s, {
            {
                "WebCore::MockWebAuthenticationConfiguration::UserVerification"_s,
                "userVerification"_s
            },
            {
                "bool"_s,
                "acceptAttestation"_s
            },
            {
                "String"_s,
                "privateKeyBase64"_s
            },
            {
                "String"_s,
                "userCertificateBase64"_s
            },
            {
                "String"_s,
                "intermediateCACertificateBase64"_s
            },
            {
                "String"_s,
                "preferredCredentialIdBase64"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::MockWebAuthenticationConfiguration::HidConfiguration"_s, {
            {
                "Vector<String>"_s,
                "payloadBase64"_s
            },
            {
                "WebCore::MockWebAuthenticationConfiguration::HidStage"_s,
                "stage"_s
            },
            {
                "WebCore::MockWebAuthenticationConfiguration::HidSubStage"_s,
                "subStage"_s
            },
            {
                "WebCore::MockWebAuthenticationConfiguration::HidError"_s,
                "error"_s
            },
            {
                "bool"_s,
                "isU2f"_s
            },
            {
                "bool"_s,
                "keepAlive"_s
            },
            {
                "bool"_s,
                "fastDataArrival"_s
            },
            {
                "bool"_s,
                "continueAfterErrorData"_s
            },
            {
                "bool"_s,
                "canDowngrade"_s
            },
            {
                "bool"_s,
                "expectCancel"_s
            },
            {
                "bool"_s,
                "supportClientPin"_s
            },
            {
                "bool"_s,
                "supportInternalUV"_s
            },
            {
                "int64_t"_s,
                "maxCredentialCountInList"_s
            },
            {
                "int64_t"_s,
                "maxCredentialIdLength"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::MockWebAuthenticationConfiguration::NfcConfiguration"_s, {
            {
                "WebCore::MockWebAuthenticationConfiguration::NfcError"_s,
                "error"_s
            },
            {
                "Vector<String>"_s,
                "payloadBase64"_s
            },
            {
                "bool"_s,
                "multipleTags"_s
            },
            {
                "bool"_s,
                "multiplePhysicalTags"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::MockWebAuthenticationConfiguration::CcidConfiguration"_s, {
            {
                "Vector<String>"_s,
                "payloadBase64"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if ENABLE(WEB_AUTHN)
        { "WebCore::MockWebAuthenticationConfiguration"_s, {
            {
                "bool"_s,
                "silentFailure"_s
            },
            {
                "std::optional<WebCore::MockWebAuthenticationConfiguration::LocalConfiguration>"_s,
                "local"_s
            },
            {
                "std::optional<WebCore::MockWebAuthenticationConfiguration::HidConfiguration>"_s,
                "hid"_s
            },
            {
                "std::optional<WebCore::MockWebAuthenticationConfiguration::NfcConfiguration>"_s,
                "nfc"_s
            },
            {
                "std::optional<WebCore::MockWebAuthenticationConfiguration::CcidConfiguration>"_s,
                "ccid"_s
            },
        } },
#endif // ENABLE(WEB_AUTHN)
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
        { "WebCore::OpenID4VPRequest"_s, {
        } },
#endif // (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
        { "WebCore::ISO18013ElementInfo"_s, {
            {
                "bool"_s,
                "isRetaining"_s
            },
        } },
#endif // (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
        { "WebCore::ISO18013DocumentRequest"_s, {
            {
                "String"_s,
                "documentType"_s
            },
            {
                "Vector<std::pair<String, Vector<std::pair<String, WebCore::ISO18013ElementInfo>>>>"_s,
                "namespaces"_s
            },
        } },
#endif // (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
        { "WebCore::ISO18013DocumentRequestSet"_s, {
            {
                "Vector<WebCore::ISO18013DocumentRequest>"_s,
                "requests"_s
            },
        } },
#endif // (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
        { "WebCore::ISO18013PresentmentRequest"_s, {
            {
                "bool"_s,
                "isMandatory"_s
            },
            {
                "Vector<WebCore::ISO18013DocumentRequestSet>"_s,
                "documentRequestSets"_s
            },
        } },
#endif // (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
        { "WebCore::MobileDocumentRequest"_s, {
            {
                "String"_s,
                "deviceRequest"_s
            },
            {
                "String"_s,
                "encryptionInfo"_s
            },
        } },
#endif // (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
        { "WebCore::ValidatedMobileDocumentRequest"_s, {
            {
                "Vector<WebCore::CertificateInfo>"_s,
                "requestAuthentications"_s
            },
            {
                "Vector<WebCore::ISO18013PresentmentRequest>"_s,
                "presentmentRequests"_s
            },
        } },
#endif // (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
        { "WebCore::DigitalCredentialsRequestData"_s, {
            {
                "Vector<Variant<WebCore::ValidatedMobileDocumentRequest, WebCore::OpenID4VPRequest>>"_s,
                "requests"_s
            },
            {
                "WebCore::SecurityOriginData"_s,
                "topOrigin"_s
            },
            {
                "WebCore::SecurityOriginData"_s,
                "documentOrigin"_s
            },
        } },
#endif // (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
        { "WebCore::DigitalCredentialsResponseData"_s, {
            {
                "WebCore::IdentityCredentialProtocol"_s,
                "protocol"_s
            },
            {
                "String"_s,
                "responseDataJSON"_s
            },
        } },
#endif // (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MockMicrophoneProperties"_s, {
            {
                "int"_s,
                "defaultSampleRate"_s
            },
            {
                "std::optional<bool>"_s,
                "echoCancellation"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MockSpeakerProperties"_s, {
            {
                "String"_s,
                "relatedMicrophoneId"_s
            },
            {
                "int"_s,
                "defaultSampleRate"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MockCameraProperties"_s, {
            {
                "double"_s,
                "defaultFrameRate"_s
            },
            {
                "WebCore::VideoFacingMode"_s,
                "facingMode"_s
            },
            {
                "Vector<WebCore::VideoPresetData>"_s,
                "presets"_s
            },
            {
                "WebCore::Color"_s,
                "fillColor"_s
            },
            {
                "Vector<WebCore::MeteringMode>"_s,
                "whiteBalanceMode"_s
            },
            {
                "bool"_s,
                "hasTorch"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MockDisplayProperties"_s, {
            {
                "WebCore::CaptureDevice::DeviceType"_s,
                "type"_s
            },
            {
                "WebCore::Color"_s,
                "fillColor"_s
            },
            {
                "WebCore::IntSize"_s,
                "defaultSize"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MockMediaDevice"_s, {
            {
                "String"_s,
                "persistentId"_s
            },
            {
                "String"_s,
                "label"_s
            },
            {
                "OptionSet<WebCore::MockMediaDevice::Flag>"_s,
                "flags"_s
            },
            {
                "bool"_s,
                "isDefault"_s
            },
            {
                "Variant<WebCore::MockMicrophoneProperties, WebCore::MockSpeakerProperties, WebCore::MockCameraProperties, WebCore::MockDisplayProperties>"_s,
                "properties"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::Constant<WebCore::CSSValueAuto>"_s, {
        } },
#endif // ENABLE(THREADED_ANIMATION_RESOLUTION)
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::Style::OffsetRotate"_s, {
            {
                "std::optional<WebCore::CSS::Keyword::Auto>"_s,
                "autoKeyword()"_s
            },
            {
                "WebCore::Style::AngleAllFloat"_s,
                "angle()"_s
            },
        } },
#endif // ENABLE(THREADED_ANIMATION_RESOLUTION)
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::AcceleratedEffectValues"_s, {
            {
                "float"_s,
                "opacity"_s
            },
            {
                "std::optional<WebCore::TransformOperationData>"_s,
                "transformOperationData"_s
            },
            {
                "WebCore::LengthPoint"_s,
                "transformOrigin"_s
            },
            {
                "WebCore::TransformBox"_s,
                "transformBox"_s
            },
            {
                "WebCore::TransformOperations"_s,
                "transform"_s
            },
            {
                "RefPtr<WebCore::TransformOperation>"_s,
                "translate"_s
            },
            {
                "RefPtr<WebCore::TransformOperation>"_s,
                "scale"_s
            },
            {
                "RefPtr<WebCore::TransformOperation>"_s,
                "rotate"_s
            },
            {
                "RefPtr<WebCore::PathOperation>"_s,
                "offsetPath"_s
            },
            {
                "WebCore::Length"_s,
                "offsetDistance"_s
            },
            {
                "WebCore::LengthPoint"_s,
                "offsetPosition"_s
            },
            {
                "WebCore::LengthPoint"_s,
                "offsetAnchor"_s
            },
            {
                "WebCore::Style::OffsetRotate"_s,
                "offsetRotate"_s
            },
            {
                "WebCore::FilterOperations"_s,
                "filter"_s
            },
            {
                "WebCore::FilterOperations"_s,
                "backdropFilter"_s
            },
        } },
#endif // ENABLE(THREADED_ANIMATION_RESOLUTION)
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::WebAnimationTime"_s, {
            {
                "std::optional<Seconds>"_s,
                "time()"_s
            },
            {
                "std::optional<double>"_s,
                "percentage()"_s
            },
        } },
#endif // ENABLE(THREADED_ANIMATION_RESOLUTION)
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::AnimationEffectTiming"_s, {
            {
                "RefPtr<WebCore::TimingFunction>"_s,
                "timingFunction"_s
            },
            {
                "WebCore::FillMode"_s,
                "fill"_s
            },
            {
                "WebCore::PlaybackDirection"_s,
                "direction"_s
            },
            {
                "double"_s,
                "iterationStart"_s
            },
            {
                "double"_s,
                "iterations"_s
            },
            {
                "WebCore::WebAnimationTime"_s,
                "startDelay"_s
            },
            {
                "WebCore::WebAnimationTime"_s,
                "endDelay"_s
            },
            {
                "WebCore::WebAnimationTime"_s,
                "iterationDuration"_s
            },
            {
                "WebCore::WebAnimationTime"_s,
                "intrinsicIterationDuration"_s
            },
            {
                "WebCore::WebAnimationTime"_s,
                "activeDuration"_s
            },
            {
                "WebCore::WebAnimationTime"_s,
                "endTime"_s
            },
        } },
#endif // ENABLE(THREADED_ANIMATION_RESOLUTION)
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::AcceleratedEffect::Keyframe"_s, {
            {
                "double"_s,
                "offset()"_s
            },
            {
                "WebCore::AcceleratedEffectValues"_s,
                "values()"_s
            },
            {
                "RefPtr<WebCore::TimingFunction>"_s,
                "timingFunction()"_s
            },
            {
                "std::optional<WebCore::CompositeOperation>"_s,
                "compositeOperation()"_s
            },
            {
                "OptionSet<WebCore::AcceleratedEffectProperty>"_s,
                "animatedProperties()"_s
            },
        } },
#endif // ENABLE(THREADED_ANIMATION_RESOLUTION)
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::AcceleratedEffect"_s, {
            {
                "WebCore::AnimationEffectTiming"_s,
                "timing()"_s
            },
            {
                "Vector<WebCore::AcceleratedEffect::Keyframe>"_s,
                "keyframes()"_s
            },
            {
                "WebCore::WebAnimationType"_s,
                "animationType()"_s
            },
            {
                "WebCore::CompositeOperation"_s,
                "compositeOperation()"_s
            },
            {
                "RefPtr<WebCore::TimingFunction>"_s,
                "defaultKeyframeTimingFunction()"_s
            },
            {
                "OptionSet<WebCore::AcceleratedEffectProperty>"_s,
                "animatedProperties()"_s
            },
            {
                "bool"_s,
                "paused()"_s
            },
            {
                "double"_s,
                "playbackRate()"_s
            },
            {
                "std::optional<WebCore::WebAnimationTime>"_s,
                "startTime()"_s
            },
            {
                "std::optional<WebCore::WebAnimationTime>"_s,
                "holdTime()"_s
            },
        } },
#endif // ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::ProtectionSpace"_s, {
            {
                "String"_s,
                "host()"_s
            },
            {
                "int"_s,
                "port()"_s
            },
            {
                "WebCore::ProtectionSpace::ServerType"_s,
                "serverType()"_s
            },
            {
                "String"_s,
                "realm()"_s
            },
            {
                "WebCore::ProtectionSpace::AuthenticationScheme"_s,
                "authenticationScheme()"_s
            },
#if USE(CURL)
            {
                "WebCore::CertificateInfo"_s,
                "certificateInfo()"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "std::optional<WebCore::ProtectionSpace::PlatformData>"_s,
                "getPlatformDataToSerialize()"_s
            },
#endif
        } },
        { "WebCore::Credential::NonPlatformData"_s, {
            {
                "String"_s,
                "user"_s
            },
            {
                "String"_s,
                "password"_s
            },
            {
                "WebCore::CredentialPersistence"_s,
                "persistence"_s
            },
        } },
#if PLATFORM(COCOA)
        { "WebCore::Credential"_s, {
            {
                "Variant<WebCore::Credential::NonPlatformData, RetainPtr<NSURLCredential>>"_s,
                "ipcData()"_s
            },
        } },
#endif // PLATFORM(COCOA)
#if USE(SOUP)
        { "WebCore::Credential::PlatformData"_s, {
            {
                "GRefPtr<GTlsCertificate>"_s,
                "certificate"_s
            },
            {
                "WebCore::CredentialPersistence"_s,
                "persistence"_s
            },
        } },
#endif // USE(SOUP)
#if USE(SOUP)
        { "WebCore::Credential"_s, {
            {
                "Variant<WebCore::Credential::NonPlatformData, WebCore::Credential::PlatformData>"_s,
                "ipcData()"_s
            },
        } },
#endif // USE(SOUP)
#if USE(CURL)
        { "WebCore::Credential"_s, {
            {
                "WebCore::Credential::NonPlatformData"_s,
                "nonPlatformData()"_s
            },
        } },
#endif // USE(CURL)
#if ENABLE(GPU_PROCESS)
        { "WebCore::ShapeDetection::BarcodeDetectorOptions"_s, {
            {
                "Vector<WebCore::ShapeDetection::BarcodeFormat>"_s,
                "formats"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebCore::ShapeDetection::DetectedBarcode"_s, {
            {
                "WebCore::FloatRect"_s,
                "boundingBox"_s
            },
            {
                "String"_s,
                "rawValue"_s
            },
            {
                "WebCore::ShapeDetection::BarcodeFormat"_s,
                "format"_s
            },
            {
                "Vector<WebCore::FloatPoint>"_s,
                "cornerPoints"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebCore::ShapeDetection::DetectedFace"_s, {
            {
                "WebCore::FloatRect"_s,
                "boundingBox"_s
            },
            {
                "std::optional<Vector<WebCore::ShapeDetection::Landmark>>"_s,
                "landmarks"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebCore::ShapeDetection::DetectedText"_s, {
            {
                "WebCore::FloatRect"_s,
                "boundingBox"_s
            },
            {
                "String"_s,
                "rawValue"_s
            },
            {
                "Vector<WebCore::FloatPoint>"_s,
                "cornerPoints"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebCore::ShapeDetection::FaceDetectorOptions"_s, {
            {
                "uint16_t"_s,
                "maxDetectedFaces"_s
            },
            {
                "bool"_s,
                "fastMode"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebCore::ShapeDetection::Landmark"_s, {
            {
                "Vector<WebCore::FloatPoint>"_s,
                "locations"_s
            },
            {
                "WebCore::ShapeDetection::LandmarkType"_s,
                "type"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
        { "WebCore::TextExtraction::Editable"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "String"_s,
                "placeholder"_s
            },
            {
                "bool"_s,
                "isSecure"_s
            },
            {
                "bool"_s,
                "isFocused"_s
            },
        } },
        { "WebCore::TextExtraction::TextItemData"_s, {
            {
                "Vector<std::pair<URL, WebCore::CharacterRange>>"_s,
                "links"_s
            },
            {
                "std::optional<WebCore::CharacterRange>"_s,
                "selectedRange"_s
            },
            {
                "String"_s,
                "content"_s
            },
            {
                "std::optional<WebCore::TextExtraction::Editable>"_s,
                "editable"_s
            },
        } },
        { "WebCore::TextExtraction::ScrollableItemData"_s, {
            {
                "WebCore::FloatSize"_s,
                "contentSize"_s
            },
        } },
        { "WebCore::TextExtraction::ImageItemData"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "String"_s,
                "altText"_s
            },
        } },
        { "WebCore::TextExtraction::Item"_s, {
            {
                "Variant<WebCore::TextExtraction::ContainerType, WebCore::TextExtraction::TextItemData, WebCore::TextExtraction::ScrollableItemData, WebCore::TextExtraction::ImageItemData>"_s,
                "data"_s
            },
            {
                "WebCore::FloatRect"_s,
                "rectInRootView"_s
            },
            {
                "Vector<WebCore::TextExtraction::Item>"_s,
                "children"_s
            },
        } },
#if ENABLE(WRITING_TOOLS)
        { "WebCore::WritingTools::Session"_s, {
            {
                "WebCore::WritingTools::SessionID"_s,
                "identifier"_s
            },
            {
                "WebCore::WritingTools::SessionType"_s,
                "type"_s
            },
            {
                "WebCore::WritingTools::SessionCompositionType"_s,
                "compositionType"_s
            },
        } },
#endif // ENABLE(WRITING_TOOLS)
#if ENABLE(WRITING_TOOLS)
        { "WebCore::WritingTools::Context"_s, {
            {
                "Markable<WebCore::WritingTools::ContextID>"_s,
                "identifier"_s
            },
            {
                "WebCore::AttributedString"_s,
                "attributedText"_s
            },
            {
                "WebCore::CharacterRange"_s,
                "range"_s
            },
        } },
#endif // ENABLE(WRITING_TOOLS)
#if ENABLE(WRITING_TOOLS)
        { "WebCore::WritingTools::TextSuggestion"_s, {
            {
                "WebCore::WritingTools::TextSuggestionID"_s,
                "identifier"_s
            },
            {
                "WebCore::CharacterRange"_s,
                "originalRange"_s
            },
            {
                "String"_s,
                "replacement"_s
            },
            {
                "WebCore::WritingTools::TextSuggestionState"_s,
                "state"_s
            },
        } },
#endif // ENABLE(WRITING_TOOLS)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::CaptureSourceError"_s, {
            {
                "String"_s,
                "errorMessage"_s
            },
            {
                "WebCore::MediaAccessDenialReason"_s,
                "denialReason"_s
            },
            {
                "WebCore::MediaConstraintType"_s,
                "invalidConstraint"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MediaSettingsRange"_s, {
            {
                "std::optional<double>"_s,
                "max"_s
            },
            {
                "std::optional<double>"_s,
                "min"_s
            },
            {
                "std::optional<double>"_s,
                "step"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::PhotoCapabilities"_s, {
            {
                "std::optional<WebCore::RedEyeReduction>"_s,
                "redEyeReduction"_s
            },
            {
                "std::optional<WebCore::MediaSettingsRange>"_s,
                "imageHeight"_s
            },
            {
                "std::optional<WebCore::MediaSettingsRange>"_s,
                "imageWidth"_s
            },
            {
                "std::optional<Vector<WebCore::FillLightMode>>"_s,
                "fillLightMode"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MEDIA_STREAM)
        { "WebCore::PhotoSettings"_s, {
            {
                "std::optional<WebCore::FillLightMode>"_s,
                "fillLightMode"_s
            },
            {
                "std::optional<double>"_s,
                "imageHeight"_s
            },
            {
                "std::optional<double>"_s,
                "imageWidth"_s
            },
            {
                "std::optional<bool>"_s,
                "redEyeReduction"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
        { "WebCore::CookieStoreGetOptions"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "String"_s,
                "url"_s
            },
        } },
        { "WebCore::CookieChangeSubscription"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "String"_s,
                "url"_s
            },
        } },
        { "WebCore::Model"_s, {
            {
                "Ref<WebCore::SharedBuffer>"_s,
                "data()"_s
            },
            {
                "String"_s,
                "mimeType()"_s
            },
            {
                "URL"_s,
                "url()"_s
            },
        } },
        { "WebCore::ModelPlayerAnimationState"_s, {
            {
                "bool"_s,
                "autoplay()"_s
            },
            {
                "bool"_s,
                "loop()"_s
            },
            {
                "bool"_s,
                "paused()"_s
            },
            {
                "Seconds"_s,
                "duration()"_s
            },
            {
                "std::optional<double>"_s,
                "effectivePlaybackRate()"_s
            },
            {
                "std::optional<Seconds>"_s,
                "lastCachedCurrentTime()"_s
            },
            {
                "std::optional<MonotonicTime>"_s,
                "lastCachedClockTimestamp()"_s
            },
        } },
#if ENABLE(MODEL_PROCESS)
        { "WebCore::ModelContext"_s, {
            {
                "WebCore::PlatformLayerIdentifier"_s,
                "modelLayerIdentifier()"_s
            },
            {
                "WebCore::LayerHostingContextIdentifier"_s,
                "modelContentsLayerHostingContextIdentifier()"_s
            },
            {
                "WebCore::LayoutSize"_s,
                "modelLayoutSize()"_s
            },
            {
                "WebCore::ModelContextDisablePortal"_s,
                "disablePortal()"_s
            },
            {
                "std::optional<WebCore::Color>"_s,
                "backgroundColor()"_s
            },
        } },
#endif // ENABLE(MODEL_PROCESS)
#if PLATFORM(IOS_FAMILY)
        { "WebCore::InspectorOverlayLabel::Content::Decoration"_s, {
            {
                "WebCore::InspectorOverlayLabel::Content::Decoration::Type"_s,
                "type"_s
            },
            {
                "WebCore::Color"_s,
                "color"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
#if PLATFORM(IOS_FAMILY)
        { "WebCore::InspectorOverlayLabel::Content"_s, {
            {
                "String"_s,
                "text"_s
            },
            {
                "WebCore::Color"_s,
                "textColor"_s
            },
            {
                "WebCore::InspectorOverlayLabel::Content::Decoration"_s,
                "decoration"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
#if PLATFORM(IOS_FAMILY)
        { "WebCore::InspectorOverlayLabel::Arrow"_s, {
            {
                "WebCore::InspectorOverlayLabel::Arrow::Direction"_s,
                "direction"_s
            },
            {
                "WebCore::InspectorOverlayLabel::Arrow::Alignment"_s,
                "alignment"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
#if PLATFORM(IOS_FAMILY)
        { "WebCore::InspectorOverlayLabel"_s, {
            {
                "Vector<WebCore::InspectorOverlayLabel::Content>"_s,
                "m_contents"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "m_location"_s
            },
            {
                "WebCore::Color"_s,
                "m_backgroundColor"_s
            },
            {
                "WebCore::InspectorOverlayLabel::Arrow"_s,
                "m_arrow"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
#if PLATFORM(IOS_FAMILY)
        { "WebCore::InspectorOverlayHighlight::FlexHighlightOverlay"_s, {
            {
                "WebCore::Color"_s,
                "color"_s
            },
            {
                "WebCore::FloatQuad"_s,
                "containerBounds"_s
            },
            {
                "Vector<WebCore::FloatQuad>"_s,
                "itemBounds"_s
            },
            {
                "Vector<WebCore::FloatQuad>"_s,
                "mainAxisGaps"_s
            },
            {
                "Vector<WebCore::FloatQuad>"_s,
                "mainAxisSpaceBetweenItemsAndGaps"_s
            },
            {
                "Vector<WebCore::FloatQuad>"_s,
                "spaceBetweenItemsAndCrossAxisSpace"_s
            },
            {
                "Vector<WebCore::FloatQuad>"_s,
                "crossAxisGaps"_s
            },
            {
                "Vector<WebCore::InspectorOverlayLabel>"_s,
                "labels"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
#if PLATFORM(IOS_FAMILY)
        { "WebCore::InspectorOverlayHighlight::GridHighlightOverlay::Area"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "WebCore::FloatQuad"_s,
                "quad"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
#if PLATFORM(IOS_FAMILY)
        { "WebCore::InspectorOverlayHighlight::GridHighlightOverlay"_s, {
            {
                "WebCore::Color"_s,
                "color"_s
            },
            {
                "Vector<WebCore::FloatLine>"_s,
                "gridLines"_s
            },
            {
                "Vector<WebCore::FloatQuad>"_s,
                "gaps"_s
            },
            {
                "Vector<WebCore::InspectorOverlayHighlight::GridHighlightOverlay::Area>"_s,
                "areas"_s
            },
            {
                "Vector<WebCore::InspectorOverlayLabel>"_s,
                "labels"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
#if PLATFORM(IOS_FAMILY)
        { "WebCore::InspectorOverlayHighlight"_s, {
            {
                "WebCore::Color"_s,
                "contentColor"_s
            },
            {
                "WebCore::Color"_s,
                "contentOutlineColor"_s
            },
            {
                "WebCore::Color"_s,
                "paddingColor"_s
            },
            {
                "WebCore::Color"_s,
                "borderColor"_s
            },
            {
                "WebCore::Color"_s,
                "marginColor"_s
            },
            {
                "WebCore::InspectorOverlayHighlight::Type"_s,
                "type"_s
            },
            {
                "Vector<WebCore::FloatQuad>"_s,
                "quads"_s
            },
            {
                "Vector<WebCore::InspectorOverlayHighlight::GridHighlightOverlay>"_s,
                "gridHighlightOverlays"_s
            },
            {
                "Vector<WebCore::InspectorOverlayHighlight::FlexHighlightOverlay>"_s,
                "flexHighlightOverlays"_s
            },
            {
                "bool"_s,
                "usePageCoordinates"_s
            },
        } },
#endif // PLATFORM(IOS_FAMILY)
        { "WebCore::DiagnosticLoggingDictionary"_s, {
            {
                "HashMap<String, Variant<String, uint64_t, int64_t, bool, double>>"_s,
                "dictionary"_s
            },
        } },
        { "WebCore::FixedPositionViewportConstraints"_s, {
            {
                "WebCore::FloatSize"_s,
                "alignmentOffset()"_s
            },
            {
                "WebCore::ViewportConstraints::AnchorEdges"_s,
                "anchorEdges()"_s
            },
            {
                "WebCore::FloatRect"_s,
                "viewportRectAtLastLayout()"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "layerPositionAtLastLayout()"_s
            },
        } },
        { "WebCore::StickyPositionViewportConstraints"_s, {
            {
                "WebCore::FloatSize"_s,
                "alignmentOffset()"_s
            },
            {
                "WebCore::ViewportConstraints::AnchorEdges"_s,
                "anchorEdges()"_s
            },
            {
                "float"_s,
                "leftOffset()"_s
            },
            {
                "float"_s,
                "rightOffset()"_s
            },
            {
                "float"_s,
                "topOffset()"_s
            },
            {
                "float"_s,
                "bottomOffset()"_s
            },
            {
                "WebCore::FloatRect"_s,
                "constrainingRectAtLastLayout()"_s
            },
            {
                "WebCore::FloatRect"_s,
                "containingBlockRect()"_s
            },
            {
                "WebCore::FloatRect"_s,
                "stickyBoxRect()"_s
            },
            {
                "WebCore::FloatSize"_s,
                "stickyOffsetAtLastLayout()"_s
            },
            {
                "WebCore::FloatSize"_s,
                "anchorLayerOffsetAtLastLayout()"_s
            },
            {
                "WebCore::FloatRect"_s,
                "viewportRectAtLastLayout()"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "layerPositionAtLastLayout()"_s
            },
        } },
        { "WebCore::FloatLine"_s, {
            {
                "WebCore::FloatPoint"_s,
                "start()"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "end()"_s
            },
        } },
        { "WebCore::FontCachePrewarmInformation"_s, {
            {
                "Vector<String>"_s,
                "seenFamilies"_s
            },
            {
                "Vector<String>"_s,
                "fontNamesRequiringSystemFallback"_s
            },
        } },
        { "WebCore::PrewarmInformation"_s, {
            {
                "WebCore::FontCachePrewarmInformation"_s,
                "fontCache"_s
            },
        } },
        { "WebCore::FontSelectionValue"_s, {
            {
                "WebCore::FontSelectionValue::BackingType"_s,
                "rawValue()"_s
            },
        } },
        { "WebCore::FontSelectionRange"_s, {
            {
                "WebCore::FontSelectionValue"_s,
                "minimum"_s
            },
            {
                "WebCore::FontSelectionValue"_s,
                "maximum"_s
            },
        } },
        { "WebCore::FontSelectionSpecifiedCapabilities"_s, {
            {
                "std::optional<WebCore::FontSelectionRange>"_s,
                "weight"_s
            },
            {
                "std::optional<WebCore::FontSelectionRange>"_s,
                "width"_s
            },
            {
                "std::optional<WebCore::FontSelectionRange>"_s,
                "slope"_s
            },
        } },
        { "WebCore::RemoteUserInputEventData"_s, {
            {
                "WebCore::FrameIdentifier"_s,
                "targetFrameID"_s
            },
            {
                "WebCore::IntPoint"_s,
                "transformedPoint"_s
            },
        } },
        { "WebCore::LinkDecorationFilteringData"_s, {
            {
                "WebCore::RegistrableDomain"_s,
                "domain"_s
            },
            {
                "String"_s,
                "path"_s
            },
            {
                "String"_s,
                "linkDecoration"_s
            },
        } },
        { "WebCore::InspectorFrontendClientSaveData"_s, {
            {
                "String"_s,
                "displayType"_s
            },
            {
                "String"_s,
                "url"_s
            },
            {
                "String"_s,
                "content"_s
            },
            {
                "bool"_s,
                "base64Encoded"_s
            },
        } },
#if ENABLE(VIDEO)
        { "WebCore::PlatformTextTrackData"_s, {
            {
                "String"_s,
                "m_label"_s
            },
            {
                "String"_s,
                "m_language"_s
            },
            {
                "String"_s,
                "m_url"_s
            },
            {
                "WebCore::PlatformTextTrackData::TrackMode"_s,
                "m_mode"_s
            },
            {
                "WebCore::PlatformTextTrackData::TrackKind"_s,
                "m_kind"_s
            },
            {
                "WebCore::PlatformTextTrackData::TrackType"_s,
                "m_type"_s
            },
            {
                "int"_s,
                "m_uniqueId"_s
            },
            {
                "bool"_s,
                "m_isDefault"_s
            },
        } },
#endif // ENABLE(VIDEO)
        { "WebCore::NotificationPayload"_s, {
            {
                "URL"_s,
                "defaultActionURL"_s
            },
            {
                "String"_s,
                "title"_s
            },
            {
                "std::optional<unsigned long long>"_s,
                "appBadge"_s
            },
            {
                "std::optional<WebCore::NotificationOptionsPayload>"_s,
                "options"_s
            },
            {
                "bool"_s,
                "isMutable"_s
            },
        } },
        { "WebCore::NotificationOptionsPayload"_s, {
            {
                "WebCore::NotificationDirection"_s,
                "dir"_s
            },
            {
                "String"_s,
                "lang"_s
            },
            {
                "String"_s,
                "body"_s
            },
            {
                "String"_s,
                "tag"_s
            },
            {
                "String"_s,
                "icon"_s
            },
            {
                "String"_s,
                "dataJSONString"_s
            },
            {
                "std::optional<bool>"_s,
                "silent"_s
            },
        } },
        { "WebCore::NetworkLoadMetrics"_s, {
            {
                "MonotonicTime"_s,
                "redirectStart"_s
            },
            {
                "MonotonicTime"_s,
                "fetchStart"_s
            },
            {
                "MonotonicTime"_s,
                "domainLookupStart"_s
            },
            {
                "MonotonicTime"_s,
                "domainLookupEnd"_s
            },
            {
                "MonotonicTime"_s,
                "connectStart"_s
            },
            {
                "MonotonicTime"_s,
                "secureConnectionStart"_s
            },
            {
                "MonotonicTime"_s,
                "connectEnd"_s
            },
            {
                "MonotonicTime"_s,
                "requestStart"_s
            },
            {
                "MonotonicTime"_s,
                "responseStart"_s
            },
            {
                "MonotonicTime"_s,
                "responseEnd"_s
            },
            {
                "MonotonicTime"_s,
                "workerStart"_s
            },
            {
                "String"_s,
                "protocol"_s
            },
            {
                "uint16_t"_s,
                "redirectCount"_s
            },
            {
                "bool"_s,
                "isComplete()"_s
            },
            {
                "bool"_s,
                "isCellular()"_s
            },
            {
                "bool"_s,
                "isExpensive()"_s
            },
            {
                "bool"_s,
                "isConstrained()"_s
            },
            {
                "bool"_s,
                "isMultipath()"_s
            },
            {
                "bool"_s,
                "reusedConnection()"_s
            },
            {
                "bool"_s,
                "doesFailTAOCheck()"_s
            },
            {
                "bool"_s,
                "crossOriginRedirect()"_s
            },
            {
                "WebCore::PrivacyStance"_s,
                "privacyStance"_s
            },
            {
                "uint64_t"_s,
                "responseBodyBytesReceived"_s
            },
            {
                "uint64_t"_s,
                "responseBodyDecodedSize"_s
            },
            {
                "RefPtr<WebCore::AdditionalNetworkLoadMetricsForWebInspector>"_s,
                "additionalNetworkLoadMetricsForWebInspector"_s
            },
        } },
        { "WebCore::AdditionalNetworkLoadMetricsForWebInspector"_s, {
            {
                "WebCore::NetworkLoadPriority"_s,
                "priority"_s
            },
            {
                "String"_s,
                "remoteAddress"_s
            },
            {
                "String"_s,
                "connectionIdentifier"_s
            },
            {
                "String"_s,
                "tlsProtocol"_s
            },
            {
                "String"_s,
                "tlsCipher"_s
            },
            {
                "WebCore::HTTPHeaderMap"_s,
                "requestHeaders"_s
            },
            {
                "uint64_t"_s,
                "requestHeaderBytesSent"_s
            },
            {
                "uint64_t"_s,
                "responseHeaderBytesReceived"_s
            },
            {
                "uint64_t"_s,
                "requestBodyBytesSent"_s
            },
            {
                "bool"_s,
                "isProxyConnection"_s
            },
        } },
        { "WebCore::DisplayUpdate"_s, {
            {
                "unsigned"_s,
                "updateIndex"_s
            },
            {
                "WebCore::FramesPerSecond"_s,
                "updatesPerSecond"_s
            },
        } },
        { "WebCore::MediaUsageInfo"_s, {
            {
                "URL"_s,
                "mediaURL"_s
            },
            {
                "bool"_s,
                "hasSource"_s
            },
            {
                "bool"_s,
                "isPlaying"_s
            },
            {
                "bool"_s,
                "canShowControlsManager"_s
            },
            {
                "bool"_s,
                "canShowNowPlayingControls"_s
            },
            {
                "bool"_s,
                "isSuspended"_s
            },
            {
                "bool"_s,
                "isInActiveDocument"_s
            },
            {
                "bool"_s,
                "isFullscreen"_s
            },
            {
                "bool"_s,
                "isMuted"_s
            },
            {
                "bool"_s,
                "isMediaDocumentInMainFrame"_s
            },
            {
                "bool"_s,
                "isVideo"_s
            },
            {
                "bool"_s,
                "isAudio"_s
            },
            {
                "bool"_s,
                "hasVideo"_s
            },
            {
                "bool"_s,
                "hasAudio"_s
            },
            {
                "bool"_s,
                "hasRenderer"_s
            },
            {
                "bool"_s,
                "audioElementWithUserGesture"_s
            },
            {
                "bool"_s,
                "userHasPlayedAudioBefore"_s
            },
            {
                "bool"_s,
                "isElementRectMostlyInMainFrame"_s
            },
            {
                "bool"_s,
                "playbackPermitted"_s
            },
            {
                "bool"_s,
                "pageMediaPlaybackSuspended"_s
            },
            {
                "bool"_s,
                "isMediaDocumentAndNotOwnerElement"_s
            },
            {
                "bool"_s,
                "pageExplicitlyAllowsElementToAutoplayInline"_s
            },
            {
                "bool"_s,
                "requiresFullscreenForVideoPlaybackAndFullscreenNotPermitted"_s
            },
            {
                "bool"_s,
                "isVideoAndRequiresUserGestureForVideoRateChange"_s
            },
            {
                "bool"_s,
                "isAudioAndRequiresUserGestureForAudioRateChange"_s
            },
            {
                "bool"_s,
                "isVideoAndRequiresUserGestureForVideoDueToLowPowerMode"_s
            },
            {
                "bool"_s,
                "isVideoAndRequiresUserGestureForVideoDueToAggressiveThermalMitigation"_s
            },
            {
                "bool"_s,
                "noUserGestureRequired"_s
            },
            {
                "bool"_s,
                "requiresPlaybackAndIsNotPlaying"_s
            },
            {
                "bool"_s,
                "hasEverNotifiedAboutPlaying"_s
            },
            {
                "bool"_s,
                "outsideOfFullscreen"_s
            },
            {
                "bool"_s,
                "isLargeEnoughForMainContent"_s
            },
#if PLATFORM(COCOA) && !HAVE(CGS_FIX_FOR_RADAR_97530095)
            {
                "bool"_s,
                "isInViewport"_s
            },
#endif
        } },
        { "WebCore::NowPlayingInfoArtwork"_s, {
            {
                "String"_s,
                "src"_s
            },
            {
                "String"_s,
                "mimeType"_s
            },
            {
                "RefPtr<WebCore::Image>"_s,
                "image"_s
            },
        } },
        { "WebCore::NowPlayingMetadata"_s, {
            {
                "String"_s,
                "title"_s
            },
            {
                "String"_s,
                "artist"_s
            },
            {
                "String"_s,
                "album"_s
            },
            {
                "String"_s,
                "sourceApplicationIdentifier"_s
            },
            {
                "std::optional<WebCore::NowPlayingInfoArtwork>"_s,
                "artwork"_s
            },
        } },
        { "WebCore::NowPlayingInfo"_s, {
            {
                "WebCore::NowPlayingMetadata"_s,
                "metadata"_s
            },
            {
                "double"_s,
                "duration"_s
            },
            {
                "double"_s,
                "currentTime"_s
            },
            {
                "double"_s,
                "rate"_s
            },
            {
                "bool"_s,
                "supportsSeeking"_s
            },
            {
                "Markable<WebCore::MediaUniqueIdentifier>"_s,
                "uniqueIdentifier"_s
            },
            {
                "bool"_s,
                "isPlaying"_s
            },
            {
                "bool"_s,
                "allowsNowPlayingControlsVisibility"_s
            },
            {
                "bool"_s,
                "isVideo"_s
            },
        } },
        { "WebCore::VideoConfiguration"_s, {
            {
                "String"_s,
                "contentType"_s
            },
            {
                "uint32_t"_s,
                "width"_s
            },
            {
                "uint32_t"_s,
                "height"_s
            },
            {
                "uint64_t"_s,
                "bitrate"_s
            },
            {
                "double"_s,
                "framerate"_s
            },
            {
                "std::optional<bool>"_s,
                "alphaChannel"_s
            },
            {
                "std::optional<WebCore::ColorGamut>"_s,
                "colorGamut"_s
            },
            {
                "std::optional<WebCore::HdrMetadataType>"_s,
                "hdrMetadataType"_s
            },
            {
                "std::optional<WebCore::TransferFunction>"_s,
                "transferFunction"_s
            },
        } },
        { "WebCore::FloatFontTaggedSetting"_s, {
            {
                "WebCore::FontTag"_s,
                "m_tag"_s
            },
            {
                "float"_s,
                "m_value"_s
            },
        } },
        { "WebCore::IntFontTaggedSetting"_s, {
            {
                "WebCore::FontTag"_s,
                "m_tag"_s
            },
            {
                "int"_s,
                "m_value"_s
            },
        } },
        { "WebCore::FontVariationSettings"_s, {
            {
                "Vector<WebCore::FloatFontTaggedSetting>"_s,
                "m_list"_s
            },
        } },
        { "WebCore::FontFeatureSettings"_s, {
            {
                "Vector<WebCore::IntFontTaggedSetting>"_s,
                "m_list"_s
            },
        } },
        { "WebCore::UserScript"_s, {
            {
                "String"_s,
                "source()"_s
            },
            {
                "URL"_s,
                "url()"_s
            },
            {
                "Vector<String>"_s,
                "allowlist()"_s
            },
            {
                "Vector<String>"_s,
                "blocklist()"_s
            },
            {
                "WebCore::UserScriptInjectionTime"_s,
                "injectionTime()"_s
            },
            {
                "WebCore::UserContentInjectedFrames"_s,
                "injectedFrames()"_s
            },
            {
                "WebCore::UserContentMatchParentFrame"_s,
                "matchParentFrame()"_s
            },
        } },
        { "WebCore::ContentSecurityPolicyResponseHeaders"_s, {
            {
                "Vector<std::pair<String, WebCore::ContentSecurityPolicyHeaderType>>"_s,
                "headers()"_s
            },
            {
                "int"_s,
                "httpStatusCode()"_s
            },
        } },
        { "WebCore::DragImage"_s, {
            {
                "RefPtr<WebCore::TextIndicator>"_s,
                "textIndicator()"_s
            },
            {
                "std::optional<WebCore::Path>"_s,
                "visiblePath()"_s
            },
        } },
        { "WebCore::DragItem"_s, {
            {
                "WebCore::DragImage"_s,
                "image"_s
            },
            {
                "WebCore::FloatPoint"_s,
                "imageAnchorPoint"_s
            },
            {
                "std::optional<WebCore::DragSourceAction>"_s,
                "sourceAction"_s
            },
            {
                "WebCore::IntPoint"_s,
                "eventPositionInContentCoordinates"_s
            },
            {
                "WebCore::IntPoint"_s,
                "dragLocationInContentCoordinates"_s
            },
            {
                "WebCore::IntPoint"_s,
                "dragLocationInWindowCoordinates"_s
            },
            {
                "String"_s,
                "title"_s
            },
            {
                "URL"_s,
                "url"_s
            },
            {
                "WebCore::IntRect"_s,
                "dragPreviewFrameInRootViewCoordinates"_s
            },
            {
                "bool"_s,
                "containsSelection"_s
            },
            {
                "WebCore::PromisedAttachmentInfo"_s,
                "promisedAttachmentInfo"_s
            },
#if ENABLE(MODEL_PROCESS)
            {
                "Markable<WebCore::PlatformLayerIdentifier>"_s,
                "modelLayerID"_s
            },
#endif
        } },
#if PLATFORM(COCOA)
        { "WebCore::KeypressCommand"_s, {
            {
                "String"_s,
                "commandName"_s
            },
            {
                "String"_s,
                "text"_s
            },
            {
                "Vector<WebCore::CompositionUnderline>"_s,
                "underlines"_s
            },
            {
                "Vector<WebCore::CompositionHighlight>"_s,
                "highlights"_s
            },
            {
                "WebCore::CharacterRange"_s,
                "selectedRange"_s
            },
            {
                "WebCore::CharacterRange"_s,
                "replacementRange"_s
            },
        } },
#endif // PLATFORM(COCOA)
#if !USE(COORDINATED_GRAPHICS)
        { "WebCore::FilterOperations"_s, {
            {
                "Vector<Ref<WebCore::FilterOperation>>"_s,
                "m_operations"_s
            },
        } },
#endif // !USE(COORDINATED_GRAPHICS)
        { "WebCore::Filter"_s, {
            { "Variant<"
                "WebCore::CSSFilter"
                ", WebCore::SVGFilter"
            ">"_s, "subclasses"_s }
        } },
        { "WebCore::CSSFilter"_s, {
            {
                "Vector<Ref<WebCore::FilterFunction>>"_s,
                "functions()"_s
            },
            {
                "OptionSet<WebCore::FilterRenderingMode>"_s,
                "filterRenderingModes()"_s
            },
            {
                "WebCore::FloatSize"_s,
                "filterScale()"_s
            },
            {
                "WebCore::FloatRect"_s,
                "filterRegion()"_s
            },
        } },
        { "WebCore::SVGFilter"_s, {
            {
                "WebCore::FloatRect"_s,
                "targetBoundingBox()"_s
            },
            {
                "WebCore::SVGUnitTypes::SVGUnitType"_s,
                "primitiveUnits()"_s
            },
            {
                "WebCore::SVGFilterExpression"_s,
                "expression()"_s
            },
            {
                "Vector<Ref<WebCore::FilterEffect>>"_s,
                "effects()"_s
            },
            {
                "std::optional<WebCore::RenderingResourceIdentifier>"_s,
                "renderingResourceIdentifierIfExists()"_s
            },
            {
                "OptionSet<WebCore::FilterRenderingMode>"_s,
                "filterRenderingModes()"_s
            },
            {
                "WebCore::FloatSize"_s,
                "filterScale()"_s
            },
            {
                "WebCore::FloatRect"_s,
                "filterRegion()"_s
            },
        } },
        { "WebCore::ByteArrayPixelBuffer"_s, {
            {
                "WebCore::PixelBufferFormat"_s,
                "format()"_s
            },
            {
                "WebCore::IntSize"_s,
                "size()"_s
            },
            {
                "std::span<const uint8_t>"_s,
                "span()"_s
            },
        } },
        { "WebCore::PixelBufferSourceView"_s, {
            {
                "WebCore::PixelBufferFormat"_s,
                "format()"_s
            },
            {
                "WebCore::IntSize"_s,
                "size()"_s
            },
            {
                "std::span<const uint8_t>"_s,
                "bytes()"_s
            },
        } },
        { "WebCore::MarkupExclusionRule"_s, {
            {
                "AtomString"_s,
                "elementLocalName"_s
            },
            {
                "Vector<std::pair<AtomString, AtomString>>"_s,
                "attributes"_s
            },
        } },
        { "WebCore::SystemImage"_s, {
            { "Variant<"
#if ENABLE(APPLE_PAY)
                "WebCore::ApplePayLogoSystemImage"
#endif
#if USE(SYSTEM_PREVIEW)
                ", WebCore::ARKitBadgeSystemImage"
#endif
#if USE(APPKIT)
                ", WebCore::AppKitControlSystemImage"
#endif
            ">"_s, "subclasses"_s }
        } },
#if ENABLE(WEB_CODECS)
        { "WebCore::WebCodecsEncodedVideoChunkStorage"_s, {
            {
                "WebCore::WebCodecsEncodedVideoChunkData"_s,
                "data()"_s
            },
        } },
#endif // ENABLE(WEB_CODECS)
#if ENABLE(WEB_CODECS)
        { "WebCore::WebCodecsEncodedAudioChunkStorage"_s, {
            {
                "WebCore::WebCodecsEncodedAudioChunkData"_s,
                "data()"_s
            },
        } },
#endif // ENABLE(WEB_CODECS)
        { "WebCore::SerializedScriptValue::Internals"_s, {
            {
                "Vector<uint8_t>"_s,
                "data"_s
            },
            {
                "std::unique_ptr<Vector<JSC::ArrayBufferContents>>"_s,
                "arrayBufferContentsArray"_s
            },
#if ENABLE(WEB_RTC)
            {
                "Vector<std::unique_ptr<WebCore::DetachedRTCDataChannel>>"_s,
                "detachedRTCDataChannels"_s
            },
#endif
#if ENABLE(WEB_CODECS)
            {
                "Vector<RefPtr<WebCore::WebCodecsEncodedVideoChunkStorage>>"_s,
                "serializedVideoChunks"_s
            },
#endif
#if ENABLE(WEB_CODECS)
            {
                "Vector<RefPtr<WebCore::WebCodecsEncodedAudioChunkStorage>>"_s,
                "serializedAudioChunks"_s
            },
#endif
        } },
        { "WebCore::SerializedScriptValue"_s, {
            {
                "WebCore::SerializedScriptValue::Internals"_s,
                "m_internals"_s
            },
        } },
        { "WebCore::SharedBuffer"_s, {
            {
                "Ref<WebCore::FragmentedSharedBuffer>"_s,
                "asFragmentedSharedBuffer()"_s
            },
        } },
#if !USE(COORDINATED_GRAPHICS)
        { "WebCore::FilterOperation"_s, {
            { "Variant<"
                "WebCore::BasicColorMatrixFilterOperation"
                ", WebCore::BasicComponentTransferFilterOperation"
                ", WebCore::BlurFilterOperation"
                ", WebCore::DropShadowFilterOperation"
                ", WebCore::DefaultFilterOperation"
                ", WebCore::PassthroughFilterOperation"
            ">"_s, "subclasses"_s }
        } },
#endif // !USE(COORDINATED_GRAPHICS)
#if !USE(COORDINATED_GRAPHICS)
        { "WebCore::BasicColorMatrixFilterOperation"_s, {
            {
                "double"_s,
                "amount()"_s
            },
            {
                "WebCore::FilterOperation::Type"_s,
                "type()"_s
            },
        } },
#endif // !USE(COORDINATED_GRAPHICS)
#if !USE(COORDINATED_GRAPHICS)
        { "WebCore::BasicComponentTransferFilterOperation"_s, {
            {
                "double"_s,
                "amount()"_s
            },
            {
                "WebCore::FilterOperation::Type"_s,
                "type()"_s
            },
        } },
#endif // !USE(COORDINATED_GRAPHICS)
#if !USE(COORDINATED_GRAPHICS)
        { "WebCore::BlurFilterOperation"_s, {
            {
                "WebCore::Length"_s,
                "stdDeviation()"_s
            },
        } },
#endif // !USE(COORDINATED_GRAPHICS)
#if !USE(COORDINATED_GRAPHICS)
        { "WebCore::DropShadowFilterOperation"_s, {
            {
                "WebCore::IntPoint"_s,
                "location()"_s
            },
            {
                "int"_s,
                "stdDeviation()"_s
            },
            {
                "WebCore::Color"_s,
                "color()"_s
            },
        } },
#endif // !USE(COORDINATED_GRAPHICS)
#if !USE(COORDINATED_GRAPHICS)
        { "WebCore::DefaultFilterOperation"_s, {
            {
                "WebCore::FilterOperation::Type"_s,
                "representedType()"_s
            },
        } },
#endif // !USE(COORDINATED_GRAPHICS)
#if !USE(COORDINATED_GRAPHICS)
        { "WebCore::PassthroughFilterOperation"_s, {
        } },
#endif // !USE(COORDINATED_GRAPHICS)
        { "WebCore::FilterEffect"_s, {
            { "Variant<"
                "WebCore::FEBlend"
                ", WebCore::FEColorMatrix"
                ", WebCore::FEComponentTransfer"
                ", WebCore::FEComposite"
                ", WebCore::FEConvolveMatrix"
                ", WebCore::FEDiffuseLighting"
                ", WebCore::FEDisplacementMap"
                ", WebCore::FEDropShadow"
                ", WebCore::FEFlood"
                ", WebCore::FEGaussianBlur"
                ", WebCore::FEImage"
                ", WebCore::FEMerge"
                ", WebCore::FEMorphology"
                ", WebCore::FEOffset"
                ", WebCore::FETile"
                ", WebCore::FESpecularLighting"
                ", WebCore::FETurbulence"
                ", WebCore::SourceAlpha"
                ", WebCore::SourceGraphic"
            ">"_s, "subclasses"_s }
        } },
#if HAVE(CORE_MATERIAL)
        { "WebCore::AppleVisualEffectData"_s, {
            {
                "WebCore::AppleVisualEffect"_s,
                "effect"_s
            },
            {
                "WebCore::AppleVisualEffect"_s,
                "contextEffect"_s
            },
            {
                "WebCore::AppleVisualEffectData::ColorScheme"_s,
                "colorScheme"_s
            },
            {
                "std::optional<WebCore::FloatRoundedRect>"_s,
                "borderRect"_s
            },
        } },
#endif // HAVE(CORE_MATERIAL)
#if ENABLE(MEDIA_SOURCE)
        { "WebCore::SourceBufferEvictionData"_s, {
            {
                "uint64_t"_s,
                "contentSize"_s
            },
            {
                "int64_t"_s,
                "evictableSize"_s
            },
            {
                "uint64_t"_s,
                "maximumBufferSize"_s
            },
            {
                "uint64_t"_s,
                "numMediaSamples"_s
            },
        } },
#endif // ENABLE(MEDIA_SOURCE)
#if ENABLE(MEDIA_SOURCE)
        { "WebCore::MediaSourceConfiguration"_s, {
            {
                "bool"_s,
                "textTracksEnabled"_s
            },
        } },
#endif // ENABLE(MEDIA_SOURCE)
        { "WebCore::FontInternalAttributes"_s, {
            {
                "std::optional<WebCore::RenderingResourceIdentifier>"_s,
                "renderingResourceIdentifier"_s
            },
            {
                "WebCore::FontOrigin"_s,
                "origin"_s
            },
            {
                "WebCore::FontIsInterstitial"_s,
                "isInterstitial"_s
            },
            {
                "WebCore::FontVisibility"_s,
                "visibility"_s
            },
            {
                "WebCore::FontIsOrientationFallback"_s,
                "isTextOrientationFallback"_s
            },
        } },
        { "WebCore::Cursor::CustomCursorIPCData"_s, {
            {
                "Ref<WebCore::Image>"_s,
                "image"_s
            },
            {
                "WebCore::IntPoint"_s,
                "hotSpot"_s
            },
#if ENABLE(MOUSE_CURSOR_SCALE)
            {
                "float"_s,
                "scaleFactor"_s
            },
#endif
        } },
        { "WebCore::Cursor"_s, {
            {
                "Variant<WebCore::PlatformCursorType, std::optional<WebCore::Cursor::CustomCursorIPCData>>"_s,
                "ipcData()"_s
            },
        } },
        { "WebCore::DOMCacheEngine::Record"_s, {
            {
                "uint64_t"_s,
                "identifier"_s
            },
            {
                "uint64_t"_s,
                "updateResponseCounter"_s
            },
            {
                "WebCore::FetchHeadersGuard"_s,
                "requestHeadersGuard"_s
            },
            {
                "WebCore::ResourceRequest"_s,
                "request"_s
            },
            {
                "WebCore::FetchOptions"_s,
                "options"_s
            },
            {
                "String"_s,
                "referrer"_s
            },
            {
                "WebCore::FetchHeadersGuard"_s,
                "responseHeadersGuard"_s
            },
            {
                "WebCore::ResourceResponse"_s,
                "response"_s
            },
            {
                "Variant<std::nullptr_t, Ref<WebCore::FormData>, Ref<WebCore::SharedBuffer>>"_s,
                "responseBody"_s
            },
            {
                "uint64_t"_s,
                "responseBodySize"_s
            },
        } },
        { "WebCore::LightSource"_s, {
            { "Variant<"
                "WebCore::DistantLightSource"
                ", WebCore::PointLightSource"
                ", WebCore::SpotLightSource"
            ">"_s, "subclasses"_s }
        } },
        { "WebCore::Image"_s, {
            {
                "RefPtr<WebCore::ShareableBitmap>"_s,
                "toShareableBitmap()"_s
            },
        } },
        { "WebCore::Length"_s, {
            {
                "Variant<WebCore::Length::AutoData, WebCore::Length::NormalData, WebCore::Length::RelativeData, WebCore::Length::PercentData, WebCore::Length::FixedData, WebCore::Length::IntrinsicData, WebCore::Length::MinIntrinsicData, WebCore::Length::MinContentData, WebCore::Length::MaxContentData, WebCore::Length::FillAvailableData, WebCore::Length::FitContentData, WebCore::Length::ContentData, WebCore::Length::UndefinedData>"_s,
                "ipcData()"_s
            },
        } },
        { "WebCore::Length::AutoData"_s, {
        } },
        { "WebCore::Length::NormalData"_s, {
        } },
        { "WebCore::Length::RelativeData"_s, {
            {
                "Variant<float, int>"_s,
                "value"_s
            },
            {
                "bool"_s,
                "hasQuirk"_s
            },
        } },
        { "WebCore::Length::PercentData"_s, {
            {
                "Variant<float, int>"_s,
                "value"_s
            },
            {
                "bool"_s,
                "hasQuirk"_s
            },
        } },
        { "WebCore::Length::FixedData"_s, {
            {
                "Variant<float, int>"_s,
                "value"_s
            },
            {
                "bool"_s,
                "hasQuirk"_s
            },
        } },
        { "WebCore::Length::IntrinsicData"_s, {
            {
                "Variant<float, int>"_s,
                "value"_s
            },
            {
                "bool"_s,
                "hasQuirk"_s
            },
        } },
        { "WebCore::Length::MinIntrinsicData"_s, {
            {
                "Variant<float, int>"_s,
                "value"_s
            },
            {
                "bool"_s,
                "hasQuirk"_s
            },
        } },
        { "WebCore::Length::MinContentData"_s, {
            {
                "Variant<float, int>"_s,
                "value"_s
            },
            {
                "bool"_s,
                "hasQuirk"_s
            },
        } },
        { "WebCore::Length::MaxContentData"_s, {
            {
                "Variant<float, int>"_s,
                "value"_s
            },
            {
                "bool"_s,
                "hasQuirk"_s
            },
        } },
        { "WebCore::Length::FillAvailableData"_s, {
            {
                "Variant<float, int>"_s,
                "value"_s
            },
            {
                "bool"_s,
                "hasQuirk"_s
            },
        } },
        { "WebCore::Length::FitContentData"_s, {
            {
                "Variant<float, int>"_s,
                "value"_s
            },
            {
                "bool"_s,
                "hasQuirk"_s
            },
        } },
        { "WebCore::Length::ContentData"_s, {
        } },
        { "WebCore::Length::UndefinedData"_s, {
        } },
        { "WebCore::FilterFunction"_s, {
            { "Variant<"
                "WebCore::SVGFilter"
                ", WebCore::FEBlend"
                ", WebCore::FEColorMatrix"
                ", WebCore::FEComponentTransfer"
                ", WebCore::FEComposite"
                ", WebCore::FEConvolveMatrix"
                ", WebCore::FEDiffuseLighting"
                ", WebCore::FEDisplacementMap"
                ", WebCore::FEDropShadow"
                ", WebCore::FEFlood"
                ", WebCore::FEGaussianBlur"
                ", WebCore::FEImage"
                ", WebCore::FEMerge"
                ", WebCore::FEMorphology"
                ", WebCore::FEOffset"
                ", WebCore::FESpecularLighting"
                ", WebCore::FETile"
                ", WebCore::FETurbulence"
                ", WebCore::SourceAlpha"
                ", WebCore::SourceGraphic"
            ">"_s, "subclasses"_s }
        } },
        { "WebCore::OrganizationStorageAccessPromptQuirk"_s, {
            {
                "String"_s,
                "organizationName"_s
            },
            {
                "HashMap<WebCore::RegistrableDomain, Vector<WebCore::RegistrableDomain>>"_s,
                "quirkDomains"_s
            },
            {
                "Vector<URL>"_s,
                "triggerPages"_s
            },
        } },
#if ENABLE(SHAREABLE_RESOURCE)
        { "WebCore::ShareableResourceHandle"_s, {
            {
                "WebCore::SharedMemoryHandle"_s,
                "m_handle"_s
            },
            {
                "unsigned"_s,
                "m_offset"_s
            },
            {
                "unsigned"_s,
                "m_size"_s
            },
        } },
#endif // ENABLE(SHAREABLE_RESOURCE)
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
        { "WebCore::DynamicContentScalingDisplayList"_s, {
            {
                "Ref<WebCore::SharedBuffer>"_s,
                "displayList()"_s
            },
            {
                "Vector<MachSendRight>"_s,
                "takeSurfaces()"_s
            },
        } },
#endif // ENABLE(RE_DYNAMIC_CONTENT_SCALING)
#if PLATFORM(COCOA)
        { "WebCore::TextAttachmentMissingImage"_s, {
        } },
#endif // PLATFORM(COCOA)
#if PLATFORM(COCOA)
        { "WebCore::TextAttachmentFileWrapper"_s, {
#if !PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "ignoresOrientation"_s
            },
#endif
            {
                "String"_s,
                "preferredFilename"_s
            },
            {
                "RetainPtr<CFDataRef>"_s,
                "data"_s
            },
            {
                "String"_s,
                "accessibilityLabel"_s
            },
        } },
#endif // PLATFORM(COCOA)
#if (PLATFORM(COCOA)) && (ENABLE(MULTI_REPRESENTATION_HEIC))
        { "WebCore::MultiRepresentationHEICAttachmentSingleImage"_s, {
            {
                "RefPtr<WebCore::Image>"_s,
                "image"_s
            },
            {
                "WebCore::FloatSize"_s,
                "size"_s
            },
        } },
#endif // (PLATFORM(COCOA)) && (ENABLE(MULTI_REPRESENTATION_HEIC))
#if (PLATFORM(COCOA)) && (ENABLE(MULTI_REPRESENTATION_HEIC))
        { "WebCore::MultiRepresentationHEICAttachmentData"_s, {
            {
                "String"_s,
                "identifier"_s
            },
            {
                "String"_s,
                "description"_s
            },
            {
                "String"_s,
                "credit"_s
            },
            {
                "String"_s,
                "digitalSourceType"_s
            },
            {
                "Vector<WebCore::MultiRepresentationHEICAttachmentSingleImage>"_s,
                "images"_s
            },
        } },
#endif // (PLATFORM(COCOA)) && (ENABLE(MULTI_REPRESENTATION_HEIC))
#if ENABLE(IMAGE_ANALYSIS) && ENABLE(DATA_DETECTION)
        { "WebCore::TextRecognitionDataDetector"_s, {
            {
                "RetainPtr<DDScannerResult>"_s,
                "result"_s
            },
            {
                "Vector<WebCore::FloatQuad>"_s,
                "normalizedQuads"_s
            },
        } },
#endif // ENABLE(IMAGE_ANALYSIS) && ENABLE(DATA_DETECTION)
        { "WebCore::ShareableBitmapConfiguration"_s, {
            {
                "WebCore::IntSize"_s,
                "m_size"_s
            },
            {
                "std::optional<WebCore::DestinationColorSpace>"_s,
                "m_colorSpace"_s
            },
            {
                "WebCore::Headroom"_s,
                "m_headroom"_s
            },
            {
                "bool"_s,
                "m_isOpaque"_s
            },
            {
                "unsigned"_s,
                "bitsPerComponent()"_s
            },
            {
                "unsigned"_s,
                "bytesPerPixel()"_s
            },
            {
                "unsigned"_s,
                "bytesPerRow()"_s
            },
#if USE(CG)
            {
                "CGBitmapInfo"_s,
                "m_bitmapInfo"_s
            },
#endif
        } },
        { "WebCore::ShareableBitmapHandle"_s, {
            {
                "WebCore::SharedMemoryHandle"_s,
                "m_handle"_s
            },
            {
                "WebCore::ShareableBitmapConfiguration"_s,
                "m_configuration"_s
            },
        } },
        { "WebCore::ShareableBitmap"_s, {
            {
                "std::optional<WebCore::ShareableBitmapHandle>"_s,
                "createReadOnlyHandle()"_s
            },
        } },
#if ENABLE(DATA_DETECTION)
        { "WebCore::DataDetectorElementInfo"_s, {
            {
                "RetainPtr<DDScannerResult>"_s,
                "result"_s
            },
            {
                "WebCore::IntRect"_s,
                "elementBounds"_s
            },
        } },
#endif // ENABLE(DATA_DETECTION)
#if ENABLE(VIDEO)
        { "WebCore::SerializedPlatformDataCueValue"_s, {
            {
                "std::optional<WebCore::SerializedPlatformDataCueValue::Data>"_s,
                "data()"_s
            },
        } },
#endif // ENABLE(VIDEO)
#if ENABLE(VIDEO)
        { "WebCore::SerializedPlatformDataCueValue::Data"_s, {
#if PLATFORM(COCOA)
            {
                "String"_s,
                "type"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "HashMap<String, String>"_s,
                "otherAttributes"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "String"_s,
                "key"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "RetainPtr<NSLocale>"_s,
                "locale"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "Variant<std::nullptr_t, RetainPtr<NSString>, RetainPtr<NSDate>, RetainPtr<NSNumber>, RetainPtr<NSData>>"_s,
                "value"_s
            },
#endif
        } },
#endif // ENABLE(VIDEO)
        { "WebCore::FragmentedSharedBuffer"_s, {
            {
                "Variant<std::optional<WebCore::SharedMemoryHandle>, Vector<std::span<const uint8_t>>>"_s,
                "toIPCData()"_s
            },
        } },
#if (!PLATFORM(COCOA) && ENABLE(WEBGL)) && ((PLATFORM(GTK) || PLATFORM(WPE)))
        { "WebCore::GraphicsContextGLExternalImageSource"_s, {
            {
                "Vector<WTF::UnixFileDescriptor>"_s,
                "fds"_s
            },
            {
                "Vector<uint32_t>"_s,
                "strides"_s
            },
            {
                "Vector<uint32_t>"_s,
                "offsets"_s
            },
            {
                "uint32_t"_s,
                "fourcc"_s
            },
            {
                "uint64_t"_s,
                "modifier"_s
            },
            {
                "WebCore::IntSize"_s,
                "size"_s
            },
        } },
#endif // (!PLATFORM(COCOA) && ENABLE(WEBGL)) && ((PLATFORM(GTK) || PLATFORM(WPE)))
        { "WebCore::PublicSuffix"_s, {
            {
                "String"_s,
                "string()"_s
            },
        } },
        { "WebCore::WrappedCryptoKey"_s, {
            {
                "std::array<uint8_t, 24>"_s,
                "wrappedKEK"_s
            },
            {
                "Vector<uint8_t>"_s,
                "encryptedKey"_s
            },
            {
                "std::array<uint8_t, 16>"_s,
                "tag"_s
            },
        } },
        { "WebCore::Allowlist::AllowAllOrigins"_s, {
        } },
        { "WebCore::Allowlist"_s, {
            {
                "Variant<HashSet<WebCore::SecurityOriginData>, WebCore::Allowlist::AllowAllOrigins>"_s,
                "origins()"_s
            },
        } },
        { "WebCore::OwnerPermissionsPolicyData"_s, {
            {
                "WebCore::SecurityOriginData"_s,
                "documentOrigin"_s
            },
            {
                "WebCore::PermissionsPolicy"_s,
                "documentPolicy"_s
            },
            {
                "WebCore::OwnerPermissionsPolicyData::PolicyDirective"_s,
                "containerPolicy"_s
            },
        } },
        { "WebCore::PermissionsPolicy"_s, {
            {
                "WebCore::PermissionsPolicy::InheritedPolicy"_s,
                "inheritedPolicy()"_s
            },
        } },
        { "WebCore::ImageBufferResourceLimits"_s, {
            {
                "uint64_t"_s,
                "acceleratedImageBufferForCanvasCount"_s
            },
            {
                "uint64_t"_s,
                "acceleratedImageBufferForCanvasLimit"_s
            },
            {
                "uint64_t"_s,
                "globalAcceleratedImageBufferCount"_s
            },
            {
                "uint64_t"_s,
                "globalAcceleratedImageBufferLimit"_s
            },
            {
                "uint64_t"_s,
                "globalImageBufferForCanvasCount"_s
            },
            {
                "uint64_t"_s,
                "globalImageBufferForCanvasLimit"_s
            },
            {
                "uint64_t"_s,
                "imageBufferForCanvasCount"_s
            },
            {
                "uint64_t"_s,
                "imageBufferForCanvasLimit"_s
            },
        } },
        { "WebCore::RsaOtherPrimesInfo"_s, {
            {
                "String"_s,
                "r"_s
            },
            {
                "String"_s,
                "d"_s
            },
            {
                "String"_s,
                "t"_s
            },
        } },
        { "WebCore::JsonWebKey"_s, {
            {
                "String"_s,
                "kty"_s
            },
            {
                "String"_s,
                "use"_s
            },
            {
                "std::optional<Vector<WebCore::CryptoKeyUsage>>"_s,
                "key_ops"_s
            },
            {
                "int"_s,
                "usages"_s
            },
            {
                "String"_s,
                "alg"_s
            },
            {
                "std::optional<bool>"_s,
                "ext"_s
            },
            {
                "String"_s,
                "crv"_s
            },
            {
                "String"_s,
                "x"_s
            },
            {
                "String"_s,
                "y"_s
            },
            {
                "String"_s,
                "d"_s
            },
            {
                "String"_s,
                "n"_s
            },
            {
                "String"_s,
                "e"_s
            },
            {
                "String"_s,
                "p"_s
            },
            {
                "String"_s,
                "q"_s
            },
            {
                "String"_s,
                "dp"_s
            },
            {
                "String"_s,
                "dq"_s
            },
            {
                "String"_s,
                "qi"_s
            },
            {
                "std::optional<Vector<WebCore::RsaOtherPrimesInfo>>"_s,
                "oth"_s
            },
            {
                "String"_s,
                "k"_s
            },
        } },
        { "WebCore::CryptoKeyData"_s, {
            {
                "WebCore::CryptoKeyClass"_s,
                "keyClass"_s
            },
            {
                "WebCore::CryptoAlgorithmIdentifier"_s,
                "algorithmIdentifier"_s
            },
            {
                "bool"_s,
                "extractable"_s
            },
            {
                "int"_s,
                "usages"_s
            },
            {
                "std::optional<Vector<uint8_t>>"_s,
                "key"_s
            },
            {
                "std::optional<WebCore::JsonWebKey>"_s,
                "jwk"_s
            },
            {
                "std::optional<WebCore::CryptoAlgorithmIdentifier>"_s,
                "hashAlgorithmIdentifier"_s
            },
            {
                "std::optional<String>"_s,
                "namedCurveString"_s
            },
            {
                "std::optional<uint64_t>"_s,
                "lengthBits"_s
            },
            {
                "std::optional<WebCore::CryptoKeyType>"_s,
                "type"_s
            },
        } },
        { "WebCore::MediaSamplesBlock::MediaSampleItem"_s, {
            {
                "MediaTime"_s,
                "presentationTime"_s
            },
            {
                "MediaTime"_s,
                "decodeTime"_s
            },
            {
                "MediaTime"_s,
                "duration"_s
            },
            {
                "std::pair<MediaTime, MediaTime>"_s,
                "trimInterval"_s
            },
            {
                "RefPtr<WebCore::FragmentedSharedBuffer>"_s,
                "data"_s
            },
            {
                "RefPtr<WebCore::SharedBuffer>"_s,
                "hdrMetadata"_s
            },
            {
                "std::optional<WebCore::HdrMetadataType>"_s,
                "hdrMetadataType"_s
            },
            {
                "uint32_t"_s,
                "flags"_s
            },
        } },
        { "WebCore::RectEdges<WebCore::FixedContainerEdge>"_s, {
            {
                "WebCore::FixedContainerEdge"_s,
                "top()"_s
            },
            {
                "WebCore::FixedContainerEdge"_s,
                "right()"_s
            },
            {
                "WebCore::FixedContainerEdge"_s,
                "bottom()"_s
            },
            {
                "WebCore::FixedContainerEdge"_s,
                "left()"_s
            },
        } },
        { "WebCore::FixedContainerEdges"_s, {
            {
                "WebCore::RectEdges<WebCore::FixedContainerEdge>"_s,
                "colors"_s
            },
        } },
        { "WebCore::MessageForTesting"_s, {
            {
                "AtomString"_s,
                "type"_s
            },
            {
                "String"_s,
                "data"_s
            },
        } },
        { "WebCore::HostingContext"_s, {
            {
                "uint32_t"_s,
                "contextID"_s
            },
#if ENABLE(MACH_PORT_LAYER_HOSTING)
            {
                "WTF::MachSendRightAnnotated"_s,
                "sendRightAnnotated"_s
            },
#endif
        } },
        { "WebCore::FocusEventData"_s, {
            {
                "AtomString"_s,
                "type"_s
            },
            {
                "AtomString"_s,
                "keyIdentifier"_s
            },
            {
                "bool"_s,
                "altKey"_s
            },
        } },
        { "WebCore::AXDebugInfo"_s, {
            {
                "bool"_s,
                "isAccessibilityEnabled"_s
            },
            {
                "bool"_s,
                "isAccessibilityThreadInitialized"_s
            },
            {
                "String"_s,
                "liveTree"_s
            },
            {
                "String"_s,
                "isolatedTree"_s
            },
            {
                "uint64_t"_s,
                "remoteTokenHash"_s
            },
            {
                "uint64_t"_s,
                "webProcessLocalTokenHash"_s
            },
        } },
        { "WebCore::Font"_s, {
            {
                "WebCore::FontInternalAttributes"_s,
                "attributes()"_s
            },
            {
                "WebCore::FontPlatformData"_s,
                "platformData()"_s
            },
        } },
        { "WebCore::FontPlatformData"_s, {
            {
                "float"_s,
                "size()"_s
            },
            {
                "WebCore::FontOrientation"_s,
                "orientation()"_s
            },
            {
                "WebCore::FontWidthVariant"_s,
                "widthVariant()"_s
            },
            {
                "WebCore::TextRenderingMode"_s,
                "textRenderingMode()"_s
            },
            {
                "bool"_s,
                "syntheticBold()"_s
            },
            {
                "bool"_s,
                "syntheticOblique()"_s
            },
            {
                "WebCore::FontPlatformData::IPCData"_s,
                "toIPCData()"_s
            },
        } },
        { "WebCore::FontPlatformDataAttributes"_s, {
            {
                "float"_s,
                "m_size"_s
            },
            {
                "WebCore::FontOrientation"_s,
                "m_orientation"_s
            },
            {
                "WebCore::FontWidthVariant"_s,
                "m_widthVariant"_s
            },
            {
                "WebCore::TextRenderingMode"_s,
                "m_textRenderingMode"_s
            },
            {
                "bool"_s,
                "m_syntheticBold"_s
            },
            {
                "bool"_s,
                "m_syntheticOblique"_s
            },
#if PLATFORM(WIN) && USE(CAIRO)
            {
                "LOGFONT"_s,
                "m_font"_s
            },
#endif
#if USE(CORE_TEXT)
            {
                "RetainPtr<CFDictionaryRef>"_s,
                "m_attributes"_s
            },
#endif
#if USE(CORE_TEXT)
            {
                "CTFontDescriptorOptions"_s,
                "m_options"_s
            },
#endif
#if USE(CORE_TEXT)
            {
                "RetainPtr<CFStringRef>"_s,
                "m_url"_s
            },
#endif
#if USE(CORE_TEXT)
            {
                "RetainPtr<CFStringRef>"_s,
                "m_psName"_s
            },
#endif
#if USE(SKIA)
            {
                "SkString"_s,
                "m_familyName"_s
            },
#endif
#if USE(SKIA)
            {
                "SkFontStyle"_s,
                "m_style"_s
            },
#endif
#if USE(SKIA)
            {
                "Vector<hb_feature_t>"_s,
                "m_features"_s
            },
#endif
        } },
        { "WebCore::FontCustomPlatformSerializedData"_s, {
            {
                "Ref<WebCore::SharedBuffer>"_s,
                "fontFaceData"_s
            },
            {
                "String"_s,
                "itemInCollection"_s
            },
            {
                "WebCore::RenderingResourceIdentifier"_s,
                "renderingResourceIdentifier"_s
            },
        } },
#if ENABLE(CONTENT_EXTENSIONS)
        { "WebKit::WebCompiledContentRuleListData"_s, {
            {
                "String"_s,
                "identifier"_s
            },
            {
                "std::optional<WebCore::SharedMemoryHandle>"_s,
                "createDataHandle()"_s
            },
            {
                "uint64_t"_s,
                "actionsOffset"_s
            },
            {
                "uint64_t"_s,
                "actionsSize"_s
            },
            {
                "uint64_t"_s,
                "urlFiltersBytecodeOffset"_s
            },
            {
                "uint64_t"_s,
                "urlFiltersBytecodeSize"_s
            },
            {
                "uint64_t"_s,
                "topURLFiltersBytecodeOffset"_s
            },
            {
                "uint64_t"_s,
                "topURLFiltersBytecodeSize"_s
            },
            {
                "uint64_t"_s,
                "frameURLFiltersBytecodeOffset"_s
            },
            {
                "uint64_t"_s,
                "frameURLFiltersBytecodeSize"_s
            },
        } },
#endif // ENABLE(CONTENT_EXTENSIONS)
        { "WebKit::WebEvent"_s, {
            {
                "WebKit::WebEventType"_s,
                "type()"_s
            },
            {
                "OptionSet<WebKit::WebEventModifier>"_s,
                "modifiers()"_s
            },
            {
                "WallTime"_s,
                "timestamp()"_s
            },
            {
                "WTF::UUID"_s,
                "authorizationToken()"_s
            },
        } },
        { "WebKit::WebKeyboardEvent"_s, {
            {
                "WebKit::WebEventType"_s,
                "type()"_s
            },
            {
                "OptionSet<WebKit::WebEventModifier>"_s,
                "modifiers()"_s
            },
            {
                "WallTime"_s,
                "timestamp()"_s
            },
            {
                "WTF::UUID"_s,
                "authorizationToken()"_s
            },
            {
                "String"_s,
                "text()"_s
            },
#if !PLATFORM(GTK) && !USE(LIBWPE)
            {
                "String"_s,
                "unmodifiedText()"_s
            },
#endif
            {
                "String"_s,
                "key()"_s
            },
            {
                "String"_s,
                "code()"_s
            },
            {
                "String"_s,
                "keyIdentifier()"_s
            },
            {
                "int32_t"_s,
                "windowsVirtualKeyCode()"_s
            },
            {
                "int32_t"_s,
                "nativeVirtualKeyCode()"_s
            },
#if !PLATFORM(GTK) && !USE(LIBWPE)
            {
                "int32_t"_s,
                "macCharCode()"_s
            },
#endif
#if USE(APPKIT) || PLATFORM(IOS_FAMILY) || PLATFORM(GTK) || USE(LIBWPE)
            {
                "bool"_s,
                "handledByInputMethod()"_s
            },
#endif
#if PLATFORM(GTK) || USE(LIBWPE)
            {
                "std::optional<Vector<WebCore::CompositionUnderline>>"_s,
                "preeditUnderlines()"_s
            },
#endif
#if PLATFORM(GTK) || USE(LIBWPE)
            {
                "std::optional<WebKit::EditingRange>"_s,
                "preeditSelectionRange()"_s
            },
#endif
#if USE(APPKIT)
            {
                "Vector<WebCore::KeypressCommand>"_s,
                "commands()"_s
            },
#endif
#if !USE(APPKIT) && PLATFORM(GTK)
            {
                "Vector<String>"_s,
                "commands()"_s
            },
#endif
            {
                "bool"_s,
                "isAutoRepeat()"_s
            },
            {
                "bool"_s,
                "isKeypad()"_s
            },
#if !PLATFORM(GTK) && !USE(LIBWPE)
            {
                "bool"_s,
                "isSystemKey()"_s
            },
#endif
        } },
#if ENABLE(TOUCH_EVENTS)
        { "WebKit::WebTouchEvent"_s, {
            {
                "WebKit::WebEventType"_s,
                "type()"_s
            },
            {
                "OptionSet<WebKit::WebEventModifier>"_s,
                "modifiers()"_s
            },
            {
                "WallTime"_s,
                "timestamp()"_s
            },
            {
                "WTF::UUID"_s,
                "authorizationToken()"_s
            },
            {
                "Vector<WebKit::WebPlatformTouchPoint>"_s,
                "touchPoints()"_s
            },
            {
                "Vector<WebKit::WebTouchEvent>"_s,
                "coalescedEvents()"_s
            },
            {
                "Vector<WebKit::WebTouchEvent>"_s,
                "predictedEvents()"_s
            },
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::IntPoint"_s,
                "position()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "isPotentialTap()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "isGesture()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "float"_s,
                "gestureScale()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "float"_s,
                "gestureRotation()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "canPreventNativeGestures()"_s
            },
#endif
        } },
#endif // ENABLE(TOUCH_EVENTS)
#if ENABLE(TOUCH_EVENTS)
        { "WebKit::WebPlatformTouchPoint"_s, {
#if PLATFORM(IOS_FAMILY)
            {
                "unsigned"_s,
                "identifier()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::IntPoint"_s,
                "locationInRootView()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::IntPoint"_s,
                "locationInViewport()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebKit::WebPlatformTouchPoint::State"_s,
                "phase()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(IOS_TOUCH_EVENTS)
            {
                "double"_s,
                "radiusX()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(IOS_TOUCH_EVENTS)
            {
                "double"_s,
                "radiusY()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(IOS_TOUCH_EVENTS)
            {
                "double"_s,
                "rotationAngle()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(IOS_TOUCH_EVENTS)
            {
                "double"_s,
                "force()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(IOS_TOUCH_EVENTS)
            {
                "double"_s,
                "altitudeAngle()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(IOS_TOUCH_EVENTS)
            {
                "double"_s,
                "azimuthAngle()"_s
            },
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(IOS_TOUCH_EVENTS)
            {
                "WebKit::WebPlatformTouchPoint::TouchType"_s,
                "touchType()"_s
            },
#endif
#if !PLATFORM(IOS_FAMILY)
            {
                "uint32_t"_s,
                "id()"_s
            },
#endif
#if !PLATFORM(IOS_FAMILY)
            {
                "WebKit::WebPlatformTouchPoint::State"_s,
                "state()"_s
            },
#endif
#if !PLATFORM(IOS_FAMILY)
            {
                "WebCore::IntPoint"_s,
                "screenPosition()"_s
            },
#endif
#if !PLATFORM(IOS_FAMILY)
            {
                "WebCore::IntPoint"_s,
                "position()"_s
            },
#endif
#if !PLATFORM(IOS_FAMILY)
            {
                "WebCore::IntSize"_s,
                "radius()"_s
            },
#endif
#if !PLATFORM(IOS_FAMILY)
            {
                "float"_s,
                "rotationAngle()"_s
            },
#endif
#if !PLATFORM(IOS_FAMILY)
            {
                "float"_s,
                "force()"_s
            },
#endif
        } },
#endif // ENABLE(TOUCH_EVENTS)
        { "WebKit::WebMouseEvent"_s, {
            {
                "WebKit::WebEventType"_s,
                "type()"_s
            },
            {
                "OptionSet<WebKit::WebEventModifier>"_s,
                "modifiers()"_s
            },
            {
                "WallTime"_s,
                "timestamp()"_s
            },
            {
                "WTF::UUID"_s,
                "authorizationToken()"_s
            },
            {
                "WebKit::WebMouseEventButton"_s,
                "button()"_s
            },
            {
                "unsigned short"_s,
                "buttons()"_s
            },
            {
                "WebCore::IntPoint"_s,
                "position()"_s
            },
            {
                "WebCore::IntPoint"_s,
                "globalPosition()"_s
            },
            {
                "float"_s,
                "deltaX()"_s
            },
            {
                "float"_s,
                "deltaY()"_s
            },
            {
                "float"_s,
                "deltaZ()"_s
            },
            {
                "int32_t"_s,
                "clickCount()"_s
            },
            {
                "double"_s,
                "force()"_s
            },
            {
                "WebKit::WebMouseEventSyntheticClickType"_s,
                "syntheticClickType()"_s
            },
#if PLATFORM(MAC)
            {
                "int32_t"_s,
                "eventNumber()"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "int32_t"_s,
                "menuTypeForEvent()"_s
            },
#endif
#if !PLATFORM(MAC) && PLATFORM(GTK)
            {
                "WebCore::PlatformMouseEvent::IsTouch"_s,
                "isTouchEvent()"_s
            },
#endif
#if !PLATFORM(MAC)
            {
                "WebCore::PointerID"_s,
                "pointerId()"_s
            },
#endif
#if !PLATFORM(MAC)
            {
                "String"_s,
                "pointerType()"_s
            },
#endif
            {
                "WebKit::GestureWasCancelled"_s,
                "gestureWasCancelled()"_s
            },
            {
                "WebCore::IntPoint"_s,
                "unadjustedMovementDelta()"_s
            },
            {
                "Vector<WebKit::WebMouseEvent>"_s,
                "coalescedEvents()"_s
            },
        } },
#if ENABLE(MAC_GESTURE_EVENTS)
        { "WebKit::WebGestureEvent"_s, {
            {
                "WebKit::WebEventType"_s,
                "type()"_s
            },
            {
                "OptionSet<WebKit::WebEventModifier>"_s,
                "modifiers()"_s
            },
            {
                "WallTime"_s,
                "timestamp()"_s
            },
            {
                "WTF::UUID"_s,
                "authorizationToken()"_s
            },
            {
                "WebCore::IntPoint"_s,
                "position()"_s
            },
            {
                "float"_s,
                "gestureScale()"_s
            },
            {
                "float"_s,
                "gestureRotation()"_s
            },
        } },
#endif // ENABLE(MAC_GESTURE_EVENTS)
        { "WebKit::WebWheelEvent"_s, {
            {
                "WebKit::WebEventType"_s,
                "type()"_s
            },
            {
                "OptionSet<WebKit::WebEventModifier>"_s,
                "modifiers()"_s
            },
            {
                "WallTime"_s,
                "timestamp()"_s
            },
            {
                "WTF::UUID"_s,
                "authorizationToken()"_s
            },
            {
                "WebCore::IntPoint"_s,
                "position()"_s
            },
            {
                "WebCore::IntPoint"_s,
                "globalPosition()"_s
            },
            {
                "WebCore::FloatSize"_s,
                "delta()"_s
            },
            {
                "WebCore::FloatSize"_s,
                "wheelTicks()"_s
            },
            {
                "WebKit::WebWheelEvent::Granularity"_s,
                "granularity()"_s
            },
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "directionInvertedFromDevice()"_s
            },
#endif
#if PLATFORM(COCOA) || PLATFORM(GTK) || USE(LIBWPE)
            {
                "WebKit::WebWheelEvent::Phase"_s,
                "phase()"_s
            },
#endif
#if PLATFORM(COCOA) || PLATFORM(GTK) || USE(LIBWPE)
            {
                "WebKit::WebWheelEvent::Phase"_s,
                "momentumPhase()"_s
            },
#endif
#if PLATFORM(COCOA) || PLATFORM(GTK) || USE(LIBWPE)
            {
                "bool"_s,
                "hasPreciseScrollingDeltas()"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "uint32_t"_s,
                "scrollCount()"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "WebCore::FloatSize"_s,
                "unacceleratedScrollingDelta()"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "WallTime"_s,
                "ioHIDEventTimestamp()"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "std::optional<WebCore::FloatSize>"_s,
                "rawPlatformDelta()"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "WebKit::WebWheelEvent::MomentumEndType"_s,
                "momentumEndType()"_s
            },
#endif
        } },
        { "WebKit::WebFoundTextRange::DOMData"_s, {
            {
                "uint64_t"_s,
                "location"_s
            },
            {
                "uint64_t"_s,
                "length"_s
            },
        } },
        { "WebKit::WebFoundTextRange::PDFData"_s, {
            {
                "uint64_t"_s,
                "startPage"_s
            },
            {
                "uint64_t"_s,
                "startOffset"_s
            },
            {
                "uint64_t"_s,
                "endPage"_s
            },
            {
                "uint64_t"_s,
                "endOffset"_s
            },
        } },
        { "WebKit::WebFoundTextRange"_s, {
            {
                "Variant<WebKit::WebFoundTextRange::DOMData, WebKit::WebFoundTextRange::PDFData>"_s,
                "data"_s
            },
            {
                "AtomString"_s,
                "frameIdentifier"_s
            },
            {
                "uint64_t"_s,
                "order"_s
            },
        } },
        { "WebKit::WebFrameMetrics"_s, {
            {
                "WebKit::IsScrollable"_s,
                "isScrollable"_s
            },
            {
                "WebCore::IntSize"_s,
                "contentSize"_s
            },
            {
                "WebCore::IntSize"_s,
                "visibleContentSize"_s
            },
            {
                "WebCore::IntSize"_s,
                "visibleContentSizeExcludingScrollbars"_s
            },
        } },
        { "WebKit::WebHitTestResultData"_s, {
            {
                "String"_s,
                "absoluteImageURL"_s
            },
            {
                "String"_s,
                "absolutePDFURL"_s
            },
            {
                "String"_s,
                "absoluteLinkURL"_s
            },
            {
                "String"_s,
                "absoluteMediaURL"_s
            },
            {
                "String"_s,
                "linkLabel"_s
            },
            {
                "String"_s,
                "linkTitle"_s
            },
            {
                "String"_s,
                "linkSuggestedFilename"_s
            },
            {
                "String"_s,
                "imageSuggestedFilename"_s
            },
            {
                "bool"_s,
                "isContentEditable"_s
            },
            {
                "WebCore::IntRect"_s,
                "elementBoundingBox"_s
            },
            {
                "WebKit::WebHitTestResultData::IsScrollbar"_s,
                "isScrollbar"_s
            },
            {
                "bool"_s,
                "isSelected"_s
            },
            {
                "bool"_s,
                "isTextNode"_s
            },
            {
                "bool"_s,
                "isOverTextInsideFormControlElement"_s
            },
            {
                "bool"_s,
                "isDownloadableMedia"_s
            },
            {
                "bool"_s,
                "mediaIsInFullscreen"_s
            },
            {
                "bool"_s,
                "isActivePDFAnnotation"_s
            },
            {
                "WebKit::WebHitTestResultData::ElementType"_s,
                "elementType"_s
            },
            {
                "std::optional<WebKit::FrameInfoData>"_s,
                "frameInfo"_s
            },
            {
                "std::optional<WebCore::RemoteUserInputEventData>"_s,
                "remoteUserInputEventData"_s
            },
            {
                "String"_s,
                "lookupText"_s
            },
            {
                "String"_s,
                "toolTipText"_s
            },
            {
                "String"_s,
                "imageText"_s
            },
            {
                "std::optional<WebCore::SharedMemoryHandle>"_s,
                "getImageSharedMemoryHandle()"_s
            },
            {
                "RefPtr<WebCore::ShareableBitmap>"_s,
                "imageBitmap"_s
            },
            {
                "String"_s,
                "sourceImageMIMEType"_s
            },
            {
                "bool"_s,
                "hasEntireImage"_s
            },
            {
                "bool"_s,
                "allowsFollowingLink"_s
            },
            {
                "bool"_s,
                "allowsFollowingImageURL"_s
            },
            {
                "std::optional<WebCore::ResourceResponse>"_s,
                "linkLocalResourceResponse"_s
            },
#if PLATFORM(MAC)
            {
                "WebKit::WebHitTestResultPlatformData"_s,
                "platformData"_s
            },
#endif
            {
                "WebCore::DictionaryPopupInfo"_s,
                "dictionaryPopupInfo"_s
            },
            {
                "RefPtr<WebCore::TextIndicator>"_s,
                "linkTextIndicator"_s
            },
        } },
        { "WebKit::WebImage"_s, {
            {
                "std::optional<std::pair<WebCore::ImageBufferParameters, WebCore::ShareableBitmapHandle>>"_s,
                "parametersAndHandle()"_s
            },
        } },
        { "WebKit::WebNavigationDataStore"_s, {
            {
                "String"_s,
                "url"_s
            },
            {
                "String"_s,
                "title"_s
            },
            {
                "WebCore::ResourceRequest"_s,
                "originalRequest"_s
            },
            {
                "WebCore::ResourceResponse"_s,
                "response"_s
            },
        } },
        { "WebKit::WebPageCreationParameters"_s, {
            {
                "WebCore::IntSize"_s,
                "viewSize"_s
            },
            {
                "OptionSet<WebCore::ActivityState>"_s,
                "activityState"_s
            },
            {
                "WebKit::WebPreferencesStore"_s,
                "store"_s
            },
#if ENABLE(TILED_CA_DRAWING_AREA)
            {
                "WebKit::DrawingAreaType"_s,
                "drawingAreaType"_s
            },
#endif
            {
                "WebKit::DrawingAreaIdentifier"_s,
                "drawingAreaIdentifier"_s
            },
            {
                "WebKit::WebPageProxyIdentifier"_s,
                "webPageProxyIdentifier"_s
            },
            {
                "WebKit::WebPageGroupData"_s,
                "pageGroupData"_s
            },
            {
                "bool"_s,
                "isEditable"_s
            },
            {
                "WebCore::Color"_s,
                "underlayColor"_s
            },
            {
                "bool"_s,
                "useFixedLayout"_s
            },
            {
                "WebCore::IntSize"_s,
                "fixedLayoutSize"_s
            },
            {
                "WebCore::FloatSize"_s,
                "defaultUnobscuredSize"_s
            },
            {
                "WebCore::FloatSize"_s,
                "minimumUnobscuredSize"_s
            },
            {
                "WebCore::FloatSize"_s,
                "maximumUnobscuredSize"_s
            },
            {
                "std::optional<WebCore::FloatRect>"_s,
                "viewExposedRect"_s
            },
            {
                "std::optional<uint32_t>"_s,
                "displayID"_s
            },
            {
                "std::optional<unsigned>"_s,
                "nominalFramesPerSecond"_s
            },
            {
                "bool"_s,
                "alwaysShowsHorizontalScroller"_s
            },
            {
                "bool"_s,
                "alwaysShowsVerticalScroller"_s
            },
            {
                "bool"_s,
                "suppressScrollbarAnimations"_s
            },
            {
                "WebCore::PaginationMode"_s,
                "paginationMode"_s
            },
            {
                "bool"_s,
                "paginationBehavesLikeColumns"_s
            },
            {
                "double"_s,
                "pageLength"_s
            },
            {
                "double"_s,
                "gapBetweenPages"_s
            },
            {
                "String"_s,
                "userAgent"_s
            },
            {
                "WebKit::VisitedLinkTableIdentifier"_s,
                "visitedLinkTableID"_s
            },
            {
                "bool"_s,
                "canRunBeforeUnloadConfirmPanel"_s
            },
            {
                "bool"_s,
                "canRunModal"_s
            },
            {
                "float"_s,
                "deviceScaleFactor"_s
            },
#if USE(GRAPHICS_LAYER_WC) || USE(GRAPHICS_LAYER_TEXTURE_MAPPER)
            {
                "float"_s,
                "intrinsicDeviceScaleFactor"_s
            },
#endif
            {
                "float"_s,
                "viewScaleFactor"_s
            },
            {
                "double"_s,
                "textZoomFactor"_s
            },
            {
                "double"_s,
                "pageZoomFactor"_s
            },
            {
                "WebCore::FloatBoxExtent"_s,
                "obscuredContentInsets"_s
            },
            {
                "float"_s,
                "mediaVolume"_s
            },
            {
                "WebCore::MediaProducerMutedStateFlags"_s,
                "muted"_s
            },
            {
                "bool"_s,
                "openedByDOM"_s
            },
            {
                "bool"_s,
                "mayStartMediaWhenInWindow"_s
            },
            {
                "bool"_s,
                "mediaPlaybackIsSuspended"_s
            },
            {
                "WebCore::IntSize"_s,
                "minimumSizeForAutoLayout"_s
            },
            {
                "WebCore::IntSize"_s,
                "sizeToContentAutoSizeMaximumSize"_s
            },
            {
                "bool"_s,
                "autoSizingShouldExpandToViewHeight"_s
            },
            {
                "std::optional<WebCore::FloatSize>"_s,
                "viewportSizeForCSSViewportUnits"_s
            },
            {
                "WebCore::ScrollPinningBehavior"_s,
                "scrollPinningBehavior"_s
            },
            {
                "std::optional<WebCore::ScrollbarOverlayStyle>"_s,
                "scrollbarOverlayStyle"_s
            },
            {
                "bool"_s,
                "backgroundExtendsBeyondPage"_s
            },
            {
                "bool"_s,
                "hasResourceLoadClient"_s
            },
            {
                "Vector<String>"_s,
                "mimeTypesWithCustomContentProviders"_s
            },
            {
                "bool"_s,
                "controlledByAutomation"_s
            },
            {
                "bool"_s,
                "isProcessSwap"_s
            },
            {
                "bool"_s,
                "useDarkAppearance"_s
            },
            {
                "bool"_s,
                "useElevatedUserInterfaceLevel"_s
            },
#if PLATFORM(MAC)
            {
                "std::optional<WebCore::DestinationColorSpace>"_s,
                "colorSpace"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "bool"_s,
                "useFormSemanticContext"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "int"_s,
                "headerBannerHeight"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "int"_s,
                "footerBannerHeight"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "std::optional<WebKit::ViewWindowCoordinates>"_s,
                "viewWindowCoordinates"_s
            },
#endif
#if ENABLE(META_VIEWPORT)
            {
                "bool"_s,
                "ignoresViewportScaleLimits"_s
            },
#endif
#if ENABLE(META_VIEWPORT)
            {
                "WebCore::FloatSize"_s,
                "viewportConfigurationViewLayoutSize"_s
            },
#endif
#if ENABLE(META_VIEWPORT)
            {
                "double"_s,
                "viewportConfigurationLayoutSizeScaleFactorFromClient"_s
            },
#endif
#if ENABLE(META_VIEWPORT)
            {
                "double"_s,
                "viewportConfigurationMinimumEffectiveDeviceWidth"_s
            },
#endif
#if ENABLE(META_VIEWPORT)
            {
                "WebCore::FloatSize"_s,
                "viewportConfigurationViewSize"_s
            },
#endif
#if ENABLE(META_VIEWPORT)
            {
                "std::optional<WebCore::ViewportArguments>"_s,
                "overrideViewportArguments"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::FloatSize"_s,
                "screenSize"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::FloatSize"_s,
                "availableScreenSize"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::FloatSize"_s,
                "overrideScreenSize"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::FloatSize"_s,
                "overrideAvailableScreenSize"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "float"_s,
                "textAutosizingWidth"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::IntDegrees"_s,
                "deviceOrientation"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebKit::HardwareKeyboardState"_s,
                "hardwareKeyboardState"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "canShowWhileLocked"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "isCapturingScreen"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::Color"_s,
                "insertionPointColor"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "smartInsertDeleteEnabled"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "Vector<String>"_s,
                "additionalSupportedImageTypes"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "Vector<WebKit::SandboxExtensionHandle>"_s,
                "gpuIOKitExtensionHandles"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "Vector<WebKit::SandboxExtensionHandle>"_s,
                "gpuMachExtensionHandles"_s
            },
#endif
#if ENABLE(TILED_CA_DRAWING_AREA)
            {
                "WebKit::SandboxExtensionHandle"_s,
                "renderServerMachExtensionHandle"_s
            },
#endif
#if HAVE(STATIC_FONT_REGISTRY)
            {
                "Vector<WebKit::SandboxExtensionHandle>"_s,
                "fontMachExtensionHandles"_s
            },
#endif
#if HAVE(APP_ACCENT_COLORS)
            {
                "WebCore::Color"_s,
                "accentColor"_s
            },
#endif
#if HAVE(APP_ACCENT_COLORS) && PLATFORM(MAC)
            {
                "bool"_s,
                "appUsesCustomAccentColor"_s
            },
#endif
#if USE(WPE_RENDERER)
            {
                "UnixFileDescriptor"_s,
                "hostFileDescriptor"_s
            },
#endif
#if USE(GRAPHICS_LAYER_TEXTURE_MAPPER) || USE(GRAPHICS_LAYER_WC)
            {
                "uint64_t"_s,
                "nativeWindowHandle"_s
            },
#endif
#if USE(GRAPHICS_LAYER_WC)
            {
                "bool"_s,
                "usesOffscreenRendering"_s
            },
#endif
            {
                "bool"_s,
                "shouldScaleViewToFitDocument"_s
            },
            {
                "WebCore::UserInterfaceLayoutDirection"_s,
                "userInterfaceLayoutDirection"_s
            },
            {
                "OptionSet<WebCore::LayoutMilestone>"_s,
                "observedLayoutMilestones"_s
            },
            {
                "String"_s,
                "overrideContentSecurityPolicy"_s
            },
            {
                "std::optional<double>"_s,
                "cpuLimit"_s
            },
            {
                "HashMap<String, WebKit::WebURLSchemeHandlerIdentifier>"_s,
                "urlSchemeHandlers"_s
            },
            {
                "Vector<String>"_s,
                "urlSchemesWithLegacyCustomProtocolHandlers"_s
            },
#if ENABLE(APPLICATION_MANIFEST)
            {
                "std::optional<WebCore::ApplicationManifest>"_s,
                "applicationManifest"_s
            },
#endif
            {
                "bool"_s,
                "needsFontAttributes"_s
            },
            {
                "bool"_s,
                "needsScrollGeometryUpdates"_s
            },
            {
                "bool"_s,
                "iceCandidateFilteringEnabled"_s
            },
            {
                "bool"_s,
                "enumeratingAllNetworkInterfacesEnabled"_s
            },
            {
                "WebKit::UserContentControllerParameters"_s,
                "userContentControllerParameters"_s
            },
#if ENABLE(WK_WEB_EXTENSIONS)
            {
                "std::optional<WebKit::WebExtensionControllerParameters>"_s,
                "webExtensionControllerParameters"_s
            },
#endif
            {
                "std::optional<WebCore::Color>"_s,
                "backgroundColor"_s
            },
            {
                "std::optional<WebCore::PageIdentifier>"_s,
                "oldPageID"_s
            },
            {
                "String"_s,
                "overriddenMediaType"_s
            },
            {
                "Vector<String>"_s,
                "corsDisablingPatterns"_s
            },
            {
                "HashSet<String>"_s,
                "maskedURLSchemes"_s
            },
            {
                "bool"_s,
                "loadsSubresources"_s
            },
            {
                "std::optional<MemoryCompactLookupOnlyRobinHoodHashSet<String>>"_s,
                "allowedNetworkHosts"_s
            },
            {
                "std::optional<std::pair<uint16_t, uint16_t>>"_s,
                "portsForUpgradingInsecureSchemeForTesting"_s
            },
            {
                "bool"_s,
                "crossOriginAccessControlCheckEnabled"_s
            },
            {
                "String"_s,
                "processDisplayName"_s
            },
            {
                "bool"_s,
                "shouldCaptureAudioInUIProcess"_s
            },
            {
                "bool"_s,
                "shouldCaptureAudioInGPUProcess"_s
            },
            {
                "bool"_s,
                "shouldCaptureVideoInUIProcess"_s
            },
            {
                "bool"_s,
                "shouldCaptureVideoInGPUProcess"_s
            },
            {
                "bool"_s,
                "shouldCaptureDisplayInUIProcess"_s
            },
            {
                "bool"_s,
                "shouldCaptureDisplayInGPUProcess"_s
            },
            {
                "bool"_s,
                "shouldRenderCanvasInGPUProcess"_s
            },
            {
                "bool"_s,
                "shouldRenderDOMInGPUProcess"_s
            },
            {
                "bool"_s,
                "shouldPlayMediaInGPUProcess"_s
            },
#if ENABLE(WEBGL)
            {
                "bool"_s,
                "shouldRenderWebGLInGPUProcess"_s
            },
#endif
            {
                "bool"_s,
                "shouldEnableVP8Decoder"_s
            },
            {
                "bool"_s,
                "shouldEnableVP9Decoder"_s
            },
#if ENABLE(APP_BOUND_DOMAINS)
            {
                "bool"_s,
                "limitsNavigationsToAppBoundDomains"_s
            },
#endif
            {
                "bool"_s,
                "lastNavigationWasAppInitiated"_s
            },
            {
                "bool"_s,
                "canUseCredentialStorage"_s
            },
            {
                "WebCore::ShouldRelaxThirdPartyCookieBlocking"_s,
                "shouldRelaxThirdPartyCookieBlocking"_s
            },
            {
                "bool"_s,
                "httpsUpgradeEnabled"_s
            },
#if ENABLE(APP_HIGHLIGHTS)
            {
                "WebCore::HighlightVisibility"_s,
                "appHighlightsVisible"_s
            },
#endif
#if HAVE(TOUCH_BAR)
            {
                "bool"_s,
                "requiresUserActionForEditingControlsManager"_s
            },
#endif
            {
                "bool"_s,
                "hasResizableWindows"_s
            },
            {
                "WebCore::ContentSecurityPolicyModeForExtension"_s,
                "contentSecurityPolicyModeForExtension"_s
            },
            {
                "std::optional<WebKit::RemotePageParameters>"_s,
                "remotePageParameters"_s
            },
            {
                "std::optional<WebKit::ProvisionalFrameCreationParameters>"_s,
                "provisionalFrameCreationParameters"_s
            },
            {
                "WebCore::FrameIdentifier"_s,
                "mainFrameIdentifier"_s
            },
            {
                "String"_s,
                "openedMainFrameName"_s
            },
            {
                "std::optional<WebCore::FrameIdentifier>"_s,
                "mainFrameOpenerIdentifier"_s
            },
            {
                "WebCore::SandboxFlags"_s,
                "initialSandboxFlags"_s
            },
            {
                "std::optional<WebCore::WindowFeatures>"_s,
                "windowFeatures"_s
            },
#if ENABLE(ADVANCED_PRIVACY_PROTECTIONS)
            {
                "Vector<WebCore::LinkDecorationFilteringData>"_s,
                "linkDecorationFilteringData"_s
            },
#endif
#if ENABLE(ADVANCED_PRIVACY_PROTECTIONS)
            {
                "Vector<WebCore::LinkDecorationFilteringData>"_s,
                "allowedQueryParametersForAdvancedPrivacyProtections"_s
            },
#endif
#if HAVE(MACH_BOOTSTRAP_EXTENSION)
            {
                "WebKit::SandboxExtensionHandle"_s,
                "machBootstrapHandle"_s
            },
#endif
#if (PLATFORM(GTK) || PLATFORM(WPE)) && (USE(GBM))
            {
                "Vector<WebKit::RendererBufferFormat>"_s,
                "preferredBufferFormats"_s
            },
#endif
#if PLATFORM(VISION) && ENABLE(GAMEPAD)
            {
                "WebCore::ShouldRequireExplicitConsentForGamepadAccess"_s,
                "gamepadAccessRequiresExplicitConsent"_s
            },
#endif
#if HAVE(AUDIT_TOKEN)
            {
                "std::optional<WebKit::CoreIPCAuditToken>"_s,
                "presentingApplicationAuditToken"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "String"_s,
                "presentingApplicationBundleIdentifier"_s
            },
#endif
            {
                "bool"_s,
                "shouldSendConsoleLogsToUIProcessForTesting"_s
            },
        } },
        { "WebKit::RemotePageParameters"_s, {
            {
                "URL"_s,
                "initialMainDocumentURL"_s
            },
            {
                "WebKit::FrameTreeCreationParameters"_s,
                "frameTreeParameters"_s
            },
            {
                "std::optional<WebKit::WebsitePoliciesData>"_s,
                "websitePoliciesData"_s
            },
        } },
        { "WebKit::WebPageGroupData"_s, {
            {
                "String"_s,
                "identifier"_s
            },
            {
                "WebKit::PageGroupIdentifier"_s,
                "pageGroupID"_s
            },
        } },
        { "WebKit::WebPageNetworkParameters"_s, {
            {
                "String"_s,
                "attributedBundleIdentifier()"_s
            },
        } },
        { "WebKit::WebPopupItem"_s, {
            {
                "WebKit::WebPopupItem::Type"_s,
                "m_type"_s
            },
            {
                "String"_s,
                "m_text"_s
            },
            {
                "String"_s,
                "m_language"_s
            },
            {
                "WebCore::TextDirection"_s,
                "m_textDirection"_s
            },
            {
                "bool"_s,
                "m_hasTextDirectionOverride"_s
            },
            {
                "String"_s,
                "m_toolTip"_s
            },
            {
                "String"_s,
                "m_accessibilityText"_s
            },
            {
                "bool"_s,
                "m_isEnabled"_s
            },
            {
                "bool"_s,
                "m_isLabel"_s
            },
            {
                "bool"_s,
                "m_isSelected"_s
            },
        } },
        { "WebKit::WebPreferencesStore"_s, {
            {
                "WebKit::WebPreferencesStore::ValueMap"_s,
                "m_values"_s
            },
            {
                "WebKit::WebPreferencesStore::ValueMap"_s,
                "m_overriddenDefaults"_s
            },
        } },
        { "WebKit::WebProcessCreationParameters"_s, {
            {
                "WebKit::AuxiliaryProcessCreationParameters"_s,
                "auxiliaryProcessParameters"_s
            },
            {
                "String"_s,
                "injectedBundlePath"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "injectedBundlePathExtensionHandle"_s
            },
            {
                "Vector<WebKit::SandboxExtensionHandle>"_s,
                "additionalSandboxExtensionHandles"_s
            },
            {
                "WebKit::UserData"_s,
                "initializationUserData"_s
            },
#if PLATFORM(COCOA) && ENABLE(REMOTE_INSPECTOR)
            {
                "Vector<WebKit::SandboxExtensionHandle>"_s,
                "enableRemoteWebInspectorExtensionHandles"_s
            },
#endif
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsEmptyDocument"_s
            },
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsSecure"_s
            },
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsBypassingContentSecurityPolicy"_s
            },
            {
                "Vector<String>"_s,
                "urlSchemesForWhichDomainRelaxationIsForbidden"_s
            },
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsLocal"_s
            },
#if ENABLE(ALL_LEGACY_REGISTERED_SPECIAL_URL_SCHEMES)
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsNoAccess"_s
            },
#endif
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsDisplayIsolated"_s
            },
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsCORSEnabled"_s
            },
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsAlwaysRevalidated"_s
            },
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsCachePartitioned"_s
            },
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsCanDisplayOnlyIfCanRequest"_s
            },
#if ENABLE(WK_WEB_EXTENSIONS)
            {
                "Vector<String>"_s,
                "urlSchemesRegisteredAsWebExtensions"_s
            },
#endif
            {
                "Vector<String>"_s,
                "fontAllowList"_s
            },
            {
                "Vector<String>"_s,
                "overrideLanguages"_s
            },
#if USE(GSTREAMER)
            {
                "Vector<String>"_s,
                "gstreamerOptions"_s
            },
#endif
            {
                "WebKit::CacheModel"_s,
                "cacheModel"_s
            },
            {
                "Markable<double>"_s,
                "defaultRequestTimeoutInterval"_s
            },
            {
                "unsigned"_s,
                "backForwardCacheCapacity"_s
            },
            {
                "bool"_s,
                "shouldAlwaysUseComplexTextCodePath"_s
            },
            {
                "bool"_s,
                "shouldEnableMemoryPressureReliefLogging"_s
            },
            {
                "bool"_s,
                "shouldSuppressMemoryPressureHandler"_s
            },
            {
                "bool"_s,
                "disableFontSubpixelAntialiasingForTesting"_s
            },
            {
                "bool"_s,
                "fullKeyboardAccessEnabled"_s
            },
#if HAVE(MOUSE_DEVICE_OBSERVATION)
            {
                "bool"_s,
                "hasMouseDevice"_s
            },
#endif
#if HAVE(STYLUS_DEVICE_OBSERVATION)
            {
                "bool"_s,
                "hasStylusDevice"_s
            },
#endif
            {
                "bool"_s,
                "memoryCacheDisabled"_s
            },
            {
                "bool"_s,
                "attrStyleEnabled"_s
            },
            {
                "bool"_s,
                "shouldThrowExceptionForGlobalConstantRedeclaration"_s
            },
            {
                "WebCore::CrossOriginMode"_s,
                "crossOriginMode"_s
            },
#if ENABLE(SERVICE_CONTROLS)
            {
                "bool"_s,
                "hasImageServices"_s
            },
#endif
#if ENABLE(SERVICE_CONTROLS)
            {
                "bool"_s,
                "hasSelectionServices"_s
            },
#endif
#if ENABLE(SERVICE_CONTROLS)
            {
                "bool"_s,
                "hasRichContentServices"_s
            },
#endif
            {
                "OptionSet<WebKit::TextCheckerState>"_s,
                "textCheckerState"_s
            },
#if PLATFORM(COCOA)
            {
                "String"_s,
                "uiProcessBundleIdentifier"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "int"_s,
                "latencyQOS"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "int"_s,
                "throughputQOS"_s
            },
#endif
            {
                "ProcessID"_s,
                "presentingApplicationPID"_s
            },
#if PLATFORM(COCOA)
            {
                "String"_s,
                "uiProcessBundleResourcePath"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "WebKit::SandboxExtensionHandle"_s,
                "uiProcessBundleResourcePathExtensionHandle"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "shouldEnableJIT"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "shouldEnableFTLJIT"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "accessibilityEnhancedUserInterfaceEnabled"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "RefPtr<API::Data>"_s,
                "bundleParameterData"_s
            },
#endif
#if ENABLE(NOTIFICATIONS)
            {
                "HashMap<String, bool>"_s,
                "notificationPermissions"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "RetainPtr<CFDataRef>"_s,
                "networkATSContext"_s
            },
#endif
#if PLATFORM(WAYLAND)
            {
                "String"_s,
                "waylandCompositorDisplayName"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "Vector<String>"_s,
                "mediaMIMETypes"_s
            },
#endif
#if PLATFORM(COCOA) || PLATFORM(GTK) || (PLATFORM(WPE) && ENABLE(WPE_PLATFORM))
            {
                "WebCore::ScreenProperties"_s,
                "screenProperties"_s
            },
#endif
#if !RELEASE_LOG_DISABLED
            {
                "bool"_s,
                "shouldLogUserInteraction"_s
            },
#endif
#if PLATFORM(MAC)
            {
                "bool"_s,
                "useOverlayScrollbars"_s
            },
#endif
#if USE(WPE_RENDERER)
            {
                "bool"_s,
                "isServiceWorkerProcess"_s
            },
#endif
#if USE(WPE_RENDERER)
            {
                "UnixFileDescriptor"_s,
                "hostClientFileDescriptor"_s
            },
#endif
#if USE(WPE_RENDERER)
            {
                "CString"_s,
                "implementationLibraryName"_s
            },
#endif
            {
                "std::optional<WebKit::WebProcessDataStoreParameters>"_s,
                "websiteDataStoreParameters"_s
            },
            {
                "std::optional<WebKit::SandboxExtensionHandle>"_s,
                "mobileGestaltExtensionHandle"_s
            },
            {
                "std::optional<WebKit::SandboxExtensionHandle>"_s,
                "launchServicesExtensionHandle"_s
            },
#if (PLATFORM(MAC) || PLATFORM(MACCATALYST)) && HAVE(VIDEO_RESTRICTED_DECODING)
            {
                "WebKit::SandboxExtensionHandle"_s,
                "trustdExtensionHandle"_s
            },
#endif
#if HAVE(VIDEO_RESTRICTED_DECODING)
            {
                "bool"_s,
                "enableDecodingHEIC"_s
            },
#endif
#if HAVE(VIDEO_RESTRICTED_DECODING)
            {
                "bool"_s,
                "enableDecodingAVIF"_s
            },
#endif
#if PLATFORM(VISION)
            {
                "Vector<WebKit::SandboxExtensionHandle>"_s,
                "metalCacheDirectoryExtensionHandles"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "systemHasBattery"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "systemHasAC"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "PAL::UserInterfaceIdiom"_s,
                "currentUserInterfaceIdiom"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "supportsPictureInPicture"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::RenderThemeIOS::CSSValueToSystemColorMap"_s,
                "cssValueToSystemColorMap"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebCore::Color"_s,
                "focusRingColor"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "String"_s,
                "localizedDeviceModel"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "String"_s,
                "contentSizeCategory"_s
            },
#endif
#if USE(GBM)
            {
                "WebCore::DRMDevice"_s,
                "drmDevice"_s
            },
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            {
                "OptionSet<WebKit::RendererBufferTransportMode>"_s,
                "rendererBufferTransportMode"_s
            },
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            {
                "WebCore::SystemSettings::State"_s,
                "systemSettings"_s
            },
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            {
                "std::optional<WTF::MemoryPressureHandler::Configuration>"_s,
                "memoryPressureHandlerConfiguration"_s
            },
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            {
                "bool"_s,
                "disableFontHintingForTesting"_s
            },
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            {
                "OptionSet<WebKit::AvailableInputDevices>"_s,
                "availableInputDevices"_s
            },
#endif
#if PLATFORM(GTK)
            {
                "bool"_s,
                "useSystemAppearanceForScrollbars"_s
            },
#endif
#if HAVE(CATALYST_USER_INTERFACE_IDIOM_AND_SCALE_FACTOR)
            {
                "std::pair<int64_t, double>"_s,
                "overrideUserInterfaceIdiomAndScale"_s
            },
#endif
#if HAVE(IOSURFACE)
            {
                "WebCore::IntSize"_s,
                "maximumIOSurfaceSize"_s
            },
#endif
#if HAVE(IOSURFACE)
            {
                "uint64_t"_s,
                "bytesPerRowIOSurfaceAlignment"_s
            },
#endif
            {
                "WebKit::AccessibilityPreferences"_s,
                "accessibilityPreferences"_s
            },
#if PLATFORM(IOS_FAMILY)
            {
                "bool"_s,
                "applicationAccessibilityEnabled"_s
            },
#endif
#if USE(GLIB)
            {
                "String"_s,
                "applicationID"_s
            },
#endif
#if USE(GLIB)
            {
                "String"_s,
                "applicationName"_s
            },
#endif
#if USE(GLIB) && ENABLE(REMOTE_INSPECTOR)
            {
                "CString"_s,
                "inspectorServerAddress"_s
            },
#endif
#if USE(ATSPI)
            {
                "String"_s,
                "accessibilityBusAddress"_s
            },
#endif
#if USE(ATSPI)
            {
                "String"_s,
                "accessibilityBusName"_s
            },
#endif
            {
                "String"_s,
                "timeZoneOverride"_s
            },
            {
                "HashMap<WebCore::RegistrableDomain, String>"_s,
                "storageAccessUserAgentStringQuirksData"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "storageAccessPromptQuirksDomains"_s
            },
            {
                "WebKit::ScriptTrackingPrivacyRules"_s,
                "scriptTrackingPrivacyRules"_s
            },
            {
                "Seconds"_s,
                "memoryFootprintPollIntervalForTesting"_s
            },
            {
                "Vector<uint64_t>"_s,
                "memoryFootprintNotificationThresholds"_s
            },
#if ENABLE(NOTIFY_BLOCKING)
            {
                "Vector<std::pair<String, uint64_t>>"_s,
                "notifyState"_s
            },
#endif
#if ENABLE(INITIALIZE_ACCESSIBILITY_ON_DEMAND)
            {
                "bool"_s,
                "shouldInitializeAccessibility"_s
            },
#endif
#if HAVE(LIQUID_GLASS)
            {
                "bool"_s,
                "isLiquidGlassEnabled"_s
            },
#endif
        } },
        { "WebKit::WebProcessDataStoreParameters"_s, {
            {
                "PAL::SessionID"_s,
                "sessionID"_s
            },
            {
                "String"_s,
                "mediaCacheDirectory"_s
            },
#if !ENABLE(GPU_PROCESS)
            {
                "WebKit::SandboxExtensionHandle"_s,
                "mediaCacheDirectoryExtensionHandle"_s
            },
#endif
            {
                "String"_s,
                "mediaKeyStorageDirectory"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "mediaKeyStorageDirectoryExtensionHandle"_s
            },
            {
                "FileSystem::Salt"_s,
                "mediaKeysStorageSalt"_s
            },
            {
                "String"_s,
                "javaScriptConfigurationDirectory"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "javaScriptConfigurationDirectoryExtensionHandle"_s
            },
            {
                "WebCore::ThirdPartyCookieBlockingMode"_s,
                "thirdPartyCookieBlockingMode"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "domainsWithUserInteraction"_s
            },
            {
                "HashMap<WebCore::RegistrableDomain, Vector<WebCore::RegistrableDomain>>"_s,
                "domainsWithStorageAccessQuirk"_s
            },
#if ENABLE(ARKIT_INLINE_PREVIEW) && !PLATFORM(IOS_FAMILY)
            {
                "String"_s,
                "modelElementCacheDirectory"_s
            },
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW) && !PLATFORM(IOS_FAMILY)
            {
                "WebKit::SandboxExtensionHandle"_s,
                "modelElementCacheDirectoryExtensionHandle"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "WebKit::SandboxExtensionHandle"_s,
                "containerTemporaryDirectoryExtensionHandle"_s
            },
#endif
            {
                "bool"_s,
                "trackingPreventionEnabled"_s
            },
#if HAVE(ALLOW_ONLY_PARTITIONED_COOKIES)
            {
                "bool"_s,
                "isOptInCookiePartitioningEnabled"_s
            },
#endif
        } },
        { "WebKit::WebPushD::WebPushDaemonConnectionConfiguration"_s, {
            {
                "Vector<uint8_t>"_s,
                "hostAppAuditTokenData"_s
            },
            {
                "String"_s,
                "bundleIdentifierOverride"_s
            },
            {
                "String"_s,
                "pushPartitionString"_s
            },
            {
                "std::optional<WTF::UUID>"_s,
                "dataStoreIdentifier"_s
            },
            {
                "bool"_s,
                "declarativeWebPushEnabled"_s
            },
        } },
        { "WebKit::WebPushMessage"_s, {
            {
                "std::optional<Vector<uint8_t>>"_s,
                "pushData"_s
            },
            {
                "String"_s,
                "pushPartitionString"_s
            },
            {
                "URL"_s,
                "registrationURL"_s
            },
            {
                "std::optional<WebCore::NotificationPayload>"_s,
                "notificationPayload"_s
            },
        } },
        { "WebKit::WebUserScriptData"_s, {
            {
                "WebKit::UserScriptIdentifier"_s,
                "identifier"_s
            },
            {
                "WebKit::ContentWorldIdentifier"_s,
                "worldIdentifier"_s
            },
            {
                "WebCore::UserScript"_s,
                "userScript"_s
            },
        } },
        { "WebKit::WebUserStyleSheetData"_s, {
            {
                "WebKit::UserStyleSheetIdentifier"_s,
                "identifier"_s
            },
            {
                "WebKit::ContentWorldIdentifier"_s,
                "worldIdentifier"_s
            },
            {
                "WebCore::UserStyleSheet"_s,
                "userStyleSheet"_s
            },
        } },
        { "WebKit::WebScriptMessageHandlerData"_s, {
            {
                "WebKit::ScriptMessageHandlerIdentifier"_s,
                "identifier"_s
            },
            {
                "WebKit::ContentWorldIdentifier"_s,
                "worldIdentifier"_s
            },
            {
                "String"_s,
                "name"_s
            },
        } },
        { "WebKit::WebsiteDataStoreParameters"_s, {
            {
                "Vector<uint8_t>"_s,
                "uiProcessCookieStorageIdentifier"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "cookieStoragePathExtensionHandle"_s
            },
            {
                "WebKit::NetworkSessionCreationParameters"_s,
                "networkSessionParameters"_s
            },
#if PLATFORM(IOS_FAMILY)
            {
                "std::optional<WebKit::SandboxExtensionHandle>"_s,
                "cookieStorageDirectoryExtensionHandle"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "std::optional<WebKit::SandboxExtensionHandle>"_s,
                "containerCachesDirectoryExtensionHandle"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "std::optional<WebKit::SandboxExtensionHandle>"_s,
                "parentBundleDirectoryExtensionHandle"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "std::optional<WebKit::SandboxExtensionHandle>"_s,
                "tempDirectoryExtensionHandle"_s
            },
#endif
#if PLATFORM(IOS_FAMILY)
            {
                "std::optional<WebKit::SandboxExtensionHandle>"_s,
                "tempDirectoryRootExtensionHandle"_s
            },
#endif
        } },
        { "WebKit::WebsitePoliciesData"_s, {
            {
                "HashMap<String, Vector<String>>"_s,
                "activeContentRuleListActionPatterns"_s
            },
            {
                "Vector<WebCore::CustomHeaderFields>"_s,
                "customHeaderFields"_s
            },
            {
                "Vector<WebCore::TargetedElementSelectors>"_s,
                "visibilityAdjustmentSelectors"_s
            },
            {
                "String"_s,
                "customUserAgent"_s
            },
            {
                "String"_s,
                "customUserAgentAsSiteSpecificQuirks"_s
            },
            {
                "String"_s,
                "customNavigatorPlatform"_s
            },
            {
                "String"_s,
                "applicationNameForDesktopUserAgent"_s
            },
            {
                "OptionSet<WebCore::AdvancedPrivacyProtections>"_s,
                "advancedPrivacyProtections"_s
            },
            {
                "OptionSet<WebKit::WebsiteAutoplayQuirk>"_s,
                "allowedAutoplayQuirks"_s
            },
            {
                "WebCore::ContentExtensionEnablement"_s,
                "contentExtensionEnablement"_s
            },
#if ENABLE(TOUCH_EVENTS)
            {
                "std::optional<bool>"_s,
                "overrideTouchEventDOMAttributesEnabled"_s
            },
#endif
            {
                "WebKit::WebsiteAutoplayPolicy"_s,
                "autoplayPolicy"_s
            },
            {
                "WebKit::WebsitePopUpPolicy"_s,
                "popUpPolicy"_s
            },
            {
                "WebKit::WebsiteMetaViewportPolicy"_s,
                "metaViewportPolicy"_s
            },
            {
                "WebKit::WebsiteMediaSourcePolicy"_s,
                "mediaSourcePolicy"_s
            },
            {
                "WebKit::WebsiteSimulatedMouseEventsDispatchPolicy"_s,
                "simulatedMouseEventsDispatchPolicy"_s
            },
            {
                "WebKit::WebsiteLegacyOverflowScrollingTouchPolicy"_s,
                "legacyOverflowScrollingTouchPolicy"_s
            },
            {
                "WebCore::AllowsContentJavaScript"_s,
                "allowsContentJavaScript"_s
            },
            {
                "WebCore::MouseEventPolicy"_s,
                "mouseEventPolicy"_s
            },
            {
                "WebCore::ModalContainerObservationPolicy"_s,
                "modalContainerObservationPolicy"_s
            },
            {
                "WebCore::ColorSchemePreference"_s,
                "colorSchemePreference"_s
            },
            {
                "WebKit::WebContentMode"_s,
                "preferredContentMode"_s
            },
#if ENABLE(DEVICE_ORIENTATION)
            {
                "std::optional<WebCore::DeviceOrientationOrMotionPermissionState>"_s,
                "deviceOrientationAndMotionAccessState"_s
            },
#endif
            {
                "WebCore::HTTPSByDefaultMode"_s,
                "httpsByDefaultMode"_s
            },
            {
                "bool"_s,
                "idempotentModeAutosizingOnlyHonorsPercentages"_s
            },
            {
                "bool"_s,
                "allowPrivacyProxy"_s
            },
            {
                "bool"_s,
                "allowSiteSpecificQuirksToOverrideContentMode"_s
            },
            {
                "WebKit::WebsitePushAndNotificationsEnabledPolicy"_s,
                "pushAndNotificationsEnabledPolicy"_s
            },
            {
                "WebKit::WebsiteInlineMediaPlaybackPolicy"_s,
                "inlineMediaPlaybackPolicy"_s
            },
        } },
        { "API::Array"_s, {
            {
                "Vector<RefPtr<API::Object>>"_s,
                "elements()"_s
            },
        } },
        { "API::Data"_s, {
            {
                "std::span<const uint8_t>"_s,
                "span()"_s
            },
        } },
        { "API::Dictionary"_s, {
            {
                "HashMap<String, RefPtr<API::Object>>"_s,
                "map()"_s
            },
        } },
        { "API::Error"_s, {
            {
                "WebCore::ResourceError"_s,
                "platformError()"_s
            },
        } },
        { "API::FrameHandle"_s, {
            {
                "Markable<WebCore::FrameIdentifier>"_s,
                "frameID()"_s
            },
            {
                "bool"_s,
                "isAutoconverting()"_s
            },
        } },
        { "API::Size"_s, {
            {
                "double"_s,
                "size().width"_s
            },
            {
                "double"_s,
                "size().height"_s
            },
        } },
        { "API::Point"_s, {
            {
                "double"_s,
                "point().x"_s
            },
            {
                "double"_s,
                "point().y"_s
            },
        } },
        { "API::Rect"_s, {
            {
                "double"_s,
                "rect().origin.x"_s
            },
            {
                "double"_s,
                "rect().origin.y"_s
            },
            {
                "double"_s,
                "rect().size.width"_s
            },
            {
                "double"_s,
                "rect().size.height"_s
            },
        } },
        { "API::Boolean"_s, {
            {
                "bool"_s,
                "value()"_s
            },
        } },
        { "API::Double"_s, {
            {
                "double"_s,
                "value()"_s
            },
        } },
        { "API::UInt64"_s, {
            {
                "uint64_t"_s,
                "value()"_s
            },
        } },
        { "API::Int64"_s, {
            {
                "int64_t"_s,
                "value()"_s
            },
        } },
        { "API::Object"_s, {
            { "Variant<"
                "API::Array"
                ", API::Boolean"
                ", API::Data"
                ", API::Dictionary"
                ", API::Double"
                ", API::Error"
                ", API::FrameHandle"
                ", WebKit::WebImage"
                ", API::PageHandle"
                ", API::Point"
                ", API::Rect"
                ", API::Size"
                ", API::String"
                ", API::URL"
                ", API::URLRequest"
                ", API::URLResponse"
                ", API::UInt64"
                ", API::Int64"
                ", API::UserContentURLPattern"
            ">"_s, "subclasses"_s }
        } },
        { "API::PageHandle"_s, {
            {
                "WebKit::WebPageProxyIdentifier"_s,
                "pageProxyID()"_s
            },
            {
                "WebCore::PageIdentifier"_s,
                "webPageID()"_s
            },
            {
                "bool"_s,
                "isAutoconverting()"_s
            },
        } },
        { "API::String"_s, {
            {
                "String"_s,
                "string()"_s
            },
        } },
        { "API::URL"_s, {
            {
                "String"_s,
                "string()"_s
            },
        } },
        { "API::URLRequest"_s, {
            {
                "WebCore::ResourceRequest"_s,
                "resourceRequest()"_s
            },
        } },
        { "API::URLResponse"_s, {
            {
                "WebCore::ResourceResponse"_s,
                "resourceResponse()"_s
            },
        } },
        { "API::UserContentURLPattern"_s, {
            {
                "String"_s,
                "patternString()"_s
            },
        } },
        { "WebKit::WebIDBResult"_s, {
            {
                "WebCore::IDBResultData"_s,
                "m_resultData"_s
            },
            {
                "Vector<WebKit::SandboxExtensionHandle>"_s,
                "m_handles"_s
            },
        } },
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionAlarmParameters"_s, {
            {
                "String"_s,
                "name"_s
            },
            {
                "Seconds"_s,
                "initialInterval"_s
            },
            {
                "Seconds"_s,
                "repeatInterval"_s
            },
            {
                "MonotonicTime"_s,
                "nextScheduledTime"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS_BOOKMARKS)
        { "WebKit::WebExtensionBookmarksParameters"_s, {
            {
                "String"_s,
                "nodeId"_s
            },
            {
                "std::optional<String>"_s,
                "parentId"_s
            },
            {
                "uint64_t"_s,
                "index"_s
            },
            {
                "String"_s,
                "title"_s
            },
            {
                "std::optional<String>"_s,
                "url"_s
            },
            {
                "std::optional<Vector<WebKit::WebExtensionBookmarksParameters>>"_s,
                "children"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS_BOOKMARKS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionCommandParameters"_s, {
            {
                "String"_s,
                "identifier"_s
            },
            {
                "String"_s,
                "description"_s
            },
            {
                "String"_s,
                "shortcut"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionContextParameters"_s, {
            {
                "WebKit::WebExtensionContextIdentifier"_s,
                "unprivilegedIdentifier"_s
            },
            {
                "Markable<WebKit::WebExtensionContextIdentifier>"_s,
                "privilegedIdentifier"_s
            },
            {
                "URL"_s,
                "baseURL"_s
            },
            {
                "String"_s,
                "uniqueIdentifier"_s
            },
            {
                "HashSet<String>"_s,
                "unsupportedAPIs"_s
            },
            {
                "HashMap<String, WallTime>"_s,
                "grantedPermissions"_s
            },
            {
                "RefPtr<API::Data>"_s,
                "localizationJSON"_s
            },
            {
                "RefPtr<API::Data>"_s,
                "manifestJSON"_s
            },
            {
                "double"_s,
                "manifestVersion"_s
            },
            {
                "bool"_s,
                "isSessionStorageAllowedInContentScripts"_s
            },
            {
                "std::optional<WebCore::PageIdentifier>"_s,
                "backgroundPageIdentifier"_s
            },
#if ENABLE(INSPECTOR_EXTENSIONS)
            {
                "Vector<WebKit::WebExtensionContext::PageIdentifierTuple>"_s,
                "inspectorPageIdentifiers"_s
            },
#endif
#if ENABLE(INSPECTOR_EXTENSIONS)
            {
                "Vector<WebKit::WebExtensionContext::PageIdentifierTuple>"_s,
                "inspectorBackgroundPageIdentifiers"_s
            },
#endif
            {
                "Vector<WebKit::WebExtensionContext::PageIdentifierTuple>"_s,
                "popupPageIdentifiers"_s
            },
            {
                "Vector<WebKit::WebExtensionContext::PageIdentifierTuple>"_s,
                "tabPageIdentifiers"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionControllerParameters"_s, {
            {
                "WebKit::WebExtensionControllerIdentifier"_s,
                "identifier"_s
            },
            {
                "bool"_s,
                "testingMode"_s
            },
            {
                "Vector<WebKit::WebExtensionContextParameters>"_s,
                "contextParameters"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionCookieParameters"_s, {
            {
                "std::optional<PAL::SessionID>"_s,
                "sessionIdentifier"_s
            },
            {
                "WebCore::Cookie"_s,
                "cookie"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionCookieFilterParameters"_s, {
            {
                "std::optional<String>"_s,
                "name"_s
            },
            {
                "std::optional<String>"_s,
                "domain"_s
            },
            {
                "std::optional<String>"_s,
                "path"_s
            },
            {
                "std::optional<bool>"_s,
                "secure"_s
            },
            {
                "std::optional<bool>"_s,
                "session"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionScriptInjectionParameters"_s, {
            {
                "std::optional<WebKit::WebExtensionTabIdentifier>"_s,
                "tabIdentifier"_s
            },
            {
                "std::optional<Ref<API::Data>>"_s,
                "arguments"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "files"_s
            },
            {
                "std::optional<Vector<WebKit::WebExtensionFrameIdentifier>>"_s,
                "frameIdentifiers"_s
            },
            {
                "std::optional<Vector<WTF::UUID>>"_s,
                "documentIdentifiers"_s
            },
            {
                "std::optional<String>"_s,
                "code"_s
            },
            {
                "std::optional<String>"_s,
                "css"_s
            },
            {
                "std::optional<String>"_s,
                "function"_s
            },
            {
                "WebKit::WebExtensionContentWorldType"_s,
                "world"_s
            },
            {
                "WebCore::UserStyleLevel"_s,
                "styleLevel"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionScriptInjectionResultParameters"_s, {
            {
                "std::optional<String>"_s,
                "error"_s
            },
            {
                "std::optional<String>"_s,
                "resultJSON"_s
            },
            {
                "std::optional<WebKit::WebExtensionFrameIdentifier>"_s,
                "frameIdentifier"_s
            },
            {
                "Markable<WTF::UUID>"_s,
                "documentIdentifier"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionRegisteredScriptParameters"_s, {
            {
                "std::optional<Vector<String>>"_s,
                "css"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "js"_s
            },
            {
                "String"_s,
                "identifier"_s
            },
            {
                "std::optional<WebKit::WebExtension::InjectionTime>"_s,
                "injectionTime"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "excludeMatchPatterns"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "matchPatterns"_s
            },
            {
                "std::optional<bool>"_s,
                "allFrames"_s
            },
            {
                "std::optional<WebCore::UserContentMatchParentFrame>"_s,
                "matchParentFrame"_s
            },
            {
                "std::optional<bool>"_s,
                "persistent"_s
            },
            {
                "std::optional<WebKit::WebExtensionContentWorldType>"_s,
                "world"_s
            },
            {
                "std::optional<WebCore::UserStyleLevel>"_s,
                "styleLevel"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionFrameParameters"_s, {
            {
                "bool"_s,
                "errorOccurred"_s
            },
            {
                "std::optional<URL>"_s,
                "url"_s
            },
            {
                "WebKit::WebExtensionFrameIdentifier"_s,
                "parentFrameIdentifier"_s
            },
            {
                "std::optional<WebKit::WebExtensionFrameIdentifier>"_s,
                "frameIdentifier"_s
            },
            {
                "Markable<WTF::UUID>"_s,
                "documentIdentifier"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionMatchedRuleParameters"_s, {
            {
                "URL"_s,
                "url"_s
            },
            {
                "WallTime"_s,
                "timeStamp"_s
            },
            {
                "WebKit::WebExtensionTabIdentifier"_s,
                "tabIdentifier"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionMenuItemParameters"_s, {
            {
                "String"_s,
                "identifier"_s
            },
            {
                "std::optional<String>"_s,
                "parentIdentifier"_s
            },
            {
                "std::optional<WebKit::WebExtensionMenuItemType>"_s,
                "type"_s
            },
            {
                "String"_s,
                "title"_s
            },
            {
                "String"_s,
                "command"_s
            },
            {
                "String"_s,
                "iconsJSON"_s
            },
            {
                "std::optional<bool>"_s,
                "checked"_s
            },
            {
                "std::optional<bool>"_s,
                "enabled"_s
            },
            {
                "std::optional<bool>"_s,
                "visible"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "documentURLPatterns"_s
            },
            {
                "std::optional<Vector<String>>"_s,
                "targetURLPatterns"_s
            },
            {
                "std::optional<OptionSet<WebKit::WebExtensionMenuItemContextType>>"_s,
                "contexts"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionMenuItemContextParameters"_s, {
            {
                "OptionSet<WebKit::WebExtensionMenuItemContextType>"_s,
                "types"_s
            },
            {
                "std::optional<WebKit::WebExtensionTabIdentifier>"_s,
                "tabIdentifier"_s
            },
            {
                "std::optional<WebKit::WebExtensionFrameIdentifier>"_s,
                "frameIdentifier"_s
            },
            {
                "URL"_s,
                "frameURL"_s
            },
            {
                "String"_s,
                "linkText"_s
            },
            {
                "URL"_s,
                "linkURL"_s
            },
            {
                "URL"_s,
                "sourceURL"_s
            },
            {
                "String"_s,
                "selectionString"_s
            },
            {
                "bool"_s,
                "editable"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionMessageSenderParameters"_s, {
            {
                "std::optional<String>"_s,
                "extensionUniqueIdentifier"_s
            },
            {
                "std::optional<WebKit::WebExtensionTabParameters>"_s,
                "tabParameters"_s
            },
            {
                "std::optional<WebKit::WebExtensionFrameIdentifier>"_s,
                "frameIdentifier"_s
            },
            {
                "WebKit::WebPageProxyIdentifier"_s,
                "pageProxyIdentifier"_s
            },
            {
                "WebKit::WebExtensionContentWorldType"_s,
                "contentWorldType"_s
            },
            {
                "URL"_s,
                "url"_s
            },
            {
                "WTF::UUID"_s,
                "documentIdentifier"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionMessageTargetParameters"_s, {
            {
                "std::optional<WebKit::WebPageProxyIdentifier>"_s,
                "pageProxyIdentifier"_s
            },
            {
                "std::optional<WebKit::WebExtensionFrameIdentifier>"_s,
                "frameIdentifier"_s
            },
            {
                "Markable<WTF::UUID>"_s,
                "documentIdentifier"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS_SIDEBAR)
        { "WebKit::WebExtensionSidebarParameters"_s, {
            {
                "bool"_s,
                "enabled"_s
            },
            {
                "String"_s,
                "panelPath"_s
            },
            {
                "std::optional<WebKit::WebExtensionTabIdentifier>"_s,
                "tabIdentifier"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS_SIDEBAR)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionTabParameters"_s, {
            {
                "std::optional<WebKit::WebExtensionTabIdentifier>"_s,
                "identifier"_s
            },
            {
                "std::optional<URL>"_s,
                "url"_s
            },
            {
                "std::optional<String>"_s,
                "title"_s
            },
            {
                "std::optional<WebKit::WebExtensionWindowIdentifier>"_s,
                "windowIdentifier"_s
            },
            {
                "std::optional<uint64_t>"_s,
                "index"_s
            },
#if PLATFORM(COCOA)
            {
                "std::optional<WebKit::DoubleSize>"_s,
                "size"_s
            },
#endif
            {
                "std::optional<WebKit::WebExtensionTabIdentifier>"_s,
                "parentTabIdentifier"_s
            },
            {
                "std::optional<bool>"_s,
                "active"_s
            },
            {
                "std::optional<bool>"_s,
                "selected"_s
            },
            {
                "std::optional<bool>"_s,
                "pinned"_s
            },
            {
                "std::optional<bool>"_s,
                "audible"_s
            },
            {
                "std::optional<bool>"_s,
                "muted"_s
            },
            {
                "std::optional<bool>"_s,
                "loading"_s
            },
            {
                "std::optional<bool>"_s,
                "privateBrowsing"_s
            },
            {
                "std::optional<bool>"_s,
                "readerModeAvailable"_s
            },
            {
                "std::optional<bool>"_s,
                "showingReaderMode"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionTabQueryParameters"_s, {
            {
                "std::optional<Vector<String>>"_s,
                "urlPatterns"_s
            },
            {
                "std::optional<String>"_s,
                "titlePattern"_s
            },
            {
                "std::optional<WebKit::WebExtensionWindowIdentifier>"_s,
                "windowIdentifier"_s
            },
            {
                "std::optional<OptionSet<WebKit::WebExtensionWindowTypeFilter>>"_s,
                "windowType"_s
            },
            {
                "std::optional<bool>"_s,
                "currentWindow"_s
            },
            {
                "std::optional<bool>"_s,
                "frontmostWindow"_s
            },
            {
                "std::optional<uint64_t>"_s,
                "index"_s
            },
            {
                "std::optional<bool>"_s,
                "active"_s
            },
            {
                "std::optional<bool>"_s,
                "audible"_s
            },
            {
                "std::optional<bool>"_s,
                "hidden"_s
            },
            {
                "std::optional<bool>"_s,
                "loading"_s
            },
            {
                "std::optional<bool>"_s,
                "muted"_s
            },
            {
                "std::optional<bool>"_s,
                "pinned"_s
            },
            {
                "std::optional<bool>"_s,
                "selected"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionWindowParameters"_s, {
            {
                "std::optional<WebKit::WebExtensionWindowIdentifier>"_s,
                "identifier"_s
            },
            {
                "std::optional<WebKit::WebExtensionWindow::State>"_s,
                "state"_s
            },
            {
                "std::optional<WebKit::WebExtensionWindow::Type>"_s,
                "type"_s
            },
            {
                "std::optional<Vector<WebKit::WebExtensionTabParameters>>"_s,
                "tabs"_s
            },
#if PLATFORM(COCOA)
            {
                "std::optional<WebKit::DoubleRect>"_s,
                "frame"_s
            },
#endif
            {
                "std::optional<bool>"_s,
                "focused"_s
            },
            {
                "std::optional<bool>"_s,
                "privateBrowsing"_s
            },
        } },
#endif // ENABLE(WK_WEB_EXTENSIONS)
#if ENABLE(GAMEPAD)
        { "WebKit::GamepadData"_s, {
            {
                "unsigned"_s,
                "index()"_s
            },
            {
                "String"_s,
                "id()"_s
            },
            {
                "String"_s,
                "mapping()"_s
            },
            {
                "Vector<double>"_s,
                "axisValues()"_s
            },
            {
                "Vector<double>"_s,
                "buttonValues()"_s
            },
            {
                "MonotonicTime"_s,
                "lastUpdateTime()"_s
            },
            {
                "HashSet<WebCore::GamepadHapticEffectType, IntHash<WebCore::GamepadHapticEffectType>, WTF::StrongEnumHashTraits<WebCore::GamepadHapticEffectType>>"_s,
                "supportedEffectTypes()"_s
            },
        } },
#endif // ENABLE(GAMEPAD)
#if ENABLE(GPU_PROCESS)
        { "WebKit::RemoteImageBufferSetConfiguration"_s, {
            {
                "WebCore::FloatSize"_s,
                "logicalSize"_s
            },
            {
                "float"_s,
                "resolutionScale"_s
            },
            {
                "WebCore::DestinationColorSpace"_s,
                "colorSpace"_s
            },
            {
                "WebCore::ContentsFormat"_s,
                "contentsFormat"_s
            },
            {
                "WebCore::ImageBufferFormat"_s,
                "bufferFormat"_s
            },
            {
                "WebCore::RenderingMode"_s,
                "renderingMode"_s
            },
            {
                "WebCore::RenderingPurpose"_s,
                "renderingPurpose"_s
            },
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
            {
                "WebCore::IncludeDynamicContentScalingDisplayList"_s,
                "includeDisplayList"_s
            },
#endif
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::BindGroupDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "WebKit::WebGPUIdentifier"_s,
                "bindGroupLayout"_s
            },
            {
                "Vector<WebKit::WebGPU::BindGroupEntry>"_s,
                "entries"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::BindGroupEntry"_s, {
            {
                "WebCore::WebGPU::Index32"_s,
                "binding"_s
            },
            {
                "WebKit::WebGPU::BufferBinding"_s,
                "bufferBinding"_s
            },
            {
                "WebKit::WebGPUIdentifier"_s,
                "identifier"_s
            },
            {
                "WebKit::WebGPU::BindingResourceType"_s,
                "type"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::BindGroupLayoutDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "Vector<WebKit::WebGPU::BindGroupLayoutEntry>"_s,
                "entries"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::BindGroupLayoutEntry"_s, {
            {
                "WebCore::WebGPU::Index32"_s,
                "binding"_s
            },
            {
                "WebCore::WebGPU::ShaderStageFlags"_s,
                "visibility"_s
            },
            {
                "std::optional<WebKit::WebGPU::BufferBindingLayout>"_s,
                "buffer"_s
            },
            {
                "std::optional<WebKit::WebGPU::SamplerBindingLayout>"_s,
                "sampler"_s
            },
            {
                "std::optional<WebKit::WebGPU::TextureBindingLayout>"_s,
                "texture"_s
            },
            {
                "std::optional<WebKit::WebGPU::StorageTextureBindingLayout>"_s,
                "storageTexture"_s
            },
            {
                "std::optional<WebKit::WebGPU::ExternalTextureBindingLayout>"_s,
                "externalTexture"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::BlendComponent"_s, {
            {
                "WebCore::WebGPU::BlendOperation"_s,
                "operation"_s
            },
            {
                "WebCore::WebGPU::BlendFactor"_s,
                "srcFactor"_s
            },
            {
                "WebCore::WebGPU::BlendFactor"_s,
                "dstFactor"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::BlendState"_s, {
            {
                "WebKit::WebGPU::BlendComponent"_s,
                "color"_s
            },
            {
                "WebKit::WebGPU::BlendComponent"_s,
                "alpha"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::BufferBinding"_s, {
            {
                "WebKit::WebGPUIdentifier"_s,
                "buffer"_s
            },
            {
                "WebCore::WebGPU::Size64"_s,
                "offset"_s
            },
            {
                "std::optional<WebCore::WebGPU::Size64>"_s,
                "size"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::BufferBindingLayout"_s, {
            {
                "WebCore::WebGPU::BufferBindingType"_s,
                "type"_s
            },
            {
                "bool"_s,
                "hasDynamicOffset"_s
            },
            {
                "WebCore::WebGPU::Size64"_s,
                "minBindingSize"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::BufferDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "WebCore::WebGPU::Size64"_s,
                "size"_s
            },
            {
                "WebCore::WebGPU::BufferUsageFlags"_s,
                "usage"_s
            },
            {
                "bool"_s,
                "mappedAtCreation"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::CanvasConfiguration"_s, {
            {
                "WebKit::WebGPUIdentifier"_s,
                "device"_s
            },
            {
                "WebCore::WebGPU::TextureFormat"_s,
                "format"_s
            },
            {
                "WebCore::WebGPU::TextureUsageFlags"_s,
                "usage"_s
            },
            {
                "Vector<WebCore::WebGPU::TextureFormat>"_s,
                "viewFormats"_s
            },
            {
                "WebCore::WebGPU::PredefinedColorSpace"_s,
                "colorSpace"_s
            },
            {
                "WebCore::WebGPU::CanvasToneMappingMode"_s,
                "toneMappingMode"_s
            },
            {
                "WebCore::WebGPU::CanvasAlphaMode"_s,
                "compositingAlphaMode"_s
            },
            {
                "bool"_s,
                "reportValidationErrors"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ColorDict"_s, {
            {
                "double"_s,
                "r"_s
            },
            {
                "double"_s,
                "g"_s
            },
            {
                "double"_s,
                "b"_s
            },
            {
                "double"_s,
                "a"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ColorTargetState"_s, {
            {
                "WebCore::WebGPU::TextureFormat"_s,
                "format"_s
            },
            {
                "std::optional<WebKit::WebGPU::BlendState>"_s,
                "blend"_s
            },
            {
                "WebCore::WebGPU::ColorWriteFlags"_s,
                "writeMask"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::CommandBufferDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::CommandEncoderDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::CompilationMessage"_s, {
            {
                "String"_s,
                "message"_s
            },
            {
                "WebCore::WebGPU::CompilationMessageType"_s,
                "type"_s
            },
            {
                "uint64_t"_s,
                "lineNum"_s
            },
            {
                "uint64_t"_s,
                "linePos"_s
            },
            {
                "uint64_t"_s,
                "offset"_s
            },
            {
                "uint64_t"_s,
                "length"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ComputePassDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "std::optional<WebKit::WebGPU::ComputePassTimestampWrites>"_s,
                "timestampWrites"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ComputePassTimestampWrites"_s, {
            {
                "WebKit::WebGPUIdentifier"_s,
                "querySet"_s
            },
            {
                "WebCore::WebGPU::Size32"_s,
                "beginningOfPassWriteIndex"_s
            },
            {
                "WebCore::WebGPU::Size32"_s,
                "endOfPassWriteIndex"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ComputePipelineDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "Markable<WebKit::WebGPUIdentifier>"_s,
                "layout"_s
            },
            {
                "WebKit::WebGPU::ProgrammableStage"_s,
                "compute"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::DepthStencilState"_s, {
            {
                "WebCore::WebGPU::TextureFormat"_s,
                "format"_s
            },
            {
                "std::optional<bool>"_s,
                "depthWriteEnabled"_s
            },
            {
                "std::optional<WebCore::WebGPU::CompareFunction>"_s,
                "depthCompare"_s
            },
            {
                "WebKit::WebGPU::StencilFaceState"_s,
                "stencilFront"_s
            },
            {
                "WebKit::WebGPU::StencilFaceState"_s,
                "stencilBack"_s
            },
            {
                "std::optional<WebCore::WebGPU::StencilValue>"_s,
                "stencilReadMask"_s
            },
            {
                "std::optional<WebCore::WebGPU::StencilValue>"_s,
                "stencilWriteMask"_s
            },
            {
                "WebCore::WebGPU::DepthBias"_s,
                "depthBias"_s
            },
            {
                "float"_s,
                "depthBiasSlopeScale"_s
            },
            {
                "float"_s,
                "depthBiasClamp"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::DeviceDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "Vector<WebCore::WebGPU::FeatureName>"_s,
                "requiredFeatures"_s
            },
            {
                "Vector<KeyValuePair<String, uint64_t>>"_s,
                "requiredLimits"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::Extent3DDict"_s, {
            {
                "WebCore::WebGPU::IntegerCoordinate"_s,
                "width"_s
            },
            {
                "WebCore::WebGPU::IntegerCoordinate"_s,
                "height"_s
            },
            {
                "WebCore::WebGPU::IntegerCoordinate"_s,
                "depthOrArrayLayers"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ExternalTextureBindingLayout"_s, {
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ExternalTextureDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "std::optional<WebCore::MediaPlayerIdentifier>"_s,
                "mediaIdentifier"_s
            },
            {
                "WebCore::WebGPU::PredefinedColorSpace"_s,
                "colorSpace"_s
            },
#if PLATFORM(COCOA) && ENABLE(VIDEO)
            {
                "std::optional<WebKit::SharedVideoFrame>"_s,
                "sharedFrame"_s
            },
#endif
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::FragmentState"_s, {
            {
                "WebKit::WebGPUIdentifier"_s,
                "module"_s
            },
            {
                "std::optional<String>"_s,
                "entryPoint"_s
            },
            {
                "Vector<KeyValuePair<String, double>>"_s,
                "constants"_s
            },
            {
                "Vector<std::optional<WebKit::WebGPU::ColorTargetState>>"_s,
                "targets"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ImageCopyBuffer"_s, {
            {
                "WebCore::WebGPU::Size64"_s,
                "offset"_s
            },
            {
                "std::optional<WebCore::WebGPU::Size32>"_s,
                "bytesPerRow"_s
            },
            {
                "std::optional<WebCore::WebGPU::Size32>"_s,
                "rowsPerImage"_s
            },
            {
                "WebKit::WebGPUIdentifier"_s,
                "buffer"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ImageCopyExternalImage"_s, {
            {
                "std::optional<WebKit::WebGPU::Origin2D>"_s,
                "origin"_s
            },
            {
                "bool"_s,
                "flipY"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ImageCopyTexture"_s, {
            {
                "WebKit::WebGPUIdentifier"_s,
                "texture"_s
            },
            {
                "WebCore::WebGPU::IntegerCoordinate"_s,
                "mipLevel"_s
            },
            {
                "std::optional<WebKit::WebGPU::Origin3D>"_s,
                "origin"_s
            },
            {
                "WebCore::WebGPU::TextureAspect"_s,
                "aspect"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ImageCopyTextureTagged"_s, {
            {
                "WebKit::WebGPUIdentifier"_s,
                "texture"_s
            },
            {
                "WebCore::WebGPU::IntegerCoordinate"_s,
                "mipLevel"_s
            },
            {
                "std::optional<WebKit::WebGPU::Origin3D>"_s,
                "origin"_s
            },
            {
                "WebCore::WebGPU::TextureAspect"_s,
                "aspect"_s
            },
            {
                "WebCore::WebGPU::PredefinedColorSpace"_s,
                "colorSpace"_s
            },
            {
                "bool"_s,
                "premultipliedAlpha"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ImageDataLayout"_s, {
            {
                "WebCore::WebGPU::Size64"_s,
                "offset"_s
            },
            {
                "std::optional<WebCore::WebGPU::Size32>"_s,
                "bytesPerRow"_s
            },
            {
                "std::optional<WebCore::WebGPU::Size32>"_s,
                "rowsPerImage"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::InternalError"_s, {
            {
                "String"_s,
                "message"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::MultisampleState"_s, {
            {
                "WebCore::WebGPU::Size32"_s,
                "count"_s
            },
            {
                "WebCore::WebGPU::SampleMask"_s,
                "mask"_s
            },
            {
                "bool"_s,
                "alphaToCoverageEnabled"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ObjectDescriptorBase"_s, {
            {
                "String"_s,
                "label"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::Origin2DDict"_s, {
            {
                "WebCore::WebGPU::IntegerCoordinate"_s,
                "x"_s
            },
            {
                "WebCore::WebGPU::IntegerCoordinate"_s,
                "y"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::Origin3DDict"_s, {
            {
                "WebCore::WebGPU::IntegerCoordinate"_s,
                "x"_s
            },
            {
                "WebCore::WebGPU::IntegerCoordinate"_s,
                "y"_s
            },
            {
                "WebCore::WebGPU::IntegerCoordinate"_s,
                "z"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::OutOfMemoryError"_s, {
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::PipelineDescriptorBase"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "Markable<WebKit::WebGPUIdentifier>"_s,
                "layout"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::PipelineLayoutDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "std::optional<Vector<WebKit::WebGPUIdentifier>>"_s,
                "bindGroupLayouts"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::PresentationContextDescriptor"_s, {
            {
                "WebKit::WebGPUIdentifier"_s,
                "compositorIntegration"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::PrimitiveState"_s, {
            {
                "WebCore::WebGPU::PrimitiveTopology"_s,
                "topology"_s
            },
            {
                "std::optional<WebCore::WebGPU::IndexFormat>"_s,
                "stripIndexFormat"_s
            },
            {
                "WebCore::WebGPU::FrontFace"_s,
                "frontFace"_s
            },
            {
                "WebCore::WebGPU::CullMode"_s,
                "cullMode"_s
            },
            {
                "bool"_s,
                "unclippedDepth"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ProgrammableStage"_s, {
            {
                "WebKit::WebGPUIdentifier"_s,
                "module"_s
            },
            {
                "std::optional<String>"_s,
                "entryPoint"_s
            },
            {
                "Vector<KeyValuePair<String, double>>"_s,
                "constants"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::QuerySetDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "WebCore::WebGPU::QueryType"_s,
                "type"_s
            },
            {
                "WebCore::WebGPU::Size32"_s,
                "count"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::RenderBundleDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::RenderBundleEncoderDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "Vector<std::optional<WebCore::WebGPU::TextureFormat>>"_s,
                "colorFormats"_s
            },
            {
                "std::optional<WebCore::WebGPU::TextureFormat>"_s,
                "depthStencilFormat"_s
            },
            {
                "WebCore::WebGPU::Size32"_s,
                "sampleCount"_s
            },
            {
                "bool"_s,
                "depthReadOnly"_s
            },
            {
                "bool"_s,
                "stencilReadOnly"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::RenderPassColorAttachment"_s, {
            {
                "WebKit::WebGPUIdentifier"_s,
                "view"_s
            },
            {
                "std::optional<WebCore::WebGPU::IntegerCoordinate>"_s,
                "depthSlice"_s
            },
            {
                "std::optional<WebKit::WebGPUIdentifier>"_s,
                "resolveTarget"_s
            },
            {
                "std::optional<WebKit::WebGPU::Color>"_s,
                "clearValue"_s
            },
            {
                "WebCore::WebGPU::LoadOp"_s,
                "loadOp"_s
            },
            {
                "WebCore::WebGPU::StoreOp"_s,
                "storeOp"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::RenderPassDepthStencilAttachment"_s, {
            {
                "WebKit::WebGPUIdentifier"_s,
                "view"_s
            },
            {
                "float"_s,
                "depthClearValue"_s
            },
            {
                "std::optional<WebCore::WebGPU::LoadOp>"_s,
                "depthLoadOp"_s
            },
            {
                "std::optional<WebCore::WebGPU::StoreOp>"_s,
                "depthStoreOp"_s
            },
            {
                "bool"_s,
                "depthReadOnly"_s
            },
            {
                "WebCore::WebGPU::StencilValue"_s,
                "stencilClearValue"_s
            },
            {
                "std::optional<WebCore::WebGPU::LoadOp>"_s,
                "stencilLoadOp"_s
            },
            {
                "std::optional<WebCore::WebGPU::StoreOp>"_s,
                "stencilStoreOp"_s
            },
            {
                "bool"_s,
                "stencilReadOnly"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::RenderPassDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "Vector<std::optional<WebKit::WebGPU::RenderPassColorAttachment>>"_s,
                "colorAttachments"_s
            },
            {
                "std::optional<WebKit::WebGPU::RenderPassDepthStencilAttachment>"_s,
                "depthStencilAttachment"_s
            },
            {
                "std::optional<WebKit::WebGPUIdentifier>"_s,
                "occlusionQuerySet"_s
            },
            {
                "std::optional<WebKit::WebGPU::RenderPassTimestampWrites>"_s,
                "timestampWrites"_s
            },
            {
                "std::optional<uint64_t>"_s,
                "maxDrawCount"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::RenderPassLayout"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "Vector<std::optional<WebCore::WebGPU::TextureFormat>>"_s,
                "colorFormats"_s
            },
            {
                "std::optional<WebCore::WebGPU::TextureFormat>"_s,
                "depthStencilFormat"_s
            },
            {
                "WebCore::WebGPU::Size32"_s,
                "sampleCount"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::RenderPassTimestampWrites"_s, {
            {
                "WebKit::WebGPUIdentifier"_s,
                "querySet"_s
            },
            {
                "WebCore::WebGPU::Size32"_s,
                "beginningOfPassWriteIndex"_s
            },
            {
                "WebCore::WebGPU::Size32"_s,
                "endOfPassWriteIndex"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::RenderPipelineDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "Markable<WebKit::WebGPUIdentifier>"_s,
                "layout"_s
            },
            {
                "WebKit::WebGPU::VertexState"_s,
                "vertex"_s
            },
            {
                "std::optional<WebKit::WebGPU::PrimitiveState>"_s,
                "primitive"_s
            },
            {
                "std::optional<WebKit::WebGPU::DepthStencilState>"_s,
                "depthStencil"_s
            },
            {
                "std::optional<WebKit::WebGPU::MultisampleState>"_s,
                "multisample"_s
            },
            {
                "std::optional<WebKit::WebGPU::FragmentState>"_s,
                "fragment"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::RequestAdapterOptions"_s, {
            {
                "std::optional<WebCore::WebGPU::PowerPreference>"_s,
                "powerPreference"_s
            },
            {
                "bool"_s,
                "forceFallbackAdapter"_s
            },
            {
                "bool"_s,
                "xrCompatible"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::SamplerBindingLayout"_s, {
            {
                "WebCore::WebGPU::SamplerBindingType"_s,
                "type"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::SamplerDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "WebCore::WebGPU::AddressMode"_s,
                "addressModeU"_s
            },
            {
                "WebCore::WebGPU::AddressMode"_s,
                "addressModeV"_s
            },
            {
                "WebCore::WebGPU::AddressMode"_s,
                "addressModeW"_s
            },
            {
                "WebCore::WebGPU::FilterMode"_s,
                "magFilter"_s
            },
            {
                "WebCore::WebGPU::FilterMode"_s,
                "minFilter"_s
            },
            {
                "WebCore::WebGPU::MipmapFilterMode"_s,
                "mipmapFilter"_s
            },
            {
                "float"_s,
                "lodMinClamp"_s
            },
            {
                "float"_s,
                "lodMaxClamp"_s
            },
            {
                "std::optional<WebCore::WebGPU::CompareFunction>"_s,
                "compare"_s
            },
            {
                "uint16_t"_s,
                "maxAnisotropy"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ShaderModuleCompilationHint"_s, {
            {
                "WebKit::WebGPUIdentifier"_s,
                "pipelineLayout"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ShaderModuleDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "String"_s,
                "code"_s
            },
            {
                "Vector<KeyValuePair<String, WebKit::WebGPU::ShaderModuleCompilationHint>>"_s,
                "hints"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::StencilFaceState"_s, {
            {
                "WebCore::WebGPU::CompareFunction"_s,
                "compare"_s
            },
            {
                "WebCore::WebGPU::StencilOperation"_s,
                "failOp"_s
            },
            {
                "WebCore::WebGPU::StencilOperation"_s,
                "depthFailOp"_s
            },
            {
                "WebCore::WebGPU::StencilOperation"_s,
                "passOp"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::StorageTextureBindingLayout"_s, {
            {
                "WebCore::WebGPU::StorageTextureAccess"_s,
                "access"_s
            },
            {
                "WebCore::WebGPU::TextureFormat"_s,
                "format"_s
            },
            {
                "WebCore::WebGPU::TextureViewDimension"_s,
                "viewDimension"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::SupportedFeatures"_s, {
            {
                "Vector<String>"_s,
                "features"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::SupportedLimits"_s, {
            {
                "uint32_t"_s,
                "maxTextureDimension1D"_s
            },
            {
                "uint32_t"_s,
                "maxTextureDimension2D"_s
            },
            {
                "uint32_t"_s,
                "maxTextureDimension3D"_s
            },
            {
                "uint32_t"_s,
                "maxTextureArrayLayers"_s
            },
            {
                "uint32_t"_s,
                "maxBindGroups"_s
            },
            {
                "uint32_t"_s,
                "maxBindGroupsPlusVertexBuffers"_s
            },
            {
                "uint32_t"_s,
                "maxBindingsPerBindGroup"_s
            },
            {
                "uint32_t"_s,
                "maxDynamicUniformBuffersPerPipelineLayout"_s
            },
            {
                "uint32_t"_s,
                "maxDynamicStorageBuffersPerPipelineLayout"_s
            },
            {
                "uint32_t"_s,
                "maxSampledTexturesPerShaderStage"_s
            },
            {
                "uint32_t"_s,
                "maxSamplersPerShaderStage"_s
            },
            {
                "uint32_t"_s,
                "maxStorageBuffersPerShaderStage"_s
            },
            {
                "uint32_t"_s,
                "maxStorageTexturesPerShaderStage"_s
            },
            {
                "uint32_t"_s,
                "maxUniformBuffersPerShaderStage"_s
            },
            {
                "uint64_t"_s,
                "maxUniformBufferBindingSize"_s
            },
            {
                "uint64_t"_s,
                "maxStorageBufferBindingSize"_s
            },
            {
                "uint32_t"_s,
                "minUniformBufferOffsetAlignment"_s
            },
            {
                "uint32_t"_s,
                "minStorageBufferOffsetAlignment"_s
            },
            {
                "uint32_t"_s,
                "maxVertexBuffers"_s
            },
            {
                "uint64_t"_s,
                "maxBufferSize"_s
            },
            {
                "uint32_t"_s,
                "maxVertexAttributes"_s
            },
            {
                "uint32_t"_s,
                "maxVertexBufferArrayStride"_s
            },
            {
                "uint32_t"_s,
                "maxInterStageShaderComponents"_s
            },
            {
                "uint32_t"_s,
                "maxInterStageShaderVariables"_s
            },
            {
                "uint32_t"_s,
                "maxColorAttachments"_s
            },
            {
                "uint32_t"_s,
                "maxColorAttachmentBytesPerSample"_s
            },
            {
                "uint32_t"_s,
                "maxComputeWorkgroupStorageSize"_s
            },
            {
                "uint32_t"_s,
                "maxComputeInvocationsPerWorkgroup"_s
            },
            {
                "uint32_t"_s,
                "maxComputeWorkgroupSizeX"_s
            },
            {
                "uint32_t"_s,
                "maxComputeWorkgroupSizeY"_s
            },
            {
                "uint32_t"_s,
                "maxComputeWorkgroupSizeZ"_s
            },
            {
                "uint32_t"_s,
                "maxComputeWorkgroupsPerDimension"_s
            },
            {
                "uint32_t"_s,
                "maxStorageBuffersInFragmentStage"_s
            },
            {
                "uint32_t"_s,
                "maxStorageTexturesInFragmentStage"_s
            },
            {
                "uint32_t"_s,
                "maxStorageBuffersInVertexStage"_s
            },
            {
                "uint32_t"_s,
                "maxStorageTexturesInVertexStage"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::TextureBindingLayout"_s, {
            {
                "WebCore::WebGPU::TextureSampleType"_s,
                "sampleType"_s
            },
            {
                "WebCore::WebGPU::TextureViewDimension"_s,
                "viewDimension"_s
            },
            {
                "bool"_s,
                "multisampled"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::TextureDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "WebKit::WebGPU::Extent3D"_s,
                "size"_s
            },
            {
                "WebCore::WebGPU::IntegerCoordinate"_s,
                "mipLevelCount"_s
            },
            {
                "WebCore::WebGPU::Size32"_s,
                "sampleCount"_s
            },
            {
                "WebCore::WebGPU::TextureDimension"_s,
                "dimension"_s
            },
            {
                "WebCore::WebGPU::TextureFormat"_s,
                "format"_s
            },
            {
                "WebCore::WebGPU::TextureUsageFlags"_s,
                "usage"_s
            },
            {
                "Vector<WebCore::WebGPU::TextureFormat>"_s,
                "viewFormats"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::TextureViewDescriptor"_s, {
            {
                "String"_s,
                "label"_s
            },
            {
                "std::optional<WebCore::WebGPU::TextureFormat>"_s,
                "format"_s
            },
            {
                "std::optional<WebCore::WebGPU::TextureViewDimension>"_s,
                "dimension"_s
            },
            {
                "WebCore::WebGPU::TextureAspect"_s,
                "aspect"_s
            },
            {
                "WebCore::WebGPU::IntegerCoordinate"_s,
                "baseMipLevel"_s
            },
            {
                "std::optional<WebCore::WebGPU::IntegerCoordinate>"_s,
                "mipLevelCount"_s
            },
            {
                "WebCore::WebGPU::IntegerCoordinate"_s,
                "baseArrayLayer"_s
            },
            {
                "std::optional<WebCore::WebGPU::IntegerCoordinate>"_s,
                "arrayLayerCount"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::ValidationError"_s, {
            {
                "String"_s,
                "message"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::VertexAttribute"_s, {
            {
                "WebCore::WebGPU::VertexFormat"_s,
                "format"_s
            },
            {
                "WebCore::WebGPU::Size64"_s,
                "offset"_s
            },
            {
                "WebCore::WebGPU::Index32"_s,
                "shaderLocation"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::VertexBufferLayout"_s, {
            {
                "WebCore::WebGPU::Size64"_s,
                "arrayStride"_s
            },
            {
                "WebCore::WebGPU::VertexStepMode"_s,
                "stepMode"_s
            },
            {
                "Vector<WebKit::WebGPU::VertexAttribute>"_s,
                "attributes"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::VertexState"_s, {
            {
                "WebKit::WebGPUIdentifier"_s,
                "module"_s
            },
            {
                "std::optional<String>"_s,
                "entryPoint"_s
            },
            {
                "Vector<KeyValuePair<String, double>>"_s,
                "constants"_s
            },
            {
                "Vector<std::optional<WebKit::WebGPU::VertexBufferLayout>>"_s,
                "buffers"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
        { "WebKit::WebsiteData::Entry"_s, {
            {
                "WebCore::SecurityOriginData"_s,
                "origin"_s
            },
            {
                "OptionSet<WebKit::WebsiteDataType>"_s,
                "typeAsOptionSet()"_s
            },
            {
                "uint64_t"_s,
                "size"_s
            },
        } },
        { "WebKit::WebsiteData"_s, {
            {
                "Vector<WebKit::WebsiteData::Entry>"_s,
                "entries"_s
            },
            {
                "HashSet<String>"_s,
                "hostNamesWithCookies"_s
            },
            {
                "HashSet<String>"_s,
                "hostNamesWithHSTSCache"_s
            },
            {
                "HashSet<WebCore::RegistrableDomain>"_s,
                "registrableDomainsWithResourceLoadStatistics"_s
            },
        } },
#if ENABLE(WEBXR)
        { "PlatformXR::DepthRange"_s, {
            {
                "float"_s,
                "near"_s
            },
            {
                "float"_s,
                "far"_s
            },
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR)
        { "PlatformXR::RequestData"_s, {
            {
                "PlatformXR::DepthRange"_s,
                "depthRange"_s
            },
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR)
        { "PlatformXR::FrameData::FloatQuaternion"_s, {
            {
                "float"_s,
                "x"_s
            },
            {
                "float"_s,
                "y"_s
            },
            {
                "float"_s,
                "z"_s
            },
            {
                "float"_s,
                "w"_s
            },
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR)
        { "PlatformXR::FrameData::Pose"_s, {
            {
                "WebCore::FloatPoint3D"_s,
                "position"_s
            },
            {
                "PlatformXR::FrameData::FloatQuaternion"_s,
                "orientation"_s
            },
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR)
        { "PlatformXR::FrameData::Fov"_s, {
            {
                "float"_s,
                "up"_s
            },
            {
                "float"_s,
                "down"_s
            },
            {
                "float"_s,
                "left"_s
            },
            {
                "float"_s,
                "right"_s
            },
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR)
        { "PlatformXR::FrameData::View"_s, {
            {
                "PlatformXR::FrameData::Pose"_s,
                "offset"_s
            },
            {
                "PlatformXR::FrameData::Projection"_s,
                "projection"_s
            },
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR)
        { "PlatformXR::FrameData::StageParameters"_s, {
            {
                "int"_s,
                "id"_s
            },
            {
                "Vector<WebCore::FloatPoint>"_s,
                "bounds"_s
            },
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR)
        { "PlatformXR::FrameData::RateMapDescription"_s, {
            {
                "WebCore::IntSize"_s,
                "screenSize"_s
            },
            {
                "Vector<float>"_s,
                "horizontalSamplesLeft"_s
            },
            {
                "Vector<float>"_s,
                "horizontalSamplesRight"_s
            },
            {
                "Vector<float>"_s,
                "verticalSamples"_s
            },
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR)
        { "PlatformXR::FrameData::LayerSetupData"_s, {
            {
                "std::array<std::array<uint16_t, 2>, 2>"_s,
                "physicalSize"_s
            },
            {
                "std::array<WebCore::IntRect, 2>"_s,
                "viewports"_s
            },
            {
                "PlatformXR::FrameData::RateMapDescription"_s,
                "foveationRateMapDesc"_s
            },
#if PLATFORM(COCOA)
            {
                "MachSendRight"_s,
                "completionSyncEvent"_s
            },
#endif
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR)
        { "PlatformXR::FrameData::ExternalTexture"_s, {
#if PLATFORM(COCOA)
            {
                "MachSendRight"_s,
                "handle"_s
            },
#endif
#if PLATFORM(COCOA)
            {
                "bool"_s,
                "isSharedTexture"_s
            },
#endif
#if !PLATFORM(COCOA)
            {
                "Vector<WTF::UnixFileDescriptor>"_s,
                "fds"_s
            },
#endif
#if !PLATFORM(COCOA)
            {
                "Vector<uint32_t>"_s,
                "strides"_s
            },
#endif
#if !PLATFORM(COCOA)
            {
                "Vector<uint32_t>"_s,
                "offsets"_s
            },
#endif
#if !PLATFORM(COCOA)
            {
                "uint32_t"_s,
                "fourcc"_s
            },
#endif
#if !PLATFORM(COCOA)
            {
                "uint64_t"_s,
                "modifier"_s
            },
#endif
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR)
        { "PlatformXR::FrameData::ExternalTextureData"_s, {
            {
                "uint64_t"_s,
                "reusableTextureIndex"_s
            },
            {
                "PlatformXR::FrameData::ExternalTexture"_s,
                "colorTexture"_s
            },
            {
                "PlatformXR::FrameData::ExternalTexture"_s,
                "depthStencilBuffer"_s
            },
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR)
        { "PlatformXR::FrameData::LayerData"_s, {
            {
                "std::optional<PlatformXR::FrameData::LayerSetupData>"_s,
                "layerSetup"_s
            },
            {
                "uint64_t"_s,
                "renderingFrameIndex"_s
            },
            {
                "std::optional<PlatformXR::FrameData::ExternalTextureData>"_s,
                "textureData"_s
            },
            {
                "bool"_s,
                "requestDepth"_s
            },
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR)
        { "PlatformXR::FrameData::InputSourceButton"_s, {
            {
                "bool"_s,
                "touched"_s
            },
            {
                "bool"_s,
                "pressed"_s
            },
            {
                "float"_s,
                "pressedValue"_s
            },
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR)
        { "PlatformXR::FrameData::InputSourcePose"_s, {
            {
                "PlatformXR::FrameData::Pose"_s,
                "pose"_s
            },
            {
                "bool"_s,
                "isPositionEmulated"_s
            },
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR_HANDS)
        { "PlatformXR::FrameData::InputSourceHandJoint"_s, {
            {
                "PlatformXR::FrameData::InputSourcePose"_s,
                "pose"_s
            },
            {
                "float"_s,
                "radius"_s
            },
        } },
#endif // ENABLE(WEBXR_HANDS)
#if ENABLE(WEBXR)
        { "PlatformXR::FrameData::InputSource"_s, {
            {
                "int"_s,
                "handle"_s
            },
            {
                "PlatformXR::XRHandedness"_s,
                "handedness"_s
            },
            {
                "PlatformXR::XRTargetRayMode"_s,
                "targetRayMode"_s
            },
            {
                "Vector<String>"_s,
                "profiles"_s
            },
            {
                "PlatformXR::FrameData::InputSourcePose"_s,
                "pointerOrigin"_s
            },
            {
                "std::optional<PlatformXR::FrameData::InputSourcePose>"_s,
                "gripOrigin"_s
            },
            {
                "Vector<PlatformXR::FrameData::InputSourceButton>"_s,
                "buttons"_s
            },
            {
                "Vector<float>"_s,
                "axes"_s
            },
#if ENABLE(WEBXR_HANDS)
            {
                "std::optional<PlatformXR::FrameData::HandJointsVector>"_s,
                "handJoints"_s
            },
#endif
        } },
#endif // ENABLE(WEBXR)
#if ENABLE(WEBXR)
        { "PlatformXR::FrameData"_s, {
            {
                "bool"_s,
                "isTrackingValid"_s
            },
            {
                "bool"_s,
                "isPositionValid"_s
            },
            {
                "bool"_s,
                "isPositionEmulated"_s
            },
            {
                "bool"_s,
                "shouldRender"_s
            },
            {
                "long"_s,
                "predictedDisplayTime"_s
            },
            {
                "PlatformXR::FrameData::Pose"_s,
                "origin"_s
            },
            {
                "std::optional<PlatformXR::FrameData::Pose>"_s,
                "floorTransform"_s
            },
            {
                "PlatformXR::FrameData::StageParameters"_s,
                "stageParameters"_s
            },
            {
                "Vector<PlatformXR::FrameData::View>"_s,
                "views"_s
            },
            {
                "HashMap<PlatformXR::LayerHandle, UniqueRef<PlatformXR::FrameData::LayerData>>"_s,
                "layers"_s
            },
            {
                "Vector<PlatformXR::FrameData::InputSource>"_s,
                "inputSources"_s
            },
        } },
#endif // ENABLE(WEBXR)
#if (ENABLE(WEBXR)) && (USE(OPENXR))
        { "PlatformXR::Device::LayerView"_s, {
            {
                "PlatformXR::Eye"_s,
                "eye"_s
            },
            {
                "WebCore::IntRect"_s,
                "viewport"_s
            },
        } },
#endif // (ENABLE(WEBXR)) && (USE(OPENXR))
#if ENABLE(WEBXR)
        { "WebKit::XRDeviceInfo"_s, {
            {
                "WebKit::XRDeviceIdentifier"_s,
                "identifier"_s
            },
            {
                "bool"_s,
                "supportsOrientationTracking"_s
            },
            {
                "bool"_s,
                "supportsStereoRendering"_s
            },
            {
                "PlatformXR::Device::FeatureList"_s,
                "vrFeatures"_s
            },
            {
                "PlatformXR::Device::FeatureList"_s,
                "arFeatures"_s
            },
            {
                "WebCore::IntSize"_s,
                "recommendedResolution"_s
            },
            {
                "double"_s,
                "minimumNearClipPlane"_s
            },
        } },
#endif // ENABLE(WEBXR)
#if (ENABLE(WEBXR)) && (USE(OPENXR))
        { "WebKit::XRDeviceLayer"_s, {
            {
                "PlatformXR::LayerHandle"_s,
                "handle"_s
            },
            {
                "bool"_s,
                "visible"_s
            },
            {
                "Vector<PlatformXR::Device::LayerView>"_s,
                "views"_s
            },
            {
                "WTF::UnixFileDescriptor"_s,
                "fenceFD"_s
            },
        } },
#endif // (ENABLE(WEBXR)) && (USE(OPENXR))
#if ENABLE(GPU_PROCESS)
        { "WebKit::GPUProcessConnectionInfo"_s, {
#if HAVE(AUDIT_TOKEN)
            {
                "std::optional<WebKit::CoreIPCAuditToken>"_s,
                "auditToken"_s
            },
#endif
#if ENABLE(VP9)
            {
                "bool"_s,
                "hasVP9HardwareDecoder"_s
            },
#endif
#if ENABLE(AV1)
            {
                "bool"_s,
                "hasAV1HardwareDecoder"_s
            },
#endif
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS)
        { "WebKit::BufferIdentifierSet"_s, {
            {
                "std::optional<WebCore::RenderingResourceIdentifier>"_s,
                "front"_s
            },
            {
                "std::optional<WebCore::RenderingResourceIdentifier>"_s,
                "back"_s
            },
            {
                "std::optional<WebCore::RenderingResourceIdentifier>"_s,
                "secondaryBack"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS) && PLATFORM(COCOA)
        { "WebKit::ImageBufferSetPrepareBufferForDisplayInputData"_s, {
            {
                "WebKit::RemoteImageBufferSetIdentifier"_s,
                "remoteBufferSet"_s
            },
            {
                "WebCore::Region"_s,
                "dirtyRegion"_s
            },
            {
                "bool"_s,
                "supportsPartialRepaint"_s
            },
            {
                "bool"_s,
                "hasEmptyDirtyRegion"_s
            },
            {
                "bool"_s,
                "requiresClearedPixels"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && PLATFORM(COCOA)
#if ENABLE(GPU_PROCESS) && PLATFORM(COCOA)
        { "WebKit::ImageBufferSetPrepareBufferForDisplayOutputData"_s, {
            {
                "std::optional<WebKit::ImageBufferBackendHandle>"_s,
                "backendHandle"_s
            },
            {
                "WebKit::SwapBuffersDisplayRequirement"_s,
                "displayRequirement"_s
            },
            {
                "WebKit::BufferIdentifierSet"_s,
                "bufferCacheIdentifiers"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && PLATFORM(COCOA)
#if ENABLE(GPU_PROCESS)
        { "WebKit::MediaOverridesForTesting"_s, {
            {
                "std::optional<bool>"_s,
                "systemHasAC"_s
            },
            {
                "std::optional<bool>"_s,
                "systemHasBattery"_s
            },
            {
                "std::optional<bool>"_s,
                "vp9HardwareDecoderDisabled"_s
            },
            {
                "std::optional<bool>"_s,
                "vp9DecoderDisabled"_s
            },
            {
                "std::optional<WebCore::ScreenDataOverrides>"_s,
                "vp9ScreenSizeAndScale"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
        { "WebKit::MediaTimeUpdateData"_s, {
            {
                "MediaTime"_s,
                "currentTime"_s
            },
            {
                "bool"_s,
                "timeIsProgressing"_s
            },
            {
                "MonotonicTime"_s,
                "wallTime"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#if ENABLE(GPU_PROCESS) && USE(AUDIO_SESSION)
        { "WebKit::RemoteAudioSessionConfiguration"_s, {
            {
                "String"_s,
                "routingContextUID"_s
            },
            {
                "float"_s,
                "sampleRate"_s
            },
            {
                "uint64_t"_s,
                "bufferSize"_s
            },
            {
                "uint64_t"_s,
                "numberOfOutputChannels"_s
            },
            {
                "uint64_t"_s,
                "maximumNumberOfOutputChannels"_s
            },
            {
                "uint64_t"_s,
                "preferredBufferSize"_s
            },
            {
                "uint64_t"_s,
                "outputLatency"_s
            },
            {
                "bool"_s,
                "isMuted"_s
            },
            {
                "bool"_s,
                "isActive"_s
            },
            {
                "String"_s,
                "sceneIdentifier"_s
            },
            {
                "WebCore::AudioSessionSoundStageSize"_s,
                "soundStageSize"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && USE(AUDIO_SESSION)
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
        { "WebKit::RemoteCDMConfiguration"_s, {
            {
                "Vector<AtomString>"_s,
                "supportedInitDataTypes"_s
            },
            {
                "Vector<AtomString>"_s,
                "supportedRobustnesses"_s
            },
            {
                "bool"_s,
                "supportsServerCertificates"_s
            },
            {
                "bool"_s,
                "supportsSessions"_s
            },
            {
                "uint64_t"_s,
                "logIdentifier"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
        { "WebKit::RemoteCDMInstanceConfiguration"_s, {
            {
                "String"_s,
                "keySystem"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
#if ENABLE(GPU_PROCESS)
        { "WebKit::RemoteMediaPlayerConfiguration"_s, {
            {
                "String"_s,
                "engineDescription"_s
            },
            {
                "bool"_s,
                "supportsScanning"_s
            },
            {
                "bool"_s,
                "supportsFullscreen"_s
            },
            {
                "bool"_s,
                "supportsPictureInPicture"_s
            },
            {
                "bool"_s,
                "supportsAcceleratedRendering"_s
            },
            {
                "bool"_s,
                "supportsPlayAtHostTime"_s
            },
            {
                "bool"_s,
                "supportsPauseAtHostTime"_s
            },
            {
                "bool"_s,
                "canPlayToWirelessPlaybackTarget"_s
            },
            {
                "bool"_s,
                "shouldIgnoreIntrinsicSize"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS)
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
        { "WebKit::RemoteMediaPlayerState"_s, {
            {
                "MediaTime"_s,
                "duration"_s
            },
            {
                "MediaTime"_s,
                "minTimeSeekable"_s
            },
            {
                "MediaTime"_s,
                "maxTimeSeekable"_s
            },
            {
                "MediaTime"_s,
                "startDate"_s
            },
            {
                "MediaTime"_s,
                "startTime"_s
            },
            {
                "String"_s,
                "languageOfPrimaryAudioTrack"_s
            },
            {
                "String"_s,
                "wirelessPlaybackTargetName"_s
            },
            {
                "std::optional<WebCore::PlatformTimeRanges>"_s,
                "bufferedRanges"_s
            },
            {
                "WebCore::MediaPlayerNetworkState"_s,
                "networkState"_s
            },
            {
                "WebCore::MediaPlayerMovieLoadType"_s,
                "movieLoadType"_s
            },
            {
                "WebCore::MediaPlayerWirelessPlaybackTargetType"_s,
                "wirelessPlaybackTargetType"_s
            },
            {
                "WebCore::FloatSize"_s,
                "naturalSize"_s
            },
            {
                "double"_s,
                "maxFastForwardRate"_s
            },
            {
                "double"_s,
                "minFastReverseRate"_s
            },
            {
                "double"_s,
                "seekableTimeRangesLastModifiedTime"_s
            },
            {
                "double"_s,
                "liveUpdateInterval"_s
            },
            {
                "uint64_t"_s,
                "totalBytes"_s
            },
            {
                "std::optional<WebCore::VideoPlaybackQualityMetrics>"_s,
                "videoMetrics"_s
            },
            {
                "std::optional<bool>"_s,
                "documentIsCrossOrigin"_s
            },
            {
                "bool"_s,
                "paused"_s
            },
            {
                "bool"_s,
                "canSaveMediaData"_s
            },
            {
                "bool"_s,
                "hasAudio"_s
            },
            {
                "bool"_s,
                "hasVideo"_s
            },
            {
                "bool"_s,
                "hasClosedCaptions"_s
            },
            {
                "bool"_s,
                "hasAvailableVideoFrame"_s
            },
            {
                "bool"_s,
                "wirelessVideoPlaybackDisabled"_s
            },
            {
                "bool"_s,
                "didPassCORSAccessCheck"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
        { "WebKit::RemoteVideoFrameProxyProperties"_s, {
            {
                "WebKit::RemoteVideoFrameReference"_s,
                "reference"_s
            },
            {
                "MediaTime"_s,
                "presentationTime"_s
            },
            {
                "bool"_s,
                "isMirrored"_s
            },
            {
                "WebCore::VideoFrameRotation"_s,
                "rotation"_s
            },
            {
                "WebCore::IntSize"_s,
                "size"_s
            },
            {
                "uint32_t"_s,
                "pixelFormat"_s
            },
            {
                "WebCore::PlatformVideoColorSpace"_s,
                "colorSpace"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#if ENABLE(GPU_PROCESS) && PLATFORM(COCOA) && ENABLE(VIDEO)
        { "WebKit::SharedVideoFrame"_s, {
            {
                "MediaTime"_s,
                "time"_s
            },
            {
                "bool"_s,
                "mirrored"_s
            },
            {
                "WebCore::VideoFrameRotation"_s,
                "rotation"_s
            },
            {
                "WebKit::SharedVideoFrame::Buffer"_s,
                "buffer"_s
            },
        } },
#endif // ENABLE(GPU_PROCESS) && PLATFORM(COCOA) && ENABLE(VIDEO)
#if ENABLE(MEDIA_STREAM)
        { "WebKit::MediaDeviceSandboxExtensions"_s, {
            {
                "Vector<String>"_s,
                "takeIDs()"_s
            },
            {
                "Vector<WebKit::SandboxExtensionHandle>"_s,
                "takeHandles()"_s
            },
            {
                "WebKit::SandboxExtensionHandle"_s,
                "takeMachBootstrapHandle()"_s
            },
        } },
#endif // ENABLE(MEDIA_STREAM)
#if ENABLE(MODEL_PROCESS)
        { "WebKit::ModelProcessConnectionInfo"_s, {
#if HAVE(AUDIT_TOKEN)
            {
                "std::optional<WebKit::CoreIPCAuditToken>"_s,
                "auditToken"_s
            },
#endif
        } },
#endif // ENABLE(MODEL_PROCESS)
        { "WebKit::NetworkProcessConnectionInfo"_s, {
            {
                "IPC::ConnectionHandle"_s,
                "connection"_s
            },
            {
                "WebCore::HTTPCookieAcceptPolicy"_s,
                "cookieAcceptPolicy"_s
            },
#if HAVE(AUDIT_TOKEN)
            {
                "std::optional<WebKit::CoreIPCAuditToken>"_s,
                "auditToken"_s
            },
#endif
        } },
#if ENABLE(SPEECH_SYNTHESIS)
        { "WebKit::WebSpeechSynthesisVoice"_s, {
            {
                "String"_s,
                "voiceURI"_s
            },
            {
                "String"_s,
                "name"_s
            },
            {
                "String"_s,
                "lang"_s
            },
            {
                "bool"_s,
                "localService"_s
            },
            {
                "bool"_s,
                "defaultLang"_s
            },
        } },
#endif // ENABLE(SPEECH_SYNTHESIS)
#if USE(SKIA)
        { "hb_feature_t"_s, {
            {
                "hb_tag_t"_s,
                "tag"_s
            },
            {
                "uint32_t"_s,
                "value"_s
            },
            {
                "unsigned"_s,
                "start"_s
            },
            {
                "unsigned"_s,
                "end"_s
            },
        } },
#endif // USE(SKIA)
#if USE(SKIA)
        { "sk_sp<SkColorSpace>"_s, {
            {
                "std::span<const uint8_t>"_s,
                "dataReference()"_s
            },
        } },
#endif // USE(SKIA)
#if USE(SKIA)
        { "sk_sp<SkData>"_s, {
            {
                "std::span<const uint8_t>"_s,
                "dataReference()"_s
            },
        } },
#endif // USE(SKIA)
#if USE(SKIA)
        { "SkFontStyle::Slant"_s, {
            {
                "uint8_t"_s,
                "data()"_s
            },
        } },
#endif // USE(SKIA)
#if USE(SKIA)
        { "SkString"_s, {
            {
                "std::span<const char>"_s,
                "data()"_s
            },
        } },
#endif // USE(SKIA)
        { "SkFontStyle"_s, {
            {
                "int"_s,
                "weight()"_s
            },
            {
                "int"_s,
                "width()"_s
            },
            {
                "SkFontStyle::Slant"_s,
                "slant()"_s
            },
        } },
#if USE(SKIA)
        { "WebCore::FontPlatformSerializedCreationData"_s, {
            {
                "Vector<uint8_t>"_s,
                "fontFaceData"_s
            },
            {
                "String"_s,
                "itemInCollection"_s
            },
        } },
#endif // USE(SKIA)
#if USE(SKIA)
        { "WebCore::FontPlatformSerializedData"_s, {
            {
                "sk_sp<SkData>"_s,
                "typefaceData"_s
            },
        } },
#endif // USE(SKIA)
        { "WebKit::RendererBufferFormat"_s, {
            {
                "WebKit::RendererBufferFormat::Usage"_s,
                "usage"_s
            },
#if USE(GBM)
            {
                "WebCore::DRMDevice"_s,
                "drmDevice"_s
            },
#endif
            {
                "Vector<WebKit::RendererBufferFormat::Format>"_s,
                "formats"_s
            },
        } },
        { "WebKit::RendererBufferFormat::Format"_s, {
            {
                "uint32_t"_s,
                "fourcc"_s
            },
            {
                "Vector<uint64_t, 1>"_s,
                "modifiers"_s
            },
        } },
#if USE(GBM)
        { "WebCore::DMABufBufferAttributes"_s, {
            {
                "WebCore::IntSize"_s,
                "size"_s
            },
            {
                "uint32_t"_s,
                "fourcc"_s
            },
            {
                "Vector<WTF::UnixFileDescriptor>"_s,
                "fds"_s
            },
            {
                "Vector<uint32_t>"_s,
                "offsets"_s
            },
            {
                "Vector<uint32_t>"_s,
                "strides"_s
            },
            {
                "uint64_t"_s,
                "modifier"_s
            },
        } },
#endif // USE(GBM)
#if USE(GBM)
        { "WebCore::DRMDevice"_s, {
            {
                "CString"_s,
                "primaryNode"_s
            },
            {
                "CString"_s,
                "renderNode"_s
            },
        } },
#endif // USE(GBM)
        { "WebKit::InputMethodState"_s, {
            {
                "WebKit::InputMethodState::Purpose"_s,
                "purpose"_s
            },
            {
                "OptionSet<WebKit::InputMethodState::Hint>"_s,
                "hints"_s
            },
        } },
        { "WebCore::SelectionData"_s, {
            {
                "String"_s,
                "text()"_s
            },
            {
                "String"_s,
                "markup()"_s
            },
            {
                "URL"_s,
                "url()"_s
            },
            {
                "String"_s,
                "uriList()"_s
            },
            {
                "RefPtr<WebCore::Image>"_s,
                "image()"_s
            },
            {
                "RefPtr<WebCore::SharedBuffer>"_s,
                "customData()"_s
            },
            {
                "bool"_s,
                "canSmartReplace()"_s
            },
        } },
        { "WebCore::SystemSettingsState"_s, {
            {
                "std::optional<String>"_s,
                "themeName"_s
            },
            {
                "std::optional<bool>"_s,
                "darkMode"_s
            },
            {
                "std::optional<String>"_s,
                "fontName"_s
            },
            {
                "std::optional<int>"_s,
                "xftAntialias"_s
            },
            {
                "std::optional<int>"_s,
                "xftHinting"_s
            },
            {
                "std::optional<String>"_s,
                "xftHintStyle"_s
            },
            {
                "std::optional<String>"_s,
                "xftRGBA"_s
            },
            {
                "std::optional<int>"_s,
                "xftDPI"_s
            },
            {
                "std::optional<bool>"_s,
                "followFontSystemSettings"_s
            },
            {
                "std::optional<bool>"_s,
                "cursorBlink"_s
            },
            {
                "std::optional<int>"_s,
                "cursorBlinkTime"_s
            },
            {
                "std::optional<bool>"_s,
                "primaryButtonWarpsSlider"_s
            },
            {
                "std::optional<bool>"_s,
                "overlayScrolling"_s
            },
            {
                "std::optional<bool>"_s,
                "enableAnimations"_s
            },
        } },
        { "WebKit::UserMessage"_s, {
            {
                "Variant<WebKit::UserMessage::NullMessage, WebKit::UserMessage::ErrorMessage, WebKit::UserMessage::DataMessage>"_s,
                "toIPCData()"_s
            },
        } },
        { "WebKit::UserMessage::NullMessage"_s, {
        } },
        { "WebKit::UserMessage::ErrorMessage"_s, {
            {
                "CString"_s,
                "name"_s
            },
            {
                "uint32_t"_s,
                "errorCode"_s
            },
        } },
        { "WebKit::UserMessage::DataMessage"_s, {
            {
                "CString"_s,
                "name"_s
            },
            {
                "GRefPtr<GVariant>"_s,
                "parameters"_s
            },
            {
                "GRefPtr<GUnixFDList>"_s,
                "fileDescriptors"_s
            },
        } },
        { "WebCore::SoupNetworkProxySettings"_s, {
            {
                "WebCore::SoupNetworkProxySettingsMode"_s,
                "mode"_s
            },
            {
                "CString"_s,
                "defaultProxyURL"_s
            },
            {
                "GUniquePtr<char*>"_s,
                "ignoreHosts"_s
            },
            {
                "HashMap<CString, CString>"_s,
                "proxyMap"_s
            },
        } },
        { "WebCore::DocumentSyncData"_s, {
            {
                "bool"_s,
                "isAutofocusProcessed"_s
            },
            {
                "bool"_s,
                "userDidInteractWithPage"_s
            },
            {
                "bool"_s,
                "isClosing"_s
            },
            {
                "URL"_s,
                "documentURL"_s
            },
            {
                "RefPtr<WebCore::SecurityOrigin>"_s,
                "documentSecurityOrigin"_s
            },
            {
                "OptionSet<WebCore::DocumentClass>"_s,
                "documentClasses"_s
            },
#if ENABLE(DOM_AUDIO_SESSION)
            {
                "WebCore::DOMAudioSessionType"_s,
                "audioSessionType"_s
            },
#endif
            {
                "bool"_s,
                "hasInjectedUserScript"_s
            },
        } },
        { "WebCore::FrameTreeSyncData"_s, {
            {
                "bool"_s,
                "frameCanCreatePaymentSession"_s
            },
            {
                "RefPtr<WebCore::SecurityOrigin>"_s,
                "frameDocumentSecurityOrigin"_s
            },
        } },
        { "WebCore::ProcessSyncData"_s, {
            {
                "WebCore::ProcessSyncDataType"_s,
                "type"_s
            },
            {
                "WebCore::ProcessSyncDataVariant"_s,
                "value"_s
            },
        } },
        { "WebKit::SharedPreferencesForWebProcess"_s, {
            {
                "uint64_t"_s,
                "version"_s
            },
            {
                "bool"_s,
                "allowTestOnlyIPC"_s
            },
#if ENABLE(APPLE_PAY)
            {
                "bool"_s,
                "applePayEnabled"_s
            },
#endif
#if ENABLE(DEVICE_ORIENTATION)
            {
                "bool"_s,
                "deviceOrientationEventEnabled"_s
            },
#endif
#if ENABLE(DEVICE_ORIENTATION)
            {
                "bool"_s,
                "deviceOrientationPermissionAPIEnabled"_s
            },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
            {
                "bool"_s,
                "encryptedMediaAPIEnabled"_s
            },
#endif
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS)
            {
                "bool"_s,
                "mediaControlsContextMenusEnabled"_s
            },
#endif
#if USE(SYSTEM_PREVIEW)
            {
                "bool"_s,
                "systemPreviewEnabled"_s
            },
#endif
            {
                "bool"_s,
                "usesSingleWebProcess"_s
            },
#if ENABLE(FULLSCREEN_API)
            {
                "bool"_s,
                "videoFullscreenRequiresElementFullscreen"_s
            },
#endif
            {
                "bool"_s,
                "videoPresentationManagerEnabled"_s
            },
            {
                "bool"_s,
                "videoPresentationModeAPIEnabled"_s
            },
#if ENABLE(WEB_AUDIO)
            {
                "bool"_s,
                "webAudioEnabled"_s
            },
#endif
            {
                "bool"_s,
                "webSocketEnabled"_s
            },
            {
                "bool"_s,
                "allowPrivacySensitiveOperationsInNonPersistentDataStores"_s
            },
            {
                "bool"_s,
                "appBadgeEnabled"_s
            },
#if ENABLE(ATTACHMENT_ELEMENT)
            {
                "bool"_s,
                "attachmentElementEnabled"_s
            },
#endif
            {
                "bool"_s,
                "broadcastChannelEnabled"_s
            },
#if ENABLE(WEB_PUSH_NOTIFICATIONS)
            {
                "bool"_s,
                "builtInNotificationsEnabled"_s
            },
#endif
            {
                "bool"_s,
                "canvasPixelFormatEnabled"_s
            },
            {
                "bool"_s,
                "inputTypeColorEnabled"_s
            },
            {
                "bool"_s,
                "contactPickerAPIEnabled"_s
            },
            {
                "bool"_s,
                "cookieConsentAPIEnabled"_s
            },
            {
                "bool"_s,
                "cookieStoreManagerEnabled"_s
            },
#if PLATFORM(MAC)
            {
                "bool"_s,
                "inputMethodUsesCorrectKeyEventOrder"_s
            },
#endif
            {
                "bool"_s,
                "dataListElementEnabled"_s
            },
            {
                "bool"_s,
                "inputTypeDateEnabled"_s
            },
#if ENABLE(WEB_AUTHN)
            {
                "bool"_s,
                "digitalCredentialsEnabled"_s
            },
#endif
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
            {
                "bool"_s,
                "useCGDisplayListsForDOMRendering"_s
            },
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
            {
                "bool"_s,
                "legacyEncryptedMediaAPIEnabled"_s
            },
#endif
#if ENABLE(MODEL_PROCESS)
            {
                "bool"_s,
                "modelProcessEnabled"_s
            },
#endif
            {
                "bool"_s,
                "backgroundFetchAPIEnabled"_s
            },
            {
                "bool"_s,
                "blobFileAccessEnforcementEnabled"_s
            },
#if ENABLE(MEDIA_SESSION_COORDINATOR)
            {
                "bool"_s,
                "mediaSessionCoordinatorEnabled"_s
            },
#endif
            {
                "bool"_s,
                "fileSystemEnabled"_s
            },
            {
                "bool"_s,
                "fileSystemWritableStreamEnabled"_s
            },
            {
                "bool"_s,
                "forceLockdownFontParserEnabled"_s
            },
#if ENABLE(FULLSCREEN_API)
            {
                "bool"_s,
                "fullScreenEnabled"_s
            },
#endif
#if ENABLE(GPU_PROCESS)
            {
                "bool"_s,
                "useGPUProcessForDOMRenderingEnabled"_s
            },
#endif
#if ENABLE(GPU_PROCESS)
            {
                "bool"_s,
                "useGPUProcessForMediaEnabled"_s
            },
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
            {
                "bool"_s,
                "useGPUProcessForWebGLEnabled"_s
            },
#endif
#if ENABLE(GAMEPAD)
            {
                "bool"_s,
                "gamepadsEnabled"_s
            },
#endif
            {
                "bool"_s,
                "geolocationAPIEnabled"_s
            },
#if ENABLE(MODEL_ELEMENT)
            {
                "bool"_s,
                "modelElementEnabled"_s
            },
#endif
            {
                "bool"_s,
                "inputTypeColorEnhancementsEnabled"_s
            },
            {
                "bool"_s,
                "ignoreIframeEmbeddingProtectionsEnabled"_s
            },
            {
                "bool"_s,
                "indexedDBAPIEnabled"_s
            },
            {
                "bool"_s,
                "lockdownFontParserEnabled"_s
            },
#if ENABLE(MEDIA_SOURCE)
            {
                "bool"_s,
                "managedMediaSourceEnabled"_s
            },
#endif
#if ENABLE(EXTENSION_CAPABILITIES)
            {
                "bool"_s,
                "mediaCapabilityGrantsEnabled"_s
            },
#endif
            {
                "bool"_s,
                "mediaPlaybackEnabled"_s
            },
#if ENABLE(MEDIA_SESSION)
            {
                "bool"_s,
                "mediaSessionEnabled"_s
            },
#endif
            {
                "bool"_s,
                "mediaSourceEnabled"_s
            },
#if ENABLE(MEDIA_RECORDER_WEBM)
            {
                "bool"_s,
                "mediaRecorderEnabledWebM"_s
            },
#endif
#if ENABLE(MEDIA_RECORDER)
            {
                "bool"_s,
                "mediaRecorderEnabled"_s
            },
#endif
#if ENABLE(MEDIA_SOURCE) && USE(AVFOUNDATION)
            {
                "bool"_s,
                "mediaSourcePrefersDecompressionSession"_s
            },
#endif
            {
                "bool"_s,
                "inputTypeMonthEnabled"_s
            },
#if ENABLE(NOTIFICATION_EVENT)
            {
                "bool"_s,
                "notificationEventEnabled"_s
            },
#endif
#if ENABLE(NOTIFICATIONS)
            {
                "bool"_s,
                "notificationsEnabled"_s
            },
#endif
            {
                "bool"_s,
                "permissionsAPIEnabled"_s
            },
#if HAVE(SPATIAL_AUDIO_EXPERIENCE)
            {
                "bool"_s,
                "preferSpatialAudioExperience"_s
            },
#endif
            {
                "bool"_s,
                "pushAPIEnabled"_s
            },
            {
                "bool"_s,
                "remoteMediaSessionManagerEnabled"_s
            },
            {
                "bool"_s,
                "loginStatusAPIRequiresWebAuthnEnabled"_s
            },
            {
                "bool"_s,
                "screenOrientationAPIEnabled"_s
            },
            {
                "bool"_s,
                "serviceWorkerNavigationPreloadEnabled"_s
            },
            {
                "bool"_s,
                "serviceWorkersEnabled"_s
            },
            {
                "bool"_s,
                "shapeDetection"_s
            },
            {
                "bool"_s,
                "siteIsolationSharedProcessEnabled"_s
            },
            {
                "bool"_s,
                "sharedWorkerEnabled"_s
            },
            {
                "bool"_s,
                "siteIsolationEnabled"_s
            },
            {
                "bool"_s,
                "speechRecognitionEnabled"_s
            },
            {
                "bool"_s,
                "speechSynthesisAPIEnabled"_s
            },
#if ENABLE(IMAGE_ANALYSIS) && ENABLE(VIDEO)
            {
                "bool"_s,
                "textRecognitionInVideosEnabled"_s
            },
#endif
            {
                "bool"_s,
                "inputTypeTimeEnabled"_s
            },
#if HAVE(AVCAPTUREDEVICEROTATIONCOORDINATOR)
            {
                "bool"_s,
                "useAVCaptureDeviceRotationCoordinatorAPI"_s
            },
#endif
#if HAVE(WEBCONTENTRESTRICTIONS)
            {
                "bool"_s,
                "usesWebContentRestrictionsForFilter"_s
            },
#endif
#if USE(MODERN_AVCONTENTKEYSESSION_WITH_VTDECOMPRESSIONSESSION)
            {
                "bool"_s,
                "videoRendererProtectedFallbackDisabled"_s
            },
#endif
#if USE(MODERN_AVCONTENTKEYSESSION_WITH_VTDECOMPRESSIONSESSION)
            {
                "bool"_s,
                "videoRendererUseDecompressionSessionForProtected"_s
            },
#endif
#if ENABLE(WEB_AUTHN)
            {
                "bool"_s,
                "webAuthenticationEnabled"_s
            },
#endif
            {
                "bool"_s,
                "webLocksAPIEnabled"_s
            },
            {
                "bool"_s,
                "webShareEnabled"_s
            },
#if ENABLE(WEB_CODECS)
            {
                "bool"_s,
                "webCodecsVideoEnabled"_s
            },
#endif
            {
                "bool"_s,
                "webGLEnabled"_s
            },
            {
                "bool"_s,
                "webGPUHDREnabled"_s
            },
            {
                "bool"_s,
                "webXRWebGPUBindingsEnabled"_s
            },
            {
                "bool"_s,
                "webGPUEnabled"_s
            },
#if ENABLE(WEB_RTC)
            {
                "bool"_s,
                "peerConnectionEnabled"_s
            },
#endif
#if ENABLE(WEB_RTC) && PLATFORM(COCOA)
            {
                "bool"_s,
                "webRTCInterfaceMonitoringViaNWEnabled"_s
            },
#endif
            {
                "bool"_s,
                "webTransportEnabled"_s
            },
#if ENABLE(WEBXR)
            {
                "bool"_s,
                "webXREnabled"_s
            },
#endif
#if ENABLE(WEB_PAGE_SPATIAL_BACKDROP)
            {
                "bool"_s,
                "webPageSpatialBackdropEnabled"_s
            },
#endif
            {
                "bool"_s,
                "inputTypeWeekEnabled"_s
            },
            {
                "bool"_s,
                "inputTypeDateTimeLocalEnabled"_s
            },
            {
                "bool"_s,
                "shadowRootReferenceTargetEnabledForAriaOwns"_s
            },
            {
                "bool"_s,
                "shadowRootReferenceTargetEnabled"_s
            },
        } },
        { "WebCore::PathSegment::Data"_s, {
        {
            "Variant<WebCore::PathMoveTo, WebCore::PathLineTo, WebCore::PathQuadCurveTo, WebCore::PathBezierCurveTo, WebCore::PathArcTo, WebCore::PathArc, WebCore::PathClosedArc, WebCore::PathEllipse, WebCore::PathEllipseInRect, WebCore::PathRect, WebCore::PathRoundedRect, WebCore::PathContinuousRoundedRect, WebCore::PathDataLine, WebCore::PathDataQuadCurve, WebCore::PathDataBezierCurve, WebCore::PathDataArc, WebCore::PathCloseSubpath>"_s
            , "alias"_s }
        } },
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "WebCore::TextDrawingModeFlags"_s, {
        {
            "OptionSet<WebCore::TextDrawingMode>"_s
            , "alias"_s }
        } },
#endif
        { "WebCore::FetchingWorkerIdentifier"_s, {
        {
            "Variant<std::monostate, WebCore::SharedWorkerIdentifier, WebCore::ServiceWorkerIdentifier>"_s
            , "alias"_s }
        } },
        { "WebKit::ActivityStateChangeID"_s, {
        {
            "uint64_t"_s
            , "alias"_s }
        } },
        { "WebCore::ScrollOffset"_s, {
        {
            "WebCore::IntPoint"_s
            , "alias"_s }
        } },
#if (USE(LIBWEBRTC)) && (USE(LIBWEBRTC) && PLATFORM(COCOA))
        { "webrtc::WebKitEncodedFrameTiming"_s, {
        {
            "webrtc::EncodedImage::Timing"_s
            , "alias"_s }
        } },
#endif
#if OS(WINDOWS)
        { "WTF::ProcessID"_s, {
        {
            "int"_s
            , "alias"_s }
        } },
#endif
#if !(OS(WINDOWS))
        { "WTF::ProcessID"_s, {
        {
            "pid_t"_s
            , "alias"_s }
        } },
#endif
        { "FileSystem::Salt"_s, {
        {
            "std::array<uint8_t, 8>"_s
            , "alias"_s }
        } },
        { "WebCore::IndexIDToIndexKeyMap"_s, {
        {
            "HashMap<WebCore::IDBIndexIdentifier, WebCore::IndexKey>"_s
            , "alias"_s }
        } },
        { "WebCore::TargetedElementIdentifiers"_s, {
        {
            "std::pair<WebCore::NodeIdentifier, WebCore::ScriptExecutionContextIdentifier>"_s
            , "alias"_s }
        } },
        { "WebCore::TargetedElementSelectors"_s, {
        {
            "Vector<HashSet<String>>"_s
            , "alias"_s }
        } },
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticatorResponseDataSerializableForm"_s, {
        {
            "Variant<std::nullptr_t, WebCore::AuthenticatorResponseBaseData, WebCore::AuthenticatorAttestationResponseData, WebCore::AuthenticatorAssertionResponseData>"_s
            , "alias"_s }
        } },
#endif
#if ENABLE(WEB_AUTHN)
        { "WebCore::PointerID"_s, {
        {
            "uint32_t"_s
            , "alias"_s }
        } },
#endif
#if USE(CG)
        { "WebCore::PlatformColorSpace"_s, {
        {
            "RetainPtr<CGColorSpaceRef>"_s
            , "alias"_s }
        } },
#endif
#if (!(USE(CG))) && (USE(SKIA))
        { "WebCore::PlatformColorSpace"_s, {
        {
            "sk_sp<SkColorSpace>"_s
            , "alias"_s }
        } },
#endif
        { "WebCore::PlatformDisplayID"_s, {
        {
            "uint32_t"_s
            , "alias"_s }
        } },
        { "WebCore::Style::LengthAll"_s, {
        {
            "WebCore::Style::Length<WebCore::CSS::All>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::LengthPercentageNonnegative"_s, {
        {
            "WebCore::Style::LengthPercentage<WebCore::CSS::Nonnegative>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::LengthPercentageAll"_s, {
        {
            "WebCore::Style::LengthPercentage<WebCore::CSS::All>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::LengthPercentageSpaceSeparatedPointAll"_s, {
        {
            "WebCore::SpaceSeparatedPoint<WebCore::Style::LengthPercentageAll>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::LengthPercentageSpaceSeparatedPointNonnegative"_s, {
        {
            "WebCore::SpaceSeparatedPoint<WebCore::Style::LengthPercentageNonnegative>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::ShapeCommand"_s, {
        {
            "Variant<WebCore::Style::MoveCommand, WebCore::Style::LineCommand, WebCore::Style::HLineCommand, WebCore::Style::VLineCommand, WebCore::Style::CurveCommand, WebCore::Style::SmoothCommand, WebCore::Style::ArcCommand, WebCore::Style::CloseCommand>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::ClosestCorner"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueClosestCorner>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::ClosestSide"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueClosestSide>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::FarthestCorner"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueFarthestCorner>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::FarthestSide"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueFarthestSide>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::Circle::Extent"_s, {
        {
            "Variant<WebCore::CSS::Keyword::ClosestCorner, WebCore::CSS::Keyword::ClosestSide, WebCore::CSS::Keyword::FarthestCorner, WebCore::CSS::Keyword::FarthestSide>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::Circle::RadialSize"_s, {
        {
            "Variant<WebCore::Style::LengthPercentage<WebCore::CSS::Nonnegative>, WebCore::Style::Circle::Extent>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::Ellipse::Extent"_s, {
        {
            "Variant<WebCore::CSS::Keyword::ClosestCorner, WebCore::CSS::Keyword::ClosestSide, WebCore::CSS::Keyword::FarthestCorner, WebCore::CSS::Keyword::FarthestSide>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::Ellipse::RadialSize"_s, {
        {
            "Variant<WebCore::Style::LengthPercentage<WebCore::CSS::Nonnegative>, WebCore::Style::Ellipse::Extent>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::Nonzero"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueNonzero>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::Evenodd"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueEvenodd>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::FillRule"_s, {
        {
            "Variant<WebCore::CSS::Keyword::Nonzero, WebCore::CSS::Keyword::Evenodd>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::CoordinatePair"_s, {
        {
            "WebCore::SpaceSeparatedPoint<WebCore::Style::LengthPercentageAll>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::CommandAffinity"_s, {
        {
            "Variant<WebCore::CSS::Keyword::By, WebCore::CSS::Keyword::To>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::By"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueBy>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::To"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueTo>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::Ccw"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueCcw>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::Cw"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueCw>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::Large"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueLarge>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::Small"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueSmall>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::Start"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueStart>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::End"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueEnd>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::Origin"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueOrigin>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::ControlPointAnchor"_s, {
        {
            "Variant<WebCore::CSS::Keyword::Start, WebCore::CSS::Keyword::End, WebCore::CSS::Keyword::Origin>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::CloseCommand"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueClose>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::LengthPercentageMinimallySerializingSpaceSeparatedSizeAll"_s, {
        {
            "WebCore::MinimallySerializingSpaceSeparatedSize<WebCore::Style::LengthPercentageAll>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::Sides"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueSides>"_s
            , "alias"_s }
        } },
        { "WebCore::CSS::Keyword::Contain"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueContain>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::RaySize"_s, {
        {
            "Variant<WebCore::CSS::Keyword::ClosestCorner, WebCore::CSS::Keyword::ClosestSide, WebCore::CSS::Keyword::FarthestCorner, WebCore::CSS::Keyword::FarthestSide, WebCore::CSS::Keyword::Sides>"_s
            , "alias"_s }
        } },
        { "WebCore::Style::BasicShape"_s, {
        {
            "Variant<WebCore::Style::CircleFunction, WebCore::Style::EllipseFunction, WebCore::Style::InsetFunction, WebCore::Style::PathFunction, WebCore::Style::PolygonFunction, WebCore::Style::ShapeFunction>"_s
            , "alias"_s }
        } },
        { "WebCore::ResourceResponseBase::Type"_s, {
        {
            "WebCore::ResourceResponseBaseType"_s
            , "alias"_s }
        } },
        { "WebCore::ResourceResponseBase::Tainting"_s, {
        {
            "WebCore::ResourceResponseBaseTainting"_s
            , "alias"_s }
        } },
        { "WebCore::ResourceResponseBase::Source"_s, {
        {
            "WebCore::ResourceResponseSource"_s
            , "alias"_s }
        } },
        { "WebCore::SharedStringHash"_s, {
        {
            "uint32_t"_s
            , "alias"_s }
        } },
        { "PlatformGLObject"_s, {
        {
            "GCGLuint"_s
            , "alias"_s }
        } },
        { "GCGLuint"_s, {
        {
            "unsigned"_s
            , "alias"_s }
        } },
        { "WebCore::IDBConnectionIdentifier"_s, {
        {
            "WebCore::ProcessIdentifier"_s
            , "alias"_s }
        } },
        { "WebCore::TransferredMessagePort"_s, {
        {
            "std::pair<WebCore::MessagePortIdentifier, WebCore::MessagePortIdentifier>"_s
            , "alias"_s }
        } },
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::CSS::Keyword::Auto"_s, {
        {
            "WebCore::Constant<WebCore::CSSValueAuto>"_s
            , "alias"_s }
        } },
#endif
#if ENABLE(WRITING_TOOLS)
        { "WebCore::WritingTools::SessionID"_s, {
        {
            "WTF::UUID"_s
            , "alias"_s }
        } },
#endif
#if ENABLE(WRITING_TOOLS)
        { "WebCore::WritingTools::ContextID"_s, {
        {
            "WTF::UUID"_s
            , "alias"_s }
        } },
#endif
#if ENABLE(WRITING_TOOLS)
        { "WebCore::WritingTools::TextSuggestionID"_s, {
        {
            "WTF::UUID"_s
            , "alias"_s }
        } },
#endif
        { "WebCore::ViewportConstraints::AnchorEdges"_s, {
        {
            "unsigned"_s
            , "alias"_s }
        } },
        { "WebCore::FontSelectionValue::BackingType"_s, {
        {
            "int16_t"_s
            , "alias"_s }
        } },
        { "WebCore::FontTag"_s, {
        {
            "std::array<char, 4>"_s
            , "alias"_s }
        } },
#if ENABLE(MEDIA_SOURCE)
        { "WebCore::SourceBufferPrivate::SamplesPromise::Result"_s, {
        {
            "Expected<Vector<String>, WebCore::PlatformMediaError>"_s
            , "alias"_s }
        } },
#endif
        { "WebCore::MediaProducerMutedStateFlags"_s, {
        {
            "OptionSet<WebCore::MediaProducerMutedState>"_s
            , "alias"_s }
        } },
        { "WebCore::FramesPerSecond"_s, {
        {
            "unsigned"_s
            , "alias"_s }
        } },
        { "WebCore::PlatformGPUID"_s, {
        {
            "uint64_t"_s
            , "alias"_s }
        } },
        { "WebCore::GraphicsStyle"_s, {
        {
            "Variant<WebCore::GraphicsDropShadow, WebCore::GraphicsGaussianBlur, WebCore::GraphicsColorMatrix>"_s
            , "alias"_s }
        } },
#if USE(CG)
        { "WebCore::GlyphBufferGlyph"_s, {
        {
            "CGGlyph"_s
            , "alias"_s }
        } },
#endif
#if !(USE(CG))
        { "WebCore::GlyphBufferGlyph"_s, {
        {
            "WebCore::Glyph"_s
            , "alias"_s }
        } },
#endif
        { "WebCore::Glyph"_s, {
        {
            "unsigned short"_s
            , "alias"_s }
        } },
        { "WebCore::ContentExtensionEnablement"_s, {
        {
            "std::pair<WebCore::ContentExtensionDefaultEnablement, HashSet<String>>"_s
            , "alias"_s }
        } },
#if PLATFORM(COCOA) && ENABLE(WEBGL)
        { "WebCore::GraphicsContextGL::ExternalImageSource"_s, {
        {
            "Variant<WebCore::GraphicsContextGLExternalImageSourceIOSurfaceHandle, WebCore::GraphicsContextGLExternalImageSourceMTLSharedTextureHandle>"_s
            , "alias"_s }
        } },
#endif
#if PLATFORM(COCOA) && ENABLE(WEBGL)
        { "WebCore::GraphicsContextGL::ExternalSyncSource"_s, {
        {
            "std::tuple<MachSendRight, uint64_t>"_s
            , "alias"_s }
        } },
#endif
#if (!PLATFORM(COCOA) && ENABLE(WEBGL)) && ((PLATFORM(GTK) || PLATFORM(WPE)))
        { "WebCore::GraphicsContextGL::ExternalImageSource"_s, {
        {
            "WebCore::GraphicsContextGLExternalImageSource"_s
            , "alias"_s }
        } },
#endif
#if (!PLATFORM(COCOA) && ENABLE(WEBGL)) && (!((PLATFORM(GTK) || PLATFORM(WPE))))
        { "WebCore::GraphicsContextGL::ExternalImageSource"_s, {
        {
            "int"_s
            , "alias"_s }
        } },
#endif
#if !PLATFORM(COCOA) && ENABLE(WEBGL)
        { "WebCore::GraphicsContextGL::ExternalSyncSource"_s, {
        {
            "int"_s
            , "alias"_s }
        } },
#endif
        { "WebCore::DOMCacheEngine::CacheInfosOrError"_s, {
        {
            "Expected<WebCore::DOMCacheEngine::CacheInfos, WebCore::DOMCacheEngine::Error>"_s
            , "alias"_s }
        } },
        { "WebCore::DOMCacheEngine::CacheIdentifierOrError"_s, {
        {
            "Expected<WebCore::DOMCacheEngine::CacheIdentifierOperationResult, WebCore::DOMCacheEngine::Error>"_s
            , "alias"_s }
        } },
        { "WebCore::DOMCacheEngine::RecordIdentifiersOrError"_s, {
        {
            "Expected<Vector<uint64_t>, WebCore::DOMCacheEngine::Error>"_s
            , "alias"_s }
        } },
        { "WebCore::DOMCacheEngine::CrossThreadRecordsOrError"_s, {
        {
            "Expected<Vector<WebCore::DOMCacheEngine::CrossThreadRecord>, WebCore::DOMCacheEngine::Error>"_s
            , "alias"_s }
        } },
        { "WebCore::DOMCacheEngine::RemoveCacheIdentifierOrError"_s, {
        {
            "Expected<bool, WebCore::DOMCacheEngine::Error>"_s
            , "alias"_s }
        } },
        { "WebCore::SVGFilterExpression"_s, {
        {
            "Vector<WebCore::SVGFilterExpressionTerm>"_s
            , "alias"_s }
        } },
        { "WebCore::SandboxFlags"_s, {
        {
            "OptionSet<WebCore::SandboxFlag>"_s
            , "alias"_s }
        } },
#if ENABLE(VIDEO)
        { "WebCore::MediaPlayer::VideoFullscreenMode"_s, {
        {
            "uint32_t"_s
            , "alias"_s }
        } },
#endif
#if ENABLE(VIDEO)
        { "WebCore::TrackID"_s, {
        {
            "uint64_t"_s
            , "alias"_s }
        } },
#endif
        { "WebCore::EpochTimeStamp"_s, {
        {
            "uint64_t"_s
            , "alias"_s }
        } },
        { "WebCore::SharedMemory::Handle"_s, {
        {
            "WebCore::SharedMemoryHandle"_s
            , "alias"_s }
        } },
        { "WebCore::ServiceWorkerOrClientIdentifier"_s, {
        {
            "Variant<WebCore::ScriptExecutionContextIdentifier, WebCore::ServiceWorkerIdentifier>"_s
            , "alias"_s }
        } },
#if OS(WINDOWS)
        { "ProcessID"_s, {
        {
            "int"_s
            , "alias"_s }
        } },
#endif
#if !(OS(WINDOWS))
        { "ProcessID"_s, {
        {
            "pid_t"_s
            , "alias"_s }
        } },
#endif
        { "WebCore::IntDegrees"_s, {
        {
            "int32_t"_s
            , "alias"_s }
        } },
        { "WebCore::PageOverlay::PageOverlayID"_s, {
        {
            "uint64_t"_s
            , "alias"_s }
        } },
#if ENABLE(INSPECTOR_EXTENSIONS)
        { "Inspector::ExtensionTabID"_s, {
        {
            "String"_s
            , "alias"_s }
        } },
#endif
        { "WebCore::IDBKeyPath"_s, {
        {
            "Variant<String, Vector<String>>"_s
            , "alias"_s }
        } },
        { "WebCore::ServiceWorkerOrClientData"_s, {
        {
            "Variant<WebCore::ServiceWorkerData, WebCore::ServiceWorkerClientData>"_s
            , "alias"_s }
        } },
#if PLATFORM(IOS_FAMILY)
        { "WebCore::RenderThemeIOS::CSSValueToSystemColorMap"_s, {
        {
            "HashMap<WebCore::CSSValueKey, WebCore::Color>"_s
            , "alias"_s }
        } },
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(LEGACY_ENCRYPTED_MEDIA)
        { "WebCore::LegacyCDMSessionClient::MediaKeyErrorCode"_s, {
        {
            "unsigned short"_s
            , "alias"_s }
        } },
#endif
        { "WebCore::PermissionsPolicy::InheritedPolicy"_s, {
        {
            "HashSet<WebCore::PermissionsPolicy::Feature, IntHash<WebCore::PermissionsPolicy::Feature>, WTF::StrongEnumHashTraits<WebCore::PermissionsPolicy::Feature>>"_s
            , "alias"_s }
        } },
        { "WebCore::OwnerPermissionsPolicyData::PolicyDirective"_s, {
        {
            "HashMap<WebCore::PermissionsPolicy::Feature, WebCore::Allowlist, IntHash<WebCore::PermissionsPolicy::Feature>, WTF::StrongEnumHashTraits<WebCore::PermissionsPolicy::Feature>>"_s
            , "alias"_s }
        } },
        { "WebCore::FixedContainerEdge"_s, {
        {
            "Variant<WebCore::PredominantColorType, WebCore::Color>"_s
            , "alias"_s }
        } },
        { "WebCore::FontPlatformData::IPCData"_s, {
        {
            "Variant<WebCore::FontPlatformSerializedData, WebCore::FontPlatformSerializedCreationData>"_s
            , "alias"_s }
        } },
        { "WebKit::WebPreferencesStore::ValueMap"_s, {
        {
            "MemoryCompactRobinHoodHashMap<String, WebKit::WebPreferencesStore::Value>"_s
            , "alias"_s }
        } },
        { "WebKit::WebPreferencesStore::Value"_s, {
        {
            "Variant<String, bool, uint32_t, double>"_s
            , "alias"_s }
        } },
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionError"_s, {
        {
            "String"_s
            , "alias"_s }
        } },
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
        { "WebKit::WebExtensionContext::PageIdentifierTuple"_s, {
        {
            "std::tuple<WebCore::PageIdentifier, std::optional<WebKit::WebExtensionTabIdentifier>, std::optional<WebKit::WebExtensionWindowIdentifier>>"_s
            , "alias"_s }
        } },
#endif
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::Color"_s, {
        {
            "Variant<Vector<double>, WebKit::WebGPU::ColorDict>"_s
            , "alias"_s }
        } },
#endif
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::Extent3D"_s, {
        {
            "Variant<Vector<WebCore::WebGPU::IntegerCoordinate>, WebKit::WebGPU::Extent3DDict>"_s
            , "alias"_s }
        } },
#endif
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::Origin2D"_s, {
        {
            "Variant<Vector<WebCore::WebGPU::IntegerCoordinate>, WebKit::WebGPU::Origin2DDict>"_s
            , "alias"_s }
        } },
#endif
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::Origin3D"_s, {
        {
            "Variant<Vector<WebCore::WebGPU::IntegerCoordinate>, WebKit::WebGPU::Origin3DDict>"_s
            , "alias"_s }
        } },
#endif
#if ENABLE(GPU_PROCESS)
        { "WebKit::WebGPU::Error"_s, {
        {
            "Variant<WebKit::WebGPU::OutOfMemoryError, WebKit::WebGPU::ValidationError, WebKit::WebGPU::InternalError>"_s
            , "alias"_s }
        } },
#endif
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING) && PLATFORM(COCOA)
        { "WebKit::ImageBufferBackendHandle"_s, {
        {
            "Variant<WebCore::ShareableBitmapHandle, MachSendRight, WebCore::DynamicContentScalingDisplayList>"_s
            , "alias"_s }
        } },
#endif
#if !ENABLE(RE_DYNAMIC_CONTENT_SCALING) && PLATFORM(COCOA)
        { "WebKit::ImageBufferBackendHandle"_s, {
        {
            "Variant<WebCore::ShareableBitmapHandle, MachSendRight>"_s
            , "alias"_s }
        } },
#endif
#if !PLATFORM(COCOA)
        { "WebKit::ImageBufferBackendHandle"_s, {
        {
            "Variant<WebCore::ShareableBitmapHandle>"_s
            , "alias"_s }
        } },
#endif
#if ENABLE(GPU_PROCESS) && PLATFORM(COCOA) && ENABLE(VIDEO)
        { "WebKit::SharedVideoFrame::Buffer"_s, {
        {
            "Variant<std::nullptr_t, WebKit::RemoteVideoFrameReadReference, MachSendRight, WebCore::IntSize>"_s
            , "alias"_s }
        } },
#endif
#if USE(SKIA)
        { "hb_tag_t"_s, {
        {
            "uint32_t"_s
            , "alias"_s }
        } },
#endif
#if !ENABLE(DOM_AUDIO_SESSION)
        { "WebCore::DOMAudioSessionType"_s, {
        {
            "bool"_s
            , "alias"_s }
        } },
#endif
        { "WebCore::ProcessSyncDataVariant"_s, {
        {
            "Variant<WebCore::DOMAudioSessionType, bool, bool, bool, URL, RefPtr<WebCore::SecurityOrigin>, OptionSet<WebCore::DocumentClass>, bool, bool, RefPtr<WebCore::SecurityOrigin>>"_s
            , "alias"_s }
        } },
        { "WebCore::ProtectionSpace::ServerType"_s, {
        {
            "WebCore::ProtectionSpaceBaseServerType"_s
            , "alias"_s }
        } },
        { "WebCore::ProtectionSpace::AuthenticationScheme"_s, {
        {
            "WebCore::ProtectionSpaceBaseAuthenticationScheme"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::MapModeFlags"_s, {
        {
            "OptionSet<WebCore::WebGPU::MapMode>"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::Size64"_s, {
        {
            "uint64_t"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::Size32"_s, {
        {
            "uint32_t"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::BufferDynamicOffset"_s, {
        {
            "uint32_t"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::IntegerCoordinate"_s, {
        {
            "uint32_t"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::Index32"_s, {
        {
            "uint32_t"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::StencilValue"_s, {
        {
            "uint32_t"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::SampleMask"_s, {
        {
            "uint32_t"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::DepthBias"_s, {
        {
            "int32_t"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::SignedOffset32"_s, {
        {
            "int32_t"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::FlagsConstant"_s, {
        {
            "uint32_t"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::ShaderStageFlags"_s, {
        {
            "OptionSet<WebCore::WebGPU::ShaderStage>"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::ColorWriteFlags"_s, {
        {
            "uint32_t"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::TextureUsageFlags"_s, {
        {
            "OptionSet<WebCore::WebGPU::TextureUsage>"_s
            , "alias"_s }
        } },
        { "WebCore::WebGPU::BufferUsageFlags"_s, {
        {
            "uint16_t"_s
            , "alias"_s }
        } },
    };
}

Vector<SerializedEnumInfo> allSerializedEnums()
{
    return {
        { "WebCore::PathRoundedRect::Strategy"_s, sizeof(WebCore::PathRoundedRect::Strategy), false, {
            enumValueForIPCTestAPI(WebCore::PathRoundedRect::Strategy::PreferNative),
            enumValueForIPCTestAPI(WebCore::PathRoundedRect::Strategy::PreferBezier),
        } },
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "WebCore::TextDrawingMode"_s, sizeof(WebCore::TextDrawingMode), false, {
            enumValueForIPCTestAPI(WebCore::TextDrawingMode::Fill),
            enumValueForIPCTestAPI(WebCore::TextDrawingMode::Stroke),
        } },
#endif
        { "WebKit::LoadedWebArchive"_s, sizeof(WebKit::LoadedWebArchive), false, {
            0, 1
        } },
        { "WebKit::DidFilterKnownLinkDecoration"_s, sizeof(WebKit::DidFilterKnownLinkDecoration), false, {
            0, 1
        } },
        { "WebKit::ShouldGrandfatherStatistics"_s, sizeof(WebKit::ShouldGrandfatherStatistics), false, {
            0, 1
        } },
        { "WebKit::PrivateRelayed"_s, sizeof(WebKit::PrivateRelayed), false, {
            0, 1
        } },
        { "WebKit::ContentAsStringIncludesChildFrames"_s, sizeof(WebKit::ContentAsStringIncludesChildFrames), false, {
            0, 1
        } },
        { "WebKit::CallDownloadDidStart"_s, sizeof(WebKit::CallDownloadDidStart), false, {
            0, 1
        } },
        { "WebKit::AllowOverwrite"_s, sizeof(WebKit::AllowOverwrite), false, {
            0, 1
        } },
        { "WebKit::UseDownloadPlaceholder"_s, sizeof(WebKit::UseDownloadPlaceholder), false, {
            0, 1
        } },
        { "WebKit::PreconnectOnly"_s, sizeof(WebKit::PreconnectOnly), false, {
            0, 1
        } },
        { "WebKit::NavigatingToAppBoundDomain"_s, sizeof(WebKit::NavigatingToAppBoundDomain), false, {
            0, 1
        } },
        { "WebKit::AllowsCellularAccess"_s, sizeof(WebKit::AllowsCellularAccess), false, {
            0, 1
        } },
#if USE(SOUP)
        { "WebKit::SoupCookiePersistentStorageType"_s, sizeof(WebKit::SoupCookiePersistentStorageType), false, {
            0, 1
        } },
#endif
        { "WebKit::StorageAccessStatus"_s, sizeof(WebKit::StorageAccessStatus), false, {
            enumValueForIPCTestAPI(WebKit::StorageAccessStatus::CannotRequestAccess),
            enumValueForIPCTestAPI(WebKit::StorageAccessStatus::RequiresUserPrompt),
            enumValueForIPCTestAPI(WebKit::StorageAccessStatus::HasAccess),
        } },
        { "WebKit::PCM::MessageType"_s, sizeof(WebKit::PCM::MessageType), false, {
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::StoreUnattributed),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::HandleAttribution),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::Clear),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::ClearForRegistrableDomain),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::MigratePrivateClickMeasurementFromLegacyStorage),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::SetDebugModeIsEnabled),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::ToStringForTesting),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::SetOverrideTimerForTesting),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::SetTokenPublicKeyURLForTesting),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::SetTokenSignatureURLForTesting),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::SetAttributionReportURLsForTesting),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::MarkAllUnattributedAsExpiredForTesting),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::MarkAttributedPrivateClickMeasurementsAsExpiredForTesting),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::SetPCMFraudPreventionValuesForTesting),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::StartTimerImmediatelyForTesting),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::SetPrivateClickMeasurementAppBundleIDForTesting),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::DestroyStoreForTesting),
            enumValueForIPCTestAPI(WebKit::PCM::MessageType::AllowTLSCertificateChainForLocalPCMTesting),
        } },
        { "WebKit::PrivateClickMeasurementAttributionType"_s, sizeof(WebKit::PrivateClickMeasurementAttributionType), false, {
            0, 1
        } },
        { "WebKit::FileSystemStorageError"_s, sizeof(WebKit::FileSystemStorageError), false, {
            enumValueForIPCTestAPI(WebKit::FileSystemStorageError::AccessHandleActive),
            enumValueForIPCTestAPI(WebKit::FileSystemStorageError::BackendNotSupported),
            enumValueForIPCTestAPI(WebKit::FileSystemStorageError::FileNotFound),
            enumValueForIPCTestAPI(WebKit::FileSystemStorageError::InvalidDataType),
            enumValueForIPCTestAPI(WebKit::FileSystemStorageError::InvalidModification),
            enumValueForIPCTestAPI(WebKit::FileSystemStorageError::InvalidName),
            enumValueForIPCTestAPI(WebKit::FileSystemStorageError::InvalidState),
            enumValueForIPCTestAPI(WebKit::FileSystemStorageError::MissingArgument),
            enumValueForIPCTestAPI(WebKit::FileSystemStorageError::TypeMismatch),
            enumValueForIPCTestAPI(WebKit::FileSystemStorageError::QuotaError),
            enumValueForIPCTestAPI(WebKit::FileSystemStorageError::Unknown),
        } },
        { "IPC::MessageFlags"_s, sizeof(IPC::MessageFlags), true, {
            enumValueForIPCTestAPI(IPC::MessageFlags::DispatchMessageWhenWaitingForSyncReply),
            enumValueForIPCTestAPI(IPC::MessageFlags::DispatchMessageWhenWaitingForUnboundedSyncReply),
            enumValueForIPCTestAPI(IPC::MessageFlags::UseFullySynchronousModeForTesting),
            enumValueForIPCTestAPI(IPC::MessageFlags::MaintainOrderingWithAsyncMessages),
#if ENABLE(IPC_TESTING_API)
            enumValueForIPCTestAPI(IPC::MessageFlags::SyncMessageDeserializationFailure),
#endif
        } },
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
        { "WebKit::WebKitAXValueState"_s, sizeof(WebKit::WebKitAXValueState), false, {
            enumValueForIPCTestAPI(WebKit::WebKitAXValueState::AXValueStateInvalid),
            enumValueForIPCTestAPI(WebKit::WebKitAXValueState::AXValueStateEmpty),
            enumValueForIPCTestAPI(WebKit::WebKitAXValueState::AXValueStateOff),
            enumValueForIPCTestAPI(WebKit::WebKitAXValueState::AXValueStateOn),
        } },
#endif
        { "WebKit::BackgroundFetchChange"_s, sizeof(WebKit::BackgroundFetchChange), false, {
            enumValueForIPCTestAPI(WebKit::BackgroundFetchChange::Addition),
            enumValueForIPCTestAPI(WebKit::BackgroundFetchChange::Removal),
            enumValueForIPCTestAPI(WebKit::BackgroundFetchChange::Update),
        } },
        { "WebKit::CacheModel"_s, sizeof(WebKit::CacheModel), false, {
            enumValueForIPCTestAPI(WebKit::CacheModel::DocumentViewer),
            enumValueForIPCTestAPI(WebKit::CacheModel::DocumentBrowser),
            enumValueForIPCTestAPI(WebKit::CacheModel::PrimaryWebBrowser),
        } },
        { "WebKit::ContentWorldOption"_s, sizeof(WebKit::ContentWorldOption), true, {
            enumValueForIPCTestAPI(WebKit::ContentWorldOption::AllowAccessToClosedShadowRoots),
            enumValueForIPCTestAPI(WebKit::ContentWorldOption::AllowAutofill),
            enumValueForIPCTestAPI(WebKit::ContentWorldOption::AllowElementUserInfo),
            enumValueForIPCTestAPI(WebKit::ContentWorldOption::DisableLegacyBuiltinOverrides),
            enumValueForIPCTestAPI(WebKit::ContentWorldOption::AllowNodeInfo),
        } },
        { "WebKit::CoordinateSystem"_s, sizeof(WebKit::CoordinateSystem), false, {
            enumValueForIPCTestAPI(WebKit::CoordinateSystem::Page),
            enumValueForIPCTestAPI(WebKit::CoordinateSystem::LayoutViewport),
        } },
        { "Inspector::DebuggableType"_s, sizeof(Inspector::DebuggableType), false, {
            enumValueForIPCTestAPI(Inspector::DebuggableType::ITML),
            enumValueForIPCTestAPI(Inspector::DebuggableType::JavaScript),
            enumValueForIPCTestAPI(Inspector::DebuggableType::Page),
            enumValueForIPCTestAPI(Inspector::DebuggableType::ServiceWorker),
            enumValueForIPCTestAPI(Inspector::DebuggableType::WebPage),
        } },
#if PLATFORM(IOS_FAMILY)
        { "WebKit::DocumentEditingContextRequest::Options"_s, sizeof(WebKit::DocumentEditingContextRequest::Options), false, {
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::Text),
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::AttributedText),
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::Rects),
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::Spatial),
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::Annotation),
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::MarkedTextRects),
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::SpatialAndCurrentSelection),
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::AutocorrectedRanges),
        } },
#endif
#if PLATFORM(IOS_FAMILY)
        { "WebKit::DocumentEditingContextRequest::Options"_s, sizeof(WebKit::DocumentEditingContextRequest::Options), true, {
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::Text),
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::AttributedText),
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::Rects),
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::Spatial),
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::Annotation),
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::MarkedTextRects),
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::SpatialAndCurrentSelection),
            enumValueForIPCTestAPI(WebKit::DocumentEditingContextRequest::Options::AutocorrectedRanges),
        } },
#endif
        { "WebKit::DragControllerAction"_s, sizeof(WebKit::DragControllerAction), false, {
            enumValueForIPCTestAPI(WebKit::DragControllerAction::Entered),
            enumValueForIPCTestAPI(WebKit::DragControllerAction::Updated),
            enumValueForIPCTestAPI(WebKit::DragControllerAction::Exited),
            enumValueForIPCTestAPI(WebKit::DragControllerAction::PerformDragOperation),
        } },
#if ENABLE(TILED_CA_DRAWING_AREA)
        { "WebKit::DrawingAreaType"_s, sizeof(WebKit::DrawingAreaType), false, {
            0, 1
        } },
#endif
        { "WebKit::EditingRangeIsRelativeTo"_s, sizeof(WebKit::EditingRangeIsRelativeTo), false, {
            enumValueForIPCTestAPI(WebKit::EditingRangeIsRelativeTo::EditableRoot),
            enumValueForIPCTestAPI(WebKit::EditingRangeIsRelativeTo::Paragraph),
        } },
        { "WebKit::ListType"_s, sizeof(WebKit::ListType), false, {
            enumValueForIPCTestAPI(WebKit::ListType::None),
            enumValueForIPCTestAPI(WebKit::ListType::OrderedList),
            enumValueForIPCTestAPI(WebKit::ListType::UnorderedList),
        } },
        { "WebKit::TextAlignment"_s, sizeof(WebKit::TextAlignment), false, {
            enumValueForIPCTestAPI(WebKit::TextAlignment::Natural),
            enumValueForIPCTestAPI(WebKit::TextAlignment::Left),
            enumValueForIPCTestAPI(WebKit::TextAlignment::Right),
            enumValueForIPCTestAPI(WebKit::TextAlignment::Center),
            enumValueForIPCTestAPI(WebKit::TextAlignment::Justified),
        } },
        { "WebKit::TypingAttribute"_s, sizeof(WebKit::TypingAttribute), true, {
            enumValueForIPCTestAPI(WebKit::TypingAttribute::Bold),
            enumValueForIPCTestAPI(WebKit::TypingAttribute::Italics),
            enumValueForIPCTestAPI(WebKit::TypingAttribute::Underline),
            enumValueForIPCTestAPI(WebKit::TypingAttribute::StrikeThrough),
        } },
        { "WebKit::InputType"_s, sizeof(WebKit::InputType), false, {
            enumValueForIPCTestAPI(WebKit::InputType::None),
            enumValueForIPCTestAPI(WebKit::InputType::ContentEditable),
            enumValueForIPCTestAPI(WebKit::InputType::Text),
            enumValueForIPCTestAPI(WebKit::InputType::Password),
            enumValueForIPCTestAPI(WebKit::InputType::TextArea),
            enumValueForIPCTestAPI(WebKit::InputType::Search),
            enumValueForIPCTestAPI(WebKit::InputType::Email),
            enumValueForIPCTestAPI(WebKit::InputType::URL),
            enumValueForIPCTestAPI(WebKit::InputType::Phone),
            enumValueForIPCTestAPI(WebKit::InputType::Number),
            enumValueForIPCTestAPI(WebKit::InputType::NumberPad),
            enumValueForIPCTestAPI(WebKit::InputType::Date),
            enumValueForIPCTestAPI(WebKit::InputType::DateTimeLocal),
            enumValueForIPCTestAPI(WebKit::InputType::Month),
            enumValueForIPCTestAPI(WebKit::InputType::Week),
            enumValueForIPCTestAPI(WebKit::InputType::Time),
            enumValueForIPCTestAPI(WebKit::InputType::Select),
            enumValueForIPCTestAPI(WebKit::InputType::Drawing),
            enumValueForIPCTestAPI(WebKit::InputType::Color),
        } },
        { "WebKit::ColorControlSupportsAlpha"_s, sizeof(WebKit::ColorControlSupportsAlpha), false, {
            0, 1
        } },
        { "WebKit::FrameType"_s, sizeof(WebKit::FrameType), false, {
            0, 1
        } },
        { "WebKit::FullScreenMediaDetails::Type"_s, sizeof(WebKit::FullScreenMediaDetails::Type), false, {
            enumValueForIPCTestAPI(WebKit::FullScreenMediaDetails::Type::None),
            enumValueForIPCTestAPI(WebKit::FullScreenMediaDetails::Type::Video),
            enumValueForIPCTestAPI(WebKit::FullScreenMediaDetails::Type::ElementWithVideo),
            enumValueForIPCTestAPI(WebKit::FullScreenMediaDetails::Type::Image),
        } },
        { "WebKit::SnapshotOption"_s, sizeof(WebKit::SnapshotOption), true, {
            enumValueForIPCTestAPI(WebKit::SnapshotOption::Shareable),
            enumValueForIPCTestAPI(WebKit::SnapshotOption::ExcludeSelectionHighlighting),
            enumValueForIPCTestAPI(WebKit::SnapshotOption::InViewCoordinates),
            enumValueForIPCTestAPI(WebKit::SnapshotOption::PaintSelectionRectangle),
            enumValueForIPCTestAPI(WebKit::SnapshotOption::ExcludeDeviceScaleFactor),
            enumValueForIPCTestAPI(WebKit::SnapshotOption::ForceBlackText),
            enumValueForIPCTestAPI(WebKit::SnapshotOption::ForceWhiteText),
            enumValueForIPCTestAPI(WebKit::SnapshotOption::Printing),
            enumValueForIPCTestAPI(WebKit::SnapshotOption::UseScreenColorSpace),
            enumValueForIPCTestAPI(WebKit::SnapshotOption::VisibleContentRect),
            enumValueForIPCTestAPI(WebKit::SnapshotOption::FullContentRect),
            enumValueForIPCTestAPI(WebKit::SnapshotOption::TransparentBackground),
            enumValueForIPCTestAPI(WebKit::SnapshotOption::Accelerated),
            enumValueForIPCTestAPI(WebKit::SnapshotOption::AllowHDR),
        } },
#if ENABLE(INSPECTOR_EXTENSIONS)
        { "Inspector::ExtensionError"_s, sizeof(Inspector::ExtensionError), false, {
            enumValueForIPCTestAPI(Inspector::ExtensionError::ContextDestroyed),
            enumValueForIPCTestAPI(Inspector::ExtensionError::InternalError),
            enumValueForIPCTestAPI(Inspector::ExtensionError::InvalidRequest),
            enumValueForIPCTestAPI(Inspector::ExtensionError::RegistrationFailed),
            enumValueForIPCTestAPI(Inspector::ExtensionError::NotImplemented),
        } },
#endif
#if ENABLE(INSPECTOR_EXTENSIONS)
        { "Inspector::ExtensionAppearance"_s, sizeof(Inspector::ExtensionAppearance), false, {
            0, 1
        } },
#endif
        { "JSC::MessageSource"_s, sizeof(JSC::MessageSource), false, {
            enumValueForIPCTestAPI(JSC::MessageSource::XML),
            enumValueForIPCTestAPI(JSC::MessageSource::JS),
            enumValueForIPCTestAPI(JSC::MessageSource::Network),
            enumValueForIPCTestAPI(JSC::MessageSource::ConsoleAPI),
            enumValueForIPCTestAPI(JSC::MessageSource::Storage),
            enumValueForIPCTestAPI(JSC::MessageSource::Rendering),
            enumValueForIPCTestAPI(JSC::MessageSource::CSS),
            enumValueForIPCTestAPI(JSC::MessageSource::Security),
            enumValueForIPCTestAPI(JSC::MessageSource::ContentBlocker),
            enumValueForIPCTestAPI(JSC::MessageSource::Media),
            enumValueForIPCTestAPI(JSC::MessageSource::MediaSource),
            enumValueForIPCTestAPI(JSC::MessageSource::WebRTC),
            enumValueForIPCTestAPI(JSC::MessageSource::ITPDebug),
            enumValueForIPCTestAPI(JSC::MessageSource::PrivateClickMeasurement),
            enumValueForIPCTestAPI(JSC::MessageSource::PaymentRequest),
            enumValueForIPCTestAPI(JSC::MessageSource::Other),
        } },
        { "JSC::MessageType"_s, sizeof(JSC::MessageType), false, {
            enumValueForIPCTestAPI(JSC::MessageType::Log),
            enumValueForIPCTestAPI(JSC::MessageType::Dir),
            enumValueForIPCTestAPI(JSC::MessageType::DirXML),
            enumValueForIPCTestAPI(JSC::MessageType::Table),
            enumValueForIPCTestAPI(JSC::MessageType::Trace),
            enumValueForIPCTestAPI(JSC::MessageType::StartGroup),
            enumValueForIPCTestAPI(JSC::MessageType::StartGroupCollapsed),
            enumValueForIPCTestAPI(JSC::MessageType::EndGroup),
            enumValueForIPCTestAPI(JSC::MessageType::Clear),
            enumValueForIPCTestAPI(JSC::MessageType::Assert),
            enumValueForIPCTestAPI(JSC::MessageType::Timing),
            enumValueForIPCTestAPI(JSC::MessageType::Profile),
            enumValueForIPCTestAPI(JSC::MessageType::ProfileEnd),
            enumValueForIPCTestAPI(JSC::MessageType::Image),
        } },
        { "JSC::MessageLevel"_s, sizeof(JSC::MessageLevel), false, {
            enumValueForIPCTestAPI(JSC::MessageLevel::Log),
            enumValueForIPCTestAPI(JSC::MessageLevel::Warning),
            enumValueForIPCTestAPI(JSC::MessageLevel::Error),
            enumValueForIPCTestAPI(JSC::MessageLevel::Debug),
            enumValueForIPCTestAPI(JSC::MessageLevel::Info),
        } },
        { "JSC::SourceTaintedOrigin"_s, sizeof(JSC::SourceTaintedOrigin), false, {
            enumValueForIPCTestAPI(JSC::SourceTaintedOrigin::Untainted),
            enumValueForIPCTestAPI(JSC::SourceTaintedOrigin::IndirectlyTaintedByHistory),
            enumValueForIPCTestAPI(JSC::SourceTaintedOrigin::IndirectlyTainted),
            enumValueForIPCTestAPI(JSC::SourceTaintedOrigin::KnownTainted),
        } },
        { "Inspector::FrontendChannel::ConnectionType"_s, sizeof(Inspector::FrontendChannel::ConnectionType), false, {
            0, 1
        } },
        { "Inspector::InspectorTargetType"_s, sizeof(Inspector::InspectorTargetType), false, {
            enumValueForIPCTestAPI(Inspector::InspectorTargetType::Page),
            enumValueForIPCTestAPI(Inspector::InspectorTargetType::DedicatedWorker),
            enumValueForIPCTestAPI(Inspector::InspectorTargetType::ServiceWorker),
        } },
        { "WebKit::JavaScriptEvaluationResult::EmptyType"_s, sizeof(WebKit::JavaScriptEvaluationResult::EmptyType), false, {
            0, 1
        } },
        { "WebCore::LockHistory"_s, sizeof(WebCore::LockHistory), false, {
            0, 1
        } },
        { "WebCore::LockBackForwardList"_s, sizeof(WebCore::LockBackForwardList), false, {
            0, 1
        } },
        { "WebKit::MediaPlaybackState"_s, sizeof(WebKit::MediaPlaybackState), false, {
            enumValueForIPCTestAPI(WebKit::MediaPlaybackState::NoMediaPlayback),
            enumValueForIPCTestAPI(WebKit::MediaPlaybackState::MediaPlaybackPaused),
            enumValueForIPCTestAPI(WebKit::MediaPlaybackState::MediaPlaybackSuspended),
            enumValueForIPCTestAPI(WebKit::MediaPlaybackState::MediaPlaybackPlaying),
        } },
        { "WebKit::SafeBrowsingCheckOngoing"_s, sizeof(WebKit::SafeBrowsingCheckOngoing), false, {
            0, 1
        } },
#if PLATFORM(GTK)
        { "WebKit::PrintInfo::PrintMode"_s, sizeof(WebKit::PrintInfo::PrintMode), false, {
            enumValueForIPCTestAPI(WebKit::PrintInfo::PrintMode::Async),
            enumValueForIPCTestAPI(WebKit::PrintInfo::PrintMode::Sync),
        } },
#endif
#if USE(LIBWEBRTC)
        { "WebKit::WebRTCNetwork::EcnMarking"_s, sizeof(WebKit::WebRTCNetwork::EcnMarking), false, {
            enumValueForIPCTestAPI(WebKit::WebRTCNetwork::EcnMarking::kNotEct),
            enumValueForIPCTestAPI(WebKit::WebRTCNetwork::EcnMarking::kEct1),
            enumValueForIPCTestAPI(WebKit::WebRTCNetwork::EcnMarking::kEct0),
            enumValueForIPCTestAPI(WebKit::WebRTCNetwork::EcnMarking::kCe),
        } },
#endif
#if (USE(LIBWEBRTC)) && (USE(LIBWEBRTC) && PLATFORM(COCOA))
        { "webrtc::WebKitEncodedVideoRotation"_s, sizeof(webrtc::WebKitEncodedVideoRotation), false, {
            enumValueForIPCTestAPI(webrtc::WebKitEncodedVideoRotation::kVideoRotation_0),
            enumValueForIPCTestAPI(webrtc::WebKitEncodedVideoRotation::kVideoRotation_90),
            enumValueForIPCTestAPI(webrtc::WebKitEncodedVideoRotation::kVideoRotation_180),
            enumValueForIPCTestAPI(webrtc::WebKitEncodedVideoRotation::kVideoRotation_270),
        } },
#endif
#if (USE(LIBWEBRTC)) && (USE(LIBWEBRTC) && PLATFORM(COCOA))
        { "webrtc::VideoFrameType"_s, sizeof(webrtc::VideoFrameType), false, {
            enumValueForIPCTestAPI(webrtc::VideoFrameType::kEmptyFrame),
            enumValueForIPCTestAPI(webrtc::VideoFrameType::kVideoFrameKey),
            enumValueForIPCTestAPI(webrtc::VideoFrameType::kVideoFrameDelta),
        } },
#endif
#if (USE(LIBWEBRTC)) && (USE(LIBWEBRTC) && PLATFORM(COCOA))
        { "webrtc::VideoContentType"_s, sizeof(webrtc::VideoContentType), false, {
            enumValueForIPCTestAPI(webrtc::VideoContentType::UNSPECIFIED),
            enumValueForIPCTestAPI(webrtc::VideoContentType::SCREENSHARE),
        } },
#endif
#if USE(LIBWEBRTC)
        { "WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint"_s, sizeof(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint), false, {
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::NoChange),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::CS0),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::CS1),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::AF11),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::AF12),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::AF13),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::CS2),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::AF21),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::AF22),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::AF23),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::CS3),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::AF31),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::AF32),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::AF33),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::CS4),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::AF41),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::AF42),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::AF43),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::CS5),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::EF),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::CS6),
            enumValueForIPCTestAPI(WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint::CS7),
        } },
#endif
        { "WebKit::RemoteWorkerType"_s, sizeof(WebKit::RemoteWorkerType), false, {
            enumValueForIPCTestAPI(WebKit::RemoteWorkerType::ServiceWorker),
            enumValueForIPCTestAPI(WebKit::RemoteWorkerType::SharedWorker),
        } },
        { "WebKit::ResourceLoadInfo::Type"_s, sizeof(WebKit::ResourceLoadInfo::Type), false, {
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::ApplicationManifest),
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::Beacon),
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::CSPReport),
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::Document),
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::Fetch),
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::Font),
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::Image),
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::Media),
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::Object),
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::Other),
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::Ping),
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::Script),
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::Stylesheet),
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::XMLHTTPRequest),
            enumValueForIPCTestAPI(WebKit::ResourceLoadInfo::Type::XSLT),
        } },
        { "WebCore::SameSiteStrictEnforcementEnabled"_s, sizeof(WebCore::SameSiteStrictEnforcementEnabled), false, {
            0, 1
        } },
        { "WebKit::SameDocumentNavigationType"_s, sizeof(WebKit::SameDocumentNavigationType), false, {
            enumValueForIPCTestAPI(WebKit::SameDocumentNavigationType::AnchorNavigation),
            enumValueForIPCTestAPI(WebKit::SameDocumentNavigationType::SessionStatePush),
            enumValueForIPCTestAPI(WebKit::SameDocumentNavigationType::SessionStateReplace),
            enumValueForIPCTestAPI(WebKit::SameDocumentNavigationType::SessionStatePop),
        } },
        { "WebCore::ClonedDocumentType"_s, sizeof(WebCore::ClonedDocumentType), false, {
            enumValueForIPCTestAPI(WebCore::ClonedDocumentType::XMLDocument),
            enumValueForIPCTestAPI(WebCore::ClonedDocumentType::XHTMLDocument),
            enumValueForIPCTestAPI(WebCore::ClonedDocumentType::HTMLDocument),
            enumValueForIPCTestAPI(WebCore::ClonedDocumentType::SVGDocument),
            enumValueForIPCTestAPI(WebCore::ClonedDocumentType::Document),
        } },
        { "WebKit::SyntheticEditingCommandType"_s, sizeof(WebKit::SyntheticEditingCommandType), false, {
            enumValueForIPCTestAPI(WebKit::SyntheticEditingCommandType::Undo),
            enumValueForIPCTestAPI(WebKit::SyntheticEditingCommandType::Redo),
            enumValueForIPCTestAPI(WebKit::SyntheticEditingCommandType::ToggleBoldface),
            enumValueForIPCTestAPI(WebKit::SyntheticEditingCommandType::ToggleItalic),
            enumValueForIPCTestAPI(WebKit::SyntheticEditingCommandType::ToggleUnderline),
        } },
        { "WebCore::FontWidthVariant"_s, sizeof(WebCore::FontWidthVariant), false, {
            enumValueForIPCTestAPI(WebCore::FontWidthVariant::RegularWidth),
            enumValueForIPCTestAPI(WebCore::FontWidthVariant::HalfWidth),
            enumValueForIPCTestAPI(WebCore::FontWidthVariant::ThirdWidth),
            enumValueForIPCTestAPI(WebCore::FontWidthVariant::QuarterWidth),
        } },
        { "WebCore::Kerning"_s, sizeof(WebCore::Kerning), false, {
            enumValueForIPCTestAPI(WebCore::Kerning::Auto),
            enumValueForIPCTestAPI(WebCore::Kerning::Normal),
            enumValueForIPCTestAPI(WebCore::Kerning::NoShift),
        } },
        { "WebCore::FontOpticalSizing"_s, sizeof(WebCore::FontOpticalSizing), false, {
            0, 1
        } },
        { "WebCore::FontStyleAxis"_s, sizeof(WebCore::FontStyleAxis), false, {
            enumValueForIPCTestAPI(WebCore::FontStyleAxis::slnt),
            enumValueForIPCTestAPI(WebCore::FontStyleAxis::ital),
        } },
        { "WebCore::AllowUserInstalledFonts"_s, sizeof(WebCore::AllowUserInstalledFonts), false, {
            0, 1
        } },
        { "WebCore::FontVariantEastAsianVariant"_s, sizeof(WebCore::FontVariantEastAsianVariant), false, {
            enumValueForIPCTestAPI(WebCore::FontVariantEastAsianVariant::Normal),
            enumValueForIPCTestAPI(WebCore::FontVariantEastAsianVariant::Jis78),
            enumValueForIPCTestAPI(WebCore::FontVariantEastAsianVariant::Jis83),
            enumValueForIPCTestAPI(WebCore::FontVariantEastAsianVariant::Jis90),
            enumValueForIPCTestAPI(WebCore::FontVariantEastAsianVariant::Jis04),
            enumValueForIPCTestAPI(WebCore::FontVariantEastAsianVariant::Simplified),
            enumValueForIPCTestAPI(WebCore::FontVariantEastAsianVariant::Traditional),
        } },
        { "WebCore::FontVariantEastAsianWidth"_s, sizeof(WebCore::FontVariantEastAsianWidth), false, {
            enumValueForIPCTestAPI(WebCore::FontVariantEastAsianWidth::Normal),
            enumValueForIPCTestAPI(WebCore::FontVariantEastAsianWidth::Full),
            enumValueForIPCTestAPI(WebCore::FontVariantEastAsianWidth::Proportional),
        } },
        { "WebCore::FontVariantEastAsianRuby"_s, sizeof(WebCore::FontVariantEastAsianRuby), false, {
            enumValueForIPCTestAPI(WebCore::FontVariantEastAsianRuby::Normal),
            enumValueForIPCTestAPI(WebCore::FontVariantEastAsianRuby::Yes),
        } },
        { "WebCore::FontVariantLigatures"_s, sizeof(WebCore::FontVariantLigatures), false, {
            enumValueForIPCTestAPI(WebCore::FontVariantLigatures::Normal),
            enumValueForIPCTestAPI(WebCore::FontVariantLigatures::Yes),
            enumValueForIPCTestAPI(WebCore::FontVariantLigatures::No),
        } },
        { "WebCore::FontVariantPosition"_s, sizeof(WebCore::FontVariantPosition), false, {
            enumValueForIPCTestAPI(WebCore::FontVariantPosition::Normal),
            enumValueForIPCTestAPI(WebCore::FontVariantPosition::Subscript),
            enumValueForIPCTestAPI(WebCore::FontVariantPosition::Superscript),
        } },
        { "WebCore::FontVariantCaps"_s, sizeof(WebCore::FontVariantCaps), false, {
            enumValueForIPCTestAPI(WebCore::FontVariantCaps::Normal),
            enumValueForIPCTestAPI(WebCore::FontVariantCaps::Small),
            enumValueForIPCTestAPI(WebCore::FontVariantCaps::AllSmall),
            enumValueForIPCTestAPI(WebCore::FontVariantCaps::Petite),
            enumValueForIPCTestAPI(WebCore::FontVariantCaps::AllPetite),
            enumValueForIPCTestAPI(WebCore::FontVariantCaps::Unicase),
            enumValueForIPCTestAPI(WebCore::FontVariantCaps::Titling),
        } },
        { "WebCore::FontVariantNumericFigure"_s, sizeof(WebCore::FontVariantNumericFigure), false, {
            enumValueForIPCTestAPI(WebCore::FontVariantNumericFigure::Normal),
            enumValueForIPCTestAPI(WebCore::FontVariantNumericFigure::LiningNumbers),
            enumValueForIPCTestAPI(WebCore::FontVariantNumericFigure::OldStyleNumbers),
        } },
        { "WebCore::FontVariantNumericSpacing"_s, sizeof(WebCore::FontVariantNumericSpacing), false, {
            enumValueForIPCTestAPI(WebCore::FontVariantNumericSpacing::Normal),
            enumValueForIPCTestAPI(WebCore::FontVariantNumericSpacing::ProportionalNumbers),
            enumValueForIPCTestAPI(WebCore::FontVariantNumericSpacing::TabularNumbers),
        } },
        { "WebCore::FontVariantNumericFraction"_s, sizeof(WebCore::FontVariantNumericFraction), false, {
            enumValueForIPCTestAPI(WebCore::FontVariantNumericFraction::Normal),
            enumValueForIPCTestAPI(WebCore::FontVariantNumericFraction::DiagonalFractions),
            enumValueForIPCTestAPI(WebCore::FontVariantNumericFraction::StackedFractions),
        } },
        { "WebCore::TextRenderingMode"_s, sizeof(WebCore::TextRenderingMode), false, {
            enumValueForIPCTestAPI(WebCore::TextRenderingMode::AutoTextRendering),
            enumValueForIPCTestAPI(WebCore::TextRenderingMode::OptimizeSpeed),
            enumValueForIPCTestAPI(WebCore::TextRenderingMode::OptimizeLegibility),
            enumValueForIPCTestAPI(WebCore::TextRenderingMode::GeometricPrecision),
        } },
        { "WebCore::FontSmoothingMode"_s, sizeof(WebCore::FontSmoothingMode), false, {
            enumValueForIPCTestAPI(WebCore::FontSmoothingMode::AutoSmoothing),
            enumValueForIPCTestAPI(WebCore::FontSmoothingMode::NoSmoothing),
            enumValueForIPCTestAPI(WebCore::FontSmoothingMode::Antialiased),
            enumValueForIPCTestAPI(WebCore::FontSmoothingMode::SubpixelAntialiased),
        } },
        { "WebKit::TextCheckerState"_s, sizeof(WebKit::TextCheckerState), true, {
            enumValueForIPCTestAPI(WebKit::TextCheckerState::ContinuousSpellCheckingEnabled),
            enumValueForIPCTestAPI(WebKit::TextCheckerState::GrammarCheckingEnabled),
#if USE(APPKIT)
            enumValueForIPCTestAPI(WebKit::TextCheckerState::AutomaticTextReplacementEnabled),
#endif
#if USE(APPKIT)
            enumValueForIPCTestAPI(WebKit::TextCheckerState::AutomaticSpellingCorrectionEnabled),
#endif
#if USE(APPKIT)
            enumValueForIPCTestAPI(WebKit::TextCheckerState::AutomaticQuoteSubstitutionEnabled),
#endif
#if USE(APPKIT)
            enumValueForIPCTestAPI(WebKit::TextCheckerState::AutomaticDashSubstitutionEnabled),
#endif
#if USE(APPKIT)
            enumValueForIPCTestAPI(WebKit::TextCheckerState::AutomaticLinkDetectionEnabled),
#endif
        } },
        { "WebCore::FontOrientation"_s, sizeof(WebCore::FontOrientation), false, {
            0, 1
        } },
        { "WebCore::NonCJKGlyphOrientation"_s, sizeof(WebCore::NonCJKGlyphOrientation), false, {
            0, 1
        } },
        { "WebCore::FontVariantNumericOrdinal"_s, sizeof(WebCore::FontVariantNumericOrdinal), false, {
            0, 1
        } },
        { "WebCore::FontVariantNumericSlashedZero"_s, sizeof(WebCore::FontVariantNumericSlashedZero), false, {
            0, 1
        } },
        { "WebCore::FontSynthesisLonghandValue"_s, sizeof(WebCore::FontSynthesisLonghandValue), false, {
            0, 1
        } },
        { "WebCore::FontSmallCaps"_s, sizeof(WebCore::FontSmallCaps), false, {
            0, 1
        } },
#if ENABLE(IMAGE_ANALYSIS)
        { "WebKit::TextRecognitionUpdateResult"_s, sizeof(WebKit::TextRecognitionUpdateResult), false, {
            enumValueForIPCTestAPI(WebKit::TextRecognitionUpdateResult::NoText),
            enumValueForIPCTestAPI(WebKit::TextRecognitionUpdateResult::Text),
            enumValueForIPCTestAPI(WebKit::TextRecognitionUpdateResult::DataDetector),
        } },
#endif
        { "WebKit::UndoOrRedo"_s, sizeof(WebKit::UndoOrRedo), false, {
            0, 1
        } },
#if ENABLE(UI_SIDE_COMPOSITING)
        { "WebKit::ViewStabilityFlag"_s, sizeof(WebKit::ViewStabilityFlag), true, {
            enumValueForIPCTestAPI(WebKit::ViewStabilityFlag::ScrollViewInteracting),
            enumValueForIPCTestAPI(WebKit::ViewStabilityFlag::ScrollViewAnimatedScrollOrZoom),
            enumValueForIPCTestAPI(WebKit::ViewStabilityFlag::ScrollViewRubberBanding),
            enumValueForIPCTestAPI(WebKit::ViewStabilityFlag::ChangingObscuredInsetsInteractively),
            enumValueForIPCTestAPI(WebKit::ViewStabilityFlag::UnstableForTesting),
        } },
#endif
        { "WTF::SystemMemoryPressureStatus"_s, sizeof(WTF::SystemMemoryPressureStatus), false, {
            enumValueForIPCTestAPI(WTF::SystemMemoryPressureStatus::Normal),
            enumValueForIPCTestAPI(WTF::SystemMemoryPressureStatus::Warning),
            enumValueForIPCTestAPI(WTF::SystemMemoryPressureStatus::Critical),
        } },
        { "WTFLogLevel"_s, sizeof(WTFLogLevel), false, {
            enumValueForIPCTestAPI(WTFLogLevel::Always),
            enumValueForIPCTestAPI(WTFLogLevel::Error),
            enumValueForIPCTestAPI(WTFLogLevel::Warning),
            enumValueForIPCTestAPI(WTFLogLevel::Info),
            enumValueForIPCTestAPI(WTFLogLevel::Debug),
        } },
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayFeature"_s, sizeof(WebCore::ApplePayFeature), false, {
#if ENABLE(APPLE_PAY_LATER)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::ApplePayLater),
#endif
#if ENABLE(APPLE_PAY_LATER_AVAILABILITY)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::ApplePayLaterAvailability),
#endif
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::AuthorizationResultOrderDetails),
#endif
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::LineItemPaymentTiming),
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::PaymentRequestAutomaticReload),
#endif
#if ENABLE(APPLE_PAY_COUPON_CODE)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::PaymentRequestCouponCode),
#endif
#if ENABLE(APPLE_PAY_MERCHANT_CATEGORY_CODE)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::PaymentRequestMerchantCategoryCode),
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::PaymentRequestMultiTokenContexts),
#endif
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::PaymentRequestRecurring),
#endif
#if ENABLE(APPLE_PAY_SHIPPING_CONTACT_EDITING_MODE)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::PaymentRequestShippingContactEditingMode),
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::PaymentTimingAutomaticReload),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::PaymentRequestDeferred),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::PaymentTimingDeferred),
#endif
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::PaymentTimingImmediate),
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::PaymentTimingRecurring),
#endif
#if ENABLE(APPLE_PAY_SHIPPING_CONTACT_EDITING_MODE)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::ShippingContactEditingModeEnabled),
#endif
#if ENABLE(APPLE_PAY_SHIPPING_CONTACT_EDITING_MODE)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::ShippingContactEditingModeStorePickup),
#endif
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::ShippingMethodDateComponentsRange),
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
            enumValueForIPCTestAPI(WebCore::ApplePayFeature::PaymentRequestDisbursements),
#endif
        } },
#endif
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayPaymentTiming"_s, sizeof(WebCore::ApplePayPaymentTiming), false, {
            enumValueForIPCTestAPI(WebCore::ApplePayPaymentTiming::Immediate),
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
            enumValueForIPCTestAPI(WebCore::ApplePayPaymentTiming::Recurring),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
            enumValueForIPCTestAPI(WebCore::ApplePayPaymentTiming::Deferred),
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
            enumValueForIPCTestAPI(WebCore::ApplePayPaymentTiming::AutomaticReload),
#endif
        } },
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        { "WebCore::ApplePayRecurringPaymentDateUnit"_s, sizeof(WebCore::ApplePayRecurringPaymentDateUnit), false, {
            enumValueForIPCTestAPI(WebCore::ApplePayRecurringPaymentDateUnit::Year),
            enumValueForIPCTestAPI(WebCore::ApplePayRecurringPaymentDateUnit::Month),
            enumValueForIPCTestAPI(WebCore::ApplePayRecurringPaymentDateUnit::Day),
            enumValueForIPCTestAPI(WebCore::ApplePayRecurringPaymentDateUnit::Hour),
            enumValueForIPCTestAPI(WebCore::ApplePayRecurringPaymentDateUnit::Minute),
        } },
#endif
        { "WebCore::ContactProperty"_s, sizeof(WebCore::ContactProperty), false, {
            enumValueForIPCTestAPI(WebCore::ContactProperty::Email),
            enumValueForIPCTestAPI(WebCore::ContactProperty::Name),
            enumValueForIPCTestAPI(WebCore::ContactProperty::Tel),
        } },
        { "WebCore::CookieConsentDecisionResult"_s, sizeof(WebCore::CookieConsentDecisionResult), false, {
            enumValueForIPCTestAPI(WebCore::CookieConsentDecisionResult::NotSupported),
            enumValueForIPCTestAPI(WebCore::CookieConsentDecisionResult::Consent),
            enumValueForIPCTestAPI(WebCore::CookieConsentDecisionResult::Dissent),
        } },
        { "WebCore::IDBResultType"_s, sizeof(WebCore::IDBResultType), false, {
            enumValueForIPCTestAPI(WebCore::IDBResultType::Error),
            enumValueForIPCTestAPI(WebCore::IDBResultType::OpenDatabaseSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::OpenDatabaseUpgradeNeeded),
            enumValueForIPCTestAPI(WebCore::IDBResultType::DeleteDatabaseSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::CreateObjectStoreSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::DeleteObjectStoreSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::ClearObjectStoreSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::PutOrAddSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::GetRecordSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::GetAllRecordsSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::GetCountSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::DeleteRecordSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::CreateIndexSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::DeleteIndexSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::OpenCursorSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::IterateCursorSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::RenameObjectStoreSuccess),
            enumValueForIPCTestAPI(WebCore::IDBResultType::RenameIndexSuccess),
        } },
        { "WebCore::IDBTransactionDurability"_s, sizeof(WebCore::IDBTransactionDurability), false, {
            enumValueForIPCTestAPI(WebCore::IDBTransactionDurability::Strict),
            enumValueForIPCTestAPI(WebCore::IDBTransactionDurability::Relaxed),
            enumValueForIPCTestAPI(WebCore::IDBTransactionDurability::Default),
        } },
        { "WebCore::IDBTransactionMode"_s, sizeof(WebCore::IDBTransactionMode), false, {
            enumValueForIPCTestAPI(WebCore::IDBTransactionMode::Readonly),
            enumValueForIPCTestAPI(WebCore::IDBTransactionMode::Readwrite),
            enumValueForIPCTestAPI(WebCore::IDBTransactionMode::Versionchange),
        } },
#if ENABLE(MEDIA_SESSION)
        { "WebCore::MediaSessionAction"_s, sizeof(WebCore::MediaSessionAction), false, {
            enumValueForIPCTestAPI(WebCore::MediaSessionAction::Play),
            enumValueForIPCTestAPI(WebCore::MediaSessionAction::Pause),
            enumValueForIPCTestAPI(WebCore::MediaSessionAction::Seekbackward),
            enumValueForIPCTestAPI(WebCore::MediaSessionAction::Seekforward),
            enumValueForIPCTestAPI(WebCore::MediaSessionAction::Previoustrack),
            enumValueForIPCTestAPI(WebCore::MediaSessionAction::Nexttrack),
            enumValueForIPCTestAPI(WebCore::MediaSessionAction::Skipad),
            enumValueForIPCTestAPI(WebCore::MediaSessionAction::Stop),
            enumValueForIPCTestAPI(WebCore::MediaSessionAction::Seekto),
            enumValueForIPCTestAPI(WebCore::MediaSessionAction::Settrack),
        } },
#endif
#if ENABLE(MEDIA_SESSION)
        { "WebCore::MediaSessionPlaybackState"_s, sizeof(WebCore::MediaSessionPlaybackState), false, {
            enumValueForIPCTestAPI(WebCore::MediaSessionPlaybackState::None),
            enumValueForIPCTestAPI(WebCore::MediaSessionPlaybackState::Paused),
            enumValueForIPCTestAPI(WebCore::MediaSessionPlaybackState::Playing),
        } },
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
        { "WebCore::MediaSessionCoordinatorState"_s, sizeof(WebCore::MediaSessionCoordinatorState), false, {
            enumValueForIPCTestAPI(WebCore::MediaSessionCoordinatorState::Waiting),
            enumValueForIPCTestAPI(WebCore::MediaSessionCoordinatorState::Joined),
            enumValueForIPCTestAPI(WebCore::MediaSessionCoordinatorState::Closed),
        } },
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
        { "WebCore::MediaSessionReadyState"_s, sizeof(WebCore::MediaSessionReadyState), false, {
            enumValueForIPCTestAPI(WebCore::MediaSessionReadyState::Havenothing),
            enumValueForIPCTestAPI(WebCore::MediaSessionReadyState::Havemetadata),
            enumValueForIPCTestAPI(WebCore::MediaSessionReadyState::Havecurrentdata),
            enumValueForIPCTestAPI(WebCore::MediaSessionReadyState::Havefuturedata),
            enumValueForIPCTestAPI(WebCore::MediaSessionReadyState::Haveenoughdata),
        } },
#endif
        { "WebCore::RTCErrorDetailType"_s, sizeof(WebCore::RTCErrorDetailType), false, {
            enumValueForIPCTestAPI(WebCore::RTCErrorDetailType::DataChannelFailure),
            enumValueForIPCTestAPI(WebCore::RTCErrorDetailType::DtlsFailure),
            enumValueForIPCTestAPI(WebCore::RTCErrorDetailType::FingerprintFailure),
            enumValueForIPCTestAPI(WebCore::RTCErrorDetailType::SctpFailure),
            enumValueForIPCTestAPI(WebCore::RTCErrorDetailType::SdpSyntaxError),
        } },
        { "WebCore::NotificationEventType"_s, sizeof(WebCore::NotificationEventType), false, {
            0, 1
        } },
        { "WebCore::PermissionName"_s, sizeof(WebCore::PermissionName), false, {
            enumValueForIPCTestAPI(WebCore::PermissionName::Accelerometer),
            enumValueForIPCTestAPI(WebCore::PermissionName::BackgroundFetch),
            enumValueForIPCTestAPI(WebCore::PermissionName::Bluetooth),
            enumValueForIPCTestAPI(WebCore::PermissionName::Camera),
            enumValueForIPCTestAPI(WebCore::PermissionName::DisplayCapture),
            enumValueForIPCTestAPI(WebCore::PermissionName::Geolocation),
            enumValueForIPCTestAPI(WebCore::PermissionName::Gyroscope),
            enumValueForIPCTestAPI(WebCore::PermissionName::Magnetometer),
            enumValueForIPCTestAPI(WebCore::PermissionName::Microphone),
            enumValueForIPCTestAPI(WebCore::PermissionName::Midi),
            enumValueForIPCTestAPI(WebCore::PermissionName::Nfc),
            enumValueForIPCTestAPI(WebCore::PermissionName::Notifications),
            enumValueForIPCTestAPI(WebCore::PermissionName::Push),
            enumValueForIPCTestAPI(WebCore::PermissionName::ScreenWakeLock),
            enumValueForIPCTestAPI(WebCore::PermissionName::SpeakerSelection),
        } },
        { "WebCore::PermissionQuerySource"_s, sizeof(WebCore::PermissionQuerySource), false, {
            enumValueForIPCTestAPI(WebCore::PermissionQuerySource::Window),
            enumValueForIPCTestAPI(WebCore::PermissionQuerySource::DedicatedWorker),
            enumValueForIPCTestAPI(WebCore::PermissionQuerySource::SharedWorker),
            enumValueForIPCTestAPI(WebCore::PermissionQuerySource::ServiceWorker),
        } },
        { "WebCore::PermissionState"_s, sizeof(WebCore::PermissionState), false, {
            enumValueForIPCTestAPI(WebCore::PermissionState::Granted),
            enumValueForIPCTestAPI(WebCore::PermissionState::Denied),
            enumValueForIPCTestAPI(WebCore::PermissionState::Prompt),
        } },
        { "WebCore::PushPermissionState"_s, sizeof(WebCore::PushPermissionState), false, {
            enumValueForIPCTestAPI(WebCore::PushPermissionState::Denied),
            enumValueForIPCTestAPI(WebCore::PushPermissionState::Granted),
            enumValueForIPCTestAPI(WebCore::PushPermissionState::Prompt),
        } },
        { "WebCore::AutofillFieldName"_s, sizeof(WebCore::AutofillFieldName), false, {
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::None),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::Name),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::HonorificPrefix),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::GivenName),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::AdditionalName),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::FamilyName),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::HonorificSuffix),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::Nickname),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::Username),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::NewPassword),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::CurrentPassword),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::OrganizationTitle),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::Organization),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::StreetAddress),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::AddressLine1),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::AddressLine2),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::AddressLine3),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::AddressLevel4),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::AddressLevel3),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::AddressLevel2),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::AddressLevel1),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::Country),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::CountryName),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::PostalCode),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::CcName),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::CcGivenName),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::CcAdditionalName),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::CcFamilyName),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::CcNumber),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::CcExp),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::CcExpMonth),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::CcExpYear),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::CcCsc),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::CcType),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::TransactionCurrency),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::TransactionAmount),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::Language),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::Bday),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::BdayDay),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::BdayMonth),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::BdayYear),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::Sex),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::URL),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::Photo),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::Tel),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::TelCountryCode),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::TelNational),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::TelAreaCode),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::TelLocal),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::TelLocalPrefix),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::TelLocalSuffix),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::TelExtension),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::Email),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::Impp),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::WebAuthn),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::OneTimeCode),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::DeviceEID),
            enumValueForIPCTestAPI(WebCore::AutofillFieldName::DeviceIMEI),
        } },
        { "WebCore::NonAutofillCredentialType"_s, sizeof(WebCore::NonAutofillCredentialType), false, {
            0, 1
        } },
        { "WebCore::EnterKeyHint"_s, sizeof(WebCore::EnterKeyHint), false, {
            enumValueForIPCTestAPI(WebCore::EnterKeyHint::Unspecified),
            enumValueForIPCTestAPI(WebCore::EnterKeyHint::Enter),
            enumValueForIPCTestAPI(WebCore::EnterKeyHint::Done),
            enumValueForIPCTestAPI(WebCore::EnterKeyHint::Go),
            enumValueForIPCTestAPI(WebCore::EnterKeyHint::Next),
            enumValueForIPCTestAPI(WebCore::EnterKeyHint::Previous),
            enumValueForIPCTestAPI(WebCore::EnterKeyHint::Search),
            enumValueForIPCTestAPI(WebCore::EnterKeyHint::Send),
        } },
        { "WebCore::DownloadableBinaryFontTrustedTypes"_s, sizeof(WebCore::DownloadableBinaryFontTrustedTypes), false, {
            enumValueForIPCTestAPI(WebCore::DownloadableBinaryFontTrustedTypes::Any),
            enumValueForIPCTestAPI(WebCore::DownloadableBinaryFontTrustedTypes::Restricted),
            enumValueForIPCTestAPI(WebCore::DownloadableBinaryFontTrustedTypes::None),
        } },
        { "WebCore::LoadSchedulingMode"_s, sizeof(WebCore::LoadSchedulingMode), false, {
            enumValueForIPCTestAPI(WebCore::LoadSchedulingMode::Direct),
            enumValueForIPCTestAPI(WebCore::LoadSchedulingMode::Prioritized),
        } },
        { "WebCore::ServiceWorkersMode"_s, sizeof(WebCore::ServiceWorkersMode), false, {
            enumValueForIPCTestAPI(WebCore::ServiceWorkersMode::All),
            enumValueForIPCTestAPI(WebCore::ServiceWorkersMode::None),
            enumValueForIPCTestAPI(WebCore::ServiceWorkersMode::Only),
        } },
        { "WebCore::ShouldTreatAsContinuingLoad"_s, sizeof(WebCore::ShouldTreatAsContinuingLoad), false, {
            enumValueForIPCTestAPI(WebCore::ShouldTreatAsContinuingLoad::No),
            enumValueForIPCTestAPI(WebCore::ShouldTreatAsContinuingLoad::YesAfterNavigationPolicyDecision),
            enumValueForIPCTestAPI(WebCore::ShouldTreatAsContinuingLoad::YesAfterProvisionalLoadStarted),
        } },
        { "WebCore::ContentSecurityPolicyModeForExtension"_s, sizeof(WebCore::ContentSecurityPolicyModeForExtension), false, {
            enumValueForIPCTestAPI(WebCore::ContentSecurityPolicyModeForExtension::None),
            enumValueForIPCTestAPI(WebCore::ContentSecurityPolicyModeForExtension::ManifestV2),
            enumValueForIPCTestAPI(WebCore::ContentSecurityPolicyModeForExtension::ManifestV3),
        } },
        { "WebCore::MediaProducerMediaCaptureKind"_s, sizeof(WebCore::MediaProducerMediaCaptureKind), false, {
            enumValueForIPCTestAPI(WebCore::MediaProducerMediaCaptureKind::Microphone),
            enumValueForIPCTestAPI(WebCore::MediaProducerMediaCaptureKind::Camera),
            enumValueForIPCTestAPI(WebCore::MediaProducerMediaCaptureKind::Display),
            enumValueForIPCTestAPI(WebCore::MediaProducerMediaCaptureKind::SystemAudio),
            enumValueForIPCTestAPI(WebCore::MediaProducerMediaCaptureKind::EveryKind),
        } },
        { "WebCore::ScreenOrientationType"_s, sizeof(WebCore::ScreenOrientationType), false, {
            enumValueForIPCTestAPI(WebCore::ScreenOrientationType::PortraitPrimary),
            enumValueForIPCTestAPI(WebCore::ScreenOrientationType::PortraitSecondary),
            enumValueForIPCTestAPI(WebCore::ScreenOrientationType::LandscapePrimary),
            enumValueForIPCTestAPI(WebCore::ScreenOrientationType::LandscapeSecondary),
        } },
        { "WebCore::StorageBlockingPolicy"_s, sizeof(WebCore::StorageBlockingPolicy), false, {
            enumValueForIPCTestAPI(WebCore::StorageBlockingPolicy::AllowAll),
            enumValueForIPCTestAPI(WebCore::StorageBlockingPolicy::BlockThirdParty),
            enumValueForIPCTestAPI(WebCore::StorageBlockingPolicy::BlockAll),
        } },
        { "WebCore::HTTPSByDefaultMode"_s, sizeof(WebCore::HTTPSByDefaultMode), false, {
            enumValueForIPCTestAPI(WebCore::HTTPSByDefaultMode::Disabled),
            enumValueForIPCTestAPI(WebCore::HTTPSByDefaultMode::UpgradeWithAutomaticFallback),
            enumValueForIPCTestAPI(WebCore::HTTPSByDefaultMode::UpgradeWithUserMediatedFallback),
            enumValueForIPCTestAPI(WebCore::HTTPSByDefaultMode::UpgradeAndNoFallback),
        } },
#if HAVE(TRANSLATION_UI_SERVICES) && ENABLE(CONTEXT_MENUS)
        { "WebCore::TranslationContextMenuMode"_s, sizeof(WebCore::TranslationContextMenuMode), false, {
            0, 1
        } },
#endif
#if HAVE(TRANSLATION_UI_SERVICES) && ENABLE(CONTEXT_MENUS)
        { "WebCore::TranslationContextMenuSource"_s, sizeof(WebCore::TranslationContextMenuSource), false, {
            0, 1
        } },
#endif
#if USE(APPKIT)
        { "WebCore::AppKitControlSystemImageType"_s, sizeof(WebCore::AppKitControlSystemImageType), false, {
            enumValueForIPCTestAPI(WebCore::AppKitControlSystemImageType::ScrollbarTrackCorner),
        } },
#endif
        { "WebCore::ScrollIsAnimated"_s, sizeof(WebCore::ScrollIsAnimated), false, {
            0, 1
        } },
        { "WebCore::ScrollGranularity"_s, sizeof(WebCore::ScrollGranularity), false, {
            enumValueForIPCTestAPI(WebCore::ScrollGranularity::Line),
            enumValueForIPCTestAPI(WebCore::ScrollGranularity::Page),
            enumValueForIPCTestAPI(WebCore::ScrollGranularity::Document),
            enumValueForIPCTestAPI(WebCore::ScrollGranularity::Pixel),
        } },
        { "WebCore::IDBGetRecordDataType"_s, sizeof(WebCore::IDBGetRecordDataType), false, {
            0, 1
        } },
        { "WebCore::IndexedDB::KeyType"_s, sizeof(WebCore::IndexedDB::KeyType), false, {
            enumValueForIPCTestAPI(WebCore::IndexedDB::KeyType::Max),
            enumValueForIPCTestAPI(WebCore::IndexedDB::KeyType::Invalid),
            enumValueForIPCTestAPI(WebCore::IndexedDB::KeyType::Array),
            enumValueForIPCTestAPI(WebCore::IndexedDB::KeyType::Binary),
            enumValueForIPCTestAPI(WebCore::IndexedDB::KeyType::String),
            enumValueForIPCTestAPI(WebCore::IndexedDB::KeyType::Date),
            enumValueForIPCTestAPI(WebCore::IndexedDB::KeyType::Number),
            enumValueForIPCTestAPI(WebCore::IndexedDB::KeyType::Min),
        } },
        { "WebCore::IndexedDB::CursorDirection"_s, sizeof(WebCore::IndexedDB::CursorDirection), false, {
            enumValueForIPCTestAPI(WebCore::IndexedDB::CursorDirection::Next),
            enumValueForIPCTestAPI(WebCore::IndexedDB::CursorDirection::Nextunique),
            enumValueForIPCTestAPI(WebCore::IndexedDB::CursorDirection::Prev),
            enumValueForIPCTestAPI(WebCore::IndexedDB::CursorDirection::Prevunique),
        } },
        { "WebCore::IndexedDB::ObjectStoreOverwriteMode"_s, sizeof(WebCore::IndexedDB::ObjectStoreOverwriteMode), false, {
            enumValueForIPCTestAPI(WebCore::IndexedDB::ObjectStoreOverwriteMode::Overwrite),
            enumValueForIPCTestAPI(WebCore::IndexedDB::ObjectStoreOverwriteMode::OverwriteForCursor),
            enumValueForIPCTestAPI(WebCore::IndexedDB::ObjectStoreOverwriteMode::NoOverwrite),
        } },
        { "WebCore::IndexedDB::RequestType"_s, sizeof(WebCore::IndexedDB::RequestType), false, {
            enumValueForIPCTestAPI(WebCore::IndexedDB::RequestType::Open),
            enumValueForIPCTestAPI(WebCore::IndexedDB::RequestType::Delete),
            enumValueForIPCTestAPI(WebCore::IndexedDB::RequestType::Other),
        } },
        { "WebCore::CubicBezierTimingFunction::TimingFunctionPreset"_s, sizeof(WebCore::CubicBezierTimingFunction::TimingFunctionPreset), false, {
            enumValueForIPCTestAPI(WebCore::CubicBezierTimingFunction::TimingFunctionPreset::Ease),
            enumValueForIPCTestAPI(WebCore::CubicBezierTimingFunction::TimingFunctionPreset::EaseIn),
            enumValueForIPCTestAPI(WebCore::CubicBezierTimingFunction::TimingFunctionPreset::EaseOut),
            enumValueForIPCTestAPI(WebCore::CubicBezierTimingFunction::TimingFunctionPreset::EaseInOut),
            enumValueForIPCTestAPI(WebCore::CubicBezierTimingFunction::TimingFunctionPreset::Custom),
        } },
        { "WebCore::StepsTimingFunction::StepPosition"_s, sizeof(WebCore::StepsTimingFunction::StepPosition), false, {
            enumValueForIPCTestAPI(WebCore::StepsTimingFunction::StepPosition::JumpStart),
            enumValueForIPCTestAPI(WebCore::StepsTimingFunction::StepPosition::JumpEnd),
            enumValueForIPCTestAPI(WebCore::StepsTimingFunction::StepPosition::JumpNone),
            enumValueForIPCTestAPI(WebCore::StepsTimingFunction::StepPosition::JumpBoth),
            enumValueForIPCTestAPI(WebCore::StepsTimingFunction::StepPosition::Start),
            enumValueForIPCTestAPI(WebCore::StepsTimingFunction::StepPosition::End),
        } },
        { "WebCore::NavigatorAPIsAccessed"_s, sizeof(WebCore::NavigatorAPIsAccessed), true, {
            enumValueForIPCTestAPI(WebCore::NavigatorAPIsAccessed::AppVersion),
            enumValueForIPCTestAPI(WebCore::NavigatorAPIsAccessed::UserAgent),
            enumValueForIPCTestAPI(WebCore::NavigatorAPIsAccessed::Plugins),
            enumValueForIPCTestAPI(WebCore::NavigatorAPIsAccessed::MimeTypes),
            enumValueForIPCTestAPI(WebCore::NavigatorAPIsAccessed::CookieEnabled),
        } },
        { "WebCore::ScreenAPIsAccessed"_s, sizeof(WebCore::ScreenAPIsAccessed), true, {
            enumValueForIPCTestAPI(WebCore::ScreenAPIsAccessed::Height),
            enumValueForIPCTestAPI(WebCore::ScreenAPIsAccessed::Width),
            enumValueForIPCTestAPI(WebCore::ScreenAPIsAccessed::ColorDepth),
            enumValueForIPCTestAPI(WebCore::ScreenAPIsAccessed::AvailLeft),
            enumValueForIPCTestAPI(WebCore::ScreenAPIsAccessed::AvailTop),
            enumValueForIPCTestAPI(WebCore::ScreenAPIsAccessed::AvailHeight),
            enumValueForIPCTestAPI(WebCore::ScreenAPIsAccessed::AvailWidth),
        } },
        { "WebCore::SandboxFlag"_s, sizeof(WebCore::SandboxFlag), true, {
            enumValueForIPCTestAPI(WebCore::SandboxFlag::Navigation),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::Plugins),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::Origin),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::Forms),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::Scripts),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::TopNavigation),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::Popups),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::AutomaticFeatures),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::PointerLock),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::PropagatesToAuxiliaryBrowsingContexts),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::TopNavigationByUserActivation),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::DocumentDomain),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::Modals),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::StorageAccessByUserActivation),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::TopNavigationToCustomProtocols),
            enumValueForIPCTestAPI(WebCore::SandboxFlag::Downloads),
        } },
        { "WebCore::ViewportFit"_s, sizeof(WebCore::ViewportFit), false, {
            enumValueForIPCTestAPI(WebCore::ViewportFit::Auto),
            enumValueForIPCTestAPI(WebCore::ViewportFit::Contain),
            enumValueForIPCTestAPI(WebCore::ViewportFit::Cover),
        } },
        { "WebCore::InteractiveWidget"_s, sizeof(WebCore::InteractiveWidget), false, {
            enumValueForIPCTestAPI(WebCore::InteractiveWidget::ResizesVisual),
            enumValueForIPCTestAPI(WebCore::InteractiveWidget::ResizesContent),
            enumValueForIPCTestAPI(WebCore::InteractiveWidget::OverlaysContent),
        } },
        { "WebCore::ShareDataOriginator"_s, sizeof(WebCore::ShareDataOriginator), false, {
            0, 1
        } },
        { "WebCore::PositionType"_s, sizeof(WebCore::PositionType), false, {
            enumValueForIPCTestAPI(WebCore::PositionType::Static),
            enumValueForIPCTestAPI(WebCore::PositionType::Relative),
            enumValueForIPCTestAPI(WebCore::PositionType::Absolute),
            enumValueForIPCTestAPI(WebCore::PositionType::Sticky),
            enumValueForIPCTestAPI(WebCore::PositionType::Fixed),
        } },
        { "WebCore::PCM::AttributionEphemeral"_s, sizeof(WebCore::PCM::AttributionEphemeral), false, {
            0, 1
        } },
        { "WebCore::PCM::WasSent"_s, sizeof(WebCore::PCM::WasSent), false, {
            0, 1
        } },
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayLineItem::Type"_s, sizeof(WebCore::ApplePayLineItem::Type), false, {
            0, 1
        } },
#endif
#if (ENABLE(APPLE_PAY)) && (ENABLE(APPLE_PAY_DISBURSEMENTS))
        { "WebCore::ApplePayLineItem::DisbursementLineItemType"_s, sizeof(WebCore::ApplePayLineItem::DisbursementLineItemType), false, {
            enumValueForIPCTestAPI(WebCore::ApplePayLineItem::DisbursementLineItemType::Disbursement),
            enumValueForIPCTestAPI(WebCore::ApplePayLineItem::DisbursementLineItemType::InstantFundsOutFee),
        } },
#endif
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayError::Domain"_s, sizeof(WebCore::ApplePayError::Domain), false, {
            enumValueForIPCTestAPI(WebCore::ApplePayError::Domain::Disbursement),
        } },
#endif
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayLogoStyle"_s, sizeof(WebCore::ApplePayLogoStyle), false, {
            0, 1
        } },
#endif
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayErrorContactField"_s, sizeof(WebCore::ApplePayErrorContactField), false, {
            enumValueForIPCTestAPI(WebCore::ApplePayErrorContactField::PhoneNumber),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorContactField::EmailAddress),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorContactField::Name),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorContactField::PhoneticName),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorContactField::PostalAddress),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorContactField::AddressLines),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorContactField::SubLocality),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorContactField::Locality),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorContactField::PostalCode),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorContactField::SubAdministrativeArea),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorContactField::AdministrativeArea),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorContactField::Country),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorContactField::CountryCode),
        } },
#endif
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayContactField"_s, sizeof(WebCore::ApplePayContactField), false, {
            enumValueForIPCTestAPI(WebCore::ApplePayContactField::Email),
            enumValueForIPCTestAPI(WebCore::ApplePayContactField::Name),
            enumValueForIPCTestAPI(WebCore::ApplePayContactField::PhoneticName),
            enumValueForIPCTestAPI(WebCore::ApplePayContactField::Phone),
            enumValueForIPCTestAPI(WebCore::ApplePayContactField::PostalAddress),
        } },
#endif
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayErrorCode"_s, sizeof(WebCore::ApplePayErrorCode), false, {
            enumValueForIPCTestAPI(WebCore::ApplePayErrorCode::Unknown),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorCode::ShippingContactInvalid),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorCode::BillingContactInvalid),
            enumValueForIPCTestAPI(WebCore::ApplePayErrorCode::AddressUnserviceable),
#if ENABLE(APPLE_PAY_COUPON_CODE)
            enumValueForIPCTestAPI(WebCore::ApplePayErrorCode::CouponCodeInvalid),
#endif
#if ENABLE(APPLE_PAY_COUPON_CODE)
            enumValueForIPCTestAPI(WebCore::ApplePayErrorCode::CouponCodeExpired),
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
            enumValueForIPCTestAPI(WebCore::ApplePayErrorCode::UnsupportedCard),
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
            enumValueForIPCTestAPI(WebCore::ApplePayErrorCode::RecipientContactInvalid),
#endif
        } },
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
        { "WebCore::ApplePaySetupFeatureType"_s, sizeof(WebCore::ApplePaySetupFeatureType), false, {
            0, 1
        } },
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
        { "WebCore::ApplePayInstallmentItemType"_s, sizeof(WebCore::ApplePayInstallmentItemType), false, {
            enumValueForIPCTestAPI(WebCore::ApplePayInstallmentItemType::Generic),
            enumValueForIPCTestAPI(WebCore::ApplePayInstallmentItemType::Phone),
            enumValueForIPCTestAPI(WebCore::ApplePayInstallmentItemType::Pad),
            enumValueForIPCTestAPI(WebCore::ApplePayInstallmentItemType::Watch),
            enumValueForIPCTestAPI(WebCore::ApplePayInstallmentItemType::Mac),
        } },
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
        { "WebCore::ApplePayInstallmentRetailChannel"_s, sizeof(WebCore::ApplePayInstallmentRetailChannel), false, {
            enumValueForIPCTestAPI(WebCore::ApplePayInstallmentRetailChannel::Unknown),
            enumValueForIPCTestAPI(WebCore::ApplePayInstallmentRetailChannel::App),
            enumValueForIPCTestAPI(WebCore::ApplePayInstallmentRetailChannel::Web),
            enumValueForIPCTestAPI(WebCore::ApplePayInstallmentRetailChannel::InStore),
        } },
#endif
        { "WebCore::ScreenOrientationLockType"_s, sizeof(WebCore::ScreenOrientationLockType), false, {
            enumValueForIPCTestAPI(WebCore::ScreenOrientationLockType::Any),
            enumValueForIPCTestAPI(WebCore::ScreenOrientationLockType::Natural),
            enumValueForIPCTestAPI(WebCore::ScreenOrientationLockType::Landscape),
            enumValueForIPCTestAPI(WebCore::ScreenOrientationLockType::Portrait),
            enumValueForIPCTestAPI(WebCore::ScreenOrientationLockType::PortraitPrimary),
            enumValueForIPCTestAPI(WebCore::ScreenOrientationLockType::PortraitSecondary),
            enumValueForIPCTestAPI(WebCore::ScreenOrientationLockType::LandscapePrimary),
            enumValueForIPCTestAPI(WebCore::ScreenOrientationLockType::LandscapeSecondary),
        } },
#if ENABLE(APPLICATION_MANIFEST)
        { "WebCore::ApplicationManifest::Direction"_s, sizeof(WebCore::ApplicationManifest::Direction), false, {
            enumValueForIPCTestAPI(WebCore::ApplicationManifest::Direction::Auto),
            enumValueForIPCTestAPI(WebCore::ApplicationManifest::Direction::LTR),
            enumValueForIPCTestAPI(WebCore::ApplicationManifest::Direction::RTL),
        } },
#endif
#if ENABLE(APPLICATION_MANIFEST)
        { "WebCore::ApplicationManifest::Display"_s, sizeof(WebCore::ApplicationManifest::Display), false, {
            enumValueForIPCTestAPI(WebCore::ApplicationManifest::Display::Browser),
            enumValueForIPCTestAPI(WebCore::ApplicationManifest::Display::MinimalUI),
            enumValueForIPCTestAPI(WebCore::ApplicationManifest::Display::Standalone),
            enumValueForIPCTestAPI(WebCore::ApplicationManifest::Display::Fullscreen),
        } },
#endif
#if ENABLE(APPLICATION_MANIFEST)
        { "WebCore::ApplicationManifest::Icon::Purpose"_s, sizeof(WebCore::ApplicationManifest::Icon::Purpose), true, {
            enumValueForIPCTestAPI(WebCore::ApplicationManifest::Icon::Purpose::Any),
            enumValueForIPCTestAPI(WebCore::ApplicationManifest::Icon::Purpose::Monochrome),
            enumValueForIPCTestAPI(WebCore::ApplicationManifest::Icon::Purpose::Maskable),
        } },
#endif
        { "WebCore::DOMCacheEngine::Error"_s, sizeof(WebCore::DOMCacheEngine::Error), false, {
            enumValueForIPCTestAPI(WebCore::DOMCacheEngine::Error::NotImplemented),
            enumValueForIPCTestAPI(WebCore::DOMCacheEngine::Error::ReadDisk),
            enumValueForIPCTestAPI(WebCore::DOMCacheEngine::Error::WriteDisk),
            enumValueForIPCTestAPI(WebCore::DOMCacheEngine::Error::QuotaExceeded),
            enumValueForIPCTestAPI(WebCore::DOMCacheEngine::Error::Internal),
            enumValueForIPCTestAPI(WebCore::DOMCacheEngine::Error::Stopped),
            enumValueForIPCTestAPI(WebCore::DOMCacheEngine::Error::CORP),
        } },
#if ENABLE(WEB_CODECS)
        { "WebCore::WebCodecsEncodedVideoChunkType"_s, sizeof(WebCore::WebCodecsEncodedVideoChunkType), false, {
            0, 1
        } },
#endif
#if ENABLE(WEB_CODECS)
        { "WebCore::WebCodecsEncodedAudioChunkType"_s, sizeof(WebCore::WebCodecsEncodedAudioChunkType), false, {
            0, 1
        } },
#endif
        { "WebCore::VideoEncoderScalabilityMode"_s, sizeof(WebCore::VideoEncoderScalabilityMode), false, {
            enumValueForIPCTestAPI(WebCore::VideoEncoderScalabilityMode::L1T1),
            enumValueForIPCTestAPI(WebCore::VideoEncoderScalabilityMode::L1T2),
            enumValueForIPCTestAPI(WebCore::VideoEncoderScalabilityMode::L1T3),
        } },
        { "WebCore::SpeechRecognitionErrorType"_s, sizeof(WebCore::SpeechRecognitionErrorType), false, {
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionErrorType::NoSpeech),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionErrorType::Aborted),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionErrorType::AudioCapture),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionErrorType::Network),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionErrorType::NotAllowed),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionErrorType::ServiceNotAllowed),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionErrorType::BadGrammar),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionErrorType::LanguageNotSupported),
        } },
        { "WebCore::WebLockMode"_s, sizeof(WebCore::WebLockMode), false, {
            0, 1
        } },
#if ENABLE(WEB_AUTHN)
        { "WebCore::AttestationConveyancePreference"_s, sizeof(WebCore::AttestationConveyancePreference), false, {
            enumValueForIPCTestAPI(WebCore::AttestationConveyancePreference::None),
            enumValueForIPCTestAPI(WebCore::AttestationConveyancePreference::Indirect),
            enumValueForIPCTestAPI(WebCore::AttestationConveyancePreference::Direct),
            enumValueForIPCTestAPI(WebCore::AttestationConveyancePreference::Enterprise),
        } },
#endif
        { "WebCore::Cookie::SameSitePolicy"_s, sizeof(WebCore::Cookie::SameSitePolicy), false, {
            enumValueForIPCTestAPI(WebCore::Cookie::SameSitePolicy::None),
            enumValueForIPCTestAPI(WebCore::Cookie::SameSitePolicy::Lax),
            enumValueForIPCTestAPI(WebCore::Cookie::SameSitePolicy::Strict),
        } },
        { "WebCore::ShouldPartitionCookie"_s, sizeof(WebCore::ShouldPartitionCookie), false, {
            0, 1
        } },
        { "WebCore::RenderingMode"_s, sizeof(WebCore::RenderingMode), false, {
            enumValueForIPCTestAPI(WebCore::RenderingMode::Unaccelerated),
            enumValueForIPCTestAPI(WebCore::RenderingMode::Accelerated),
            enumValueForIPCTestAPI(WebCore::RenderingMode::PDFDocument),
            enumValueForIPCTestAPI(WebCore::RenderingMode::DisplayList),
        } },
        { "WebCore::RenderingPurpose"_s, sizeof(WebCore::RenderingPurpose), false, {
            enumValueForIPCTestAPI(WebCore::RenderingPurpose::Unspecified),
            enumValueForIPCTestAPI(WebCore::RenderingPurpose::Canvas),
            enumValueForIPCTestAPI(WebCore::RenderingPurpose::DOM),
            enumValueForIPCTestAPI(WebCore::RenderingPurpose::LayerBacking),
            enumValueForIPCTestAPI(WebCore::RenderingPurpose::Snapshot),
            enumValueForIPCTestAPI(WebCore::RenderingPurpose::ShareableSnapshot),
            enumValueForIPCTestAPI(WebCore::RenderingPurpose::ShareableLocalSnapshot),
            enumValueForIPCTestAPI(WebCore::RenderingPurpose::MediaPainting),
        } },
        { "WebCore::ContentsFormat"_s, sizeof(WebCore::ContentsFormat), false, {
            enumValueForIPCTestAPI(WebCore::ContentsFormat::RGBA8),
#if ENABLE(PIXEL_FORMAT_RGB10)
            enumValueForIPCTestAPI(WebCore::ContentsFormat::RGBA10),
#endif
#if ENABLE(PIXEL_FORMAT_RGBA16F)
            enumValueForIPCTestAPI(WebCore::ContentsFormat::RGBA16F),
#endif
        } },
        { "WebCore::RotationDirection"_s, sizeof(WebCore::RotationDirection), false, {
            0, 1
        } },
#if ENABLE(CONTENT_FILTERING)
        { "WebCore::MockContentFilterSettings::DecisionPoint"_s, sizeof(WebCore::MockContentFilterSettings::DecisionPoint), false, {
            enumValueForIPCTestAPI(WebCore::MockContentFilterSettings::DecisionPoint::AfterWillSendRequest),
            enumValueForIPCTestAPI(WebCore::MockContentFilterSettings::DecisionPoint::AfterRedirect),
            enumValueForIPCTestAPI(WebCore::MockContentFilterSettings::DecisionPoint::AfterResponse),
            enumValueForIPCTestAPI(WebCore::MockContentFilterSettings::DecisionPoint::AfterAddData),
            enumValueForIPCTestAPI(WebCore::MockContentFilterSettings::DecisionPoint::AfterFinishedAddingData),
            enumValueForIPCTestAPI(WebCore::MockContentFilterSettings::DecisionPoint::Never),
        } },
#endif
#if ENABLE(CONTENT_FILTERING)
        { "WebCore::MockContentFilterSettings::Decision"_s, sizeof(WebCore::MockContentFilterSettings::Decision), false, {
            0, 1
        } },
#endif
        { "WebCore::IsLoggedIn"_s, sizeof(WebCore::IsLoggedIn), false, {
            enumValueForIPCTestAPI(WebCore::IsLoggedIn::LoggedOut),
            enumValueForIPCTestAPI(WebCore::IsLoggedIn::LoggedIn),
        } },
        { "WebCore::LoginStatus::CredentialTokenType"_s, sizeof(WebCore::LoginStatus::CredentialTokenType), false, {
            0, 1
        } },
        { "WebCore::LoginStatus::AuthenticationType"_s, sizeof(WebCore::LoginStatus::AuthenticationType), false, {
            enumValueForIPCTestAPI(WebCore::LoginStatus::AuthenticationType::WebAuthn),
            enumValueForIPCTestAPI(WebCore::LoginStatus::AuthenticationType::PasswordManager),
            enumValueForIPCTestAPI(WebCore::LoginStatus::AuthenticationType::Unmanaged),
        } },
        { "WebCore::AutoplayEvent"_s, sizeof(WebCore::AutoplayEvent), false, {
            enumValueForIPCTestAPI(WebCore::AutoplayEvent::DidPreventMediaFromPlaying),
            enumValueForIPCTestAPI(WebCore::AutoplayEvent::DidPlayMediaWithUserGesture),
            enumValueForIPCTestAPI(WebCore::AutoplayEvent::DidAutoplayMediaPastThresholdWithoutUserInterference),
            enumValueForIPCTestAPI(WebCore::AutoplayEvent::UserDidInterfereWithPlayback),
        } },
        { "WebCore::InputMode"_s, sizeof(WebCore::InputMode), false, {
            enumValueForIPCTestAPI(WebCore::InputMode::Unspecified),
            enumValueForIPCTestAPI(WebCore::InputMode::None),
            enumValueForIPCTestAPI(WebCore::InputMode::Text),
            enumValueForIPCTestAPI(WebCore::InputMode::Telephone),
            enumValueForIPCTestAPI(WebCore::InputMode::Url),
            enumValueForIPCTestAPI(WebCore::InputMode::Email),
            enumValueForIPCTestAPI(WebCore::InputMode::Numeric),
            enumValueForIPCTestAPI(WebCore::InputMode::Decimal),
            enumValueForIPCTestAPI(WebCore::InputMode::Search),
        } },
        { "WebCore::IndexedDB::GetAllType"_s, sizeof(WebCore::IndexedDB::GetAllType), false, {
            0, 1
        } },
        { "WebCore::WorkerType"_s, sizeof(WebCore::WorkerType), false, {
            0, 1
        } },
        { "WebCore::StoredCredentialsPolicy"_s, sizeof(WebCore::StoredCredentialsPolicy), false, {
            enumValueForIPCTestAPI(WebCore::StoredCredentialsPolicy::DoNotUse),
            enumValueForIPCTestAPI(WebCore::StoredCredentialsPolicy::Use),
            enumValueForIPCTestAPI(WebCore::StoredCredentialsPolicy::EphemeralStateless),
        } },
        { "WebCore::ContentSniffingPolicy"_s, sizeof(WebCore::ContentSniffingPolicy), false, {
            0, 1
        } },
        { "WebCore::ContentEncodingSniffingPolicy"_s, sizeof(WebCore::ContentEncodingSniffingPolicy), false, {
            0, 1
        } },
        { "WebCore::ClientCredentialPolicy"_s, sizeof(WebCore::ClientCredentialPolicy), false, {
            0, 1
        } },
        { "WebCore::ShouldRelaxThirdPartyCookieBlocking"_s, sizeof(WebCore::ShouldRelaxThirdPartyCookieBlocking), false, {
            0, 1
        } },
        { "WebCore::PreflightPolicy"_s, sizeof(WebCore::PreflightPolicy), false, {
            enumValueForIPCTestAPI(WebCore::PreflightPolicy::Consider),
            enumValueForIPCTestAPI(WebCore::PreflightPolicy::Force),
            enumValueForIPCTestAPI(WebCore::PreflightPolicy::Prevent),
        } },
        { "WTFLogChannelState"_s, sizeof(WTFLogChannelState), false, {
            enumValueForIPCTestAPI(WTFLogChannelState::Off),
            enumValueForIPCTestAPI(WTFLogChannelState::On),
            enumValueForIPCTestAPI(WTFLogChannelState::OnWithAccumulation),
        } },
        { "WebCore::ScrollSnapStrictness"_s, sizeof(WebCore::ScrollSnapStrictness), false, {
            enumValueForIPCTestAPI(WebCore::ScrollSnapStrictness::None),
            enumValueForIPCTestAPI(WebCore::ScrollSnapStrictness::Proximity),
            enumValueForIPCTestAPI(WebCore::ScrollSnapStrictness::Mandatory),
        } },
        { "WebCore::LengthType"_s, sizeof(WebCore::LengthType), false, {
            enumValueForIPCTestAPI(WebCore::LengthType::Auto),
            enumValueForIPCTestAPI(WebCore::LengthType::Normal),
            enumValueForIPCTestAPI(WebCore::LengthType::Relative),
            enumValueForIPCTestAPI(WebCore::LengthType::Percent),
            enumValueForIPCTestAPI(WebCore::LengthType::Fixed),
            enumValueForIPCTestAPI(WebCore::LengthType::Intrinsic),
            enumValueForIPCTestAPI(WebCore::LengthType::MinIntrinsic),
            enumValueForIPCTestAPI(WebCore::LengthType::MinContent),
            enumValueForIPCTestAPI(WebCore::LengthType::MaxContent),
            enumValueForIPCTestAPI(WebCore::LengthType::FillAvailable),
            enumValueForIPCTestAPI(WebCore::LengthType::FitContent),
            enumValueForIPCTestAPI(WebCore::LengthType::Calculated),
            enumValueForIPCTestAPI(WebCore::LengthType::Undefined),
        } },
        { "WebCore::OverscrollBehavior"_s, sizeof(WebCore::OverscrollBehavior), false, {
            enumValueForIPCTestAPI(WebCore::OverscrollBehavior::Auto),
            enumValueForIPCTestAPI(WebCore::OverscrollBehavior::Contain),
            enumValueForIPCTestAPI(WebCore::OverscrollBehavior::None),
        } },
        { "WebCore::ScrollPinningBehavior"_s, sizeof(WebCore::ScrollPinningBehavior), false, {
            enumValueForIPCTestAPI(WebCore::ScrollPinningBehavior::DoNotPin),
            enumValueForIPCTestAPI(WebCore::ScrollPinningBehavior::PinToTop),
            enumValueForIPCTestAPI(WebCore::ScrollPinningBehavior::PinToBottom),
        } },
        { "WebCore::WheelScrollGestureState"_s, sizeof(WebCore::WheelScrollGestureState), false, {
            enumValueForIPCTestAPI(WebCore::WheelScrollGestureState::Blocking),
            enumValueForIPCTestAPI(WebCore::WheelScrollGestureState::NonBlocking),
        } },
#if ENABLE(META_VIEWPORT)
        { "WebCore::ViewportArguments::Type"_s, sizeof(WebCore::ViewportArguments::Type), false, {
            enumValueForIPCTestAPI(WebCore::ViewportArguments::Type::Implicit),
#if PLATFORM(IOS_FAMILY)
            enumValueForIPCTestAPI(WebCore::ViewportArguments::Type::ImageDocument),
#endif
            enumValueForIPCTestAPI(WebCore::ViewportArguments::Type::ViewportMeta),
        } },
#endif
        { "WebCore::DiagnosticLoggingDomain"_s, sizeof(WebCore::DiagnosticLoggingDomain), false, {
            enumValueForIPCTestAPI(WebCore::DiagnosticLoggingDomain::Media),
        } },
#if (!(USE(CG))) && (!(USE(SKIA)))
        { "WebCore::PlatformColorSpace::Name"_s, sizeof(WebCore::PlatformColorSpace::Name), false, {
            enumValueForIPCTestAPI(WebCore::PlatformColorSpace::Name::SRGB),
            enumValueForIPCTestAPI(WebCore::PlatformColorSpace::Name::LinearSRGB),
#if ENABLE(DESTINATION_COLOR_SPACE_DISPLAY_P3)
            enumValueForIPCTestAPI(WebCore::PlatformColorSpace::Name::DisplayP3),
#endif
        } },
#endif
        { "WebCore::CompositionUnderlineColor"_s, sizeof(WebCore::CompositionUnderlineColor), false, {
            0, 1
        } },
        { "WebCore::MediaCaptureType"_s, sizeof(WebCore::MediaCaptureType), false, {
            enumValueForIPCTestAPI(WebCore::MediaCaptureType::MediaCaptureTypeNone),
            enumValueForIPCTestAPI(WebCore::MediaCaptureType::MediaCaptureTypeUser),
            enumValueForIPCTestAPI(WebCore::MediaCaptureType::MediaCaptureTypeEnvironment),
        } },
#if ENABLE(ATTACHMENT_ELEMENT)
        { "WebCore::AttachmentAssociatedElementType"_s, sizeof(WebCore::AttachmentAssociatedElementType), false, {
            enumValueForIPCTestAPI(WebCore::AttachmentAssociatedElementType::None),
            enumValueForIPCTestAPI(WebCore::AttachmentAssociatedElementType::Image),
            enumValueForIPCTestAPI(WebCore::AttachmentAssociatedElementType::Source),
        } },
#endif
        { "WebCore::TextCheckingProcessType"_s, sizeof(WebCore::TextCheckingProcessType), false, {
            0, 1
        } },
        { "WebCore::ColorSpace"_s, sizeof(WebCore::ColorSpace), false, {
            enumValueForIPCTestAPI(WebCore::ColorSpace::A98RGB),
            enumValueForIPCTestAPI(WebCore::ColorSpace::DisplayP3),
            enumValueForIPCTestAPI(WebCore::ColorSpace::ExtendedA98RGB),
            enumValueForIPCTestAPI(WebCore::ColorSpace::ExtendedDisplayP3),
            enumValueForIPCTestAPI(WebCore::ColorSpace::ExtendedLinearSRGB),
            enumValueForIPCTestAPI(WebCore::ColorSpace::ExtendedProPhotoRGB),
            enumValueForIPCTestAPI(WebCore::ColorSpace::ExtendedRec2020),
            enumValueForIPCTestAPI(WebCore::ColorSpace::ExtendedSRGB),
            enumValueForIPCTestAPI(WebCore::ColorSpace::HSL),
            enumValueForIPCTestAPI(WebCore::ColorSpace::HWB),
            enumValueForIPCTestAPI(WebCore::ColorSpace::LCH),
            enumValueForIPCTestAPI(WebCore::ColorSpace::Lab),
            enumValueForIPCTestAPI(WebCore::ColorSpace::LinearSRGB),
            enumValueForIPCTestAPI(WebCore::ColorSpace::OKLCH),
            enumValueForIPCTestAPI(WebCore::ColorSpace::OKLab),
            enumValueForIPCTestAPI(WebCore::ColorSpace::ProPhotoRGB),
            enumValueForIPCTestAPI(WebCore::ColorSpace::Rec2020),
            enumValueForIPCTestAPI(WebCore::ColorSpace::SRGB),
            enumValueForIPCTestAPI(WebCore::ColorSpace::XYZ_D50),
            enumValueForIPCTestAPI(WebCore::ColorSpace::XYZ_D65),
        } },
        { "WebCore::MediaStreamRequest::Type"_s, sizeof(WebCore::MediaStreamRequest::Type), false, {
            enumValueForIPCTestAPI(WebCore::MediaStreamRequest::Type::UserMedia),
            enumValueForIPCTestAPI(WebCore::MediaStreamRequest::Type::DisplayMedia),
            enumValueForIPCTestAPI(WebCore::MediaStreamRequest::Type::DisplayMediaWithAudio),
        } },
        { "WebCore::VideoCodecType"_s, sizeof(WebCore::VideoCodecType), false, {
            enumValueForIPCTestAPI(WebCore::VideoCodecType::H264),
            enumValueForIPCTestAPI(WebCore::VideoCodecType::H265),
            enumValueForIPCTestAPI(WebCore::VideoCodecType::VP9),
            enumValueForIPCTestAPI(WebCore::VideoCodecType::AV1),
        } },
        { "WebCore::NetworkTransactionInformation::Type"_s, sizeof(WebCore::NetworkTransactionInformation::Type), false, {
            0, 1
        } },
#if HAVE(SUPPORT_HDR_DISPLAY)
        { "WebCore::ContentsFormat"_s, sizeof(WebCore::ContentsFormat), true, {
            enumValueForIPCTestAPI(WebCore::ContentsFormat::RGBA8),
#if ENABLE(PIXEL_FORMAT_RGB10)
            enumValueForIPCTestAPI(WebCore::ContentsFormat::RGBA10),
#endif
#if ENABLE(PIXEL_FORMAT_RGBA16F)
            enumValueForIPCTestAPI(WebCore::ContentsFormat::RGBA16F),
#endif
        } },
#endif
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticatorTransport"_s, sizeof(WebCore::AuthenticatorTransport), false, {
            enumValueForIPCTestAPI(WebCore::AuthenticatorTransport::Usb),
            enumValueForIPCTestAPI(WebCore::AuthenticatorTransport::Nfc),
            enumValueForIPCTestAPI(WebCore::AuthenticatorTransport::Ble),
            enumValueForIPCTestAPI(WebCore::AuthenticatorTransport::Internal),
            enumValueForIPCTestAPI(WebCore::AuthenticatorTransport::Cable),
            enumValueForIPCTestAPI(WebCore::AuthenticatorTransport::Hybrid),
            enumValueForIPCTestAPI(WebCore::AuthenticatorTransport::SmartCard),
        } },
#endif
#if ENABLE(WEB_AUTHN)
        { "WebCore::PublicKeyCredentialType"_s, sizeof(WebCore::PublicKeyCredentialType), false, {
            0, 1
        } },
#endif
#if PLATFORM(IOS_FAMILY)
        { "WebCore::SelectionRenderingBehavior"_s, sizeof(WebCore::SelectionRenderingBehavior), false, {
            0, 1
        } },
#endif
        { "WebCore::DataListSuggestionActivationType"_s, sizeof(WebCore::DataListSuggestionActivationType), false, {
            enumValueForIPCTestAPI(WebCore::DataListSuggestionActivationType::ControlClicked),
            enumValueForIPCTestAPI(WebCore::DataListSuggestionActivationType::IndicatorClicked),
            enumValueForIPCTestAPI(WebCore::DataListSuggestionActivationType::TextChanged),
            enumValueForIPCTestAPI(WebCore::DataListSuggestionActivationType::DataListMayHaveChanged),
        } },
        { "WebCore::AlphaPremultiplication"_s, sizeof(WebCore::AlphaPremultiplication), false, {
            enumValueForIPCTestAPI(WebCore::AlphaPremultiplication::Premultiplied),
            enumValueForIPCTestAPI(WebCore::AlphaPremultiplication::Unpremultiplied),
        } },
        { "WebCore::PixelFormat"_s, sizeof(WebCore::PixelFormat), false, {
            enumValueForIPCTestAPI(WebCore::PixelFormat::RGBA8),
            enumValueForIPCTestAPI(WebCore::PixelFormat::BGRX8),
            enumValueForIPCTestAPI(WebCore::PixelFormat::BGRA8),
#if ENABLE(PIXEL_FORMAT_RGB10)
            enumValueForIPCTestAPI(WebCore::PixelFormat::RGB10),
#endif
#if ENABLE(PIXEL_FORMAT_RGB10A8)
            enumValueForIPCTestAPI(WebCore::PixelFormat::RGB10A8),
#endif
#if ENABLE(PIXEL_FORMAT_RGBA16F)
            enumValueForIPCTestAPI(WebCore::PixelFormat::RGBA16F),
#endif
        } },
        { "WebCore::UseLosslessCompression"_s, sizeof(WebCore::UseLosslessCompression), false, {
            0, 1
        } },
        { "WebCore::ImageBufferPixelFormat"_s, sizeof(WebCore::ImageBufferPixelFormat), false, {
            enumValueForIPCTestAPI(WebCore::ImageBufferPixelFormat::BGRX8),
            enumValueForIPCTestAPI(WebCore::ImageBufferPixelFormat::BGRA8),
#if ENABLE(PIXEL_FORMAT_RGB10)
            enumValueForIPCTestAPI(WebCore::ImageBufferPixelFormat::RGB10),
#endif
#if ENABLE(PIXEL_FORMAT_RGB10A8)
            enumValueForIPCTestAPI(WebCore::ImageBufferPixelFormat::RGB10A8),
#endif
#if ENABLE(PIXEL_FORMAT_RGBA16F)
            enumValueForIPCTestAPI(WebCore::ImageBufferPixelFormat::RGBA16F),
#endif
        } },
        { "WebCore::TextIndicatorLifetime"_s, sizeof(WebCore::TextIndicatorLifetime), false, {
            enumValueForIPCTestAPI(WebCore::TextIndicatorLifetime::Permanent),
            enumValueForIPCTestAPI(WebCore::TextIndicatorLifetime::Temporary),
        } },
        { "WebCore::EventTrackingRegions::EventType"_s, sizeof(WebCore::EventTrackingRegions::EventType), false, {
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Mousedown),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Mousemove),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Mouseup),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Mousewheel),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Pointerdown),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Pointerenter),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Pointerleave),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Pointermove),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Pointerout),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Pointerover),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Pointerup),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Touchend),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Touchforcechange),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Touchmove),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Touchstart),
            enumValueForIPCTestAPI(WebCore::EventTrackingRegions::EventType::Wheel),
        } },
        { "WebCore::HasInsecureContent"_s, sizeof(WebCore::HasInsecureContent), false, {
            0, 1
        } },
        { "WebCore::ScrollElasticity"_s, sizeof(WebCore::ScrollElasticity), false, {
            enumValueForIPCTestAPI(WebCore::ScrollElasticity::Automatic),
            enumValueForIPCTestAPI(WebCore::ScrollElasticity::None),
            enumValueForIPCTestAPI(WebCore::ScrollElasticity::Allowed),
        } },
        { "WebCore::ScrollbarMode"_s, sizeof(WebCore::ScrollbarMode), false, {
            enumValueForIPCTestAPI(WebCore::ScrollbarMode::Auto),
            enumValueForIPCTestAPI(WebCore::ScrollbarMode::AlwaysOff),
            enumValueForIPCTestAPI(WebCore::ScrollbarMode::AlwaysOn),
        } },
        { "WebCore::NativeScrollbarVisibility"_s, sizeof(WebCore::NativeScrollbarVisibility), false, {
            enumValueForIPCTestAPI(WebCore::NativeScrollbarVisibility::Visible),
            enumValueForIPCTestAPI(WebCore::NativeScrollbarVisibility::HiddenByStyle),
            enumValueForIPCTestAPI(WebCore::NativeScrollbarVisibility::ReplacedByCustomScrollbar),
        } },
        { "WebCore::ScrollUpdateType"_s, sizeof(WebCore::ScrollUpdateType), false, {
            enumValueForIPCTestAPI(WebCore::ScrollUpdateType::PositionUpdate),
            enumValueForIPCTestAPI(WebCore::ScrollUpdateType::AnimatedScrollWillStart),
            enumValueForIPCTestAPI(WebCore::ScrollUpdateType::AnimatedScrollDidEnd),
            enumValueForIPCTestAPI(WebCore::ScrollUpdateType::WheelEventScrollWillStart),
            enumValueForIPCTestAPI(WebCore::ScrollUpdateType::WheelEventScrollDidEnd),
            enumValueForIPCTestAPI(WebCore::ScrollUpdateType::ProgrammaticScrollDidEnd),
        } },
        { "WebCore::ScrollingLayerPositionAction"_s, sizeof(WebCore::ScrollingLayerPositionAction), false, {
            enumValueForIPCTestAPI(WebCore::ScrollingLayerPositionAction::Set),
            enumValueForIPCTestAPI(WebCore::ScrollingLayerPositionAction::SetApproximate),
            enumValueForIPCTestAPI(WebCore::ScrollingLayerPositionAction::Sync),
        } },
        { "WebCore::WheelEventProcessingSteps"_s, sizeof(WebCore::WheelEventProcessingSteps), true, {
            enumValueForIPCTestAPI(WebCore::WheelEventProcessingSteps::AsyncScrolling),
            enumValueForIPCTestAPI(WebCore::WheelEventProcessingSteps::SynchronousScrolling),
            enumValueForIPCTestAPI(WebCore::WheelEventProcessingSteps::NonBlockingDOMEventDispatch),
            enumValueForIPCTestAPI(WebCore::WheelEventProcessingSteps::BlockingDOMEventDispatch),
        } },
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "WebCore::GraphicsContextGLPowerPreference"_s, sizeof(WebCore::GraphicsContextGLPowerPreference), false, {
            enumValueForIPCTestAPI(WebCore::GraphicsContextGLPowerPreference::Default),
            enumValueForIPCTestAPI(WebCore::GraphicsContextGLPowerPreference::LowPower),
            enumValueForIPCTestAPI(WebCore::GraphicsContextGLPowerPreference::HighPerformance),
        } },
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "WebCore::GraphicsContextGLSimulatedCreationFailure"_s, sizeof(WebCore::GraphicsContextGLSimulatedCreationFailure), false, {
            enumValueForIPCTestAPI(WebCore::GraphicsContextGLSimulatedCreationFailure::None),
            enumValueForIPCTestAPI(WebCore::GraphicsContextGLSimulatedCreationFailure::IPCBufferOOM),
            enumValueForIPCTestAPI(WebCore::GraphicsContextGLSimulatedCreationFailure::CreationTimeout),
            enumValueForIPCTestAPI(WebCore::GraphicsContextGLSimulatedCreationFailure::FailPlatformContextCreation),
        } },
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "WebCore::GraphicsContextGLFlipY"_s, sizeof(WebCore::GraphicsContextGLFlipY), false, {
            0, 1
        } },
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        { "WebCore::GraphicsContextGLSimulatedEventForTesting"_s, sizeof(WebCore::GraphicsContextGLSimulatedEventForTesting), false, {
            enumValueForIPCTestAPI(WebCore::GraphicsContextGLSimulatedEventForTesting::GPUStatusFailure),
            enumValueForIPCTestAPI(WebCore::GraphicsContextGLSimulatedEventForTesting::Timeout),
            enumValueForIPCTestAPI(WebCore::GraphicsContextGLSimulatedEventForTesting::DisplayBufferAllocationFailure),
        } },
#endif
        { "WebCore::CSSBoxType"_s, sizeof(WebCore::CSSBoxType), false, {
            enumValueForIPCTestAPI(WebCore::CSSBoxType::BoxMissing),
            enumValueForIPCTestAPI(WebCore::CSSBoxType::MarginBox),
            enumValueForIPCTestAPI(WebCore::CSSBoxType::BorderBox),
            enumValueForIPCTestAPI(WebCore::CSSBoxType::PaddingBox),
            enumValueForIPCTestAPI(WebCore::CSSBoxType::ContentBox),
            enumValueForIPCTestAPI(WebCore::CSSBoxType::FillBox),
            enumValueForIPCTestAPI(WebCore::CSSBoxType::StrokeBox),
            enumValueForIPCTestAPI(WebCore::CSSBoxType::ViewBox),
        } },
#if ENABLE(WEB_AUTHN)
        { "WebCore::UserVerificationRequirement"_s, sizeof(WebCore::UserVerificationRequirement), false, {
            enumValueForIPCTestAPI(WebCore::UserVerificationRequirement::Required),
            enumValueForIPCTestAPI(WebCore::UserVerificationRequirement::Preferred),
            enumValueForIPCTestAPI(WebCore::UserVerificationRequirement::Discouraged),
        } },
#endif
#if ENABLE(WEB_AUTHN)
        { "WebCore::ResidentKeyRequirement"_s, sizeof(WebCore::ResidentKeyRequirement), false, {
            enumValueForIPCTestAPI(WebCore::ResidentKeyRequirement::Required),
            enumValueForIPCTestAPI(WebCore::ResidentKeyRequirement::Preferred),
            enumValueForIPCTestAPI(WebCore::ResidentKeyRequirement::Discouraged),
        } },
#endif
#if ENABLE(WEB_AUTHN)
        { "WebCore::AuthenticatorAttachment"_s, sizeof(WebCore::AuthenticatorAttachment), false, {
            enumValueForIPCTestAPI(WebCore::AuthenticatorAttachment::Platform),
            enumValueForIPCTestAPI(WebCore::AuthenticatorAttachment::CrossPlatform),
        } },
#endif
        { "WebCore::ResourceRequestCachePolicy"_s, sizeof(WebCore::ResourceRequestCachePolicy), false, {
            enumValueForIPCTestAPI(WebCore::ResourceRequestCachePolicy::UseProtocolCachePolicy),
            enumValueForIPCTestAPI(WebCore::ResourceRequestCachePolicy::ReloadIgnoringCacheData),
            enumValueForIPCTestAPI(WebCore::ResourceRequestCachePolicy::ReturnCacheDataElseLoad),
            enumValueForIPCTestAPI(WebCore::ResourceRequestCachePolicy::ReturnCacheDataDontLoad),
            enumValueForIPCTestAPI(WebCore::ResourceRequestCachePolicy::DoNotUseAnyCache),
            enumValueForIPCTestAPI(WebCore::ResourceRequestCachePolicy::RefreshAnyCacheData),
        } },
        { "WebCore::ResourceRequestBase::SameSiteDisposition"_s, sizeof(WebCore::ResourceRequestBase::SameSiteDisposition), false, {
            enumValueForIPCTestAPI(WebCore::ResourceRequestBase::SameSiteDisposition::Unspecified),
            enumValueForIPCTestAPI(WebCore::ResourceRequestBase::SameSiteDisposition::SameSite),
            enumValueForIPCTestAPI(WebCore::ResourceRequestBase::SameSiteDisposition::CrossSite),
        } },
        { "WebCore::ResourceRequestRequester"_s, sizeof(WebCore::ResourceRequestRequester), false, {
            enumValueForIPCTestAPI(WebCore::ResourceRequestRequester::Unspecified),
            enumValueForIPCTestAPI(WebCore::ResourceRequestRequester::Main),
            enumValueForIPCTestAPI(WebCore::ResourceRequestRequester::XHR),
            enumValueForIPCTestAPI(WebCore::ResourceRequestRequester::Fetch),
            enumValueForIPCTestAPI(WebCore::ResourceRequestRequester::Media),
            enumValueForIPCTestAPI(WebCore::ResourceRequestRequester::Model),
            enumValueForIPCTestAPI(WebCore::ResourceRequestRequester::ImportScripts),
            enumValueForIPCTestAPI(WebCore::ResourceRequestRequester::Ping),
            enumValueForIPCTestAPI(WebCore::ResourceRequestRequester::Beacon),
            enumValueForIPCTestAPI(WebCore::ResourceRequestRequester::EventSource),
        } },
        { "WebCore::ResourceLoadPriority"_s, sizeof(WebCore::ResourceLoadPriority), false, {
            enumValueForIPCTestAPI(WebCore::ResourceLoadPriority::VeryLow),
            enumValueForIPCTestAPI(WebCore::ResourceLoadPriority::Low),
            enumValueForIPCTestAPI(WebCore::ResourceLoadPriority::Medium),
            enumValueForIPCTestAPI(WebCore::ResourceLoadPriority::High),
            enumValueForIPCTestAPI(WebCore::ResourceLoadPriority::VeryHigh),
        } },
        { "WebCore::ResourceResponseBaseType"_s, sizeof(WebCore::ResourceResponseBaseType), false, {
            enumValueForIPCTestAPI(WebCore::ResourceResponseBaseType::Basic),
            enumValueForIPCTestAPI(WebCore::ResourceResponseBaseType::Cors),
            enumValueForIPCTestAPI(WebCore::ResourceResponseBaseType::Default),
            enumValueForIPCTestAPI(WebCore::ResourceResponseBaseType::Error),
            enumValueForIPCTestAPI(WebCore::ResourceResponseBaseType::Opaque),
            enumValueForIPCTestAPI(WebCore::ResourceResponseBaseType::Opaqueredirect),
        } },
        { "WebCore::ResourceResponseBaseTainting"_s, sizeof(WebCore::ResourceResponseBaseTainting), false, {
            enumValueForIPCTestAPI(WebCore::ResourceResponseBaseTainting::Basic),
            enumValueForIPCTestAPI(WebCore::ResourceResponseBaseTainting::Cors),
            enumValueForIPCTestAPI(WebCore::ResourceResponseBaseTainting::Opaque),
            enumValueForIPCTestAPI(WebCore::ResourceResponseBaseTainting::Opaqueredirect),
        } },
        { "WebCore::ResourceResponseSource"_s, sizeof(WebCore::ResourceResponseSource), false, {
            enumValueForIPCTestAPI(WebCore::ResourceResponseSource::Unknown),
            enumValueForIPCTestAPI(WebCore::ResourceResponseSource::Network),
            enumValueForIPCTestAPI(WebCore::ResourceResponseSource::DiskCache),
            enumValueForIPCTestAPI(WebCore::ResourceResponseSource::DiskCacheAfterValidation),
            enumValueForIPCTestAPI(WebCore::ResourceResponseSource::MemoryCache),
            enumValueForIPCTestAPI(WebCore::ResourceResponseSource::MemoryCacheAfterValidation),
            enumValueForIPCTestAPI(WebCore::ResourceResponseSource::ServiceWorker),
            enumValueForIPCTestAPI(WebCore::ResourceResponseSource::ApplicationCache),
            enumValueForIPCTestAPI(WebCore::ResourceResponseSource::DOMCache),
            enumValueForIPCTestAPI(WebCore::ResourceResponseSource::InspectorOverride),
        } },
        { "WebCore::UsedLegacyTLS"_s, sizeof(WebCore::UsedLegacyTLS), false, {
            0, 1
        } },
        { "WebCore::WasPrivateRelayed"_s, sizeof(WebCore::WasPrivateRelayed), false, {
            0, 1
        } },
        { "WebCore::ReferrerPolicy"_s, sizeof(WebCore::ReferrerPolicy), false, {
            enumValueForIPCTestAPI(WebCore::ReferrerPolicy::EmptyString),
            enumValueForIPCTestAPI(WebCore::ReferrerPolicy::NoReferrer),
            enumValueForIPCTestAPI(WebCore::ReferrerPolicy::NoReferrerWhenDowngrade),
            enumValueForIPCTestAPI(WebCore::ReferrerPolicy::SameOrigin),
            enumValueForIPCTestAPI(WebCore::ReferrerPolicy::Origin),
            enumValueForIPCTestAPI(WebCore::ReferrerPolicy::StrictOrigin),
            enumValueForIPCTestAPI(WebCore::ReferrerPolicy::OriginWhenCrossOrigin),
            enumValueForIPCTestAPI(WebCore::ReferrerPolicy::StrictOriginWhenCrossOrigin),
            enumValueForIPCTestAPI(WebCore::ReferrerPolicy::UnsafeUrl),
        } },
        { "WebCore::FetchOptionsDestination"_s, sizeof(WebCore::FetchOptionsDestination), false, {
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::EmptyString),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Audio),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Audioworklet),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Document),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Embed),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Environmentmap),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Font),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Image),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Iframe),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Manifest),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Model),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Object),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Paintworklet),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Report),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Script),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Serviceworker),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Sharedworker),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Style),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Track),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Video),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Worker),
            enumValueForIPCTestAPI(WebCore::FetchOptionsDestination::Xslt),
        } },
        { "WebCore::FetchOptionsMode"_s, sizeof(WebCore::FetchOptionsMode), false, {
            enumValueForIPCTestAPI(WebCore::FetchOptionsMode::Navigate),
            enumValueForIPCTestAPI(WebCore::FetchOptionsMode::SameOrigin),
            enumValueForIPCTestAPI(WebCore::FetchOptionsMode::NoCors),
            enumValueForIPCTestAPI(WebCore::FetchOptionsMode::Cors),
        } },
        { "WebCore::FetchOptionsCredentials"_s, sizeof(WebCore::FetchOptionsCredentials), false, {
            enumValueForIPCTestAPI(WebCore::FetchOptionsCredentials::Omit),
            enumValueForIPCTestAPI(WebCore::FetchOptionsCredentials::SameOrigin),
            enumValueForIPCTestAPI(WebCore::FetchOptionsCredentials::Include),
        } },
        { "WebCore::FetchOptionsCache"_s, sizeof(WebCore::FetchOptionsCache), false, {
            enumValueForIPCTestAPI(WebCore::FetchOptionsCache::Default),
            enumValueForIPCTestAPI(WebCore::FetchOptionsCache::NoStore),
            enumValueForIPCTestAPI(WebCore::FetchOptionsCache::Reload),
            enumValueForIPCTestAPI(WebCore::FetchOptionsCache::NoCache),
            enumValueForIPCTestAPI(WebCore::FetchOptionsCache::ForceCache),
            enumValueForIPCTestAPI(WebCore::FetchOptionsCache::OnlyIfCached),
        } },
        { "WebCore::FetchOptionsRedirect"_s, sizeof(WebCore::FetchOptionsRedirect), false, {
            enumValueForIPCTestAPI(WebCore::FetchOptionsRedirect::Follow),
            enumValueForIPCTestAPI(WebCore::FetchOptionsRedirect::Error),
            enumValueForIPCTestAPI(WebCore::FetchOptionsRedirect::Manual),
        } },
        { "WebCore::FetchHeadersGuard"_s, sizeof(WebCore::FetchHeadersGuard), false, {
            enumValueForIPCTestAPI(WebCore::FetchHeadersGuard::None),
            enumValueForIPCTestAPI(WebCore::FetchHeadersGuard::Immutable),
            enumValueForIPCTestAPI(WebCore::FetchHeadersGuard::Request),
            enumValueForIPCTestAPI(WebCore::FetchHeadersGuard::RequestNoCors),
            enumValueForIPCTestAPI(WebCore::FetchHeadersGuard::Response),
        } },
        { "WebCore::ControlStyle::State"_s, sizeof(WebCore::ControlStyle::State), true, {
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::Hovered),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::Pressed),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::Focused),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::Enabled),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::Checked),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::Default),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::WindowActive),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::Indeterminate),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::SpinUp),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::Presenting),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::FormSemanticContext),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::DarkAppearance),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::InlineFlippedWritingMode),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::LargeControls),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::ReadOnly),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::ListButton),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::ListButtonPressed),
            enumValueForIPCTestAPI(WebCore::ControlStyle::State::VerticalWritingMode),
        } },
        { "WebCore::StyleAppearance"_s, sizeof(WebCore::StyleAppearance), false, {
            enumValueForIPCTestAPI(WebCore::StyleAppearance::None),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::Auto),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::Checkbox),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::Radio),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::PushButton),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::SquareButton),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::Button),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::DefaultButton),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::Listbox),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::Menulist),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::MenulistButton),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::Meter),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::ProgressBar),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::SliderHorizontal),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::SliderVertical),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::SearchField),
#if ENABLE(APPLE_PAY)
            enumValueForIPCTestAPI(WebCore::StyleAppearance::ApplePayButton),
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
            enumValueForIPCTestAPI(WebCore::StyleAppearance::Attachment),
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
            enumValueForIPCTestAPI(WebCore::StyleAppearance::BorderlessAttachment),
#endif
            enumValueForIPCTestAPI(WebCore::StyleAppearance::TextArea),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::TextField),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::ColorWell),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::ColorWellSwatch),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::ColorWellSwatchOverlay),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::ColorWellSwatchWrapper),
#if ENABLE(SERVICE_CONTROLS)
            enumValueForIPCTestAPI(WebCore::StyleAppearance::ImageControlsButton),
#endif
            enumValueForIPCTestAPI(WebCore::StyleAppearance::InnerSpinButton),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::ListButton),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::SearchFieldDecoration),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::SearchFieldResultsDecoration),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::SearchFieldResultsButton),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::SearchFieldCancelButton),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::SliderThumbHorizontal),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::SliderThumbVertical),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::Switch),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::SwitchThumb),
            enumValueForIPCTestAPI(WebCore::StyleAppearance::SwitchTrack),
        } },
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayButtonType"_s, sizeof(WebCore::ApplePayButtonType), false, {
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::Plain),
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::Buy),
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::SetUp),
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::Donate),
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::CheckOut),
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::Book),
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::Subscribe),
#if ENABLE(APPLE_PAY_NEW_BUTTON_TYPES)
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::Reload),
#endif
#if ENABLE(APPLE_PAY_NEW_BUTTON_TYPES)
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::AddMoney),
#endif
#if ENABLE(APPLE_PAY_NEW_BUTTON_TYPES)
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::TopUp),
#endif
#if ENABLE(APPLE_PAY_NEW_BUTTON_TYPES)
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::Order),
#endif
#if ENABLE(APPLE_PAY_NEW_BUTTON_TYPES)
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::Rent),
#endif
#if ENABLE(APPLE_PAY_NEW_BUTTON_TYPES)
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::Support),
#endif
#if ENABLE(APPLE_PAY_NEW_BUTTON_TYPES)
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::Contribute),
#endif
#if ENABLE(APPLE_PAY_NEW_BUTTON_TYPES)
            enumValueForIPCTestAPI(WebCore::ApplePayButtonType::Tip),
#endif
        } },
#endif
#if ENABLE(APPLE_PAY)
        { "WebCore::ApplePayButtonStyle"_s, sizeof(WebCore::ApplePayButtonStyle), false, {
            enumValueForIPCTestAPI(WebCore::ApplePayButtonStyle::White),
            enumValueForIPCTestAPI(WebCore::ApplePayButtonStyle::WhiteOutline),
            enumValueForIPCTestAPI(WebCore::ApplePayButtonStyle::Black),
        } },
#endif
        { "WebCore::MeterPart::GaugeRegion"_s, sizeof(WebCore::MeterPart::GaugeRegion), false, {
            enumValueForIPCTestAPI(WebCore::MeterPart::GaugeRegion::Optimum),
            enumValueForIPCTestAPI(WebCore::MeterPart::GaugeRegion::Suboptimal),
            enumValueForIPCTestAPI(WebCore::MeterPart::GaugeRegion::EvenLessGood),
        } },
        { "WebCore::FilterEffectGeometry::Flags"_s, sizeof(WebCore::FilterEffectGeometry::Flags), true, {
            enumValueForIPCTestAPI(WebCore::FilterEffectGeometry::Flags::HasX),
            enumValueForIPCTestAPI(WebCore::FilterEffectGeometry::Flags::HasY),
            enumValueForIPCTestAPI(WebCore::FilterEffectGeometry::Flags::HasWidth),
            enumValueForIPCTestAPI(WebCore::FilterEffectGeometry::Flags::HasHeight),
        } },
        { "WebCore::ModalContainerDecision"_s, sizeof(WebCore::ModalContainerDecision), false, {
            enumValueForIPCTestAPI(WebCore::ModalContainerDecision::Show),
            enumValueForIPCTestAPI(WebCore::ModalContainerDecision::HideAndIgnore),
            enumValueForIPCTestAPI(WebCore::ModalContainerDecision::HideAndAllow),
            enumValueForIPCTestAPI(WebCore::ModalContainerDecision::HideAndDisallow),
        } },
        { "WebCore::AutoplayEventFlags"_s, sizeof(WebCore::AutoplayEventFlags), true, {
            enumValueForIPCTestAPI(WebCore::AutoplayEventFlags::HasAudio),
            enumValueForIPCTestAPI(WebCore::AutoplayEventFlags::PlaybackWasPrevented),
            enumValueForIPCTestAPI(WebCore::AutoplayEventFlags::MediaIsMainContent),
        } },
        { "WebCore::FocusDirection"_s, sizeof(WebCore::FocusDirection), false, {
            enumValueForIPCTestAPI(WebCore::FocusDirection::None),
            enumValueForIPCTestAPI(WebCore::FocusDirection::Forward),
            enumValueForIPCTestAPI(WebCore::FocusDirection::Backward),
            enumValueForIPCTestAPI(WebCore::FocusDirection::Up),
            enumValueForIPCTestAPI(WebCore::FocusDirection::Down),
            enumValueForIPCTestAPI(WebCore::FocusDirection::Left),
            enumValueForIPCTestAPI(WebCore::FocusDirection::Right),
        } },
#if ENABLE(GAMEPAD)
        { "WebCore::GamepadHapticEffectType"_s, sizeof(WebCore::GamepadHapticEffectType), false, {
            enumValueForIPCTestAPI(WebCore::GamepadHapticEffectType::DualRumble),
            enumValueForIPCTestAPI(WebCore::GamepadHapticEffectType::TriggerRumble),
        } },
#endif
        { "WebCore::DOMPasteAccessCategory"_s, sizeof(WebCore::DOMPasteAccessCategory), false, {
            enumValueForIPCTestAPI(WebCore::DOMPasteAccessCategory::General),
            enumValueForIPCTestAPI(WebCore::DOMPasteAccessCategory::Fonts),
        } },
        { "WebCore::DOMPasteAccessPolicy"_s, sizeof(WebCore::DOMPasteAccessPolicy), false, {
            enumValueForIPCTestAPI(WebCore::DOMPasteAccessPolicy::NotRequestedYet),
            enumValueForIPCTestAPI(WebCore::DOMPasteAccessPolicy::Denied),
            enumValueForIPCTestAPI(WebCore::DOMPasteAccessPolicy::Granted),
        } },
        { "WebCore::DOMPasteAccessResponse"_s, sizeof(WebCore::DOMPasteAccessResponse), false, {
            enumValueForIPCTestAPI(WebCore::DOMPasteAccessResponse::DeniedForGesture),
            enumValueForIPCTestAPI(WebCore::DOMPasteAccessResponse::GrantedForCommand),
            enumValueForIPCTestAPI(WebCore::DOMPasteAccessResponse::GrantedForGesture),
        } },
        { "WebCore::DeviceOrientationOrMotionPermissionState"_s, sizeof(WebCore::DeviceOrientationOrMotionPermissionState), false, {
            enumValueForIPCTestAPI(WebCore::DeviceOrientationOrMotionPermissionState::Granted),
            enumValueForIPCTestAPI(WebCore::DeviceOrientationOrMotionPermissionState::Denied),
            enumValueForIPCTestAPI(WebCore::DeviceOrientationOrMotionPermissionState::Prompt),
        } },
        { "WebCore::ExceptionDetails::Type"_s, sizeof(WebCore::ExceptionDetails::Type), false, {
            enumValueForIPCTestAPI(WebCore::ExceptionDetails::Type::Script),
            enumValueForIPCTestAPI(WebCore::ExceptionDetails::Type::InvalidTargetFrame),
            enumValueForIPCTestAPI(WebCore::ExceptionDetails::Type::AppBoundDomain),
        } },
        { "WebCore::SecurityPolicyViolationEventDisposition"_s, sizeof(WebCore::SecurityPolicyViolationEventDisposition), false, {
            0, 1
        } },
        { "WebCore::VerticalAlignChange"_s, sizeof(WebCore::VerticalAlignChange), false, {
            enumValueForIPCTestAPI(WebCore::VerticalAlignChange::Superscript),
            enumValueForIPCTestAPI(WebCore::VerticalAlignChange::Baseline),
            enumValueForIPCTestAPI(WebCore::VerticalAlignChange::Subscript),
        } },
        { "WebCore::TextGranularity"_s, sizeof(WebCore::TextGranularity), false, {
            enumValueForIPCTestAPI(WebCore::TextGranularity::CharacterGranularity),
            enumValueForIPCTestAPI(WebCore::TextGranularity::WordGranularity),
            enumValueForIPCTestAPI(WebCore::TextGranularity::SentenceGranularity),
            enumValueForIPCTestAPI(WebCore::TextGranularity::LineGranularity),
            enumValueForIPCTestAPI(WebCore::TextGranularity::ParagraphGranularity),
            enumValueForIPCTestAPI(WebCore::TextGranularity::DocumentGranularity),
            enumValueForIPCTestAPI(WebCore::TextGranularity::SentenceBoundary),
            enumValueForIPCTestAPI(WebCore::TextGranularity::LineBoundary),
            enumValueForIPCTestAPI(WebCore::TextGranularity::ParagraphBoundary),
            enumValueForIPCTestAPI(WebCore::TextGranularity::DocumentBoundary),
        } },
        { "WebCore::RunAsAsyncFunction"_s, sizeof(WebCore::RunAsAsyncFunction), false, {
            0, 1
        } },
        { "WebCore::ForceUserGesture"_s, sizeof(WebCore::ForceUserGesture), false, {
            0, 1
        } },
        { "WebCore::RemoveTransientActivation"_s, sizeof(WebCore::RemoveTransientActivation), false, {
            0, 1
        } },
        { "WebCore::FontAttributes::SubscriptOrSuperscript"_s, sizeof(WebCore::FontAttributes::SubscriptOrSuperscript), false, {
            enumValueForIPCTestAPI(WebCore::FontAttributes::SubscriptOrSuperscript::None),
            enumValueForIPCTestAPI(WebCore::FontAttributes::SubscriptOrSuperscript::Subscript),
            enumValueForIPCTestAPI(WebCore::FontAttributes::SubscriptOrSuperscript::Superscript),
        } },
        { "WebCore::FontAttributes::HorizontalAlignment"_s, sizeof(WebCore::FontAttributes::HorizontalAlignment), false, {
            enumValueForIPCTestAPI(WebCore::FontAttributes::HorizontalAlignment::Left),
            enumValueForIPCTestAPI(WebCore::FontAttributes::HorizontalAlignment::Center),
            enumValueForIPCTestAPI(WebCore::FontAttributes::HorizontalAlignment::Right),
            enumValueForIPCTestAPI(WebCore::FontAttributes::HorizontalAlignment::Justify),
            enumValueForIPCTestAPI(WebCore::FontAttributes::HorizontalAlignment::Natural),
        } },
        { "WebCore::WritingDirection"_s, sizeof(WebCore::WritingDirection), false, {
            enumValueForIPCTestAPI(WebCore::WritingDirection::Natural),
            enumValueForIPCTestAPI(WebCore::WritingDirection::LeftToRight),
            enumValueForIPCTestAPI(WebCore::WritingDirection::RightToLeft),
        } },
        { "WebCore::SelectionDirection"_s, sizeof(WebCore::SelectionDirection), false, {
            enumValueForIPCTestAPI(WebCore::SelectionDirection::Forward),
            enumValueForIPCTestAPI(WebCore::SelectionDirection::Backward),
            enumValueForIPCTestAPI(WebCore::SelectionDirection::Right),
            enumValueForIPCTestAPI(WebCore::SelectionDirection::Left),
        } },
#if ENABLE(DATA_DETECTION)
        { "WebCore::DataDetectorType"_s, sizeof(WebCore::DataDetectorType), true, {
            enumValueForIPCTestAPI(WebCore::DataDetectorType::PhoneNumber),
            enumValueForIPCTestAPI(WebCore::DataDetectorType::Link),
            enumValueForIPCTestAPI(WebCore::DataDetectorType::Address),
            enumValueForIPCTestAPI(WebCore::DataDetectorType::CalendarEvent),
            enumValueForIPCTestAPI(WebCore::DataDetectorType::TrackingNumber),
            enumValueForIPCTestAPI(WebCore::DataDetectorType::FlightNumber),
            enumValueForIPCTestAPI(WebCore::DataDetectorType::LookupSuggestion),
        } },
#endif
        { "WebCore::AutocapitalizeType"_s, sizeof(WebCore::AutocapitalizeType), false, {
            enumValueForIPCTestAPI(WebCore::AutocapitalizeType::Default),
            enumValueForIPCTestAPI(WebCore::AutocapitalizeType::None),
            enumValueForIPCTestAPI(WebCore::AutocapitalizeType::Words),
            enumValueForIPCTestAPI(WebCore::AutocapitalizeType::Sentences),
            enumValueForIPCTestAPI(WebCore::AutocapitalizeType::AllCharacters),
        } },
        { "WebCore::CrossOriginEmbedderPolicyValue"_s, sizeof(WebCore::CrossOriginEmbedderPolicyValue), false, {
            0, 1
        } },
        { "WebCore::IncludeSecureCookies"_s, sizeof(WebCore::IncludeSecureCookies), false, {
            0, 1
        } },
#if ENABLE(ASYNC_SCROLLING)
        { "WebCore::ScrollingStateNodeProperty"_s, sizeof(WebCore::ScrollingStateNodeProperty), true, {
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::Layer),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ChildNodes),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ScrollableAreaSize),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::TotalContentsSize),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ReachableContentsSize),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ScrollPosition),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ScrollOrigin),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ScrollableAreaParams),
#if ENABLE(SCROLLING_THREAD)
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ReasonsForSynchronousScrolling),
#endif
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::RequestedScrollPosition),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::SnapOffsetsInfo),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::CurrentHorizontalSnapOffsetIndex),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::CurrentVerticalSnapOffsetIndex),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::IsMonitoringWheelEvents),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ScrollContainerLayer),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ScrolledContentsLayer),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::HorizontalScrollbarLayer),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::VerticalScrollbarLayer),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::PainterForScrollbar),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ContentAreaHoverState),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::MouseActivityState),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ScrollbarHoverState),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ScrollbarEnabledState),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ScrollbarLayoutDirection),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ScrollbarWidth),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::UseDarkAppearanceForScrollbars),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::FrameScaleFactor),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::EventTrackingRegion),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::RootContentsLayer),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::CounterScrollingLayer),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::InsetClipLayer),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ContentShadowLayer),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::HeaderHeight),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::FooterHeight),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::HeaderLayer),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::FooterLayer),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::BehaviorForFixedElements),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ObscuredContentInsets),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::VisualViewportIsSmallerThanLayoutViewport),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::AsyncFrameOrOverflowScrollingEnabled),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::WheelEventGesturesBecomeNonBlocking),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ScrollingPerformanceTestingEnabled),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::LayoutViewport),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::MinLayoutViewportOrigin),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::MaxLayoutViewportOrigin),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::OverrideVisualViewportSize),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::RelatedOverflowScrollingNodes),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::LayoutConstraintData),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ViewportConstraints),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::ViewportAnchorLayer),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::OverflowScrollingNode),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::KeyboardScrollData),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::OverlayScrollbarsEnabled),
            enumValueForIPCTestAPI(WebCore::ScrollingStateNodeProperty::LayerHostingContextIdentifier),
        } },
#endif
        { "WebCore::ScrollClamping"_s, sizeof(WebCore::ScrollClamping), false, {
            0, 1
        } },
        { "WebCore::ScrollType"_s, sizeof(WebCore::ScrollType), false, {
            0, 1
        } },
        { "WebCore::ScrollSnapStop"_s, sizeof(WebCore::ScrollSnapStop), false, {
            0, 1
        } },
#if ENABLE(ENCRYPTED_MEDIA)
        { "WebCore::CDMEncryptionScheme"_s, sizeof(WebCore::CDMEncryptionScheme), false, {
            0, 1
        } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
        { "WebCore::CDMKeyGroupingStrategy"_s, sizeof(WebCore::CDMKeyGroupingStrategy), false, {
            0, 1
        } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
        { "WebCore::CDMSessionType"_s, sizeof(WebCore::CDMSessionType), false, {
            enumValueForIPCTestAPI(WebCore::CDMSessionType::Temporary),
            enumValueForIPCTestAPI(WebCore::CDMSessionType::PersistentUsageRecord),
            enumValueForIPCTestAPI(WebCore::CDMSessionType::PersistentLicense),
        } },
#endif
        { "WebCore::MediaSelectionOption::MediaType"_s, sizeof(WebCore::MediaSelectionOption::MediaType), false, {
            enumValueForIPCTestAPI(WebCore::MediaSelectionOption::MediaType::Unknown),
            enumValueForIPCTestAPI(WebCore::MediaSelectionOption::MediaType::Audio),
            enumValueForIPCTestAPI(WebCore::MediaSelectionOption::MediaType::Subtitles),
            enumValueForIPCTestAPI(WebCore::MediaSelectionOption::MediaType::Captions),
            enumValueForIPCTestAPI(WebCore::MediaSelectionOption::MediaType::Metadata),
        } },
        { "WebCore::MediaSelectionOption::LegibleType"_s, sizeof(WebCore::MediaSelectionOption::LegibleType), false, {
            enumValueForIPCTestAPI(WebCore::MediaSelectionOption::LegibleType::Regular),
            enumValueForIPCTestAPI(WebCore::MediaSelectionOption::LegibleType::LegibleOff),
            enumValueForIPCTestAPI(WebCore::MediaSelectionOption::LegibleType::LegibleAuto),
        } },
        { "WebCore::MediaDecodingType"_s, sizeof(WebCore::MediaDecodingType), false, {
            enumValueForIPCTestAPI(WebCore::MediaDecodingType::File),
            enumValueForIPCTestAPI(WebCore::MediaDecodingType::MediaSource),
            enumValueForIPCTestAPI(WebCore::MediaDecodingType::WebRTC),
        } },
        { "WebCore::MediaEncodingType"_s, sizeof(WebCore::MediaEncodingType), false, {
            0, 1
        } },
        { "WebCore::TextManipulationControllerExclusionRule::Type"_s, sizeof(WebCore::TextManipulationControllerExclusionRule::Type), false, {
            enumValueForIPCTestAPI(WebCore::TextManipulationControllerExclusionRule::Type::Exclude),
            enumValueForIPCTestAPI(WebCore::TextManipulationControllerExclusionRule::Type::Include),
        } },
        { "WebCore::TextManipulationControllerManipulationFailure::Type"_s, sizeof(WebCore::TextManipulationControllerManipulationFailure::Type), false, {
            enumValueForIPCTestAPI(WebCore::TextManipulationControllerManipulationFailure::Type::NotAvailable),
            enumValueForIPCTestAPI(WebCore::TextManipulationControllerManipulationFailure::Type::ContentChanged),
            enumValueForIPCTestAPI(WebCore::TextManipulationControllerManipulationFailure::Type::InvalidItem),
            enumValueForIPCTestAPI(WebCore::TextManipulationControllerManipulationFailure::Type::InvalidToken),
            enumValueForIPCTestAPI(WebCore::TextManipulationControllerManipulationFailure::Type::ExclusionViolation),
        } },
#if ENABLE(VIDEO)
        { "WebCore::VideoMediaSampleRendererPreference"_s, sizeof(WebCore::VideoMediaSampleRendererPreference), true, {
            enumValueForIPCTestAPI(WebCore::VideoMediaSampleRendererPreference::PrefersDecompressionSession),
            enumValueForIPCTestAPI(WebCore::VideoMediaSampleRendererPreference::ProtectedFallbackDisabled),
            enumValueForIPCTestAPI(WebCore::VideoMediaSampleRendererPreference::UseDecompressionSessionForProtectedContent),
            enumValueForIPCTestAPI(WebCore::VideoMediaSampleRendererPreference::UseStereoDecoding),
        } },
#endif
        { "WebCore::MediaPlayerNetworkState"_s, sizeof(WebCore::MediaPlayerNetworkState), false, {
            enumValueForIPCTestAPI(WebCore::MediaPlayerNetworkState::Empty),
            enumValueForIPCTestAPI(WebCore::MediaPlayerNetworkState::Idle),
            enumValueForIPCTestAPI(WebCore::MediaPlayerNetworkState::Loading),
            enumValueForIPCTestAPI(WebCore::MediaPlayerNetworkState::Loaded),
            enumValueForIPCTestAPI(WebCore::MediaPlayerNetworkState::FormatError),
            enumValueForIPCTestAPI(WebCore::MediaPlayerNetworkState::NetworkError),
            enumValueForIPCTestAPI(WebCore::MediaPlayerNetworkState::DecodeError),
        } },
        { "WebCore::MediaPlayerReadyState"_s, sizeof(WebCore::MediaPlayerReadyState), false, {
            enumValueForIPCTestAPI(WebCore::MediaPlayerReadyState::HaveNothing),
            enumValueForIPCTestAPI(WebCore::MediaPlayerReadyState::HaveMetadata),
            enumValueForIPCTestAPI(WebCore::MediaPlayerReadyState::HaveCurrentData),
            enumValueForIPCTestAPI(WebCore::MediaPlayerReadyState::HaveFutureData),
            enumValueForIPCTestAPI(WebCore::MediaPlayerReadyState::HaveEnoughData),
        } },
        { "WebCore::MediaPlayerMovieLoadType"_s, sizeof(WebCore::MediaPlayerMovieLoadType), false, {
            enumValueForIPCTestAPI(WebCore::MediaPlayerMovieLoadType::Unknown),
            enumValueForIPCTestAPI(WebCore::MediaPlayerMovieLoadType::Download),
            enumValueForIPCTestAPI(WebCore::MediaPlayerMovieLoadType::StoredStream),
            enumValueForIPCTestAPI(WebCore::MediaPlayerMovieLoadType::LiveStream),
            enumValueForIPCTestAPI(WebCore::MediaPlayerMovieLoadType::HttpLiveStream),
        } },
        { "WebCore::MediaPlayerPreload"_s, sizeof(WebCore::MediaPlayerPreload), false, {
            enumValueForIPCTestAPI(WebCore::MediaPlayerPreload::None),
            enumValueForIPCTestAPI(WebCore::MediaPlayerPreload::MetaData),
            enumValueForIPCTestAPI(WebCore::MediaPlayerPreload::Auto),
        } },
        { "WebCore::MediaPlayerVideoGravity"_s, sizeof(WebCore::MediaPlayerVideoGravity), false, {
            enumValueForIPCTestAPI(WebCore::MediaPlayerVideoGravity::Resize),
            enumValueForIPCTestAPI(WebCore::MediaPlayerVideoGravity::ResizeAspect),
            enumValueForIPCTestAPI(WebCore::MediaPlayerVideoGravity::ResizeAspectFill),
        } },
        { "WebCore::MediaPlayerSupportsType"_s, sizeof(WebCore::MediaPlayerSupportsType), false, {
            enumValueForIPCTestAPI(WebCore::MediaPlayerSupportsType::IsNotSupported),
            enumValueForIPCTestAPI(WebCore::MediaPlayerSupportsType::IsSupported),
            enumValueForIPCTestAPI(WebCore::MediaPlayerSupportsType::MayBeSupported),
        } },
        { "WebCore::MediaPlayerBufferingPolicy"_s, sizeof(WebCore::MediaPlayerBufferingPolicy), false, {
            enumValueForIPCTestAPI(WebCore::MediaPlayerBufferingPolicy::Default),
            enumValueForIPCTestAPI(WebCore::MediaPlayerBufferingPolicy::LimitReadAhead),
            enumValueForIPCTestAPI(WebCore::MediaPlayerBufferingPolicy::MakeResourcesPurgeable),
            enumValueForIPCTestAPI(WebCore::MediaPlayerBufferingPolicy::PurgeResources),
        } },
        { "WebCore::MediaPlayerMediaEngineIdentifier"_s, sizeof(WebCore::MediaPlayerMediaEngineIdentifier), false, {
            enumValueForIPCTestAPI(WebCore::MediaPlayerMediaEngineIdentifier::AVFoundation),
            enumValueForIPCTestAPI(WebCore::MediaPlayerMediaEngineIdentifier::AVFoundationMSE),
            enumValueForIPCTestAPI(WebCore::MediaPlayerMediaEngineIdentifier::AVFoundationMediaStream),
            enumValueForIPCTestAPI(WebCore::MediaPlayerMediaEngineIdentifier::AVFoundationCF),
            enumValueForIPCTestAPI(WebCore::MediaPlayerMediaEngineIdentifier::GStreamer),
            enumValueForIPCTestAPI(WebCore::MediaPlayerMediaEngineIdentifier::GStreamerMSE),
            enumValueForIPCTestAPI(WebCore::MediaPlayerMediaEngineIdentifier::HolePunch),
            enumValueForIPCTestAPI(WebCore::MediaPlayerMediaEngineIdentifier::MediaFoundation),
            enumValueForIPCTestAPI(WebCore::MediaPlayerMediaEngineIdentifier::MockMSE),
            enumValueForIPCTestAPI(WebCore::MediaPlayerMediaEngineIdentifier::CocoaWebM),
        } },
        { "WebCore::MediaPlayerWirelessPlaybackTargetType"_s, sizeof(WebCore::MediaPlayerWirelessPlaybackTargetType), false, {
            enumValueForIPCTestAPI(WebCore::MediaPlayerWirelessPlaybackTargetType::TargetTypeNone),
            enumValueForIPCTestAPI(WebCore::MediaPlayerWirelessPlaybackTargetType::TargetTypeAirPlay),
            enumValueForIPCTestAPI(WebCore::MediaPlayerWirelessPlaybackTargetType::TargetTypeTVOut),
        } },
        { "WebCore::MediaPlayerPitchCorrectionAlgorithm"_s, sizeof(WebCore::MediaPlayerPitchCorrectionAlgorithm), false, {
            enumValueForIPCTestAPI(WebCore::MediaPlayerPitchCorrectionAlgorithm::BestAllAround),
            enumValueForIPCTestAPI(WebCore::MediaPlayerPitchCorrectionAlgorithm::BestForMusic),
            enumValueForIPCTestAPI(WebCore::MediaPlayerPitchCorrectionAlgorithm::BestForSpeech),
        } },
        { "WebCore::MediaPlayerSoundStageSize"_s, sizeof(WebCore::MediaPlayerSoundStageSize), false, {
            enumValueForIPCTestAPI(WebCore::MediaPlayerSoundStageSize::Auto),
            enumValueForIPCTestAPI(WebCore::MediaPlayerSoundStageSize::Small),
            enumValueForIPCTestAPI(WebCore::MediaPlayerSoundStageSize::Medium),
            enumValueForIPCTestAPI(WebCore::MediaPlayerSoundStageSize::Large),
        } },
#if ENABLE(APP_HIGHLIGHTS)
        { "WebCore::CreateNewGroupForHighlight"_s, sizeof(WebCore::CreateNewGroupForHighlight), false, {
            0, 1
        } },
#endif
#if ENABLE(APP_HIGHLIGHTS)
        { "WebCore::HighlightRequestOriginatedInApp"_s, sizeof(WebCore::HighlightRequestOriginatedInApp), false, {
            0, 1
        } },
#endif
        { "WebCore::SpeechRecognitionUpdateType"_s, sizeof(WebCore::SpeechRecognitionUpdateType), false, {
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionUpdateType::Start),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionUpdateType::AudioStart),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionUpdateType::SoundStart),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionUpdateType::SpeechStart),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionUpdateType::SpeechEnd),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionUpdateType::SoundEnd),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionUpdateType::AudioEnd),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionUpdateType::Result),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionUpdateType::NoMatch),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionUpdateType::Error),
            enumValueForIPCTestAPI(WebCore::SpeechRecognitionUpdateType::End),
        } },
        { "WebCore::CompositeOperator"_s, sizeof(WebCore::CompositeOperator), false, {
            enumValueForIPCTestAPI(WebCore::CompositeOperator::Clear),
            enumValueForIPCTestAPI(WebCore::CompositeOperator::Copy),
            enumValueForIPCTestAPI(WebCore::CompositeOperator::SourceOver),
            enumValueForIPCTestAPI(WebCore::CompositeOperator::SourceIn),
            enumValueForIPCTestAPI(WebCore::CompositeOperator::SourceOut),
            enumValueForIPCTestAPI(WebCore::CompositeOperator::SourceAtop),
            enumValueForIPCTestAPI(WebCore::CompositeOperator::DestinationOver),
            enumValueForIPCTestAPI(WebCore::CompositeOperator::DestinationIn),
            enumValueForIPCTestAPI(WebCore::CompositeOperator::DestinationOut),
            enumValueForIPCTestAPI(WebCore::CompositeOperator::DestinationAtop),
            enumValueForIPCTestAPI(WebCore::CompositeOperator::XOR),
            enumValueForIPCTestAPI(WebCore::CompositeOperator::PlusDarker),
            enumValueForIPCTestAPI(WebCore::CompositeOperator::PlusLighter),
            enumValueForIPCTestAPI(WebCore::CompositeOperator::Difference),
        } },
        { "WebCore::BlendMode"_s, sizeof(WebCore::BlendMode), false, {
            enumValueForIPCTestAPI(WebCore::BlendMode::Normal),
            enumValueForIPCTestAPI(WebCore::BlendMode::Multiply),
            enumValueForIPCTestAPI(WebCore::BlendMode::Screen),
            enumValueForIPCTestAPI(WebCore::BlendMode::Darken),
            enumValueForIPCTestAPI(WebCore::BlendMode::Lighten),
            enumValueForIPCTestAPI(WebCore::BlendMode::Overlay),
            enumValueForIPCTestAPI(WebCore::BlendMode::ColorDodge),
            enumValueForIPCTestAPI(WebCore::BlendMode::ColorBurn),
            enumValueForIPCTestAPI(WebCore::BlendMode::HardLight),
            enumValueForIPCTestAPI(WebCore::BlendMode::SoftLight),
            enumValueForIPCTestAPI(WebCore::BlendMode::Difference),
            enumValueForIPCTestAPI(WebCore::BlendMode::Exclusion),
            enumValueForIPCTestAPI(WebCore::BlendMode::Hue),
            enumValueForIPCTestAPI(WebCore::BlendMode::Saturation),
            enumValueForIPCTestAPI(WebCore::BlendMode::Color),
            enumValueForIPCTestAPI(WebCore::BlendMode::Luminosity),
            enumValueForIPCTestAPI(WebCore::BlendMode::PlusDarker),
            enumValueForIPCTestAPI(WebCore::BlendMode::PlusLighter),
        } },
        { "WebCore::GradientSpreadMethod"_s, sizeof(WebCore::GradientSpreadMethod), false, {
            enumValueForIPCTestAPI(WebCore::GradientSpreadMethod::Pad),
            enumValueForIPCTestAPI(WebCore::GradientSpreadMethod::Reflect),
            enumValueForIPCTestAPI(WebCore::GradientSpreadMethod::Repeat),
        } },
        { "WebCore::InterpolationQuality"_s, sizeof(WebCore::InterpolationQuality), false, {
            enumValueForIPCTestAPI(WebCore::InterpolationQuality::Default),
            enumValueForIPCTestAPI(WebCore::InterpolationQuality::DoNotInterpolate),
            enumValueForIPCTestAPI(WebCore::InterpolationQuality::Low),
            enumValueForIPCTestAPI(WebCore::InterpolationQuality::Medium),
            enumValueForIPCTestAPI(WebCore::InterpolationQuality::High),
        } },
#if ENABLE(VIDEO)
        { "WebCore::VideoFrameRotation"_s, sizeof(WebCore::VideoFrameRotation), false, {
            enumValueForIPCTestAPI(WebCore::VideoFrameRotation::None),
            enumValueForIPCTestAPI(WebCore::VideoFrameRotation::UpsideDown),
            enumValueForIPCTestAPI(WebCore::VideoFrameRotation::Right),
            enumValueForIPCTestAPI(WebCore::VideoFrameRotation::Left),
        } },
#endif
        { "WebCore::PreserveResolution"_s, sizeof(WebCore::PreserveResolution), false, {
            0, 1
        } },
        { "WebCore::ColorInterpolationColorSpace"_s, sizeof(WebCore::ColorInterpolationColorSpace), false, {
            enumValueForIPCTestAPI(WebCore::ColorInterpolationColorSpace::HSL),
            enumValueForIPCTestAPI(WebCore::ColorInterpolationColorSpace::HWB),
            enumValueForIPCTestAPI(WebCore::ColorInterpolationColorSpace::LCH),
            enumValueForIPCTestAPI(WebCore::ColorInterpolationColorSpace::Lab),
            enumValueForIPCTestAPI(WebCore::ColorInterpolationColorSpace::OKLCH),
            enumValueForIPCTestAPI(WebCore::ColorInterpolationColorSpace::OKLab),
            enumValueForIPCTestAPI(WebCore::ColorInterpolationColorSpace::SRGB),
            enumValueForIPCTestAPI(WebCore::ColorInterpolationColorSpace::SRGBLinear),
            enumValueForIPCTestAPI(WebCore::ColorInterpolationColorSpace::DisplayP3),
            enumValueForIPCTestAPI(WebCore::ColorInterpolationColorSpace::A98RGB),
            enumValueForIPCTestAPI(WebCore::ColorInterpolationColorSpace::ProPhotoRGB),
            enumValueForIPCTestAPI(WebCore::ColorInterpolationColorSpace::Rec2020),
            enumValueForIPCTestAPI(WebCore::ColorInterpolationColorSpace::XYZD50),
            enumValueForIPCTestAPI(WebCore::ColorInterpolationColorSpace::XYZD65),
        } },
        { "WebCore::HueInterpolationMethod"_s, sizeof(WebCore::HueInterpolationMethod), false, {
            enumValueForIPCTestAPI(WebCore::HueInterpolationMethod::Shorter),
            enumValueForIPCTestAPI(WebCore::HueInterpolationMethod::Longer),
            enumValueForIPCTestAPI(WebCore::HueInterpolationMethod::Increasing),
            enumValueForIPCTestAPI(WebCore::HueInterpolationMethod::Decreasing),
        } },
#if USE(AUDIO_SESSION)
        { "WebCore::RouteSharingPolicy"_s, sizeof(WebCore::RouteSharingPolicy), false, {
            enumValueForIPCTestAPI(WebCore::RouteSharingPolicy::Default),
            enumValueForIPCTestAPI(WebCore::RouteSharingPolicy::LongFormAudio),
            enumValueForIPCTestAPI(WebCore::RouteSharingPolicy::Independent),
            enumValueForIPCTestAPI(WebCore::RouteSharingPolicy::LongFormVideo),
        } },
#endif
#if USE(AUDIO_SESSION)
        { "WebCore::AudioSessionCategory"_s, sizeof(WebCore::AudioSessionCategory), false, {
            enumValueForIPCTestAPI(WebCore::AudioSessionCategory::None),
            enumValueForIPCTestAPI(WebCore::AudioSessionCategory::AmbientSound),
            enumValueForIPCTestAPI(WebCore::AudioSessionCategory::SoloAmbientSound),
            enumValueForIPCTestAPI(WebCore::AudioSessionCategory::MediaPlayback),
            enumValueForIPCTestAPI(WebCore::AudioSessionCategory::RecordAudio),
            enumValueForIPCTestAPI(WebCore::AudioSessionCategory::PlayAndRecord),
            enumValueForIPCTestAPI(WebCore::AudioSessionCategory::AudioProcessing),
        } },
#endif
#if USE(AUDIO_SESSION)
        { "WebCore::AudioSessionMode"_s, sizeof(WebCore::AudioSessionMode), false, {
            enumValueForIPCTestAPI(WebCore::AudioSessionMode::Default),
            enumValueForIPCTestAPI(WebCore::AudioSessionMode::VideoChat),
            enumValueForIPCTestAPI(WebCore::AudioSessionMode::MoviePlayback),
        } },
#endif
#if USE(AUDIO_SESSION)
        { "WebCore::AudioSessionSoundStageSize"_s, sizeof(WebCore::AudioSessionSoundStageSize), false, {
            enumValueForIPCTestAPI(WebCore::AudioSessionSoundStageSize::Automatic),
            enumValueForIPCTestAPI(WebCore::AudioSessionSoundStageSize::Small),
            enumValueForIPCTestAPI(WebCore::AudioSessionSoundStageSize::Medium),
            enumValueForIPCTestAPI(WebCore::AudioSessionSoundStageSize::Large),
        } },
#endif
#if USE(AUDIO_SESSION)
        { "WebCore::AudioSessionMayResume"_s, sizeof(WebCore::AudioSessionMayResume), false, {
            0, 1
        } },
#endif
#if USE(AUDIO_SESSION)
        { "WebCore::AudioSessionRoutingArbitrationError"_s, sizeof(WebCore::AudioSessionRoutingArbitrationError), false, {
            enumValueForIPCTestAPI(WebCore::AudioSessionRoutingArbitrationError::None),
            enumValueForIPCTestAPI(WebCore::AudioSessionRoutingArbitrationError::Failed),
            enumValueForIPCTestAPI(WebCore::AudioSessionRoutingArbitrationError::Cancelled),
        } },
#endif
#if USE(AUDIO_SESSION)
        { "WebCore::AudioSessionRoutingArbitrationClient::DefaultRouteChanged"_s, sizeof(WebCore::AudioSessionRoutingArbitrationClient::DefaultRouteChanged), false, {
            0, 1
        } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
        { "WebCore::CDMKeyStatus"_s, sizeof(WebCore::CDMKeyStatus), false, {
            enumValueForIPCTestAPI(WebCore::CDMKeyStatus::Usable),
            enumValueForIPCTestAPI(WebCore::CDMKeyStatus::Expired),
            enumValueForIPCTestAPI(WebCore::CDMKeyStatus::Released),
            enumValueForIPCTestAPI(WebCore::CDMKeyStatus::OutputRestricted),
            enumValueForIPCTestAPI(WebCore::CDMKeyStatus::OutputDownscaled),
            enumValueForIPCTestAPI(WebCore::CDMKeyStatus::StatusPending),
            enumValueForIPCTestAPI(WebCore::CDMKeyStatus::InternalError),
        } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
        { "WebCore::CDMMessageType"_s, sizeof(WebCore::CDMMessageType), false, {
            enumValueForIPCTestAPI(WebCore::CDMMessageType::LicenseRequest),
            enumValueForIPCTestAPI(WebCore::CDMMessageType::LicenseRenewal),
            enumValueForIPCTestAPI(WebCore::CDMMessageType::LicenseRelease),
            enumValueForIPCTestAPI(WebCore::CDMMessageType::IndividualizationRequest),
        } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
        { "WebCore::CDMRequirement"_s, sizeof(WebCore::CDMRequirement), false, {
            enumValueForIPCTestAPI(WebCore::CDMRequirement::Required),
            enumValueForIPCTestAPI(WebCore::CDMRequirement::Optional),
            enumValueForIPCTestAPI(WebCore::CDMRequirement::NotAllowed),
        } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
        { "WebCore::CDMInstanceSessionLoadFailure"_s, sizeof(WebCore::CDMInstanceSessionLoadFailure), false, {
            enumValueForIPCTestAPI(WebCore::CDMInstanceSessionLoadFailure::None),
            enumValueForIPCTestAPI(WebCore::CDMInstanceSessionLoadFailure::NoSessionData),
            enumValueForIPCTestAPI(WebCore::CDMInstanceSessionLoadFailure::MismatchedSessionType),
            enumValueForIPCTestAPI(WebCore::CDMInstanceSessionLoadFailure::QuotaExceeded),
            enumValueForIPCTestAPI(WebCore::CDMInstanceSessionLoadFailure::Other),
        } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
        { "WebCore::CDMInstanceHDCPStatus"_s, sizeof(WebCore::CDMInstanceHDCPStatus), false, {
            enumValueForIPCTestAPI(WebCore::CDMInstanceHDCPStatus::Unknown),
            enumValueForIPCTestAPI(WebCore::CDMInstanceHDCPStatus::Valid),
            enumValueForIPCTestAPI(WebCore::CDMInstanceHDCPStatus::OutputRestricted),
            enumValueForIPCTestAPI(WebCore::CDMInstanceHDCPStatus::OutputDownscaled),
        } },
#endif
#if ENABLE(WEB_RTC)
        { "WebCore::RTCDataChannelState"_s, sizeof(WebCore::RTCDataChannelState), false, {
            enumValueForIPCTestAPI(WebCore::RTCDataChannelState::Connecting),
            enumValueForIPCTestAPI(WebCore::RTCDataChannelState::Open),
            enumValueForIPCTestAPI(WebCore::RTCDataChannelState::Closing),
            enumValueForIPCTestAPI(WebCore::RTCDataChannelState::Closed),
        } },
#endif
#if ENABLE(WEB_RTC)
        { "WebCore::RTCPriorityType"_s, sizeof(WebCore::RTCPriorityType), false, {
            enumValueForIPCTestAPI(WebCore::RTCPriorityType::VeryLow),
            enumValueForIPCTestAPI(WebCore::RTCPriorityType::Low),
            enumValueForIPCTestAPI(WebCore::RTCPriorityType::Medium),
            enumValueForIPCTestAPI(WebCore::RTCPriorityType::High),
        } },
#endif
        { "WebCore::LineCap"_s, sizeof(WebCore::LineCap), false, {
            enumValueForIPCTestAPI(WebCore::LineCap::Butt),
            enumValueForIPCTestAPI(WebCore::LineCap::Round),
            enumValueForIPCTestAPI(WebCore::LineCap::Square),
        } },
        { "WebCore::LineJoin"_s, sizeof(WebCore::LineJoin), false, {
            enumValueForIPCTestAPI(WebCore::LineJoin::Miter),
            enumValueForIPCTestAPI(WebCore::LineJoin::Round),
            enumValueForIPCTestAPI(WebCore::LineJoin::Bevel),
        } },
        { "WebCore::StrokeStyle"_s, sizeof(WebCore::StrokeStyle), false, {
            enumValueForIPCTestAPI(WebCore::StrokeStyle::NoStroke),
            enumValueForIPCTestAPI(WebCore::StrokeStyle::SolidStroke),
            enumValueForIPCTestAPI(WebCore::StrokeStyle::DottedStroke),
            enumValueForIPCTestAPI(WebCore::StrokeStyle::DashedStroke),
            enumValueForIPCTestAPI(WebCore::StrokeStyle::DoubleStroke),
            enumValueForIPCTestAPI(WebCore::StrokeStyle::WavyStroke),
        } },
        { "WebCore::TextDrawingMode"_s, sizeof(WebCore::TextDrawingMode), true, {
            enumValueForIPCTestAPI(WebCore::TextDrawingMode::Fill),
            enumValueForIPCTestAPI(WebCore::TextDrawingMode::Stroke),
        } },
        { "WebCore::DecodingMode"_s, sizeof(WebCore::DecodingMode), false, {
            enumValueForIPCTestAPI(WebCore::DecodingMode::Auto),
            enumValueForIPCTestAPI(WebCore::DecodingMode::Synchronous),
            enumValueForIPCTestAPI(WebCore::DecodingMode::Asynchronous),
        } },
        { "WebCore::DocumentMarkerLineStyleMode"_s, sizeof(WebCore::DocumentMarkerLineStyleMode), false, {
            enumValueForIPCTestAPI(WebCore::DocumentMarkerLineStyleMode::TextCheckingDictationPhraseWithAlternatives),
            enumValueForIPCTestAPI(WebCore::DocumentMarkerLineStyleMode::Spelling),
            enumValueForIPCTestAPI(WebCore::DocumentMarkerLineStyleMode::Grammar),
            enumValueForIPCTestAPI(WebCore::DocumentMarkerLineStyleMode::AutocorrectionReplacement),
            enumValueForIPCTestAPI(WebCore::DocumentMarkerLineStyleMode::DictationAlternatives),
        } },
        { "WebCore::ShadowRadiusMode"_s, sizeof(WebCore::ShadowRadiusMode), false, {
            0, 1
        } },
#if ENABLE(VIDEO)
        { "WebCore::GenericCueData::Alignment"_s, sizeof(WebCore::GenericCueData::Alignment), false, {
            enumValueForIPCTestAPI(WebCore::GenericCueData::Alignment::None),
            enumValueForIPCTestAPI(WebCore::GenericCueData::Alignment::Start),
            enumValueForIPCTestAPI(WebCore::GenericCueData::Alignment::Middle),
            enumValueForIPCTestAPI(WebCore::GenericCueData::Alignment::End),
        } },
#endif
#if ENABLE(VIDEO)
        { "WebCore::GenericCueData::Status"_s, sizeof(WebCore::GenericCueData::Status), false, {
            enumValueForIPCTestAPI(WebCore::GenericCueData::Status::Uninitialized),
            enumValueForIPCTestAPI(WebCore::GenericCueData::Status::Partial),
            enumValueForIPCTestAPI(WebCore::GenericCueData::Status::Complete),
        } },
#endif
        { "WebCore::ImageOrientation::Orientation"_s, sizeof(WebCore::ImageOrientation::Orientation), false, {
            enumValueForIPCTestAPI(WebCore::ImageOrientation::Orientation::FromImage),
            enumValueForIPCTestAPI(WebCore::ImageOrientation::Orientation::OriginTopLeft),
            enumValueForIPCTestAPI(WebCore::ImageOrientation::Orientation::OriginTopRight),
            enumValueForIPCTestAPI(WebCore::ImageOrientation::Orientation::OriginBottomRight),
            enumValueForIPCTestAPI(WebCore::ImageOrientation::Orientation::OriginBottomLeft),
            enumValueForIPCTestAPI(WebCore::ImageOrientation::Orientation::OriginLeftTop),
            enumValueForIPCTestAPI(WebCore::ImageOrientation::Orientation::OriginRightTop),
            enumValueForIPCTestAPI(WebCore::ImageOrientation::Orientation::OriginRightBottom),
            enumValueForIPCTestAPI(WebCore::ImageOrientation::Orientation::OriginLeftBottom),
        } },
        { "WebCore::DrawsHDRContent"_s, sizeof(WebCore::DrawsHDRContent), false, {
            enumValueForIPCTestAPI(WebCore::DrawsHDRContent::No),
            enumValueForIPCTestAPI(WebCore::DrawsHDRContent::Yes),
        } },
        { "WebCore::CrossOriginOpenerPolicyValue"_s, sizeof(WebCore::CrossOriginOpenerPolicyValue), false, {
            enumValueForIPCTestAPI(WebCore::CrossOriginOpenerPolicyValue::UnsafeNone),
            enumValueForIPCTestAPI(WebCore::CrossOriginOpenerPolicyValue::SameOrigin),
            enumValueForIPCTestAPI(WebCore::CrossOriginOpenerPolicyValue::SameOriginPlusCOEP),
            enumValueForIPCTestAPI(WebCore::CrossOriginOpenerPolicyValue::SameOriginAllowPopups),
            enumValueForIPCTestAPI(WebCore::CrossOriginOpenerPolicyValue::NoopenerAllowPopups),
        } },
        { "WebCore::SubstituteData::SessionHistoryVisibility"_s, sizeof(WebCore::SubstituteData::SessionHistoryVisibility), false, {
            0, 1
        } },
        { "WebCore::HTTPCookieAcceptPolicy"_s, sizeof(WebCore::HTTPCookieAcceptPolicy), false, {
            enumValueForIPCTestAPI(WebCore::HTTPCookieAcceptPolicy::AlwaysAccept),
            enumValueForIPCTestAPI(WebCore::HTTPCookieAcceptPolicy::Never),
            enumValueForIPCTestAPI(WebCore::HTTPCookieAcceptPolicy::OnlyFromMainDocumentDomain),
            enumValueForIPCTestAPI(WebCore::HTTPCookieAcceptPolicy::ExclusivelyFromMainDocumentDomain),
        } },
        { "WebCore::NetworkLoadPriority"_s, sizeof(WebCore::NetworkLoadPriority), false, {
            enumValueForIPCTestAPI(WebCore::NetworkLoadPriority::Low),
            enumValueForIPCTestAPI(WebCore::NetworkLoadPriority::Medium),
            enumValueForIPCTestAPI(WebCore::NetworkLoadPriority::High),
            enumValueForIPCTestAPI(WebCore::NetworkLoadPriority::Unknown),
        } },
        { "WebCore::PrivacyStance"_s, sizeof(WebCore::PrivacyStance), false, {
            enumValueForIPCTestAPI(WebCore::PrivacyStance::Unknown),
            enumValueForIPCTestAPI(WebCore::PrivacyStance::NotEligible),
            enumValueForIPCTestAPI(WebCore::PrivacyStance::Proxied),
            enumValueForIPCTestAPI(WebCore::PrivacyStance::Failed),
            enumValueForIPCTestAPI(WebCore::PrivacyStance::Direct),
            enumValueForIPCTestAPI(WebCore::PrivacyStance::FailedUnreachable),
        } },
        { "WebCore::ThirdPartyCookieBlockingMode"_s, sizeof(WebCore::ThirdPartyCookieBlockingMode), false, {
            enumValueForIPCTestAPI(WebCore::ThirdPartyCookieBlockingMode::All),
            enumValueForIPCTestAPI(WebCore::ThirdPartyCookieBlockingMode::AllExceptBetweenAppBoundDomains),
            enumValueForIPCTestAPI(WebCore::ThirdPartyCookieBlockingMode::AllExceptManagedDomains),
#if HAVE(ALLOW_ONLY_PARTITIONED_COOKIES)
            enumValueForIPCTestAPI(WebCore::ThirdPartyCookieBlockingMode::AllExceptPartitioned),
#endif
            enumValueForIPCTestAPI(WebCore::ThirdPartyCookieBlockingMode::AllOnSitesWithoutUserInteraction),
            enumValueForIPCTestAPI(WebCore::ThirdPartyCookieBlockingMode::OnlyAccordingToPerDomainPolicy),
        } },
        { "WebCore::FirstPartyWebsiteDataRemovalMode"_s, sizeof(WebCore::FirstPartyWebsiteDataRemovalMode), false, {
            enumValueForIPCTestAPI(WebCore::FirstPartyWebsiteDataRemovalMode::AllButCookies),
            enumValueForIPCTestAPI(WebCore::FirstPartyWebsiteDataRemovalMode::None),
            enumValueForIPCTestAPI(WebCore::FirstPartyWebsiteDataRemovalMode::AllButCookiesLiveOnTestingTimeout),
            enumValueForIPCTestAPI(WebCore::FirstPartyWebsiteDataRemovalMode::AllButCookiesReproTestingTimeout),
        } },
        { "WebCore::DragApplicationFlags"_s, sizeof(WebCore::DragApplicationFlags), true, {
            enumValueForIPCTestAPI(WebCore::DragApplicationFlags::IsModal),
            enumValueForIPCTestAPI(WebCore::DragApplicationFlags::IsSource),
            enumValueForIPCTestAPI(WebCore::DragApplicationFlags::HasAttachedSheet),
            enumValueForIPCTestAPI(WebCore::DragApplicationFlags::IsCopyKeyDown),
        } },
        { "WebCore::TextCheckingType"_s, sizeof(WebCore::TextCheckingType), true, {
            enumValueForIPCTestAPI(WebCore::TextCheckingType::None),
            enumValueForIPCTestAPI(WebCore::TextCheckingType::Spelling),
            enumValueForIPCTestAPI(WebCore::TextCheckingType::Grammar),
            enumValueForIPCTestAPI(WebCore::TextCheckingType::Link),
            enumValueForIPCTestAPI(WebCore::TextCheckingType::Quote),
            enumValueForIPCTestAPI(WebCore::TextCheckingType::Dash),
            enumValueForIPCTestAPI(WebCore::TextCheckingType::Replacement),
            enumValueForIPCTestAPI(WebCore::TextCheckingType::Correction),
            enumValueForIPCTestAPI(WebCore::TextCheckingType::ShowCorrectionPanel),
        } },
        { "WebCore::ServiceWorkerClientType"_s, sizeof(WebCore::ServiceWorkerClientType), false, {
            enumValueForIPCTestAPI(WebCore::ServiceWorkerClientType::Window),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerClientType::Worker),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerClientType::Sharedworker),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerClientType::All),
        } },
        { "WebCore::ServiceWorkerJobType"_s, sizeof(WebCore::ServiceWorkerJobType), false, {
            enumValueForIPCTestAPI(WebCore::ServiceWorkerJobType::Register),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerJobType::Unregister),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerJobType::Update),
        } },
        { "WebCore::ServiceWorkerRegistrationState"_s, sizeof(WebCore::ServiceWorkerRegistrationState), false, {
            enumValueForIPCTestAPI(WebCore::ServiceWorkerRegistrationState::Installing),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerRegistrationState::Waiting),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerRegistrationState::Active),
        } },
        { "WebCore::ServiceWorkerState"_s, sizeof(WebCore::ServiceWorkerState), false, {
            enumValueForIPCTestAPI(WebCore::ServiceWorkerState::Parsed),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerState::Installing),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerState::Installed),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerState::Activating),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerState::Activated),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerState::Redundant),
        } },
        { "WebCore::ServiceWorkerClientFrameType"_s, sizeof(WebCore::ServiceWorkerClientFrameType), false, {
            enumValueForIPCTestAPI(WebCore::ServiceWorkerClientFrameType::Auxiliary),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerClientFrameType::TopLevel),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerClientFrameType::Nested),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerClientFrameType::None),
        } },
        { "WebCore::ServiceWorkerIsInspectable"_s, sizeof(WebCore::ServiceWorkerIsInspectable), false, {
            0, 1
        } },
        { "WebCore::ShouldNotifyWhenResolved"_s, sizeof(WebCore::ShouldNotifyWhenResolved), false, {
            0, 1
        } },
        { "WebCore::ServiceWorkerUpdateViaCache"_s, sizeof(WebCore::ServiceWorkerUpdateViaCache), false, {
            enumValueForIPCTestAPI(WebCore::ServiceWorkerUpdateViaCache::Imports),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerUpdateViaCache::All),
            enumValueForIPCTestAPI(WebCore::ServiceWorkerUpdateViaCache::None),
        } },
        { "WebCore::LastNavigationWasAppInitiated"_s, sizeof(WebCore::LastNavigationWasAppInitiated), false, {
            0, 1
        } },
        { "WebCore::RouterSourceEnum"_s, sizeof(WebCore::RouterSourceEnum), false, {
            enumValueForIPCTestAPI(WebCore::RouterSourceEnum::Cache),
            enumValueForIPCTestAPI(WebCore::RouterSourceEnum::FetchEvent),
            enumValueForIPCTestAPI(WebCore::RouterSourceEnum::Network),
        } },
        { "WebCore::RunningStatus"_s, sizeof(WebCore::RunningStatus), false, {
            0, 1
        } },
        { "WebCore::StorageAccessWasGranted"_s, sizeof(WebCore::StorageAccessWasGranted), false, {
            enumValueForIPCTestAPI(WebCore::StorageAccessWasGranted::No),
            enumValueForIPCTestAPI(WebCore::StorageAccessWasGranted::Yes),
            enumValueForIPCTestAPI(WebCore::StorageAccessWasGranted::YesWithException),
        } },
        { "WebCore::StorageAccessPromptWasShown"_s, sizeof(WebCore::StorageAccessPromptWasShown), false, {
            0, 1
        } },
        { "WebCore::StorageAccessScope"_s, sizeof(WebCore::StorageAccessScope), false, {
            0, 1
        } },
        { "WebCore::StorageAccessQuickResult"_s, sizeof(WebCore::StorageAccessQuickResult), false, {
            0, 1
        } },
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MediaConstraint::DataType"_s, sizeof(WebCore::MediaConstraint::DataType), false, {
            enumValueForIPCTestAPI(WebCore::MediaConstraint::DataType::Integer),
            enumValueForIPCTestAPI(WebCore::MediaConstraint::DataType::Double),
            enumValueForIPCTestAPI(WebCore::MediaConstraint::DataType::Boolean),
            enumValueForIPCTestAPI(WebCore::MediaConstraint::DataType::String),
        } },
#endif
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MediaConstraintType"_s, sizeof(WebCore::MediaConstraintType), false, {
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::Unknown),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::Width),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::Height),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::AspectRatio),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::FrameRate),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::FacingMode),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::Volume),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::SampleRate),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::SampleSize),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::EchoCancellation),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::DeviceId),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::GroupId),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::DisplaySurface),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::LogicalSurface),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::WhiteBalanceMode),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::Zoom),
            enumValueForIPCTestAPI(WebCore::MediaConstraintType::Torch),
        } },
#endif
#if ENABLE(MEDIA_STREAM)
        { "WebCore::RealtimeMediaSource::Type"_s, sizeof(WebCore::RealtimeMediaSource::Type), false, {
            0, 1
        } },
#endif
#if ENABLE(MEDIA_STREAM)
        { "WebCore::VideoFacingMode"_s, sizeof(WebCore::VideoFacingMode), false, {
            enumValueForIPCTestAPI(WebCore::VideoFacingMode::Unknown),
            enumValueForIPCTestAPI(WebCore::VideoFacingMode::User),
            enumValueForIPCTestAPI(WebCore::VideoFacingMode::Environment),
            enumValueForIPCTestAPI(WebCore::VideoFacingMode::Left),
            enumValueForIPCTestAPI(WebCore::VideoFacingMode::Right),
        } },
#endif
#if ENABLE(MEDIA_STREAM)
        { "WebCore::DisplaySurfaceType"_s, sizeof(WebCore::DisplaySurfaceType), false, {
            enumValueForIPCTestAPI(WebCore::DisplaySurfaceType::Monitor),
            enumValueForIPCTestAPI(WebCore::DisplaySurfaceType::Window),
            enumValueForIPCTestAPI(WebCore::DisplaySurfaceType::Application),
            enumValueForIPCTestAPI(WebCore::DisplaySurfaceType::Browser),
            enumValueForIPCTestAPI(WebCore::DisplaySurfaceType::Invalid),
        } },
#endif
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MeteringMode"_s, sizeof(WebCore::MeteringMode), false, {
            enumValueForIPCTestAPI(WebCore::MeteringMode::None),
            enumValueForIPCTestAPI(WebCore::MeteringMode::Manual),
            enumValueForIPCTestAPI(WebCore::MeteringMode::SingleShot),
            enumValueForIPCTestAPI(WebCore::MeteringMode::Continuous),
        } },
#endif
#if ENABLE(MEDIA_STREAM)
        { "WebCore::CaptureDevice::DeviceType"_s, sizeof(WebCore::CaptureDevice::DeviceType), false, {
            enumValueForIPCTestAPI(WebCore::CaptureDevice::DeviceType::Unknown),
            enumValueForIPCTestAPI(WebCore::CaptureDevice::DeviceType::Microphone),
            enumValueForIPCTestAPI(WebCore::CaptureDevice::DeviceType::Speaker),
            enumValueForIPCTestAPI(WebCore::CaptureDevice::DeviceType::Camera),
            enumValueForIPCTestAPI(WebCore::CaptureDevice::DeviceType::Screen),
            enumValueForIPCTestAPI(WebCore::CaptureDevice::DeviceType::Window),
            enumValueForIPCTestAPI(WebCore::CaptureDevice::DeviceType::SystemAudio),
        } },
#endif
#if ENABLE(MEDIA_STREAM)
        { "WebCore::RealtimeMediaSourceCapabilities::EchoCancellation"_s, sizeof(WebCore::RealtimeMediaSourceCapabilities::EchoCancellation), false, {
            enumValueForIPCTestAPI(WebCore::RealtimeMediaSourceCapabilities::EchoCancellation::Off),
            enumValueForIPCTestAPI(WebCore::RealtimeMediaSourceCapabilities::EchoCancellation::On),
            enumValueForIPCTestAPI(WebCore::RealtimeMediaSourceCapabilities::EchoCancellation::OnOrOff),
        } },
#endif
#if ENABLE(MEDIA_STREAM)
        { "WebCore::RealtimeMediaSourceCapabilities::BackgroundBlur"_s, sizeof(WebCore::RealtimeMediaSourceCapabilities::BackgroundBlur), false, {
            enumValueForIPCTestAPI(WebCore::RealtimeMediaSourceCapabilities::BackgroundBlur::Off),
            enumValueForIPCTestAPI(WebCore::RealtimeMediaSourceCapabilities::BackgroundBlur::On),
            enumValueForIPCTestAPI(WebCore::RealtimeMediaSourceCapabilities::BackgroundBlur::OnOff),
        } },
#endif
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MockMediaDevice::Flag"_s, sizeof(WebCore::MockMediaDevice::Flag), true, {
            enumValueForIPCTestAPI(WebCore::MockMediaDevice::Flag::Ephemeral),
            enumValueForIPCTestAPI(WebCore::MockMediaDevice::Flag::Invalid),
        } },
#endif
        { "WebCore::PlatformVideoColorPrimaries"_s, sizeof(WebCore::PlatformVideoColorPrimaries), false, {
            enumValueForIPCTestAPI(WebCore::PlatformVideoColorPrimaries::Bt709),
            enumValueForIPCTestAPI(WebCore::PlatformVideoColorPrimaries::Bt470bg),
            enumValueForIPCTestAPI(WebCore::PlatformVideoColorPrimaries::Smpte170m),
            enumValueForIPCTestAPI(WebCore::PlatformVideoColorPrimaries::Bt470m),
            enumValueForIPCTestAPI(WebCore::PlatformVideoColorPrimaries::Smpte240m),
            enumValueForIPCTestAPI(WebCore::PlatformVideoColorPrimaries::Film),
            enumValueForIPCTestAPI(WebCore::PlatformVideoColorPrimaries::Bt2020),
            enumValueForIPCTestAPI(WebCore::PlatformVideoColorPrimaries::SmpteSt4281),
            enumValueForIPCTestAPI(WebCore::PlatformVideoColorPrimaries::SmpteRp431),
            enumValueForIPCTestAPI(WebCore::PlatformVideoColorPrimaries::SmpteEg432),
            enumValueForIPCTestAPI(WebCore::PlatformVideoColorPrimaries::JedecP22Phosphors),
            enumValueForIPCTestAPI(WebCore::PlatformVideoColorPrimaries::Unspecified),
        } },
        { "WebCore::PlatformVideoTransferCharacteristics"_s, sizeof(WebCore::PlatformVideoTransferCharacteristics), false, {
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::Bt709),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::Smpte170m),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::Iec6196621),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::Gamma22curve),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::Gamma28curve),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::Smpte240m),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::Linear),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::Log),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::LogSqrt),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::Iec6196624),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::Bt1361ExtendedColourGamut),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::Bt2020_10bit),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::Bt2020_12bit),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::SmpteSt2084),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::SmpteSt4281),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::AribStdB67Hlg),
            enumValueForIPCTestAPI(WebCore::PlatformVideoTransferCharacteristics::Unspecified),
        } },
        { "WebCore::PlatformVideoMatrixCoefficients"_s, sizeof(WebCore::PlatformVideoMatrixCoefficients), false, {
            enumValueForIPCTestAPI(WebCore::PlatformVideoMatrixCoefficients::Rgb),
            enumValueForIPCTestAPI(WebCore::PlatformVideoMatrixCoefficients::Bt709),
            enumValueForIPCTestAPI(WebCore::PlatformVideoMatrixCoefficients::Bt470bg),
            enumValueForIPCTestAPI(WebCore::PlatformVideoMatrixCoefficients::Smpte170m),
            enumValueForIPCTestAPI(WebCore::PlatformVideoMatrixCoefficients::Smpte240m),
            enumValueForIPCTestAPI(WebCore::PlatformVideoMatrixCoefficients::Fcc),
            enumValueForIPCTestAPI(WebCore::PlatformVideoMatrixCoefficients::YCgCo),
            enumValueForIPCTestAPI(WebCore::PlatformVideoMatrixCoefficients::Bt2020NonconstantLuminance),
            enumValueForIPCTestAPI(WebCore::PlatformVideoMatrixCoefficients::Bt2020ConstantLuminance),
            enumValueForIPCTestAPI(WebCore::PlatformVideoMatrixCoefficients::Unspecified),
        } },
#if ENABLE(VIDEO)
        { "WebCore::VideoProjectionMetadataKind"_s, sizeof(WebCore::VideoProjectionMetadataKind), false, {
            enumValueForIPCTestAPI(WebCore::VideoProjectionMetadataKind::Unknown),
            enumValueForIPCTestAPI(WebCore::VideoProjectionMetadataKind::Equirectangular),
            enumValueForIPCTestAPI(WebCore::VideoProjectionMetadataKind::HalfEquirectangular),
            enumValueForIPCTestAPI(WebCore::VideoProjectionMetadataKind::EquiAngularCubemap),
            enumValueForIPCTestAPI(WebCore::VideoProjectionMetadataKind::Parametric),
            enumValueForIPCTestAPI(WebCore::VideoProjectionMetadataKind::Pyramid),
            enumValueForIPCTestAPI(WebCore::VideoProjectionMetadataKind::AppleImmersiveVideo),
        } },
#endif
        { "WebCore::PolicyAction"_s, sizeof(WebCore::PolicyAction), false, {
            enumValueForIPCTestAPI(WebCore::PolicyAction::Use),
            enumValueForIPCTestAPI(WebCore::PolicyAction::Download),
            enumValueForIPCTestAPI(WebCore::PolicyAction::Ignore),
            enumValueForIPCTestAPI(WebCore::PolicyAction::LoadWillContinueInAnotherProcess),
        } },
        { "WebCore::ReloadOption"_s, sizeof(WebCore::ReloadOption), true, {
            enumValueForIPCTestAPI(WebCore::ReloadOption::ExpiredOnly),
            enumValueForIPCTestAPI(WebCore::ReloadOption::FromOrigin),
            enumValueForIPCTestAPI(WebCore::ReloadOption::DisableContentBlockers),
        } },
        { "WebCore::FrameLoadType"_s, sizeof(WebCore::FrameLoadType), false, {
            enumValueForIPCTestAPI(WebCore::FrameLoadType::Standard),
            enumValueForIPCTestAPI(WebCore::FrameLoadType::Back),
            enumValueForIPCTestAPI(WebCore::FrameLoadType::Forward),
            enumValueForIPCTestAPI(WebCore::FrameLoadType::IndexedBackForward),
            enumValueForIPCTestAPI(WebCore::FrameLoadType::Reload),
            enumValueForIPCTestAPI(WebCore::FrameLoadType::Same),
            enumValueForIPCTestAPI(WebCore::FrameLoadType::RedirectWithLockedBackForwardList),
            enumValueForIPCTestAPI(WebCore::FrameLoadType::Replace),
            enumValueForIPCTestAPI(WebCore::FrameLoadType::ReloadFromOrigin),
            enumValueForIPCTestAPI(WebCore::FrameLoadType::ReloadExpiredOnly),
        } },
        { "WebCore::NavigationType"_s, sizeof(WebCore::NavigationType), false, {
            enumValueForIPCTestAPI(WebCore::NavigationType::LinkClicked),
            enumValueForIPCTestAPI(WebCore::NavigationType::FormSubmitted),
            enumValueForIPCTestAPI(WebCore::NavigationType::BackForward),
            enumValueForIPCTestAPI(WebCore::NavigationType::Reload),
            enumValueForIPCTestAPI(WebCore::NavigationType::FormResubmitted),
            enumValueForIPCTestAPI(WebCore::NavigationType::Other),
        } },
        { "WebCore::BrowsingContextGroupSwitchDecision"_s, sizeof(WebCore::BrowsingContextGroupSwitchDecision), false, {
            enumValueForIPCTestAPI(WebCore::BrowsingContextGroupSwitchDecision::StayInGroup),
            enumValueForIPCTestAPI(WebCore::BrowsingContextGroupSwitchDecision::NewSharedGroup),
            enumValueForIPCTestAPI(WebCore::BrowsingContextGroupSwitchDecision::NewIsolatedGroup),
        } },
        { "WebCore::ShouldOpenExternalURLsPolicy"_s, sizeof(WebCore::ShouldOpenExternalURLsPolicy), false, {
            enumValueForIPCTestAPI(WebCore::ShouldOpenExternalURLsPolicy::ShouldNotAllow),
            enumValueForIPCTestAPI(WebCore::ShouldOpenExternalURLsPolicy::ShouldAllowExternalSchemesButNotAppLinks),
            enumValueForIPCTestAPI(WebCore::ShouldOpenExternalURLsPolicy::ShouldAllow),
        } },
        { "WebCore::ScheduleLocationChangeResult"_s, sizeof(WebCore::ScheduleLocationChangeResult), false, {
            enumValueForIPCTestAPI(WebCore::ScheduleLocationChangeResult::Stopped),
            enumValueForIPCTestAPI(WebCore::ScheduleLocationChangeResult::Completed),
            enumValueForIPCTestAPI(WebCore::ScheduleLocationChangeResult::Started),
        } },
        { "WebCore::MouseEventPolicy"_s, sizeof(WebCore::MouseEventPolicy), false, {
            enumValueForIPCTestAPI(WebCore::MouseEventPolicy::Default),
#if ENABLE(IOS_TOUCH_EVENTS)
            enumValueForIPCTestAPI(WebCore::MouseEventPolicy::SynthesizeTouchEvents),
#endif
        } },
        { "WebCore::ColorSchemePreference"_s, sizeof(WebCore::ColorSchemePreference), false, {
            enumValueForIPCTestAPI(WebCore::ColorSchemePreference::NoPreference),
            enumValueForIPCTestAPI(WebCore::ColorSchemePreference::Light),
            enumValueForIPCTestAPI(WebCore::ColorSchemePreference::Dark),
        } },
        { "WebCore::ModalContainerObservationPolicy"_s, sizeof(WebCore::ModalContainerObservationPolicy), false, {
            0, 1
        } },
        { "WebCore::AllowsContentJavaScript"_s, sizeof(WebCore::AllowsContentJavaScript), false, {
            0, 1
        } },
        { "WebCore::AdvancedPrivacyProtections"_s, sizeof(WebCore::AdvancedPrivacyProtections), true, {
            enumValueForIPCTestAPI(WebCore::AdvancedPrivacyProtections::BaselineProtections),
            enumValueForIPCTestAPI(WebCore::AdvancedPrivacyProtections::HTTPSFirst),
            enumValueForIPCTestAPI(WebCore::AdvancedPrivacyProtections::HTTPSOnly),
            enumValueForIPCTestAPI(WebCore::AdvancedPrivacyProtections::HTTPSOnlyExplicitlyBypassedForDomain),
            enumValueForIPCTestAPI(WebCore::AdvancedPrivacyProtections::FailClosedForUnreachableHosts),
            enumValueForIPCTestAPI(WebCore::AdvancedPrivacyProtections::WebSearchContent),
            enumValueForIPCTestAPI(WebCore::AdvancedPrivacyProtections::FingerprintingProtections),
            enumValueForIPCTestAPI(WebCore::AdvancedPrivacyProtections::EnhancedNetworkPrivacy),
            enumValueForIPCTestAPI(WebCore::AdvancedPrivacyProtections::LinkDecorationFiltering),
            enumValueForIPCTestAPI(WebCore::AdvancedPrivacyProtections::ScriptTrackingPrivacy),
            enumValueForIPCTestAPI(WebCore::AdvancedPrivacyProtections::FailClosedForAllHosts),
            enumValueForIPCTestAPI(WebCore::AdvancedPrivacyProtections::StrictFailClosed),
        } },
        { "WebCore::ViolationReportType"_s, sizeof(WebCore::ViolationReportType), false, {
            enumValueForIPCTestAPI(WebCore::ViolationReportType::COEPInheritenceViolation),
            enumValueForIPCTestAPI(WebCore::ViolationReportType::CORPViolation),
            enumValueForIPCTestAPI(WebCore::ViolationReportType::ContentSecurityPolicy),
            enumValueForIPCTestAPI(WebCore::ViolationReportType::CrossOriginOpenerPolicy),
            enumValueForIPCTestAPI(WebCore::ViolationReportType::Deprecation),
            enumValueForIPCTestAPI(WebCore::ViolationReportType::StandardReportingAPIViolation),
            enumValueForIPCTestAPI(WebCore::ViolationReportType::Test),
        } },
        { "WebCore::COEPDisposition"_s, sizeof(WebCore::COEPDisposition), false, {
            0, 1
        } },
        { "WebCore::LinkIconType"_s, sizeof(WebCore::LinkIconType), false, {
            enumValueForIPCTestAPI(WebCore::LinkIconType::Favicon),
            enumValueForIPCTestAPI(WebCore::LinkIconType::TouchIcon),
            enumValueForIPCTestAPI(WebCore::LinkIconType::TouchPrecomposedIcon),
        } },
        { "WebCore::PasteboardItemPresentationStyle"_s, sizeof(WebCore::PasteboardItemPresentationStyle), false, {
            enumValueForIPCTestAPI(WebCore::PasteboardItemPresentationStyle::Unspecified),
            enumValueForIPCTestAPI(WebCore::PasteboardItemPresentationStyle::Inline),
            enumValueForIPCTestAPI(WebCore::PasteboardItemPresentationStyle::Attachment),
        } },
#if HAVE(SCREEN_CAPTURE_KIT)
        { "WebCore::DisplayCapturePromptType"_s, sizeof(WebCore::DisplayCapturePromptType), false, {
            enumValueForIPCTestAPI(WebCore::DisplayCapturePromptType::Window),
            enumValueForIPCTestAPI(WebCore::DisplayCapturePromptType::Screen),
            enumValueForIPCTestAPI(WebCore::DisplayCapturePromptType::UserChoose),
        } },
#endif
        { "WebCore::TextIndicatorPresentationTransition"_s, sizeof(WebCore::TextIndicatorPresentationTransition), false, {
            enumValueForIPCTestAPI(WebCore::TextIndicatorPresentationTransition::None),
            enumValueForIPCTestAPI(WebCore::TextIndicatorPresentationTransition::Bounce),
            enumValueForIPCTestAPI(WebCore::TextIndicatorPresentationTransition::BounceAndCrossfade),
            enumValueForIPCTestAPI(WebCore::TextIndicatorPresentationTransition::FadeIn),
        } },
        { "WebCore::TextIndicatorOption"_s, sizeof(WebCore::TextIndicatorOption), true, {
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::RespectTextColor),
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::PaintBackgrounds),
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::PaintAllContent),
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::IncludeSnapshotWithSelectionHighlight),
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::TightlyFitContent),
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::UseBoundingRectAndPaintAllContentForComplexRanges),
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::IncludeMarginIfRangeMatchesSelection),
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::ExpandClipBeyondVisibleRect),
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::DoNotClipToVisibleRect),
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::IncludeSnapshotOfAllVisibleContentWithoutSelection),
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::UseSelectionRectForSizing),
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::ComputeEstimatedBackgroundColor),
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::UseUserSelectAllCommonAncestor),
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::SkipReplacedContent),
            enumValueForIPCTestAPI(WebCore::TextIndicatorOption::SnapshotContentAt3xBaseScale),
        } },
        { "WebCore::InteractionRegion::Type"_s, sizeof(WebCore::InteractionRegion::Type), false, {
            enumValueForIPCTestAPI(WebCore::InteractionRegion::Type::Interaction),
            enumValueForIPCTestAPI(WebCore::InteractionRegion::Type::Occlusion),
            enumValueForIPCTestAPI(WebCore::InteractionRegion::Type::Guard),
        } },
        { "WebCore::InteractionRegion::CornerMask"_s, sizeof(WebCore::InteractionRegion::CornerMask), true, {
            enumValueForIPCTestAPI(WebCore::InteractionRegion::CornerMask::MinXMinYCorner),
            enumValueForIPCTestAPI(WebCore::InteractionRegion::CornerMask::MaxXMinYCorner),
            enumValueForIPCTestAPI(WebCore::InteractionRegion::CornerMask::MinXMaxYCorner),
            enumValueForIPCTestAPI(WebCore::InteractionRegion::CornerMask::MaxXMaxYCorner),
        } },
        { "WebCore::InteractionRegion::ContentHint"_s, sizeof(WebCore::InteractionRegion::ContentHint), false, {
            0, 1
        } },
#if ENABLE(WEB_AUTHN)
        { "WebCore::MockWebAuthenticationConfiguration::UserVerification"_s, sizeof(WebCore::MockWebAuthenticationConfiguration::UserVerification), false, {
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::UserVerification::No),
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::UserVerification::Yes),
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::UserVerification::Cancel),
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::UserVerification::Presence),
        } },
#endif
#if ENABLE(WEB_AUTHN)
        { "WebCore::MockWebAuthenticationConfiguration::HidStage"_s, sizeof(WebCore::MockWebAuthenticationConfiguration::HidStage), false, {
            0, 1
        } },
#endif
#if ENABLE(WEB_AUTHN)
        { "WebCore::MockWebAuthenticationConfiguration::HidSubStage"_s, sizeof(WebCore::MockWebAuthenticationConfiguration::HidSubStage), false, {
            0, 1
        } },
#endif
#if ENABLE(WEB_AUTHN)
        { "WebCore::MockWebAuthenticationConfiguration::HidError"_s, sizeof(WebCore::MockWebAuthenticationConfiguration::HidError), false, {
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::HidError::Success),
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::HidError::DataNotSent),
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::HidError::EmptyReport),
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::HidError::WrongChannelId),
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::HidError::MaliciousPayload),
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::HidError::UnsupportedOptions),
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::HidError::WrongNonce),
        } },
#endif
#if ENABLE(WEB_AUTHN)
        { "WebCore::MockWebAuthenticationConfiguration::NfcError"_s, sizeof(WebCore::MockWebAuthenticationConfiguration::NfcError), false, {
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::NfcError::Success),
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::NfcError::NoTags),
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::NfcError::WrongTagType),
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::NfcError::NoConnections),
            enumValueForIPCTestAPI(WebCore::MockWebAuthenticationConfiguration::NfcError::MaliciousPayload),
        } },
#endif
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
        { "WebCore::IdentityCredentialProtocol"_s, sizeof(WebCore::IdentityCredentialProtocol), false, {
            enumValueForIPCTestAPI(WebCore::IdentityCredentialProtocol::Openid4vp),
            enumValueForIPCTestAPI(WebCore::IdentityCredentialProtocol::OrgIsoMdoc),
        } },
#endif
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MockMediaDevice::Flag"_s, sizeof(WebCore::MockMediaDevice::Flag), false, {
            enumValueForIPCTestAPI(WebCore::MockMediaDevice::Flag::Ephemeral),
            enumValueForIPCTestAPI(WebCore::MockMediaDevice::Flag::Invalid),
        } },
#endif
        { "WebCore::StorageType"_s, sizeof(WebCore::StorageType), false, {
            enumValueForIPCTestAPI(WebCore::StorageType::Session),
            enumValueForIPCTestAPI(WebCore::StorageType::Local),
            enumValueForIPCTestAPI(WebCore::StorageType::TransientLocal),
        } },
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::TransformBox"_s, sizeof(WebCore::TransformBox), false, {
            enumValueForIPCTestAPI(WebCore::TransformBox::StrokeBox),
            enumValueForIPCTestAPI(WebCore::TransformBox::ContentBox),
            enumValueForIPCTestAPI(WebCore::TransformBox::BorderBox),
            enumValueForIPCTestAPI(WebCore::TransformBox::FillBox),
            enumValueForIPCTestAPI(WebCore::TransformBox::ViewBox),
        } },
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::AcceleratedEffectProperty"_s, sizeof(WebCore::AcceleratedEffectProperty), true, {
            enumValueForIPCTestAPI(WebCore::AcceleratedEffectProperty::Opacity),
            enumValueForIPCTestAPI(WebCore::AcceleratedEffectProperty::Transform),
            enumValueForIPCTestAPI(WebCore::AcceleratedEffectProperty::Translate),
            enumValueForIPCTestAPI(WebCore::AcceleratedEffectProperty::Rotate),
            enumValueForIPCTestAPI(WebCore::AcceleratedEffectProperty::Scale),
            enumValueForIPCTestAPI(WebCore::AcceleratedEffectProperty::OffsetPath),
            enumValueForIPCTestAPI(WebCore::AcceleratedEffectProperty::OffsetDistance),
            enumValueForIPCTestAPI(WebCore::AcceleratedEffectProperty::OffsetPosition),
            enumValueForIPCTestAPI(WebCore::AcceleratedEffectProperty::OffsetAnchor),
            enumValueForIPCTestAPI(WebCore::AcceleratedEffectProperty::OffsetRotate),
            enumValueForIPCTestAPI(WebCore::AcceleratedEffectProperty::Filter),
            enumValueForIPCTestAPI(WebCore::AcceleratedEffectProperty::BackdropFilter),
        } },
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::WebAnimationType"_s, sizeof(WebCore::WebAnimationType), false, {
            enumValueForIPCTestAPI(WebCore::WebAnimationType::CSSAnimation),
            enumValueForIPCTestAPI(WebCore::WebAnimationType::CSSTransition),
            enumValueForIPCTestAPI(WebCore::WebAnimationType::WebAnimation),
        } },
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::FillMode"_s, sizeof(WebCore::FillMode), false, {
            enumValueForIPCTestAPI(WebCore::FillMode::None),
            enumValueForIPCTestAPI(WebCore::FillMode::Forwards),
            enumValueForIPCTestAPI(WebCore::FillMode::Backwards),
            enumValueForIPCTestAPI(WebCore::FillMode::Both),
            enumValueForIPCTestAPI(WebCore::FillMode::Auto),
        } },
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::PlaybackDirection"_s, sizeof(WebCore::PlaybackDirection), false, {
            enumValueForIPCTestAPI(WebCore::PlaybackDirection::Normal),
            enumValueForIPCTestAPI(WebCore::PlaybackDirection::Reverse),
            enumValueForIPCTestAPI(WebCore::PlaybackDirection::Alternate),
            enumValueForIPCTestAPI(WebCore::PlaybackDirection::AlternateReverse),
        } },
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
        { "WebCore::CompositeOperation"_s, sizeof(WebCore::CompositeOperation), false, {
            enumValueForIPCTestAPI(WebCore::CompositeOperation::Replace),
            enumValueForIPCTestAPI(WebCore::CompositeOperation::Add),
            enumValueForIPCTestAPI(WebCore::CompositeOperation::Accumulate),
        } },
#endif
#if PLATFORM(MAC)
        { "WebCore::CaretAnimatorType"_s, sizeof(WebCore::CaretAnimatorType), false, {
            enumValueForIPCTestAPI(WebCore::CaretAnimatorType::Default),
            enumValueForIPCTestAPI(WebCore::CaretAnimatorType::Dictation),
        } },
#endif
#if ENABLE(GPU_PROCESS)
        { "WebCore::ShapeDetection::BarcodeFormat"_s, sizeof(WebCore::ShapeDetection::BarcodeFormat), false, {
            enumValueForIPCTestAPI(WebCore::ShapeDetection::BarcodeFormat::Aztec),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::BarcodeFormat::Code_128),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::BarcodeFormat::Code_39),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::BarcodeFormat::Code_93),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::BarcodeFormat::Codabar),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::BarcodeFormat::Data_matrix),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::BarcodeFormat::Ean_13),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::BarcodeFormat::Ean_8),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::BarcodeFormat::Itf),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::BarcodeFormat::Pdf417),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::BarcodeFormat::Qr_code),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::BarcodeFormat::Unknown),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::BarcodeFormat::Upc_a),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::BarcodeFormat::Upc_e),
        } },
#endif
#if ENABLE(GPU_PROCESS)
        { "WebCore::ShapeDetection::LandmarkType"_s, sizeof(WebCore::ShapeDetection::LandmarkType), false, {
            enumValueForIPCTestAPI(WebCore::ShapeDetection::LandmarkType::Mouth),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::LandmarkType::Eye),
            enumValueForIPCTestAPI(WebCore::ShapeDetection::LandmarkType::Nose),
        } },
#endif
        { "WebCore::RenderAsTextFlag"_s, sizeof(WebCore::RenderAsTextFlag), true, {
            enumValueForIPCTestAPI(WebCore::RenderAsTextFlag::ShowAllLayers),
            enumValueForIPCTestAPI(WebCore::RenderAsTextFlag::ShowLayerNesting),
            enumValueForIPCTestAPI(WebCore::RenderAsTextFlag::ShowCompositedLayers),
            enumValueForIPCTestAPI(WebCore::RenderAsTextFlag::ShowOverflow),
            enumValueForIPCTestAPI(WebCore::RenderAsTextFlag::ShowSVGGeometry),
            enumValueForIPCTestAPI(WebCore::RenderAsTextFlag::ShowLayerFragments),
            enumValueForIPCTestAPI(WebCore::RenderAsTextFlag::ShowAddresses),
            enumValueForIPCTestAPI(WebCore::RenderAsTextFlag::ShowIDAndClass),
            enumValueForIPCTestAPI(WebCore::RenderAsTextFlag::PrintingMode),
            enumValueForIPCTestAPI(WebCore::RenderAsTextFlag::DontUpdateLayout),
            enumValueForIPCTestAPI(WebCore::RenderAsTextFlag::ShowLayoutState),
        } },
        { "WebCore::LayerTreeAsTextOptions"_s, sizeof(WebCore::LayerTreeAsTextOptions), true, {
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::Debug),
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::IncludeVisibleRects),
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::IncludeTileCaches),
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::IncludeRepaintRects),
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::IncludePaintingPhases),
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::IncludeContentLayers),
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::IncludePageOverlayLayers),
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::IncludeAcceleratesDrawing),
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::IncludeClipping),
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::IncludeBackingStoreAttached),
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::IncludeRootLayerProperties),
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::IncludeEventRegion),
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::IncludeExtendedColor),
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::IncludeDeviceScale),
            enumValueForIPCTestAPI(WebCore::LayerTreeAsTextOptions::IncludeRootLayers),
        } },
        { "WebCore::TextExtraction::ContainerType"_s, sizeof(WebCore::TextExtraction::ContainerType), false, {
            enumValueForIPCTestAPI(WebCore::TextExtraction::ContainerType::Root),
            enumValueForIPCTestAPI(WebCore::TextExtraction::ContainerType::ViewportConstrained),
            enumValueForIPCTestAPI(WebCore::TextExtraction::ContainerType::List),
            enumValueForIPCTestAPI(WebCore::TextExtraction::ContainerType::ListItem),
            enumValueForIPCTestAPI(WebCore::TextExtraction::ContainerType::BlockQuote),
            enumValueForIPCTestAPI(WebCore::TextExtraction::ContainerType::Article),
            enumValueForIPCTestAPI(WebCore::TextExtraction::ContainerType::Section),
            enumValueForIPCTestAPI(WebCore::TextExtraction::ContainerType::Nav),
            enumValueForIPCTestAPI(WebCore::TextExtraction::ContainerType::Button),
        } },
#if ENABLE(WRITING_TOOLS)
        { "WebCore::WritingTools::Behavior"_s, sizeof(WebCore::WritingTools::Behavior), false, {
            enumValueForIPCTestAPI(WebCore::WritingTools::Behavior::None),
            enumValueForIPCTestAPI(WebCore::WritingTools::Behavior::Default),
            enumValueForIPCTestAPI(WebCore::WritingTools::Behavior::Limited),
            enumValueForIPCTestAPI(WebCore::WritingTools::Behavior::Complete),
        } },
#endif
#if ENABLE(WRITING_TOOLS)
        { "WebCore::WritingTools::Action"_s, sizeof(WebCore::WritingTools::Action), false, {
            enumValueForIPCTestAPI(WebCore::WritingTools::Action::ShowOriginal),
            enumValueForIPCTestAPI(WebCore::WritingTools::Action::ShowRewritten),
            enumValueForIPCTestAPI(WebCore::WritingTools::Action::Restart),
        } },
#endif
#if ENABLE(WRITING_TOOLS)
        { "WebCore::WritingTools::SessionType"_s, sizeof(WebCore::WritingTools::SessionType), false, {
            enumValueForIPCTestAPI(WebCore::WritingTools::SessionType::Proofreading),
            enumValueForIPCTestAPI(WebCore::WritingTools::SessionType::Composition),
        } },
#endif
#if ENABLE(WRITING_TOOLS)
        { "WebCore::WritingTools::SessionCompositionType"_s, sizeof(WebCore::WritingTools::SessionCompositionType), false, {
            enumValueForIPCTestAPI(WebCore::WritingTools::SessionCompositionType::None),
            enumValueForIPCTestAPI(WebCore::WritingTools::SessionCompositionType::Compose),
            enumValueForIPCTestAPI(WebCore::WritingTools::SessionCompositionType::SmartReply),
            enumValueForIPCTestAPI(WebCore::WritingTools::SessionCompositionType::Other),
        } },
#endif
#if ENABLE(WRITING_TOOLS)
        { "WebCore::WritingTools::TextSuggestionState"_s, sizeof(WebCore::WritingTools::TextSuggestionState), false, {
            enumValueForIPCTestAPI(WebCore::WritingTools::TextSuggestionState::Pending),
            enumValueForIPCTestAPI(WebCore::WritingTools::TextSuggestionState::Reviewing),
            enumValueForIPCTestAPI(WebCore::WritingTools::TextSuggestionState::Rejected),
            enumValueForIPCTestAPI(WebCore::WritingTools::TextSuggestionState::Invalid),
        } },
#endif
        { "WebCore::WebGPU::TextureFormat"_s, sizeof(WebCore::WebGPU::TextureFormat), false, {
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::R8unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::R8snorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::R8uint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::R8sint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::R16uint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::R16sint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::R16float),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rg8unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rg8snorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rg8uint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rg8sint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::R32uint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::R32sint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::R32float),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rg16uint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rg16sint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rg16float),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rgba8unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rgba8unormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rgba8snorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rgba8uint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rgba8sint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bgra8unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bgra8unormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rgb9e5ufloat),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rgb10a2uint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rgb10a2unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rg11b10ufloat),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rg32uint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rg32sint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rg32float),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rgba16uint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rgba16sint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rgba16float),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rgba32uint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rgba32sint),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Rgba32float),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Stencil8),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Depth16unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Depth24plus),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Depth24plusStencil8),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Depth32float),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Depth32floatStencil8),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bc1RgbaUnorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bc1RgbaUnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bc2RgbaUnorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bc2RgbaUnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bc3RgbaUnorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bc3RgbaUnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bc4RUnorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bc4RSnorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bc5RgUnorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bc5RgSnorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bc6hRgbUfloat),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bc6hRgbFloat),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bc7RgbaUnorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Bc7RgbaUnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Etc2Rgb8unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Etc2Rgb8unormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Etc2Rgb8a1unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Etc2Rgb8a1unormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Etc2Rgba8unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Etc2Rgba8unormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::EacR11unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::EacR11snorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::EacRg11unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::EacRg11snorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc4x4Unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc4x4UnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc5x4Unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc5x4UnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc5x5Unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc5x5UnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc6x5Unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc6x5UnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc6x6Unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc6x6UnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc8x5Unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc8x5UnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc8x6Unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc8x6UnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc8x8Unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc8x8UnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc10x5Unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc10x5UnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc10x6Unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc10x6UnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc10x8Unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc10x8UnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc10x10Unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc10x10UnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc12x10Unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc12x10UnormSRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc12x12Unorm),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureFormat::Astc12x12UnormSRGB),
        } },
#if ENABLE(MEDIA_STREAM)
        { "WebCore::MediaAccessDenialReason"_s, sizeof(WebCore::MediaAccessDenialReason), false, {
            enumValueForIPCTestAPI(WebCore::MediaAccessDenialReason::NoReason),
            enumValueForIPCTestAPI(WebCore::MediaAccessDenialReason::NoConstraints),
            enumValueForIPCTestAPI(WebCore::MediaAccessDenialReason::UserMediaDisabled),
            enumValueForIPCTestAPI(WebCore::MediaAccessDenialReason::NoCaptureDevices),
            enumValueForIPCTestAPI(WebCore::MediaAccessDenialReason::InvalidConstraint),
            enumValueForIPCTestAPI(WebCore::MediaAccessDenialReason::HardwareError),
            enumValueForIPCTestAPI(WebCore::MediaAccessDenialReason::PermissionDenied),
            enumValueForIPCTestAPI(WebCore::MediaAccessDenialReason::InvalidAccess),
            enumValueForIPCTestAPI(WebCore::MediaAccessDenialReason::OtherFailure),
        } },
#endif
#if ENABLE(MEDIA_STREAM)
        { "WebCore::FillLightMode"_s, sizeof(WebCore::FillLightMode), false, {
            enumValueForIPCTestAPI(WebCore::FillLightMode::Auto),
            enumValueForIPCTestAPI(WebCore::FillLightMode::Off),
            enumValueForIPCTestAPI(WebCore::FillLightMode::Flash),
        } },
#endif
#if ENABLE(MEDIA_STREAM)
        { "WebCore::RedEyeReduction"_s, sizeof(WebCore::RedEyeReduction), false, {
            enumValueForIPCTestAPI(WebCore::RedEyeReduction::Never),
            enumValueForIPCTestAPI(WebCore::RedEyeReduction::Always),
            enumValueForIPCTestAPI(WebCore::RedEyeReduction::Controllable),
        } },
#endif
        { "WebCore::WebGPU::TextureAspect"_s, sizeof(WebCore::WebGPU::TextureAspect), false, {
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureAspect::All),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureAspect::StencilOnly),
            enumValueForIPCTestAPI(WebCore::WebGPU::TextureAspect::DepthOnly),
        } },
        { "WebCore::WebGPU::PowerPreference"_s, sizeof(WebCore::WebGPU::PowerPreference), false, {
            0, 1
        } },
        { "WebCore::WebGPU::PredefinedColorSpace"_s, sizeof(WebCore::WebGPU::PredefinedColorSpace), false, {
            enumValueForIPCTestAPI(WebCore::WebGPU::PredefinedColorSpace::SRGB),
            enumValueForIPCTestAPI(WebCore::WebGPU::PredefinedColorSpace::DisplayP3),
        } },
#if ENABLE(MODEL_PROCESS)
        { "WebCore::ModelContextDisablePortal"_s, sizeof(WebCore::ModelContextDisablePortal), false, {
            0, 1
        } },
#endif
#if PLATFORM(IOS_FAMILY)
        { "WebCore::InspectorOverlayLabel::Arrow::Direction"_s, sizeof(WebCore::InspectorOverlayLabel::Arrow::Direction), false, {
            enumValueForIPCTestAPI(WebCore::InspectorOverlayLabel::Arrow::Direction::None),
            enumValueForIPCTestAPI(WebCore::InspectorOverlayLabel::Arrow::Direction::Down),
            enumValueForIPCTestAPI(WebCore::InspectorOverlayLabel::Arrow::Direction::Up),
            enumValueForIPCTestAPI(WebCore::InspectorOverlayLabel::Arrow::Direction::Left),
            enumValueForIPCTestAPI(WebCore::InspectorOverlayLabel::Arrow::Direction::Right),
        } },
#endif
#if PLATFORM(IOS_FAMILY)
        { "WebCore::InspectorOverlayLabel::Arrow::Alignment"_s, sizeof(WebCore::InspectorOverlayLabel::Arrow::Alignment), false, {
            enumValueForIPCTestAPI(WebCore::InspectorOverlayLabel::Arrow::Alignment::None),
            enumValueForIPCTestAPI(WebCore::InspectorOverlayLabel::Arrow::Alignment::Leading),
            enumValueForIPCTestAPI(WebCore::InspectorOverlayLabel::Arrow::Alignment::Middle),
            enumValueForIPCTestAPI(WebCore::InspectorOverlayLabel::Arrow::Alignment::Trailing),
        } },
#endif
#if PLATFORM(IOS_FAMILY)
        { "WebCore::InspectorOverlayLabel::Content::Decoration::Type"_s, sizeof(WebCore::InspectorOverlayLabel::Content::Decoration::Type), false, {
            enumValueForIPCTestAPI(WebCore::InspectorOverlayLabel::Content::Decoration::Type::None),
            enumValueForIPCTestAPI(WebCore::InspectorOverlayLabel::Content::Decoration::Type::Bordered),
        } },
#endif
#if PLATFORM(IOS_FAMILY)
        { "WebCore::InspectorOverlayHighlight::Type"_s, sizeof(WebCore::InspectorOverlayHighlight::Type), false, {
            enumValueForIPCTestAPI(WebCore::InspectorOverlayHighlight::Type::None),
            enumValueForIPCTestAPI(WebCore::InspectorOverlayHighlight::Type::Node),
            enumValueForIPCTestAPI(WebCore::InspectorOverlayHighlight::Type::NodeList),
            enumValueForIPCTestAPI(WebCore::InspectorOverlayHighlight::Type::Rects),
        } },
#endif
        { "WebCore::InspectorFrontendClientAppearance"_s, sizeof(WebCore::InspectorFrontendClientAppearance), false, {
            enumValueForIPCTestAPI(WebCore::InspectorFrontendClientAppearance::System),
            enumValueForIPCTestAPI(WebCore::InspectorFrontendClientAppearance::Light),
            enumValueForIPCTestAPI(WebCore::InspectorFrontendClientAppearance::Dark),
        } },
        { "WebCore::InspectorFrontendClient::SaveMode"_s, sizeof(WebCore::InspectorFrontendClient::SaveMode), false, {
            enumValueForIPCTestAPI(WebCore::InspectorFrontendClient::SaveMode::SingleFile),
            enumValueForIPCTestAPI(WebCore::InspectorFrontendClient::SaveMode::FileVariants),
        } },
#if ENABLE(VIDEO)
        { "WebCore::PlatformTextTrackData::TrackKind"_s, sizeof(WebCore::PlatformTextTrackData::TrackKind), false, {
            enumValueForIPCTestAPI(WebCore::PlatformTextTrackData::TrackKind::Subtitle),
            enumValueForIPCTestAPI(WebCore::PlatformTextTrackData::TrackKind::Caption),
            enumValueForIPCTestAPI(WebCore::PlatformTextTrackData::TrackKind::Description),
            enumValueForIPCTestAPI(WebCore::PlatformTextTrackData::TrackKind::Chapter),
            enumValueForIPCTestAPI(WebCore::PlatformTextTrackData::TrackKind::MetaData),
            enumValueForIPCTestAPI(WebCore::PlatformTextTrackData::TrackKind::Forced),
        } },
#endif
#if ENABLE(VIDEO)
        { "WebCore::PlatformTextTrackData::TrackType"_s, sizeof(WebCore::PlatformTextTrackData::TrackType), false, {
            enumValueForIPCTestAPI(WebCore::PlatformTextTrackData::TrackType::InBand),
            enumValueForIPCTestAPI(WebCore::PlatformTextTrackData::TrackType::OutOfBand),
            enumValueForIPCTestAPI(WebCore::PlatformTextTrackData::TrackType::Script),
        } },
#endif
#if ENABLE(VIDEO)
        { "WebCore::PlatformTextTrackData::TrackMode"_s, sizeof(WebCore::PlatformTextTrackData::TrackMode), false, {
            enumValueForIPCTestAPI(WebCore::PlatformTextTrackData::TrackMode::Disabled),
            enumValueForIPCTestAPI(WebCore::PlatformTextTrackData::TrackMode::Hidden),
            enumValueForIPCTestAPI(WebCore::PlatformTextTrackData::TrackMode::Showing),
        } },
#endif
        { "WebCore::UserScriptInjectionTime"_s, sizeof(WebCore::UserScriptInjectionTime), false, {
            0, 1
        } },
        { "WebCore::UserContentInjectedFrames"_s, sizeof(WebCore::UserContentInjectedFrames), false, {
            0, 1
        } },
        { "WebCore::UserContentMatchParentFrame"_s, sizeof(WebCore::UserContentMatchParentFrame), false, {
            enumValueForIPCTestAPI(WebCore::UserContentMatchParentFrame::Never),
            enumValueForIPCTestAPI(WebCore::UserContentMatchParentFrame::ForAboutBlank),
            enumValueForIPCTestAPI(WebCore::UserContentMatchParentFrame::ForOpaqueOrigins),
        } },
        { "WebCore::WindRule"_s, sizeof(WebCore::WindRule), false, {
            0, 1
        } },
        { "WebCore::ContentSecurityPolicyHeaderType"_s, sizeof(WebCore::ContentSecurityPolicyHeaderType), false, {
            0, 1
        } },
        { "WebCore::UserStyleLevel"_s, sizeof(WebCore::UserStyleLevel), false, {
            0, 1
        } },
        { "WebCore::WheelEventTestMonitorDeferReason"_s, sizeof(WebCore::WheelEventTestMonitorDeferReason), true, {
            enumValueForIPCTestAPI(WebCore::WheelEventTestMonitorDeferReason::None),
            enumValueForIPCTestAPI(WebCore::WheelEventTestMonitorDeferReason::HandlingWheelEvent),
            enumValueForIPCTestAPI(WebCore::WheelEventTestMonitorDeferReason::HandlingWheelEventOnMainThread),
            enumValueForIPCTestAPI(WebCore::WheelEventTestMonitorDeferReason::PostMainThreadWheelEventHandling),
            enumValueForIPCTestAPI(WebCore::WheelEventTestMonitorDeferReason::RubberbandInProgress),
            enumValueForIPCTestAPI(WebCore::WheelEventTestMonitorDeferReason::ScrollSnapInProgress),
            enumValueForIPCTestAPI(WebCore::WheelEventTestMonitorDeferReason::ScrollAnimationInProgress),
            enumValueForIPCTestAPI(WebCore::WheelEventTestMonitorDeferReason::ScrollingThreadSyncNeeded),
            enumValueForIPCTestAPI(WebCore::WheelEventTestMonitorDeferReason::ContentScrollInProgress),
            enumValueForIPCTestAPI(WebCore::WheelEventTestMonitorDeferReason::RequestedScrollPosition),
            enumValueForIPCTestAPI(WebCore::WheelEventTestMonitorDeferReason::CommittingTransientZoom),
        } },
        { "WebCore::HTTPHeadersToKeepFromCleaning"_s, sizeof(WebCore::HTTPHeadersToKeepFromCleaning), true, {
            enumValueForIPCTestAPI(WebCore::HTTPHeadersToKeepFromCleaning::AcceptEncoding),
            enumValueForIPCTestAPI(WebCore::HTTPHeadersToKeepFromCleaning::CacheControl),
            enumValueForIPCTestAPI(WebCore::HTTPHeadersToKeepFromCleaning::ContentType),
            enumValueForIPCTestAPI(WebCore::HTTPHeadersToKeepFromCleaning::Origin),
            enumValueForIPCTestAPI(WebCore::HTTPHeadersToKeepFromCleaning::Pragma),
            enumValueForIPCTestAPI(WebCore::HTTPHeadersToKeepFromCleaning::Referer),
            enumValueForIPCTestAPI(WebCore::HTTPHeadersToKeepFromCleaning::UserAgent),
        } },
        { "WebCore::ExceptionCode"_s, sizeof(WebCore::ExceptionCode), false, {
            enumValueForIPCTestAPI(WebCore::ExceptionCode::IndexSizeError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::HierarchyRequestError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::WrongDocumentError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::InvalidCharacterError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::NoModificationAllowedError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::NotFoundError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::NotSupportedError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::InUseAttributeError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::InvalidStateError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::SyntaxError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::InvalidModificationError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::NamespaceError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::InvalidAccessError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::TypeMismatchError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::SecurityError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::NetworkError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::AbortError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::URLMismatchError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::QuotaExceededError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::TimeoutError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::InvalidNodeTypeError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::DataCloneError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::EncodingError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::NotReadableError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::UnknownError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::ConstraintError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::DataError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::TransactionInactiveError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::ReadonlyError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::VersionError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::OperationError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::NotAllowedError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::RangeError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::TypeError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::JSSyntaxError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::StackOverflowError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::OutOfMemoryError),
            enumValueForIPCTestAPI(WebCore::ExceptionCode::ExistingExceptionError),
        } },
        { "WebCore::BackgroundFetchFailureReason"_s, sizeof(WebCore::BackgroundFetchFailureReason), false, {
            enumValueForIPCTestAPI(WebCore::BackgroundFetchFailureReason::EmptyString),
            enumValueForIPCTestAPI(WebCore::BackgroundFetchFailureReason::Aborted),
            enumValueForIPCTestAPI(WebCore::BackgroundFetchFailureReason::BadStatus),
            enumValueForIPCTestAPI(WebCore::BackgroundFetchFailureReason::FetchError),
            enumValueForIPCTestAPI(WebCore::BackgroundFetchFailureReason::QuotaExceeded),
            enumValueForIPCTestAPI(WebCore::BackgroundFetchFailureReason::DownloadTotalExceeded),
        } },
        { "WebCore::BackgroundFetchResult"_s, sizeof(WebCore::BackgroundFetchResult), false, {
            enumValueForIPCTestAPI(WebCore::BackgroundFetchResult::EmptyString),
            enumValueForIPCTestAPI(WebCore::BackgroundFetchResult::Success),
            enumValueForIPCTestAPI(WebCore::BackgroundFetchResult::Failure),
        } },
        { "WebCore::ResourceErrorBaseType"_s, sizeof(WebCore::ResourceErrorBaseType), false, {
            enumValueForIPCTestAPI(WebCore::ResourceErrorBaseType::Null),
            enumValueForIPCTestAPI(WebCore::ResourceErrorBaseType::General),
            enumValueForIPCTestAPI(WebCore::ResourceErrorBaseType::AccessControl),
            enumValueForIPCTestAPI(WebCore::ResourceErrorBaseType::Cancellation),
            enumValueForIPCTestAPI(WebCore::ResourceErrorBaseType::Timeout),
        } },
        { "WebCore::CredentialPersistence"_s, sizeof(WebCore::CredentialPersistence), false, {
            enumValueForIPCTestAPI(WebCore::CredentialPersistence::None),
            enumValueForIPCTestAPI(WebCore::CredentialPersistence::ForSession),
            enumValueForIPCTestAPI(WebCore::CredentialPersistence::Permanent),
        } },
        { "WebCore::PaginationMode"_s, sizeof(WebCore::PaginationMode), false, {
            enumValueForIPCTestAPI(WebCore::PaginationMode::Unpaginated),
            enumValueForIPCTestAPI(WebCore::PaginationMode::LeftToRightPaginated),
            enumValueForIPCTestAPI(WebCore::PaginationMode::RightToLeftPaginated),
            enumValueForIPCTestAPI(WebCore::PaginationMode::TopToBottomPaginated),
            enumValueForIPCTestAPI(WebCore::PaginationMode::BottomToTopPaginated),
        } },
        { "WebCore::RepaintRectCalculation"_s, sizeof(WebCore::RepaintRectCalculation), false, {
            0, 1
        } },
        { "WebCore::HdrMetadataType"_s, sizeof(WebCore::HdrMetadataType), false, {
            enumValueForIPCTestAPI(WebCore::HdrMetadataType::SmpteSt2086),
            enumValueForIPCTestAPI(WebCore::HdrMetadataType::SmpteSt209410),
            enumValueForIPCTestAPI(WebCore::HdrMetadataType::SmpteSt209440),
        } },
        { "WebCore::TransferFunction"_s, sizeof(WebCore::TransferFunction), false, {
            enumValueForIPCTestAPI(WebCore::TransferFunction::SRGB),
            enumValueForIPCTestAPI(WebCore::TransferFunction::PQ),
            enumValueForIPCTestAPI(WebCore::TransferFunction::HLG),
        } },
        { "WebCore::ColorGamut"_s, sizeof(WebCore::ColorGamut), false, {
            enumValueForIPCTestAPI(WebCore::ColorGamut::SRGB),
            enumValueForIPCTestAPI(WebCore::ColorGamut::P3),
            enumValueForIPCTestAPI(WebCore::ColorGamut::Rec2020),
        } },
#if ENABLE(WEB_AUTHN)
        { "WebCore::MediationRequirement"_s, sizeof(WebCore::MediationRequirement), false, {
            enumValueForIPCTestAPI(WebCore::MediationRequirement::Silent),
            enumValueForIPCTestAPI(WebCore::MediationRequirement::Optional),
            enumValueForIPCTestAPI(WebCore::MediationRequirement::Required),
            enumValueForIPCTestAPI(WebCore::MediationRequirement::Conditional),
        } },
#endif
#if ENABLE(VIDEO)
        { "WebCore::VTTDirectionSetting"_s, sizeof(WebCore::VTTDirectionSetting), false, {
            enumValueForIPCTestAPI(WebCore::VTTDirectionSetting::Horizontal),
            enumValueForIPCTestAPI(WebCore::VTTDirectionSetting::VerticalGrowingLeft),
            enumValueForIPCTestAPI(WebCore::VTTDirectionSetting::VerticalGrowingRight),
        } },
#endif
#if ENABLE(VIDEO)
        { "WebCore::VTTLineAlignSetting"_s, sizeof(WebCore::VTTLineAlignSetting), false, {
            enumValueForIPCTestAPI(WebCore::VTTLineAlignSetting::Start),
            enumValueForIPCTestAPI(WebCore::VTTLineAlignSetting::Center),
            enumValueForIPCTestAPI(WebCore::VTTLineAlignSetting::End),
        } },
#endif
#if ENABLE(VIDEO)
        { "WebCore::VTTPositionAlignSetting"_s, sizeof(WebCore::VTTPositionAlignSetting), false, {
            enumValueForIPCTestAPI(WebCore::VTTPositionAlignSetting::LineLeft),
            enumValueForIPCTestAPI(WebCore::VTTPositionAlignSetting::Center),
            enumValueForIPCTestAPI(WebCore::VTTPositionAlignSetting::LineRight),
            enumValueForIPCTestAPI(WebCore::VTTPositionAlignSetting::Auto),
        } },
#endif
#if ENABLE(VIDEO)
        { "WebCore::VTTAlignSetting"_s, sizeof(WebCore::VTTAlignSetting), false, {
            enumValueForIPCTestAPI(WebCore::VTTAlignSetting::Start),
            enumValueForIPCTestAPI(WebCore::VTTAlignSetting::Center),
            enumValueForIPCTestAPI(WebCore::VTTAlignSetting::End),
            enumValueForIPCTestAPI(WebCore::VTTAlignSetting::Left),
            enumValueForIPCTestAPI(WebCore::VTTAlignSetting::Right),
        } },
#endif
#if ENABLE(CONTEXT_MENUS)
        { "WebCore::ContextMenuContextType"_s, sizeof(WebCore::ContextMenuContextType), false, {
            enumValueForIPCTestAPI(WebCore::ContextMenuContextType::ContextMenu),
#if ENABLE(SERVICE_CONTROLS)
            enumValueForIPCTestAPI(WebCore::ContextMenuContextType::ServicesMenu),
#endif
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS)
            enumValueForIPCTestAPI(WebCore::ContextMenuContextType::MediaControls),
#endif
        } },
#endif
        { "WebCore::CrossSiteNavigationDataTransferFlag"_s, sizeof(WebCore::CrossSiteNavigationDataTransferFlag), true, {
            enumValueForIPCTestAPI(WebCore::CrossSiteNavigationDataTransferFlag::DestinationLinkDecoration),
            enumValueForIPCTestAPI(WebCore::CrossSiteNavigationDataTransferFlag::ReferrerLinkDecoration),
        } },
        { "WebCore::SynchronousScrollingReason"_s, sizeof(WebCore::SynchronousScrollingReason), true, {
            enumValueForIPCTestAPI(WebCore::SynchronousScrollingReason::ForcedOnMainThread),
            enumValueForIPCTestAPI(WebCore::SynchronousScrollingReason::HasViewportConstrainedObjectsWithoutSupportingFixedLayers),
            enumValueForIPCTestAPI(WebCore::SynchronousScrollingReason::HasNonLayerViewportConstrainedObjects),
            enumValueForIPCTestAPI(WebCore::SynchronousScrollingReason::IsImageDocument),
            enumValueForIPCTestAPI(WebCore::SynchronousScrollingReason::HasSlowRepaintObjects),
            enumValueForIPCTestAPI(WebCore::SynchronousScrollingReason::DescendantScrollersHaveSynchronousScrolling),
        } },
        { "WebCore::ScrollRequestType"_s, sizeof(WebCore::ScrollRequestType), false, {
            enumValueForIPCTestAPI(WebCore::ScrollRequestType::PositionUpdate),
            enumValueForIPCTestAPI(WebCore::ScrollRequestType::DeltaUpdate),
            enumValueForIPCTestAPI(WebCore::ScrollRequestType::CancelAnimatedScroll),
        } },
        { "WebCore::KeyboardScrollAction"_s, sizeof(WebCore::KeyboardScrollAction), false, {
            enumValueForIPCTestAPI(WebCore::KeyboardScrollAction::StartAnimation),
            enumValueForIPCTestAPI(WebCore::KeyboardScrollAction::StopWithAnimation),
            enumValueForIPCTestAPI(WebCore::KeyboardScrollAction::StopImmediately),
        } },
        { "WebCore::FontOrigin"_s, sizeof(WebCore::FontOrigin), false, {
            0, 1
        } },
        { "WebCore::FontIsInterstitial"_s, sizeof(WebCore::FontIsInterstitial), false, {
            0, 1
        } },
        { "WebCore::FontVisibility"_s, sizeof(WebCore::FontVisibility), false, {
            0, 1
        } },
        { "WebCore::FontIsOrientationFallback"_s, sizeof(WebCore::FontIsOrientationFallback), false, {
            0, 1
        } },
#if ENABLE(VIDEO)
        { "WebCore::CaptionUserPreferencesDisplayMode"_s, sizeof(WebCore::CaptionUserPreferencesDisplayMode), false, {
            enumValueForIPCTestAPI(WebCore::CaptionUserPreferencesDisplayMode::Automatic),
            enumValueForIPCTestAPI(WebCore::CaptionUserPreferencesDisplayMode::ForcedOnly),
            enumValueForIPCTestAPI(WebCore::CaptionUserPreferencesDisplayMode::AlwaysOn),
            enumValueForIPCTestAPI(WebCore::CaptionUserPreferencesDisplayMode::Manual),
        } },
#endif
        { "WebCore::InspectorBackendClientDeveloperPreference"_s, sizeof(WebCore::InspectorBackendClientDeveloperPreference), false, {
            enumValueForIPCTestAPI(WebCore::InspectorBackendClientDeveloperPreference::PrivateClickMeasurementDebugModeEnabled),
            enumValueForIPCTestAPI(WebCore::InspectorBackendClientDeveloperPreference::ITPDebugModeEnabled),
            enumValueForIPCTestAPI(WebCore::InspectorBackendClientDeveloperPreference::MockCaptureDevicesEnabled),
            enumValueForIPCTestAPI(WebCore::InspectorBackendClientDeveloperPreference::NeedsSiteSpecificQuirks),
        } },
#if HAVE(CORE_MATERIAL)
        { "WebCore::AppleVisualEffect"_s, sizeof(WebCore::AppleVisualEffect), false, {
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::None),
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::BlurUltraThinMaterial),
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::BlurThinMaterial),
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::BlurMaterial),
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::BlurThickMaterial),
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::BlurChromeMaterial),
#if HAVE(MATERIAL_HOSTING)
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::GlassMaterial),
#endif
#if HAVE(MATERIAL_HOSTING)
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::GlassClearMaterial),
#endif
#if HAVE(MATERIAL_HOSTING)
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::GlassSubduedMaterial),
#endif
#if HAVE(MATERIAL_HOSTING)
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::GlassMediaControlsMaterial),
#endif
#if HAVE(MATERIAL_HOSTING)
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::GlassSubduedMediaControlsMaterial),
#endif
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::VibrancyLabel),
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::VibrancySecondaryLabel),
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::VibrancyTertiaryLabel),
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::VibrancyQuaternaryLabel),
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::VibrancyFill),
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::VibrancySecondaryFill),
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::VibrancyTertiaryFill),
            enumValueForIPCTestAPI(WebCore::AppleVisualEffect::VibrancySeparator),
        } },
#endif
#if HAVE(CORE_MATERIAL)
        { "WebCore::AppleVisualEffectData::ColorScheme"_s, sizeof(WebCore::AppleVisualEffectData::ColorScheme), false, {
            enumValueForIPCTestAPI(WebCore::AppleVisualEffectData::ColorScheme::Light),
            enumValueForIPCTestAPI(WebCore::AppleVisualEffectData::ColorScheme::Dark),
        } },
#endif
#if ENABLE(MEDIA_SOURCE)
        { "WebCore::MediaSourcePrivateAddStatus"_s, sizeof(WebCore::MediaSourcePrivateAddStatus), false, {
            enumValueForIPCTestAPI(WebCore::MediaSourcePrivateAddStatus::Ok),
            enumValueForIPCTestAPI(WebCore::MediaSourcePrivateAddStatus::NotSupported),
            enumValueForIPCTestAPI(WebCore::MediaSourcePrivateAddStatus::ReachedIdLimit),
        } },
#endif
#if ENABLE(MEDIA_SOURCE)
        { "WebCore::MediaSourcePrivateEndOfStreamStatus"_s, sizeof(WebCore::MediaSourcePrivateEndOfStreamStatus), false, {
            enumValueForIPCTestAPI(WebCore::MediaSourcePrivateEndOfStreamStatus::NoError),
            enumValueForIPCTestAPI(WebCore::MediaSourcePrivateEndOfStreamStatus::NetworkError),
            enumValueForIPCTestAPI(WebCore::MediaSourcePrivateEndOfStreamStatus::DecodeError),
        } },
#endif
#if ENABLE(MEDIA_SOURCE)
        { "WebCore::SourceBufferAppendMode"_s, sizeof(WebCore::SourceBufferAppendMode), false, {
            enumValueForIPCTestAPI(WebCore::SourceBufferAppendMode::Segments),
            enumValueForIPCTestAPI(WebCore::SourceBufferAppendMode::Sequence),
        } },
#endif
        { "WebCore::WindowProxyProperty"_s, sizeof(WebCore::WindowProxyProperty), false, {
            enumValueForIPCTestAPI(WebCore::WindowProxyProperty::Other),
            enumValueForIPCTestAPI(WebCore::WindowProxyProperty::Closed),
            enumValueForIPCTestAPI(WebCore::WindowProxyProperty::PostMessage),
        } },
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
        { "WebCore::IncludeDynamicContentScalingDisplayList"_s, sizeof(WebCore::IncludeDynamicContentScalingDisplayList), false, {
            0, 1
        } },
#endif
        { "WebCore::PlatformCursorType"_s, sizeof(WebCore::PlatformCursorType), false, {
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::Invalid),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::Pointer),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::Cross),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::Hand),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::IBeam),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::Wait),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::Help),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::EastResize),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::NorthResize),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::NorthEastResize),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::NorthWestResize),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::SouthResize),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::SouthEastResize),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::SouthWestResize),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::WestResize),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::NorthSouthResize),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::EastWestResize),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::NorthEastSouthWestResize),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::NorthWestSouthEastResize),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::ColumnResize),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::RowResize),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::MiddlePanning),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::EastPanning),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::NorthPanning),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::NorthEastPanning),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::NorthWestPanning),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::SouthPanning),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::SouthEastPanning),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::SouthWestPanning),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::WestPanning),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::Move),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::VerticalText),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::Cell),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::ContextMenu),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::Alias),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::Progress),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::NoDrop),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::Copy),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::None),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::NotAllowed),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::ZoomIn),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::ZoomOut),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::Grab),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::Grabbing),
            enumValueForIPCTestAPI(WebCore::PlatformCursorType::Custom),
        } },
        { "WebCore::ContextMenuItemType"_s, sizeof(WebCore::ContextMenuItemType), false, {
            enumValueForIPCTestAPI(WebCore::ContextMenuItemType::Action),
            enumValueForIPCTestAPI(WebCore::ContextMenuItemType::CheckableAction),
            enumValueForIPCTestAPI(WebCore::ContextMenuItemType::Separator),
            enumValueForIPCTestAPI(WebCore::ContextMenuItemType::Submenu),
        } },
        { "WebCore::PopupMenuStyle::Size"_s, sizeof(WebCore::PopupMenuStyle::Size), false, {
            enumValueForIPCTestAPI(WebCore::PopupMenuStyle::Size::Normal),
            enumValueForIPCTestAPI(WebCore::PopupMenuStyle::Size::Small),
            enumValueForIPCTestAPI(WebCore::PopupMenuStyle::Size::Mini),
            enumValueForIPCTestAPI(WebCore::PopupMenuStyle::Size::Large),
        } },
        { "WebCore::PredefinedColorSpace"_s, sizeof(WebCore::PredefinedColorSpace), false, {
            enumValueForIPCTestAPI(WebCore::PredefinedColorSpace::SRGB),
#if ENABLE(PREDEFINED_COLOR_SPACE_DISPLAY_P3)
            enumValueForIPCTestAPI(WebCore::PredefinedColorSpace::DisplayP3),
#endif
        } },
        { "WebCore::TransformOperationType"_s, sizeof(WebCore::TransformOperationType), false, {
            enumValueForIPCTestAPI(WebCore::TransformOperationType::ScaleX),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::ScaleY),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::Scale),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::TranslateX),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::TranslateY),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::Translate),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::RotateX),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::RotateY),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::Rotate),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::SkewX),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::SkewY),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::Skew),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::Matrix),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::ScaleZ),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::Scale3D),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::TranslateZ),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::Translate3D),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::RotateZ),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::Rotate3D),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::Matrix3D),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::Perspective),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::Identity),
            enumValueForIPCTestAPI(WebCore::TransformOperationType::None),
        } },
        { "WebCore::GraphicsContextGLSurfaceBuffer"_s, sizeof(WebCore::GraphicsContextGLSurfaceBuffer), false, {
            0, 1
        } },
        { "WebCore::GraphicsLayer::CustomAppearance"_s, sizeof(WebCore::GraphicsLayer::CustomAppearance), false, {
            0, 1
        } },
        { "GCGLErrorCode"_s, sizeof(GCGLErrorCode), true, {
            enumValueForIPCTestAPI(GCGLErrorCode::ContextLost),
            enumValueForIPCTestAPI(GCGLErrorCode::InvalidFramebufferOperation),
            enumValueForIPCTestAPI(GCGLErrorCode::OutOfMemory),
            enumValueForIPCTestAPI(GCGLErrorCode::InvalidOperation),
            enumValueForIPCTestAPI(GCGLErrorCode::InvalidValue),
            enumValueForIPCTestAPI(GCGLErrorCode::InvalidEnum),
        } },
#if ENABLE(VIDEO)
        { "WebCore::AudioTrackPrivate::Kind"_s, sizeof(WebCore::AudioTrackPrivate::Kind), false, {
            enumValueForIPCTestAPI(WebCore::AudioTrackPrivate::Kind::Alternative),
            enumValueForIPCTestAPI(WebCore::AudioTrackPrivate::Kind::Description),
            enumValueForIPCTestAPI(WebCore::AudioTrackPrivate::Kind::Main),
            enumValueForIPCTestAPI(WebCore::AudioTrackPrivate::Kind::MainDesc),
            enumValueForIPCTestAPI(WebCore::AudioTrackPrivate::Kind::Translation),
            enumValueForIPCTestAPI(WebCore::AudioTrackPrivate::Kind::Commentary),
            enumValueForIPCTestAPI(WebCore::AudioTrackPrivate::Kind::None),
        } },
#endif
#if ENABLE(VIDEO)
        { "WebCore::VideoTrackPrivate::Kind"_s, sizeof(WebCore::VideoTrackPrivate::Kind), false, {
            enumValueForIPCTestAPI(WebCore::VideoTrackPrivate::Kind::Alternative),
            enumValueForIPCTestAPI(WebCore::VideoTrackPrivate::Kind::Captions),
            enumValueForIPCTestAPI(WebCore::VideoTrackPrivate::Kind::Main),
            enumValueForIPCTestAPI(WebCore::VideoTrackPrivate::Kind::Sign),
            enumValueForIPCTestAPI(WebCore::VideoTrackPrivate::Kind::Subtitles),
            enumValueForIPCTestAPI(WebCore::VideoTrackPrivate::Kind::Commentary),
            enumValueForIPCTestAPI(WebCore::VideoTrackPrivate::Kind::None),
        } },
#endif
        { "WebCore::CompositeOperationType"_s, sizeof(WebCore::CompositeOperationType), false, {
            enumValueForIPCTestAPI(WebCore::CompositeOperationType::FECOMPOSITE_OPERATOR_UNKNOWN),
            enumValueForIPCTestAPI(WebCore::CompositeOperationType::FECOMPOSITE_OPERATOR_OVER),
            enumValueForIPCTestAPI(WebCore::CompositeOperationType::FECOMPOSITE_OPERATOR_IN),
            enumValueForIPCTestAPI(WebCore::CompositeOperationType::FECOMPOSITE_OPERATOR_OUT),
            enumValueForIPCTestAPI(WebCore::CompositeOperationType::FECOMPOSITE_OPERATOR_ATOP),
            enumValueForIPCTestAPI(WebCore::CompositeOperationType::FECOMPOSITE_OPERATOR_XOR),
            enumValueForIPCTestAPI(WebCore::CompositeOperationType::FECOMPOSITE_OPERATOR_ARITHMETIC),
            enumValueForIPCTestAPI(WebCore::CompositeOperationType::FECOMPOSITE_OPERATOR_LIGHTER),
        } },
        { "WebCore::ColorMatrixType"_s, sizeof(WebCore::ColorMatrixType), false, {
            enumValueForIPCTestAPI(WebCore::ColorMatrixType::FECOLORMATRIX_TYPE_UNKNOWN),
            enumValueForIPCTestAPI(WebCore::ColorMatrixType::FECOLORMATRIX_TYPE_MATRIX),
            enumValueForIPCTestAPI(WebCore::ColorMatrixType::FECOLORMATRIX_TYPE_SATURATE),
            enumValueForIPCTestAPI(WebCore::ColorMatrixType::FECOLORMATRIX_TYPE_HUEROTATE),
            enumValueForIPCTestAPI(WebCore::ColorMatrixType::FECOLORMATRIX_TYPE_LUMINANCETOALPHA),
        } },
        { "WebCore::TurbulenceType"_s, sizeof(WebCore::TurbulenceType), false, {
            enumValueForIPCTestAPI(WebCore::TurbulenceType::Unknown),
            enumValueForIPCTestAPI(WebCore::TurbulenceType::FractalNoise),
            enumValueForIPCTestAPI(WebCore::TurbulenceType::Turbulence),
        } },
        { "WebCore::FilterRenderingMode"_s, sizeof(WebCore::FilterRenderingMode), true, {
            enumValueForIPCTestAPI(WebCore::FilterRenderingMode::Software),
            enumValueForIPCTestAPI(WebCore::FilterRenderingMode::Accelerated),
            enumValueForIPCTestAPI(WebCore::FilterRenderingMode::GraphicsContext),
        } },
        { "WebCore::LightType"_s, sizeof(WebCore::LightType), false, {
            enumValueForIPCTestAPI(WebCore::LightType::LS_DISTANT),
            enumValueForIPCTestAPI(WebCore::LightType::LS_POINT),
            enumValueForIPCTestAPI(WebCore::LightType::LS_SPOT),
        } },
        { "WebCore::ComponentTransferType"_s, sizeof(WebCore::ComponentTransferType), false, {
            enumValueForIPCTestAPI(WebCore::ComponentTransferType::FECOMPONENTTRANSFER_TYPE_UNKNOWN),
            enumValueForIPCTestAPI(WebCore::ComponentTransferType::FECOMPONENTTRANSFER_TYPE_IDENTITY),
            enumValueForIPCTestAPI(WebCore::ComponentTransferType::FECOMPONENTTRANSFER_TYPE_TABLE),
            enumValueForIPCTestAPI(WebCore::ComponentTransferType::FECOMPONENTTRANSFER_TYPE_DISCRETE),
            enumValueForIPCTestAPI(WebCore::ComponentTransferType::FECOMPONENTTRANSFER_TYPE_LINEAR),
            enumValueForIPCTestAPI(WebCore::ComponentTransferType::FECOMPONENTTRANSFER_TYPE_GAMMA),
        } },
        { "WebCore::ComponentTransferChannel"_s, sizeof(WebCore::ComponentTransferChannel), false, {
            enumValueForIPCTestAPI(WebCore::ComponentTransferChannel::Red),
            enumValueForIPCTestAPI(WebCore::ComponentTransferChannel::Green),
            enumValueForIPCTestAPI(WebCore::ComponentTransferChannel::Blue),
            enumValueForIPCTestAPI(WebCore::ComponentTransferChannel::Alpha),
        } },
        { "WebCore::MorphologyOperatorType"_s, sizeof(WebCore::MorphologyOperatorType), false, {
            enumValueForIPCTestAPI(WebCore::MorphologyOperatorType::Unknown),
            enumValueForIPCTestAPI(WebCore::MorphologyOperatorType::Erode),
            enumValueForIPCTestAPI(WebCore::MorphologyOperatorType::Dilate),
        } },
        { "WebCore::ChannelSelectorType"_s, sizeof(WebCore::ChannelSelectorType), false, {
            enumValueForIPCTestAPI(WebCore::ChannelSelectorType::CHANNEL_UNKNOWN),
            enumValueForIPCTestAPI(WebCore::ChannelSelectorType::CHANNEL_R),
            enumValueForIPCTestAPI(WebCore::ChannelSelectorType::CHANNEL_G),
            enumValueForIPCTestAPI(WebCore::ChannelSelectorType::CHANNEL_B),
            enumValueForIPCTestAPI(WebCore::ChannelSelectorType::CHANNEL_A),
        } },
        { "WebCore::EdgeModeType"_s, sizeof(WebCore::EdgeModeType), false, {
            enumValueForIPCTestAPI(WebCore::EdgeModeType::Unknown),
            enumValueForIPCTestAPI(WebCore::EdgeModeType::Duplicate),
            enumValueForIPCTestAPI(WebCore::EdgeModeType::Wrap),
            enumValueForIPCTestAPI(WebCore::EdgeModeType::None),
        } },
        { "WebCore::FilterOperation::Type"_s, sizeof(WebCore::FilterOperation::Type), false, {
            enumValueForIPCTestAPI(WebCore::FilterOperation::Type::Reference),
            enumValueForIPCTestAPI(WebCore::FilterOperation::Type::Grayscale),
          