/* Generated by wayland-scanner 1.24.0 */

#ifndef XDG_DIALOG_V1_SERVER_PROTOCOL_H
#define XDG_DIALOG_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_xdg_dialog_v1 The xdg_dialog_v1 protocol
 * @section page_ifaces_xdg_dialog_v1 Interfaces
 * - @subpage page_iface_xdg_wm_dialog_v1 - create dialogs related to other toplevels
 * - @subpage page_iface_xdg_dialog_v1 - dialog object
 * @section page_copyright_xdg_dialog_v1 Copyright
 * <pre>
 *
 * Copyright © 2023 Carlos Garnacho
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct xdg_dialog_v1;
struct xdg_toplevel;
struct xdg_wm_dialog_v1;

#ifndef XDG_WM_DIALOG_V1_INTERFACE
#define XDG_WM_DIALOG_V1_INTERFACE
/**
 * @page page_iface_xdg_wm_dialog_v1 xdg_wm_dialog_v1
 * @section page_iface_xdg_wm_dialog_v1_desc Description
 *
 * The xdg_wm_dialog_v1 interface is exposed as a global object allowing
 * to register surfaces with a xdg_toplevel role as "dialogs" relative to
 * another toplevel.
 *
 * The compositor may let this relation influence how the surface is
 * placed, displayed or interacted with.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_xdg_wm_dialog_v1_api API
 * See @ref iface_xdg_wm_dialog_v1.
 */
/**
 * @defgroup iface_xdg_wm_dialog_v1 The xdg_wm_dialog_v1 interface
 *
 * The xdg_wm_dialog_v1 interface is exposed as a global object allowing
 * to register surfaces with a xdg_toplevel role as "dialogs" relative to
 * another toplevel.
 *
 * The compositor may let this relation influence how the surface is
 * placed, displayed or interacted with.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface xdg_wm_dialog_v1_interface;
#endif
#ifndef XDG_DIALOG_V1_INTERFACE
#define XDG_DIALOG_V1_INTERFACE
/**
 * @page page_iface_xdg_dialog_v1 xdg_dialog_v1
 * @section page_iface_xdg_dialog_v1_desc Description
 *
 * A xdg_dialog_v1 object is an ancillary object tied to a xdg_toplevel. Its
 * purpose is hinting the compositor that the toplevel is a "dialog" (e.g. a
 * temporary window) relative to another toplevel (see
 * xdg_toplevel.set_parent). If the xdg_toplevel is destroyed, the xdg_dialog_v1
 * becomes inert.
 *
 * Through this object, the client may provide additional hints about
 * the purpose of the secondary toplevel. This interface has no effect
 * on toplevels that are not attached to a parent toplevel.
 * @section page_iface_xdg_dialog_v1_api API
 * See @ref iface_xdg_dialog_v1.
 */
/**
 * @defgroup iface_xdg_dialog_v1 The xdg_dialog_v1 interface
 *
 * A xdg_dialog_v1 object is an ancillary object tied to a xdg_toplevel. Its
 * purpose is hinting the compositor that the toplevel is a "dialog" (e.g. a
 * temporary window) relative to another toplevel (see
 * xdg_toplevel.set_parent). If the xdg_toplevel is destroyed, the xdg_dialog_v1
 * becomes inert.
 *
 * Through this object, the client may provide additional hints about
 * the purpose of the secondary toplevel. This interface has no effect
 * on toplevels that are not attached to a parent toplevel.
 */
extern const struct wl_interface xdg_dialog_v1_interface;
#endif

#ifndef XDG_WM_DIALOG_V1_ERROR_ENUM
#define XDG_WM_DIALOG_V1_ERROR_ENUM
enum xdg_wm_dialog_v1_error {
	/**
	 * the xdg_toplevel object has already been used to create a xdg_dialog_v1
	 */
	XDG_WM_DIALOG_V1_ERROR_ALREADY_USED = 0,
};
#endif /* XDG_WM_DIALOG_V1_ERROR_ENUM */

#ifndef XDG_WM_DIALOG_V1_ERROR_ENUM_IS_VALID
#define XDG_WM_DIALOG_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_xdg_wm_dialog_v1
 * Validate a xdg_wm_dialog_v1 error value.
 *
 * @return true on success, false on error.
 * @ref xdg_wm_dialog_v1_error
 */
static inline bool
xdg_wm_dialog_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XDG_WM_DIALOG_V1_ERROR_ALREADY_USED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XDG_WM_DIALOG_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_xdg_wm_dialog_v1
 * @struct xdg_wm_dialog_v1_interface
 */
struct xdg_wm_dialog_v1_interface {
	/**
	 * destroy the dialog manager object
	 *
	 * Destroys the xdg_wm_dialog_v1 object. This does not affect the
	 * xdg_dialog_v1 objects generated through it.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create a dialog object
	 *
	 * Creates a xdg_dialog_v1 object for the given toplevel. See the
	 * interface description for more details.
	 *
	 * Compositors must raise an already_used error if clients attempt
	 * to create multiple xdg_dialog_v1 objects for the same
	 * xdg_toplevel.
	 */
	void (*get_xdg_dialog)(struct wl_client *client,
			       struct wl_resource *resource,
			       uint32_t id,
			       struct wl_resource *toplevel);
};


/**
 * @ingroup iface_xdg_wm_dialog_v1
 */
#define XDG_WM_DIALOG_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_wm_dialog_v1
 */
#define XDG_WM_DIALOG_V1_GET_XDG_DIALOG_SINCE_VERSION 1

/**
 * @ingroup iface_xdg_dialog_v1
 * @struct xdg_dialog_v1_interface
 */
struct xdg_dialog_v1_interface {
	/**
	 * destroy the dialog object
	 *
	 * Destroys the xdg_dialog_v1 object. If this object is destroyed
	 * before the related xdg_toplevel, the compositor should unapply
	 * its effects.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * mark dialog as modal
	 *
	 * Hints that the dialog has "modal" behavior. Modal dialogs
	 * typically require to be fully addressed by the user (i.e.
	 * closed) before resuming interaction with the parent toplevel,
	 * and may require a distinct presentation.
	 *
	 * Clients must implement the logic to filter events in the parent
	 * toplevel on their own.
	 *
	 * Compositors may choose any policy in event delivery to the
	 * parent toplevel, from delivering all events unfiltered to using
	 * them for internal consumption.
	 */
	void (*set_modal)(struct wl_client *client,
			  struct wl_resource *resource);
	/**
	 * mark dialog as not modal
	 *
	 * Drops the hint that this dialog has "modal" behavior. See
	 * xdg_dialog_v1.set_modal for more details.
	 */
	void (*unset_modal)(struct wl_client *client,
			    struct wl_resource *resource);
};


/**
 * @ingroup iface_xdg_dialog_v1
 */
#define XDG_DIALOG_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_dialog_v1
 */
#define XDG_DIALOG_V1_SET_MODAL_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_dialog_v1
 */
#define XDG_DIALOG_V1_UNSET_MODAL_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
