/* Generated by wayland-scanner 1.24.0 */

#ifndef WESTON_OUTPUT_CAPTURE_CLIENT_PROTOCOL_H
#define WESTON_OUTPUT_CAPTURE_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_weston_output_capture The weston_output_capture protocol
 * @section page_ifaces_weston_output_capture Interfaces
 * - @subpage page_iface_weston_capture_v1 - image capture factory
 * - @subpage page_iface_weston_capture_source_v1 - image capturing source
 * @section page_copyright_weston_output_capture Copyright
 * <pre>
 *
 * Copyright 2020, 2022 Collabora, Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct weston_capture_source_v1;
struct weston_capture_v1;
struct wl_buffer;
struct wl_output;

#ifndef WESTON_CAPTURE_V1_INTERFACE
#define WESTON_CAPTURE_V1_INTERFACE
/**
 * @page page_iface_weston_capture_v1 weston_capture_v1
 * @section page_iface_weston_capture_v1_desc Description
 *
 * The global interface exposing Weston screenshooting functionality
 * intended for single shots.
 *
 * This is a privileged inteface.
 * @section page_iface_weston_capture_v1_api API
 * See @ref iface_weston_capture_v1.
 */
/**
 * @defgroup iface_weston_capture_v1 The weston_capture_v1 interface
 *
 * The global interface exposing Weston screenshooting functionality
 * intended for single shots.
 *
 * This is a privileged inteface.
 */
extern const struct wl_interface weston_capture_v1_interface;
#endif
#ifndef WESTON_CAPTURE_SOURCE_V1_INTERFACE
#define WESTON_CAPTURE_SOURCE_V1_INTERFACE
/**
 * @page page_iface_weston_capture_source_v1 weston_capture_source_v1
 * @section page_iface_weston_capture_source_v1_desc Description
 *
 * An object representing image capturing functionality for a single
 * source. When created, it sends the initial events if and only if the
 * output still exists and the specified pixel source is available on
 * the output.
 * @section page_iface_weston_capture_source_v1_api API
 * See @ref iface_weston_capture_source_v1.
 */
/**
 * @defgroup iface_weston_capture_source_v1 The weston_capture_source_v1 interface
 *
 * An object representing image capturing functionality for a single
 * source. When created, it sends the initial events if and only if the
 * output still exists and the specified pixel source is available on
 * the output.
 */
extern const struct wl_interface weston_capture_source_v1_interface;
#endif

#ifndef WESTON_CAPTURE_V1_ERROR_ENUM
#define WESTON_CAPTURE_V1_ERROR_ENUM
enum weston_capture_v1_error {
	/**
	 * invalid source enum value
	 */
	WESTON_CAPTURE_V1_ERROR_INVALID_SOURCE = 0,
};
#endif /* WESTON_CAPTURE_V1_ERROR_ENUM */

#ifndef WESTON_CAPTURE_V1_SOURCE_ENUM
#define WESTON_CAPTURE_V1_SOURCE_ENUM
enum weston_capture_v1_source {
	/**
	 * use hardware writeback
	 */
	WESTON_CAPTURE_V1_SOURCE_WRITEBACK = 0,
	/**
	 * copy from framebuffer, desktop area
	 */
	WESTON_CAPTURE_V1_SOURCE_FRAMEBUFFER = 1,
	/**
	 * copy whole framebuffer, including borders
	 */
	WESTON_CAPTURE_V1_SOURCE_FULL_FRAMEBUFFER = 2,
	/**
	 * copy from blending space
	 */
	WESTON_CAPTURE_V1_SOURCE_BLENDING = 3,
};
#endif /* WESTON_CAPTURE_V1_SOURCE_ENUM */

#define WESTON_CAPTURE_V1_DESTROY 0
#define WESTON_CAPTURE_V1_CREATE 1


/**
 * @ingroup iface_weston_capture_v1
 */
#define WESTON_CAPTURE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_weston_capture_v1
 */
#define WESTON_CAPTURE_V1_CREATE_SINCE_VERSION 1

/** @ingroup iface_weston_capture_v1 */
static inline void
weston_capture_v1_set_user_data(struct weston_capture_v1 *weston_capture_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) weston_capture_v1, user_data);
}

/** @ingroup iface_weston_capture_v1 */
static inline void *
weston_capture_v1_get_user_data(struct weston_capture_v1 *weston_capture_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) weston_capture_v1);
}

static inline uint32_t
weston_capture_v1_get_version(struct weston_capture_v1 *weston_capture_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) weston_capture_v1);
}

/**
 * @ingroup iface_weston_capture_v1
 *
 * Affects no other protocol objects in any way.
 */
static inline void
weston_capture_v1_destroy(struct weston_capture_v1 *weston_capture_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_capture_v1,
			 WESTON_CAPTURE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) weston_capture_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_weston_capture_v1
 *
 * This creates a weston_capture_source_v1 object corresponding to the
 * given wl_output. The object delivers information for allocating
 * suitable buffers, and exposes the capture function.
 *
 * The object will be using the given pixel source for capturing images.
 * If the source is not available, all attempts to capture will fail
 * gracefully.
 *
 * 'writeback' source will use hardware writeback feature of DRM KMS for
 * capturing. This may allow hardware planes to remain used
 * during the capture. This source is often not available.
 *
 * 'framebuffer' source copies the contents of the final framebuffer.
 * Using this source temporarily disables all use of hardware planes and
 * DRM KMS color pipeline features. This source is always available.
 *
 * 'full_framebuffer' is otherwise the same as 'framebuffer' except it
 * will include also any borders (decorations) that the framebuffer may
 * contain.
 *
 * 'blending' source copies the contents of the intermediate blending
 * buffer, which should be in linear-light format.  Using this source
 * temporarily disables all use of hardware planes. This source is only
 * available when a blending buffer exists, e.g. when color management
 * is active on the output.
 *
 * If the pixel source is not one of the defined enumeration values,
 * 'invalid_source' protocol error is raised.
 */
static inline struct weston_capture_source_v1 *
weston_capture_v1_create(struct weston_capture_v1 *weston_capture_v1, struct wl_output *output, uint32_t source)
{
	struct wl_proxy *capture_source_new_id;

	capture_source_new_id = wl_proxy_marshal_flags((struct wl_proxy *) weston_capture_v1,
			 WESTON_CAPTURE_V1_CREATE, &weston_capture_source_v1_interface, wl_proxy_get_version((struct wl_proxy *) weston_capture_v1), 0, output, source, NULL);

	return (struct weston_capture_source_v1 *) capture_source_new_id;
}

#ifndef WESTON_CAPTURE_SOURCE_V1_ERROR_ENUM
#define WESTON_CAPTURE_SOURCE_V1_ERROR_ENUM
enum weston_capture_source_v1_error {
	/**
	 * the wl_buffer is not writable
	 */
	WESTON_CAPTURE_SOURCE_V1_ERROR_BAD_BUFFER = 0,
	/**
	 * capture requested again before previous retired
	 */
	WESTON_CAPTURE_SOURCE_V1_ERROR_SEQUENCE = 1,
};
#endif /* WESTON_CAPTURE_SOURCE_V1_ERROR_ENUM */

/**
 * @ingroup iface_weston_capture_source_v1
 * @struct weston_capture_source_v1_listener
 */
struct weston_capture_source_v1_listener {
	/**
	 * pixel format for a buffer
	 *
	 * This event delivers the pixel format that should be used for
	 * the image buffer. Any buffer is incompatible if it does not have
	 * this pixel format.
	 *
	 * The format modifier is linear (DRM_FORMAT_MOD_LINEAR).
	 *
	 * This is an initial event, and sent whenever the required format
	 * changes.
	 * @param drm_format DRM pixel format code
	 */
	void (*format)(void *data,
		       struct weston_capture_source_v1 *weston_capture_source_v1,
		       uint32_t drm_format);
	/**
	 * dimensions for a buffer
	 *
	 * This event delivers the size that should be used for the image
	 * buffer. Any buffer is incompatible if it does not have this
	 * size.
	 *
	 * Row alignment of the buffer must be 4 bytes, and it must not
	 * contain further row padding. Otherwise the buffer is
	 * unsupported.
	 *
	 * This is an initial event, and sent whenever the required size
	 * changes.
	 * @param width width in pixels
	 * @param height height in pixels
	 */
	void (*size)(void *data,
		     struct weston_capture_source_v1 *weston_capture_source_v1,
		     int32_t width,
		     int32_t height);
	/**
	 * capture has completed
	 *
	 * This event is emitted as a response to 'capture' request when
	 * it has successfully completed.
	 *
	 * If the buffer used in the shot is a dmabuf, the client also
	 * needs to wait for any implicit fences on it before accessing the
	 * contents.
	 */
	void (*complete)(void *data,
			 struct weston_capture_source_v1 *weston_capture_source_v1);
	/**
	 * retry image capture with a different buffer
	 *
	 * This event is emitted as a response to 'capture' request when
	 * it cannot succeed due to an incompatible buffer. The client has
	 * already received the events delivering the new buffer
	 * parameters. The client should retry the capture with the new
	 * buffer parameters.
	 */
	void (*retry)(void *data,
		      struct weston_capture_source_v1 *weston_capture_source_v1);
	/**
	 * capture failed
	 *
	 * This event is emitted as a response to 'capture' request when
	 * it has failed for reasons other than an incompatible buffer. The
	 * reasons may include: unsupported buffer type, unsupported buffer
	 * stride, unsupported image source, the image source (output) was
	 * removed, or compositor policy denied the capture.
	 *
	 * The string 'msg' may contain a human-readable explanation of the
	 * failure to aid debugging.
	 * @param msg human-readable hint
	 */
	void (*failed)(void *data,
		       struct weston_capture_source_v1 *weston_capture_source_v1,
		       const char *msg);
};

/**
 * @ingroup iface_weston_capture_source_v1
 */
static inline int
weston_capture_source_v1_add_listener(struct weston_capture_source_v1 *weston_capture_source_v1,
				      const struct weston_capture_source_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) weston_capture_source_v1,
				     (void (**)(void)) listener, data);
}

#define WESTON_CAPTURE_SOURCE_V1_DESTROY 0
#define WESTON_CAPTURE_SOURCE_V1_CAPTURE 1

/**
 * @ingroup iface_weston_capture_source_v1
 */
#define WESTON_CAPTURE_SOURCE_V1_FORMAT_SINCE_VERSION 1
/**
 * @ingroup iface_weston_capture_source_v1
 */
#define WESTON_CAPTURE_SOURCE_V1_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_capture_source_v1
 */
#define WESTON_CAPTURE_SOURCE_V1_COMPLETE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_capture_source_v1
 */
#define WESTON_CAPTURE_SOURCE_V1_RETRY_SINCE_VERSION 1
/**
 * @ingroup iface_weston_capture_source_v1
 */
#define WESTON_CAPTURE_SOURCE_V1_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_weston_capture_source_v1
 */
#define WESTON_CAPTURE_SOURCE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_weston_capture_source_v1
 */
#define WESTON_CAPTURE_SOURCE_V1_CAPTURE_SINCE_VERSION 1

/** @ingroup iface_weston_capture_source_v1 */
static inline void
weston_capture_source_v1_set_user_data(struct weston_capture_source_v1 *weston_capture_source_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) weston_capture_source_v1, user_data);
}

/** @ingroup iface_weston_capture_source_v1 */
static inline void *
weston_capture_source_v1_get_user_data(struct weston_capture_source_v1 *weston_capture_source_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) weston_capture_source_v1);
}

static inline uint32_t
weston_capture_source_v1_get_version(struct weston_capture_source_v1 *weston_capture_source_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) weston_capture_source_v1);
}

/**
 * @ingroup iface_weston_capture_source_v1
 *
 * If a capture is on-going on this object, this will cancel it and
 * make the image buffer contents undefined.
 *
 * This object is destroyed.
 */
static inline void
weston_capture_source_v1_destroy(struct weston_capture_source_v1 *weston_capture_source_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_capture_source_v1,
			 WESTON_CAPTURE_SOURCE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) weston_capture_source_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_weston_capture_source_v1
 *
 * If the given wl_buffer is compatible, the associated output will go
 * through a repaint some time after this request has been processed,
 * and that repaint will execute the capture.
 * Once the capture is complete, 'complete' event is emitted.
 *
 * If the given wl_buffer is incompatible, the event 'retry' is
 * emitted.
 *
 * If the capture fails or the buffer type is unsupported, the event
 * 'failed' is emitted.
 *
 * The client must wait for one of these events before attempting
 * 'capture' on this object again. If 'capture' is requested again before
 * any of those events, 'sequence' protocol error is raised.
 *
 * The wl_buffer object will not emit wl_buffer.release event due to
 * this request.
 *
 * The wl_buffer must refer to compositor-writable storage. If buffer
 * storage is not writable, either the protocol error bad_buffer or
 * wl_shm.error.invalid_fd is raised.
 *
 * If the wl_buffer is destroyed before any event is emitted, the buffer
 * contents become undefined.
 *
 * A compositor is required to implement capture into wl_shm buffers.
 * Other buffer types may or may not be supported.
 */
static inline void
weston_capture_source_v1_capture(struct weston_capture_source_v1 *weston_capture_source_v1, struct wl_buffer *buffer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_capture_source_v1,
			 WESTON_CAPTURE_SOURCE_V1_CAPTURE, NULL, wl_proxy_get_version((struct wl_proxy *) weston_capture_source_v1), 0, buffer);
}

#ifdef  __cplusplus
}
#endif

#endif
