/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSScrollLogicalPosition.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ScrollLogicalPosition enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 4> values {
        MAKE_STATIC_STRING_IMPL("start"),
        MAKE_STATIC_STRING_IMPL("center"),
        MAKE_STATIC_STRING_IMPL("end"),
        MAKE_STATIC_STRING_IMPL("nearest"),
    };
    static_assert(static_cast<size_t>(ScrollLogicalPosition::Start) == 0, "ScrollLogicalPosition::Start is not 0 as expected");
    static_assert(static_cast<size_t>(ScrollLogicalPosition::Center) == 1, "ScrollLogicalPosition::Center is not 1 as expected");
    static_assert(static_cast<size_t>(ScrollLogicalPosition::End) == 2, "ScrollLogicalPosition::End is not 2 as expected");
    static_assert(static_cast<size_t>(ScrollLogicalPosition::Nearest) == 3, "ScrollLogicalPosition::Nearest is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ScrollLogicalPosition enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ScrollLogicalPosition> parseEnumerationFromString<ScrollLogicalPosition>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, ScrollLogicalPosition>, 4> mappings {
        std::pair<ComparableASCIILiteral, ScrollLogicalPosition> { "center"_s, ScrollLogicalPosition::Center },
        std::pair<ComparableASCIILiteral, ScrollLogicalPosition> { "end"_s, ScrollLogicalPosition::End },
        std::pair<ComparableASCIILiteral, ScrollLogicalPosition> { "nearest"_s, ScrollLogicalPosition::Nearest },
        std::pair<ComparableASCIILiteral, ScrollLogicalPosition> { "start"_s, ScrollLogicalPosition::Start },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ScrollLogicalPosition> parseEnumeration<ScrollLogicalPosition>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ScrollLogicalPosition>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<ScrollLogicalPosition>()
{
    return "\"start\", \"center\", \"end\", \"nearest\""_s;
}

} // namespace WebCore

