/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSOfflineAudioCompletionEvent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSAudioBuffer.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSOfflineAudioCompletionEventInit.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsOfflineAudioCompletionEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsOfflineAudioCompletionEvent_renderedBuffer);

class JSOfflineAudioCompletionEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOfflineAudioCompletionEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOfflineAudioCompletionEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSOfflineAudioCompletionEventPrototype>(vm)) JSOfflineAudioCompletionEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOfflineAudioCompletionEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOfflineAudioCompletionEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOfflineAudioCompletionEventPrototype, JSOfflineAudioCompletionEventPrototype::Base);

using JSOfflineAudioCompletionEventDOMConstructor = JSDOMConstructor<JSOfflineAudioCompletionEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSOfflineAudioCompletionEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSOfflineAudioCompletionEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<OfflineAudioCompletionEventInit>>(*lexicalGlobalObject, argument1.value());
    if (eventInitDictConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = OfflineAudioCompletionEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<OfflineAudioCompletionEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<OfflineAudioCompletionEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSOfflineAudioCompletionEventDOMConstructorConstruct, JSOfflineAudioCompletionEventDOMConstructor::construct);

template<> const ClassInfo JSOfflineAudioCompletionEventDOMConstructor::s_info = { "OfflineAudioCompletionEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOfflineAudioCompletionEventDOMConstructor) };

template<> JSValue JSOfflineAudioCompletionEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSOfflineAudioCompletionEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "OfflineAudioCompletionEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSOfflineAudioCompletionEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSOfflineAudioCompletionEventPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsOfflineAudioCompletionEventConstructor, 0 } },
    HashTableValue { "renderedBuffer"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOfflineAudioCompletionEvent_renderedBuffer, 0 } },
};

const ClassInfo JSOfflineAudioCompletionEventPrototype::s_info = { "OfflineAudioCompletionEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOfflineAudioCompletionEventPrototype) };

void JSOfflineAudioCompletionEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOfflineAudioCompletionEvent::info(), JSOfflineAudioCompletionEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOfflineAudioCompletionEvent::s_info = { "OfflineAudioCompletionEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOfflineAudioCompletionEvent) };

JSOfflineAudioCompletionEvent::JSOfflineAudioCompletionEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OfflineAudioCompletionEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<OfflineAudioCompletionEvent> JSOfflineAudioCompletionEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, OfflineAudioCompletionEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSOfflineAudioCompletionEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOfflineAudioCompletionEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSOfflineAudioCompletionEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOfflineAudioCompletionEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOfflineAudioCompletionEvent>(vm, globalObject);
}

JSValue JSOfflineAudioCompletionEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOfflineAudioCompletionEventDOMConstructor, DOMConstructorID::OfflineAudioCompletionEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsOfflineAudioCompletionEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSOfflineAudioCompletionEventPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSOfflineAudioCompletionEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsOfflineAudioCompletionEvent_renderedBufferGetter(JSGlobalObject& lexicalGlobalObject, JSOfflineAudioCompletionEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioBuffer>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.renderedBuffer())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOfflineAudioCompletionEvent_renderedBuffer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOfflineAudioCompletionEvent>::get<jsOfflineAudioCompletionEvent_renderedBufferGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSOfflineAudioCompletionEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOfflineAudioCompletionEvent, UseCustomHeapCellType::No>(vm, "JSOfflineAudioCompletionEvent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOfflineAudioCompletionEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOfflineAudioCompletionEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOfflineAudioCompletionEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOfflineAudioCompletionEvent = std::forward<decltype(space)>(space); }
    );
}

void JSOfflineAudioCompletionEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOfflineAudioCompletionEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OfflineAudioCompletionEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27OfflineAudioCompletionEventE[]; }
#endif
template<std::same_as<OfflineAudioCompletionEvent> T>
static inline void verifyVTable(OfflineAudioCompletionEvent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OfflineAudioCompletionEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore27OfflineAudioCompletionEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OfflineAudioCompletionEvent has subclasses. If OfflineAudioCompletionEvent has subclasses that get passed
        // to toJS() we currently require OfflineAudioCompletionEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OfflineAudioCompletionEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<OfflineAudioCompletionEvent>(impl.ptr());
#endif
    return createWrapper<OfflineAudioCompletionEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OfflineAudioCompletionEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
