/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GAMEPAD)

#include "JSGamepadHapticEffectType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GamepadHapticEffectType enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("dual-rumble"),
        MAKE_STATIC_STRING_IMPL("trigger-rumble"),
    };
    static_assert(static_cast<size_t>(GamepadHapticEffectType::DualRumble) == 0, "GamepadHapticEffectType::DualRumble is not 0 as expected");
    static_assert(static_cast<size_t>(GamepadHapticEffectType::TriggerRumble) == 1, "GamepadHapticEffectType::TriggerRumble is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GamepadHapticEffectType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GamepadHapticEffectType> parseEnumerationFromString<GamepadHapticEffectType>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, GamepadHapticEffectType>, 2> mappings {
        std::pair<ComparableASCIILiteral, GamepadHapticEffectType> { "dual-rumble"_s, GamepadHapticEffectType::DualRumble },
        std::pair<ComparableASCIILiteral, GamepadHapticEffectType> { "trigger-rumble"_s, GamepadHapticEffectType::TriggerRumble },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GamepadHapticEffectType> parseEnumeration<GamepadHapticEffectType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GamepadHapticEffectType>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GamepadHapticEffectType>()
{
    return "\"dual-rumble\", \"trigger-rumble\""_s;
}

} // namespace WebCore


#endif // ENABLE(GAMEPAD)
