/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUPrimitiveState.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertOptional.h"
#include "JSGPUCullMode.h"
#include "JSGPUFrontFace.h"
#include "JSGPUIndexFormat.h"
#include "JSGPUPrimitiveTopology.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUPrimitiveState>> convertDictionary<GPUPrimitiveState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUPrimitiveState result;
    JSValue cullModeValue;
    if (isNullOrUndefined)
        cullModeValue = jsUndefined();
    else {
        cullModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cullMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cullModeConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUCullMode>>(lexicalGlobalObject, cullModeValue, [&]() -> ConversionResult<IDLEnumeration<GPUCullMode>> { return Converter<IDLEnumeration<GPUCullMode>>::ReturnType { GPUCullMode::None }; });
    if (cullModeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.cullMode = cullModeConversionResult.releaseReturnValue();
    JSValue frontFaceValue;
    if (isNullOrUndefined)
        frontFaceValue = jsUndefined();
    else {
        frontFaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frontFace"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto frontFaceConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUFrontFace>>(lexicalGlobalObject, frontFaceValue, [&]() -> ConversionResult<IDLEnumeration<GPUFrontFace>> { return Converter<IDLEnumeration<GPUFrontFace>>::ReturnType { GPUFrontFace::Ccw }; });
    if (frontFaceConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.frontFace = frontFaceConversionResult.releaseReturnValue();
    JSValue stripIndexFormatValue;
    if (isNullOrUndefined)
        stripIndexFormatValue = jsUndefined();
    else {
        stripIndexFormatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stripIndexFormat"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!stripIndexFormatValue.isUndefined()) {
        auto stripIndexFormatConversionResult = convert<IDLEnumeration<GPUIndexFormat>>(lexicalGlobalObject, stripIndexFormatValue);
        if (stripIndexFormatConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.stripIndexFormat = stripIndexFormatConversionResult.releaseReturnValue();
    }
    JSValue topologyValue;
    if (isNullOrUndefined)
        topologyValue = jsUndefined();
    else {
        topologyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "topology"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto topologyConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUPrimitiveTopology>>(lexicalGlobalObject, topologyValue, [&]() -> ConversionResult<IDLEnumeration<GPUPrimitiveTopology>> { return Converter<IDLEnumeration<GPUPrimitiveTopology>>::ReturnType { GPUPrimitiveTopology::TriangleList }; });
    if (topologyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.topology = topologyConversionResult.releaseReturnValue();
    JSValue unclippedDepthValue;
    if (isNullOrUndefined)
        unclippedDepthValue = jsUndefined();
    else {
        unclippedDepthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "unclippedDepth"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto unclippedDepthConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, unclippedDepthValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (unclippedDepthConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.unclippedDepth = unclippedDepthConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

