// java wrapper for vtkVRRay object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVRRay.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVRRay_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVRRay",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRRay_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRay* op = static_cast<vtkVRRay*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRRay_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRay* op = static_cast<vtkVRRay*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRRay_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRay* op = static_cast<vtkVRRay*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRRay_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRay* op = static_cast<vtkVRRay*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVRRay_Build_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkOpenGLRenderWindow * temp0;
  bool   temp20;
  temp0 = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVRRay* op = static_cast<vtkVRRay*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Build(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRay_Render_15(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkOpenGLRenderWindow * temp0;
  vtkMatrix4x4 * temp1;
  temp0 = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id1));

  vtkVRRay* op = static_cast<vtkVRRay*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRay_SetShow_16(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkVRRay* op = static_cast<vtkVRRay*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShow(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVRRay_GetShow_17(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkVRRay* op = static_cast<vtkVRRay*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShow();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRay_SetLength_18(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkVRRay* op = static_cast<vtkVRRay*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLength(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRay_SetColor_19(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2)
{
  float   temp0;
  float   temp1;
  float   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkVRRay* op = static_cast<vtkVRRay*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRay_SetColor_110(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkVRRay* op = static_cast<vtkVRRay*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRay_ReleaseGraphicsResources_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVRRay* op = static_cast<vtkVRRay*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkVRRay_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkVRRay::New());
}
