// java wrapper for vtkBlockItem object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkBlockItem.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkContextItem_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkBlockItem_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkBlockItem",dType)) { return me; }
  if ((res= vtkContextItem_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBlockItem_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBlockItem_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBlockItem_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBlockItem_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkBlockItem_Paint_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContext2D * temp0;
  bool   temp20;
  temp0 = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Paint(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBlockItem_SetLabel_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabel(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkBlockItem_GetLabel_16(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabel();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBlockItem_SetDimensions_17(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jfloat id3)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBlockItem_SetDimensions_18(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[4];
  env->GetFloatArrayRegion(id0, 0, 4, &temp0[0]);

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkBlockItem_GetDimensions_19(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensions();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBlockItem_SetAutoComputeDimensions_110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAutoComputeDimensions(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkBlockItem_GetAutoComputeDimensions_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutoComputeDimensions();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBlockItem_AutoComputeDimensionsOn_112(JNIEnv* env, jobject obj)
{

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoComputeDimensionsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBlockItem_AutoComputeDimensionsOff_113(JNIEnv* env, jobject obj)
{

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoComputeDimensionsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBlockItem_SetHorizontalAlignment_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHorizontalAlignment(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBlockItem_GetHorizontalAlignment_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHorizontalAlignment();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBlockItem_SetVerticalAlignment_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVerticalAlignment(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBlockItem_GetVerticalAlignment_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVerticalAlignment();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBlockItem_SetPadding_118(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPadding(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBlockItem_SetPadding_119(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPadding(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkBlockItem_GetPadding_120(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPadding();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBlockItem_SetMargins_121(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMargins(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBlockItem_SetMargins_122(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMargins(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkBlockItem_GetMargins_123(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMargins();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBlockItem_GetPen_124(JNIEnv* env, jobject obj)
{
  vtkPen * temp20;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPen();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBlockItem_GetBrush_125(JNIEnv* env, jobject obj)
{
  vtkBrush * temp20;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBrush();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBlockItem_GetMouseOverBrush_126(JNIEnv* env, jobject obj)
{
  vtkBrush * temp20;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMouseOverBrush();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBlockItem_SetLabelProperties_127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelProperties(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBlockItem_GetLabelProperties_128(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkBlockItem* op = static_cast<vtkBlockItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelProperties();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkBlockItem_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkBlockItem::New());
}
