// java wrapper for vtkAxesActor object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAxesActor.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkProp3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAxesActor_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAxesActor",dType)) { return me; }
  if ((res= vtkProp3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_GetActors_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetActors(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_RenderOpaqueGeometry_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_RenderTranslucentPolygonalGeometry_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_RenderOverlay_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_HasTranslucentPolygonalGeometry_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_ShallowCopy_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_ReleaseGraphicsResources_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_GetBounds_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAxesActor_GetBounds_112(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetMTime_113(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetRedrawMTime_114(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRedrawMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetTotalLength_115(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTotalLength(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetTotalLength_116(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTotalLength(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAxesActor_GetTotalLength_117(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTotalLength();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetNormalizedShaftLength_118(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalizedShaftLength(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetNormalizedShaftLength_119(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalizedShaftLength(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAxesActor_GetNormalizedShaftLength_120(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalizedShaftLength();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetNormalizedTipLength_121(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalizedTipLength(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetNormalizedTipLength_122(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalizedTipLength(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAxesActor_GetNormalizedTipLength_123(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalizedTipLength();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetNormalizedLabelPosition_124(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalizedLabelPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetNormalizedLabelPosition_125(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalizedLabelPosition(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAxesActor_GetNormalizedLabelPosition_126(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalizedLabelPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetConeResolution_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConeResolution(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_GetConeResolutionMinValue_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConeResolutionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_GetConeResolutionMaxValue_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConeResolutionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_GetConeResolution_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConeResolution();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetSphereResolution_131(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSphereResolution(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_GetSphereResolutionMinValue_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSphereResolutionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_GetSphereResolutionMaxValue_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSphereResolutionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_GetSphereResolution_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSphereResolution();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetCylinderResolution_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCylinderResolution(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_GetCylinderResolutionMinValue_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCylinderResolutionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_GetCylinderResolutionMaxValue_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCylinderResolutionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_GetCylinderResolution_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCylinderResolution();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetConeRadius_139(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConeRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxesActor_GetConeRadiusMinValue_140(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConeRadiusMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxesActor_GetConeRadiusMaxValue_141(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConeRadiusMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxesActor_GetConeRadius_142(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConeRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetSphereRadius_143(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSphereRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxesActor_GetSphereRadiusMinValue_144(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSphereRadiusMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxesActor_GetSphereRadiusMaxValue_145(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSphereRadiusMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxesActor_GetSphereRadius_146(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSphereRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetCylinderRadius_147(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCylinderRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxesActor_GetCylinderRadiusMinValue_148(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCylinderRadiusMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxesActor_GetCylinderRadiusMaxValue_149(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCylinderRadiusMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxesActor_GetCylinderRadius_150(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCylinderRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetShaftType_151(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShaftType(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetShaftTypeToCylinder_152(JNIEnv* env, jobject obj)
{

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShaftTypeToCylinder();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetShaftTypeToLine_153(JNIEnv* env, jobject obj)
{

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShaftTypeToLine();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetShaftTypeToUserDefined_154(JNIEnv* env, jobject obj)
{

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShaftTypeToUserDefined();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_GetShaftType_155(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShaftType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetTipType_156(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTipType(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetTipTypeToCone_157(JNIEnv* env, jobject obj)
{

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTipTypeToCone();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetTipTypeToSphere_158(JNIEnv* env, jobject obj)
{

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTipTypeToSphere();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetTipTypeToUserDefined_159(JNIEnv* env, jobject obj)
{

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTipTypeToUserDefined();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_GetTipType_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTipType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetUserDefinedTip_161(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUserDefinedTip(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetUserDefinedTip_162(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUserDefinedTip();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetUserDefinedShaft_163(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUserDefinedShaft(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetUserDefinedShaft_164(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUserDefinedShaft();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetXAxisTipProperty_165(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxisTipProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetYAxisTipProperty_166(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxisTipProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetZAxisTipProperty_167(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxisTipProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetXAxisShaftProperty_168(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxisShaftProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetYAxisShaftProperty_169(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxisShaftProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetZAxisShaftProperty_170(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxisShaftProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetXAxisCaptionActor2D_171(JNIEnv* env, jobject obj)
{
  vtkCaptionActor2D * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxisCaptionActor2D();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetYAxisCaptionActor2D_172(JNIEnv* env, jobject obj)
{
  vtkCaptionActor2D * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxisCaptionActor2D();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxesActor_GetZAxisCaptionActor2D_173(JNIEnv* env, jobject obj)
{
  vtkCaptionActor2D * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxisCaptionActor2D();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetXAxisLabelText_174(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxisLabelText(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAxesActor_GetXAxisLabelText_175(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxisLabelText();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetYAxisLabelText_176(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxisLabelText(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAxesActor_GetYAxisLabelText_177(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxisLabelText();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetZAxisLabelText_178(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZAxisLabelText(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAxesActor_GetZAxisLabelText_179(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxisLabelText();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_SetAxisLabels_180(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabels(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxesActor_GetAxisLabels_181(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisLabels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_AxisLabelsOn_182(JNIEnv* env, jobject obj)
{

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxisLabelsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxesActor_AxisLabelsOff_183(JNIEnv* env, jobject obj)
{

  vtkAxesActor* op = static_cast<vtkAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxisLabelsOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkAxesActor_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkAxesActor::New());
}
