// java wrapper for vtkContourRepresentation object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkContourRepresentation.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWidgetRepresentation_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkContourRepresentation_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkContourRepresentation",dType)) { return me; }
  if ((res= vtkWidgetRepresentation_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContourRepresentation_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContourRepresentation_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_AddNodeAtWorldPosition_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddNodeAtWorldPosition(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_AddNodeAtWorldPosition_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddNodeAtWorldPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_AddNodeAtWorldPosition_16(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[9];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 9, &temp1[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddNodeAtWorldPosition(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 9, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_AddNodeAtDisplayPosition_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddNodeAtDisplayPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_AddNodeAtDisplayPosition_18(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  int   temp20;
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddNodeAtDisplayPosition(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_AddNodeAtDisplayPosition_19(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddNodeAtDisplayPosition(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_ActivateNode_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ActivateNode(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_ActivateNode_111(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  int   temp20;
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ActivateNode(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_ActivateNode_112(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ActivateNode(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_SetActiveNodeToWorldPosition_113(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveNodeToWorldPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_SetActiveNodeToWorldPosition_114(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[9];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 9, &temp1[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveNodeToWorldPosition(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 9, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_SetActiveNodeToDisplayPosition_115(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveNodeToDisplayPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_SetActiveNodeToDisplayPosition_116(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  int   temp20;
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveNodeToDisplayPosition(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_SetActiveNodeToDisplayPosition_117(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveNodeToDisplayPosition(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_ToggleActiveNodeSelected_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ToggleActiveNodeSelected();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetActiveNodeSelected_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActiveNodeSelected();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetNthNodeSelected_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNthNodeSelected(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_SetNthNodeSelected_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNthNodeSelected(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetActiveNodeWorldPosition_122(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActiveNodeWorldPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetActiveNodeWorldOrientation_123(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[9];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActiveNodeWorldOrientation(temp0);
  env->SetDoubleArrayRegion(id0, 0, 9, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetActiveNodeDisplayPosition_124(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActiveNodeDisplayPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetNumberOfNodes_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNodes();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetNthNodeDisplayPosition_126(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[2];
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNthNodeDisplayPosition(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetNthNodeWorldPosition_127(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[3];
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNthNodeWorldPosition(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetNthNodeWorldOrientation_128(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[9];
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 9, &temp1[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNthNodeWorldOrientation(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 9, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_SetNthNodeDisplayPosition_129(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNthNodeDisplayPosition(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_SetNthNodeDisplayPosition_130(JNIEnv* env, jobject obj,jint id0,jintArray id1)
{
  int   temp0;
  int temp1[2];
  int   temp20;
  temp0 = id0;
  env->GetIntArrayRegion(id1, 0, 2, reinterpret_cast<jint*>(&temp1[0]));

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNthNodeDisplayPosition(temp0,temp1);
  env->SetIntArrayRegion(id1, 0, 2, reinterpret_cast<jint*>(&temp1[0]));
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_SetNthNodeDisplayPosition_131(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[2];
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNthNodeDisplayPosition(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_SetNthNodeWorldPosition_132(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[3];
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNthNodeWorldPosition(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_SetNthNodeWorldPosition_133(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jdoubleArray id2)
{
  int   temp0;
  double temp1[3];
  double temp2[9];
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 9, &temp2[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNthNodeWorldPosition(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 9, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetNthNodeSlope_134(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[3];
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNthNodeSlope(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetNumberOfIntermediatePoints_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfIntermediatePoints(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetIntermediatePointWorldPosition_136(JNIEnv* env, jobject obj,jint id0,jint id1,jdoubleArray id2)
{
  int   temp0;
  int   temp1;
  double temp2[3];
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntermediatePointWorldPosition(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_AddIntermediatePointWorldPosition_137(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[3];
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddIntermediatePointWorldPosition(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_AddIntermediatePointWorldPosition_138(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jlong id2)
{
  int   temp0;
  double temp1[3];
  long long   temp2;
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = id2;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddIntermediatePointWorldPosition(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_DeleteLastNode_139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DeleteLastNode();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_DeleteActiveNode_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DeleteActiveNode();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_DeleteNthNode_141(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DeleteNthNode(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_ClearAllNodes_142(JNIEnv* env, jobject obj)
{

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearAllNodes();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_AddNodeOnContour_143(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddNodeOnContour(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_SetPixelTolerance_144(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPixelTolerance(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetPixelToleranceMinValue_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPixelToleranceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetPixelToleranceMaxValue_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPixelToleranceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetPixelTolerance_147(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPixelTolerance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_SetWorldTolerance_148(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWorldTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkContourRepresentation_GetWorldToleranceMinValue_149(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWorldToleranceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkContourRepresentation_GetWorldToleranceMaxValue_150(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWorldToleranceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkContourRepresentation_GetWorldTolerance_151(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWorldTolerance();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetCurrentOperation_152(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentOperation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_SetCurrentOperation_153(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCurrentOperation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetCurrentOperationMinValue_154(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentOperationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetCurrentOperationMaxValue_155(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentOperationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_SetCurrentOperationToInactive_156(JNIEnv* env, jobject obj)
{

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCurrentOperationToInactive();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_SetCurrentOperationToTranslate_157(JNIEnv* env, jobject obj)
{

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCurrentOperationToTranslate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_SetCurrentOperationToShift_158(JNIEnv* env, jobject obj)
{

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCurrentOperationToShift();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_SetCurrentOperationToScale_159(JNIEnv* env, jobject obj)
{

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCurrentOperationToScale();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_SetPointPlacer_160(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPointPlacer * temp0;
  temp0 = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointPlacer(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContourRepresentation_GetPointPlacer_161(JNIEnv* env, jobject obj)
{
  vtkPointPlacer * temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointPlacer();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_SetLineInterpolator_162(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContourLineInterpolator * temp0;
  temp0 = static_cast<vtkContourLineInterpolator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineInterpolator(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContourRepresentation_GetLineInterpolator_163(JNIEnv* env, jobject obj)
{
  vtkContourLineInterpolator * temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineInterpolator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_BuildRepresentation_164(JNIEnv* env, jobject obj)
{

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildRepresentation();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_ComputeInteractionState_165(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeInteractionState(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_StartWidgetInteraction_166(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartWidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_WidgetInteraction_167(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->WidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_ReleaseGraphicsResources_168(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_RenderOverlay_169(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_RenderOpaqueGeometry_170(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_RenderTranslucentPolygonalGeometry_171(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_HasTranslucentPolygonalGeometry_172(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_SetClosedLoop_173(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClosedLoop(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetClosedLoop_174(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClosedLoop();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_ClosedLoopOn_175(JNIEnv* env, jobject obj)
{

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClosedLoopOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_ClosedLoopOff_176(JNIEnv* env, jobject obj)
{

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClosedLoopOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_SetShowSelectedNodes_177(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowSelectedNodes(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContourRepresentation_GetShowSelectedNodes_178(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowSelectedNodes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_ShowSelectedNodesOn_179(JNIEnv* env, jobject obj)
{

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShowSelectedNodesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_ShowSelectedNodesOff_180(JNIEnv* env, jobject obj)
{

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShowSelectedNodesOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContourRepresentation_GetContourRepresentationAsPolyData_181(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContourRepresentationAsPolyData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_GetNodePolyData_182(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetNodePolyData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContourRepresentation_SetRebuildLocator_183(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkContourRepresentation* op = static_cast<vtkContourRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRebuildLocator(temp0);

}
