// java wrapper for vtkMedicalImageProperties object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMedicalImageProperties.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMedicalImageProperties_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMedicalImageProperties",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMedicalImageProperties_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMedicalImageProperties_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_Clear_14(JNIEnv* env, jobject obj)
{

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clear();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetPatientName_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPatientName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetPatientName_16(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatientName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetPatientID_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPatientID(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetPatientID_18(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatientID();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetPatientAge_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPatientAge(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetPatientAge_110(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatientAge();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetPatientAgeYear_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatientAgeYear();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetPatientAgeMonth_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatientAgeMonth();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetPatientAgeWeek_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatientAgeWeek();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetPatientAgeDay_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatientAgeDay();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetPatientSex_115(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPatientSex(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetPatientSex_116(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatientSex();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetPatientBirthDate_117(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPatientBirthDate(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetPatientBirthDate_118(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatientBirthDate();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetPatientBirthDateYear_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatientBirthDateYear();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetPatientBirthDateMonth_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatientBirthDateMonth();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetPatientBirthDateDay_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatientBirthDateDay();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetStudyDate_122(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStudyDate(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetStudyDate_123(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStudyDate();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetAcquisitionDate_124(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAcquisitionDate(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetAcquisitionDate_125(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAcquisitionDate();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetAcquisitionDateYear_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAcquisitionDateYear();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetAcquisitionDateMonth_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAcquisitionDateMonth();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetAcquisitionDateDay_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAcquisitionDateDay();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetStudyTime_129(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStudyTime(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetStudyTime_130(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStudyTime();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetAcquisitionTime_131(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAcquisitionTime(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetAcquisitionTime_132(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAcquisitionTime();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetImageDate_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImageDate(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetImageDate_134(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageDate();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetImageDateYear_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageDateYear();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetImageDateMonth_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageDateMonth();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetImageDateDay_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageDateDay();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetDateAsLocale_138(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  char * temp0;
  char * temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDateAsLocale(temp0,temp1);
  delete[] temp0;
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetImageTime_139(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImageTime(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetImageTime_140(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageTime();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetImageNumber_141(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImageNumber(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetImageNumber_142(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageNumber();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetSeriesNumber_143(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSeriesNumber(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetSeriesNumber_144(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSeriesNumber();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetSeriesDescription_145(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSeriesDescription(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetSeriesDescription_146(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSeriesDescription();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetStudyID_147(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStudyID(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetStudyID_148(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStudyID();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetStudyDescription_149(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStudyDescription(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetStudyDescription_150(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStudyDescription();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetModality_151(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModality(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetModality_152(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModality();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetManufacturer_153(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetManufacturer(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetManufacturer_154(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetManufacturer();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetManufacturerModelName_155(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetManufacturerModelName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetManufacturerModelName_156(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetManufacturerModelName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetStationName_157(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStationName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetStationName_158(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStationName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetInstitutionName_159(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInstitutionName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetInstitutionName_160(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInstitutionName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetConvolutionKernel_161(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConvolutionKernel(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetConvolutionKernel_162(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConvolutionKernel();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetSliceThickness_163(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSliceThickness(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetSliceThickness_164(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceThickness();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMedicalImageProperties_GetSliceThicknessAsDouble_165(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceThicknessAsDouble();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetKVP_166(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKVP(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetKVP_167(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKVP();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetGantryTilt_168(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGantryTilt(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetGantryTilt_169(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGantryTilt();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMedicalImageProperties_GetGantryTiltAsDouble_170(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGantryTiltAsDouble();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetEchoTime_171(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEchoTime(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetEchoTime_172(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEchoTime();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetEchoTrainLength_173(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEchoTrainLength(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetEchoTrainLength_174(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEchoTrainLength();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetRepetitionTime_175(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRepetitionTime(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetRepetitionTime_176(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRepetitionTime();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetExposureTime_177(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExposureTime(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetExposureTime_178(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExposureTime();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetXRayTubeCurrent_179(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXRayTubeCurrent(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetXRayTubeCurrent_180(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXRayTubeCurrent();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetExposure_181(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExposure(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetExposure_182(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExposure();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetDirectionCosine_183(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDirectionCosine(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetDirectionCosine_184(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDirectionCosine(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetDirectionCosine_185(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDirectionCosine();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_AddUserDefinedValue_186(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  char * temp0;
  char * temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddUserDefinedValue(temp0,temp1);
  delete[] temp0;
  delete[] temp1;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetUserDefinedValue_187(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  const char * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUserDefinedValue(temp0);
  delete[] temp0;
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetNumberOfUserDefinedValues_188(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfUserDefinedValues();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetUserDefinedNameByIndex_189(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUserDefinedNameByIndex(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetUserDefinedValueByIndex_190(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUserDefinedValueByIndex(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_RemoveAllUserDefinedValues_191(JNIEnv* env, jobject obj)
{

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllUserDefinedValues();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_AddWindowLevelPreset_192(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddWindowLevelPreset(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_RemoveWindowLevelPreset_193(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveWindowLevelPreset(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_RemoveAllWindowLevelPresets_194(JNIEnv* env, jobject obj)
{

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllWindowLevelPresets();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetNumberOfWindowLevelPresets_195(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfWindowLevelPresets();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_HasWindowLevelPreset_196(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasWindowLevelPreset(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetWindowLevelPresetIndex_197(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWindowLevelPresetIndex(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetNthWindowLevelPreset_198(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double * temp20;
  temp0 = id0;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNthWindowLevelPreset(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetNthWindowLevelPresetComment_199(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  int   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNthWindowLevelPresetComment(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetNthWindowLevelPresetComment_1100(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNthWindowLevelPresetComment(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetInstanceUIDFromSliceID_1101(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  const char * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInstanceUIDFromSliceID(temp0,temp1);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetInstanceUIDFromSliceID_1102(JNIEnv* env, jobject obj,jint id0,jint id1, jbyteArray id2, jint len2)
{
  int   temp0;
  int   temp1;
  char * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInstanceUIDFromSliceID(temp0,temp1,temp2);
  delete[] temp2;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMedicalImageProperties_GetOrientationType_1103(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientationType(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_SetOrientationType_1104(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientationType(temp0,temp1);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMedicalImageProperties_GetStringFromOrientationType_1105(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStringFromOrientationType(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMedicalImageProperties_DeepCopy_1106(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMedicalImageProperties * temp0;
  temp0 = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMedicalImageProperties* op = static_cast<vtkMedicalImageProperties*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMedicalImageProperties_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMedicalImageProperties::New());
}
