// java wrapper for vtkDEMReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDEMReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDEMReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDEMReader",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDEMReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDEMReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDEMReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDEMReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDEMReader_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDEMReader_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDEMReader_SetElevationReference_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElevationReference(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDEMReader_GetElevationReferenceMinValue_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElevationReferenceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDEMReader_GetElevationReferenceMaxValue_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElevationReferenceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDEMReader_GetElevationReference_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElevationReference();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDEMReader_SetElevationReferenceToSeaLevel_110(JNIEnv* env, jobject obj)
{

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElevationReferenceToSeaLevel();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDEMReader_SetElevationReferenceToElevationBounds_111(JNIEnv* env, jobject obj)
{

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElevationReferenceToElevationBounds();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDEMReader_GetElevationReferenceAsString_112(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElevationReferenceAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDEMReader_GetMapLabel_113(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMapLabel();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDEMReader_GetDEMLevel_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDEMLevel();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDEMReader_GetElevationPattern_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElevationPattern();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDEMReader_GetGroundSystem_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGroundSystem();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDEMReader_GetGroundZone_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGroundZone();
  return temp20;

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkDEMReader_GetProjectionParameters_118(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectionParameters();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 15);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDEMReader_GetPlaneUnitOfMeasure_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlaneUnitOfMeasure();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDEMReader_GetElevationUnitOfMeasure_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElevationUnitOfMeasure();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDEMReader_GetPolygonSize_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolygonSize();
  return temp20;

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkDEMReader_GetElevationBounds_122(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElevationBounds();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 2);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkDEMReader_GetLocalRotation_123(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLocalRotation();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDEMReader_GetAccuracyCode_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAccuracyCode();
  return temp20;

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkDEMReader_GetSpatialResolution_125(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpatialResolution();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 3);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkDEMReader_GetProfileDimension_126(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkDEMReader* op = static_cast<vtkDEMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProfileDimension();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDEMReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDEMReader::New());
}
