// java wrapper for vtkStatisticsAlgorithm object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkStatisticsAlgorithm.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkTableAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkStatisticsAlgorithm_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkStatisticsAlgorithm",dType)) { return me; }
  if ((res= vtkTableAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStatisticsAlgorithm_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStatisticsAlgorithm_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStatisticsAlgorithm_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStatisticsAlgorithm_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_SetLearnOptionParameterConnection_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLearnOptionParameterConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_SetLearnOptionParameters_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLearnOptionParameters(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_SetInputModelConnection_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputModelConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_SetInputModel_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputModel(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_SetLearnOption_18(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLearnOption(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStatisticsAlgorithm_GetLearnOption_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLearnOption();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_SetDeriveOption_110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDeriveOption(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStatisticsAlgorithm_GetDeriveOption_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDeriveOption();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_SetAssessOption_112(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAssessOption(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStatisticsAlgorithm_GetAssessOption_113(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAssessOption();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_SetTestOption_114(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTestOption(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStatisticsAlgorithm_GetTestOption_115(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTestOption();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_SetNumberOfPrimaryTables_116(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfPrimaryTables(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStatisticsAlgorithm_GetNumberOfPrimaryTables_117(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPrimaryTables();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_SetAssessNames_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkStringArray * temp0;
  temp0 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAssessNames(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStatisticsAlgorithm_GetAssessNames_119(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAssessNames();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_SetColumnStatus_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColumnStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_ResetAllColumnStates_121(JNIEnv* env, jobject obj)
{

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetAllColumnStates();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStatisticsAlgorithm_RequestSelectedColumns_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RequestSelectedColumns();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_ResetRequests_123(JNIEnv* env, jobject obj)
{

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetRequests();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStatisticsAlgorithm_GetNumberOfRequests_124(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfRequests();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStatisticsAlgorithm_GetNumberOfColumnsForRequest_125(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfColumnsForRequest(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkStatisticsAlgorithm_GetColumnForRequest_126(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  const char * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumnForRequest(temp0,temp1);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStatisticsAlgorithm_GetColumnForRequest_127(JNIEnv* env, jobject obj,jlong id0,jlong id1, jbyteArray id2, jint len2)
{
  long long   temp0;
  long long   temp1;
  vtkStdString temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = vtkJavaUTF8ToString(env, id2, len2);

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumnForRequest(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_AddColumn_128(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddColumn(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_AddColumnPair_129(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  char * temp0;
  char * temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddColumnPair(temp0,temp1);
  delete[] temp0;
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStatisticsAlgorithm_Aggregate_130(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataObjectCollection * temp0;
  vtkMultiBlockDataSet * temp1;
  temp0 = static_cast<vtkDataObjectCollection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkMultiBlockDataSet*>(vtkJavaGetPointerFromObject(env, id1));

  vtkStatisticsAlgorithm* op = static_cast<vtkStatisticsAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->Aggregate(temp0,temp1);

}
