// java wrapper for vtkDelaunay2D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDelaunay2D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDelaunay2D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDelaunay2D",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay2D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay2D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDelaunay2D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDelaunay2D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay2D_SetSourceData_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSourceData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay2D_SetSourceConnection_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSourceConnection(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDelaunay2D_GetSource_16(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSource();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay2D_SetAlpha_17(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAlpha(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay2D_GetAlphaMinValue_18(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlphaMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay2D_GetAlphaMaxValue_19(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlphaMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay2D_GetAlpha_110(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlpha();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay2D_SetTolerance_111(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay2D_GetToleranceMinValue_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetToleranceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay2D_GetToleranceMaxValue_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetToleranceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay2D_GetTolerance_114(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTolerance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay2D_SetOffset_115(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOffset(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay2D_GetOffsetMinValue_116(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffsetMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay2D_GetOffsetMaxValue_117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffsetMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelaunay2D_GetOffset_118(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay2D_SetBoundingTriangulation_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBoundingTriangulation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay2D_GetBoundingTriangulation_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoundingTriangulation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay2D_BoundingTriangulationOn_121(JNIEnv* env, jobject obj)
{

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->BoundingTriangulationOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay2D_BoundingTriangulationOff_122(JNIEnv* env, jobject obj)
{

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->BoundingTriangulationOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay2D_SetTransform_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractTransform * temp0;
  temp0 = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransform(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDelaunay2D_GetTransform_124(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay2D_SetProjectionPlaneMode_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjectionPlaneMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay2D_GetProjectionPlaneModeMinValue_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectionPlaneModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay2D_GetProjectionPlaneModeMaxValue_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectionPlaneModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay2D_GetProjectionPlaneMode_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectionPlaneMode();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDelaunay2D_ComputeBestFittingPlane_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPointSet * temp0;
  vtkAbstractTransform * temp20;
  temp0 = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeBestFittingPlane(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay2D_SetRandomPointInsertion_130(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRandomPointInsertion(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelaunay2D_GetRandomPointInsertion_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRandomPointInsertion();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay2D_RandomPointInsertionOn_132(JNIEnv* env, jobject obj)
{

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->RandomPointInsertionOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelaunay2D_RandomPointInsertionOff_133(JNIEnv* env, jobject obj)
{

  vtkDelaunay2D* op = static_cast<vtkDelaunay2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->RandomPointInsertionOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDelaunay2D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDelaunay2D::New());
}
