// java wrapper for vtkStructuredData object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkStructuredData.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkStructuredData_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkStructuredData",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredData_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredData_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredData_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredData_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredData_SetDimensions_14(JNIEnv* env, jobject obj,jintArray id0,jintArray id1)
{
  int temp0[3];
  int temp1[3];
  int   temp20;
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetDimensions(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  env->SetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredData_SetExtent_15(JNIEnv* env, jobject obj,jintArray id0,jintArray id1)
{
  int temp0[6];
  int temp1[6];
  int   temp20;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetExtent(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->SetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredData_GetDataDescription_16(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  int   temp20;
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDescription(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredData_GetDataDescriptionFromExtent_17(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  int   temp20;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDescriptionFromExtent(temp0);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredData_GetDataDimension_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDimension(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredData_GetDataDimension_19(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  int   temp20;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDimension(temp0);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredData_GetNumberOfPoints_110(JNIEnv* env, jobject obj,jintArray id0,jint id1)
{
  int temp0[6];
  int   temp1;
  long long   temp20;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = id1;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredData_GetNumberOfCells_111(JNIEnv* env, jobject obj,jintArray id0,jint id1)
{
  int temp0[6];
  int   temp1;
  long long   temp20;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = id1;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_GetCellExtentFromPointExtent_112(JNIEnv* env, jobject obj,jintArray id0,jintArray id1,jint id2)
{
  int temp0[6];
  int temp1[6];
  int   temp2;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));
  temp2 = id2;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellExtentFromPointExtent(temp0,temp1,temp2);
  env->SetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_GetDimensionsFromExtent_113(JNIEnv* env, jobject obj,jintArray id0,jintArray id1,jint id2)
{
  int temp0[6];
  int temp1[3];
  int   temp2;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  temp2 = id2;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDimensionsFromExtent(temp0,temp1,temp2);
  env->SetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStructuredData_IsPointVisible_114(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkUnsignedCharArray * temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPointVisible(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStructuredData_IsCellVisible_115(JNIEnv* env, jobject obj,jlong id0,jintArray id1,jint id2,jobject id3,jobject id4)
{
  long long   temp0;
  int temp1[3];
  int   temp2;
  vtkUnsignedCharArray * temp3;
  vtkUnsignedCharArray * temp4;
  bool   temp20;
  temp0 = id0;
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  temp2 = id2;
  temp3 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id4));

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsCellVisible(temp0,temp1,temp2,temp3,temp4);
  env->SetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_GetCellDimensionsFromExtent_116(JNIEnv* env, jobject obj,jintArray id0,jintArray id1,jint id2)
{
  int temp0[6];
  int temp1[3];
  int   temp2;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  temp2 = id2;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellDimensionsFromExtent(temp0,temp1,temp2);
  env->SetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_GetCellDimensionsFromPointDimensions_117(JNIEnv* env, jobject obj,jintArray id0,jintArray id1)
{
  int temp0[3];
  int temp1[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellDimensionsFromPointDimensions(temp0,temp1);
  env->SetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_GetLocalStructuredCoordinates_118(JNIEnv* env, jobject obj,jintArray id0,jintArray id1,jintArray id2,jint id3)
{
  int temp0[3];
  int temp1[6];
  int temp2[3];
  int   temp3;
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));
  env->GetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));
  temp3 = id3;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetLocalStructuredCoordinates(temp0,temp1,temp2,temp3);
  env->SetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_GetGlobalStructuredCoordinates_119(JNIEnv* env, jobject obj,jintArray id0,jintArray id1,jintArray id2,jint id3)
{
  int temp0[3];
  int temp1[6];
  int temp2[3];
  int   temp3;
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));
  env->GetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));
  temp3 = id3;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetGlobalStructuredCoordinates(temp0,temp1,temp2,temp3);
  env->SetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_GetCellPoints_120(JNIEnv* env, jobject obj,jlong id0,jobject id1,jint id2,jintArray id3)
{
  long long   temp0;
  vtkIdList * temp1;
  int   temp2;
  int temp3[3];
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  env->GetIntArrayRegion(id3, 0, 3, reinterpret_cast<jint*>(&temp3[0]));

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellPoints(temp0,temp1,temp2,temp3);
  env->SetIntArrayRegion(id3, 0, 3, reinterpret_cast<jint*>(&temp3[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_GetPointCells_121(JNIEnv* env, jobject obj,jlong id0,jobject id1,jintArray id2)
{
  long long   temp0;
  vtkIdList * temp1;
  int temp2[3];
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  env->GetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPointCells(temp0,temp1,temp2);
  env->SetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_GetCellNeighbors_122(JNIEnv* env, jobject obj,jlong id0,jobject id1,jobject id2,jintArray id3)
{
  long long   temp0;
  vtkIdList * temp1;
  vtkIdList * temp2;
  int temp3[3];
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));
  env->GetIntArrayRegion(id3, 0, 3, reinterpret_cast<jint*>(&temp3[0]));

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellNeighbors(temp0,temp1,temp2,temp3);
  env->SetIntArrayRegion(id3, 0, 3, reinterpret_cast<jint*>(&temp3[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_GetCellNeighbors_123(JNIEnv* env, jobject obj,jlong id0,jobject id1,jobject id2,jintArray id3,jintArray id4)
{
  long long   temp0;
  vtkIdList * temp1;
  vtkIdList * temp2;
  int temp3[3];
  int temp4[3];
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));
  env->GetIntArrayRegion(id3, 0, 3, reinterpret_cast<jint*>(&temp3[0]));
  env->GetIntArrayRegion(id4, 0, 3, reinterpret_cast<jint*>(&temp4[0]));

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellNeighbors(temp0,temp1,temp2,temp3,temp4);
  env->SetIntArrayRegion(id3, 0, 3, reinterpret_cast<jint*>(&temp3[0]));
  env->SetIntArrayRegion(id4, 0, 3, reinterpret_cast<jint*>(&temp4[0]));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredData_ComputePointIdForExtent_124(JNIEnv* env, jobject obj,jintArray id0,jintArray id1,jint id2)
{
  int temp0[6];
  int temp1[3];
  int   temp2;
  long long   temp20;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  temp2 = id2;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputePointIdForExtent(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredData_ComputeCellIdForExtent_125(JNIEnv* env, jobject obj,jintArray id0,jintArray id1,jint id2)
{
  int temp0[6];
  int temp1[3];
  int   temp2;
  long long   temp20;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  temp2 = id2;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeCellIdForExtent(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredData_ComputePointId_126(JNIEnv* env, jobject obj,jintArray id0,jintArray id1,jint id2)
{
  int temp0[3];
  int temp1[3];
  int   temp2;
  long long   temp20;
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  temp2 = id2;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputePointId(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredData_ComputeCellId_127(JNIEnv* env, jobject obj,jintArray id0,jintArray id1,jint id2)
{
  int temp0[3];
  int temp1[3];
  int   temp2;
  long long   temp20;
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  temp2 = id2;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeCellId(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_ComputeCellStructuredCoordsForExtent_128(JNIEnv* env, jobject obj,jlong id0,jintArray id1,jintArray id2,jint id3)
{
  long long   temp0;
  int temp1[6];
  int temp2[3];
  int   temp3;
  temp0 = id0;
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));
  env->GetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));
  temp3 = id3;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeCellStructuredCoordsForExtent(temp0,temp1,temp2,temp3);
  env->SetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_ComputeCellStructuredCoords_129(JNIEnv* env, jobject obj,jlong id0,jintArray id1,jintArray id2,jint id3)
{
  long long   temp0;
  int temp1[3];
  int temp2[3];
  int   temp3;
  temp0 = id0;
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  env->GetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));
  temp3 = id3;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeCellStructuredCoords(temp0,temp1,temp2,temp3);
  env->SetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_ComputeCellStructuredMinMaxCoords_130(JNIEnv* env, jobject obj,jlong id0,jintArray id1,jintArray id2,jintArray id3,jint id4)
{
  long long   temp0;
  int temp1[3];
  int temp2[3];
  int temp3[3];
  int   temp4;
  temp0 = id0;
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  env->GetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));
  env->GetIntArrayRegion(id3, 0, 3, reinterpret_cast<jint*>(&temp3[0]));
  temp4 = id4;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeCellStructuredMinMaxCoords(temp0,temp1,temp2,temp3,temp4);
  env->SetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));
  env->SetIntArrayRegion(id3, 0, 3, reinterpret_cast<jint*>(&temp3[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_ComputePointStructuredCoordsForExtent_131(JNIEnv* env, jobject obj,jlong id0,jintArray id1,jintArray id2,jint id3)
{
  long long   temp0;
  int temp1[6];
  int temp2[3];
  int   temp3;
  temp0 = id0;
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));
  env->GetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));
  temp3 = id3;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputePointStructuredCoordsForExtent(temp0,temp1,temp2,temp3);
  env->SetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredData_ComputePointStructuredCoords_132(JNIEnv* env, jobject obj,jlong id0,jintArray id1,jintArray id2,jint id3)
{
  long long   temp0;
  int temp1[3];
  int temp2[3];
  int   temp3;
  temp0 = id0;
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  env->GetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));
  temp3 = id3;

  vtkStructuredData* op = static_cast<vtkStructuredData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputePointStructuredCoords(temp0,temp1,temp2,temp3);
  env->SetIntArrayRegion(id2, 0, 3, reinterpret_cast<jint*>(&temp2[0]));

}
