// java wrapper for vtkQuadric object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkQuadric.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImplicitFunction_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkQuadric_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkQuadric",dType)) { return me; }
  if ((res= vtkImplicitFunction_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuadric_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkQuadric* op = static_cast<vtkQuadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuadric_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkQuadric* op = static_cast<vtkQuadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkQuadric_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkQuadric* op = static_cast<vtkQuadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkQuadric_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkQuadric* op = static_cast<vtkQuadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkQuadric_EvaluateFunction_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkQuadric* op = static_cast<vtkQuadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateFunction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuadric_EvaluateGradient_15(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkQuadric* op = static_cast<vtkQuadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->EvaluateGradient(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuadric_SetCoefficients_16(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[10];
  env->GetDoubleArrayRegion(id0, 0, 10, &temp0[0]);

  vtkQuadric* op = static_cast<vtkQuadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoefficients(temp0);
  env->SetDoubleArrayRegion(id0, 0, 10, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuadric_SetCoefficients_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6,jdouble id7,jdouble id8,jdouble id9)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  double   temp7;
  double   temp8;
  double   temp9;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;
  temp8 = id8;
  temp9 = id9;

  vtkQuadric* op = static_cast<vtkQuadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoefficients(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkQuadric_GetCoefficients_18(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkQuadric* op = static_cast<vtkQuadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoefficients();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 10);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuadric_EvaluateFunction_19(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkQuadric* op = static_cast<vtkQuadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->EvaluateFunction(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkQuadric_EvaluateFunction_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkQuadric* op = static_cast<vtkQuadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateFunction(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkQuadric_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkQuadric::New());
}
