// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkDepthOfFieldPassFS.h"

const char *vtkDepthOfFieldPassFS =
"//VTK::System::Dec\n"
"\n"
"\n"
"// Fragment shader used by the DOF render pass.\n"
"\n"
"in vec2 tcoordVC;\n"
"uniform sampler2D source;\n"
"uniform sampler2D depth;\n"
"\n"
"uniform vec2  worldToTCoord;\n"
"uniform vec2  pixelToTCoord;\n"
"uniform float nearC;\n"
"uniform float farC;\n"
"uniform float focalDisk;\n"
"uniform float focalDistance;\n"
"\n"
"// the output of this shader\n"
"//VTK::Output::Dec\n"
"\n"
"vec2 rand2(vec2 co)\n"
"{\n"
"  float a = 12.9898;\n"
"  float b = 78.233;\n"
"  float c = 43758.5453;\n"
"  float dt= dot(co.xy ,vec2(a,b));\n"
"  float sn= mod(dt,3.14);\n"
"  float dt2= dot(co.xy ,vec2(b,a));\n"
"  float sn2= mod(dt2,3.14);\n"
"  return vec2(fract(sin(sn) * c), fract(sin(sn2) * c));\n"
"}\n"
"\n"
"void main(void)\n"
"{\n"
"  // original pixel\n"
"  vec4 fcolor = texture2D(source,tcoordVC);\n"
"  float fsum = 1.0;\n"
"\n"
"  float fdist = focalDistance;\n"
"  // use automatic focalDistance?  when focalDistance = 0\n"
"  if (fdist == 0.0)\n"
"    {\n"
"    fdist = -farC * nearC / (texture2D(depth,vec2(0.5,0.5)).r * (farC - nearC) - farC);\n"
"    }\n"
"\n"
"  float CoCScale = focalDisk*fdist*(farC - nearC)/(farC*nearC);\n"
"  float CoCBias = focalDisk*(nearC - fdist)/nearC;\n"
"\n"
"  float cdepth = texture2D(depth,tcoordVC).r;\n"
"  float CoC = CoCScale*cdepth + CoCBias;\n"
"\n"
"  // loop over pixels\n"
"  for (int i = 0; i < 9; i++)\n"
"    {\n"
"    for (int j = 0; j < 9; j++)\n"
"      {\n"
"      vec2 newOffset = pixelToTCoord*(vec2(i-4,j-4)*2.0 + rand2(tcoordVC));\n"
"      vec2 newtc = tcoordVC + newOffset;\n"
"      float tdepth = texture2D(depth,newtc).r;\n"
"      float tCoC = CoCScale*tdepth + CoCBias;\n"
"      // is the sample in range?\n"
"      float close = abs(tCoC) - length(newOffset/worldToTCoord);\n"
"      if (close > 0.0)\n"
"        {\n"
"        // is the sample to be blended in front?\n"
"        // or if behind, not too far behind\n"
"        if ((tCoC < 0.0 || (CoC > 0.0 && tCoC < (CoC * 2.0f))))\n"
"          {\n"
"          float weight = close/abs(tCoC);\n"
"          fcolor = fcolor + weight*texture2D(source,newtc);\n"
"          fsum += weight;\n"
"          }\n"
"        }\n"
"      }\n"
"    }\n"
"\n"
"  gl_FragData[0] = fcolor/fsum;\n"
"}\n"
"";
