// python wrapper for vtkOpenVROverlay
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkOpenVROverlay.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkOpenVROverlay(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkOpenVROverlay_ClassNew(); }


static PyObject *
PyvtkOpenVROverlay_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkOpenVROverlay::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkOpenVROverlay::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkOpenVROverlay *tempr = vtkOpenVROverlay::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOpenVROverlay *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkOpenVROverlay::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkOpenVROverlay::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkOpenVROverlay::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_Render(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Render");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Render();
    }
    else
    {
      op->vtkOpenVROverlay::Render();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_Create(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Create");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  vtkOpenVRRenderWindow *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkOpenVRRenderWindow"))
  {
    if (ap.IsBound())
    {
      op->Create(temp0);
    }
    else
    {
      op->vtkOpenVROverlay::Create(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_GetOverlayTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOverlayTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkTextureObject *tempr = (ap.IsBound() ?
      op->GetOverlayTexture() :
      op->vtkOpenVROverlay::GetOverlayTexture());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_MouseMoved(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MouseMoved");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->MouseMoved(temp0, temp1);
    }
    else
    {
      op->vtkOpenVROverlay::MouseMoved(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_MouseButtonPress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MouseButtonPress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->MouseButtonPress(temp0, temp1);
    }
    else
    {
      op->vtkOpenVROverlay::MouseButtonPress(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_MouseButtonRelease(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MouseButtonRelease");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->MouseButtonRelease(temp0, temp1);
    }
    else
    {
      op->vtkOpenVROverlay::MouseButtonRelease(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_GetLastSpot(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLastSpot");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOpenVROverlaySpot *tempr = (ap.IsBound() ?
      op->GetLastSpot() :
      op->vtkOpenVROverlay::GetLastSpot());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_UpdateSpot(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateSpot");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  vtkOpenVROverlaySpot *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkOpenVROverlaySpot"))
  {
    if (ap.IsBound())
    {
      op->UpdateSpot(temp0);
    }
    else
    {
      op->vtkOpenVROverlay::UpdateSpot(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_SetSessionName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSessionName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSessionName(temp0);
    }
    else
    {
      op->vtkOpenVROverlay::SetSessionName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_GetSessionName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSessionName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetSessionName() :
      op->vtkOpenVROverlay::GetSessionName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_SetDashboardImageFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDashboardImageFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDashboardImageFileName(temp0);
    }
    else
    {
      op->vtkOpenVROverlay::SetDashboardImageFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_GetDashboardImageFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDashboardImageFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetDashboardImageFileName() :
      op->vtkOpenVROverlay::GetDashboardImageFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_GetSavedCameraPose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSavedCameraPose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkOpenVRCameraPose *tempr = (ap.IsBound() ?
      op->GetSavedCameraPose(temp0) :
      op->vtkOpenVROverlay::GetSavedCameraPose(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_SetSavedCameraPose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSavedCameraPose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  int temp0;
  vtkOpenVRCameraPose *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkOpenVRCameraPose"))
  {
    if (ap.IsBound())
    {
      op->SetSavedCameraPose(temp0, temp1);
    }
    else
    {
      op->vtkOpenVROverlay::SetSavedCameraPose(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_WriteCameraPoses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteCameraPoses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteCameraPoses();
    }
    else
    {
      op->vtkOpenVROverlay::WriteCameraPoses();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_ReadCameraPoses_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReadCameraPoses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ReadCameraPoses();
    }
    else
    {
      op->vtkOpenVROverlay::ReadCameraPoses();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkOpenVROverlay_ReadCameraPoses_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReadCameraPoses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  vtkXMLDataElement *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkXMLDataElement"))
  {
    if (ap.IsBound())
    {
      op->ReadCameraPoses(temp0);
    }
    else
    {
      op->vtkOpenVROverlay::ReadCameraPoses(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkOpenVROverlay_ReadCameraPoses(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkOpenVROverlay_ReadCameraPoses_s1(self, args);
    case 1:
      return PyvtkOpenVROverlay_ReadCameraPoses_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "ReadCameraPoses");
  return nullptr;
}


static PyObject *
PyvtkOpenVROverlay_SaveCameraPose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SaveCameraPose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SaveCameraPose(temp0);
    }
    else
    {
      op->vtkOpenVROverlay::SaveCameraPose(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_LoadCameraPose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadCameraPose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->LoadCameraPose(temp0);
    }
    else
    {
      op->vtkOpenVROverlay::LoadCameraPose(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_LoadNextCameraPose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadNextCameraPose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LoadNextCameraPose();
    }
    else
    {
      op->vtkOpenVROverlay::LoadNextCameraPose();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_Show(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Show");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Show();
    }
    else
    {
      op->vtkOpenVROverlay::Show();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVROverlay_Hide(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Hide");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVROverlay *op = static_cast<vtkOpenVROverlay *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Hide();
    }
    else
    {
      op->vtkOpenVROverlay::Hide();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkOpenVROverlay_Methods[] = {
  {"IsTypeOf", PyvtkOpenVROverlay_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkOpenVROverlay_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkOpenVROverlay_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkOpenVROverlay\nC++: static vtkOpenVROverlay *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkOpenVROverlay_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkOpenVROverlay\nC++: vtkOpenVROverlay *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkOpenVROverlay_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkOpenVROverlay_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Render", PyvtkOpenVROverlay_Render, METH_VARARGS,
   "Render(self) -> None\nC++: virtual void Render()\n\nRender the overlay\n"},
  {"Create", PyvtkOpenVROverlay_Create, METH_VARARGS,
   "Create(self, rw:vtkOpenVRRenderWindow) -> None\nC++: virtual void Create(vtkOpenVRRenderWindow *rw)\n\nCreate the overlay\n"},
  {"GetOverlayTexture", PyvtkOpenVROverlay_GetOverlayTexture, METH_VARARGS,
   "GetOverlayTexture(self) -> vtkTextureObject\nC++: vtkTextureObject *GetOverlayTexture()\n\nGet handle to the overlay texture\n"},
  {"MouseMoved", PyvtkOpenVROverlay_MouseMoved, METH_VARARGS,
   "MouseMoved(self, x:int, y:int) -> None\nC++: virtual void MouseMoved(int x, int y)\n\nmethods to support events on the overlay\n"},
  {"MouseButtonPress", PyvtkOpenVROverlay_MouseButtonPress, METH_VARARGS,
   "MouseButtonPress(self, x:int, y:int) -> None\nC++: virtual void MouseButtonPress(int x, int y)\n\n"},
  {"MouseButtonRelease", PyvtkOpenVROverlay_MouseButtonRelease, METH_VARARGS,
   "MouseButtonRelease(self, x:int, y:int) -> None\nC++: virtual void MouseButtonRelease(int x, int y)\n\n"},
  {"GetLastSpot", PyvtkOpenVROverlay_GetLastSpot, METH_VARARGS,
   "GetLastSpot(self) -> vtkOpenVROverlaySpot\nC++: vtkOpenVROverlaySpot *GetLastSpot()\n\n"},
  {"UpdateSpot", PyvtkOpenVROverlay_UpdateSpot, METH_VARARGS,
   "UpdateSpot(self, spot:vtkOpenVROverlaySpot) -> None\nC++: virtual void UpdateSpot(vtkOpenVROverlaySpot *spot)\n\n* update the texture because this spot has changed\n"},
  {"SetSessionName", PyvtkOpenVROverlay_SetSessionName, METH_VARARGS,
   "SetSessionName(self, name:str) -> None\nC++: void SetSessionName(const std::string &name)\n\nSet/Get a prefix for saving camera poses\n"},
  {"GetSessionName", PyvtkOpenVROverlay_GetSessionName, METH_VARARGS,
   "GetSessionName(self) -> str\nC++: std::string GetSessionName()\n\n"},
  {"SetDashboardImageFileName", PyvtkOpenVROverlay_SetDashboardImageFileName, METH_VARARGS,
   "SetDashboardImageFileName(self, name:str) -> None\nC++: void SetDashboardImageFileName(const std::string &name)\n\nSet/Get a file for the dashboard image\n"},
  {"GetDashboardImageFileName", PyvtkOpenVROverlay_GetDashboardImageFileName, METH_VARARGS,
   "GetDashboardImageFileName(self) -> str\nC++: std::string GetDashboardImageFileName()\n\n"},
  {"GetSavedCameraPose", PyvtkOpenVROverlay_GetSavedCameraPose, METH_VARARGS,
   "GetSavedCameraPose(self, i:int) -> vtkOpenVRCameraPose\nC++: vtkOpenVRCameraPose *GetSavedCameraPose(int i)\n\n"},
  {"SetSavedCameraPose", PyvtkOpenVROverlay_SetSavedCameraPose, METH_VARARGS,
   "SetSavedCameraPose(self, i:int, __b:vtkOpenVRCameraPose) -> None\nC++: virtual void SetSavedCameraPose(int i, vtkOpenVRCameraPose *)\n\n"},
  {"WriteCameraPoses", PyvtkOpenVROverlay_WriteCameraPoses, METH_VARARGS,
   "WriteCameraPoses(self) -> None\nC++: virtual void WriteCameraPoses()\n\n"},
  {"ReadCameraPoses", PyvtkOpenVROverlay_ReadCameraPoses, METH_VARARGS,
   "ReadCameraPoses(self) -> None\nC++: virtual void ReadCameraPoses()\nReadCameraPoses(self, xml:vtkXMLDataElement) -> None\nC++: virtual void ReadCameraPoses(vtkXMLDataElement *xml)\n\n"},
  {"SaveCameraPose", PyvtkOpenVROverlay_SaveCameraPose, METH_VARARGS,
   "SaveCameraPose(self, num:int) -> None\nC++: virtual void SaveCameraPose(int num)\n\n"},
  {"LoadCameraPose", PyvtkOpenVROverlay_LoadCameraPose, METH_VARARGS,
   "LoadCameraPose(self, num:int) -> None\nC++: virtual void LoadCameraPose(int num)\n\n"},
  {"LoadNextCameraPose", PyvtkOpenVROverlay_LoadNextCameraPose, METH_VARARGS,
   "LoadNextCameraPose(self) -> None\nC++: virtual void LoadNextCameraPose()\n\n"},
  {"Show", PyvtkOpenVROverlay_Show, METH_VARARGS,
   "Show(self) -> None\nC++: void Show()\n\n"},
  {"Hide", PyvtkOpenVROverlay_Hide, METH_VARARGS,
   "Hide(self) -> None\nC++: void Hide()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkOpenVROverlay_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("session_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenVROverlay_GetSessionName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOpenVROverlay_SetSessionName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOpenVROverlay_SetSessionName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSessionName/SetSessionName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("dashboard_image_file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenVROverlay_GetDashboardImageFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOpenVROverlay_SetDashboardImageFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOpenVROverlay_SetDashboardImageFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDashboardImageFileName/SetDashboardImageFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("overlay_texture"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenVROverlay_GetOverlayTexture(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetOverlayTexture\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_spot"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenVROverlay_GetLastSpot(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLastSpot\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkOpenVROverlay_Doc =
  "vtkOpenVROverlay - OpenVR overlay\n\n"
  "Superclass: vtkObject\n\n"
  "vtkOpenVROverlay support for VR overlays\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOpenVROverlay_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingOpenVR.vtkOpenVROverlay", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkOpenVROverlay_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkOpenVROverlay_StaticNew()
{
  return vtkOpenVROverlay::New();
}

PyObject *PyvtkOpenVROverlay_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkOpenVROverlay_Type, PyvtkOpenVROverlay_Methods,
    "vtkOpenVROverlay",
 &PyvtkOpenVROverlay_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkOpenVROverlay_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkOpenVROverlay(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkOpenVROverlay_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkOpenVROverlay", o) != 0)
  {
    Py_DECREF(o);
  }

}

