// python wrapper for vtkReebGraphToJoinSplitTreeFilter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkReebGraphToJoinSplitTreeFilter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkReebGraphToJoinSplitTreeFilter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkReebGraphToJoinSplitTreeFilter_ClassNew(); }


static PyObject *
PyvtkReebGraphToJoinSplitTreeFilter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkReebGraphToJoinSplitTreeFilter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReebGraphToJoinSplitTreeFilter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReebGraphToJoinSplitTreeFilter *op = static_cast<vtkReebGraphToJoinSplitTreeFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkReebGraphToJoinSplitTreeFilter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReebGraphToJoinSplitTreeFilter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkReebGraphToJoinSplitTreeFilter *tempr = vtkReebGraphToJoinSplitTreeFilter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReebGraphToJoinSplitTreeFilter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReebGraphToJoinSplitTreeFilter *op = static_cast<vtkReebGraphToJoinSplitTreeFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkReebGraphToJoinSplitTreeFilter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkReebGraphToJoinSplitTreeFilter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReebGraphToJoinSplitTreeFilter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkReebGraphToJoinSplitTreeFilter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReebGraphToJoinSplitTreeFilter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReebGraphToJoinSplitTreeFilter *op = static_cast<vtkReebGraphToJoinSplitTreeFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkReebGraphToJoinSplitTreeFilter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReebGraphToJoinSplitTreeFilter_SetIsSplitTree(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIsSplitTree");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReebGraphToJoinSplitTreeFilter *op = static_cast<vtkReebGraphToJoinSplitTreeFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIsSplitTree(temp0);
    }
    else
    {
      op->vtkReebGraphToJoinSplitTreeFilter::SetIsSplitTree(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkReebGraphToJoinSplitTreeFilter_GetIsSplitTree(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsSplitTree");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReebGraphToJoinSplitTreeFilter *op = static_cast<vtkReebGraphToJoinSplitTreeFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsSplitTree() :
      op->vtkReebGraphToJoinSplitTreeFilter::GetIsSplitTree());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReebGraphToJoinSplitTreeFilter_SetFieldId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFieldId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReebGraphToJoinSplitTreeFilter *op = static_cast<vtkReebGraphToJoinSplitTreeFilter *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFieldId(temp0);
    }
    else
    {
      op->vtkReebGraphToJoinSplitTreeFilter::SetFieldId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkReebGraphToJoinSplitTreeFilter_GetFieldId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReebGraphToJoinSplitTreeFilter *op = static_cast<vtkReebGraphToJoinSplitTreeFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetFieldId() :
      op->vtkReebGraphToJoinSplitTreeFilter::GetFieldId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkReebGraphToJoinSplitTreeFilter_GetOutput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkReebGraphToJoinSplitTreeFilter *op = static_cast<vtkReebGraphToJoinSplitTreeFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkReebGraph *tempr = (ap.IsBound() ?
      op->GetOutput() :
      op->vtkReebGraphToJoinSplitTreeFilter::GetOutput());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkReebGraphToJoinSplitTreeFilter_Methods[] = {
  {"IsTypeOf", PyvtkReebGraphToJoinSplitTreeFilter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkReebGraphToJoinSplitTreeFilter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkReebGraphToJoinSplitTreeFilter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkReebGraphToJoinSplitTreeFilter\nC++: static vtkReebGraphToJoinSplitTreeFilter *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkReebGraphToJoinSplitTreeFilter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkReebGraphToJoinSplitTreeFilter\nC++: vtkReebGraphToJoinSplitTreeFilter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkReebGraphToJoinSplitTreeFilter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkReebGraphToJoinSplitTreeFilter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetIsSplitTree", PyvtkReebGraphToJoinSplitTreeFilter_SetIsSplitTree, METH_VARARGS,
   "SetIsSplitTree(self, _arg:bool) -> None\nC++: virtual void SetIsSplitTree(bool _arg)\n\nSpecify if you want to get a join or a split tree. Default value:\nfalse (join tree)\n"},
  {"GetIsSplitTree", PyvtkReebGraphToJoinSplitTreeFilter_GetIsSplitTree, METH_VARARGS,
   "GetIsSplitTree(self) -> bool\nC++: virtual bool GetIsSplitTree()\n\n"},
  {"SetFieldId", PyvtkReebGraphToJoinSplitTreeFilter_SetFieldId, METH_VARARGS,
   "SetFieldId(self, _arg:int) -> None\nC++: virtual void SetFieldId(vtkIdType _arg)\n\nSet the scalar field Id Default value: 0;\n"},
  {"GetFieldId", PyvtkReebGraphToJoinSplitTreeFilter_GetFieldId, METH_VARARGS,
   "GetFieldId(self) -> int\nC++: virtual vtkIdType GetFieldId()\n\n"},
  {"GetOutput", PyvtkReebGraphToJoinSplitTreeFilter_GetOutput, METH_VARARGS,
   "GetOutput(self) -> vtkReebGraph\nC++: vtkReebGraph *GetOutput()\n\nGet the output data object for a port on this algorithm.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkReebGraphToJoinSplitTreeFilter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("is_split_tree"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkReebGraphToJoinSplitTreeFilter_GetIsSplitTree(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkReebGraphToJoinSplitTreeFilter_SetIsSplitTree(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkReebGraphToJoinSplitTreeFilter_SetIsSplitTree(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIsSplitTree/SetIsSplitTree\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("field_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkReebGraphToJoinSplitTreeFilter_GetFieldId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkReebGraphToJoinSplitTreeFilter_SetFieldId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkReebGraphToJoinSplitTreeFilter_SetFieldId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFieldId/SetFieldId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkReebGraphToJoinSplitTreeFilter_GetOutput(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetOutput\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkReebGraphToJoinSplitTreeFilter_Doc =
  "vtkReebGraphToJoinSplitTreeFilter - converts a given Reeb graph\neither to a join tree or a split tree (respectively the connectivity\nof the sub- and sur- level sets).\n\n"
  "Superclass: vtkDirectedGraphAlgorithm\n\n"
  "Note: if you want to use simplification filters, do so on the input\n"
  "Reeb graph first.\n\n"
  "Reference: \"Computing contpour trees in all dimensions\". H. Carr, J.\n"
  "Snoeyink, U. Axen. SODA 2000, pp. 918-926.\n\n"
  "The filter takes as an input the underlying mesh (port 0, a\n"
  "vtkPolyData for 2D meshes or a vtkUnstructuredGrid for 3D meshes)\n"
  "with an attached scalar field (identified by FieldId, with\n"
  "setFieldId()) and an input Reeb graph computed on that mesh (port 1).\n"
  "The outputs is vtkReebGraph object describing either a join or split\n"
  "tree.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkReebGraphToJoinSplitTreeFilter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkFiltersReebGraph.vtkReebGraphToJoinSplitTreeFilter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkReebGraphToJoinSplitTreeFilter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkReebGraphToJoinSplitTreeFilter_StaticNew()
{
  return vtkReebGraphToJoinSplitTreeFilter::New();
}

PyObject *PyvtkReebGraphToJoinSplitTreeFilter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkReebGraphToJoinSplitTreeFilter_Type, PyvtkReebGraphToJoinSplitTreeFilter_Methods,
    "vtkReebGraphToJoinSplitTreeFilter",
 &PyvtkReebGraphToJoinSplitTreeFilter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDirectedGraphAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkReebGraphToJoinSplitTreeFilter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkReebGraphToJoinSplitTreeFilter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkReebGraphToJoinSplitTreeFilter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkReebGraphToJoinSplitTreeFilter", o) != 0)
  {
    Py_DECREF(o);
  }

}

