// python wrapper for ttkMergeTreeDistanceMatrix
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkMergeTreeDistanceMatrix.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkMergeTreeDistanceMatrix(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkMergeTreeDistanceMatrix_ClassNew(); }


static PyObject *
PyttkMergeTreeDistanceMatrix_SetEpsilon1UseFarthestSaddle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon1UseFarthestSaddle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon1UseFarthestSaddle(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetEpsilon1UseFarthestSaddle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_GetEpsilon1UseFarthestSaddle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilon1UseFarthestSaddle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEpsilon1UseFarthestSaddle() :
      op->ttkMergeTreeDistanceMatrix::GetEpsilon1UseFarthestSaddle());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetEpsilonTree1_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilonTree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilonTree1(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetEpsilonTree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeDistanceMatrix_SetEpsilonTree1_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilonTree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->SetEpsilonTree1() :
      op->ttkMergeTreeDistanceMatrix::SetEpsilonTree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeDistanceMatrix_SetEpsilonTree1(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyttkMergeTreeDistanceMatrix_SetEpsilonTree1_s1(self, args);
    case 0:
      return PyttkMergeTreeDistanceMatrix_SetEpsilonTree1_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetEpsilonTree1");
  return nullptr;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetEpsilon2Tree1_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon2Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon2Tree1(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetEpsilon2Tree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeDistanceMatrix_SetEpsilon2Tree1_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon2Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->SetEpsilon2Tree1() :
      op->ttkMergeTreeDistanceMatrix::SetEpsilon2Tree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeDistanceMatrix_SetEpsilon2Tree1(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyttkMergeTreeDistanceMatrix_SetEpsilon2Tree1_s1(self, args);
    case 0:
      return PyttkMergeTreeDistanceMatrix_SetEpsilon2Tree1_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetEpsilon2Tree1");
  return nullptr;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetEpsilon3Tree1_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon3Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon3Tree1(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetEpsilon3Tree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeDistanceMatrix_SetEpsilon3Tree1_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon3Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->SetEpsilon3Tree1() :
      op->ttkMergeTreeDistanceMatrix::SetEpsilon3Tree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeDistanceMatrix_SetEpsilon3Tree1(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyttkMergeTreeDistanceMatrix_SetEpsilon3Tree1_s1(self, args);
    case 0:
      return PyttkMergeTreeDistanceMatrix_SetEpsilon3Tree1_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetEpsilon3Tree1");
  return nullptr;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetPersistenceThreshold_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPersistenceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPersistenceThreshold(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetPersistenceThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeDistanceMatrix_SetPersistenceThreshold_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPersistenceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->SetPersistenceThreshold() :
      op->ttkMergeTreeDistanceMatrix::SetPersistenceThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeDistanceMatrix_SetPersistenceThreshold(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyttkMergeTreeDistanceMatrix_SetPersistenceThreshold_s1(self, args);
    case 0:
      return PyttkMergeTreeDistanceMatrix_SetPersistenceThreshold_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetPersistenceThreshold");
  return nullptr;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetDeleteMultiPersPairs_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeleteMultiPersPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeleteMultiPersPairs(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetDeleteMultiPersPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeDistanceMatrix_SetDeleteMultiPersPairs_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeleteMultiPersPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->SetDeleteMultiPersPairs() :
      op->ttkMergeTreeDistanceMatrix::SetDeleteMultiPersPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeDistanceMatrix_SetDeleteMultiPersPairs(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyttkMergeTreeDistanceMatrix_SetDeleteMultiPersPairs_s1(self, args);
    case 0:
      return PyttkMergeTreeDistanceMatrix_SetDeleteMultiPersPairs_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetDeleteMultiPersPairs");
  return nullptr;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetBranchMetric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBranchMetric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBranchMetric(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetBranchMetric(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetPathMetric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPathMetric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPathMetric(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetPathMetric(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetBackend(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackend");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBackend(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetBackend(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_GetBackend(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBackend");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBackend() :
      op->ttkMergeTreeDistanceMatrix::GetBackend());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetAssignmentSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAssignmentSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAssignmentSolver(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetAssignmentSolver(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_GetAssignmentSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAssignmentSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAssignmentSolver() :
      op->ttkMergeTreeDistanceMatrix::GetAssignmentSolver());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetBranchDecomposition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBranchDecomposition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBranchDecomposition(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetBranchDecomposition(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_GetBranchDecomposition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBranchDecomposition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBranchDecomposition() :
      op->ttkMergeTreeDistanceMatrix::GetBranchDecomposition());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetNormalizedWasserstein(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNormalizedWasserstein");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNormalizedWasserstein(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetNormalizedWasserstein(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_GetNormalizedWasserstein(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNormalizedWasserstein");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNormalizedWasserstein() :
      op->ttkMergeTreeDistanceMatrix::GetNormalizedWasserstein());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetKeepSubtree(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKeepSubtree");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKeepSubtree(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetKeepSubtree(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_GetKeepSubtree(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetKeepSubtree");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetKeepSubtree() :
      op->ttkMergeTreeDistanceMatrix::GetKeepSubtree());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetDistanceSquaredRoot(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDistanceSquaredRoot");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDistanceSquaredRoot(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetDistanceSquaredRoot(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_GetDistanceSquaredRoot(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDistanceSquaredRoot");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDistanceSquaredRoot() :
      op->ttkMergeTreeDistanceMatrix::GetDistanceSquaredRoot());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetUseFieldDataParameters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseFieldDataParameters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseFieldDataParameters(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetUseFieldDataParameters(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_GetUseFieldDataParameters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseFieldDataParameters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseFieldDataParameters() :
      op->ttkMergeTreeDistanceMatrix::GetUseFieldDataParameters());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SetmixtureCoefficient_(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetmixtureCoefficient_");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetmixtureCoefficient_(temp0);
    }
    else
    {
      op->ttkMergeTreeDistanceMatrix::SetmixtureCoefficient_(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_GetmixtureCoefficient_(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetmixtureCoefficient_");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetmixtureCoefficient_() :
      op->ttkMergeTreeDistanceMatrix::GetmixtureCoefficient_());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkMergeTreeDistanceMatrix::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkMergeTreeDistanceMatrix::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkMergeTreeDistanceMatrix *tempr = ttkMergeTreeDistanceMatrix::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkMergeTreeDistanceMatrix *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkMergeTreeDistanceMatrix::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkMergeTreeDistanceMatrix::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeDistanceMatrix_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeDistanceMatrix *op = static_cast<ttkMergeTreeDistanceMatrix *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkMergeTreeDistanceMatrix::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkMergeTreeDistanceMatrix_Methods[] = {
  {"SetEpsilon1UseFarthestSaddle", PyttkMergeTreeDistanceMatrix_SetEpsilon1UseFarthestSaddle, METH_VARARGS,
   "SetEpsilon1UseFarthestSaddle(self, epsilon1UseFarthestSaddle:bool)\n     -> None\nC++: void SetEpsilon1UseFarthestSaddle(\n    bool epsilon1UseFarthestSaddle)\n\nAutomatically generate getters and setters of filter parameters\nvia vtkMacros.\n"},
  {"GetEpsilon1UseFarthestSaddle", PyttkMergeTreeDistanceMatrix_GetEpsilon1UseFarthestSaddle, METH_VARARGS,
   "GetEpsilon1UseFarthestSaddle(self) -> bool\nC++: bool GetEpsilon1UseFarthestSaddle()\n\n"},
  {"SetEpsilonTree1", PyttkMergeTreeDistanceMatrix_SetEpsilonTree1, METH_VARARGS,
   "SetEpsilonTree1(self, epsilonTree1:float) -> None\nC++: void SetEpsilonTree1(double epsilonTree1)\nSetEpsilonTree1(self) -> float\nC++: double SetEpsilonTree1()\n\n"},
  {"SetEpsilon2Tree1", PyttkMergeTreeDistanceMatrix_SetEpsilon2Tree1, METH_VARARGS,
   "SetEpsilon2Tree1(self, epsilon2Tree1:float) -> None\nC++: void SetEpsilon2Tree1(double epsilon2Tree1)\nSetEpsilon2Tree1(self) -> float\nC++: double SetEpsilon2Tree1()\n\n"},
  {"SetEpsilon3Tree1", PyttkMergeTreeDistanceMatrix_SetEpsilon3Tree1, METH_VARARGS,
   "SetEpsilon3Tree1(self, epsilon3Tree1:float) -> None\nC++: void SetEpsilon3Tree1(double epsilon3Tree1)\nSetEpsilon3Tree1(self) -> float\nC++: double SetEpsilon3Tree1()\n\n"},
  {"SetPersistenceThreshold", PyttkMergeTreeDistanceMatrix_SetPersistenceThreshold, METH_VARARGS,
   "SetPersistenceThreshold(self, persistenceThreshold:float) -> None\nC++: void SetPersistenceThreshold(double persistenceThreshold)\nSetPersistenceThreshold(self) -> float\nC++: double SetPersistenceThreshold()\n\n"},
  {"SetDeleteMultiPersPairs", PyttkMergeTreeDistanceMatrix_SetDeleteMultiPersPairs, METH_VARARGS,
   "SetDeleteMultiPersPairs(self, doDelete:bool) -> None\nC++: void SetDeleteMultiPersPairs(bool doDelete)\nSetDeleteMultiPersPairs(self) -> bool\nC++: bool SetDeleteMultiPersPairs()\n\n"},
  {"SetBranchMetric", PyttkMergeTreeDistanceMatrix_SetBranchMetric, METH_VARARGS,
   "SetBranchMetric(self, m:int) -> None\nC++: void SetBranchMetric(int m)\n\n"},
  {"SetPathMetric", PyttkMergeTreeDistanceMatrix_SetPathMetric, METH_VARARGS,
   "SetPathMetric(self, m:int) -> None\nC++: void SetPathMetric(int m)\n\n"},
  {"SetBackend", PyttkMergeTreeDistanceMatrix_SetBackend, METH_VARARGS,
   "SetBackend(self, newBackend:int) -> None\nC++: void SetBackend(int newBackend)\n\n"},
  {"GetBackend", PyttkMergeTreeDistanceMatrix_GetBackend, METH_VARARGS,
   "GetBackend(self) -> int\nC++: virtual int GetBackend()\n\n"},
  {"SetAssignmentSolver", PyttkMergeTreeDistanceMatrix_SetAssignmentSolver, METH_VARARGS,
   "SetAssignmentSolver(self, assignmentSolver:int) -> None\nC++: void SetAssignmentSolver(int assignmentSolver)\n\n"},
  {"GetAssignmentSolver", PyttkMergeTreeDistanceMatrix_GetAssignmentSolver, METH_VARARGS,
   "GetAssignmentSolver(self) -> int\nC++: int GetAssignmentSolver()\n\n"},
  {"SetBranchDecomposition", PyttkMergeTreeDistanceMatrix_SetBranchDecomposition, METH_VARARGS,
   "SetBranchDecomposition(self, branchDecomposition:bool) -> None\nC++: void SetBranchDecomposition(bool branchDecomposition)\n\n"},
  {"GetBranchDecomposition", PyttkMergeTreeDistanceMatrix_GetBranchDecomposition, METH_VARARGS,
   "GetBranchDecomposition(self) -> int\nC++: int GetBranchDecomposition()\n\n"},
  {"SetNormalizedWasserstein", PyttkMergeTreeDistanceMatrix_SetNormalizedWasserstein, METH_VARARGS,
   "SetNormalizedWasserstein(self, normalizedWasserstein:bool) -> None\nC++: void SetNormalizedWasserstein(bool normalizedWasserstein)\n\n"},
  {"GetNormalizedWasserstein", PyttkMergeTreeDistanceMatrix_GetNormalizedWasserstein, METH_VARARGS,
   "GetNormalizedWasserstein(self) -> int\nC++: int GetNormalizedWasserstein()\n\n"},
  {"SetKeepSubtree", PyttkMergeTreeDistanceMatrix_SetKeepSubtree, METH_VARARGS,
   "SetKeepSubtree(self, keepSubtree:bool) -> None\nC++: void SetKeepSubtree(bool keepSubtree)\n\n"},
  {"GetKeepSubtree", PyttkMergeTreeDistanceMatrix_GetKeepSubtree, METH_VARARGS,
   "GetKeepSubtree(self) -> int\nC++: int GetKeepSubtree()\n\n"},
  {"SetDistanceSquaredRoot", PyttkMergeTreeDistanceMatrix_SetDistanceSquaredRoot, METH_VARARGS,
   "SetDistanceSquaredRoot(self, distanceSquaredRoot:bool) -> None\nC++: void SetDistanceSquaredRoot(bool distanceSquaredRoot)\n\n"},
  {"GetDistanceSquaredRoot", PyttkMergeTreeDistanceMatrix_GetDistanceSquaredRoot, METH_VARARGS,
   "GetDistanceSquaredRoot(self) -> int\nC++: int GetDistanceSquaredRoot()\n\n"},
  {"SetUseFieldDataParameters", PyttkMergeTreeDistanceMatrix_SetUseFieldDataParameters, METH_VARARGS,
   "SetUseFieldDataParameters(self, _arg:bool) -> None\nC++: virtual void SetUseFieldDataParameters(bool _arg)\n\n"},
  {"GetUseFieldDataParameters", PyttkMergeTreeDistanceMatrix_GetUseFieldDataParameters, METH_VARARGS,
   "GetUseFieldDataParameters(self) -> bool\nC++: virtual bool GetUseFieldDataParameters()\n\n"},
  {"SetmixtureCoefficient_", PyttkMergeTreeDistanceMatrix_SetmixtureCoefficient_, METH_VARARGS,
   "SetmixtureCoefficient_(self, _arg:float) -> None\nC++: virtual void SetmixtureCoefficient_(double _arg)\n\n"},
  {"GetmixtureCoefficient_", PyttkMergeTreeDistanceMatrix_GetmixtureCoefficient_, METH_VARARGS,
   "GetmixtureCoefficient_(self) -> float\nC++: virtual double GetmixtureCoefficient_()\n\n"},
  {"IsTypeOf", PyttkMergeTreeDistanceMatrix_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkMergeTreeDistanceMatrix_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkMergeTreeDistanceMatrix_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkMergeTreeDistanceMatrix\nC++: static ttkMergeTreeDistanceMatrix *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkMergeTreeDistanceMatrix_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkMergeTreeDistanceMatrix\nC++: ttkMergeTreeDistanceMatrix *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkMergeTreeDistanceMatrix_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkMergeTreeDistanceMatrix_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkMergeTreeDistanceMatrix_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("epsilon1_use_farthest_saddle"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeDistanceMatrix_GetEpsilon1UseFarthestSaddle(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetEpsilon1UseFarthestSaddle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetEpsilon1UseFarthestSaddle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilon1UseFarthestSaddle/SetEpsilon1UseFarthestSaddle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon_tree1"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetEpsilonTree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetEpsilonTree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEpsilonTree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon2_tree1"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetEpsilon2Tree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetEpsilon2Tree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEpsilon2Tree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon3_tree1"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetEpsilon3Tree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetEpsilon3Tree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEpsilon3Tree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("persistence_threshold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetPersistenceThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetPersistenceThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPersistenceThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("delete_multi_pers_pairs"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetDeleteMultiPersPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetDeleteMultiPersPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDeleteMultiPersPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("branch_metric"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetBranchMetric(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetBranchMetric(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBranchMetric\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("path_metric"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetPathMetric(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetPathMetric(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPathMetric\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("backend"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeDistanceMatrix_GetBackend(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetBackend(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetBackend(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBackend/SetBackend\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("assignment_solver"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeDistanceMatrix_GetAssignmentSolver(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetAssignmentSolver(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetAssignmentSolver(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAssignmentSolver/SetAssignmentSolver\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("branch_decomposition"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetBranchDecomposition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetBranchDecomposition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBranchDecomposition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("normalized_wasserstein"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetNormalizedWasserstein(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetNormalizedWasserstein(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNormalizedWasserstein\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("keep_subtree"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetKeepSubtree(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetKeepSubtree(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetKeepSubtree\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("distance_squared_root"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetDistanceSquaredRoot(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetDistanceSquaredRoot(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDistanceSquaredRoot\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_field_data_parameters"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeDistanceMatrix_GetUseFieldDataParameters(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeDistanceMatrix_SetUseFieldDataParameters(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeDistanceMatrix_SetUseFieldDataParameters(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseFieldDataParameters/SetUseFieldDataParameters\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("branch_decomposition"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeDistanceMatrix_GetBranchDecomposition(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetBranchDecomposition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("normalized_wasserstein"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeDistanceMatrix_GetNormalizedWasserstein(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNormalizedWasserstein\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("keep_subtree"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeDistanceMatrix_GetKeepSubtree(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetKeepSubtree\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("distance_squared_root"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeDistanceMatrix_GetDistanceSquaredRoot(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDistanceSquaredRoot\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkMergeTreeDistanceMatrix_Doc =
  "ttkMergeTreeDistanceMatrix - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Mathieu Pont <mathieu.pont@lip6.fr>\\date 2021.\n\n"
  "TTK VTK-filter that wraps the ttk::MergeTreeDistanceMatrix module.\n\n"
  "This VTK filter uses the ttk::MergeTreeDistanceMatrix module to\n"
  "compute the distance matrix of a group of merge trees.\n\n"
  "\\param Input vtkMultiBlockDataset\n"
  "\\param Output vtkTable\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(),\n"
  "GetOutputDataObject()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa ttk::MergeTreeDistanceMatrix\n"
  "\\sa ttkAlgorithm\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeClustering/\"\n"
  "  >Merge Tree Clustering example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreePGA/\">Me\n"
  "  rge Tree Principal Geodesic Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceDiagramPGA/\"\n"
  "  > Persistence Diagram Principal Geodesic Analysis example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkMergeTreeDistanceMatrix_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkMergeTreeDistanceMatrix.ttkMergeTreeDistanceMatrix", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkMergeTreeDistanceMatrix_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkMergeTreeDistanceMatrix_StaticNew()
{
  return ttkMergeTreeDistanceMatrix::New();
}

PyObject *PyttkMergeTreeDistanceMatrix_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkMergeTreeDistanceMatrix_Type, PyttkMergeTreeDistanceMatrix_Methods,
    "ttkMergeTreeDistanceMatrix",
 &PyttkMergeTreeDistanceMatrix_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkMergeTreeDistanceMatrix_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkMergeTreeDistanceMatrix(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkMergeTreeDistanceMatrix_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkMergeTreeDistanceMatrix", o) != 0)
  {
    Py_DECREF(o);
  }

}

