/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// SecretProjectionApplyConfiguration represents a declarative configuration of the SecretProjection type for use
// with apply.
//
// Adapts a secret into a projected volume.
//
// The contents of the target Secret's Data field will be presented in a
// projected volume as files using the keys in the Data field as the file names.
// Note that this is identical to a secret volume source without the default
// mode.
type SecretProjectionApplyConfiguration struct {
	LocalObjectReferenceApplyConfiguration `json:",inline"`
	// items if unspecified, each key-value pair in the Data field of the referenced
	// Secret will be projected into the volume as a file whose name is the
	// key and content is the value. If specified, the listed keys will be
	// projected into the specified paths, and unlisted keys will not be
	// present. If a key is specified which is not present in the Secret,
	// the volume setup will error unless it is marked optional. Paths must be
	// relative and may not contain the '..' path or start with '..'.
	Items []KeyToPathApplyConfiguration `json:"items,omitempty"`
	// optional field specify whether the Secret or its key must be defined
	Optional *bool `json:"optional,omitempty"`
}

// SecretProjectionApplyConfiguration constructs a declarative configuration of the SecretProjection type for use with
// apply.
func SecretProjection() *SecretProjectionApplyConfiguration {
	return &SecretProjectionApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *SecretProjectionApplyConfiguration) WithName(value string) *SecretProjectionApplyConfiguration {
	b.LocalObjectReferenceApplyConfiguration.Name = &value
	return b
}

// WithItems adds the given value to the Items field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Items field.
func (b *SecretProjectionApplyConfiguration) WithItems(values ...*KeyToPathApplyConfiguration) *SecretProjectionApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithItems")
		}
		b.Items = append(b.Items, *values[i])
	}
	return b
}

// WithOptional sets the Optional field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Optional field is set to the value of the last call.
func (b *SecretProjectionApplyConfiguration) WithOptional(value bool) *SecretProjectionApplyConfiguration {
	b.Optional = &value
	return b
}
