/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkFastMarchingBaseImageFilter.h"
#include "itkFastMarchingImageFilterBase.h"

// Additional include files
#include "itkFastMarchingThresholdStoppingCriterion.h"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
FastMarchingBaseImageFilter::FastMarchingBaseImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
FastMarchingBaseImageFilter::~FastMarchingBaseImageFilter() = default;



//
// ToString
//
std::string FastMarchingBaseImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::FastMarchingBaseImageFilter\n";
  out << "  TrialPoints: ";
  out << "[ ";
  for (unsigned int i = 0; i + 1 < m_TrialPoints.size(); ++i)
    {
    this->ToStringHelper(out, this->m_TrialPoints[i]);
    out << ", ";
    }
  if ( !this->m_TrialPoints.empty() ) out << this->m_TrialPoints.back() << ' ';
  out << "]";  out << std::endl;
  out << "  NormalizationFactor: ";
  this->ToStringHelper(out, this->m_NormalizationFactor);
  out << std::endl;
  out << "  StoppingValue: ";
  this->ToStringHelper(out, this->m_StoppingValue);
  out << std::endl;
  out << "  TopologyCheck: ";
  this->ToStringHelper(out, this->m_TopologyCheck);
  out << std::endl;
  out << "  InitialTrialValues: ";
  this->ToStringHelper(out, this->m_InitialTrialValues);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image FastMarchingBaseImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image FastMarchingBaseImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  // Define output image type
  using OutputImageType = itk::Image< float, InputImageType::ImageDimension >;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType = itk::FastMarchingImageFilterBase<InputImageType,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  using NodePairType = typename FilterType::NodePairType;
  using NodeType = typename FilterType::NodeType;
  using NodePairContainerType = typename FilterType::NodePairContainerType;

  typename NodePairContainerType::Pointer trialNodes = NodePairContainerType::New();
  trialNodes->reserve( m_TrialPoints.size() );

  for (unsigned int i = 0; i < m_TrialPoints.size(); ++i)
    {
    NodePairType node;

    //note: Node type is really an itk Index type
    NodeType index = sitkSTLVectorToITK<NodeType>( m_TrialPoints[i] );
    node.SetNode( index );
    node.SetValue( 0.0 );
    if (m_TrialPoints[i].size() > NodeType::Dimension)
      node.SetValue(m_TrialPoints[i][NodeType::Dimension]);
    trialNodes->push_back( node );
    }
  filter->SetTrialPoints( trialNodes );
  filter->SetNormalizationFactor ( this->m_NormalizationFactor );
  using CriterionType = itk::FastMarchingThresholdStoppingCriterion< InputImageType, OutputImageType >;
  typename CriterionType::Pointer criterion = CriterionType::New();
  criterion->SetThreshold( m_StoppingValue );
filter->SetStoppingCriterion( criterion );
  filter->SetTopologyCheck ( typename FilterType::TopologyCheckEnum ( int( this->m_TopologyCheck ) ) );
  auto nodes = filter->GetTrialPoints();
  for( size_t i = 0; i < nodes->Size(); ++i )
  {
   if ( i < m_InitialTrialValues.size()) nodes->ElementAt(i).SetValue(m_InitialTrialValues[i]);
  }




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image FastMarchingBase ( const Image& image1, std::vector< std::vector<unsigned int> > trialPoints, double normalizationFactor, double stoppingValue, FastMarchingBaseImageFilter::TopologyCheckType topologyCheck, std::vector<double> initialTrialValues )
{
  FastMarchingBaseImageFilter filter;
  filter.SetTrialPoints( trialPoints );  filter.SetNormalizationFactor( normalizationFactor );  filter.SetStoppingValue( stoppingValue );  filter.SetTopologyCheck( topologyCheck );  filter.SetInitialTrialValues( initialTrialValues );
  return filter.Execute ( image1 );
}


}
