/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkHMaximaImageFilter_h
#define sitkHMaximaImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class HMaximaImageFilter
\brief Suppress local maxima whose height above the baseline is less than h.

HMaximaImageFilter suppresses local maxima that are less than h intensity units above the (local) background. This has the effect of smoothing over the "high" parts of the noise in the image without smoothing over large changes in intensity (region boundaries). See the HMinimaImageFilter to suppress the local minima whose depth is less than h intensity units below the (local) background.

If the output of HMaximaImageFilter is subtracted from the original image, the significant "peaks" in the image can be identified. This is what the HConvexImageFilter provides.

This filter uses the ReconstructionByDilationImageFilter . It provides its own input as the "mask" input to the geodesic dilation. The "marker" image for the geodesic dilation is the input image minus the height parameter h.

Geodesic morphology and the H-Maxima algorithm is described in Chapter 6 of Pierre Soille's book "Morphological Image Analysis:
Principles and Applications", Second Edition, Springer, 2003.

The height parameter is set using SetHeight.

\see ReconstructionByDilationImageFilter , HMinimaImageFilter , HConvexImageFilter 


\see MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter
\sa itk::simple::HMaxima for the procedural interface
\sa itk::HMaximaImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT HMaximaImageFilter : public ImageFilter {
    public:
      using Self = HMaximaImageFilter;

      /** Destructor */
      virtual ~HMaximaImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      HMaximaImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Set/Get the height that a local maximum must be above the local background (local contrast) in order to survive the processing. Local maxima below this value are replaced with an estimate of the local background.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetHeight ( double Height ) { this->m_Height = Height; return *this; }

      /**
       * Set/Get the height that a local maximum must be above the local background (local contrast) in order to survive the processing. Local maxima below this value are replaced with an estimate of the local background.
       */
      double GetHeight() const { return this->m_Height; }

      /** Name of this class */
      std::string GetName() const { return std::string ("HMaximaImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_Height{2.0};


    };

    /**\
     * \brief Suppress local maxima whose height above the baseline is less than h.
     *
     * This function directly calls the execute method of HMaximaImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::HMaximaImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image HMaxima ( const Image& image1, double height = 2.0 );

     /** @} */
}
#endif
