// content/browser/tracing/trace_report/trace_report.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_TRACING_TRACE_REPORT_TRACE_REPORT_MOJOM_H_
#define CONTENT_BROWSER_TRACING_TRACE_REPORT_TRACE_REPORT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/browser/tracing/trace_report/trace_report.mojom-features.h"  // IWYU pragma: export
#include "content/browser/tracing/trace_report/trace_report.mojom-shared.h"  // IWYU pragma: export
#include "content/browser/tracing/trace_report/trace_report.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/browser/tracing/trace_report/trace_report_database.h"
#include "content/browser/tracing/trace_report/trace_report_mojom_traits.h"




namespace trace_report::mojom {

class TraceReportHandlerFactoryProxy;

template <typename ImplRefTraits>
class TraceReportHandlerFactoryStub;

class TraceReportHandlerFactoryRequestValidator;


class TraceReportHandlerFactory
    : public TraceReportHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TraceReportHandlerFactoryInterfaceBase;
  using Proxy_ = TraceReportHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = TraceReportHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = TraceReportHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TraceReportHandlerFactory() = default;

  
  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAllTraceReportsMinVersion = 0,
    kDeleteSingleTraceMinVersion = 0,
    kDeleteAllTracesMinVersion = 0,
    kUserUploadSingleTraceMinVersion = 0,
    kDownloadTraceMinVersion = 0,
    kGetAllPresetScenariosMinVersion = 0,
    kGetAllFieldScenariosMinVersion = 0,
    kGetEnabledScenariosMinVersion = 0,
    kSetEnabledScenariosMinVersion = 0,
    kGetPrivacyFilterEnabledMinVersion = 0,
    kSetPrivacyFilterEnabledMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetAllTraceReports_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteSingleTrace_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteAllTraces_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UserUploadSingleTrace_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DownloadTrace_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllPresetScenarios_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllFieldScenarios_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetEnabledScenarios_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetEnabledScenarios_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPrivacyFilterEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPrivacyFilterEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;


  using GetAllTraceReportsCallback = base::OnceCallback<void(std::vector<ClientTraceReportPtr>)>;
  
  virtual void GetAllTraceReports(GetAllTraceReportsCallback callback) = 0;


  using DeleteSingleTraceCallback = base::OnceCallback<void(bool)>;
  
  virtual void DeleteSingleTrace(const ::base::Token& uuid, DeleteSingleTraceCallback callback) = 0;


  using DeleteAllTracesCallback = base::OnceCallback<void(bool)>;
  
  virtual void DeleteAllTraces(DeleteAllTracesCallback callback) = 0;


  using UserUploadSingleTraceCallback = base::OnceCallback<void(bool)>;
  
  virtual void UserUploadSingleTrace(const ::base::Token& uuid, UserUploadSingleTraceCallback callback) = 0;


  using DownloadTraceCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>)>;
  
  virtual void DownloadTrace(const ::base::Token& uuid, DownloadTraceCallback callback) = 0;


  using GetAllPresetScenariosCallback = base::OnceCallback<void(std::vector<ScenarioPtr>)>;
  
  virtual void GetAllPresetScenarios(GetAllPresetScenariosCallback callback) = 0;


  using GetAllFieldScenariosCallback = base::OnceCallback<void(std::vector<ScenarioPtr>)>;
  
  virtual void GetAllFieldScenarios(GetAllFieldScenariosCallback callback) = 0;


  using GetEnabledScenariosCallback = base::OnceCallback<void(const std::vector<std::string>&)>;
  
  virtual void GetEnabledScenarios(GetEnabledScenariosCallback callback) = 0;


  using SetEnabledScenariosCallback = base::OnceCallback<void(bool)>;
  
  virtual void SetEnabledScenarios(const std::vector<std::string>& new_config, SetEnabledScenariosCallback callback) = 0;


  using GetPrivacyFilterEnabledCallback = base::OnceCallback<void(bool)>;
  
  virtual void GetPrivacyFilterEnabled(GetPrivacyFilterEnabledCallback callback) = 0;

  
  virtual void SetPrivacyFilterEnabled(bool enable) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;
};



class  TraceReportHandlerFactoryProxy
    : public TraceReportHandlerFactory {
 public:
  using InterfaceType = TraceReportHandlerFactory;

  explicit TraceReportHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetAllTraceReports(GetAllTraceReportsCallback callback) final;
  
  void DeleteSingleTrace(const ::base::Token& uuid, DeleteSingleTraceCallback callback) final;
  
  void DeleteAllTraces(DeleteAllTracesCallback callback) final;
  
  void UserUploadSingleTrace(const ::base::Token& uuid, UserUploadSingleTraceCallback callback) final;
  
  void DownloadTrace(const ::base::Token& uuid, DownloadTraceCallback callback) final;
  
  void GetAllPresetScenarios(GetAllPresetScenariosCallback callback) final;
  
  void GetAllFieldScenarios(GetAllFieldScenariosCallback callback) final;
  
  void GetEnabledScenarios(GetEnabledScenariosCallback callback) final;
  
  void SetEnabledScenarios(const std::vector<std::string>& new_config, SetEnabledScenariosCallback callback) final;
  
  void GetPrivacyFilterEnabled(GetPrivacyFilterEnabledCallback callback) final;
  
  void SetPrivacyFilterEnabled(bool enable) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  TraceReportHandlerFactoryStubDispatch {
 public:
  static bool Accept(TraceReportHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TraceReportHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TraceReportHandlerFactory>>
class TraceReportHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TraceReportHandlerFactoryStub() = default;
  ~TraceReportHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TraceReportHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TraceReportHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TraceReportHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  Scenario {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Scenario, T>::value>;
  using DataView = ScenarioDataView;
  using Data_ = internal::Scenario_Data;

  template <typename... Args>
  static ScenarioPtr New(Args&&... args) {
    return ScenarioPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScenarioPtr From(const U& u) {
    return mojo::TypeConverter<ScenarioPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Scenario>::Convert(*this);
  }


  Scenario();

  explicit Scenario(
      const std::string& scenario_name);


  ~Scenario();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScenarioPtr>
  ScenarioPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Scenario::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Scenario::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Scenario::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Scenario::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Scenario::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Scenario_UnserializedMessageContext<
            UserType, Scenario::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Scenario::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Scenario::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Scenario_UnserializedMessageContext<
            UserType, Scenario::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Scenario::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string scenario_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Scenario::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Scenario::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Scenario::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Scenario::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  ClientTraceReport {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClientTraceReport, T>::value>;
  using DataView = ClientTraceReportDataView;
  using Data_ = internal::ClientTraceReport_Data;

  template <typename... Args>
  static ClientTraceReportPtr New(Args&&... args) {
    return ClientTraceReportPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClientTraceReportPtr From(const U& u) {
    return mojo::TypeConverter<ClientTraceReportPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClientTraceReport>::Convert(*this);
  }


  ClientTraceReport();

  ClientTraceReport(
      const ::base::Token& uuid,
      ::base::Time creation_time,
      const std::string& scenario_name,
      const std::string& upload_rule_name,
      std::optional<int32_t> upload_rule_value,
      int64_t total_size,
      ::content::ReportUploadState upload_state,
      ::base::Time upload_time,
      ::content::SkipUploadReason skip_reason,
      bool has_trace_content);


  ~ClientTraceReport();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClientTraceReportPtr>
  ClientTraceReportPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClientTraceReport::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClientTraceReport::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClientTraceReport::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClientTraceReport::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClientTraceReport::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClientTraceReport_UnserializedMessageContext<
            UserType, ClientTraceReport::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClientTraceReport::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClientTraceReport::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClientTraceReport_UnserializedMessageContext<
            UserType, ClientTraceReport::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClientTraceReport::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Token uuid;
  
  ::base::Time creation_time;
  
  std::string scenario_name;
  
  std::string upload_rule_name;
  
  std::optional<int32_t> upload_rule_value;
  
  int64_t total_size;
  
  ::content::ReportUploadState upload_state;
  
  ::base::Time upload_time;
  
  ::content::SkipUploadReason skip_reason;
  
  bool has_trace_content;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClientTraceReport::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClientTraceReport::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClientTraceReport::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClientTraceReport::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
ClientTraceReportPtr ClientTraceReport::Clone() const {
  return New(
      mojo::Clone(uuid),
      mojo::Clone(creation_time),
      mojo::Clone(scenario_name),
      mojo::Clone(upload_rule_name),
      mojo::Clone(upload_rule_value),
      mojo::Clone(total_size),
      mojo::Clone(upload_state),
      mojo::Clone(upload_time),
      mojo::Clone(skip_reason),
      mojo::Clone(has_trace_content)
  );
}

template <typename T, ClientTraceReport::EnableIfSame<T>*>
bool ClientTraceReport::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  if (!mojo::Equals(this->creation_time, other_struct.creation_time))
    return false;
  if (!mojo::Equals(this->scenario_name, other_struct.scenario_name))
    return false;
  if (!mojo::Equals(this->upload_rule_name, other_struct.upload_rule_name))
    return false;
  if (!mojo::Equals(this->upload_rule_value, other_struct.upload_rule_value))
    return false;
  if (!mojo::Equals(this->total_size, other_struct.total_size))
    return false;
  if (!mojo::Equals(this->upload_state, other_struct.upload_state))
    return false;
  if (!mojo::Equals(this->upload_time, other_struct.upload_time))
    return false;
  if (!mojo::Equals(this->skip_reason, other_struct.skip_reason))
    return false;
  if (!mojo::Equals(this->has_trace_content, other_struct.has_trace_content))
    return false;
  return true;
}

template <typename T, ClientTraceReport::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.uuid < rhs.uuid)
    return true;
  if (rhs.uuid < lhs.uuid)
    return false;
  if (lhs.creation_time < rhs.creation_time)
    return true;
  if (rhs.creation_time < lhs.creation_time)
    return false;
  if (lhs.scenario_name < rhs.scenario_name)
    return true;
  if (rhs.scenario_name < lhs.scenario_name)
    return false;
  if (lhs.upload_rule_name < rhs.upload_rule_name)
    return true;
  if (rhs.upload_rule_name < lhs.upload_rule_name)
    return false;
  if (lhs.upload_rule_value < rhs.upload_rule_value)
    return true;
  if (rhs.upload_rule_value < lhs.upload_rule_value)
    return false;
  if (lhs.total_size < rhs.total_size)
    return true;
  if (rhs.total_size < lhs.total_size)
    return false;
  if (lhs.upload_state < rhs.upload_state)
    return true;
  if (rhs.upload_state < lhs.upload_state)
    return false;
  if (lhs.upload_time < rhs.upload_time)
    return true;
  if (rhs.upload_time < lhs.upload_time)
    return false;
  if (lhs.skip_reason < rhs.skip_reason)
    return true;
  if (rhs.skip_reason < lhs.skip_reason)
    return false;
  if (lhs.has_trace_content < rhs.has_trace_content)
    return true;
  if (rhs.has_trace_content < lhs.has_trace_content)
    return false;
  return false;
}
template <typename StructPtrType>
ScenarioPtr Scenario::Clone() const {
  return New(
      mojo::Clone(scenario_name)
  );
}

template <typename T, Scenario::EnableIfSame<T>*>
bool Scenario::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scenario_name, other_struct.scenario_name))
    return false;
  return true;
}

template <typename T, Scenario::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scenario_name < rhs.scenario_name)
    return true;
  if (rhs.scenario_name < lhs.scenario_name)
    return false;
  return false;
}


}  // trace_report::mojom

namespace mojo {


template <>
struct  StructTraits<::trace_report::mojom::ClientTraceReport::DataView,
                                         ::trace_report::mojom::ClientTraceReportPtr> {
  static bool IsNull(const ::trace_report::mojom::ClientTraceReportPtr& input) { return !input; }
  static void SetToNull(::trace_report::mojom::ClientTraceReportPtr* output) { output->reset(); }

  static const decltype(::trace_report::mojom::ClientTraceReport::uuid)& uuid(
      const ::trace_report::mojom::ClientTraceReportPtr& input) {
    return input->uuid;
  }

  static const decltype(::trace_report::mojom::ClientTraceReport::creation_time)& creation_time(
      const ::trace_report::mojom::ClientTraceReportPtr& input) {
    return input->creation_time;
  }

  static const decltype(::trace_report::mojom::ClientTraceReport::scenario_name)& scenario_name(
      const ::trace_report::mojom::ClientTraceReportPtr& input) {
    return input->scenario_name;
  }

  static const decltype(::trace_report::mojom::ClientTraceReport::upload_rule_name)& upload_rule_name(
      const ::trace_report::mojom::ClientTraceReportPtr& input) {
    return input->upload_rule_name;
  }

  static decltype(::trace_report::mojom::ClientTraceReport::upload_rule_value) upload_rule_value(
      const ::trace_report::mojom::ClientTraceReportPtr& input) {
    return input->upload_rule_value;
  }

  static decltype(::trace_report::mojom::ClientTraceReport::total_size) total_size(
      const ::trace_report::mojom::ClientTraceReportPtr& input) {
    return input->total_size;
  }

  static decltype(::trace_report::mojom::ClientTraceReport::upload_state) upload_state(
      const ::trace_report::mojom::ClientTraceReportPtr& input) {
    return input->upload_state;
  }

  static const decltype(::trace_report::mojom::ClientTraceReport::upload_time)& upload_time(
      const ::trace_report::mojom::ClientTraceReportPtr& input) {
    return input->upload_time;
  }

  static decltype(::trace_report::mojom::ClientTraceReport::skip_reason) skip_reason(
      const ::trace_report::mojom::ClientTraceReportPtr& input) {
    return input->skip_reason;
  }

  static decltype(::trace_report::mojom::ClientTraceReport::has_trace_content) has_trace_content(
      const ::trace_report::mojom::ClientTraceReportPtr& input) {
    return input->has_trace_content;
  }

  static bool Read(::trace_report::mojom::ClientTraceReport::DataView input, ::trace_report::mojom::ClientTraceReportPtr* output);
};


template <>
struct  StructTraits<::trace_report::mojom::Scenario::DataView,
                                         ::trace_report::mojom::ScenarioPtr> {
  static bool IsNull(const ::trace_report::mojom::ScenarioPtr& input) { return !input; }
  static void SetToNull(::trace_report::mojom::ScenarioPtr* output) { output->reset(); }

  static const decltype(::trace_report::mojom::Scenario::scenario_name)& scenario_name(
      const ::trace_report::mojom::ScenarioPtr& input) {
    return input->scenario_name;
  }

  static bool Read(::trace_report::mojom::Scenario::DataView input, ::trace_report::mojom::ScenarioPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_BROWSER_TRACING_TRACE_REPORT_TRACE_REPORT_MOJOM_H_