// third_party/blink/public/mojom/loader/resource_load_info.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_SHARED_INTERNAL_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "services/network/public/mojom/ip_address.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared-internal.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared-internal.h"
#include "services/network/public/mojom/network_param.mojom-shared-internal.h"
#include "services/network/public/mojom/url_loader.mojom-shared-internal.h"
#include "services/network/public/mojom/fetch_api.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace blink {
namespace mojom {
namespace internal {
class CommonNetworkInfo_Data;
class RedirectInfo_Data;
class ResourceLoadInfo_Data;

struct ResourceType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 19:
      case 20:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) CommonNetworkInfo_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CommonNetworkInfo_Data));
      new (data()) CommonNetworkInfo_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CommonNetworkInfo_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CommonNetworkInfo_Data>(index_);
    }
    CommonNetworkInfo_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t network_accessed : 1;
  uint8_t always_access_network : 1;
  uint8_t pad1_[7];
  mojo::internal::Pointer<::network::mojom::internal::IPEndPoint_Data> remote_endpoint;

 private:
  CommonNetworkInfo_Data();
  ~CommonNetworkInfo_Data() = delete;
};
static_assert(sizeof(CommonNetworkInfo_Data) == 24,
              "Bad sizeof(CommonNetworkInfo_Data)");
// Used by CommonNetworkInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CommonNetworkInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CommonNetworkInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CommonNetworkInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    CommonNetworkInfo_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CommonNetworkInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) RedirectInfo_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RedirectInfo_Data));
      new (data()) RedirectInfo_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RedirectInfo_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RedirectInfo_Data>(index_);
    }
    RedirectInfo_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> origin_of_new_url;
  mojo::internal::Pointer<internal::CommonNetworkInfo_Data> network_info;

 private:
  RedirectInfo_Data();
  ~RedirectInfo_Data() = delete;
};
static_assert(sizeof(RedirectInfo_Data) == 24,
              "Bad sizeof(RedirectInfo_Data)");
// Used by RedirectInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct RedirectInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  RedirectInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~RedirectInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    RedirectInfo_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    RedirectInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) ResourceLoadInfo_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ResourceLoadInfo_Data));
      new (data()) ResourceLoadInfo_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ResourceLoadInfo_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ResourceLoadInfo_Data>(index_);
    }
    ResourceLoadInfo_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t request_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> final_url;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> referrer;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> original_url;
  mojo::internal::Pointer<mojo::internal::String_Data> method;
  int32_t request_destination;
  int32_t request_priority;
  mojo::internal::Pointer<mojo::internal::String_Data> mime_type;
  uint8_t was_cached : 1;
  uint8_t pad8_[3];
  int32_t net_error;
  mojo::internal::Pointer<internal::CommonNetworkInfo_Data> network_info;
  mojo::internal::Pointer<::network::mojom::internal::LoadTimingInfo_Data> load_timing_info;
  int64_t raw_body_bytes;
  int64_t total_received_bytes;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::RedirectInfo_Data>>> redirect_info_chain;

 private:
  ResourceLoadInfo_Data();
  ~ResourceLoadInfo_Data() = delete;
};
static_assert(sizeof(ResourceLoadInfo_Data) == 112,
              "Bad sizeof(ResourceLoadInfo_Data)");
// Used by ResourceLoadInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ResourceLoadInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ResourceLoadInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ResourceLoadInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    ResourceLoadInfo_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ResourceLoadInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_SHARED_INTERNAL_H_