// third_party/blink/public/mojom/image_downloader/image_downloader.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_IMAGE_DOWNLOADER_IMAGE_DOWNLOADER_MOJOM_PARAMS_DATA_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_IMAGE_DOWNLOADER_IMAGE_DOWNLOADER_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace blink {
namespace mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) ImageDownloader_DownloadImage_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ImageDownloader_DownloadImage_Params_Data));
      new (data()) ImageDownloader_DownloadImage_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ImageDownloader_DownloadImage_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ImageDownloader_DownloadImage_Params_Data>(index_);
    }
    ImageDownloader_DownloadImage_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  uint8_t is_favicon : 1;
  uint8_t bypass_cache : 1;
  uint8_t pad2_[3];
  uint32_t preferred_size;
  uint32_t max_bitmap_size;
  uint8_t padfinal_[4];

 private:
  ImageDownloader_DownloadImage_Params_Data();
  ~ImageDownloader_DownloadImage_Params_Data() = delete;
};
static_assert(sizeof(ImageDownloader_DownloadImage_Params_Data) == 32,
              "Bad sizeof(ImageDownloader_DownloadImage_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) ImageDownloader_DownloadImage_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ImageDownloader_DownloadImage_ResponseParams_Data));
      new (data()) ImageDownloader_DownloadImage_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ImageDownloader_DownloadImage_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ImageDownloader_DownloadImage_ResponseParams_Data>(index_);
    }
    ImageDownloader_DownloadImage_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t http_status_code;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::skia::mojom::internal::Bitmap_Data>>> images;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::gfx::mojom::internal::Size_Data>>> original_image_sizes;

 private:
  ImageDownloader_DownloadImage_ResponseParams_Data();
  ~ImageDownloader_DownloadImage_ResponseParams_Data() = delete;
};
static_assert(sizeof(ImageDownloader_DownloadImage_ResponseParams_Data) == 32,
              "Bad sizeof(ImageDownloader_DownloadImage_ResponseParams_Data)");

}  // namespace internal


class ImageDownloader_DownloadImage_ParamsDataView {
 public:
  ImageDownloader_DownloadImage_ParamsDataView() {}

  ImageDownloader_DownloadImage_ParamsDataView(
      internal::ImageDownloader_DownloadImage_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  bool is_favicon() const {
    return data_->is_favicon;
  }
  uint32_t preferred_size() const {
    return data_->preferred_size;
  }
  uint32_t max_bitmap_size() const {
    return data_->max_bitmap_size;
  }
  bool bypass_cache() const {
    return data_->bypass_cache;
  }
 private:
  internal::ImageDownloader_DownloadImage_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ImageDownloader_DownloadImage_ResponseParamsDataView {
 public:
  ImageDownloader_DownloadImage_ResponseParamsDataView() {}

  ImageDownloader_DownloadImage_ResponseParamsDataView(
      internal::ImageDownloader_DownloadImage_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t http_status_code() const {
    return data_->http_status_code;
  }
  inline void GetImagesDataView(
      mojo::ArrayDataView<::skia::mojom::BitmapDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadImages(UserType* output) {
    
    auto* pointer = data_->images.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::skia::mojom::BitmapDataView>>(
        pointer, output, context_);
  }
  inline void GetOriginalImageSizesDataView(
      mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOriginalImageSizes(UserType* output) {
    
    auto* pointer = data_->original_image_sizes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        pointer, output, context_);
  }
 private:
  internal::ImageDownloader_DownloadImage_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void ImageDownloader_DownloadImage_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}


inline void ImageDownloader_DownloadImage_ResponseParamsDataView::GetImagesDataView(
    mojo::ArrayDataView<::skia::mojom::BitmapDataView>* output) {
  auto pointer = data_->images.Get();
  *output = mojo::ArrayDataView<::skia::mojom::BitmapDataView>(pointer, context_);
}
inline void ImageDownloader_DownloadImage_ResponseParamsDataView::GetOriginalImageSizesDataView(
    mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output) {
  auto pointer = data_->original_image_sizes.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::SizeDataView>(pointer, context_);
}

}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_IMAGE_DOWNLOADER_IMAGE_DOWNLOADER_MOJOM_PARAMS_DATA_H_