// media/mojo/mojom/key_system_support.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_H_
#define MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/mojo/mojom/key_system_support.mojom-shared.h"
#include "media/mojo/mojom/key_system_support.mojom-forward.h"
#include "media/mojo/mojom/content_decryption_module.mojom.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media {
namespace mojom {

class KeySystemSupportProxy;

template <typename ImplRefTraits>
class KeySystemSupportStub;

class KeySystemSupportRequestValidator;
class KeySystemSupportResponseValidator;


class  KeySystemSupport
    : public KeySystemSupportInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = KeySystemSupportInterfaceBase;
  using Proxy_ = KeySystemSupportProxy;

  template <typename ImplRefTraits>
  using Stub_ = KeySystemSupportStub<ImplRefTraits>;

  using RequestValidator_ = KeySystemSupportRequestValidator;
  using ResponseValidator_ = KeySystemSupportResponseValidator;
  enum MethodMinVersions : uint32_t {
    kIsKeySystemSupportedMinVersion = 0,
  };
  virtual ~KeySystemSupport() {}

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool IsKeySystemSupported(const std::string& key_system, bool* out_is_supported, KeySystemCapabilityPtr* out_key_system_capability);

  using IsKeySystemSupportedCallback = base::OnceCallback<void(bool, KeySystemCapabilityPtr)>;
  
  virtual void IsKeySystemSupported(const std::string& key_system, IsKeySystemSupportedCallback callback) = 0;
};



class  KeySystemSupportProxy
    : public KeySystemSupport {
 public:
  using InterfaceType = KeySystemSupport;

  explicit KeySystemSupportProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool IsKeySystemSupported(const std::string& key_system, bool* out_is_supported, KeySystemCapabilityPtr* out_key_system_capability) final;
  
  void IsKeySystemSupported(const std::string& key_system, IsKeySystemSupportedCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  KeySystemSupportStubDispatch {
 public:
  static bool Accept(KeySystemSupport* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      KeySystemSupport* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<KeySystemSupport>>
class KeySystemSupportStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  KeySystemSupportStub() {}
  ~KeySystemSupportStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return KeySystemSupportStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return KeySystemSupportStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  KeySystemSupportRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  KeySystemSupportResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  KeySystemCapability {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<KeySystemCapability, T>::value>;
  using DataView = KeySystemCapabilityDataView;
  using Data_ = internal::KeySystemCapability_Data;

  template <typename... Args>
  static KeySystemCapabilityPtr New(Args&&... args) {
    return KeySystemCapabilityPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static KeySystemCapabilityPtr From(const U& u) {
    return mojo::TypeConverter<KeySystemCapabilityPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, KeySystemCapability>::Convert(*this);
  }


  KeySystemCapability();

  KeySystemCapability(
      std::vector<::media::VideoCodec> video_codecs,
      bool supports_vp9_profile2,
      std::vector<::media::EncryptionScheme> encryption_schemes,
      std::vector<::media::VideoCodec> hw_secure_video_codecs,
      std::vector<::media::EncryptionScheme> hw_secure_encryption_schemes,
      std::vector<::media::CdmSessionType> session_types);

  ~KeySystemCapability();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = KeySystemCapabilityPtr>
  KeySystemCapabilityPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, KeySystemCapability::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        KeySystemCapability::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        KeySystemCapability::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::KeySystemCapability_UnserializedMessageContext<
            UserType, KeySystemCapability::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<KeySystemCapability::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return KeySystemCapability::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::KeySystemCapability_UnserializedMessageContext<
            UserType, KeySystemCapability::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<KeySystemCapability::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<::media::VideoCodec> video_codecs;
  
  bool supports_vp9_profile2;
  
  std::vector<::media::EncryptionScheme> encryption_schemes;
  
  std::vector<::media::VideoCodec> hw_secure_video_codecs;
  
  std::vector<::media::EncryptionScheme> hw_secure_encryption_schemes;
  
  std::vector<::media::CdmSessionType> session_types;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, KeySystemCapability::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, KeySystemCapability::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, KeySystemCapability::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, KeySystemCapability::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
KeySystemCapabilityPtr KeySystemCapability::Clone() const {
  return New(
      mojo::Clone(video_codecs),
      mojo::Clone(supports_vp9_profile2),
      mojo::Clone(encryption_schemes),
      mojo::Clone(hw_secure_video_codecs),
      mojo::Clone(hw_secure_encryption_schemes),
      mojo::Clone(session_types)
  );
}

template <typename T, KeySystemCapability::EnableIfSame<T>*>
bool KeySystemCapability::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->video_codecs, other_struct.video_codecs))
    return false;
  if (!mojo::Equals(this->supports_vp9_profile2, other_struct.supports_vp9_profile2))
    return false;
  if (!mojo::Equals(this->encryption_schemes, other_struct.encryption_schemes))
    return false;
  if (!mojo::Equals(this->hw_secure_video_codecs, other_struct.hw_secure_video_codecs))
    return false;
  if (!mojo::Equals(this->hw_secure_encryption_schemes, other_struct.hw_secure_encryption_schemes))
    return false;
  if (!mojo::Equals(this->session_types, other_struct.session_types))
    return false;
  return true;
}

template <typename T, KeySystemCapability::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.video_codecs, rhs.video_codecs))
    return true;
  if (std::less<>{}(rhs.video_codecs, lhs.video_codecs))
    return false;
  if (std::less<>{}(lhs.supports_vp9_profile2, rhs.supports_vp9_profile2))
    return true;
  if (std::less<>{}(rhs.supports_vp9_profile2, lhs.supports_vp9_profile2))
    return false;
  if (std::less<>{}(lhs.encryption_schemes, rhs.encryption_schemes))
    return true;
  if (std::less<>{}(rhs.encryption_schemes, lhs.encryption_schemes))
    return false;
  if (std::less<>{}(lhs.hw_secure_video_codecs, rhs.hw_secure_video_codecs))
    return true;
  if (std::less<>{}(rhs.hw_secure_video_codecs, lhs.hw_secure_video_codecs))
    return false;
  if (std::less<>{}(lhs.hw_secure_encryption_schemes, rhs.hw_secure_encryption_schemes))
    return true;
  if (std::less<>{}(rhs.hw_secure_encryption_schemes, lhs.hw_secure_encryption_schemes))
    return false;
  if (std::less<>{}(lhs.session_types, rhs.session_types))
    return true;
  if (std::less<>{}(rhs.session_types, lhs.session_types))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace media

namespace mojo {


template <>
struct  StructTraits<::media::mojom::KeySystemCapability::DataView,
                                         ::media::mojom::KeySystemCapabilityPtr> {
  static bool IsNull(const ::media::mojom::KeySystemCapabilityPtr& input) { return !input; }
  static void SetToNull(::media::mojom::KeySystemCapabilityPtr* output) { output->reset(); }

  static const decltype(::media::mojom::KeySystemCapability::video_codecs)& video_codecs(
      const ::media::mojom::KeySystemCapabilityPtr& input) {
    return input->video_codecs;
  }

  static decltype(::media::mojom::KeySystemCapability::supports_vp9_profile2) supports_vp9_profile2(
      const ::media::mojom::KeySystemCapabilityPtr& input) {
    return input->supports_vp9_profile2;
  }

  static const decltype(::media::mojom::KeySystemCapability::encryption_schemes)& encryption_schemes(
      const ::media::mojom::KeySystemCapabilityPtr& input) {
    return input->encryption_schemes;
  }

  static const decltype(::media::mojom::KeySystemCapability::hw_secure_video_codecs)& hw_secure_video_codecs(
      const ::media::mojom::KeySystemCapabilityPtr& input) {
    return input->hw_secure_video_codecs;
  }

  static const decltype(::media::mojom::KeySystemCapability::hw_secure_encryption_schemes)& hw_secure_encryption_schemes(
      const ::media::mojom::KeySystemCapabilityPtr& input) {
    return input->hw_secure_encryption_schemes;
  }

  static const decltype(::media::mojom::KeySystemCapability::session_types)& session_types(
      const ::media::mojom::KeySystemCapabilityPtr& input) {
    return input->session_types;
  }

  static bool Read(::media::mojom::KeySystemCapability::DataView input, ::media::mojom::KeySystemCapabilityPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_H_