// components/variations/variations.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/variations/variations.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "components/variations/variations.mojom-params-data.h"
namespace variations {
namespace mojom {

std::ostream& operator<<(std::ostream& os, GoogleWebVisibility value) {
  switch(value) {
    case GoogleWebVisibility::ANY:
      return os << "GoogleWebVisibility::ANY";
    case GoogleWebVisibility::FIRST_PARTY:
      return os << "GoogleWebVisibility::FIRST_PARTY";
    default:
      return os << "Unknown GoogleWebVisibility value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool VariationsHeaders_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VariationsHeaders_Data* object = static_cast<const VariationsHeaders_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers_map, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams headers_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::variations::mojom::internal::GoogleWebVisibility_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->headers_map, validation_context,
                                         &headers_map_validate_params)) {
    return false;
  }

  return true;
}

VariationsHeaders_Data::VariationsHeaders_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace variations