#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkAdditionalFieldReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCSVWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFileSeriesReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFileSeriesWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMetaReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParallelSerialWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVDReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStringReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStringWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXMLCollectionReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXMLPVDWriter_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkPVVTKExtensionsIOCoreCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkAdditionalFieldReader_Init(csi);
  vtkCSVWriter_Init(csi);
  vtkFileSeriesReader_Init(csi);
  vtkFileSeriesWriter_Init(csi);
  vtkMetaReader_Init(csi);
  vtkParallelSerialWriter_Init(csi);
  vtkPVDReader_Init(csi);
  vtkStringReader_Init(csi);
  vtkStringWriter_Init(csi);
  vtkXMLCollectionReader_Init(csi);
  vtkXMLPVDWriter_Init(csi);
}
