// python wrapper for vtkPVDynamicInitializerPluginInterface
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkPVDynamicInitializerPluginInterface.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVDynamicInitializerPluginInterface(PyObject *dict); }

static PyObject *
PyvtkPVDynamicInitializerPluginInterface_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVDynamicInitializerPluginInterface *op = static_cast<vtkPVDynamicInitializerPluginInterface *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    op->Initialize();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVDynamicInitializerPluginInterface_Methods[] = {
  {"Initialize", PyvtkPVDynamicInitializerPluginInterface_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: virtual void Initialize()\n\nThe following method will be run as the plugin is loaded, before\nserver-manager or python plugin interfaces are run.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVDynamicInitializerPluginInterface_GetSets[] = {
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static const char *PyvtkPVDynamicInitializerPluginInterface_Doc =
  "vtkPVDynamicInitializerPluginInterface -\nvtkPVDynamicInitializerPluginInterface defines the interface needed\nto be implemented by a plugin that needs to dynamically initialize\nits internal state.\n\n"
  "It can be used to avoid depending on static initializers, to\n"
  "initialize third-party libraries, etc.\n\n";

static PyObject *
PyvtkPVDynamicInitializerPluginInterface_New(PyTypeObject * /*unused*/, PyObject * /*unused*/, PyObject * /*unused*/)
{
  PyErr_SetString(PyExc_TypeError,
                  "this class cannot be instantiated");

  return nullptr;
}

static void PyvtkPVDynamicInitializerPluginInterface_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkPVDynamicInitializerPluginInterface *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkPVDynamicInitializerPluginInterface_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVDynamicInitializerPluginInterface_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVDynamicInitializerPluginInterface", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkPVDynamicInitializerPluginInterface_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkPVDynamicInitializerPluginInterface_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkPVDynamicInitializerPluginInterface_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkPVDynamicInitializerPluginInterface_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

#ifndef DECLARED_PyvtkPVDynamicInitializerPluginInterface_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVDynamicInitializerPluginInterface_TypeNew(); }
#define DECLARED_PyvtkPVDynamicInitializerPluginInterface_TypeNew
#endif

PyObject *PyvtkPVDynamicInitializerPluginInterface_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkPVDynamicInitializerPluginInterface_Type,
    PyvtkPVDynamicInitializerPluginInterface_Methods,
    PyvtkPVDynamicInitializerPluginInterface_GetSets,
    nullptr,
    nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVDynamicInitializerPluginInterface(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVDynamicInitializerPluginInterface_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkPVDynamicInitializerPluginInterface", o) != 0)
  {
    Py_DECREF(o);
  }

}

